// Code generated by smithy-go-codegen DO NOT EDIT.

package apprunner

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apprunner/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update an existing App Runner VPC Ingress Connection resource. The VPC Ingress
// Connection must be in one of the following states to be updated:
//   - AVAILABLE
//   - FAILED_CREATION
//   - FAILED_UPDATE
func (c *Client) UpdateVpcIngressConnection(ctx context.Context, params *UpdateVpcIngressConnectionInput, optFns ...func(*Options)) (*UpdateVpcIngressConnectionOutput, error) {
	if params == nil {
		params = &UpdateVpcIngressConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateVpcIngressConnection", params, optFns, c.addOperationUpdateVpcIngressConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateVpcIngressConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateVpcIngressConnectionInput struct {

	// Specifications for the customer’s Amazon VPC and the related Amazon Web
	// Services PrivateLink VPC endpoint that are used to update the VPC Ingress
	// Connection resource.
	//
	// This member is required.
	IngressVpcConfiguration *types.IngressVpcConfiguration

	// The Amazon Resource Name (Arn) for the App Runner VPC Ingress Connection
	// resource that you want to update.
	//
	// This member is required.
	VpcIngressConnectionArn *string

	noSmithyDocumentSerde
}

type UpdateVpcIngressConnectionOutput struct {

	// A description of the App Runner VPC Ingress Connection resource that's updated
	// by this request.
	//
	// This member is required.
	VpcIngressConnection *types.VpcIngressConnection

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateVpcIngressConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateVpcIngressConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateVpcIngressConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateVpcIngressConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateVpcIngressConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateVpcIngressConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateVpcIngressConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateVpcIngressConnection",
	}
}
