// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakermetrics

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/sagemakermetrics/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpBatchPutMetrics struct {
}

func (*validateOpBatchPutMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchPutMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchPutMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchPutMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpBatchPutMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchPutMetrics{}, middleware.After)
}

func validateRawMetricData(v *types.RawMetricData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RawMetricData"}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if v.Timestamp == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Timestamp"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRawMetricDataList(v []types.RawMetricData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RawMetricDataList"}
	for i := range v {
		if err := validateRawMetricData(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchPutMetricsInput(v *BatchPutMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchPutMetricsInput"}
	if v.TrialComponentName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrialComponentName"))
	}
	if v.MetricData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricData"))
	} else if v.MetricData != nil {
		if err := validateRawMetricDataList(v.MetricData); err != nil {
			invalidParams.AddNested("MetricData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
