// Code generated by smithy-go-codegen DO NOT EDIT.

package proton

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/proton/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get detailed data for the service sync blocker summary.
func (c *Client) GetServiceSyncBlockerSummary(ctx context.Context, params *GetServiceSyncBlockerSummaryInput, optFns ...func(*Options)) (*GetServiceSyncBlockerSummaryOutput, error) {
	if params == nil {
		params = &GetServiceSyncBlockerSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetServiceSyncBlockerSummary", params, optFns, c.addOperationGetServiceSyncBlockerSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetServiceSyncBlockerSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetServiceSyncBlockerSummaryInput struct {

	// The name of the service that you want to get the service sync blocker summary
	// for. If given only the service name, all instances are blocked.
	//
	// This member is required.
	ServiceName *string

	// The name of the service instance that you want to get the service sync blocker
	// summary for. If given bothe the instance name and the service name, only the
	// instance is blocked.
	ServiceInstanceName *string

	noSmithyDocumentSerde
}

type GetServiceSyncBlockerSummaryOutput struct {

	// The detailed data of the requested service sync blocker summary.
	ServiceSyncBlockerSummary *types.ServiceSyncBlockerSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetServiceSyncBlockerSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetServiceSyncBlockerSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetServiceSyncBlockerSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetServiceSyncBlockerSummaryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetServiceSyncBlockerSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetServiceSyncBlockerSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "proton",
		OperationName: "GetServiceSyncBlockerSummary",
	}
}
