// Code generated by smithy-go-codegen DO NOT EDIT.

package migrationhubstrategy

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpGetApplicationComponentDetails struct {
}

func (*awsRestjson1_serializeOpGetApplicationComponentDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplicationComponentDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationComponentDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-applicationcomponent-details/{applicationComponentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationComponentDetailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationComponentDetailsInput(v *GetApplicationComponentDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationComponentId == nil || len(*v.ApplicationComponentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationComponentId must not be empty")}
	}
	if v.ApplicationComponentId != nil {
		if err := encoder.SetURI("applicationComponentId").String(*v.ApplicationComponentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApplicationComponentStrategies struct {
}

func (*awsRestjson1_serializeOpGetApplicationComponentStrategies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplicationComponentStrategies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationComponentStrategiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-applicationcomponent-strategies/{applicationComponentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationComponentStrategiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationComponentStrategiesInput(v *GetApplicationComponentStrategiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationComponentId == nil || len(*v.ApplicationComponentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationComponentId must not be empty")}
	}
	if v.ApplicationComponentId != nil {
		if err := encoder.SetURI("applicationComponentId").String(*v.ApplicationComponentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAssessment struct {
}

func (*awsRestjson1_serializeOpGetAssessment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAssessment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAssessmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-assessment/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAssessmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAssessmentInput(v *GetAssessmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetImportFileTask struct {
}

func (*awsRestjson1_serializeOpGetImportFileTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetImportFileTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetImportFileTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-import-file-task/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetImportFileTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetImportFileTaskInput(v *GetImportFileTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLatestAssessmentId struct {
}

func (*awsRestjson1_serializeOpGetLatestAssessmentId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLatestAssessmentId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLatestAssessmentIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-latest-assessment-id")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLatestAssessmentIdInput(v *GetLatestAssessmentIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetPortfolioPreferences struct {
}

func (*awsRestjson1_serializeOpGetPortfolioPreferences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPortfolioPreferences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPortfolioPreferencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-portfolio-preferences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPortfolioPreferencesInput(v *GetPortfolioPreferencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetPortfolioSummary struct {
}

func (*awsRestjson1_serializeOpGetPortfolioSummary) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPortfolioSummary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPortfolioSummaryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-portfolio-summary")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPortfolioSummaryInput(v *GetPortfolioSummaryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetRecommendationReportDetails struct {
}

func (*awsRestjson1_serializeOpGetRecommendationReportDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRecommendationReportDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRecommendationReportDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-recommendation-report-details/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRecommendationReportDetailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRecommendationReportDetailsInput(v *GetRecommendationReportDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetServerDetails struct {
}

func (*awsRestjson1_serializeOpGetServerDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetServerDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetServerDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-server-details/{serverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetServerDetailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetServerDetailsInput(v *GetServerDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ServerId == nil || len(*v.ServerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member serverId must not be empty")}
	}
	if v.ServerId != nil {
		if err := encoder.SetURI("serverId").String(*v.ServerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetServerStrategies struct {
}

func (*awsRestjson1_serializeOpGetServerStrategies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetServerStrategies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetServerStrategiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/get-server-strategies/{serverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetServerStrategiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetServerStrategiesInput(v *GetServerStrategiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ServerId == nil || len(*v.ServerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member serverId must not be empty")}
	}
	if v.ServerId != nil {
		if err := encoder.SetURI("serverId").String(*v.ServerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListApplicationComponents struct {
}

func (*awsRestjson1_serializeOpListApplicationComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListApplicationComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-applicationcomponents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListApplicationComponentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListApplicationComponentsInput(v *ListApplicationComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListApplicationComponentsInput(v *ListApplicationComponentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApplicationComponentCriteria) > 0 {
		ok := object.Key("applicationComponentCriteria")
		ok.String(string(v.ApplicationComponentCriteria))
	}

	if v.FilterValue != nil {
		ok := object.Key("filterValue")
		ok.String(*v.FilterValue)
	}

	if v.GroupIdFilter != nil {
		ok := object.Key("groupIdFilter")
		if err := awsRestjson1_serializeDocumentGroupIds(v.GroupIdFilter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Sort) > 0 {
		ok := object.Key("sort")
		ok.String(string(v.Sort))
	}

	return nil
}

type awsRestjson1_serializeOpListCollectors struct {
}

func (*awsRestjson1_serializeOpListCollectors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCollectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-collectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCollectorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCollectorsInput(v *ListCollectorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListImportFileTask struct {
}

func (*awsRestjson1_serializeOpListImportFileTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListImportFileTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListImportFileTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-import-file-task")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListImportFileTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListImportFileTaskInput(v *ListImportFileTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListServers struct {
}

func (*awsRestjson1_serializeOpListServers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListServers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListServersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-servers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListServersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListServersInput(v *ListServersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListServersInput(v *ListServersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterValue != nil {
		ok := object.Key("filterValue")
		ok.String(*v.FilterValue)
	}

	if v.GroupIdFilter != nil {
		ok := object.Key("groupIdFilter")
		if err := awsRestjson1_serializeDocumentGroupIds(v.GroupIdFilter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ServerCriteria) > 0 {
		ok := object.Key("serverCriteria")
		ok.String(string(v.ServerCriteria))
	}

	if len(v.Sort) > 0 {
		ok := object.Key("sort")
		ok.String(string(v.Sort))
	}

	return nil
}

type awsRestjson1_serializeOpPutPortfolioPreferences struct {
}

func (*awsRestjson1_serializeOpPutPortfolioPreferences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutPortfolioPreferences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPortfolioPreferencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/put-portfolio-preferences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutPortfolioPreferencesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutPortfolioPreferencesInput(v *PutPortfolioPreferencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutPortfolioPreferencesInput(v *PutPortfolioPreferencesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApplicationMode) > 0 {
		ok := object.Key("applicationMode")
		ok.String(string(v.ApplicationMode))
	}

	if v.ApplicationPreferences != nil {
		ok := object.Key("applicationPreferences")
		if err := awsRestjson1_serializeDocumentApplicationPreferences(v.ApplicationPreferences, ok); err != nil {
			return err
		}
	}

	if v.DatabasePreferences != nil {
		ok := object.Key("databasePreferences")
		if err := awsRestjson1_serializeDocumentDatabasePreferences(v.DatabasePreferences, ok); err != nil {
			return err
		}
	}

	if v.PrioritizeBusinessGoals != nil {
		ok := object.Key("prioritizeBusinessGoals")
		if err := awsRestjson1_serializeDocumentPrioritizeBusinessGoals(v.PrioritizeBusinessGoals, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartAssessment struct {
}

func (*awsRestjson1_serializeOpStartAssessment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAssessment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAssessmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/start-assessment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAssessmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAssessmentInput(v *StartAssessmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAssessmentInput(v *StartAssessmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssessmentTargets != nil {
		ok := object.Key("assessmentTargets")
		if err := awsRestjson1_serializeDocumentAssessmentTargets(v.AssessmentTargets, ok); err != nil {
			return err
		}
	}

	if v.S3bucketForAnalysisData != nil {
		ok := object.Key("s3bucketForAnalysisData")
		ok.String(*v.S3bucketForAnalysisData)
	}

	if v.S3bucketForReportData != nil {
		ok := object.Key("s3bucketForReportData")
		ok.String(*v.S3bucketForReportData)
	}

	return nil
}

type awsRestjson1_serializeOpStartImportFileTask struct {
}

func (*awsRestjson1_serializeOpStartImportFileTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartImportFileTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartImportFileTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/start-import-file-task")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartImportFileTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartImportFileTaskInput(v *StartImportFileTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartImportFileTaskInput(v *StartImportFileTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataSourceType) > 0 {
		ok := object.Key("dataSourceType")
		ok.String(string(v.DataSourceType))
	}

	if v.GroupId != nil {
		ok := object.Key("groupId")
		if err := awsRestjson1_serializeDocumentGroupIds(v.GroupId, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		ok.String(*v.S3Bucket)
	}

	if v.S3bucketForReportData != nil {
		ok := object.Key("s3bucketForReportData")
		ok.String(*v.S3bucketForReportData)
	}

	if v.S3key != nil {
		ok := object.Key("s3key")
		ok.String(*v.S3key)
	}

	return nil
}

type awsRestjson1_serializeOpStartRecommendationReportGeneration struct {
}

func (*awsRestjson1_serializeOpStartRecommendationReportGeneration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartRecommendationReportGeneration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartRecommendationReportGenerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/start-recommendation-report-generation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartRecommendationReportGenerationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartRecommendationReportGenerationInput(v *StartRecommendationReportGenerationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartRecommendationReportGenerationInput(v *StartRecommendationReportGenerationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupIdFilter != nil {
		ok := object.Key("groupIdFilter")
		if err := awsRestjson1_serializeDocumentGroupIds(v.GroupIdFilter, ok); err != nil {
			return err
		}
	}

	if len(v.OutputFormat) > 0 {
		ok := object.Key("outputFormat")
		ok.String(string(v.OutputFormat))
	}

	return nil
}

type awsRestjson1_serializeOpStopAssessment struct {
}

func (*awsRestjson1_serializeOpStopAssessment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopAssessment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopAssessmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/stop-assessment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopAssessmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopAssessmentInput(v *StopAssessmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopAssessmentInput(v *StopAssessmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssessmentId != nil {
		ok := object.Key("assessmentId")
		ok.String(*v.AssessmentId)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApplicationComponentConfig struct {
}

func (*awsRestjson1_serializeOpUpdateApplicationComponentConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApplicationComponentConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationComponentConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/update-applicationcomponent-config/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApplicationComponentConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApplicationComponentConfigInput(v *UpdateApplicationComponentConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApplicationComponentConfigInput(v *UpdateApplicationComponentConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationComponentId != nil {
		ok := object.Key("applicationComponentId")
		ok.String(*v.ApplicationComponentId)
	}

	if len(v.AppType) > 0 {
		ok := object.Key("appType")
		ok.String(string(v.AppType))
	}

	if v.ConfigureOnly != nil {
		ok := object.Key("configureOnly")
		ok.Boolean(*v.ConfigureOnly)
	}

	if len(v.InclusionStatus) > 0 {
		ok := object.Key("inclusionStatus")
		ok.String(string(v.InclusionStatus))
	}

	if v.SecretsManagerKey != nil {
		ok := object.Key("secretsManagerKey")
		ok.String(*v.SecretsManagerKey)
	}

	if v.SourceCodeList != nil {
		ok := object.Key("sourceCodeList")
		if err := awsRestjson1_serializeDocumentSourceCodeList(v.SourceCodeList, ok); err != nil {
			return err
		}
	}

	if v.StrategyOption != nil {
		ok := object.Key("strategyOption")
		if err := awsRestjson1_serializeDocumentStrategyOption(v.StrategyOption, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateServerConfig struct {
}

func (*awsRestjson1_serializeOpUpdateServerConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateServerConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateServerConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/update-server-config/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateServerConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateServerConfigInput(v *UpdateServerConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateServerConfigInput(v *UpdateServerConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ServerId != nil {
		ok := object.Key("serverId")
		ok.String(*v.ServerId)
	}

	if v.StrategyOption != nil {
		ok := object.Key("strategyOption")
		if err := awsRestjson1_serializeDocumentStrategyOption(v.StrategyOption, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentApplicationPreferences(v *types.ApplicationPreferences, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManagementPreference != nil {
		ok := object.Key("managementPreference")
		if err := awsRestjson1_serializeDocumentManagementPreference(v.ManagementPreference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssessmentTarget(v *types.AssessmentTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Condition) > 0 {
		ok := object.Key("condition")
		ok.String(string(v.Condition))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAssessmentTargetValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssessmentTargets(v []types.AssessmentTarget, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssessmentTarget(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssessmentTargetValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsManagedResources(v *types.AwsManagedResources, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetDestination != nil {
		ok := object.Key("targetDestination")
		if err := awsRestjson1_serializeDocumentAwsManagedTargetDestinations(v.TargetDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsManagedTargetDestinations(v []types.AwsManagedTargetDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentBusinessGoals(v *types.BusinessGoals, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LicenseCostReduction != nil {
		ok := object.Key("licenseCostReduction")
		ok.Integer(*v.LicenseCostReduction)
	}

	if v.ModernizeInfrastructureWithCloudNativeTechnologies != nil {
		ok := object.Key("modernizeInfrastructureWithCloudNativeTechnologies")
		ok.Integer(*v.ModernizeInfrastructureWithCloudNativeTechnologies)
	}

	if v.ReduceOperationalOverheadWithManagedServices != nil {
		ok := object.Key("reduceOperationalOverheadWithManagedServices")
		ok.Integer(*v.ReduceOperationalOverheadWithManagedServices)
	}

	if v.SpeedOfMigration != nil {
		ok := object.Key("speedOfMigration")
		ok.Integer(*v.SpeedOfMigration)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatabaseMigrationPreference(v types.DatabaseMigrationPreference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DatabaseMigrationPreferenceMemberHeterogeneous:
		av := object.Key("heterogeneous")
		if err := awsRestjson1_serializeDocumentHeterogeneous(&uv.Value, av); err != nil {
			return err
		}

	case *types.DatabaseMigrationPreferenceMemberHomogeneous:
		av := object.Key("homogeneous")
		if err := awsRestjson1_serializeDocumentHomogeneous(&uv.Value, av); err != nil {
			return err
		}

	case *types.DatabaseMigrationPreferenceMemberNoPreference:
		av := object.Key("noPreference")
		if err := awsRestjson1_serializeDocumentNoDatabaseMigrationPreference(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDatabasePreferences(v *types.DatabasePreferences, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DatabaseManagementPreference) > 0 {
		ok := object.Key("databaseManagementPreference")
		ok.String(string(v.DatabaseManagementPreference))
	}

	if v.DatabaseMigrationPreference != nil {
		ok := object.Key("databaseMigrationPreference")
		if err := awsRestjson1_serializeDocumentDatabaseMigrationPreference(v.DatabaseMigrationPreference, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGroup(v *types.Group, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentGroupIds(v []types.Group, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHeterogeneous(v *types.Heterogeneous, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetDatabaseEngine != nil {
		ok := object.Key("targetDatabaseEngine")
		if err := awsRestjson1_serializeDocumentHeterogeneousTargetDatabaseEngines(v.TargetDatabaseEngine, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHeterogeneousTargetDatabaseEngines(v []types.HeterogeneousTargetDatabaseEngine, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentHomogeneous(v *types.Homogeneous, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetDatabaseEngine != nil {
		ok := object.Key("targetDatabaseEngine")
		if err := awsRestjson1_serializeDocumentHomogeneousTargetDatabaseEngines(v.TargetDatabaseEngine, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHomogeneousTargetDatabaseEngines(v []types.HomogeneousTargetDatabaseEngine, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentManagementPreference(v types.ManagementPreference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ManagementPreferenceMemberAwsManagedResources:
		av := object.Key("awsManagedResources")
		if err := awsRestjson1_serializeDocumentAwsManagedResources(&uv.Value, av); err != nil {
			return err
		}

	case *types.ManagementPreferenceMemberNoPreference:
		av := object.Key("noPreference")
		if err := awsRestjson1_serializeDocumentNoManagementPreference(&uv.Value, av); err != nil {
			return err
		}

	case *types.ManagementPreferenceMemberSelfManageResources:
		av := object.Key("selfManageResources")
		if err := awsRestjson1_serializeDocumentSelfManageResources(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentNoDatabaseMigrationPreference(v *types.NoDatabaseMigrationPreference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetDatabaseEngine != nil {
		ok := object.Key("targetDatabaseEngine")
		if err := awsRestjson1_serializeDocumentTargetDatabaseEngines(v.TargetDatabaseEngine, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNoManagementPreference(v *types.NoManagementPreference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetDestination != nil {
		ok := object.Key("targetDestination")
		if err := awsRestjson1_serializeDocumentNoPreferenceTargetDestinations(v.TargetDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNoPreferenceTargetDestinations(v []types.NoPreferenceTargetDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentPrioritizeBusinessGoals(v *types.PrioritizeBusinessGoals, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BusinessGoals != nil {
		ok := object.Key("businessGoals")
		if err := awsRestjson1_serializeDocumentBusinessGoals(v.BusinessGoals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSelfManageResources(v *types.SelfManageResources, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetDestination != nil {
		ok := object.Key("targetDestination")
		if err := awsRestjson1_serializeDocumentSelfManageTargetDestinations(v.TargetDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSelfManageTargetDestinations(v []types.SelfManageTargetDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSourceCode(v *types.SourceCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Location != nil {
		ok := object.Key("location")
		ok.String(*v.Location)
	}

	if v.ProjectName != nil {
		ok := object.Key("projectName")
		ok.String(*v.ProjectName)
	}

	if v.SourceVersion != nil {
		ok := object.Key("sourceVersion")
		ok.String(*v.SourceVersion)
	}

	if len(v.VersionControl) > 0 {
		ok := object.Key("versionControl")
		ok.String(string(v.VersionControl))
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceCodeList(v []types.SourceCode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSourceCode(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStrategyOption(v *types.StrategyOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsPreferred != nil {
		ok := object.Key("isPreferred")
		ok.Boolean(*v.IsPreferred)
	}

	if len(v.Strategy) > 0 {
		ok := object.Key("strategy")
		ok.String(string(v.Strategy))
	}

	if len(v.TargetDestination) > 0 {
		ok := object.Key("targetDestination")
		ok.String(string(v.TargetDestination))
	}

	if len(v.ToolName) > 0 {
		ok := object.Key("toolName")
		ok.String(string(v.ToolName))
	}

	return nil
}

func awsRestjson1_serializeDocumentTargetDatabaseEngines(v []types.TargetDatabaseEngine, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}
