// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the password used to protect an export zip archive. The password is not
// required. If you don't supply a password, Amazon Lex generates a zip file that
// is not protected by a password. This is the archive that is available at the
// pre-signed S3 URL provided by the DescribeExport
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
// operation.
func (c *Client) UpdateExport(ctx context.Context, params *UpdateExportInput, optFns ...func(*Options)) (*UpdateExportOutput, error) {
	if params == nil {
		params = &UpdateExportInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateExport", params, optFns, c.addOperationUpdateExportMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateExportOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateExportInput struct {

	// The unique identifier Amazon Lex assigned to the export.
	//
	// This member is required.
	ExportId *string

	// The new password to use to encrypt the export zip archive.
	FilePassword *string

	noSmithyDocumentSerde
}

type UpdateExportOutput struct {

	// The date and time that the export was created.
	CreationDateTime *time.Time

	// The unique identifier Amazon Lex assigned to the export.
	ExportId *string

	// The status of the export. When the status is Completed the export archive is
	// available for download.
	ExportStatus types.ExportStatus

	// The file format used for the files that define the resource. The TSV format is
	// required to export a custom vocabulary only; otherwise use LexJson format.
	FileFormat types.ImportExportFileFormat

	// The date and time that the export was last updated.
	LastUpdatedDateTime *time.Time

	// A description of the type of resource that was exported, either a bot or a bot
	// locale.
	ResourceSpecification *types.ExportResourceSpecification

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateExportMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateExport{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateExport{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateExportValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateExport(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateExport(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lex",
		OperationName: "UpdateExport",
	}
}
