// Code generated by smithy-go-codegen DO NOT EDIT.

package iotroborunner

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotroborunner/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Grants permission to update a worker
func (c *Client) UpdateWorker(ctx context.Context, params *UpdateWorkerInput, optFns ...func(*Options)) (*UpdateWorkerOutput, error) {
	if params == nil {
		params = &UpdateWorkerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateWorker", params, optFns, c.addOperationUpdateWorkerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateWorkerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateWorkerInput struct {

	// Full ARN of the worker.
	//
	// This member is required.
	Id *string

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string

	// JSON blob containing unstructured worker properties that are transient and may
	// change during regular operation.
	AdditionalTransientProperties *string

	// Human friendly name of the resource.
	Name *string

	// Worker orientation measured in units clockwise from north.
	Orientation types.Orientation

	// Supported coordinates for worker position.
	Position types.PositionCoordinates

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *types.VendorProperties

	noSmithyDocumentSerde
}

type UpdateWorkerOutput struct {

	// Full ARN of the worker.
	//
	// This member is required.
	Arn *string

	// Full ARN of the worker fleet.
	//
	// This member is required.
	Fleet *string

	// Filters access by the workers identifier
	//
	// This member is required.
	Id *string

	// Human friendly name of the resource.
	//
	// This member is required.
	Name *string

	// Timestamp at which the resource was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string

	// JSON blob containing unstructured worker properties that are transient and may
	// change during regular operation.
	AdditionalTransientProperties *string

	// Worker orientation measured in units clockwise from north.
	Orientation types.Orientation

	// Supported coordinates for worker position.
	Position types.PositionCoordinates

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *types.VendorProperties

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateWorkerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateWorker{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateWorker{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateWorkerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateWorker(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateWorker(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "iotroborunner",
		OperationName: "UpdateWorker",
	}
}
