// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The related resources of an Audit finding. The following resources can be
// returned from calling this API:
//
// * DEVICE_CERTIFICATE
//
// * CA_CERTIFICATE
//
// *
// IOT_POLICY
//
// * COGNITO_IDENTITY_POOL
//
// * CLIENT_ID
//
// * ACCOUNT_SETTINGS
//
// *
// ROLE_ALIAS
//
// * IAM_ROLE
//
// * ISSUER_CERTIFICATE
//
// This API is similar to
// DescribeAuditFinding's RelatedResources
// (https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html)
// but provides pagination and is not limited to 10 resources. When calling
// DescribeAuditFinding
// (https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html)
// for the intermediate CA revoked for active device certificates check,
// RelatedResources will not be populated. You must use this API,
// ListRelatedResourcesForAuditFinding, to list the certificates.
func (c *Client) ListRelatedResourcesForAuditFinding(ctx context.Context, params *ListRelatedResourcesForAuditFindingInput, optFns ...func(*Options)) (*ListRelatedResourcesForAuditFindingOutput, error) {
	if params == nil {
		params = &ListRelatedResourcesForAuditFindingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRelatedResourcesForAuditFinding", params, optFns, c.addOperationListRelatedResourcesForAuditFindingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRelatedResourcesForAuditFindingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRelatedResourcesForAuditFindingInput struct {

	// The finding Id.
	//
	// This member is required.
	FindingId *string

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results, or null if there
	// are no additional results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRelatedResourcesForAuditFindingOutput struct {

	// A token that can be used to retrieve the next set of results, or null for the
	// first API call.
	NextToken *string

	// The related resources.
	RelatedResources []types.RelatedResource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRelatedResourcesForAuditFindingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRelatedResourcesForAuditFinding{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRelatedResourcesForAuditFinding{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListRelatedResourcesForAuditFindingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRelatedResourcesForAuditFinding(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListRelatedResourcesForAuditFinding(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "execute-api",
		OperationName: "ListRelatedResourcesForAuditFinding",
	}
}
