// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Requests remote access to a fleet instance. Remote access is useful for
// debugging, gathering benchmarking data, or observing activity in real time. To
// remotely access an instance, you need credentials that match the operating
// system of the instance. For a Windows instance, GameLift returns a user name and
// password as strings for use with a Windows Remote Desktop client. For a Linux
// instance, GameLift returns a user name and RSA private key, also as strings, for
// use with an SSH client. The private key must be saved in the proper format to a
// .pem file before using. If you're making this request using the CLI, saving the
// secret can be handled as part of the GetInstanceAccess request, as shown in one
// of the examples for this operation. To request access to a specific instance,
// specify the IDs of both the instance and the fleet it belongs to. You can
// retrieve a fleet's instance IDs by calling DescribeInstances
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html).
// Learn more Remotely Access Fleet Instances
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)Debug
// Fleet Issues
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
// Related actions All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
func (c *Client) GetInstanceAccess(ctx context.Context, params *GetInstanceAccessInput, optFns ...func(*Options)) (*GetInstanceAccessOutput, error) {
	if params == nil {
		params = &GetInstanceAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetInstanceAccess", params, optFns, c.addOperationGetInstanceAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetInstanceAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetInstanceAccessInput struct {

	// A unique identifier for the fleet that contains the instance you want access to.
	// You can use either the fleet ID or ARN value. The fleet can be in any of the
	// following statuses: ACTIVATING, ACTIVE, or ERROR. Fleets with an ERROR status
	// may be accessible for a short time before they are deleted.
	//
	// This member is required.
	FleetId *string

	// A unique identifier for the instance you want to get access to. You can access
	// an instance in any status.
	//
	// This member is required.
	InstanceId *string

	noSmithyDocumentSerde
}

type GetInstanceAccessOutput struct {

	// The connection information for a fleet instance, including IP address and access
	// credentials.
	InstanceAccess *types.InstanceAccess

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetInstanceAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetInstanceAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetInstanceAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetInstanceAccessValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetInstanceAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetInstanceAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "gamelift",
		OperationName: "GetInstanceAccess",
	}
}
