// Code generated by smithy-go-codegen DO NOT EDIT.

package emrcontainers

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/emrcontainers/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelJobRun struct {
}

func (*validateOpCancelJobRun) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelJobRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelJobRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelJobRunInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateJobTemplate struct {
}

func (*validateOpCreateJobTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateJobTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateJobTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateJobTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateManagedEndpoint struct {
}

func (*validateOpCreateManagedEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateManagedEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateManagedEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateManagedEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVirtualCluster struct {
}

func (*validateOpCreateVirtualCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVirtualCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVirtualClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVirtualClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteJobTemplate struct {
}

func (*validateOpDeleteJobTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteJobTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteJobTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteJobTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteManagedEndpoint struct {
}

func (*validateOpDeleteManagedEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteManagedEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteManagedEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteManagedEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVirtualCluster struct {
}

func (*validateOpDeleteVirtualCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVirtualCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVirtualClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVirtualClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeJobRun struct {
}

func (*validateOpDescribeJobRun) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeJobRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeJobRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeJobRunInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeJobTemplate struct {
}

func (*validateOpDescribeJobTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeJobTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeJobTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeJobTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeManagedEndpoint struct {
}

func (*validateOpDescribeManagedEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeManagedEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeManagedEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeManagedEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVirtualCluster struct {
}

func (*validateOpDescribeVirtualCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVirtualCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVirtualClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVirtualClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListJobRuns struct {
}

func (*validateOpListJobRuns) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListJobRuns) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListJobRunsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListJobRunsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListManagedEndpoints struct {
}

func (*validateOpListManagedEndpoints) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListManagedEndpoints) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListManagedEndpointsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListManagedEndpointsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartJobRun struct {
}

func (*validateOpStartJobRun) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartJobRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartJobRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartJobRunInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelJobRunValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelJobRun{}, middleware.After)
}

func addOpCreateJobTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateJobTemplate{}, middleware.After)
}

func addOpCreateManagedEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateManagedEndpoint{}, middleware.After)
}

func addOpCreateVirtualClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVirtualCluster{}, middleware.After)
}

func addOpDeleteJobTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteJobTemplate{}, middleware.After)
}

func addOpDeleteManagedEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteManagedEndpoint{}, middleware.After)
}

func addOpDeleteVirtualClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVirtualCluster{}, middleware.After)
}

func addOpDescribeJobRunValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeJobRun{}, middleware.After)
}

func addOpDescribeJobTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeJobTemplate{}, middleware.After)
}

func addOpDescribeManagedEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeManagedEndpoint{}, middleware.After)
}

func addOpDescribeVirtualClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVirtualCluster{}, middleware.After)
}

func addOpListJobRunsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListJobRuns{}, middleware.After)
}

func addOpListManagedEndpointsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListManagedEndpoints{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartJobRunValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartJobRun{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateCloudWatchMonitoringConfiguration(v *types.CloudWatchMonitoringConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchMonitoringConfiguration"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfiguration(v *types.Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Configuration"}
	if v.Classification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Classification"))
	}
	if v.Configurations != nil {
		if err := validateConfigurationList(v.Configurations); err != nil {
			invalidParams.AddNested("Configurations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfigurationList(v []types.Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConfigurationList"}
	for i := range v {
		if err := validateConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfigurationOverrides(v *types.ConfigurationOverrides) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConfigurationOverrides"}
	if v.ApplicationConfiguration != nil {
		if err := validateConfigurationList(v.ApplicationConfiguration); err != nil {
			invalidParams.AddNested("ApplicationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.MonitoringConfiguration != nil {
		if err := validateMonitoringConfiguration(v.MonitoringConfiguration); err != nil {
			invalidParams.AddNested("MonitoringConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateContainerProvider(v *types.ContainerProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ContainerProvider"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobDriver(v *types.JobDriver) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobDriver"}
	if v.SparkSubmitJobDriver != nil {
		if err := validateSparkSubmitJobDriver(v.SparkSubmitJobDriver); err != nil {
			invalidParams.AddNested("SparkSubmitJobDriver", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobTemplateData(v *types.JobTemplateData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobTemplateData"}
	if v.ExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRoleArn"))
	}
	if v.ReleaseLabel == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReleaseLabel"))
	}
	if v.ConfigurationOverrides != nil {
		if err := validateParametricConfigurationOverrides(v.ConfigurationOverrides); err != nil {
			invalidParams.AddNested("ConfigurationOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if v.JobDriver == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobDriver"))
	} else if v.JobDriver != nil {
		if err := validateJobDriver(v.JobDriver); err != nil {
			invalidParams.AddNested("JobDriver", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMonitoringConfiguration(v *types.MonitoringConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MonitoringConfiguration"}
	if v.CloudWatchMonitoringConfiguration != nil {
		if err := validateCloudWatchMonitoringConfiguration(v.CloudWatchMonitoringConfiguration); err != nil {
			invalidParams.AddNested("CloudWatchMonitoringConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.S3MonitoringConfiguration != nil {
		if err := validateS3MonitoringConfiguration(v.S3MonitoringConfiguration); err != nil {
			invalidParams.AddNested("S3MonitoringConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateParametricConfigurationOverrides(v *types.ParametricConfigurationOverrides) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ParametricConfigurationOverrides"}
	if v.ApplicationConfiguration != nil {
		if err := validateConfigurationList(v.ApplicationConfiguration); err != nil {
			invalidParams.AddNested("ApplicationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetryPolicyConfiguration(v *types.RetryPolicyConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetryPolicyConfiguration"}
	if v.MaxAttempts == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxAttempts"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3MonitoringConfiguration(v *types.S3MonitoringConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3MonitoringConfiguration"}
	if v.LogUri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogUri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSparkSubmitJobDriver(v *types.SparkSubmitJobDriver) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SparkSubmitJobDriver"}
	if v.EntryPoint == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntryPoint"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelJobRunInput(v *CancelJobRunInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelJobRunInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateJobTemplateInput(v *CreateJobTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateJobTemplateInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.JobTemplateData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobTemplateData"))
	} else if v.JobTemplateData != nil {
		if err := validateJobTemplateData(v.JobTemplateData); err != nil {
			invalidParams.AddNested("JobTemplateData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateManagedEndpointInput(v *CreateManagedEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateManagedEndpointInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.ReleaseLabel == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReleaseLabel"))
	}
	if v.ExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRoleArn"))
	}
	if v.ConfigurationOverrides != nil {
		if err := validateConfigurationOverrides(v.ConfigurationOverrides); err != nil {
			invalidParams.AddNested("ConfigurationOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVirtualClusterInput(v *CreateVirtualClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVirtualClusterInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ContainerProvider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ContainerProvider"))
	} else if v.ContainerProvider != nil {
		if err := validateContainerProvider(v.ContainerProvider); err != nil {
			invalidParams.AddNested("ContainerProvider", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteJobTemplateInput(v *DeleteJobTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteJobTemplateInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteManagedEndpointInput(v *DeleteManagedEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteManagedEndpointInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVirtualClusterInput(v *DeleteVirtualClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVirtualClusterInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeJobRunInput(v *DescribeJobRunInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeJobRunInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeJobTemplateInput(v *DescribeJobTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeJobTemplateInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeManagedEndpointInput(v *DescribeManagedEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeManagedEndpointInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVirtualClusterInput(v *DescribeVirtualClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVirtualClusterInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListJobRunsInput(v *ListJobRunsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListJobRunsInput"}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListManagedEndpointsInput(v *ListManagedEndpointsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListManagedEndpointsInput"}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartJobRunInput(v *StartJobRunInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartJobRunInput"}
	if v.VirtualClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualClusterId"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.JobDriver != nil {
		if err := validateJobDriver(v.JobDriver); err != nil {
			invalidParams.AddNested("JobDriver", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConfigurationOverrides != nil {
		if err := validateConfigurationOverrides(v.ConfigurationOverrides); err != nil {
			invalidParams.AddNested("ConfigurationOverrides", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetryPolicyConfiguration != nil {
		if err := validateRetryPolicyConfiguration(v.RetryPolicyConfiguration); err != nil {
			invalidParams.AddNested("RetryPolicyConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
