// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// An event from a source outside of Amazon Web Services that you want CloudTrail
// to log.
type AuditEvent struct {

	// The content of an audit event that comes from the event, such as userIdentity,
	// userAgent, and eventSource.
	//
	// This member is required.
	EventData *string

	// The original event ID from the source event.
	//
	// This member is required.
	Id *string

	// A checksum is a base64-SHA256 algorithm that helps you verify that CloudTrail
	// receives the event that matches with the checksum. Calculate the checksum by
	// running a command like the following: printf %s $eventdata | openssl dgst
	// -binary -sha256 | base64
	EventDataChecksum *string

	noSmithyDocumentSerde
}

// A response that includes successful and failed event results.
type AuditEventResultEntry struct {

	// The event ID assigned by CloudTrail.
	//
	// This member is required.
	EventID *string

	// The original event ID from the source event.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Includes the error code and error message for events that could not be ingested
// by CloudTrail.
type ResultErrorEntry struct {

	// The error code for events that could not be ingested by CloudTrail. Possible
	// error codes include: FieldTooLong, FieldNotFound, InvalidChecksum, InvalidData,
	// InvalidRecipient, InvalidEventSource, AccountNotSubscribed, Throttling, and
	// InternalFailure.
	//
	// This member is required.
	ErrorCode *string

	// The message that describes the error for events that could not be ingested by
	// CloudTrail.
	//
	// This member is required.
	ErrorMessage *string

	// The original event ID from the source event that could not be ingested by
	// CloudTrail.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
