// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes a real-time log configuration. You cannot delete a real-time log
// configuration if it's attached to a cache behavior. First update your
// distributions to remove the real-time log configuration from all cache
// behaviors, then delete the real-time log configuration. To delete a real-time
// log configuration, you can provide the configuration's name or its Amazon
// Resource Name (ARN). You must provide at least one. If you provide both,
// CloudFront uses the name to identify the real-time log configuration to delete.
func (c *Client) DeleteRealtimeLogConfig(ctx context.Context, params *DeleteRealtimeLogConfigInput, optFns ...func(*Options)) (*DeleteRealtimeLogConfigOutput, error) {
	if params == nil {
		params = &DeleteRealtimeLogConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteRealtimeLogConfig", params, optFns, c.addOperationDeleteRealtimeLogConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteRealtimeLogConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteRealtimeLogConfigInput struct {

	// The Amazon Resource Name (ARN) of the real-time log configuration to delete.
	ARN *string

	// The name of the real-time log configuration to delete.
	Name *string

	noSmithyDocumentSerde
}

type DeleteRealtimeLogConfigOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteRealtimeLogConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestxml_serializeOpDeleteRealtimeLogConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpDeleteRealtimeLogConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteRealtimeLogConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteRealtimeLogConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudfront",
		OperationName: "DeleteRealtimeLogConfig",
	}
}
