# From 6.0 to 6.1
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/6.0-to-6.1.md) for the most up to date instructions.*

## Warning

GitLab 6.1 is affected by critical security vulnerabilities CVE-2013-4490 and CVE-2013-4489.

**In 6.1 we remove a lot of deprecated code.**

**You should update to 6.0 before installing 6.1 so all the necessary conversions are run.**

## Deprecations

### Global issue numbers

In 6.1 issue numbers are project specific. This means all issues are renumbered and get a new number in their URL. If you use an old issue number URL and the issue number does not exist yet you are redirected to the new one. This conversion does not trigger if the old number already exists for this project, this is unlikely but will happen with old issues and large projects.

## 0. Backup

It's useful to make a backup just in case things go south (with MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version):

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

## 1. Stop server

    sudo service gitlab stop

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
sudo -u git -H git checkout 6-1-stable
# For GitLab Enterprise Edition: sudo -u git -H git checkout 6-1-stable-ee
```

## 3. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.7.9
```

## 4. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL
sudo -u git -H bundle install --without development test postgres --deployment

#PostgreSQL
sudo -u git -H bundle install --without development test mysql --deployment


sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake migrate_iids RAILS_ENV=production
sudo -u git -H bundle exec rake assets:clean RAILS_ENV=production
sudo -u git -H bundle exec rake assets:precompile RAILS_ENV=production
sudo -u git -H bundle exec rake cache:clear RAILS_ENV=production
```

## 5. Update config files

- Make `/home/git/gitlab/config/gitlab.yml` same as https://gitlab.com/gitlab-org/gitlab-ce/blob/6-1-stable/config/gitlab.yml.example but with your settings.
- Make `/home/git/gitlab/config/unicorn.rb` same as https://gitlab.com/gitlab-org/gitlab-ce/blob/6-1-stable/config/unicorn.rb.example but with your settings.

## 6. Update Init script

```bash
sudo rm /etc/init.d/gitlab
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

## 7. Start application

    sudo service gitlab start
    sudo service nginx restart

## 8. Check application status

Check if GitLab and its environment are configured correctly:

    cd /home/git/gitlab
    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## Things went south? Revert to previous version (6.0)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 5.4 to 6.0](5.4-to-6.0.md), except for the database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
