//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridcontainerservice

const (
	moduleName    = "armhybridcontainerservice"
	moduleVersion = "v0.1.1"
)

type AgentPoolProvisioningState string

const (
	AgentPoolProvisioningStateCanceled   AgentPoolProvisioningState = "Canceled"
	AgentPoolProvisioningStateDeleting   AgentPoolProvisioningState = "Deleting"
	AgentPoolProvisioningStateFailed     AgentPoolProvisioningState = "Failed"
	AgentPoolProvisioningStateInProgress AgentPoolProvisioningState = "InProgress"
	AgentPoolProvisioningStateSucceeded  AgentPoolProvisioningState = "Succeeded"
)

// PossibleAgentPoolProvisioningStateValues returns the possible values for the AgentPoolProvisioningState const type.
func PossibleAgentPoolProvisioningStateValues() []AgentPoolProvisioningState {
	return []AgentPoolProvisioningState{
		AgentPoolProvisioningStateCanceled,
		AgentPoolProvisioningStateDeleting,
		AgentPoolProvisioningStateFailed,
		AgentPoolProvisioningStateInProgress,
		AgentPoolProvisioningStateSucceeded,
	}
}

// AutoUpgradeOptions - Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest
// version. Defaults to Enabled.
type AutoUpgradeOptions string

const (
	AutoUpgradeOptionsDisabled AutoUpgradeOptions = "Disabled"
	AutoUpgradeOptionsEnabled  AutoUpgradeOptions = "Enabled"
)

// PossibleAutoUpgradeOptionsValues returns the possible values for the AutoUpgradeOptions const type.
func PossibleAutoUpgradeOptionsValues() []AutoUpgradeOptions {
	return []AutoUpgradeOptions{
		AutoUpgradeOptionsDisabled,
		AutoUpgradeOptionsEnabled,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DeploymentState - Observed deployment state of the Arc Agents on the target cluster. Possible values include: 'pending',
// 'provisioning', 'provisioned', 'deleting', 'failed', 'upgrading'
type DeploymentState string

const (
	DeploymentStateDeleting     DeploymentState = "deleting"
	DeploymentStateFailed       DeploymentState = "failed"
	DeploymentStatePending      DeploymentState = "pending"
	DeploymentStateProvisioned  DeploymentState = "provisioned"
	DeploymentStateProvisioning DeploymentState = "provisioning"
	DeploymentStateUpgrading    DeploymentState = "upgrading"
)

// PossibleDeploymentStateValues returns the possible values for the DeploymentState const type.
func PossibleDeploymentStateValues() []DeploymentState {
	return []DeploymentState{
		DeploymentStateDeleting,
		DeploymentStateFailed,
		DeploymentStatePending,
		DeploymentStateProvisioned,
		DeploymentStateProvisioning,
		DeploymentStateUpgrading,
	}
}

// LicenseType - LicenseType - The licenseType to use for Windows VMs. WindowsServer is used to enable Azure Hybrid User Benefits
// for Windows VMs. Possible values include: 'None', 'WindowsServer'
type LicenseType string

const (
	LicenseTypeNone          LicenseType = "None"
	LicenseTypeWindowsServer LicenseType = "Windows_Server"
)

// PossibleLicenseTypeValues returns the possible values for the LicenseType const type.
func PossibleLicenseTypeValues() []LicenseType {
	return []LicenseType{
		LicenseTypeNone,
		LicenseTypeWindowsServer,
	}
}

// LoadBalancerSKU - LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy',
// 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
type LoadBalancerSKU string

const (
	LoadBalancerSKUStackedKubeVip   LoadBalancerSKU = "stacked-kube-vip"
	LoadBalancerSKUStackedMetallb   LoadBalancerSKU = "stacked-metallb"
	LoadBalancerSKUUnmanaged        LoadBalancerSKU = "unmanaged"
	LoadBalancerSKUUnstackedHaproxy LoadBalancerSKU = "unstacked-haproxy"
)

// PossibleLoadBalancerSKUValues returns the possible values for the LoadBalancerSKU const type.
func PossibleLoadBalancerSKUValues() []LoadBalancerSKU {
	return []LoadBalancerSKU{
		LoadBalancerSKUStackedKubeVip,
		LoadBalancerSKUStackedMetallb,
		LoadBalancerSKUUnmanaged,
		LoadBalancerSKUUnstackedHaproxy,
	}
}

// Mode - Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default
// is 'User'
type Mode string

const (
	ModeLB     Mode = "LB"
	ModeSystem Mode = "System"
	ModeUser   Mode = "User"
)

// PossibleModeValues returns the possible values for the Mode const type.
func PossibleModeValues() []Mode {
	return []Mode{
		ModeLB,
		ModeSystem,
		ModeUser,
	}
}

// NetworkPolicy - NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico',
// 'flannel'. Default is 'calico'
type NetworkPolicy string

const (
	NetworkPolicyCalico  NetworkPolicy = "calico"
	NetworkPolicyFlannel NetworkPolicy = "flannel"
)

// PossibleNetworkPolicyValues returns the possible values for the NetworkPolicy const type.
func PossibleNetworkPolicyValues() []NetworkPolicy {
	return []NetworkPolicy{
		NetworkPolicyCalico,
		NetworkPolicyFlannel,
	}
}

// OsType - OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values
// include: 'Linux', 'Windows'
type OsType string

const (
	OsTypeLinux   OsType = "Linux"
	OsTypeWindows OsType = "Windows"
)

// PossibleOsTypeValues returns the possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{
		OsTypeLinux,
		OsTypeWindows,
	}
}

type ProvisioningState string

const (
	ProvisioningStateAccepted   ProvisioningState = "Accepted"
	ProvisioningStateCanceled   ProvisioningState = "Canceled"
	ProvisioningStateCreated    ProvisioningState = "Created"
	ProvisioningStateDeleting   ProvisioningState = "Deleting"
	ProvisioningStateFailed     ProvisioningState = "Failed"
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	ProvisioningStateSucceeded  ProvisioningState = "Succeeded"
	ProvisioningStateUpdating   ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateCreated,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateInProgress,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// ResourceIdentityType - The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system
// created identity. The type None means no identity is assigned to the provisioned cluster.
type ResourceIdentityType string

const (
	ResourceIdentityTypeNone           ResourceIdentityType = "None"
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeNone,
		ResourceIdentityTypeSystemAssigned,
	}
}
