// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package tracetest

import(
	"bytes"
	"context"
	"database/sql/driver"
	"errors"
	"fmt"
	"time"
	"github.com/uber/jaeger-client-go/thrift"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

type Transport int64
const (
  Transport_HTTP Transport = 0
  Transport_TCHANNEL Transport = 1
  Transport_DUMMY Transport = 2
)

func (p Transport) String() string {
  switch p {
  case Transport_HTTP: return "HTTP"
  case Transport_TCHANNEL: return "TCHANNEL"
  case Transport_DUMMY: return "DUMMY"
  }
  return "<UNSET>"
}

func TransportFromString(s string) (Transport, error) {
  switch s {
  case "HTTP": return Transport_HTTP, nil 
  case "TCHANNEL": return Transport_TCHANNEL, nil 
  case "DUMMY": return Transport_DUMMY, nil 
  }
  return Transport(0), fmt.Errorf("not a valid Transport string")
}


func TransportPtr(v Transport) *Transport { return &v }

func (p Transport) MarshalText() ([]byte, error) {
return []byte(p.String()), nil
}

func (p *Transport) UnmarshalText(text []byte) error {
q, err := TransportFromString(string(text))
if (err != nil) {
return err
}
*p = q
return nil
}

func (p *Transport) Scan(value interface{}) error {
v, ok := value.(int64)
if !ok {
return errors.New("Scan value is not int64")
}
*p = Transport(v)
return nil
}

func (p * Transport) Value() (driver.Value, error) {
  if p == nil {
    return nil, nil
  }
return int64(*p), nil
}
// Attributes:
//  - ServiceName
//  - ServerRole
//  - Host
//  - Port
//  - Transport
//  - Downstream
type Downstream struct {
  ServiceName string `thrift:"serviceName,1,required" db:"serviceName" json:"serviceName"`
  ServerRole string `thrift:"serverRole,2,required" db:"serverRole" json:"serverRole"`
  Host string `thrift:"host,3,required" db:"host" json:"host"`
  Port string `thrift:"port,4,required" db:"port" json:"port"`
  Transport Transport `thrift:"transport,5,required" db:"transport" json:"transport"`
  Downstream *Downstream `thrift:"downstream,6" db:"downstream" json:"downstream,omitempty"`
}

func NewDownstream() *Downstream {
  return &Downstream{}
}


func (p *Downstream) GetServiceName() string {
  return p.ServiceName
}

func (p *Downstream) GetServerRole() string {
  return p.ServerRole
}

func (p *Downstream) GetHost() string {
  return p.Host
}

func (p *Downstream) GetPort() string {
  return p.Port
}

func (p *Downstream) GetTransport() Transport {
  return p.Transport
}
var Downstream_Downstream_DEFAULT *Downstream
func (p *Downstream) GetDownstream() *Downstream {
  if !p.IsSetDownstream() {
    return Downstream_Downstream_DEFAULT
  }
return p.Downstream
}
func (p *Downstream) IsSetDownstream() bool {
  return p.Downstream != nil
}

func (p *Downstream) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetServiceName bool = false;
  var issetServerRole bool = false;
  var issetHost bool = false;
  var issetPort bool = false;
  var issetTransport bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetServiceName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetServerRole = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetHost = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetPort = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTransport = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetServiceName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServiceName is not set"));
  }
  if !issetServerRole{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServerRole is not set"));
  }
  if !issetHost{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Host is not set"));
  }
  if !issetPort{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Port is not set"));
  }
  if !issetTransport{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Transport is not set"));
  }
  return nil
}

func (p *Downstream)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.ServiceName = v
}
  return nil
}

func (p *Downstream)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.ServerRole = v
}
  return nil
}

func (p *Downstream)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Host = v
}
  return nil
}

func (p *Downstream)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Port = v
}
  return nil
}

func (p *Downstream)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  temp := Transport(v)
  p.Transport = temp
}
  return nil
}

func (p *Downstream)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  p.Downstream = &Downstream{}
  if err := p.Downstream.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Downstream), err)
  }
  return nil
}

func (p *Downstream) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "Downstream"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *Downstream) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serviceName", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:serviceName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ServiceName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serviceName (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:serviceName: ", p), err) }
  return err
}

func (p *Downstream) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serverRole", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:serverRole: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ServerRole)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serverRole (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:serverRole: ", p), err) }
  return err
}

func (p *Downstream) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "host", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:host: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Host)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.host (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:host: ", p), err) }
  return err
}

func (p *Downstream) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "port", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:port: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Port)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.port (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:port: ", p), err) }
  return err
}

func (p *Downstream) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "transport", thrift.I32, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:transport: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Transport)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.transport (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:transport: ", p), err) }
  return err
}

func (p *Downstream) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDownstream() {
    if err := oprot.WriteFieldBegin(ctx, "downstream", thrift.STRUCT, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:downstream: ", p), err) }
    if err := p.Downstream.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Downstream), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:downstream: ", p), err) }
  }
  return err
}

func (p *Downstream) Equals(other *Downstream) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.ServiceName != other.ServiceName { return false }
  if p.ServerRole != other.ServerRole { return false }
  if p.Host != other.Host { return false }
  if p.Port != other.Port { return false }
  if p.Transport != other.Transport { return false }
  if !p.Downstream.Equals(other.Downstream) { return false }
  return true
}

func (p *Downstream) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("Downstream(%+v)", *p)
}

// Attributes:
//  - ServerRole
//  - Sampled
//  - Baggage
//  - Downstream
type StartTraceRequest struct {
  ServerRole string `thrift:"serverRole,1,required" db:"serverRole" json:"serverRole"`
  Sampled bool `thrift:"sampled,2,required" db:"sampled" json:"sampled"`
  Baggage string `thrift:"baggage,3,required" db:"baggage" json:"baggage"`
  Downstream *Downstream `thrift:"downstream,4,required" db:"downstream" json:"downstream"`
}

func NewStartTraceRequest() *StartTraceRequest {
  return &StartTraceRequest{}
}


func (p *StartTraceRequest) GetServerRole() string {
  return p.ServerRole
}

func (p *StartTraceRequest) GetSampled() bool {
  return p.Sampled
}

func (p *StartTraceRequest) GetBaggage() string {
  return p.Baggage
}
var StartTraceRequest_Downstream_DEFAULT *Downstream
func (p *StartTraceRequest) GetDownstream() *Downstream {
  if !p.IsSetDownstream() {
    return StartTraceRequest_Downstream_DEFAULT
  }
return p.Downstream
}
func (p *StartTraceRequest) IsSetDownstream() bool {
  return p.Downstream != nil
}

func (p *StartTraceRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetServerRole bool = false;
  var issetSampled bool = false;
  var issetBaggage bool = false;
  var issetDownstream bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetServerRole = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetSampled = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetBaggage = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetDownstream = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetServerRole{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServerRole is not set"));
  }
  if !issetSampled{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Sampled is not set"));
  }
  if !issetBaggage{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Baggage is not set"));
  }
  if !issetDownstream{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Downstream is not set"));
  }
  return nil
}

func (p *StartTraceRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.ServerRole = v
}
  return nil
}

func (p *StartTraceRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Sampled = v
}
  return nil
}

func (p *StartTraceRequest)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Baggage = v
}
  return nil
}

func (p *StartTraceRequest)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.Downstream = &Downstream{}
  if err := p.Downstream.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Downstream), err)
  }
  return nil
}

func (p *StartTraceRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "StartTraceRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *StartTraceRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serverRole", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:serverRole: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ServerRole)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serverRole (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:serverRole: ", p), err) }
  return err
}

func (p *StartTraceRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sampled", thrift.BOOL, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:sampled: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.Sampled)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sampled (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:sampled: ", p), err) }
  return err
}

func (p *StartTraceRequest) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "baggage", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:baggage: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Baggage)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.baggage (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:baggage: ", p), err) }
  return err
}

func (p *StartTraceRequest) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "downstream", thrift.STRUCT, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:downstream: ", p), err) }
  if err := p.Downstream.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Downstream), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:downstream: ", p), err) }
  return err
}

func (p *StartTraceRequest) Equals(other *StartTraceRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.ServerRole != other.ServerRole { return false }
  if p.Sampled != other.Sampled { return false }
  if p.Baggage != other.Baggage { return false }
  if !p.Downstream.Equals(other.Downstream) { return false }
  return true
}

func (p *StartTraceRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("StartTraceRequest(%+v)", *p)
}

// Attributes:
//  - ServerRole
//  - Downstream
type JoinTraceRequest struct {
  ServerRole string `thrift:"serverRole,1,required" db:"serverRole" json:"serverRole"`
  Downstream *Downstream `thrift:"downstream,2" db:"downstream" json:"downstream,omitempty"`
}

func NewJoinTraceRequest() *JoinTraceRequest {
  return &JoinTraceRequest{}
}


func (p *JoinTraceRequest) GetServerRole() string {
  return p.ServerRole
}
var JoinTraceRequest_Downstream_DEFAULT *Downstream
func (p *JoinTraceRequest) GetDownstream() *Downstream {
  if !p.IsSetDownstream() {
    return JoinTraceRequest_Downstream_DEFAULT
  }
return p.Downstream
}
func (p *JoinTraceRequest) IsSetDownstream() bool {
  return p.Downstream != nil
}

func (p *JoinTraceRequest) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetServerRole bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetServerRole = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetServerRole{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServerRole is not set"));
  }
  return nil
}

func (p *JoinTraceRequest)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.ServerRole = v
}
  return nil
}

func (p *JoinTraceRequest)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Downstream = &Downstream{}
  if err := p.Downstream.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Downstream), err)
  }
  return nil
}

func (p *JoinTraceRequest) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "JoinTraceRequest"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *JoinTraceRequest) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serverRole", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:serverRole: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ServerRole)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serverRole (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:serverRole: ", p), err) }
  return err
}

func (p *JoinTraceRequest) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDownstream() {
    if err := oprot.WriteFieldBegin(ctx, "downstream", thrift.STRUCT, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:downstream: ", p), err) }
    if err := p.Downstream.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Downstream), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:downstream: ", p), err) }
  }
  return err
}

func (p *JoinTraceRequest) Equals(other *JoinTraceRequest) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.ServerRole != other.ServerRole { return false }
  if !p.Downstream.Equals(other.Downstream) { return false }
  return true
}

func (p *JoinTraceRequest) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("JoinTraceRequest(%+v)", *p)
}

// Attributes:
//  - TraceId
//  - Sampled
//  - Baggage
type ObservedSpan struct {
  TraceId string `thrift:"traceId,1,required" db:"traceId" json:"traceId"`
  Sampled bool `thrift:"sampled,2,required" db:"sampled" json:"sampled"`
  Baggage string `thrift:"baggage,3,required" db:"baggage" json:"baggage"`
}

func NewObservedSpan() *ObservedSpan {
  return &ObservedSpan{}
}


func (p *ObservedSpan) GetTraceId() string {
  return p.TraceId
}

func (p *ObservedSpan) GetSampled() bool {
  return p.Sampled
}

func (p *ObservedSpan) GetBaggage() string {
  return p.Baggage
}
func (p *ObservedSpan) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTraceId bool = false;
  var issetSampled bool = false;
  var issetBaggage bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTraceId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetSampled = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetBaggage = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTraceId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TraceId is not set"));
  }
  if !issetSampled{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Sampled is not set"));
  }
  if !issetBaggage{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Baggage is not set"));
  }
  return nil
}

func (p *ObservedSpan)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.TraceId = v
}
  return nil
}

func (p *ObservedSpan)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Sampled = v
}
  return nil
}

func (p *ObservedSpan)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Baggage = v
}
  return nil
}

func (p *ObservedSpan) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "ObservedSpan"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ObservedSpan) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "traceId", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:traceId: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TraceId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.traceId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:traceId: ", p), err) }
  return err
}

func (p *ObservedSpan) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sampled", thrift.BOOL, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:sampled: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.Sampled)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sampled (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:sampled: ", p), err) }
  return err
}

func (p *ObservedSpan) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "baggage", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:baggage: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Baggage)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.baggage (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:baggage: ", p), err) }
  return err
}

func (p *ObservedSpan) Equals(other *ObservedSpan) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.TraceId != other.TraceId { return false }
  if p.Sampled != other.Sampled { return false }
  if p.Baggage != other.Baggage { return false }
  return true
}

func (p *ObservedSpan) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ObservedSpan(%+v)", *p)
}

// Each server must include the information about the span it observed.
// It can only be omitted from the response if notImplementedError field is not empty.
// If the server was instructed to make a downstream call, it must embed the
// downstream response in its own response.
// 
// Attributes:
//  - Span
//  - Downstream
//  - NotImplementedError
type TraceResponse struct {
  Span *ObservedSpan `thrift:"span,1" db:"span" json:"span,omitempty"`
  Downstream *TraceResponse `thrift:"downstream,2" db:"downstream" json:"downstream,omitempty"`
  NotImplementedError string `thrift:"notImplementedError,3,required" db:"notImplementedError" json:"notImplementedError"`
}

func NewTraceResponse() *TraceResponse {
  return &TraceResponse{}
}

var TraceResponse_Span_DEFAULT *ObservedSpan
func (p *TraceResponse) GetSpan() *ObservedSpan {
  if !p.IsSetSpan() {
    return TraceResponse_Span_DEFAULT
  }
return p.Span
}
var TraceResponse_Downstream_DEFAULT *TraceResponse
func (p *TraceResponse) GetDownstream() *TraceResponse {
  if !p.IsSetDownstream() {
    return TraceResponse_Downstream_DEFAULT
  }
return p.Downstream
}

func (p *TraceResponse) GetNotImplementedError() string {
  return p.NotImplementedError
}
func (p *TraceResponse) IsSetSpan() bool {
  return p.Span != nil
}

func (p *TraceResponse) IsSetDownstream() bool {
  return p.Downstream != nil
}

func (p *TraceResponse) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetNotImplementedError bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetNotImplementedError = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetNotImplementedError{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NotImplementedError is not set"));
  }
  return nil
}

func (p *TraceResponse)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Span = &ObservedSpan{}
  if err := p.Span.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Span), err)
  }
  return nil
}

func (p *TraceResponse)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  p.Downstream = &TraceResponse{}
  if err := p.Downstream.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Downstream), err)
  }
  return nil
}

func (p *TraceResponse)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.NotImplementedError = v
}
  return nil
}

func (p *TraceResponse) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TraceResponse"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TraceResponse) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSpan() {
    if err := oprot.WriteFieldBegin(ctx, "span", thrift.STRUCT, 1); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:span: ", p), err) }
    if err := p.Span.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Span), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 1:span: ", p), err) }
  }
  return err
}

func (p *TraceResponse) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDownstream() {
    if err := oprot.WriteFieldBegin(ctx, "downstream", thrift.STRUCT, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:downstream: ", p), err) }
    if err := p.Downstream.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Downstream), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:downstream: ", p), err) }
  }
  return err
}

func (p *TraceResponse) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "notImplementedError", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:notImplementedError: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.NotImplementedError)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.notImplementedError (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:notImplementedError: ", p), err) }
  return err
}

func (p *TraceResponse) Equals(other *TraceResponse) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Span.Equals(other.Span) { return false }
  if !p.Downstream.Equals(other.Downstream) { return false }
  if p.NotImplementedError != other.NotImplementedError { return false }
  return true
}

func (p *TraceResponse) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TraceResponse(%+v)", *p)
}

type TracedService interface {
  // Parameters:
  //  - Request
  StartTrace(ctx context.Context, request *StartTraceRequest) (_r *TraceResponse, _err error)
  // Parameters:
  //  - Request
  JoinTrace(ctx context.Context, request *JoinTraceRequest) (_r *TraceResponse, _err error)
}

type TracedServiceClient struct {
  c thrift.TClient
  meta thrift.ResponseMeta
}

func NewTracedServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *TracedServiceClient {
  return &TracedServiceClient{
    c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
  }
}

func NewTracedServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *TracedServiceClient {
  return &TracedServiceClient{
    c: thrift.NewTStandardClient(iprot, oprot),
  }
}

func NewTracedServiceClient(c thrift.TClient) *TracedServiceClient {
  return &TracedServiceClient{
    c: c,
  }
}

func (p *TracedServiceClient) Client_() thrift.TClient {
  return p.c
}

func (p *TracedServiceClient) LastResponseMeta_() thrift.ResponseMeta {
  return p.meta
}

func (p *TracedServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
  p.meta = meta
}

// Parameters:
//  - Request
func (p *TracedServiceClient) StartTrace(ctx context.Context, request *StartTraceRequest) (_r *TraceResponse, _err error) {
  var _args0 TracedServiceStartTraceArgs
  _args0.Request = request
  var _result2 TracedServiceStartTraceResult
  var _meta1 thrift.ResponseMeta
  _meta1, _err = p.Client_().Call(ctx, "startTrace", &_args0, &_result2)
  p.SetLastResponseMeta_(_meta1)
  if _err != nil {
    return
  }
  return _result2.GetSuccess(), nil
}

// Parameters:
//  - Request
func (p *TracedServiceClient) JoinTrace(ctx context.Context, request *JoinTraceRequest) (_r *TraceResponse, _err error) {
  var _args3 TracedServiceJoinTraceArgs
  _args3.Request = request
  var _result5 TracedServiceJoinTraceResult
  var _meta4 thrift.ResponseMeta
  _meta4, _err = p.Client_().Call(ctx, "joinTrace", &_args3, &_result5)
  p.SetLastResponseMeta_(_meta4)
  if _err != nil {
    return
  }
  return _result5.GetSuccess(), nil
}

type TracedServiceProcessor struct {
  processorMap map[string]thrift.TProcessorFunction
  handler TracedService
}

func (p *TracedServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
  p.processorMap[key] = processor
}

func (p *TracedServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
  processor, ok = p.processorMap[key]
  return processor, ok
}

func (p *TracedServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
  return p.processorMap
}

func NewTracedServiceProcessor(handler TracedService) *TracedServiceProcessor {

  self6 := &TracedServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
  self6.processorMap["startTrace"] = &tracedServiceProcessorStartTrace{handler:handler}
  self6.processorMap["joinTrace"] = &tracedServiceProcessorJoinTrace{handler:handler}
return self6
}

func (p *TracedServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
  if err2 != nil { return false, thrift.WrapTException(err2) }
  if processor, ok := p.GetProcessorFunction(name); ok {
    return processor.Process(ctx, seqId, iprot, oprot)
  }
  iprot.Skip(ctx, thrift.STRUCT)
  iprot.ReadMessageEnd(ctx)
  x7 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
  oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
  x7.Write(ctx, oprot)
  oprot.WriteMessageEnd(ctx)
  oprot.Flush(ctx)
  return false, x7

}

type tracedServiceProcessorStartTrace struct {
  handler TracedService
}

func (p *tracedServiceProcessorStartTrace) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TracedServiceStartTraceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "startTrace", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TracedServiceStartTraceResult{}
  var retval *TraceResponse
  if retval, err2 = p.handler.StartTrace(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing startTrace: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "startTrace", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "startTrace", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tracedServiceProcessorJoinTrace struct {
  handler TracedService
}

func (p *tracedServiceProcessorJoinTrace) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TracedServiceJoinTraceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "joinTrace", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TracedServiceJoinTraceResult{}
  var retval *TraceResponse
  if retval, err2 = p.handler.JoinTrace(ctx, args.Request); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing joinTrace: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "joinTrace", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "joinTrace", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Request
type TracedServiceStartTraceArgs struct {
  Request *StartTraceRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTracedServiceStartTraceArgs() *TracedServiceStartTraceArgs {
  return &TracedServiceStartTraceArgs{}
}

var TracedServiceStartTraceArgs_Request_DEFAULT *StartTraceRequest
func (p *TracedServiceStartTraceArgs) GetRequest() *StartTraceRequest {
  if !p.IsSetRequest() {
    return TracedServiceStartTraceArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TracedServiceStartTraceArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TracedServiceStartTraceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TracedServiceStartTraceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &StartTraceRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TracedServiceStartTraceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "startTrace_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TracedServiceStartTraceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TracedServiceStartTraceArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TracedServiceStartTraceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TracedServiceStartTraceResult struct {
  Success *TraceResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTracedServiceStartTraceResult() *TracedServiceStartTraceResult {
  return &TracedServiceStartTraceResult{}
}

var TracedServiceStartTraceResult_Success_DEFAULT *TraceResponse
func (p *TracedServiceStartTraceResult) GetSuccess() *TraceResponse {
  if !p.IsSetSuccess() {
    return TracedServiceStartTraceResult_Success_DEFAULT
  }
return p.Success
}
func (p *TracedServiceStartTraceResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TracedServiceStartTraceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TracedServiceStartTraceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TraceResponse{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TracedServiceStartTraceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "startTrace_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TracedServiceStartTraceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TracedServiceStartTraceResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TracedServiceStartTraceResult(%+v)", *p)
}

// Attributes:
//  - Request
type TracedServiceJoinTraceArgs struct {
  Request *JoinTraceRequest `thrift:"request,1" db:"request" json:"request"`
}

func NewTracedServiceJoinTraceArgs() *TracedServiceJoinTraceArgs {
  return &TracedServiceJoinTraceArgs{}
}

var TracedServiceJoinTraceArgs_Request_DEFAULT *JoinTraceRequest
func (p *TracedServiceJoinTraceArgs) GetRequest() *JoinTraceRequest {
  if !p.IsSetRequest() {
    return TracedServiceJoinTraceArgs_Request_DEFAULT
  }
return p.Request
}
func (p *TracedServiceJoinTraceArgs) IsSetRequest() bool {
  return p.Request != nil
}

func (p *TracedServiceJoinTraceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TracedServiceJoinTraceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Request = &JoinTraceRequest{}
  if err := p.Request.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Request), err)
  }
  return nil
}

func (p *TracedServiceJoinTraceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "joinTrace_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TracedServiceJoinTraceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "request", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:request: ", p), err) }
  if err := p.Request.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Request), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:request: ", p), err) }
  return err
}

func (p *TracedServiceJoinTraceArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TracedServiceJoinTraceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TracedServiceJoinTraceResult struct {
  Success *TraceResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTracedServiceJoinTraceResult() *TracedServiceJoinTraceResult {
  return &TracedServiceJoinTraceResult{}
}

var TracedServiceJoinTraceResult_Success_DEFAULT *TraceResponse
func (p *TracedServiceJoinTraceResult) GetSuccess() *TraceResponse {
  if !p.IsSetSuccess() {
    return TracedServiceJoinTraceResult_Success_DEFAULT
  }
return p.Success
}
func (p *TracedServiceJoinTraceResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TracedServiceJoinTraceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TracedServiceJoinTraceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TraceResponse{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TracedServiceJoinTraceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "joinTrace_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TracedServiceJoinTraceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TracedServiceJoinTraceResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TracedServiceJoinTraceResult(%+v)", *p)
}


