// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The browser settings resource that can be associated with a web portal. Once
// associated with a web portal, browser settings control how the browser will
// behave once a user starts a streaming session for the web portal.
type BrowserSettings struct {

	// The ARN of the browser settings.
	//
	// This member is required.
	BrowserSettingsArn *string

	// A list of web portal ARNs that this browser settings is associated with.
	AssociatedPortalArns []string

	// A JSON string containing Chrome Enterprise policies that will be applied to all
	// streaming sessions.
	BrowserPolicy *string

	noSmithyDocumentSerde
}

// The summary for browser settings.
type BrowserSettingsSummary struct {

	// The ARN of the browser settings.
	BrowserSettingsArn *string

	noSmithyDocumentSerde
}

// The certificate.
type Certificate struct {

	// The body of the certificate.
	Body []byte

	// The entity that issued the certificate.
	Issuer *string

	// The certificate is not valid after this date.
	NotValidAfter *time.Time

	// The certificate is not valid before this date.
	NotValidBefore *time.Time

	// The entity the certificate belongs to.
	Subject *string

	// A hexadecimal identifier for the certificate.
	Thumbprint *string

	noSmithyDocumentSerde
}

// The summary of the certificate.
type CertificateSummary struct {

	// The entity that issued the certificate.
	Issuer *string

	// The certificate is not valid after this date.
	NotValidAfter *time.Time

	// The certificate is not valid before this date.
	NotValidBefore *time.Time

	// The entity the certificate belongs to.
	Subject *string

	// A hexadecimal identifier for the certificate.
	Thumbprint *string

	noSmithyDocumentSerde
}

// The identity provider.
type IdentityProvider struct {

	// The ARN of the identity provider.
	//
	// This member is required.
	IdentityProviderArn *string

	// The identity provider details. The following list describes the provider detail
	// keys for each identity provider type.
	//
	// * For Google and Login with Amazon:
	//
	// *
	// client_id
	//
	// * client_secret
	//
	// * authorize_scopes
	//
	// * For Facebook:
	//
	// * client_id
	//
	// *
	// client_secret
	//
	// * authorize_scopes
	//
	// * api_version
	//
	// * For Sign in with Apple:
	//
	// *
	// client_id
	//
	// * team_id
	//
	// * key_id
	//
	// * private_key
	//
	// * authorize_scopes
	//
	// * For OIDC
	// providers:
	//
	// * client_id
	//
	// * client_secret
	//
	// * attributes_request_method
	//
	// *
	// oidc_issuer
	//
	// * authorize_scopes
	//
	// * authorize_url if not available from discovery
	// URL specified by oidc_issuer key
	//
	// * token_url if not available from discovery
	// URL specified by oidc_issuer key
	//
	// * attributes_url if not available from
	// discovery URL specified by oidc_issuer key
	//
	// * jwks_uri if not available from
	// discovery URL specified by oidc_issuer key
	//
	// * For SAML providers:
	//
	// *
	// MetadataFile OR MetadataURL
	//
	// * IDPSignout optional
	IdentityProviderDetails map[string]string

	// The identity provider name.
	IdentityProviderName *string

	// The identity provider type.
	IdentityProviderType IdentityProviderType

	noSmithyDocumentSerde
}

// The summary of the identity provider.
type IdentityProviderSummary struct {

	// The ARN of the identity provider.
	IdentityProviderArn *string

	// The identity provider name.
	IdentityProviderName *string

	// The identity provider type.
	IdentityProviderType IdentityProviderType

	noSmithyDocumentSerde
}

// A network settings resource that can be associated with a web portal. Once
// associated with a web portal, network settings define how streaming instances
// will connect with your specified VPC.
type NetworkSettings struct {

	// The ARN of the network settings.
	//
	// This member is required.
	NetworkSettingsArn *string

	// A list of web portal ARNs that this network settings is associated with.
	AssociatedPortalArns []string

	// One or more security groups used to control access from streaming instances to
	// your VPC.
	SecurityGroupIds []string

	// The subnets in which network interfaces are created to connect streaming
	// instances to your VPC. At least two of these subnets must be in different
	// availability zones.
	SubnetIds []string

	// The VPC that streaming instances will connect to.
	VpcId *string

	noSmithyDocumentSerde
}

// The summary of network settings.
type NetworkSettingsSummary struct {

	// The ARN of the network settings.
	NetworkSettingsArn *string

	// The VPC ID of the network settings.
	VpcId *string

	noSmithyDocumentSerde
}

// The web portal.
type Portal struct {

	// The ARN of the browser settings that is associated with this web portal.
	BrowserSettingsArn *string

	// The browser that users see when using a streaming session.
	BrowserType BrowserType

	// The creation date of the web portal.
	CreationDate *time.Time

	// The name of the web portal.
	DisplayName *string

	// The ARN of the network settings that is associated with the web portal.
	NetworkSettingsArn *string

	// The ARN of the web portal.
	PortalArn *string

	// The endpoint URL of the web portal that users access in order to start streaming
	// sessions.
	PortalEndpoint *string

	// The status of the web portal.
	PortalStatus PortalStatus

	// The renderer that is used in streaming sessions.
	RendererType RendererType

	// A message that explains why the web portal is in its current status.
	StatusReason *string

	// The ARN of the trust store that is associated with the web portal.
	TrustStoreArn *string

	// The ARN of the trust store that is associated with the web portal.
	UserSettingsArn *string

	noSmithyDocumentSerde
}

// The summary of the portal.
type PortalSummary struct {

	// The ARN of the browser settings that is associated with the web portal.
	BrowserSettingsArn *string

	// The browser type of the web portal.
	BrowserType BrowserType

	// The creation date of the web portal.
	CreationDate *time.Time

	// The name of the web portal.
	DisplayName *string

	// The ARN of the network settings that is associated with the web portal.
	NetworkSettingsArn *string

	// The ARN of the web portal.
	PortalArn *string

	// The endpoint URL of the web portal that users access in order to start streaming
	// sessions.
	PortalEndpoint *string

	// The status of the web portal.
	PortalStatus PortalStatus

	// The renderer that is used in streaming sessions.
	RendererType RendererType

	// The ARN of the trust that is associated with this web portal.
	TrustStoreArn *string

	// The ARN of the user settings that is associated with the web portal.
	UserSettingsArn *string

	noSmithyDocumentSerde
}

// The tag.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A trust store that can be associated with a web portal. A trust store contains
// certificate authority (CA) certificates. Once associated with a web portal, the
// browser in a streaming session will recognize certificates that have been issued
// using any of the CAs in the trust store. If your organization has internal
// websites that use certificates issued by private CAs, you should add the private
// CA certificate to the trust store.
type TrustStore struct {

	// A list of web portal ARNs that this trust store is associated with.
	AssociatedPortalArns []string

	// The ARN of the trust store.
	TrustStoreArn *string

	noSmithyDocumentSerde
}

// The summary of the trust store.
type TrustStoreSummary struct {

	// The ARN of the trust store.
	TrustStoreArn *string

	noSmithyDocumentSerde
}

// A user settings resource that can be associated with a web portal. Once
// associated with a web portal, user settings control how users can transfer data
// between a streaming session and the their local devices.
type UserSettings struct {

	// The ARN of the user settings.
	//
	// This member is required.
	UserSettingsArn *string

	// A list of web portal ARNs that this user settings is associated with.
	AssociatedPortalArns []string

	// Specifies whether the user can copy text from the streaming session to the local
	// device.
	CopyAllowed EnabledType

	// The amount of time that a streaming session remains active after users
	// disconnect.
	DisconnectTimeoutInMinutes *int32

	// Specifies whether the user can download files from the streaming session to the
	// local device.
	DownloadAllowed EnabledType

	// The amount of time that users can be idle (inactive) before they are
	// disconnected from their streaming session and the disconnect timeout interval
	// begins.
	IdleDisconnectTimeoutInMinutes *int32

	// Specifies whether the user can paste text from the local device to the streaming
	// session.
	PasteAllowed EnabledType

	// Specifies whether the user can print to the local device.
	PrintAllowed EnabledType

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed EnabledType

	noSmithyDocumentSerde
}

// The summary of user settings.
type UserSettingsSummary struct {

	// Specifies whether the user can copy text from the streaming session to the local
	// device.
	CopyAllowed EnabledType

	// The amount of time that a streaming session remains active after users
	// disconnect.
	DisconnectTimeoutInMinutes *int32

	// Specifies whether the user can download files from the streaming session to the
	// local device.
	DownloadAllowed EnabledType

	// The amount of time that users can be idle (inactive) before they are
	// disconnected from their streaming session and the disconnect timeout interval
	// begins.
	IdleDisconnectTimeoutInMinutes *int32

	// Specifies whether the user can paste text from the local device to the streaming
	// session.
	PasteAllowed EnabledType

	// Specifies whether the user can print to the local device.
	PrintAllowed EnabledType

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed EnabledType

	// The ARN of the user settings.
	UserSettingsArn *string

	noSmithyDocumentSerde
}

// Information about a field passed inside a request that resulted in an exception.
type ValidationExceptionField struct {

	// The message describing why the field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
