// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure describing the source of an action.
type ActionSource struct {

	// The URI of the source.
	//
	// This member is required.
	SourceUri *string

	// The ID of the source.
	SourceId *string

	// The type of the source.
	SourceType *string

	noSmithyDocumentSerde
}

// Lists the properties of an action. An action represents an action or activity.
// Some examples are a workflow step and a model deployment. Generally, an action
// involves at least one input artifact or output artifact.
type ActionSummary struct {

	// The Amazon Resource Name (ARN) of the action.
	ActionArn *string

	// The name of the action.
	ActionName *string

	// The type of the action.
	ActionType *string

	// When the action was created.
	CreationTime *time.Time

	// When the action was last modified.
	LastModifiedTime *time.Time

	// The source of the action.
	Source *ActionSource

	// The status of the action.
	Status ActionStatus

	noSmithyDocumentSerde
}

// A structure of additional Inference Specification. Additional Inference
// Specification specifies details about inference jobs that can be run with models
// based on this model package
type AdditionalInferenceSpecificationDefinition struct {

	// The Amazon ECR registry path of the Docker image that contains the inference
	// code.
	//
	// This member is required.
	Containers []ModelPackageContainerDefinition

	// A unique name to identify the additional inference specification. The name must
	// be unique within the list of your additional inference specifications for a
	// particular model package.
	//
	// This member is required.
	Name *string

	// A description of the additional Inference specification
	Description *string

	// The supported MIME types for the input data.
	SupportedContentTypes []string

	// A list of the instance types that are used to generate inferences in real-time.
	SupportedRealtimeInferenceInstanceTypes []ProductionVariantInstanceType

	// The supported MIME types for the output data.
	SupportedResponseMIMETypes []string

	// A list of the instance types on which a transformation job can be run or on
	// which an endpoint can be deployed.
	SupportedTransformInstanceTypes []TransformInstanceType

	noSmithyDocumentSerde
}

// Edge Manager agent version.
type AgentVersion struct {

	// The number of Edge Manager agents.
	//
	// This member is required.
	AgentCount int64

	// Version of the agent.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.
type Alarm struct {

	// The name of a CloudWatch alarm in your account.
	AlarmName *string

	noSmithyDocumentSerde
}

// Specifies the training algorithm to use in a CreateTrainingJob request. For more
// information about algorithms provided by SageMaker, see Algorithms
// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information
// about using your own algorithms, see Using Your Own Algorithms with Amazon
// SageMaker
// (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
type AlgorithmSpecification struct {

	// The training input mode that the algorithm supports. For more information about
	// input modes, see Algorithms
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). Pipe mode If an
	// algorithm supports Pipe mode, Amazon SageMaker streams data directly from Amazon
	// S3 to the container. File mode If an algorithm supports File mode, SageMaker
	// downloads the training data from S3 to the provisioned ML storage volume, and
	// mounts the directory to the Docker volume for the training container. You must
	// provision the ML storage volume with sufficient capacity to accommodate the data
	// downloaded from S3. In addition to the training data, the ML storage volume also
	// stores the output model. The algorithm container uses the ML storage volume to
	// also store intermediate information, if any. For distributed algorithms,
	// training data is distributed uniformly. Your training duration is predictable if
	// the input data objects sizes are approximately the same. SageMaker does not
	// split the files any further for model training. If the object sizes are skewed,
	// training won't be optimal as the data distribution is also skewed when one host
	// in a training cluster is overloaded, thus becoming a bottleneck in training.
	// FastFile mode If an algorithm supports FastFile mode, SageMaker streams data
	// directly from S3 to the container with no code changes, and provides file system
	// access to the data. Users can author their training script to interact with
	// these files as if they were stored on disk. FastFile mode works best when the
	// data is read sequentially. Augmented manifest files aren't supported. The
	// startup time is lower when there are fewer files in the S3 bucket provided.
	//
	// This member is required.
	TrainingInputMode TrainingInputMode

	// The name of the algorithm resource to use for the training job. This must be an
	// algorithm resource that you created or subscribe to on Amazon Web Services
	// Marketplace. You must specify either the algorithm name to the AlgorithmName
	// parameter or the image URI of the algorithm container to the TrainingImage
	// parameter. Note that the AlgorithmName parameter is mutually exclusive with the
	// TrainingImage parameter. If you specify a value for the AlgorithmName parameter,
	// you can't specify a value for TrainingImage, and vice versa. If you specify
	// values for both parameters, the training job might break; if you don't specify
	// any value for both parameters, the training job might raise a null error.
	AlgorithmName *string

	// To generate and save time-series metrics during training, set to true. The
	// default is false and time-series metrics aren't generated except in the
	// following cases:
	//
	// * You use one of the SageMaker built-in algorithms
	//
	// * You use
	// one of the following Prebuilt SageMaker Docker Images
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
	//
	// *
	// Tensorflow (version >= 1.15)
	//
	// * MXNet (version >= 1.6)
	//
	// * PyTorch (version >=
	// 1.3)
	//
	// * You specify at least one MetricDefinition
	EnableSageMakerMetricsTimeSeries bool

	// A list of metric definition objects. Each object specifies the metric name and
	// regular expressions used to parse algorithm logs. SageMaker publishes each
	// metric to Amazon CloudWatch.
	MetricDefinitions []MetricDefinition

	// The registry path of the Docker image that contains the training algorithm. For
	// information about docker registry paths for SageMaker built-in algorithms, see
	// Docker Registry Paths and Example Code
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html)
	// in the Amazon SageMaker developer guide. SageMaker supports both
	// registry/repository[:tag] and registry/repository[@digest] image path formats.
	// For more information about using your custom training container, see Using Your
	// Own Algorithms with Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html). You must
	// specify either the algorithm name to the AlgorithmName parameter or the image
	// URI of the algorithm container to the TrainingImage parameter. For more
	// information, see the note in the AlgorithmName parameter description.
	TrainingImage *string

	noSmithyDocumentSerde
}

// Specifies the validation and image scan statuses of the algorithm.
type AlgorithmStatusDetails struct {

	// The status of the scan of the algorithm's Docker image container.
	ImageScanStatuses []AlgorithmStatusItem

	// The status of algorithm validation.
	ValidationStatuses []AlgorithmStatusItem

	noSmithyDocumentSerde
}

// Represents the overall status of an algorithm.
type AlgorithmStatusItem struct {

	// The name of the algorithm for which the overall status is being reported.
	//
	// This member is required.
	Name *string

	// The current status.
	//
	// This member is required.
	Status DetailedAlgorithmStatus

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Provides summary information about an algorithm.
type AlgorithmSummary struct {

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// This member is required.
	AlgorithmArn *string

	// The name of the algorithm that is described by the summary.
	//
	// This member is required.
	AlgorithmName *string

	// The overall status of the algorithm.
	//
	// This member is required.
	AlgorithmStatus AlgorithmStatus

	// A timestamp that shows when the algorithm was created.
	//
	// This member is required.
	CreationTime *time.Time

	// A brief description of the algorithm.
	AlgorithmDescription *string

	noSmithyDocumentSerde
}

// Defines a training job and a batch transform job that SageMaker runs to validate
// your algorithm. The data provided in the validation profile is made available to
// your buyers on Amazon Web Services Marketplace.
type AlgorithmValidationProfile struct {

	// The name of the profile for the algorithm. The name must have 1 to 63
	// characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// This member is required.
	ProfileName *string

	// The TrainingJobDefinition object that describes the training job that SageMaker
	// runs to validate your algorithm.
	//
	// This member is required.
	TrainingJobDefinition *TrainingJobDefinition

	// The TransformJobDefinition object that describes the transform job that
	// SageMaker runs to validate your algorithm.
	TransformJobDefinition *TransformJobDefinition

	noSmithyDocumentSerde
}

// Specifies configurations for one or more training jobs that SageMaker runs to
// test the algorithm.
type AlgorithmValidationSpecification struct {

	// An array of AlgorithmValidationProfile objects, each of which specifies a
	// training job and batch transform job that SageMaker runs to validate your
	// algorithm.
	//
	// This member is required.
	ValidationProfiles []AlgorithmValidationProfile

	// The IAM roles that SageMaker uses to run the training jobs.
	//
	// This member is required.
	ValidationRole *string

	noSmithyDocumentSerde
}

// Configures how labels are consolidated across human workers and processes output
// data.
type AnnotationConsolidationConfig struct {

	// The Amazon Resource Name (ARN) of a Lambda function implements the logic for
	// annotation consolidation
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html)
	// and to process output data. This parameter is required for all labeling jobs.
	// For built-in task types
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html), use one
	// of the following Amazon SageMaker Ground Truth Lambda function ARNs for
	// AnnotationConsolidationLambdaArn. For custom labeling workflows, see
	// Post-annotation Lambda
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda).
	// Bounding box - Finds the most similar boxes from different workers based on the
	// Jaccard index of the boxes.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox
	//
	// Image
	// classification - Uses a variant of the Expectation Maximization approach to
	// estimate the true class of an image based on annotations from individual
	// workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass
	//
	// Multi-label
	// image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true classes of an image based on annotations from individual
	// workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel
	//
	// Semantic
	// segmentation - Treats each pixel in an image as a multi-class classification and
	// treats pixel annotations from workers as "votes" for the correct label.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation
	//
	// Text
	// classification - Uses a variant of the Expectation Maximization approach to
	// estimate the true class of text based on annotations from individual workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass
	//
	// Multi-label
	// text classification - Uses a variant of the Expectation Maximization approach to
	// estimate the true classes of text based on annotations from individual
	// workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel
	//
	// Named
	// entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition
	//
	// Video
	// Classification - Use this task type when you need workers to classify videos
	// using predefined labels that you specify. Workers are shown videos and are asked
	// to choose one label for each video.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass
	//
	// Video
	// Frame Object Detection - Use this task type to have workers identify and locate
	// objects in a sequence of video frames (images extracted from a video) using
	// bounding boxes. For example, you can use this task to ask workers to identify
	// and localize various objects in a series of video frames, such as cars, bikes,
	// and pedestrians.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection
	//
	// Video
	// Frame Object Tracking - Use this task type to have workers track the movement of
	// objects in a sequence of video frames (images extracted from a video) using
	// bounding boxes. For example, you can use this task to ask workers to track the
	// movement of objects, such as cars, bikes, and pedestrians.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking
	//
	// 3D
	// Point Cloud Object Detection - Use this task type when you want workers to
	// classify objects in a 3D point cloud by drawing 3D cuboids around objects. For
	// example, you can use this task type to ask workers to identify different types
	// of objects in a point cloud, such as cars, bikes, and pedestrians.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection
	//
	// 3D
	// Point Cloud Object Tracking - Use this task type when you want workers to draw
	// 3D cuboids around objects that appear in a sequence of 3D point cloud frames.
	// For example, you can use this task type to ask workers to track the movement of
	// vehicles across multiple point cloud frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking
	//
	// 3D
	// Point Cloud Semantic Segmentation - Use this task type when you want workers to
	// create a point-level semantic segmentation masks by painting objects in a 3D
	// point cloud using different colors where each color is assigned to one of the
	// classes you specify.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation
	//
	// Use
	// the following ARNs for Label Verification and Adjustment Jobs Use label
	// verification and adjustment jobs to review and adjust labels. To learn more, see
	// Verify and Adjust Labels
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
	// Semantic Segmentation Adjustment - Treats each pixel in an image as a
	// multi-class classification and treats pixel adjusted annotations from workers as
	// "votes" for the correct label.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation
	//
	// Semantic
	// Segmentation Verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgment for semantic
	// segmentation labels based on annotations from individual workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation
	//
	// Bounding
	// Box Adjustment - Finds the most similar boxes from different workers based on
	// the Jaccard index of the adjusted annotations.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox
	//
	// Bounding
	// Box Verification - Uses a variant of the Expectation Maximization approach to
	// estimate the true class of verification judgement for bounding box labels based
	// on annotations from individual workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox
	//
	// Video
	// Frame Object Detection Adjustment - Use this task type when you want workers to
	// adjust bounding boxes that workers have added to video frames to classify and
	// localize objects in a sequence of video frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection
	//
	// Video
	// Frame Object Tracking Adjustment - Use this task type when you want workers to
	// adjust bounding boxes that workers have added to video frames to track object
	// movement across a sequence of video frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking
	//
	// 3D
	// Point Cloud Object Detection Adjustment - Use this task type when you want
	// workers to adjust 3D cuboids around objects in a 3D point cloud.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// 3D
	// Point Cloud Object Tracking Adjustment - Use this task type when you want
	// workers to adjust 3D cuboids around objects that appear in a sequence of 3D
	// point cloud frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// 3D
	// Point Cloud Semantic Segmentation Adjustment - Use this task type when you want
	// workers to adjust a point-level semantic segmentation masks using a paint
	// tool.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// This member is required.
	AnnotationConsolidationLambdaArn *string

	noSmithyDocumentSerde
}

// Details about an Amazon SageMaker app.
type AppDetails struct {

	// The name of the app.
	AppName *string

	// The type of app.
	AppType AppType

	// The creation time.
	CreationTime *time.Time

	// The domain ID.
	DomainId *string

	// The status.
	Status AppStatus

	// The user profile name.
	UserProfileName *string

	noSmithyDocumentSerde
}

// The configuration for running a SageMaker image as a KernelGateway app.
type AppImageConfigDetails struct {

	// The Amazon Resource Name (ARN) of the AppImageConfig.
	AppImageConfigArn *string

	// The name of the AppImageConfig. Must be unique to your account.
	AppImageConfigName *string

	// When the AppImageConfig was created.
	CreationTime *time.Time

	// The configuration for the file system and kernels in the SageMaker image.
	KernelGatewayImageConfig *KernelGatewayImageConfig

	// When the AppImageConfig was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Configuration to run a processing job in a specified container image.
type AppSpecification struct {

	// The container image to be run by the processing job.
	//
	// This member is required.
	ImageUri *string

	// The arguments for a container used to run a processing job.
	ContainerArguments []string

	// The entrypoint for a container used to run a processing job.
	ContainerEntrypoint []string

	noSmithyDocumentSerde
}

// A structure describing the source of an artifact.
type ArtifactSource struct {

	// The URI of the source.
	//
	// This member is required.
	SourceUri *string

	// A list of source types.
	SourceTypes []ArtifactSourceType

	noSmithyDocumentSerde
}

// The ID and ID type of an artifact source.
type ArtifactSourceType struct {

	// The type of ID.
	//
	// This member is required.
	SourceIdType ArtifactSourceIdType

	// The ID.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Lists a summary of the properties of an artifact. An artifact represents a URI
// addressable object or data. Some examples are a dataset and a model.
type ArtifactSummary struct {

	// The Amazon Resource Name (ARN) of the artifact.
	ArtifactArn *string

	// The name of the artifact.
	ArtifactName *string

	// The type of the artifact.
	ArtifactType *string

	// When the artifact was created.
	CreationTime *time.Time

	// When the artifact was last modified.
	LastModifiedTime *time.Time

	// The source of the artifact.
	Source *ArtifactSource

	noSmithyDocumentSerde
}

// Lists a summary of the properties of an association. An association is an entity
// that links other lineage or experiment entities. An example would be an
// association between a training job and a model.
type AssociationSummary struct {

	// The type of the association.
	AssociationType AssociationEdgeType

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// When the association was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the destination.
	DestinationArn *string

	// The name of the destination.
	DestinationName *string

	// The destination type.
	DestinationType *string

	// The ARN of the source.
	SourceArn *string

	// The name of the source.
	SourceName *string

	// The source type.
	SourceType *string

	noSmithyDocumentSerde
}

// Configures the behavior of the client used by SageMaker to interact with the
// model container during asynchronous inference.
type AsyncInferenceClientConfig struct {

	// The maximum number of concurrent requests sent by the SageMaker client to the
	// model container. If no value is provided, SageMaker chooses an optimal value.
	MaxConcurrentInvocationsPerInstance *int32

	noSmithyDocumentSerde
}

// Specifies configuration for how an endpoint performs asynchronous inference.
type AsyncInferenceConfig struct {

	// Specifies the configuration for asynchronous inference invocation outputs.
	//
	// This member is required.
	OutputConfig *AsyncInferenceOutputConfig

	// Configures the behavior of the client used by SageMaker to interact with the
	// model container during asynchronous inference.
	ClientConfig *AsyncInferenceClientConfig

	noSmithyDocumentSerde
}

// Specifies the configuration for notifications of inference results for
// asynchronous inference.
type AsyncInferenceNotificationConfig struct {

	// Amazon SNS topic to post a notification to when inference fails. If no topic is
	// provided, no notification is sent on failure.
	ErrorTopic *string

	// Amazon SNS topic to post a notification to when inference completes
	// successfully. If no topic is provided, no notification is sent on success.
	SuccessTopic *string

	noSmithyDocumentSerde
}

// Specifies the configuration for asynchronous inference invocation outputs.
type AsyncInferenceOutputConfig struct {

	// The Amazon S3 location to upload inference responses to.
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
	KmsKeyId *string

	// Specifies the configuration for notifications of inference results for
	// asynchronous inference.
	NotificationConfig *AsyncInferenceNotificationConfig

	noSmithyDocumentSerde
}

// Configuration for Athena Dataset Definition input.
type AthenaDatasetDefinition struct {

	// The name of the data catalog used in Athena query execution.
	//
	// This member is required.
	Catalog *string

	// The name of the database used in the Athena query execution.
	//
	// This member is required.
	Database *string

	// The data storage format for Athena query results.
	//
	// This member is required.
	OutputFormat AthenaResultFormat

	// The location in Amazon S3 where Athena query results are stored.
	//
	// This member is required.
	OutputS3Uri *string

	// The SQL query statements, to be executed.
	//
	// This member is required.
	QueryString *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data generated from an Athena query
	// execution.
	KmsKeyId *string

	// The compression used for Athena query results.
	OutputCompression AthenaResultCompressionType

	// The name of the workgroup in which the Athena query is being started.
	WorkGroup *string

	noSmithyDocumentSerde
}

// Information about a candidate produced by an AutoML training job, including its
// status, steps, and other properties.
type AutoMLCandidate struct {

	// The name of the candidate.
	//
	// This member is required.
	CandidateName *string

	// The candidate's status.
	//
	// This member is required.
	CandidateStatus CandidateStatus

	// Information about the candidate's steps.
	//
	// This member is required.
	CandidateSteps []AutoMLCandidateStep

	// The creation time.
	//
	// This member is required.
	CreationTime *time.Time

	// The last modified time.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The objective's status.
	//
	// This member is required.
	ObjectiveStatus ObjectiveStatus

	// The properties of an AutoML candidate job.
	CandidateProperties *CandidateProperties

	// The end time.
	EndTime *time.Time

	// The failure reason.
	FailureReason *string

	// The best candidate result from an AutoML training job.
	FinalAutoMLJobObjectiveMetric *FinalAutoMLJobObjectiveMetric

	// Information about the inference container definitions.
	InferenceContainers []AutoMLContainerDefinition

	noSmithyDocumentSerde
}

// Stores the config information for how a candidate is generated (optional).
type AutoMLCandidateGenerationConfig struct {

	// A URL to the Amazon S3 data source containing selected features from the input
	// data source to run an Autopilot job (optional). This file should be in json
	// format as shown below: { "FeatureAttributeNames":["col1", "col2", ...] }. The
	// key name FeatureAttributeNames is fixed. The values listed in ["col1", "col2",
	// ...] is case sensitive and should be a list of strings containing unique values
	// that are a subset of the column names in the input data. The list of columns
	// provided must not include the target column.
	FeatureSpecificationS3Uri *string

	noSmithyDocumentSerde
}

// Information about the steps for a candidate and what step it is working on.
type AutoMLCandidateStep struct {

	// The ARN for the candidate's step.
	//
	// This member is required.
	CandidateStepArn *string

	// The name for the candidate's step.
	//
	// This member is required.
	CandidateStepName *string

	// Whether the candidate is at the transform, training, or processing step.
	//
	// This member is required.
	CandidateStepType CandidateStepType

	noSmithyDocumentSerde
}

// A channel is a named input source that training algorithms can consume. The
// validation dataset size is limited to less than 2 GB. The training dataset size
// must be less than 100 GB. For more information, see . A validation dataset must
// contain the same headers as the training dataset.
type AutoMLChannel struct {

	// The data source for an AutoML channel.
	//
	// This member is required.
	DataSource *AutoMLDataSource

	// The name of the target variable in supervised learning, usually represented by
	// 'y'.
	//
	// This member is required.
	TargetAttributeName *string

	// The channel type (optional) is an enum string. The default value is training.
	// Channels for training and validation must share the same ContentType and
	// TargetAttributeName. For information on specifying training and validation
	// channel types, see How to specify training and validation datasets
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-data-sources-training-or-validation).
	ChannelType AutoMLChannelType

	// You can use Gzip or None. The default value is None.
	CompressionType CompressionType

	// The content type of the data from the input source. You can use
	// text/csv;header=present or x-application/vnd.amazon+parquet. The default value
	// is text/csv;header=present.
	ContentType *string

	noSmithyDocumentSerde
}

// A list of container definitions that describe the different containers that make
// up an AutoML candidate. For more information, see .
type AutoMLContainerDefinition struct {

	// The Amazon Elastic Container Registry (Amazon ECR) path of the container. For
	// more information, see .
	//
	// This member is required.
	Image *string

	// The location of the model artifacts. For more information, see .
	//
	// This member is required.
	ModelDataUrl *string

	// The environment variables to set in the container. For more information, see .
	Environment map[string]string

	noSmithyDocumentSerde
}

// The data source for the Autopilot job.
type AutoMLDataSource struct {

	// The Amazon S3 location of the input data.
	//
	// This member is required.
	S3DataSource *AutoMLS3DataSource

	noSmithyDocumentSerde
}

// This structure specifies how to split the data into train and validation
// datasets. The validation and training datasets must contain the same headers.
// The validation dataset must be less than 2 GB in size.
type AutoMLDataSplitConfig struct {

	// The validation fraction (optional) is a float that specifies the portion of the
	// training dataset to be used for validation. The default value is 0.2, and values
	// must be greater than 0 and less than 1. We recommend setting this value to be
	// less than 0.5.
	ValidationFraction *float32

	noSmithyDocumentSerde
}

// The artifacts that are generated during an AutoML job.
type AutoMLJobArtifacts struct {

	// The URL of the notebook location.
	CandidateDefinitionNotebookLocation *string

	// The URL of the notebook location.
	DataExplorationNotebookLocation *string

	noSmithyDocumentSerde
}

// How long a job is allowed to run, or how many candidates a job is allowed to
// generate.
type AutoMLJobCompletionCriteria struct {

	// The maximum runtime, in seconds, an AutoML job has to complete. If an AutoML job
	// exceeds the maximum runtime, the job is stopped automatically and its processing
	// is ended gracefully. The AutoML job identifies the best model whose training was
	// completed and marks it as the best-performing model. Any unfinished steps of the
	// job, such as automatic one-click Autopilot model deployment, will not be
	// completed.
	MaxAutoMLJobRuntimeInSeconds *int32

	// The maximum number of times a training job is allowed to run.
	MaxCandidates *int32

	// The maximum time, in seconds, that each training job is allowed to run as part
	// of a hyperparameter tuning job. For more information, see the used by the
	// action.
	MaxRuntimePerTrainingJobInSeconds *int32

	noSmithyDocumentSerde
}

// A collection of settings used for an AutoML job.
type AutoMLJobConfig struct {

	// The configuration for generating a candidate for an AutoML job (optional).
	CandidateGenerationConfig *AutoMLCandidateGenerationConfig

	// How long an AutoML job is allowed to run, or how many candidates a job is
	// allowed to generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	// The configuration for splitting the input training dataset. Type:
	// AutoMLDataSplitConfig
	DataSplitConfig *AutoMLDataSplitConfig

	// The security configuration for traffic encryption or Amazon VPC settings.
	SecurityConfig *AutoMLSecurityConfig

	noSmithyDocumentSerde
}

// Specifies a metric to minimize or maximize as the objective of a job.
type AutoMLJobObjective struct {

	// The name of the objective metric used to measure the predictive quality of a
	// machine learning system. This metric is optimized during training to provide the
	// best estimate for model parameter values from data. Here are the options:
	//
	// *
	// MSE: The mean squared error (MSE) is the average of the squared differences
	// between the predicted and actual values. It is used for regression. MSE values
	// are always positive: the better a model is at predicting the actual values, the
	// smaller the MSE value is. When the data contains outliers, they tend to dominate
	// the MSE, which might cause subpar prediction performance.
	//
	// * Accuracy: The ratio
	// of the number of correctly classified items to the total number of (correctly
	// and incorrectly) classified items. It is used for binary and multiclass
	// classification. It measures how close the predicted class values are to the
	// actual values. Accuracy values vary between zero and one: one indicates perfect
	// accuracy and zero indicates perfect inaccuracy.
	//
	// * F1: The F1 score is the
	// harmonic mean of the precision and recall. It is used for binary classification
	// into classes traditionally referred to as positive and negative. Predictions are
	// said to be true when they match their actual (correct) class and false when they
	// do not. Precision is the ratio of the true positive predictions to all positive
	// predictions (including the false positives) in a data set and measures the
	// quality of the prediction when it predicts the positive class. Recall (or
	// sensitivity) is the ratio of the true positive predictions to all actual
	// positive instances and measures how completely a model predicts the actual class
	// members in a data set. The standard F1 score weighs precision and recall
	// equally. But which metric is paramount typically depends on specific aspects of
	// a problem. F1 scores vary between zero and one: one indicates the best possible
	// performance and zero the worst.
	//
	// * AUC: The area under the curve (AUC) metric is
	// used to compare and evaluate binary classification by algorithms such as
	// logistic regression that return probabilities. A threshold is needed to map the
	// probabilities into classifications. The relevant curve is the receiver operating
	// characteristic curve that plots the true positive rate (TPR) of predictions (or
	// recall) against the false positive rate (FPR) as a function of the threshold
	// value, above which a prediction is considered positive. Increasing the threshold
	// results in fewer false positives but more false negatives. AUC is the area under
	// this receiver operating characteristic curve and so provides an aggregated
	// measure of the model performance across all possible classification thresholds.
	// The AUC score can also be interpreted as the probability that a randomly
	// selected positive data point is more likely to be predicted positive than a
	// randomly selected negative example. AUC scores vary between zero and one: a
	// score of one indicates perfect accuracy and a score of one half indicates that
	// the prediction is not better than a random classifier. Values under one half
	// predict less accurately than a random predictor. But such consistently bad
	// predictors can simply be inverted to obtain better than random predictors.
	//
	// *
	// F1macro: The F1macro score applies F1 scoring to multiclass classification. In
	// this context, you have multiple classes to predict. You just calculate the
	// precision and recall for each class as you did for the positive class in binary
	// classification. Then, use these values to calculate the F1 score for each class
	// and average them to obtain the F1macro score. F1macro scores vary between zero
	// and one: one indicates the best possible performance and zero the worst.
	//
	// If you
	// do not specify a metric explicitly, the default behavior is to automatically
	// use:
	//
	// * MSE: for regression.
	//
	// * F1: for binary classification
	//
	// * Accuracy: for
	// multiclass classification.
	//
	// This member is required.
	MetricName AutoMLMetricEnum

	noSmithyDocumentSerde
}

// Provides a summary about an AutoML job.
type AutoMLJobSummary struct {

	// The ARN of the AutoML job.
	//
	// This member is required.
	AutoMLJobArn *string

	// The name of the AutoML job you are requesting.
	//
	// This member is required.
	AutoMLJobName *string

	// The secondary status of the AutoML job.
	//
	// This member is required.
	AutoMLJobSecondaryStatus AutoMLJobSecondaryStatus

	// The status of the AutoML job.
	//
	// This member is required.
	AutoMLJobStatus AutoMLJobStatus

	// When the AutoML job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// When the AutoML job was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The end time of an AutoML job.
	EndTime *time.Time

	// The failure reason of an AutoML job.
	FailureReason *string

	// The list of reasons for partial failures within an AutoML job.
	PartialFailureReasons []AutoMLPartialFailureReason

	noSmithyDocumentSerde
}

// The output data configuration.
type AutoMLOutputDataConfig struct {

	// The Amazon S3 output path. Must be 128 characters or less.
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Web Services KMS encryption key ID.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The reason for a partial failure of an AutoML job.
type AutoMLPartialFailureReason struct {

	// The message containing the reason for a partial failure of an AutoML job.
	PartialFailureMessage *string

	noSmithyDocumentSerde
}

// The Amazon S3 data source.
type AutoMLS3DataSource struct {

	// The data type. A ManifestFile should have the format shown below: [ {"prefix":
	// "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/DOC-EXAMPLE-PREFIX/"},
	//
	// "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-1",
	//
	//
	// "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-2",
	//
	// ...
	// "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-N" ] An S3Prefix should have
	// the following format: s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER-OR-FILE
	//
	// This member is required.
	S3DataType AutoMLS3DataType

	// The URL to the Amazon S3 data source.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Security options.
type AutoMLSecurityConfig struct {

	// Whether to use traffic encryption between the container layers.
	EnableInterContainerTrafficEncryption bool

	// The key used to encrypt stored data.
	VolumeKmsKeyId *string

	// The VPC configuration.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Automatic rollback configuration for handling endpoint deployment failures and
// recovery.
type AutoRollbackConfig struct {

	// List of CloudWatch alarms in your account that are configured to monitor metrics
	// on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls
	// back the deployment.
	Alarms []Alarm

	noSmithyDocumentSerde
}

// The error code and error description associated with the resource.
type BatchDescribeModelPackageError struct {

	//
	//
	// This member is required.
	ErrorCode *string

	//
	//
	// This member is required.
	ErrorResponse *string

	noSmithyDocumentSerde
}

// Provides summary information about the model package.
type BatchDescribeModelPackageSummary struct {

	// The creation time of the mortgage package summary.
	//
	// This member is required.
	CreationTime *time.Time

	// Defines how to perform inference generation after a training job is run.
	//
	// This member is required.
	InferenceSpecification *InferenceSpecification

	// The Amazon Resource Name (ARN) of the model package.
	//
	// This member is required.
	ModelPackageArn *string

	// The group name for the model package
	//
	// This member is required.
	ModelPackageGroupName *string

	// The status of the mortgage package.
	//
	// This member is required.
	ModelPackageStatus ModelPackageStatus

	// The approval status of the model.
	ModelApprovalStatus ModelApprovalStatus

	// The description of the model package.
	ModelPackageDescription *string

	// The version number of a versioned model.
	ModelPackageVersion *int32

	noSmithyDocumentSerde
}

// Contains bias metrics for a model.
type Bias struct {

	// The post-training bias report for a model.
	PostTrainingReport *MetricsSource

	// The pre-training bias report for a model.
	PreTrainingReport *MetricsSource

	// The bias report for a model
	Report *MetricsSource

	noSmithyDocumentSerde
}

// Update policy for a blue/green deployment. If this update policy is specified,
// SageMaker creates a new fleet during the deployment while maintaining the old
// fleet. SageMaker flips traffic to the new fleet according to the specified
// traffic routing configuration. Only one update policy should be used in the
// deployment configuration. If no update policy is specified, SageMaker uses a
// blue/green deployment strategy with all at once traffic shifting by default.
type BlueGreenUpdatePolicy struct {

	// Defines the traffic routing strategy to shift traffic from the old fleet to the
	// new fleet during an endpoint deployment.
	//
	// This member is required.
	TrafficRoutingConfiguration *TrafficRoutingConfig

	// Maximum execution timeout for the deployment. Note that the timeout value should
	// be larger than the total waiting time specified in TerminationWaitInSeconds and
	// WaitIntervalInSeconds.
	MaximumExecutionTimeoutInSeconds *int32

	// Additional waiting time in seconds after the completion of an endpoint
	// deployment before terminating the old endpoint fleet. Default is 0.
	TerminationWaitInSeconds *int32

	noSmithyDocumentSerde
}

// Details on the cache hit of a pipeline execution step.
type CacheHitResult struct {

	// The Amazon Resource Name (ARN) of the pipeline execution.
	SourcePipelineExecutionArn *string

	noSmithyDocumentSerde
}

// Metadata about a callback step.
type CallbackStepMetadata struct {

	// The pipeline generated token from the Amazon SQS queue.
	CallbackToken *string

	// A list of the output parameters of the callback step.
	OutputParameters []OutputParameter

	// The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the
	// callback step.
	SqsQueueUrl *string

	noSmithyDocumentSerde
}

// The location of artifacts for an AutoML candidate job.
type CandidateArtifactLocations struct {

	// The Amazon S3 prefix to the explainability artifacts generated for the AutoML
	// candidate.
	//
	// This member is required.
	Explainability *string

	// The Amazon S3 prefix to the model insight artifacts generated for the AutoML
	// candidate.
	ModelInsights *string

	noSmithyDocumentSerde
}

// The properties of an AutoML candidate job.
type CandidateProperties struct {

	// The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
	CandidateArtifactLocations *CandidateArtifactLocations

	// Information about the candidate metrics for an AutoML job.
	CandidateMetrics []MetricDatum

	noSmithyDocumentSerde
}

// Specifies the endpoint capacity to activate for production.
type CapacitySize struct {

	// Specifies the endpoint capacity type.
	//
	// * INSTANCE_COUNT: The endpoint activates
	// based on the number of instances.
	//
	// * CAPACITY_PERCENT: The endpoint activates
	// based on the specified percentage of capacity.
	//
	// This member is required.
	Type CapacitySizeType

	// Defines the capacity size, either as a number of instances or a capacity
	// percentage.
	//
	// This member is required.
	Value *int32

	noSmithyDocumentSerde
}

// Configuration specifying how to treat different headers. If no headers are
// specified SageMaker will by default base64 encode when capturing the data.
type CaptureContentTypeHeader struct {

	// The list of all content type headers that SageMaker will treat as CSV and
	// capture accordingly.
	CsvContentTypes []string

	// The list of all content type headers that SageMaker will treat as JSON and
	// capture accordingly.
	JsonContentTypes []string

	noSmithyDocumentSerde
}

// Specifies data Model Monitor will capture.
type CaptureOption struct {

	// Specify the boundary of data to capture.
	//
	// This member is required.
	CaptureMode CaptureMode

	noSmithyDocumentSerde
}

// Environment parameters you want to benchmark your load test against.
type CategoricalParameter struct {

	// The Name of the environment variable.
	//
	// This member is required.
	Name *string

	// The list of values you can pass.
	//
	// This member is required.
	Value []string

	noSmithyDocumentSerde
}

// A list of categorical hyperparameters to tune.
type CategoricalParameterRange struct {

	// The name of the categorical hyperparameter to tune.
	//
	// This member is required.
	Name *string

	// A list of the categories for the hyperparameter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Defines the possible values for a categorical hyperparameter.
type CategoricalParameterRangeSpecification struct {

	// The allowed categories for the hyperparameter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A channel is a named input source that training algorithms can consume.
type Channel struct {

	// The name of the channel.
	//
	// This member is required.
	ChannelName *string

	// The location of the channel data.
	//
	// This member is required.
	DataSource *DataSource

	// If training data is compressed, the compression type. The default value is None.
	// CompressionType is used only in Pipe input mode. In File mode, leave this field
	// unset or set it to None.
	CompressionType CompressionType

	// The MIME type of the data.
	ContentType *string

	// (Optional) The input mode to use for the data channel in a training job. If you
	// don't set a value for InputMode, SageMaker uses the value set for
	// TrainingInputMode. Use this parameter to override the TrainingInputMode setting
	// in a AlgorithmSpecification request when you have a channel that needs a
	// different input mode from the training job's general setting. To download the
	// data from Amazon Simple Storage Service (Amazon S3) to the provisioned ML
	// storage volume, and mount the directory to a Docker volume, use File input mode.
	// To stream data directly from Amazon S3 to the container, choose Pipe input mode.
	// To use a model for incremental training, choose File input model.
	InputMode TrainingInputMode

	// Specify RecordIO as the value when input data is in raw format but the training
	// algorithm requires the RecordIO format. In this case, SageMaker wraps each
	// individual S3 object in a RecordIO record. If the input data is already in
	// RecordIO format, you don't need to set this attribute. For more information, see
	// Create a Dataset Using RecordIO
	// (https://mxnet.apache.org/api/architecture/note_data_loading#data-format). In
	// File mode, leave this field unset or set it to None.
	RecordWrapperType RecordWrapper

	// A configuration for a shuffle option for input data in a channel. If you use
	// S3Prefix for S3DataType, this shuffles the results of the S3 key prefix matches.
	// If you use ManifestFile, the order of the S3 object references in the
	// ManifestFile is shuffled. If you use AugmentedManifestFile, the order of the
	// JSON lines in the AugmentedManifestFile is shuffled. The shuffling order is
	// determined using the Seed value. For Pipe input mode, shuffling is done at the
	// start of every epoch. With large datasets this ensures that the order of the
	// training data is different for each epoch, it helps reduce bias and possible
	// overfitting. In a multi-node training job when ShuffleConfig is combined with
	// S3DataDistributionType of ShardedByS3Key, the data is shuffled across nodes so
	// that the content sent to a particular node on the first epoch might be sent to a
	// different node on the second epoch.
	ShuffleConfig *ShuffleConfig

	noSmithyDocumentSerde
}

// Defines a named input source, called a channel, to be used by an algorithm.
type ChannelSpecification struct {

	// The name of the channel.
	//
	// This member is required.
	Name *string

	// The supported MIME types for the data.
	//
	// This member is required.
	SupportedContentTypes []string

	// The allowed input mode, either FILE or PIPE. In FILE mode, Amazon SageMaker
	// copies the data from the input source onto the local Amazon Elastic Block Store
	// (Amazon EBS) volumes before starting your training algorithm. This is the most
	// commonly used input mode. In PIPE mode, Amazon SageMaker streams input data from
	// the source directly to your algorithm without using the EBS volume.
	//
	// This member is required.
	SupportedInputModes []TrainingInputMode

	// A brief description of the channel.
	Description *string

	// Indicates whether the channel is required by the algorithm.
	IsRequired bool

	// The allowed compression types, if data compression is used.
	SupportedCompressionTypes []CompressionType

	noSmithyDocumentSerde
}

// Contains information about the output location for managed spot training
// checkpoint data.
type CheckpointConfig struct {

	// Identifies the S3 path where you want SageMaker to store checkpoints. For
	// example, s3://bucket-name/key-name-prefix.
	//
	// This member is required.
	S3Uri *string

	// (Optional) The local directory where checkpoints are written. The default
	// directory is /opt/ml/checkpoints/.
	LocalPath *string

	noSmithyDocumentSerde
}

// The container for the metadata for the ClarifyCheck step. For more information,
// see the topic on ClarifyCheck step
// (https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-clarify-check)
// in the Amazon SageMaker Developer Guide.
type ClarifyCheckStepMetadata struct {

	// The Amazon S3 URI of baseline constraints file to be used for the drift check.
	BaselineUsedForDriftCheckConstraints *string

	// The Amazon S3 URI of the newly calculated baseline constraints file.
	CalculatedBaselineConstraints *string

	// The Amazon Resource Name (ARN) of the check processing job that was run by this
	// step's execution.
	CheckJobArn *string

	// The type of the Clarify Check step
	CheckType *string

	// The model package group name.
	ModelPackageGroupName *string

	// This flag indicates if a newly calculated baseline can be accessed through step
	// properties BaselineUsedForDriftCheckConstraints and
	// BaselineUsedForDriftCheckStatistics. If it is set to False, the previous
	// baseline of the configured check type must also be available. These can be
	// accessed through the BaselineUsedForDriftCheckConstraints property.
	RegisterNewBaseline bool

	// This flag indicates if the drift check against the previous baseline will be
	// skipped or not. If it is set to False, the previous baseline of the configured
	// check type must be available.
	SkipCheck bool

	// The Amazon S3 URI of the violation report if violations are detected.
	ViolationReport *string

	noSmithyDocumentSerde
}

// Specifies summary information about a Git repository.
type CodeRepositorySummary struct {

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// This member is required.
	CodeRepositoryArn *string

	// The name of the Git repository.
	//
	// This member is required.
	CodeRepositoryName *string

	// The date and time that the Git repository was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The date and time that the Git repository was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// Configuration details for the Git repository, including the URL where it is
	// located and the ARN of the Amazon Web Services Secrets Manager secret that
	// contains the credentials used to access the repository.
	GitConfig *GitConfig

	noSmithyDocumentSerde
}

// Use this parameter to configure your Amazon Cognito workforce. A single Cognito
// workforce is created using and corresponds to a single  Amazon Cognito user pool
// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
type CognitoConfig struct {

	// The client ID for your Amazon Cognito user pool.
	//
	// This member is required.
	ClientId *string

	// A  user pool
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html)
	// is a user directory in Amazon Cognito. With a user pool, your users can sign in
	// to your web or mobile app through Amazon Cognito. Your users can also sign in
	// through social identity providers like Google, Facebook, Amazon, or Apple, and
	// through SAML identity providers.
	//
	// This member is required.
	UserPool *string

	noSmithyDocumentSerde
}

// Identifies a Amazon Cognito user group. A user group can be used in on or more
// work teams.
type CognitoMemberDefinition struct {

	// An identifier for an application client. You must create the app client ID using
	// Amazon Cognito.
	//
	// This member is required.
	ClientId *string

	// An identifier for a user group.
	//
	// This member is required.
	UserGroup *string

	// An identifier for a user pool. The user pool must be in the same region as the
	// service that you are calling.
	//
	// This member is required.
	UserPool *string

	noSmithyDocumentSerde
}

// Configuration information for the Debugger output tensor collections.
type CollectionConfiguration struct {

	// The name of the tensor collection. The name must be unique relative to other
	// rule configuration names.
	CollectionName *string

	// Parameter values for the tensor collection. The allowed parameters are "name",
	// "include_regex", "reduction_config", "save_config", "tensor_names", and
	// "save_histogram".
	CollectionParameters map[string]string

	noSmithyDocumentSerde
}

// A summary of a model compilation job.
type CompilationJobSummary struct {

	// The Amazon Resource Name (ARN) of the model compilation job.
	//
	// This member is required.
	CompilationJobArn *string

	// The name of the model compilation job that you want a summary for.
	//
	// This member is required.
	CompilationJobName *string

	// The status of the model compilation job.
	//
	// This member is required.
	CompilationJobStatus CompilationJobStatus

	// The time when the model compilation job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The time when the model compilation job completed.
	CompilationEndTime *time.Time

	// The time when the model compilation job started.
	CompilationStartTime *time.Time

	// The type of device that the model will run on after the compilation job has
	// completed.
	CompilationTargetDevice TargetDevice

	// The type of accelerator that the model will run on after the compilation job has
	// completed.
	CompilationTargetPlatformAccelerator TargetPlatformAccelerator

	// The type of architecture that the model will run on after the compilation job
	// has completed.
	CompilationTargetPlatformArch TargetPlatformArch

	// The type of OS that the model will run on after the compilation job has
	// completed.
	CompilationTargetPlatformOs TargetPlatformOs

	// The time when the model compilation job was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Metadata for a Condition step.
type ConditionStepMetadata struct {

	// The outcome of the Condition step evaluation.
	Outcome ConditionOutcome

	noSmithyDocumentSerde
}

// Describes the container, as part of model definition.
type ContainerDefinition struct {

	// This parameter is ignored for models that contain only a PrimaryContainer. When
	// a ContainerDefinition is part of an inference pipeline, the value of the
	// parameter uniquely identifies the container for the purposes of logging and
	// metrics. For information, see Use Logs and Metrics to Monitor an Inference
	// Pipeline
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html).
	// If you don't specify a value for this parameter for a ContainerDefinition that
	// is part of an inference pipeline, a unique name is automatically assigned based
	// on the position of the ContainerDefinition in the pipeline. If you specify a
	// value for the ContainerHostName for any ContainerDefinition that is part of an
	// inference pipeline, you must specify a value for the ContainerHostName parameter
	// of every ContainerDefinition in that pipeline.
	ContainerHostname *string

	// The environment variables to set in the Docker container. Each key and value in
	// the Environment string to string map can have length of up to 1024. We support
	// up to 16 entries in the map.
	Environment map[string]string

	// The path where inference code is stored. This can be either in Amazon EC2
	// Container Registry or in a Docker registry that is accessible from the same VPC
	// that you configure for your endpoint. If you are using your own custom algorithm
	// instead of an algorithm provided by SageMaker, the inference code must meet
	// SageMaker requirements. SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see Using
	// Your Own Algorithms with Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
	Image *string

	// Specifies whether the model container is in Amazon ECR or a private Docker
	// registry accessible from your Amazon Virtual Private Cloud (VPC). For
	// information about storing containers in a private Docker registry, see Use a
	// Private Docker Registry for Real-Time Inference Containers
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html)
	ImageConfig *ImageConfig

	// The inference specification name in the model package version.
	InferenceSpecificationName *string

	// Whether the container hosts a single model or multiple models.
	Mode ContainerMode

	// The S3 path where the model artifacts, which result from model training, are
	// stored. This path must point to a single gzip compressed tar archive (.tar.gz
	// suffix). The S3 path is required for SageMaker built-in algorithms, but not if
	// you use your own algorithms. For more information on built-in algorithms, see
	// Common Parameters
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// The model artifacts must be in an S3 bucket that is in the same region as the
	// model or endpoint you are creating. If you provide a value for this parameter,
	// SageMaker uses Amazon Web Services Security Token Service to download model
	// artifacts from the S3 path you provide. Amazon Web Services STS is activated in
	// your IAM user account by default. If you previously deactivated Amazon Web
	// Services STS for a region, you need to reactivate Amazon Web Services STS for
	// that region. For more information, see Activating and Deactivating Amazon Web
	// Services STS in an Amazon Web Services Region
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
	// in the Amazon Web Services Identity and Access Management User Guide. If you use
	// a built-in algorithm to create a model, SageMaker requires that you provide a S3
	// path to the model artifacts in ModelDataUrl.
	ModelDataUrl *string

	// The name or Amazon Resource Name (ARN) of the model package to use to create the
	// model.
	ModelPackageName *string

	// Specifies additional configuration for multi-model endpoints.
	MultiModelConfig *MultiModelConfig

	noSmithyDocumentSerde
}

// A structure describing the source of a context.
type ContextSource struct {

	// The URI of the source.
	//
	// This member is required.
	SourceUri *string

	// The ID of the source.
	SourceId *string

	// The type of the source.
	SourceType *string

	noSmithyDocumentSerde
}

// Lists a summary of the properties of a context. A context provides a logical
// grouping of other entities.
type ContextSummary struct {

	// The Amazon Resource Name (ARN) of the context.
	ContextArn *string

	// The name of the context.
	ContextName *string

	// The type of the context.
	ContextType *string

	// When the context was created.
	CreationTime *time.Time

	// When the context was last modified.
	LastModifiedTime *time.Time

	// The source of the context.
	Source *ContextSource

	noSmithyDocumentSerde
}

// A list of continuous hyperparameters to tune.
type ContinuousParameterRange struct {

	// The maximum value for the hyperparameter. The tuning job uses floating-point
	// values between MinValue value and this value for tuning.
	//
	// This member is required.
	MaxValue *string

	// The minimum value for the hyperparameter. The tuning job uses floating-point
	// values between this value and MaxValuefor tuning.
	//
	// This member is required.
	MinValue *string

	// The name of the continuous hyperparameter to tune.
	//
	// This member is required.
	Name *string

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values: Auto SageMaker hyperparameter tuning chooses the
	// best scale for the hyperparameter. Linear Hyperparameter tuning searches the
	// values in the hyperparameter range by using a linear scale. Logarithmic
	// Hyperparameter tuning searches the values in the hyperparameter range by using a
	// logarithmic scale. Logarithmic scaling works only for ranges that have only
	// values greater than 0. ReverseLogarithmic Hyperparameter tuning searches the
	// values in the hyperparameter range by using a reverse logarithmic scale. Reverse
	// logarithmic scaling works only for ranges that are entirely within the range
	// 0<=x<1.0.
	ScalingType HyperParameterScalingType

	noSmithyDocumentSerde
}

// Defines the possible values for a continuous hyperparameter.
type ContinuousParameterRangeSpecification struct {

	// The maximum floating-point value allowed.
	//
	// This member is required.
	MaxValue *string

	// The minimum floating-point value allowed.
	//
	// This member is required.
	MinValue *string

	noSmithyDocumentSerde
}

// A custom SageMaker image. For more information, see Bring your own SageMaker
// image (https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
type CustomImage struct {

	// The name of the AppImageConfig.
	//
	// This member is required.
	AppImageConfigName *string

	// The name of the CustomImage. Must be unique to your account.
	//
	// This member is required.
	ImageName *string

	// The version number of the CustomImage.
	ImageVersionNumber *int32

	noSmithyDocumentSerde
}

// Configuration to control how SageMaker captures inference data.
type DataCaptureConfig struct {

	// Specifies data Model Monitor will capture. You can configure whether to collect
	// only input, only output, or both
	//
	// This member is required.
	CaptureOptions []CaptureOption

	// The Amazon S3 location used to capture the data.
	//
	// This member is required.
	DestinationS3Uri *string

	// The percentage of requests SageMaker will capture. A lower value is recommended
	// for Endpoints with high traffic.
	//
	// This member is required.
	InitialSamplingPercentage *int32

	// Configuration specifying how to treat different headers. If no headers are
	// specified SageMaker will by default base64 encode when capturing the data.
	CaptureContentTypeHeader *CaptureContentTypeHeader

	// Whether data capture should be enabled or disabled (defaults to enabled).
	EnableCapture bool

	// The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service
	// key that SageMaker uses to encrypt data on the storage volume attached to the ML
	// compute instance that hosts the endpoint. The KmsKeyId can be any of the
	// following formats:
	//
	// * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// * Key ARN:
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// *
	// Alias name: alias/ExampleAlias
	//
	// * Alias name ARN:
	// arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The currently active data capture configuration used by your Endpoint.
type DataCaptureConfigSummary struct {

	// Whether data capture is currently functional.
	//
	// This member is required.
	CaptureStatus CaptureStatus

	// The percentage of requests being captured by your Endpoint.
	//
	// This member is required.
	CurrentSamplingPercentage *int32

	// The Amazon S3 location being used to capture the data.
	//
	// This member is required.
	DestinationS3Uri *string

	// Whether data capture is enabled or disabled.
	//
	// This member is required.
	EnableCapture bool

	// The KMS key being used to encrypt the data in Amazon S3.
	//
	// This member is required.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The meta data of the Glue table which serves as data catalog for the
// OfflineStore.
type DataCatalogConfig struct {

	// The name of the Glue table catalog.
	//
	// This member is required.
	Catalog *string

	// The name of the Glue table database.
	//
	// This member is required.
	Database *string

	// The name of the Glue table.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// The data structure used to specify the data to be used for inference in a batch
// transform job and to associate the data that is relevant to the prediction
// results in the output. The input filter provided allows you to exclude input
// data that is not needed for inference in a batch transform job. The output
// filter provided allows you to include input data relevant to interpreting the
// predictions in the output from the job. For more information, see Associate
// Prediction Results with their Corresponding Input Records
// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
type DataProcessing struct {

	// A JSONPath
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators)
	// expression used to select a portion of the input data to pass to the algorithm.
	// Use the InputFilter parameter to exclude fields, such as an ID column, from the
	// input. If you want SageMaker to pass the entire input dataset to the algorithm,
	// accept the default value $. Examples: "$", "$[1:]", "$.features"
	InputFilter *string

	// Specifies the source of the data to join with the transformed data. The valid
	// values are None and Input. The default value is None, which specifies not to
	// join the input with the transformed data. If you want the batch transform job to
	// join the original input data with the transformed data, set JoinSource to Input.
	// You can specify OutputFilter as an additional filter to select a portion of the
	// joined dataset and store it in the output file. For JSON or JSONLines objects,
	// such as a JSON array, SageMaker adds the transformed data to the input JSON
	// object in an attribute called SageMakerOutput. The joined result for JSON must
	// be a key-value pair object. If the input is not a key-value pair object,
	// SageMaker creates a new JSON file. In the new JSON file, and the input data is
	// stored under the SageMakerInput key and the results are stored in
	// SageMakerOutput. For CSV data, SageMaker takes each row as a JSON array and
	// joins the transformed data with the input by appending each transformed row to
	// the end of the input. The joined data has the original input data followed by
	// the transformed data and the output is a CSV file. For information on how
	// joining in applied, see Workflow for Associating Inferences with Input Records
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow).
	JoinSource JoinSource

	// A JSONPath
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators)
	// expression used to select a portion of the joined dataset to save in the output
	// file for a batch transform job. If you want SageMaker to store the entire input
	// dataset in the output file, leave the default value, $. If you specify indexes
	// that aren't within the dimension size of the joined dataset, you get an error.
	// Examples: "$", "$[0,5:]", "$['id','SageMakerOutput']"
	OutputFilter *string

	noSmithyDocumentSerde
}

// Information about the container that a data quality monitoring job runs.
type DataQualityAppSpecification struct {

	// The container image that the data quality monitoring job runs.
	//
	// This member is required.
	ImageUri *string

	// The arguments to send to the container that the monitoring job runs.
	ContainerArguments []string

	// The entrypoint for a container used to run a monitoring job.
	ContainerEntrypoint []string

	// Sets the environment variables in the container that the monitoring job runs.
	Environment map[string]string

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flatted json so that the
	// built-in container can use the converted data. Applicable only for the built-in
	// (first party) containers.
	RecordPreprocessorSourceUri *string

	noSmithyDocumentSerde
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from the
// series of jobs scheduled to collect data periodically.
type DataQualityBaselineConfig struct {

	// The name of the job that performs baselining for the data quality monitoring
	// job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	// The statistics resource for a monitoring job.
	StatisticsResource *MonitoringStatisticsResource

	noSmithyDocumentSerde
}

// The input for the data quality monitoring job. Currently endpoints are supported
// for input.
type DataQualityJobInput struct {

	// Input object for the endpoint
	//
	// This member is required.
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// Configuration for Dataset Definition inputs. The Dataset Definition input must
// specify exactly one of either AthenaDatasetDefinition or
// RedshiftDatasetDefinition types.
type DatasetDefinition struct {

	// Configuration for Athena Dataset Definition input.
	AthenaDatasetDefinition *AthenaDatasetDefinition

	// Whether the generated dataset is FullyReplicated or ShardedByS3Key (default).
	DataDistributionType DataDistributionType

	// Whether to use File or Pipe input mode. In File (default) mode, Amazon SageMaker
	// copies the data from the input source onto the local Amazon Elastic Block Store
	// (Amazon EBS) volumes before starting your training algorithm. This is the most
	// commonly used input mode. In Pipe mode, Amazon SageMaker streams input data from
	// the source directly to your algorithm without using the EBS volume.
	InputMode InputMode

	// The local path where you want Amazon SageMaker to download the Dataset
	// Definition inputs to run a processing job. LocalPath is an absolute path to the
	// input data. This is a required parameter when AppManaged is False (default).
	LocalPath *string

	// Configuration for Redshift Dataset Definition input.
	RedshiftDatasetDefinition *RedshiftDatasetDefinition

	noSmithyDocumentSerde
}

// Describes the location of the channel data.
type DataSource struct {

	// The file system that is associated with a channel.
	FileSystemDataSource *FileSystemDataSource

	// The S3 location of the data source that is associated with a channel.
	S3DataSource *S3DataSource

	noSmithyDocumentSerde
}

// Configuration information for the Debugger hook parameters, metric and tensor
// collections, and storage paths. To learn more about how to configure the
// DebugHookConfig parameter, see Use the SageMaker and Debugger Configuration API
// Operations to Create, Update, and Debug Your Training Job
// (https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
type DebugHookConfig struct {

	// Path to Amazon S3 storage location for metrics and tensors.
	//
	// This member is required.
	S3OutputPath *string

	// Configuration information for Debugger tensor collections. To learn more about
	// how to configure the CollectionConfiguration parameter, see Use the SageMaker
	// and Debugger Configuration API Operations to Create, Update, and Debug Your
	// Training Job
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
	CollectionConfigurations []CollectionConfiguration

	// Configuration information for the Debugger hook parameters.
	HookParameters map[string]string

	// Path to local storage location for metrics and tensors. Defaults to
	// /opt/ml/output/tensors/.
	LocalPath *string

	noSmithyDocumentSerde
}

// Configuration information for SageMaker Debugger rules for debugging. To learn
// more about how to configure the DebugRuleConfiguration parameter, see Use the
// SageMaker and Debugger Configuration API Operations to Create, Update, and Debug
// Your Training Job
// (https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
type DebugRuleConfiguration struct {

	// The name of the rule configuration. It must be unique relative to other rule
	// configuration names.
	//
	// This member is required.
	RuleConfigurationName *string

	// The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
	//
	// This member is required.
	RuleEvaluatorImage *string

	// The instance type to deploy a Debugger custom rule for debugging a training job.
	InstanceType ProcessingInstanceType

	// Path to local storage location for output of rules. Defaults to
	// /opt/ml/processing/output/rule/.
	LocalPath *string

	// Runtime configuration for rule container.
	RuleParameters map[string]string

	// Path to Amazon S3 storage location for rules.
	S3OutputPath *string

	// The size, in GB, of the ML storage volume attached to the processing instance.
	VolumeSizeInGB int32

	noSmithyDocumentSerde
}

// Information about the status of the rule evaluation.
type DebugRuleEvaluationStatus struct {

	// Timestamp when the rule evaluation status was last modified.
	LastModifiedTime *time.Time

	// The name of the rule configuration.
	RuleConfigurationName *string

	// The Amazon Resource Name (ARN) of the rule evaluation job.
	RuleEvaluationJobArn *string

	// Status of the rule evaluation.
	RuleEvaluationStatus RuleEvaluationStatus

	// Details from the rule evaluation.
	StatusDetails *string

	noSmithyDocumentSerde
}

// Gets the Amazon EC2 Container Registry path of the docker image of the model
// that is hosted in this ProductionVariant. If you used the
// registry/repository[:tag] form to specify the image path of the primary
// container when you created the model hosted in this ProductionVariant, the path
// resolves to a path of the form registry/repository[@digest]. A digest is a hash
// value that identifies a specific version of an image. For information about
// Amazon ECR paths, see Pulling an Image
// (https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html)
// in the Amazon ECR User Guide.
type DeployedImage struct {

	// The date and time when the image path for the model resolved to the
	// ResolvedImage
	ResolutionTime *time.Time

	// The specific digest path of the image hosted in this ProductionVariant.
	ResolvedImage *string

	// The image path you specified when you created the model.
	SpecifiedImage *string

	noSmithyDocumentSerde
}

// The deployment configuration for an endpoint, which contains the desired
// deployment strategy and rollback configurations.
type DeploymentConfig struct {

	// Update policy for a blue/green deployment. If this update policy is specified,
	// SageMaker creates a new fleet during the deployment while maintaining the old
	// fleet. SageMaker flips traffic to the new fleet according to the specified
	// traffic routing configuration. Only one update policy should be used in the
	// deployment configuration. If no update policy is specified, SageMaker uses a
	// blue/green deployment strategy with all at once traffic shifting by default.
	//
	// This member is required.
	BlueGreenUpdatePolicy *BlueGreenUpdatePolicy

	// Automatic rollback configuration for handling endpoint deployment failures and
	// recovery.
	AutoRollbackConfiguration *AutoRollbackConfig

	noSmithyDocumentSerde
}

// Contains information about a stage in an edge deployment plan.
type DeploymentStage struct {

	// Configuration of the devices in the stage.
	//
	// This member is required.
	DeviceSelectionConfig *DeviceSelectionConfig

	// The name of the stage.
	//
	// This member is required.
	StageName *string

	// Configuration of the deployment details.
	DeploymentConfig *EdgeDeploymentConfig

	noSmithyDocumentSerde
}

// Contains information summarizing the deployment stage results.
type DeploymentStageStatusSummary struct {

	// Configuration of the deployment details.
	//
	// This member is required.
	DeploymentConfig *EdgeDeploymentConfig

	// General status of the current state.
	//
	// This member is required.
	DeploymentStatus *EdgeDeploymentStatus

	// Configuration of the devices in the stage.
	//
	// This member is required.
	DeviceSelectionConfig *DeviceSelectionConfig

	// The name of the stage.
	//
	// This member is required.
	StageName *string

	noSmithyDocumentSerde
}

// Specifies weight and capacity values for a production variant.
type DesiredWeightAndCapacity struct {

	// The name of the variant to update.
	//
	// This member is required.
	VariantName *string

	// The variant's capacity.
	DesiredInstanceCount *int32

	// The variant's weight.
	DesiredWeight *float32

	noSmithyDocumentSerde
}

// Information of a particular device.
type Device struct {

	// The name of the device.
	//
	// This member is required.
	DeviceName *string

	// Description of the device.
	Description *string

	// Amazon Web Services Internet of Things (IoT) object name.
	IotThingName *string

	noSmithyDocumentSerde
}

// Contains information summarizing device details and deployment status.
type DeviceDeploymentSummary struct {

	// The ARN of the device.
	//
	// This member is required.
	DeviceArn *string

	// The name of the device.
	//
	// This member is required.
	DeviceName *string

	// The ARN of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanArn *string

	// The name of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanName *string

	// The name of the stage in the edge deployment plan.
	//
	// This member is required.
	StageName *string

	// The name of the deployed stage.
	DeployedStageName *string

	// The time when the deployment on the device started.
	DeploymentStartTime *time.Time

	// The description of the device.
	Description *string

	// The deployment status of the device.
	DeviceDeploymentStatus DeviceDeploymentStatus

	// The detailed error message for the deployoment status result.
	DeviceDeploymentStatusMessage *string

	// The name of the fleet to which the device belongs to.
	DeviceFleetName *string

	noSmithyDocumentSerde
}

// Summary of the device fleet.
type DeviceFleetSummary struct {

	// Amazon Resource Name (ARN) of the device fleet.
	//
	// This member is required.
	DeviceFleetArn *string

	// Name of the device fleet.
	//
	// This member is required.
	DeviceFleetName *string

	// Timestamp of when the device fleet was created.
	CreationTime *time.Time

	// Timestamp of when the device fleet was last updated.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains information about the configurations of selected devices.
type DeviceSelectionConfig struct {

	// Type of device subsets to deploy to the current stage.
	//
	// This member is required.
	DeviceSubsetType DeviceSubsetType

	// A filter to select devices with names containing this name.
	DeviceNameContains *string

	// List of devices chosen to deploy.
	DeviceNames []string

	// Percentage of devices in the fleet to deploy to the current stage.
	Percentage int32

	noSmithyDocumentSerde
}

// Status of devices.
type DeviceStats struct {

	// The number of devices connected with a heartbeat.
	//
	// This member is required.
	ConnectedDeviceCount int64

	// The number of registered devices.
	//
	// This member is required.
	RegisteredDeviceCount int64

	noSmithyDocumentSerde
}

// Summary of the device.
type DeviceSummary struct {

	// Amazon Resource Name (ARN) of the device.
	//
	// This member is required.
	DeviceArn *string

	// The unique identifier of the device.
	//
	// This member is required.
	DeviceName *string

	// Edge Manager agent version.
	AgentVersion *string

	// A description of the device.
	Description *string

	// The name of the fleet the device belongs to.
	DeviceFleetName *string

	// The Amazon Web Services Internet of Things (IoT) object thing name associated
	// with the device..
	IotThingName *string

	// The last heartbeat received from the device.
	LatestHeartbeat *time.Time

	// Models on the device.
	Models []EdgeModelSummary

	// The timestamp of the last registration or de-reregistration.
	RegistrationTime *time.Time

	noSmithyDocumentSerde
}

// The domain's details.
type DomainDetails struct {

	// The creation time.
	CreationTime *time.Time

	// The domain's Amazon Resource Name (ARN).
	DomainArn *string

	// The domain ID.
	DomainId *string

	// The domain name.
	DomainName *string

	// The last modified time.
	LastModifiedTime *time.Time

	// The status.
	Status DomainStatus

	// The domain's URL.
	Url *string

	noSmithyDocumentSerde
}

// A collection of settings that apply to the SageMaker Domain. These settings are
// specified through the CreateDomain API call.
type DomainSettings struct {

	// A collection of settings that configure the RStudioServerPro Domain-level app.
	RStudioServerProDomainSettings *RStudioServerProDomainSettings

	// The security groups for the Amazon Virtual Private Cloud that the Domain uses
	// for communication between Domain-level apps and user apps.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// A collection of Domain configuration settings to update.
type DomainSettingsForUpdate struct {

	// A collection of RStudioServerPro Domain-level app settings to update.
	RStudioServerProDomainSettingsForUpdate *RStudioServerProDomainSettingsForUpdate

	noSmithyDocumentSerde
}

// Represents the drift check baselines that can be used when the model monitor is
// set using the model package.
type DriftCheckBaselines struct {

	// Represents the drift check bias baselines that can be used when the model
	// monitor is set using the model package.
	Bias *DriftCheckBias

	// Represents the drift check explainability baselines that can be used when the
	// model monitor is set using the model package.
	Explainability *DriftCheckExplainability

	// Represents the drift check model data quality baselines that can be used when
	// the model monitor is set using the model package.
	ModelDataQuality *DriftCheckModelDataQuality

	// Represents the drift check model quality baselines that can be used when the
	// model monitor is set using the model package.
	ModelQuality *DriftCheckModelQuality

	noSmithyDocumentSerde
}

// Represents the drift check bias baselines that can be used when the model
// monitor is set using the model package.
type DriftCheckBias struct {

	// The bias config file for a model.
	ConfigFile *FileSource

	// The post-training constraints.
	PostTrainingConstraints *MetricsSource

	// The pre-training constraints.
	PreTrainingConstraints *MetricsSource

	noSmithyDocumentSerde
}

// Represents the drift check explainability baselines that can be used when the
// model monitor is set using the model package.
type DriftCheckExplainability struct {

	// The explainability config file for the model.
	ConfigFile *FileSource

	// The drift check explainability constraints.
	Constraints *MetricsSource

	noSmithyDocumentSerde
}

// Represents the drift check data quality baselines that can be used when the
// model monitor is set using the model package.
type DriftCheckModelDataQuality struct {

	// The drift check model data quality constraints.
	Constraints *MetricsSource

	// The drift check model data quality statistics.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// Represents the drift check model quality baselines that can be used when the
// model monitor is set using the model package.
type DriftCheckModelQuality struct {

	// The drift check model quality constraints.
	Constraints *MetricsSource

	// The drift check model quality statistics.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// A directed edge connecting two lineage entities.
type Edge struct {

	// The type of the Association(Edge) between the source and destination. For
	// example ContributedTo, Produced, or DerivedFrom.
	AssociationType AssociationEdgeType

	// The Amazon Resource Name (ARN) of the destination lineage entity of the directed
	// edge.
	DestinationArn *string

	// The Amazon Resource Name (ARN) of the source lineage entity of the directed
	// edge.
	SourceArn *string

	noSmithyDocumentSerde
}

// Contains information about the configuration of a deployment.
type EdgeDeploymentConfig struct {

	// Toggle that determines whether to rollback to previous configuration if the
	// current deployment fails. By default this is turned on. You may turn this off if
	// you want to investigate the errors yourself.
	//
	// This member is required.
	FailureHandlingPolicy FailureHandlingPolicy

	noSmithyDocumentSerde
}

// Contains information about the configuration of a model in a deployment.
type EdgeDeploymentModelConfig struct {

	// The edge packaging job associated with this deployment.
	//
	// This member is required.
	EdgePackagingJobName *string

	// The name the device application uses to reference this model.
	//
	// This member is required.
	ModelHandle *string

	noSmithyDocumentSerde
}

// Contains information summarizing an edge deployment plan.
type EdgeDeploymentPlanSummary struct {

	// The name of the device fleet used for the deployment.
	//
	// This member is required.
	DeviceFleetName *string

	// The number of edge devices that failed the deployment.
	//
	// This member is required.
	EdgeDeploymentFailed int32

	// The number of edge devices yet to pick up the deployment, or in progress.
	//
	// This member is required.
	EdgeDeploymentPending int32

	// The ARN of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanArn *string

	// The name of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanName *string

	// The number of edge devices with the successful deployment.
	//
	// This member is required.
	EdgeDeploymentSuccess int32

	// The time when the edge deployment plan was created.
	CreationTime *time.Time

	// The time when the edge deployment plan was last updated.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains information summarizing the deployment stage results.
type EdgeDeploymentStatus struct {

	// The number of edge devices that failed the deployment in current stage.
	//
	// This member is required.
	EdgeDeploymentFailedInStage int32

	// The number of edge devices yet to pick up the deployment in current stage, or in
	// progress.
	//
	// This member is required.
	EdgeDeploymentPendingInStage int32

	// The number of edge devices with the successful deployment in the current stage.
	//
	// This member is required.
	EdgeDeploymentSuccessInStage int32

	// The general status of the current stage.
	//
	// This member is required.
	StageStatus StageStatus

	// The time when the deployment API started.
	EdgeDeploymentStageStartTime *time.Time

	// A detailed message about deployment status in current stage.
	EdgeDeploymentStatusMessage *string

	noSmithyDocumentSerde
}

// The model on the edge device.
type EdgeModel struct {

	// The name of the model.
	//
	// This member is required.
	ModelName *string

	// The model version.
	//
	// This member is required.
	ModelVersion *string

	// The timestamp of the last inference that was made.
	LatestInference *time.Time

	// The timestamp of the last data sample taken.
	LatestSampleTime *time.Time

	noSmithyDocumentSerde
}

// Status of edge devices with this model.
type EdgeModelStat struct {

	// The number of devices that have this model version, a heart beat, and are
	// currently running.
	//
	// This member is required.
	ActiveDeviceCount int64

	// The number of devices that have this model version and have a heart beat.
	//
	// This member is required.
	ConnectedDeviceCount int64

	// The name of the model.
	//
	// This member is required.
	ModelName *string

	// The model version.
	//
	// This member is required.
	ModelVersion *string

	// The number of devices that have this model version and do not have a heart beat.
	//
	// This member is required.
	OfflineDeviceCount int64

	// The number of devices with this model version and are producing sample data.
	//
	// This member is required.
	SamplingDeviceCount int64

	noSmithyDocumentSerde
}

// Summary of model on edge device.
type EdgeModelSummary struct {

	// The name of the model.
	//
	// This member is required.
	ModelName *string

	// The version model.
	//
	// This member is required.
	ModelVersion *string

	noSmithyDocumentSerde
}

// The output configuration.
type EdgeOutputConfig struct {

	// The Amazon Simple Storage (S3) bucker URI.
	//
	// This member is required.
	S3OutputLocation *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume after
	// compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the
	// default KMS key for Amazon S3 for your role's account.
	KmsKeyId *string

	// The configuration used to create deployment artifacts. Specify configuration
	// options with a JSON string. The available configuration options for each type
	// are:
	//
	// * ComponentName (optional) - Name of the GreenGrass V2 component. If not
	// specified, the default name generated consists of "SagemakerEdgeManager" and the
	// name of your SageMaker Edge Manager packaging job.
	//
	// * ComponentDescription
	// (optional) - Description of the component.
	//
	// * ComponentVersion (optional) - The
	// version of the component. Amazon Web Services IoT Greengrass uses semantic
	// versions for components. Semantic versions follow a major.minor.patch number
	// system. For example, version 1.0.0 represents the first major release for a
	// component. For more information, see the semantic version specification
	// (https://semver.org/).
	//
	// * PlatformOS (optional) - The name of the operating
	// system for the platform. Supported platforms include Windows and Linux.
	//
	// *
	// PlatformArchitecture (optional) - The processor architecture for the platform.
	// Supported architectures Windows include: Windows32_x86, Windows64_x64. Supported
	// architectures for Linux include: Linux x86_64, Linux ARMV8.
	PresetDeploymentConfig *string

	// The deployment type SageMaker Edge Manager will create. Currently only supports
	// Amazon Web Services IoT Greengrass Version 2 components.
	PresetDeploymentType EdgePresetDeploymentType

	noSmithyDocumentSerde
}

// Summary of edge packaging job.
type EdgePackagingJobSummary struct {

	// The Amazon Resource Name (ARN) of the edge packaging job.
	//
	// This member is required.
	EdgePackagingJobArn *string

	// The name of the edge packaging job.
	//
	// This member is required.
	EdgePackagingJobName *string

	// The status of the edge packaging job.
	//
	// This member is required.
	EdgePackagingJobStatus EdgePackagingJobStatus

	// The name of the SageMaker Neo compilation job.
	CompilationJobName *string

	// The timestamp of when the job was created.
	CreationTime *time.Time

	// The timestamp of when the edge packaging job was last updated.
	LastModifiedTime *time.Time

	// The name of the model.
	ModelName *string

	// The version of the model.
	ModelVersion *string

	noSmithyDocumentSerde
}

// The output of a SageMaker Edge Manager deployable resource.
type EdgePresetDeploymentOutput struct {

	// The deployment type created by SageMaker Edge Manager. Currently only supports
	// Amazon Web Services IoT Greengrass Version 2 components.
	//
	// This member is required.
	Type EdgePresetDeploymentType

	// The Amazon Resource Name (ARN) of the generated deployable resource.
	Artifact *string

	// The status of the deployable resource.
	Status EdgePresetDeploymentStatus

	// Returns a message describing the status of the deployed resource.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The configurations and outcomes of an Amazon EMR step execution.
type EMRStepMetadata struct {

	// The identifier of the EMR cluster.
	ClusterId *string

	// The path to the log file where the cluster step's failure root cause is
	// recorded.
	LogFilePath *string

	// The identifier of the EMR cluster step.
	StepId *string

	// The name of the EMR cluster step.
	StepName *string

	noSmithyDocumentSerde
}

// A hosted endpoint for real-time inference.
type Endpoint struct {

	// The time that the endpoint was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The endpoint configuration associated with the endpoint.
	//
	// This member is required.
	EndpointConfigName *string

	// The name of the endpoint.
	//
	// This member is required.
	EndpointName *string

	// The status of the endpoint.
	//
	// This member is required.
	EndpointStatus EndpointStatus

	// The last time the endpoint was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The currently active data capture configuration used by your Endpoint.
	DataCaptureConfig *DataCaptureConfigSummary

	// If the endpoint failed, the reason it failed.
	FailureReason *string

	// A list of monitoring schedules for the endpoint. For information about model
	// monitoring, see Amazon SageMaker Model Monitor
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
	MonitoringSchedules []MonitoringSchedule

	// A list of the production variants hosted on the endpoint. Each production
	// variant is a model.
	ProductionVariants []ProductionVariantSummary

	// A list of the tags associated with the endpoint. For more information, see
	// Tagging Amazon Web Services resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the Amazon
	// Web Services General Reference Guide.
	Tags []Tag

	noSmithyDocumentSerde
}

// Provides summary information for an endpoint configuration.
type EndpointConfigSummary struct {

	// A timestamp that shows when the endpoint configuration was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// This member is required.
	EndpointConfigArn *string

	// The name of the endpoint configuration.
	//
	// This member is required.
	EndpointConfigName *string

	noSmithyDocumentSerde
}

// Input object for the endpoint
type EndpointInput struct {

	// An endpoint in customer's account which has enabled DataCaptureConfig enabled.
	//
	// This member is required.
	EndpointName *string

	// Path to the filesystem where the endpoint data is available to the container.
	//
	// This member is required.
	LocalPath *string

	// If specified, monitoring jobs substract this time from the end time. For
	// information about using offsets for scheduling monitoring jobs, see Schedule
	// Model Quality Monitoring Jobs
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html).
	EndTimeOffset *string

	// The attributes of the input data that are the input features.
	FeaturesAttribute *string

	// The attribute of the input data that represents the ground truth label.
	InferenceAttribute *string

	// In a classification problem, the attribute that represents the class
	// probability.
	ProbabilityAttribute *string

	// The threshold for the class probability to be evaluated as a positive result.
	ProbabilityThresholdAttribute *float64

	// Whether input data distributed in Amazon S3 is fully replicated or sharded by an
	// S3 key. Defaults to FullyReplicated
	S3DataDistributionType ProcessingS3DataDistributionType

	// Whether the Pipe or File is used as the input mode for transferring data for the
	// monitoring job. Pipe mode is recommended for large datasets. File mode is useful
	// for small files that fit in memory. Defaults to File.
	S3InputMode ProcessingS3InputMode

	// If specified, monitoring jobs substract this time from the start time. For
	// information about using offsets for scheduling monitoring jobs, see Schedule
	// Model Quality Monitoring Jobs
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html).
	StartTimeOffset *string

	noSmithyDocumentSerde
}

// The endpoint configuration for the load test.
type EndpointInputConfiguration struct {

	// The instance types to use for the load test.
	//
	// This member is required.
	InstanceType ProductionVariantInstanceType

	// The parameter you want to benchmark against.
	EnvironmentParameterRanges *EnvironmentParameterRanges

	// The inference specification name in the model package version.
	InferenceSpecificationName *string

	noSmithyDocumentSerde
}

// The endpoint configuration made by Inference Recommender during a recommendation
// job.
type EndpointOutputConfiguration struct {

	// The name of the endpoint made during a recommendation job.
	//
	// This member is required.
	EndpointName *string

	// The number of instances recommended to launch initially.
	//
	// This member is required.
	InitialInstanceCount int32

	// The instance type recommended by Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	InstanceType ProductionVariantInstanceType

	// The name of the production variant (deployed model) made during a recommendation
	// job.
	//
	// This member is required.
	VariantName *string

	noSmithyDocumentSerde
}

// Provides summary information for an endpoint.
type EndpointSummary struct {

	// A timestamp that shows when the endpoint was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The name of the endpoint.
	//
	// This member is required.
	EndpointName *string

	// The status of the endpoint.
	//
	// * OutOfService: Endpoint is not available to take
	// incoming requests.
	//
	// * Creating: CreateEndpoint is executing.
	//
	// * Updating:
	// UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
	//
	// *
	// SystemUpdating: Endpoint is undergoing maintenance and cannot be updated or
	// deleted or re-scaled until it has completed. This maintenance operation does not
	// change any customer-specified values such as VPC config, KMS encryption, model,
	// instance type, or instance count.
	//
	// * RollingBack: Endpoint fails to scale up or
	// down or change its variant weight and is in the process of rolling back to its
	// previous configuration. Once the rollback completes, endpoint returns to an
	// InService status. This transitional status only applies to an endpoint that has
	// autoscaling enabled and is undergoing variant weight or capacity changes as part
	// of an UpdateEndpointWeightsAndCapacities call or when the
	// UpdateEndpointWeightsAndCapacities operation is called explicitly.
	//
	// * InService:
	// Endpoint is available to process incoming requests.
	//
	// * Deleting: DeleteEndpoint
	// is executing.
	//
	// * Failed: Endpoint could not be created, updated, or re-scaled.
	// Use DescribeEndpointOutput$FailureReason for information about the failure.
	// DeleteEndpoint is the only operation that can be performed on a failed
	// endpoint.
	//
	// To get a list of endpoints with a specified status, use the
	// ListEndpointsInput$StatusEquals filter.
	//
	// This member is required.
	EndpointStatus EndpointStatus

	// A timestamp that shows when the endpoint was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A list of environment parameters suggested by the Amazon SageMaker Inference
// Recommender.
type EnvironmentParameter struct {

	// The environment key suggested by the Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	Key *string

	// The value suggested by the Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	Value *string

	// The value type suggested by the Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	ValueType *string

	noSmithyDocumentSerde
}

// Specifies the range of environment parameters
type EnvironmentParameterRanges struct {

	// Specified a list of parameters for each category.
	CategoricalParameterRanges []CategoricalParameter

	noSmithyDocumentSerde
}

// The properties of an experiment as returned by the Search API.
type Experiment struct {

	// Who created the experiment.
	CreatedBy *UserContext

	// When the experiment was created.
	CreationTime *time.Time

	// The description of the experiment.
	Description *string

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string

	// The name of the experiment.
	ExperimentName *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// When the experiment was last modified.
	LastModifiedTime *time.Time

	// The source of the experiment.
	Source *ExperimentSource

	// The list of tags that are associated with the experiment. You can use Search API
	// to search on the tags.
	Tags []Tag

	noSmithyDocumentSerde
}

// Associates a SageMaker job as a trial component with an experiment and trial.
// Specified when you call the following APIs:
//
// * CreateProcessingJob
//
// *
// CreateTrainingJob
//
// * CreateTransformJob
type ExperimentConfig struct {

	// The name of an existing experiment to associate the trial component with.
	ExperimentName *string

	// The display name for the trial component. If this key isn't specified, the
	// display name is the trial component name.
	TrialComponentDisplayName *string

	// The name of an existing trial to associate the trial component with. If not
	// specified, a new trial is created.
	TrialName *string

	noSmithyDocumentSerde
}

// The source of the experiment.
type ExperimentSource struct {

	// The Amazon Resource Name (ARN) of the source.
	//
	// This member is required.
	SourceArn *string

	// The source type.
	SourceType *string

	noSmithyDocumentSerde
}

// A summary of the properties of an experiment. To get the complete set of
// properties, call the DescribeExperiment API and provide the ExperimentName.
type ExperimentSummary struct {

	// When the experiment was created.
	CreationTime *time.Time

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string

	// The name of the experiment.
	ExperimentName *string

	// The source of the experiment.
	ExperimentSource *ExperimentSource

	// When the experiment was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains explainability metrics for a model.
type Explainability struct {

	// The explainability report for a model.
	Report *MetricsSource

	noSmithyDocumentSerde
}

// The container for the metadata for Fail step.
type FailStepMetadata struct {

	// A message that you define and then is processed and rendered by the Fail step
	// when the error occurs.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// A list of features. You must include FeatureName and FeatureType. Valid feature
// FeatureTypes are Integral, Fractional and String.
type FeatureDefinition struct {

	// The name of a feature. The type must be a string. FeatureName cannot be any of
	// the following: is_deleted, write_time, api_invocation_time.
	FeatureName *string

	// The value type of a feature. Valid values are Integral, Fractional, or String.
	FeatureType FeatureType

	noSmithyDocumentSerde
}

// Amazon SageMaker Feature Store stores features in a collection called Feature
// Group. A Feature Group can be visualized as a table which has rows, with a
// unique identifier for each row where each column in the table is a feature. In
// principle, a Feature Group is composed of features and values per features.
type FeatureGroup struct {

	// The time a FeatureGroup was created.
	CreationTime *time.Time

	// A free form description of a FeatureGroup.
	Description *string

	// The name of the feature that stores the EventTime of a Record in a FeatureGroup.
	// A EventTime is point in time when a new event occurs that corresponds to the
	// creation or update of a Record in FeatureGroup. All Records in the FeatureGroup
	// must have a corresponding EventTime.
	EventTimeFeatureName *string

	// The reason that the FeatureGroup failed to be replicated in the OfflineStore.
	// This is failure may be due to a failure to create a FeatureGroup in or delete a
	// FeatureGroup from the OfflineStore.
	FailureReason *string

	// A list of Features. Each Feature must include a FeatureName and a FeatureType.
	// Valid FeatureTypes are Integral, Fractional and String. FeatureNames cannot be
	// any of the following: is_deleted, write_time, api_invocation_time. You can
	// create up to 2,500 FeatureDefinitions per FeatureGroup.
	FeatureDefinitions []FeatureDefinition

	// The Amazon Resource Name (ARN) of a FeatureGroup.
	FeatureGroupArn *string

	// The name of the FeatureGroup.
	FeatureGroupName *string

	// A FeatureGroup status.
	FeatureGroupStatus FeatureGroupStatus

	// A timestamp indicating the last time you updated the feature group.
	LastModifiedTime *time.Time

	// A value that indicates whether the feature group was updated successfully.
	LastUpdateStatus *LastUpdateStatus

	// The configuration of an OfflineStore. Provide an OfflineStoreConfig in a request
	// to CreateFeatureGroup to create an OfflineStore. To encrypt an OfflineStore
	// using at rest data encryption, specify Amazon Web Services Key Management
	// Service (KMS) key ID, or KMSKeyId, in S3StorageConfig.
	OfflineStoreConfig *OfflineStoreConfig

	// The status of OfflineStore.
	OfflineStoreStatus *OfflineStoreStatus

	// Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID,
	// or KMSKeyId, for at rest data encryption. You can turn OnlineStore on or off by
	// specifying the EnableOnlineStore flag at General Assembly; the default value is
	// False.
	OnlineStoreConfig *OnlineStoreConfig

	// The name of the Feature whose value uniquely identifies a Record defined in the
	// FeatureGroupFeatureDefinitions.
	RecordIdentifierFeatureName *string

	// The Amazon Resource Name (ARN) of the IAM execution role used to create the
	// feature group.
	RoleArn *string

	// Tags used to define a FeatureGroup.
	Tags []Tag

	noSmithyDocumentSerde
}

// The name, Arn, CreationTime, FeatureGroup values, LastUpdatedTime and
// EnableOnlineStorage status of a FeatureGroup.
type FeatureGroupSummary struct {

	// A timestamp indicating the time of creation time of the FeatureGroup.
	//
	// This member is required.
	CreationTime *time.Time

	// Unique identifier for the FeatureGroup.
	//
	// This member is required.
	FeatureGroupArn *string

	// The name of FeatureGroup.
	//
	// This member is required.
	FeatureGroupName *string

	// The status of a FeatureGroup. The status can be any of the following: Creating,
	// Created, CreateFail, Deleting or DetailFail.
	FeatureGroupStatus FeatureGroupStatus

	// Notifies you if replicating data into the OfflineStore has failed. Returns
	// either: Active or Blocked.
	OfflineStoreStatus *OfflineStoreStatus

	noSmithyDocumentSerde
}

// The metadata for a feature. It can either be metadata that you specify, or
// metadata that is updated automatically.
type FeatureMetadata struct {

	// A timestamp indicating when the feature was created.
	CreationTime *time.Time

	// An optional description that you specify to better describe the feature.
	Description *string

	// The Amazon Resource Number (ARN) of the feature group.
	FeatureGroupArn *string

	// The name of the feature group containing the feature.
	FeatureGroupName *string

	// The name of feature.
	FeatureName *string

	// The data type of the feature.
	FeatureType FeatureType

	// A timestamp indicating when the feature was last modified.
	LastModifiedTime *time.Time

	// Optional key-value pairs that you specify to better describe the feature.
	Parameters []FeatureParameter

	noSmithyDocumentSerde
}

// A key-value pair that you specify to describe the feature.
type FeatureParameter struct {

	// A key that must contain a value to describe the feature.
	Key *string

	// The value that belongs to a key.
	Value *string

	noSmithyDocumentSerde
}

// Contains details regarding the file source.
type FileSource struct {

	// The Amazon S3 URI for the file source.
	//
	// This member is required.
	S3Uri *string

	// The digest of the file source.
	ContentDigest *string

	// The type of content stored in the file source.
	ContentType *string

	noSmithyDocumentSerde
}

// The Amazon Elastic File System (EFS) storage configuration for a SageMaker
// image.
type FileSystemConfig struct {

	// The default POSIX group ID (GID). If not specified, defaults to 100.
	DefaultGid int32

	// The default POSIX user ID (UID). If not specified, defaults to 1000.
	DefaultUid int32

	// The path within the image to mount the user's EFS home directory. The directory
	// should be empty. If not specified, defaults to /home/sagemaker-user.
	MountPath *string

	noSmithyDocumentSerde
}

// Specifies a file system data source for a channel.
type FileSystemDataSource struct {

	// The full path to the directory to associate with the channel.
	//
	// This member is required.
	DirectoryPath *string

	// The access mode of the mount of the directory associated with the channel. A
	// directory can be mounted either in ro (read-only) or rw (read-write) mode.
	//
	// This member is required.
	FileSystemAccessMode FileSystemAccessMode

	// The file system id.
	//
	// This member is required.
	FileSystemId *string

	// The file system type.
	//
	// This member is required.
	FileSystemType FileSystemType

	noSmithyDocumentSerde
}

// A conditional statement for a search expression that includes a resource
// property, a Boolean operator, and a value. Resources that match the statement
// are returned in the results from the Search API. If you specify a Value, but not
// an Operator, Amazon SageMaker uses the equals operator. In search, there are
// several property types: Metrics To define a metric filter, enter a value using
// the form "Metrics.", where  is a metric name. For example, the following filter
// searches for training jobs with an "accuracy" metric greater than "0.9": {
//
// "Name": "Metrics.accuracy",
//
//     "Operator": "GreaterThan",
//
//     "Value":
// "0.9"
//
// } HyperParameters To define a hyperparameter filter, enter a value with
// the form "HyperParameters.". Decimal hyperparameter values are treated as a
// decimal in a comparison if the specified Value is also a decimal value. If the
// specified Value is an integer, the decimal hyperparameter values are treated as
// integers. For example, the following filter is satisfied by training jobs with a
// "learning_rate" hyperparameter that is less than "0.5":  {
//     "Name":
// "HyperParameters.learning_rate",
//
//     "Operator": "LessThan",
//
//     "Value":
// "0.5"
//
// } Tags To define a tag filter, enter a value with the form Tags..
type Filter struct {

	// A resource property name. For example, TrainingJobName. For valid property
	// names, see SearchRecord. You must specify a valid property for the resource.
	//
	// This member is required.
	Name *string

	// A Boolean binary operator that is used to evaluate the filter. The operator
	// field contains one of the following values: Equals The value of Name equals
	// Value. NotEquals The value of Name doesn't equal Value. Exists The Name property
	// exists. NotExists The Name property does not exist. GreaterThan The value of
	// Name is greater than Value. Not supported for text properties.
	// GreaterThanOrEqualTo The value of Name is greater than or equal to Value. Not
	// supported for text properties. LessThan The value of Name is less than Value.
	// Not supported for text properties. LessThanOrEqualTo The value of Name is less
	// than or equal to Value. Not supported for text properties. In The value of Name
	// is one of the comma delimited strings in Value. Only supported for text
	// properties. Contains The value of Name contains the string Value. Only supported
	// for text properties. A SearchExpression can include the Contains operator
	// multiple times when the value of Name is one of the following:
	//
	// *
	// Experiment.DisplayName
	//
	// * Experiment.ExperimentName
	//
	// * Experiment.Tags
	//
	// *
	// Trial.DisplayName
	//
	// * Trial.TrialName
	//
	// * Trial.Tags
	//
	// *
	// TrialComponent.DisplayName
	//
	// * TrialComponent.TrialComponentName
	//
	// *
	// TrialComponent.Tags
	//
	// * TrialComponent.InputArtifacts
	//
	// *
	// TrialComponent.OutputArtifacts
	//
	// A SearchExpression can include only one Contains
	// operator for all other values of Name. In these cases, if you include multiple
	// Contains operators in the SearchExpression, the result is the following error
	// message: "'CONTAINS' operator usage limit of 1 exceeded."
	Operator Operator

	// A value used with Name and Operator to determine which resources satisfy the
	// filter's condition. For numerical properties, Value must be an integer or
	// floating-point decimal. For timestamp properties, Value must be an ISO 8601
	// date-time string of the following format: YYYY-mm-dd'T'HH:MM:SS.
	Value *string

	noSmithyDocumentSerde
}

// The best candidate result from an AutoML training job.
type FinalAutoMLJobObjectiveMetric struct {

	// The name of the metric with the best result. For a description of the possible
	// objective metrics, see AutoMLJobObjective$MetricName.
	//
	// This member is required.
	MetricName AutoMLMetricEnum

	// The value of the metric with the best result.
	//
	// This member is required.
	Value float32

	// The type of metric with the best result.
	Type AutoMLJobObjectiveType

	noSmithyDocumentSerde
}

// Shows the final value for the objective metric for a training job that was
// launched by a hyperparameter tuning job. You define the objective metric in the
// HyperParameterTuningJobObjective parameter of HyperParameterTuningJobConfig.
type FinalHyperParameterTuningJobObjectiveMetric struct {

	// The name of the objective metric.
	//
	// This member is required.
	MetricName *string

	// The value of the objective metric.
	//
	// This member is required.
	Value float32

	// Whether to minimize or maximize the objective metric. Valid values are Minimize
	// and Maximize.
	Type HyperParameterTuningJobObjectiveType

	noSmithyDocumentSerde
}

// Contains information about where human output will be stored.
type FlowDefinitionOutputConfig struct {

	// The Amazon S3 path where the object containing human output will be made
	// available. To learn more about the format of Amazon A2I output data, see Amazon
	// A2I Output Data
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-output-data.html).
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Key Management Service (KMS) key ID for server-side encryption.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Contains summary information about the flow definition.
type FlowDefinitionSummary struct {

	// The timestamp when SageMaker created the flow definition.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// This member is required.
	FlowDefinitionArn *string

	// The name of the flow definition.
	//
	// This member is required.
	FlowDefinitionName *string

	// The status of the flow definition. Valid values:
	//
	// This member is required.
	FlowDefinitionStatus FlowDefinitionStatus

	// The reason why the flow definition creation failed. A failure reason is returned
	// only when the flow definition status is Failed.
	FailureReason *string

	noSmithyDocumentSerde
}

// Specifies configuration details for a Git repository in your Amazon Web Services
// account.
type GitConfig struct {

	// The URL where the Git repository is located.
	//
	// This member is required.
	RepositoryUrl *string

	// The default branch for the Git repository.
	Branch *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret
	// that contains the credentials used to access the git repository. The secret must
	// have a staging label of AWSCURRENT and must be in the following format:
	// {"username": UserName, "password": Password}
	SecretArn *string

	noSmithyDocumentSerde
}

// Specifies configuration details for a Git repository when the repository is
// updated.
type GitConfigForUpdate struct {

	// The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret
	// that contains the credentials used to access the git repository. The secret must
	// have a staging label of AWSCURRENT and must be in the following format:
	// {"username": UserName, "password": Password}
	SecretArn *string

	noSmithyDocumentSerde
}

// Defines under what conditions SageMaker creates a human loop. Used within . See
// for the required format of activation conditions.
type HumanLoopActivationConditionsConfig struct {

	// JSON expressing use-case specific conditions declaratively. If any condition is
	// matched, atomic tasks are created against the configured work team. The set of
	// conditions is different for Rekognition and Textract. For more information about
	// how to structure the JSON, see JSON Schema for Human Loop Activation Conditions
	// in Amazon Augmented AI
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html)
	// in the Amazon SageMaker Developer Guide.
	//
	// This value conforms to the media type: application/json
	//
	// This member is required.
	HumanLoopActivationConditions *string

	noSmithyDocumentSerde
}

// Provides information about how and under what conditions SageMaker creates a
// human loop. If HumanLoopActivationConfig is not given, then all requests go to
// humans.
type HumanLoopActivationConfig struct {

	// Container structure for defining under what conditions SageMaker creates a human
	// loop.
	//
	// This member is required.
	HumanLoopActivationConditionsConfig *HumanLoopActivationConditionsConfig

	noSmithyDocumentSerde
}

// Describes the work to be performed by human workers.
type HumanLoopConfig struct {

	// The Amazon Resource Name (ARN) of the human task user interface. You can use
	// standard HTML and Crowd HTML Elements to create a custom worker task template.
	// You use this template to create a human task UI. To learn how to create a custom
	// HTML template, see Create Custom Worker Task Template
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html). To
	// learn how to create a human task UI, which is a worker task template that can be
	// used in a flow definition, see Create and Delete a Worker Task Templates
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html).
	//
	// This member is required.
	HumanTaskUiArn *string

	// The number of distinct workers who will perform the same task on each object.
	// For example, if TaskCount is set to 3 for an image classification labeling job,
	// three workers will classify each input image. Increasing TaskCount can improve
	// label accuracy.
	//
	// This member is required.
	TaskCount *int32

	// A description for the human worker task.
	//
	// This member is required.
	TaskDescription *string

	// A title for the human worker task.
	//
	// This member is required.
	TaskTitle *string

	// Amazon Resource Name (ARN) of a team of workers. To learn more about the types
	// of workforces and work teams you can create and use with Amazon A2I, see Create
	// and Manage Workforces
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html).
	//
	// This member is required.
	WorkteamArn *string

	// Defines the amount of money paid to an Amazon Mechanical Turk worker for each
	// task performed. Use one of the following prices for bounding box tasks. Prices
	// are in US dollars and should be based on the complexity of the task; the longer
	// it takes in your initial testing, the more you should offer.
	//
	// * 0.036
	//
	// *
	// 0.048
	//
	// * 0.060
	//
	// * 0.072
	//
	// * 0.120
	//
	// * 0.240
	//
	// * 0.360
	//
	// * 0.480
	//
	// * 0.600
	//
	// * 0.720
	//
	// *
	// 0.840
	//
	// * 0.960
	//
	// * 1.080
	//
	// * 1.200
	//
	// Use one of the following prices for image
	// classification, text classification, and custom tasks. Prices are in US
	// dollars.
	//
	// * 0.012
	//
	// * 0.024
	//
	// * 0.036
	//
	// * 0.048
	//
	// * 0.060
	//
	// * 0.072
	//
	// * 0.120
	//
	// *
	// 0.240
	//
	// * 0.360
	//
	// * 0.480
	//
	// * 0.600
	//
	// * 0.720
	//
	// * 0.840
	//
	// * 0.960
	//
	// * 1.080
	//
	// *
	// 1.200
	//
	// Use one of the following prices for semantic segmentation tasks. Prices
	// are in US dollars.
	//
	// * 0.840
	//
	// * 0.960
	//
	// * 1.080
	//
	// * 1.200
	//
	// Use one of the following
	// prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI
	// review tasks. Prices are in US dollars.
	//
	// * 2.400
	//
	// * 2.280
	//
	// * 2.160
	//
	// * 2.040
	//
	// *
	// 1.920
	//
	// * 1.800
	//
	// * 1.680
	//
	// * 1.560
	//
	// * 1.440
	//
	// * 1.320
	//
	// * 1.200
	//
	// * 1.080
	//
	// * 0.960
	//
	// *
	// 0.840
	//
	// * 0.720
	//
	// * 0.600
	//
	// * 0.480
	//
	// * 0.360
	//
	// * 0.240
	//
	// * 0.120
	//
	// * 0.072
	//
	// * 0.060
	//
	// *
	// 0.048
	//
	// * 0.036
	//
	// * 0.024
	//
	// * 0.012
	//
	// Use one of the following prices for
	// Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are
	// in US dollars.
	//
	// * 1.200
	//
	// * 1.080
	//
	// * 0.960
	//
	// * 0.840
	//
	// * 0.720
	//
	// * 0.600
	//
	// * 0.480
	//
	// *
	// 0.360
	//
	// * 0.240
	//
	// * 0.120
	//
	// * 0.072
	//
	// * 0.060
	//
	// * 0.048
	//
	// * 0.036
	//
	// * 0.024
	//
	// *
	// 0.012
	//
	// Use one of the following prices for Amazon Augmented AI custom human
	// review tasks. Prices are in US dollars.
	//
	// * 1.200
	//
	// * 1.080
	//
	// * 0.960
	//
	// * 0.840
	//
	// *
	// 0.720
	//
	// * 0.600
	//
	// * 0.480
	//
	// * 0.360
	//
	// * 0.240
	//
	// * 0.120
	//
	// * 0.072
	//
	// * 0.060
	//
	// * 0.048
	//
	// *
	// 0.036
	//
	// * 0.024
	//
	// * 0.012
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice

	// The length of time that a task remains available for review by human workers.
	TaskAvailabilityLifetimeInSeconds *int32

	// Keywords used to describe the task so that workers can discover the task.
	TaskKeywords []string

	// The amount of time that a worker has to complete a task. The default value is
	// 3,600 seconds (1 hour).
	TaskTimeLimitInSeconds *int32

	noSmithyDocumentSerde
}

// Container for configuring the source of human task requests.
type HumanLoopRequestSource struct {

	// Specifies whether Amazon Rekognition or Amazon Textract are used as the
	// integration source. The default field settings and JSON parsing rules are
	// different based on the integration source. Valid values:
	//
	// This member is required.
	AwsManagedHumanLoopRequestSource AwsManagedHumanLoopRequestSource

	noSmithyDocumentSerde
}

// Information required for human workers to complete a labeling task.
type HumanTaskConfig struct {

	// Configures how labels are consolidated across human workers.
	//
	// This member is required.
	AnnotationConsolidationConfig *AnnotationConsolidationConfig

	// The number of human workers that will label an object.
	//
	// This member is required.
	NumberOfHumanWorkersPerDataObject *int32

	// The Amazon Resource Name (ARN) of a Lambda function that is run before a data
	// object is sent to a human worker. Use this function to provide input to a custom
	// labeling job. For built-in task types
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html), use one
	// of the following Amazon SageMaker Ground Truth Lambda function ARNs for
	// PreHumanTaskLambdaArn. For custom labeling workflows, see Pre-annotation Lambda
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda).
	// Bounding box - Finds the most similar boxes from different workers based on the
	// Jaccard index of the boxes.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox
	//
	// Image
	// classification - Uses a variant of the Expectation Maximization approach to
	// estimate the true class of an image based on annotations from individual
	// workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass
	//
	// Multi-label
	// image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true classes of an image based on annotations from individual
	// workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel
	//
	// Semantic
	// segmentation - Treats each pixel in an image as a multi-class classification and
	// treats pixel annotations from workers as "votes" for the correct label.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation
	//
	// Text
	// classification - Uses a variant of the Expectation Maximization approach to
	// estimate the true class of text based on annotations from individual workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass
	//
	// Multi-label
	// text classification - Uses a variant of the Expectation Maximization approach to
	// estimate the true classes of text based on annotations from individual
	// workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel
	//
	// Named
	// entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition
	//
	// Video
	// Classification - Use this task type when you need workers to classify videos
	// using predefined labels that you specify. Workers are shown videos and are asked
	// to choose one label for each video.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass
	//
	// Video
	// Frame Object Detection - Use this task type to have workers identify and locate
	// objects in a sequence of video frames (images extracted from a video) using
	// bounding boxes. For example, you can use this task to ask workers to identify
	// and localize various objects in a series of video frames, such as cars, bikes,
	// and pedestrians.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection
	//
	// Video
	// Frame Object Tracking - Use this task type to have workers track the movement of
	// objects in a sequence of video frames (images extracted from a video) using
	// bounding boxes. For example, you can use this task to ask workers to track the
	// movement of objects, such as cars, bikes, and pedestrians.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking
	//
	// 3D
	// Point Cloud Modalities Use the following pre-annotation lambdas for 3D point
	// cloud labeling modality tasks. See 3D Point Cloud Task types
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html)
	// to learn more. 3D Point Cloud Object Detection - Use this task type when you
	// want workers to classify objects in a 3D point cloud by drawing 3D cuboids
	// around objects. For example, you can use this task type to ask workers to
	// identify different types of objects in a point cloud, such as cars, bikes, and
	// pedestrians.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection
	//
	// 3D
	// Point Cloud Object Tracking - Use this task type when you want workers to draw
	// 3D cuboids around objects that appear in a sequence of 3D point cloud frames.
	// For example, you can use this task type to ask workers to track the movement of
	// vehicles across multiple point cloud frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking
	//
	// 3D
	// Point Cloud Semantic Segmentation - Use this task type when you want workers to
	// create a point-level semantic segmentation masks by painting objects in a 3D
	// point cloud using different colors where each color is assigned to one of the
	// classes you specify.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation
	//
	// Use
	// the following ARNs for Label Verification and Adjustment Jobs Use label
	// verification and adjustment jobs to review and adjust labels. To learn more, see
	// Verify and Adjust Labels
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
	// Bounding box verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgement for bounding box
	// labels based on annotations from individual workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox
	//
	// Bounding
	// box adjustment - Finds the most similar boxes from different workers based on
	// the Jaccard index of the adjusted annotations.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox
	//
	// Semantic
	// segmentation verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgment for semantic
	// segmentation labels based on annotations from individual workers.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation
	//
	// Semantic
	// segmentation adjustment - Treats each pixel in an image as a multi-class
	// classification and treats pixel adjusted annotations from workers as "votes" for
	// the correct label.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation
	//
	// Video
	// Frame Object Detection Adjustment - Use this task type when you want workers to
	// adjust bounding boxes that workers have added to video frames to classify and
	// localize objects in a sequence of video frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection
	//
	// Video
	// Frame Object Tracking Adjustment - Use this task type when you want workers to
	// adjust bounding boxes that workers have added to video frames to track object
	// movement across a sequence of video frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking
	//
	// 3D
	// point cloud object detection adjustment - Adjust 3D cuboids in a point cloud
	// frame.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// 3D
	// point cloud object tracking adjustment - Adjust 3D cuboids across a sequence of
	// point cloud frames.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// 3D
	// point cloud semantic segmentation adjustment - Adjust semantic segmentation
	// masks in a 3D point cloud.
	//
	// *
	// arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// *
	// arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// This member is required.
	PreHumanTaskLambdaArn *string

	// A description of the task for your human workers.
	//
	// This member is required.
	TaskDescription *string

	// The amount of time that a worker has to complete a task. If you create a custom
	// labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).
	// If you create a labeling job using a built-in task type
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html) the
	// maximum for this parameter depends on the task type you use:
	//
	// * For image
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html) and text
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html) labeling
	// jobs, the maximum is 8 hours (28,800 seconds).
	//
	// * For 3D point cloud
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html) and video
	// frame (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html) labeling
	// jobs, the maximum is 30 days (2952,000 seconds) for non-AL mode. For most users,
	// the maximum is also 30 days.
	//
	// This member is required.
	TaskTimeLimitInSeconds *int32

	// A title for the task for your human workers.
	//
	// This member is required.
	TaskTitle *string

	// Information about the user interface that workers use to complete the labeling
	// task.
	//
	// This member is required.
	UiConfig *UiConfig

	// The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
	//
	// This member is required.
	WorkteamArn *string

	// Defines the maximum number of data objects that can be labeled by human workers
	// at the same time. Also referred to as batch size. Each object may have more than
	// one worker at one time. The default value is 1000 objects.
	MaxConcurrentTaskCount *int32

	// The price that you pay for each task performed by an Amazon Mechanical Turk
	// worker.
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice

	// The length of time that a task remains available for labeling by human workers.
	// The default and maximum values for this parameter depend on the type of
	// workforce you use.
	//
	// * If you choose the Amazon Mechanical Turk workforce, the
	// maximum is 12 hours (43,200 seconds). The default is 6 hours (21,600
	// seconds).
	//
	// * If you choose a private or vendor workforce, the default value is
	// 30 days (2592,000 seconds) for non-AL mode. For most users, the maximum is also
	// 30 days.
	TaskAvailabilityLifetimeInSeconds *int32

	// Keywords used to describe the task so that workers on Amazon Mechanical Turk can
	// discover the task.
	TaskKeywords []string

	noSmithyDocumentSerde
}

// Container for human task user interface information.
type HumanTaskUiSummary struct {

	// A timestamp when SageMaker created the human task user interface.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// This member is required.
	HumanTaskUiArn *string

	// The name of the human task user interface.
	//
	// This member is required.
	HumanTaskUiName *string

	noSmithyDocumentSerde
}

// Specifies which training algorithm to use for training jobs that a
// hyperparameter tuning job launches and the metrics to monitor.
type HyperParameterAlgorithmSpecification struct {

	// The training input mode that the algorithm supports. For more information about
	// input modes, see Algorithms
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). Pipe mode If an
	// algorithm supports Pipe mode, Amazon SageMaker streams data directly from Amazon
	// S3 to the container. File mode If an algorithm supports File mode, SageMaker
	// downloads the training data from S3 to the provisioned ML storage volume, and
	// mounts the directory to the Docker volume for the training container. You must
	// provision the ML storage volume with sufficient capacity to accommodate the data
	// downloaded from S3. In addition to the training data, the ML storage volume also
	// stores the output model. The algorithm container uses the ML storage volume to
	// also store intermediate information, if any. For distributed algorithms,
	// training data is distributed uniformly. Your training duration is predictable if
	// the input data objects sizes are approximately the same. SageMaker does not
	// split the files any further for model training. If the object sizes are skewed,
	// training won't be optimal as the data distribution is also skewed when one host
	// in a training cluster is overloaded, thus becoming a bottleneck in training.
	// FastFile mode If an algorithm supports FastFile mode, SageMaker streams data
	// directly from S3 to the container with no code changes, and provides file system
	// access to the data. Users can author their training script to interact with
	// these files as if they were stored on disk. FastFile mode works best when the
	// data is read sequentially. Augmented manifest files aren't supported. The
	// startup time is lower when there are fewer files in the S3 bucket provided.
	//
	// This member is required.
	TrainingInputMode TrainingInputMode

	// The name of the resource algorithm to use for the hyperparameter tuning job. If
	// you specify a value for this parameter, do not specify a value for
	// TrainingImage.
	AlgorithmName *string

	// An array of MetricDefinition objects that specify the metrics that the algorithm
	// emits.
	MetricDefinitions []MetricDefinition

	// The registry path of the Docker image that contains the training algorithm. For
	// information about Docker registry paths for built-in algorithms, see Algorithms
	// Provided by Amazon SageMaker: Common Parameters
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see Using
	// Your Own Algorithms with Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string

	noSmithyDocumentSerde
}

// Defines a hyperparameter to be used by an algorithm.
type HyperParameterSpecification struct {

	// The name of this hyperparameter. The name must be unique.
	//
	// This member is required.
	Name *string

	// The type of this hyperparameter. The valid types are Integer, Continuous,
	// Categorical, and FreeText.
	//
	// This member is required.
	Type ParameterType

	// The default value for this hyperparameter. If a default value is specified, a
	// hyperparameter cannot be required.
	DefaultValue *string

	// A brief description of the hyperparameter.
	Description *string

	// Indicates whether this hyperparameter is required.
	IsRequired bool

	// Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.
	IsTunable bool

	// The allowed range for this hyperparameter.
	Range *ParameterRange

	noSmithyDocumentSerde
}

// Defines the training jobs launched by a hyperparameter tuning job.
type HyperParameterTrainingJobDefinition struct {

	// The HyperParameterAlgorithmSpecification object that specifies the resource
	// algorithm to use for the training jobs that the tuning job launches.
	//
	// This member is required.
	AlgorithmSpecification *HyperParameterAlgorithmSpecification

	// Specifies the path to the Amazon S3 bucket where you store model artifacts from
	// the training jobs that the tuning job launches.
	//
	// This member is required.
	OutputDataConfig *OutputDataConfig

	// The resources, including the compute instances and storage volumes, to use for
	// the training jobs that the tuning job launches. Storage volumes store model
	// artifacts and incremental states. Training algorithms might also use storage
	// volumes for scratch space. If you want SageMaker to use the storage volume to
	// store the training data, choose File as the TrainingInputMode in the algorithm
	// specification. For distributed training algorithms, specify an instance count
	// greater than 1.
	//
	// This member is required.
	ResourceConfig *ResourceConfig

	// The Amazon Resource Name (ARN) of the IAM role associated with the training jobs
	// that the tuning job launches.
	//
	// This member is required.
	RoleArn *string

	// Specifies a limit to how long a model hyperparameter training job can run. It
	// also specifies how long a managed spot training job has to complete. When the
	// job reaches the time limit, SageMaker ends the training job. Use this API to cap
	// model training costs.
	//
	// This member is required.
	StoppingCondition *StoppingCondition

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig

	// The job definition name.
	DefinitionName *string

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use a deep
	// learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption bool

	// A Boolean indicating whether managed spot training is enabled (True) or not
	// (False).
	EnableManagedSpotTraining bool

	// Isolates the training container. No inbound or outbound network calls can be
	// made, except for calls between peers within a training cluster for distributed
	// training. If network isolation is used for training jobs that are configured to
	// use a VPC, SageMaker downloads and uploads customer data and model artifacts
	// through the specified VPC, but the training container does not have network
	// access.
	EnableNetworkIsolation bool

	// Specifies ranges of integer, continuous, and categorical hyperparameters that a
	// hyperparameter tuning job searches. The hyperparameter tuning job launches
	// training jobs with hyperparameter values within these ranges to find the
	// combination of values that result in the training job with the best performance
	// as measured by the objective metric of the hyperparameter tuning job. The
	// maximum number of items specified for Array Members refers to the maximum number
	// of hyperparameters for each range and also the maximum for the hyperparameter
	// tuning job itself. That is, the sum of the number of hyperparameters for all the
	// ranges can't exceed the maximum number specified.
	HyperParameterRanges *ParameterRanges

	// An array of Channel objects that specify the input for the training jobs that
	// the tuning job launches.
	InputDataConfig []Channel

	// The number of times to retry the job when the job fails due to an
	// InternalServerError.
	RetryStrategy *RetryStrategy

	// Specifies the values of hyperparameters that do not change for the tuning job.
	StaticHyperParameters map[string]string

	// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
	// tuning uses the value of this metric to evaluate the training jobs it launches,
	// and returns the training job that results in either the highest or lowest value
	// for this metric, depending on the value you specify for the Type parameter.
	TuningObjective *HyperParameterTuningJobObjective

	// The VpcConfig object that specifies the VPC that you want the training jobs that
	// this hyperparameter tuning job launches to connect to. Control access to and
	// from your training container by configuring the VPC. For more information, see
	// Protect Training Jobs by Using an Amazon Virtual Private Cloud
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The container for the summary information about a training job.
type HyperParameterTrainingJobSummary struct {

	// The date and time that the training job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the training job.
	//
	// This member is required.
	TrainingJobArn *string

	// The name of the training job.
	//
	// This member is required.
	TrainingJobName *string

	// The status of the training job.
	//
	// This member is required.
	TrainingJobStatus TrainingJobStatus

	// A list of the hyperparameters for which you specified ranges to search.
	//
	// This member is required.
	TunedHyperParameters map[string]string

	// The reason that the training job failed.
	FailureReason *string

	// The FinalHyperParameterTuningJobObjectiveMetric object that specifies the value
	// of the objective metric of the tuning job that launched this training job.
	FinalHyperParameterTuningJobObjectiveMetric *FinalHyperParameterTuningJobObjectiveMetric

	// The status of the objective metric for the training job:
	//
	// * Succeeded: The final
	// objective metric for the training job was evaluated by the hyperparameter tuning
	// job and used in the hyperparameter tuning process.
	//
	// * Pending: The training job
	// is in progress and evaluation of its final objective metric is pending.
	//
	// *
	// Failed: The final objective metric for the training job was not evaluated, and
	// was not used in the hyperparameter tuning process. This typically occurs when
	// the training job failed or did not emit an objective metric.
	ObjectiveStatus ObjectiveStatus

	// Specifies the time when the training job ends on training instances. You are
	// billed for the time interval between the value of TrainingStartTime and this
	// time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when SageMaker detects
	// a job failure.
	TrainingEndTime *time.Time

	// The training job definition name.
	TrainingJobDefinitionName *string

	// The date and time that the training job started.
	TrainingStartTime *time.Time

	// The HyperParameter tuning job that launched the training job.
	TuningJobName *string

	noSmithyDocumentSerde
}

// Configures a hyperparameter tuning job.
type HyperParameterTuningJobConfig struct {

	// The ResourceLimits object that specifies the maximum number of training jobs and
	// parallel training jobs for this tuning job.
	//
	// This member is required.
	ResourceLimits *ResourceLimits

	// Specifies how hyperparameter tuning chooses the combinations of hyperparameter
	// values to use for the training job it launches. To use the Bayesian search
	// strategy, set this to Bayesian. To randomly search, set it to Random. For
	// information about search strategies, see How Hyperparameter Tuning Works
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
	//
	// This member is required.
	Strategy HyperParameterTuningJobStrategyType

	// The HyperParameterTuningJobObjective object that specifies the objective metric
	// for this tuning job.
	HyperParameterTuningJobObjective *HyperParameterTuningJobObjective

	// The ParameterRanges object that specifies the ranges of hyperparameters that
	// this tuning job searches.
	ParameterRanges *ParameterRanges

	// Specifies whether to use early stopping for training jobs launched by the
	// hyperparameter tuning job. This can be one of the following values (the default
	// value is OFF): OFF Training jobs launched by the hyperparameter tuning job do
	// not use early stopping. AUTO SageMaker stops training jobs launched by the
	// hyperparameter tuning job when they are unlikely to perform better than
	// previously completed training jobs. For more information, see Stop Training Jobs
	// Early
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html).
	TrainingJobEarlyStoppingType TrainingJobEarlyStoppingType

	// The tuning job's completion criteria.
	TuningJobCompletionCriteria *TuningJobCompletionCriteria

	noSmithyDocumentSerde
}

// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
// tuning uses the value of this metric to evaluate the training jobs it launches,
// and returns the training job that results in either the highest or lowest value
// for this metric, depending on the value you specify for the Type parameter.
type HyperParameterTuningJobObjective struct {

	// The name of the metric to use for the objective metric.
	//
	// This member is required.
	MetricName *string

	// Whether to minimize or maximize the objective metric.
	//
	// This member is required.
	Type HyperParameterTuningJobObjectiveType

	noSmithyDocumentSerde
}

// Provides summary information about a hyperparameter tuning job.
type HyperParameterTuningJobSummary struct {

	// The date and time that the tuning job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the tuning job.
	//
	// This member is required.
	HyperParameterTuningJobArn *string

	// The name of the tuning job.
	//
	// This member is required.
	HyperParameterTuningJobName *string

	// The status of the tuning job.
	//
	// This member is required.
	HyperParameterTuningJobStatus HyperParameterTuningJobStatus

	// The ObjectiveStatusCounters object that specifies the numbers of training jobs,
	// categorized by objective metric status, that this tuning job launched.
	//
	// This member is required.
	ObjectiveStatusCounters *ObjectiveStatusCounters

	// Specifies the search strategy hyperparameter tuning uses to choose which
	// hyperparameters to use for each iteration. Currently, the only valid value is
	// Bayesian.
	//
	// This member is required.
	Strategy HyperParameterTuningJobStrategyType

	// The TrainingJobStatusCounters object that specifies the numbers of training
	// jobs, categorized by status, that this tuning job launched.
	//
	// This member is required.
	TrainingJobStatusCounters *TrainingJobStatusCounters

	// The date and time that the tuning job ended.
	HyperParameterTuningEndTime *time.Time

	// The date and time that the tuning job was modified.
	LastModifiedTime *time.Time

	// The ResourceLimits object that specifies the maximum number of training jobs and
	// parallel training jobs allowed for this tuning job.
	ResourceLimits *ResourceLimits

	noSmithyDocumentSerde
}

// Specifies the configuration for a hyperparameter tuning job that uses one or
// more previous hyperparameter tuning jobs as a starting point. The results of
// previous tuning jobs are used to inform which combinations of hyperparameters to
// search over in the new tuning job. All training jobs launched by the new
// hyperparameter tuning job are evaluated by using the objective metric, and the
// training job that performs the best is compared to the best training jobs from
// the parent tuning jobs. From these, the training job that performs the best as
// measured by the objective metric is returned as the overall best training job.
// All training jobs launched by parent hyperparameter tuning jobs and the new
// hyperparameter tuning jobs count against the limit of training jobs for the
// tuning job.
type HyperParameterTuningJobWarmStartConfig struct {

	// An array of hyperparameter tuning jobs that are used as the starting point for
	// the new hyperparameter tuning job. For more information about warm starting a
	// hyperparameter tuning job, see Using a Previous Hyperparameter Tuning Job as a
	// Starting Point
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html).
	// Hyperparameter tuning jobs created before October 1, 2018 cannot be used as
	// parent jobs for warm start tuning jobs.
	//
	// This member is required.
	ParentHyperParameterTuningJobs []ParentHyperParameterTuningJob

	// Specifies one of the following: IDENTICAL_DATA_AND_ALGORITHM The new
	// hyperparameter tuning job uses the same input data and training image as the
	// parent tuning jobs. You can change the hyperparameter ranges to search and the
	// maximum number of training jobs that the hyperparameter tuning job launches. You
	// cannot use a new version of the training algorithm, unless the changes in the
	// new version do not affect the algorithm itself. For example, changes that
	// improve logging or adding support for a different data format are allowed. You
	// can also change hyperparameters from tunable to static, and from static to
	// tunable, but the total number of static plus tunable hyperparameters must remain
	// the same as it is in all parent jobs. The objective metric for the new tuning
	// job must be the same as for all parent jobs. TRANSFER_LEARNING The new
	// hyperparameter tuning job can include input data, hyperparameter ranges, maximum
	// number of concurrent training jobs, and maximum number of training jobs that are
	// different than those of its parent hyperparameter tuning jobs. The training
	// image can also be a different version from the version used in the parent
	// hyperparameter tuning job. You can also change hyperparameters from tunable to
	// static, and from static to tunable, but the total number of static plus tunable
	// hyperparameters must remain the same as it is in all parent jobs. The objective
	// metric for the new tuning job must be the same as for all parent jobs.
	//
	// This member is required.
	WarmStartType HyperParameterTuningJobWarmStartType

	noSmithyDocumentSerde
}

// A SageMaker image. A SageMaker image represents a set of container images that
// are derived from a common base container image. Each of these container images
// is represented by a SageMaker ImageVersion.
type Image struct {

	// When the image was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the image.
	//
	// This member is required.
	ImageArn *string

	// The name of the image.
	//
	// This member is required.
	ImageName *string

	// The status of the image.
	//
	// This member is required.
	ImageStatus ImageStatus

	// When the image was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The description of the image.
	Description *string

	// The name of the image as displayed.
	DisplayName *string

	// When a create, update, or delete operation fails, the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Specifies whether the model container is in Amazon ECR or a private Docker
// registry accessible from your Amazon Virtual Private Cloud (VPC).
type ImageConfig struct {

	// Set this to one of the following values:
	//
	// * Platform - The model image is hosted
	// in Amazon ECR.
	//
	// * Vpc - The model image is hosted in a private Docker registry
	// in your VPC.
	//
	// This member is required.
	RepositoryAccessMode RepositoryAccessMode

	// (Optional) Specifies an authentication configuration for the private docker
	// registry where your model image is hosted. Specify a value for this property
	// only if you specified Vpc as the value for the RepositoryAccessMode field, and
	// the private Docker registry where the model image is hosted requires
	// authentication.
	RepositoryAuthConfig *RepositoryAuthConfig

	noSmithyDocumentSerde
}

// A version of a SageMaker Image. A version represents an existing container
// image.
type ImageVersion struct {

	// When the version was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the image the version is based on.
	//
	// This member is required.
	ImageArn *string

	// The ARN of the version.
	//
	// This member is required.
	ImageVersionArn *string

	// The status of the version.
	//
	// This member is required.
	ImageVersionStatus ImageVersionStatus

	// When the version was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The version number.
	//
	// This member is required.
	Version *int32

	// When a create or delete operation fails, the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Specifies details about how containers in a multi-container endpoint are run.
type InferenceExecutionConfig struct {

	// How containers in a multi-container are run. The following values are valid.
	//
	// *
	// SERIAL - Containers run as a serial pipeline.
	//
	// * DIRECT - Only the individual
	// container that you specify is run.
	//
	// This member is required.
	Mode InferenceExecutionMode

	noSmithyDocumentSerde
}

// A list of recommendations made by Amazon SageMaker Inference Recommender.
type InferenceRecommendation struct {

	// Defines the endpoint configuration parameters.
	//
	// This member is required.
	EndpointConfiguration *EndpointOutputConfiguration

	// The metrics used to decide what recommendation to make.
	//
	// This member is required.
	Metrics *RecommendationMetrics

	// Defines the model configuration.
	//
	// This member is required.
	ModelConfiguration *ModelConfiguration

	noSmithyDocumentSerde
}

// A structure that contains a list of recommendation jobs.
type InferenceRecommendationsJob struct {

	// A timestamp that shows when the job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the recommendation job.
	//
	// This member is required.
	JobArn *string

	// The job description.
	//
	// This member is required.
	JobDescription *string

	// The name of the job.
	//
	// This member is required.
	JobName *string

	// The recommendation job type.
	//
	// This member is required.
	JobType RecommendationJobType

	// A timestamp that shows when the job was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to
	// perform tasks on your behalf.
	//
	// This member is required.
	RoleArn *string

	// The status of the job.
	//
	// This member is required.
	Status RecommendationJobStatus

	// A timestamp that shows when the job completed.
	CompletionTime *time.Time

	// If the job fails, provides information why the job failed.
	FailureReason *string

	noSmithyDocumentSerde
}

// Defines how to perform inference generation after a training job is run.
type InferenceSpecification struct {

	// The Amazon ECR registry path of the Docker image that contains the inference
	// code.
	//
	// This member is required.
	Containers []ModelPackageContainerDefinition

	// The supported MIME types for the input data.
	//
	// This member is required.
	SupportedContentTypes []string

	// The supported MIME types for the output data.
	//
	// This member is required.
	SupportedResponseMIMETypes []string

	// A list of the instance types that are used to generate inferences in real-time.
	// This parameter is required for unversioned models, and optional for versioned
	// models.
	SupportedRealtimeInferenceInstanceTypes []ProductionVariantInstanceType

	// A list of the instance types on which a transformation job can be run or on
	// which an endpoint can be deployed. This parameter is required for unversioned
	// models, and optional for versioned models.
	SupportedTransformInstanceTypes []TransformInstanceType

	noSmithyDocumentSerde
}

// Contains information about the location of input model artifacts, the name and
// shape of the expected data inputs, and the framework in which the model was
// trained.
type InputConfig struct {

	// Specifies the name and shape of the expected data inputs for your trained model
	// with a JSON dictionary form. The data inputs are InputConfig$Framework
	// specific.
	//
	// * TensorFlow: You must specify the name and shape (NHWC format) of
	// the expected data inputs using a dictionary format for your trained model. The
	// dictionary formats required for the console and CLI are different.
	//
	// * Examples
	// for one input:
	//
	// * If using the console, {"input":[1,1024,1024,3]}
	//
	// * If using
	// the CLI, {\"input\":[1,1024,1024,3]}
	//
	// * Examples for two inputs:
	//
	// * If using the
	// console, {"data1": [1,28,28,1], "data2":[1,28,28,1]}
	//
	// * If using the CLI,
	// {\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}
	//
	// * KERAS: You must specify the
	// name and shape (NCHW format) of expected data inputs using a dictionary format
	// for your trained model. Note that while Keras model artifacts should be uploaded
	// in NHWC (channel-last) format, DataInputConfig should be specified in NCHW
	// (channel-first) format. The dictionary formats required for the console and CLI
	// are different.
	//
	// * Examples for one input:
	//
	// * If using the console,
	// {"input_1":[1,3,224,224]}
	//
	// * If using the CLI, {\"input_1\":[1,3,224,224]}
	//
	// *
	// Examples for two inputs:
	//
	// * If using the console, {"input_1": [1,3,224,224],
	// "input_2":[1,3,224,224]}
	//
	// * If using the CLI, {\"input_1\": [1,3,224,224],
	// \"input_2\":[1,3,224,224]}
	//
	// * MXNET/ONNX/DARKNET: You must specify the name and
	// shape (NCHW format) of the expected data inputs in order using a dictionary
	// format for your trained model. The dictionary formats required for the console
	// and CLI are different.
	//
	// * Examples for one input:
	//
	// * If using the console,
	// {"data":[1,3,1024,1024]}
	//
	// * If using the CLI, {\"data\":[1,3,1024,1024]}
	//
	// *
	// Examples for two inputs:
	//
	// * If using the console, {"var1": [1,1,28,28],
	// "var2":[1,1,28,28]}
	//
	// * If using the CLI, {\"var1\": [1,1,28,28],
	// \"var2\":[1,1,28,28]}
	//
	// * PyTorch: You can either specify the name and shape
	// (NCHW format) of expected data inputs in order using a dictionary format for
	// your trained model or you can specify the shape only using a list format. The
	// dictionary formats required for the console and CLI are different. The list
	// formats for the console and CLI are the same.
	//
	// * Examples for one input in
	// dictionary format:
	//
	// * If using the console, {"input0":[1,3,224,224]}
	//
	// * If using
	// the CLI, {\"input0\":[1,3,224,224]}
	//
	// * Example for one input in list format:
	// [[1,3,224,224]]
	//
	// * Examples for two inputs in dictionary format:
	//
	// * If using the
	// console, {"input0":[1,3,224,224], "input1":[1,3,224,224]}
	//
	// * If using the CLI,
	// {\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]}
	//
	// * Example for two inputs
	// in list format: [[1,3,224,224], [1,3,224,224]]
	//
	// * XGBOOST: input data name and
	// shape are not needed.
	//
	// DataInputConfig supports the following parameters for
	// CoreMLOutputConfig$TargetDevice (ML Model format):
	//
	// * shape: Input shape, for
	// example {"input_1": {"shape": [1,224,224,3]}}. In addition to static input
	// shapes, CoreML converter supports Flexible input shapes:
	//
	// * Range Dimension. You
	// can use the Range Dimension feature if you know the input shape will be within
	// some specific interval in that dimension, for example: {"input_1": {"shape":
	// ["1..10", 224, 224, 3]}}
	//
	// * Enumerated shapes. Sometimes, the models are trained
	// to work only on a select set of inputs. You can enumerate all supported input
	// shapes, for example: {"input_1": {"shape": [[1, 224, 224, 3], [1, 160, 160,
	// 3]]}}
	//
	// * default_shape: Default input shape. You can set a default shape during
	// conversion for both Range Dimension and Enumerated Shapes. For example
	// {"input_1": {"shape": ["1..10", 224, 224, 3], "default_shape": [1, 224, 224,
	// 3]}}
	//
	// * type: Input type. Allowed values: Image and Tensor. By default, the
	// converter generates an ML Model with inputs of type Tensor (MultiArray). User
	// can set input type to be Image. Image input type requires additional input
	// parameters such as bias and scale.
	//
	// * bias: If the input type is an Image, you
	// need to provide the bias vector.
	//
	// * scale: If the input type is an Image, you
	// need to provide a scale factor.
	//
	// CoreML ClassifierConfig parameters can be
	// specified using OutputConfig$CompilerOptions. CoreML converter supports
	// Tensorflow and PyTorch models. CoreML conversion examples:
	//
	// * Tensor type
	// input:
	//
	// * "DataInputConfig": {"input_1": {"shape": [[1,224,224,3],
	// [1,160,160,3]], "default_shape": [1,224,224,3]}}
	//
	// * Tensor type input without
	// input name (PyTorch):
	//
	// * "DataInputConfig": [{"shape": [[1,3,224,224],
	// [1,3,160,160]], "default_shape": [1,3,224,224]}]
	//
	// * Image type input:
	//
	// *
	// "DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]],
	// "default_shape": [1,224,224,3], "type": "Image", "bias": [-1,-1,-1], "scale":
	// 0.007843137255}}
	//
	// * "CompilerOptions": {"class_labels":
	// "imagenet_labels_1000.txt"}
	//
	// * Image type input without input name (PyTorch):
	//
	// *
	// "DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]], "default_shape":
	// [1,3,224,224], "type": "Image", "bias": [-1,-1,-1], "scale": 0.007843137255}]
	//
	// *
	// "CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}
	//
	// Depending on
	// the model format, DataInputConfig requires the following parameters for
	// ml_eia2OutputConfig:TargetDevice
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-TargetDevice).
	//
	// *
	// For TensorFlow models saved in the SavedModel format, specify the input names
	// from signature_def_key and the input model shapes for DataInputConfig. Specify
	// the signature_def_key in OutputConfig:CompilerOptions
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions)
	// if the model does not use TensorFlow's default signature def key. For
	// example:
	//
	// * "DataInputConfig": {"inputs": [1, 224, 224, 3]}
	//
	// *
	// "CompilerOptions": {"signature_def_key": "serving_custom"}
	//
	// * For TensorFlow
	// models saved as a frozen graph, specify the input tensor names and shapes in
	// DataInputConfig and the output tensor names for output_names in
	// OutputConfig:CompilerOptions
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions).
	// For example:
	//
	// * "DataInputConfig": {"input_tensor:0": [1, 224, 224, 3]}
	//
	// *
	// "CompilerOptions": {"output_names": ["output_tensor:0"]}
	//
	// This member is required.
	DataInputConfig *string

	// Identifies the framework in which the model was trained. For example:
	// TENSORFLOW.
	//
	// This member is required.
	Framework Framework

	// The S3 path where the model artifacts, which result from model training, are
	// stored. This path must point to a single gzip compressed tar archive (.tar.gz
	// suffix).
	//
	// This member is required.
	S3Uri *string

	// Specifies the framework version to use. This API field is only supported for the
	// PyTorch and TensorFlow frameworks. For information about framework versions
	// supported for cloud targets and edge devices, see Cloud Supported Instance Types
	// and Frameworks
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-cloud.html) and
	// Edge Supported Frameworks
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-devices-edge-frameworks.html).
	FrameworkVersion *string

	noSmithyDocumentSerde
}

// Defines an instance group for heterogeneous cluster training. When requesting a
// training job using the CreateTrainingJob
// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
// API, you can configure multiple instance groups .
type InstanceGroup struct {

	// Specifies the number of instances of the instance group.
	//
	// This member is required.
	InstanceCount int32

	// Specifies the name of the instance group.
	//
	// This member is required.
	InstanceGroupName *string

	// Specifies the instance type of the instance group.
	//
	// This member is required.
	InstanceType TrainingInstanceType

	noSmithyDocumentSerde
}

// Information on the IMDS configuration of the notebook instance
type InstanceMetadataServiceConfiguration struct {

	// Indicates the minimum IMDS version that the notebook instance supports. When
	// passed as part of CreateNotebookInstance, if no value is selected, then it
	// defaults to IMDSv1. This means that both IMDSv1 and IMDSv2 are supported. If
	// passed as part of UpdateNotebookInstance, there is no default.
	//
	// This member is required.
	MinimumInstanceMetadataServiceVersion *string

	noSmithyDocumentSerde
}

// For a hyperparameter of the integer type, specifies the range that a
// hyperparameter tuning job searches.
type IntegerParameterRange struct {

	// The maximum value of the hyperparameter to search.
	//
	// This member is required.
	MaxValue *string

	// The minimum value of the hyperparameter to search.
	//
	// This member is required.
	MinValue *string

	// The name of the hyperparameter to search.
	//
	// This member is required.
	Name *string

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values: Auto SageMaker hyperparameter tuning chooses the
	// best scale for the hyperparameter. Linear Hyperparameter tuning searches the
	// values in the hyperparameter range by using a linear scale. Logarithmic
	// Hyperparameter tuning searches the values in the hyperparameter range by using a
	// logarithmic scale. Logarithmic scaling works only for ranges that have only
	// values greater than 0.
	ScalingType HyperParameterScalingType

	noSmithyDocumentSerde
}

// Defines the possible values for an integer hyperparameter.
type IntegerParameterRangeSpecification struct {

	// The maximum integer value allowed.
	//
	// This member is required.
	MaxValue *string

	// The minimum integer value allowed.
	//
	// This member is required.
	MinValue *string

	noSmithyDocumentSerde
}

// The JupyterServer app settings.
type JupyterServerAppSettings struct {

	// The default instance type and the Amazon Resource Name (ARN) of the default
	// SageMaker image used by the JupyterServer app. If you use the
	// LifecycleConfigArns parameter, then this parameter is also required.
	DefaultResourceSpec *ResourceSpec

	// The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the
	// JupyterServerApp. If you use this parameter, the DefaultResourceSpec parameter
	// is also required. To remove a Lifecycle Config, you must set LifecycleConfigArns
	// to an empty list.
	LifecycleConfigArns []string

	noSmithyDocumentSerde
}

// The KernelGateway app settings.
type KernelGatewayAppSettings struct {

	// A list of custom SageMaker images that are configured to run as a KernelGateway
	// app.
	CustomImages []CustomImage

	// The default instance type and the Amazon Resource Name (ARN) of the default
	// SageMaker image used by the KernelGateway app. The Amazon SageMaker Studio UI
	// does not use the default instance type value set here. The default instance type
	// set here is used when Apps are created using the Amazon Web Services Command
	// Line Interface or Amazon Web Services CloudFormation and the instance type
	// parameter value is not passed.
	DefaultResourceSpec *ResourceSpec

	// The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the
	// the user profile or domain. To remove a Lifecycle Config, you must set
	// LifecycleConfigArns to an empty list.
	LifecycleConfigArns []string

	noSmithyDocumentSerde
}

// The configuration for the file system and kernels in a SageMaker image running
// as a KernelGateway app.
type KernelGatewayImageConfig struct {

	// The specification of the Jupyter kernels in the image.
	//
	// This member is required.
	KernelSpecs []KernelSpec

	// The Amazon Elastic File System (EFS) storage configuration for a SageMaker
	// image.
	FileSystemConfig *FileSystemConfig

	noSmithyDocumentSerde
}

// The specification of a Jupyter kernel.
type KernelSpec struct {

	// The name of the Jupyter kernel in the image. This value is case sensitive.
	//
	// This member is required.
	Name *string

	// The display name of the kernel.
	DisplayName *string

	noSmithyDocumentSerde
}

// Provides a breakdown of the number of objects labeled.
type LabelCounters struct {

	// The total number of objects that could not be labeled due to an error.
	FailedNonRetryableError int32

	// The total number of objects labeled by a human worker.
	HumanLabeled int32

	// The total number of objects labeled by automated data labeling.
	MachineLabeled int32

	// The total number of objects labeled.
	TotalLabeled int32

	// The total number of objects not yet labeled.
	Unlabeled int32

	noSmithyDocumentSerde
}

// Provides counts for human-labeled tasks in the labeling job.
type LabelCountersForWorkteam struct {

	// The total number of data objects labeled by a human worker.
	HumanLabeled int32

	// The total number of data objects that need to be labeled by a human worker.
	PendingHuman int32

	// The total number of tasks in the labeling job.
	Total int32

	noSmithyDocumentSerde
}

// Provides configuration information for auto-labeling of your data objects. A
// LabelingJobAlgorithmsConfig object must be supplied in order to use
// auto-labeling.
type LabelingJobAlgorithmsConfig struct {

	// Specifies the Amazon Resource Name (ARN) of the algorithm used for
	// auto-labeling. You must select one of the following ARNs:
	//
	// * Image
	// classification
	// arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/image-classification
	//
	// *
	// Text classification
	// arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/text-classification
	//
	// *
	// Object detection
	// arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/object-detection
	//
	// *
	// Semantic Segmentation
	// arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/semantic-segmentation
	//
	// This member is required.
	LabelingJobAlgorithmSpecificationArn *string

	// At the end of an auto-label job Ground Truth sends the Amazon Resource Name
	// (ARN) of the final model used for auto-labeling. You can use this model as the
	// starting point for subsequent similar jobs by providing the ARN of the model
	// here.
	InitialActiveLearningModelArn *string

	// Provides configuration information for a labeling job.
	LabelingJobResourceConfig *LabelingJobResourceConfig

	noSmithyDocumentSerde
}

// Attributes of the data specified by the customer. Use these to describe the data
// to be labeled.
type LabelingJobDataAttributes struct {

	// Declares that your content is free of personally identifiable information or
	// adult content. SageMaker may restrict the Amazon Mechanical Turk workers that
	// can view your task based on this information.
	ContentClassifiers []ContentClassifier

	noSmithyDocumentSerde
}

// Provides information about the location of input data. You must specify at least
// one of the following: S3DataSource or SnsDataSource. Use SnsDataSource to
// specify an SNS input topic for a streaming labeling job. If you do not specify
// and SNS input topic ARN, Ground Truth will create a one-time labeling job. Use
// S3DataSource to specify an input manifest file for both streaming and one-time
// labeling jobs. Adding an S3DataSource is optional if you use SnsDataSource to
// create a streaming labeling job.
type LabelingJobDataSource struct {

	// The Amazon S3 location of the input data objects.
	S3DataSource *LabelingJobS3DataSource

	// An Amazon SNS data source used for streaming labeling jobs. To learn more, see
	// Send Data to a Streaming Labeling Job
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data).
	SnsDataSource *LabelingJobSnsDataSource

	noSmithyDocumentSerde
}

// Provides summary information for a work team.
type LabelingJobForWorkteamSummary struct {

	// The date and time that the labeling job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// A unique identifier for a labeling job. You can use this to refer to a specific
	// labeling job.
	//
	// This member is required.
	JobReferenceCode *string

	// The Amazon Web Services account ID of the account used to start the labeling
	// job.
	//
	// This member is required.
	WorkRequesterAccountId *string

	// Provides information about the progress of a labeling job.
	LabelCounters *LabelCountersForWorkteam

	// The name of the labeling job that the work team is assigned to.
	LabelingJobName *string

	// The configured number of workers per data object.
	NumberOfHumanWorkersPerDataObject *int32

	noSmithyDocumentSerde
}

// Input configuration information for a labeling job.
type LabelingJobInputConfig struct {

	// The location of the input data.
	//
	// This member is required.
	DataSource *LabelingJobDataSource

	// Attributes of the data specified by the customer.
	DataAttributes *LabelingJobDataAttributes

	noSmithyDocumentSerde
}

// Specifies the location of the output produced by the labeling job.
type LabelingJobOutput struct {

	// The Amazon S3 bucket location of the manifest file for labeled data.
	//
	// This member is required.
	OutputDatasetS3Uri *string

	// The Amazon Resource Name (ARN) for the most recent SageMaker model trained as
	// part of automated data labeling.
	FinalActiveLearningModelArn *string

	noSmithyDocumentSerde
}

// Output configuration information for a labeling job.
type LabelingJobOutputConfig struct {

	// The Amazon S3 location to write output data.
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Web Services Key Management Service ID of the key used to encrypt the
	// output data, if any. If you provide your own KMS key ID, you must add the
	// required permissions to your KMS key described in Encrypt Output Data and
	// Storage Volume with Amazon Web Services KMS
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions).
	// If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web
	// Services KMS key for Amazon S3 for your role's account to encrypt your output
	// data. If you use a bucket policy with an s3:PutObject permission that only
	// allows objects with server-side encryption, set the condition key of
	// s3:x-amz-server-side-encryption to "aws:kms". For more information, see
	// KMS-Managed Encryption Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the
	// Amazon Simple Storage Service Developer Guide.
	KmsKeyId *string

	// An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a
	// SnsTopicArn if you want to do real time chaining to another streaming job and
	// receive an Amazon SNS notifications each time a data object is submitted by a
	// worker. If you provide an SnsTopicArn in OutputConfig, when workers complete
	// labeling tasks, Ground Truth will send labeling task output data to the SNS
	// output topic you specify here. To learn more, see Receive Output Data from a
	// Streaming Labeling Job
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data).
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// Configure encryption on the storage volume attached to the ML compute instance
// used to run automated data labeling model training and inference.
type LabelingJobResourceConfig struct {

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume attached to the
	// ML compute instance(s) that run the training and inference jobs used for
	// automated data labeling. You can only specify a VolumeKmsKeyId when you create a
	// labeling job with automated data labeling enabled using the API operation
	// CreateLabelingJob. You cannot specify an Amazon Web Services KMS key to encrypt
	// the storage volume used for automated data labeling model training and inference
	// when you create a labeling job using the console. To learn more, see Output Data
	// and Storage Volume Encryption
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security.html). The
	// VolumeKmsKeyId can be any of the following formats:
	//
	// * KMS Key ID
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * Amazon Resource Name (ARN) of a KMS
	// Key
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Specifies a VPC that your training jobs and hosted models have access to.
	// Control access to and from your training and model containers by configuring the
	// VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
	// and Protect Training Jobs by Using an Amazon Virtual Private Cloud
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The Amazon S3 location of the input data objects.
type LabelingJobS3DataSource struct {

	// The Amazon S3 location of the manifest file that describes the input data
	// objects. The input manifest file referenced in ManifestS3Uri must contain one of
	// the following keys: source-ref or source. The value of the keys are interpreted
	// as follows:
	//
	// * source-ref: The source of the object is the Amazon S3 object
	// specified in the value. Use this value when the object is a binary object, such
	// as an image.
	//
	// * source: The source of the object is the value. Use this value
	// when the object is a text value.
	//
	// If you are a new user of Ground Truth, it is
	// recommended you review Use an Input Manifest File
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html)
	// in the Amazon SageMaker Developer Guide to learn how to create an input manifest
	// file.
	//
	// This member is required.
	ManifestS3Uri *string

	noSmithyDocumentSerde
}

// An Amazon SNS data source used for streaming labeling jobs.
type LabelingJobSnsDataSource struct {

	// The Amazon SNS input topic Amazon Resource Name (ARN). Specify the ARN of the
	// input topic you will use to send new data objects to a streaming labeling job.
	//
	// This member is required.
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// A set of conditions for stopping a labeling job. If any of the conditions are
// met, the job is automatically stopped. You can use these conditions to control
// the cost of data labeling. Labeling jobs fail after 30 days with an appropriate
// client error message.
type LabelingJobStoppingConditions struct {

	// The maximum number of objects that can be labeled by human workers.
	MaxHumanLabeledObjectCount *int32

	// The maximum number of input data objects that should be labeled.
	MaxPercentageOfInputDatasetLabeled *int32

	noSmithyDocumentSerde
}

// Provides summary information about a labeling job.
type LabelingJobSummary struct {

	// The date and time that the job was created (timestamp).
	//
	// This member is required.
	CreationTime *time.Time

	// Counts showing the progress of the labeling job.
	//
	// This member is required.
	LabelCounters *LabelCounters

	// The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
	//
	// This member is required.
	LabelingJobArn *string

	// The name of the labeling job.
	//
	// This member is required.
	LabelingJobName *string

	// The current status of the labeling job.
	//
	// This member is required.
	LabelingJobStatus LabelingJobStatus

	// The date and time that the job was last modified (timestamp).
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of a Lambda function. The function is run before
	// each data object is sent to a worker.
	//
	// This member is required.
	PreHumanTaskLambdaArn *string

	// The Amazon Resource Name (ARN) of the work team assigned to the job.
	//
	// This member is required.
	WorkteamArn *string

	// The Amazon Resource Name (ARN) of the Lambda function used to consolidate the
	// annotations from individual workers into a label for a data object. For more
	// information, see Annotation Consolidation
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
	AnnotationConsolidationLambdaArn *string

	// If the LabelingJobStatus field is Failed, this field contains a description of
	// the error.
	FailureReason *string

	// Input configuration for the labeling job.
	InputConfig *LabelingJobInputConfig

	// The location of the output produced by the labeling job.
	LabelingJobOutput *LabelingJobOutput

	noSmithyDocumentSerde
}

// Metadata for a Lambda step.
type LambdaStepMetadata struct {

	// The Amazon Resource Name (ARN) of the Lambda function that was run by this step
	// execution.
	Arn *string

	// A list of the output parameters of the Lambda step.
	OutputParameters []OutputParameter

	noSmithyDocumentSerde
}

// A value that indicates whether the update was successful.
type LastUpdateStatus struct {

	// A value that indicates whether the update was made successful.
	//
	// This member is required.
	Status LastUpdateStatusValue

	// If the update wasn't successful, indicates the reason why it failed.
	FailureReason *string

	noSmithyDocumentSerde
}

// Lists a summary of the properties of a lineage group. A lineage group provides a
// group of shareable lineage entity resources.
type LineageGroupSummary struct {

	// The creation time of the lineage group summary.
	CreationTime *time.Time

	// The display name of the lineage group summary.
	DisplayName *string

	// The last modified time of the lineage group summary.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the lineage group resource.
	LineageGroupArn *string

	// The name or Amazon Resource Name (ARN) of the lineage group.
	LineageGroupName *string

	noSmithyDocumentSerde
}

// Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work
// team.
type MemberDefinition struct {

	// The Amazon Cognito user group that is part of the work team.
	CognitoMemberDefinition *CognitoMemberDefinition

	// A list user groups that exist in your OIDC Identity Provider (IdP). One to ten
	// groups can be used to create a single private work team. When you add a user
	// group to the list of Groups, you can add that user group to one or more private
	// work teams. If you add a user group to a private work team, all workers in that
	// user group are added to the work team.
	OidcMemberDefinition *OidcMemberDefinition

	noSmithyDocumentSerde
}

// Metadata properties of the tracking entity, trial, or trial component.
type MetadataProperties struct {

	// The commit ID.
	CommitId *string

	// The entity this entity was generated by.
	GeneratedBy *string

	// The project ID.
	ProjectId *string

	// The repository.
	Repository *string

	noSmithyDocumentSerde
}

// The name, value, and date and time of a metric that was emitted to Amazon
// CloudWatch.
type MetricData struct {

	// The name of the metric.
	MetricName *string

	// The date and time that the algorithm emitted the metric.
	Timestamp *time.Time

	// The value of the metric.
	Value float32

	noSmithyDocumentSerde
}

// Information about the metric for a candidate produced by an AutoML job.
type MetricDatum struct {

	// The name of the metric.
	MetricName AutoMLMetricEnum

	// The dataset split from which the AutoML job produced the metric.
	Set MetricSetSource

	// The name of the standard metric. For definitions of the standard metrics, see
	// Autopilot candidate metrics
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics).
	StandardMetricName AutoMLMetricExtendedEnum

	// The value of the metric.
	Value float32

	noSmithyDocumentSerde
}

// Specifies a metric that the training algorithm writes to stderr or stdout.
// SageMakerhyperparameter tuning captures all defined metrics. You specify one
// metric that a hyperparameter tuning job uses as its objective metric to choose
// the best training job.
type MetricDefinition struct {

	// The name of the metric.
	//
	// This member is required.
	Name *string

	// A regular expression that searches the output of a training job and gets the
	// value of the metric. For more information about using regular expressions to
	// define metrics, see Defining Objective Metrics
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html).
	//
	// This member is required.
	Regex *string

	noSmithyDocumentSerde
}

// Details about the metrics source.
type MetricsSource struct {

	// The metric source content type.
	//
	// This member is required.
	ContentType *string

	// The S3 URI for the metrics source.
	//
	// This member is required.
	S3Uri *string

	// The hash key used for the metrics source.
	ContentDigest *string

	noSmithyDocumentSerde
}

// Provides information about the location that is configured for storing model
// artifacts. Model artifacts are the output that results from training a model,
// and typically consist of trained parameters, a model definition that describes
// how to compute inferences, and other metadata.
type ModelArtifacts struct {

	// The path of the S3 object that contains the model artifacts. For example,
	// s3://bucket-name/keynameprefix/model.tar.gz.
	//
	// This member is required.
	S3ModelArtifacts *string

	noSmithyDocumentSerde
}

// Docker container image configuration object for the model bias job.
type ModelBiasAppSpecification struct {

	// JSON formatted S3 file that defines bias parameters. For more information on
	// this JSON configuration file, see Configure bias parameters
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html).
	//
	// This member is required.
	ConfigUri *string

	// The container image to be run by the model bias job.
	//
	// This member is required.
	ImageUri *string

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	noSmithyDocumentSerde
}

// The configuration for a baseline model bias job.
type ModelBiasBaselineConfig struct {

	// The name of the baseline model bias job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	noSmithyDocumentSerde
}

// Inputs for the model bias job.
type ModelBiasJobInput struct {

	// Input object for the endpoint
	//
	// This member is required.
	EndpointInput *EndpointInput

	// Location of ground truth labels to use in model bias job.
	//
	// This member is required.
	GroundTruthS3Input *MonitoringGroundTruthS3Input

	noSmithyDocumentSerde
}

// Configures the timeout and maximum number of retries for processing a transform
// job invocation.
type ModelClientConfig struct {

	// The maximum number of retries when invocation requests are failing. The default
	// value is 3.
	InvocationsMaxRetries *int32

	// The timeout value in seconds for an invocation request. The default value is
	// 600.
	InvocationsTimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// Defines the model configuration. Includes the specification name and environment
// parameters.
type ModelConfiguration struct {

	// Defines the environment parameters that includes key, value types, and values.
	EnvironmentParameters []EnvironmentParameter

	// The inference specification name in the model package version.
	InferenceSpecificationName *string

	noSmithyDocumentSerde
}

// Data quality constraints and statistics for a model.
type ModelDataQuality struct {

	// Data quality constraints for a model.
	Constraints *MetricsSource

	// Data quality statistics for a model.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// Specifies how to generate the endpoint name for an automatic one-click Autopilot
// model deployment.
type ModelDeployConfig struct {

	// Set to True to automatically generate an endpoint name for a one-click Autopilot
	// model deployment; set to False otherwise. The default value is False. If you set
	// AutoGenerateEndpointName to True, do not specify the EndpointName; otherwise a
	// 400 error is thrown.
	AutoGenerateEndpointName bool

	// Specifies the endpoint name to use for a one-click Autopilot model deployment if
	// the endpoint name is not generated automatically. Specify the EndpointName if
	// and only if you set AutoGenerateEndpointName to False; otherwise a 400 error is
	// thrown.
	EndpointName *string

	noSmithyDocumentSerde
}

// Provides information about the endpoint of the model deployment.
type ModelDeployResult struct {

	// The name of the endpoint to which the model has been deployed. If model
	// deployment fails, this field is omitted from the response.
	EndpointName *string

	noSmithyDocumentSerde
}

// Provides information to verify the integrity of stored model artifacts.
type ModelDigests struct {

	// Provides a hash value that uniquely identifies the stored model artifacts.
	ArtifactDigest *string

	noSmithyDocumentSerde
}

// Docker container image configuration object for the model explainability job.
type ModelExplainabilityAppSpecification struct {

	// JSON formatted S3 file that defines explainability parameters. For more
	// information on this JSON configuration file, see Configure model explainability
	// parameters
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-model-explainability-parameters.html).
	//
	// This member is required.
	ConfigUri *string

	// The container image to be run by the model explainability job.
	//
	// This member is required.
	ImageUri *string

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	noSmithyDocumentSerde
}

// The configuration for a baseline model explainability job.
type ModelExplainabilityBaselineConfig struct {

	// The name of the baseline model explainability job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	noSmithyDocumentSerde
}

// Inputs for the model explainability job.
type ModelExplainabilityJobInput struct {

	// Input object for the endpoint
	//
	// This member is required.
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// Input object for the model.
type ModelInput struct {

	// The input configuration object for the model.
	//
	// This member is required.
	DataInputConfig *string

	noSmithyDocumentSerde
}

// The model latency threshold.
type ModelLatencyThreshold struct {

	// The model latency percentile threshold.
	Percentile *string

	// The model latency percentile value in milliseconds.
	ValueInMilliseconds int32

	noSmithyDocumentSerde
}

// Part of the search expression. You can specify the name and value (domain, task,
// framework, framework version, task, and model).
type ModelMetadataFilter struct {

	// The name of the of the model to filter by.
	//
	// This member is required.
	Name ModelMetadataFilterType

	// The value to filter the model metadata.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// One or more filters that searches for the specified resource or resources in a
// search. All resource objects that satisfy the expression's condition are
// included in the search results
type ModelMetadataSearchExpression struct {

	// A list of filter objects.
	Filters []ModelMetadataFilter

	noSmithyDocumentSerde
}

// A summary of the model metadata.
type ModelMetadataSummary struct {

	// The machine learning domain of the model.
	//
	// This member is required.
	Domain *string

	// The machine learning framework of the model.
	//
	// This member is required.
	Framework *string

	// The framework version of the model.
	//
	// This member is required.
	FrameworkVersion *string

	// The name of the model.
	//
	// This member is required.
	Model *string

	// The machine learning task of the model.
	//
	// This member is required.
	Task *string

	noSmithyDocumentSerde
}

// Contains metrics captured from a model.
type ModelMetrics struct {

	// Metrics that measure bais in a model.
	Bias *Bias

	// Metrics that help explain a model.
	Explainability *Explainability

	// Metrics that measure the quality of the input data for a model.
	ModelDataQuality *ModelDataQuality

	// Metrics that measure the quality of a model.
	ModelQuality *ModelQuality

	noSmithyDocumentSerde
}

// A versioned model that can be deployed for SageMaker inference.
type ModelPackage struct {

	// An array of additional Inference Specification objects.
	AdditionalInferenceSpecifications []AdditionalInferenceSpecificationDefinition

	// A description provided when the model approval is set.
	ApprovalDescription *string

	// Whether the model package is to be certified to be listed on Amazon Web Services
	// Marketplace. For information about listing model packages on Amazon Web Services
	// Marketplace, see List Your Algorithm or Model Package on Amazon Web Services
	// Marketplace
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html).
	CertifyForMarketplace bool

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// The time that the model package was created.
	CreationTime *time.Time

	// The metadata properties for the model package.
	CustomerMetadataProperties map[string]string

	// The machine learning domain of your model package and its components. Common
	// machine learning domains include computer vision and natural language
	// processing.
	Domain *string

	// Represents the drift check baselines that can be used when the model monitor is
	// set using the model package.
	DriftCheckBaselines *DriftCheckBaselines

	// Defines how to perform inference generation after a training job is run.
	InferenceSpecification *InferenceSpecification

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// The last time the model package was modified.
	LastModifiedTime *time.Time

	// Metadata properties of the tracking entity, trial, or trial component.
	MetadataProperties *MetadataProperties

	// The approval status of the model. This can be one of the following values.
	//
	// *
	// APPROVED - The model is approved
	//
	// * REJECTED - The model is rejected.
	//
	// *
	// PENDING_MANUAL_APPROVAL - The model is waiting for manual approval.
	ModelApprovalStatus ModelApprovalStatus

	// Metrics for the model.
	ModelMetrics *ModelMetrics

	// The Amazon Resource Name (ARN) of the model package.
	ModelPackageArn *string

	// The description of the model package.
	ModelPackageDescription *string

	// The model group to which the model belongs.
	ModelPackageGroupName *string

	// The name of the model.
	ModelPackageName *string

	// The status of the model package. This can be one of the following values.
	//
	// *
	// PENDING - The model package is pending being created.
	//
	// * IN_PROGRESS - The model
	// package is in the process of being created.
	//
	// * COMPLETED - The model package was
	// successfully created.
	//
	// * FAILED - The model package failed.
	//
	// * DELETING - The
	// model package is in the process of being deleted.
	ModelPackageStatus ModelPackageStatus

	// Specifies the validation and image scan statuses of the model package.
	ModelPackageStatusDetails *ModelPackageStatusDetails

	// The version number of a versioned model.
	ModelPackageVersion *int32

	// The Amazon Simple Storage Service path where the sample payload are stored. This
	// path must point to a single gzip compressed tar archive (.tar.gz suffix).
	SamplePayloadUrl *string

	// A list of algorithms that were used to create a model package.
	SourceAlgorithmSpecification *SourceAlgorithmSpecification

	// A list of the tags associated with the model package. For more information, see
	// Tagging Amazon Web Services resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the Amazon
	// Web Services General Reference Guide.
	Tags []Tag

	// The machine learning task your model package accomplishes. Common machine
	// learning tasks include object detection and image classification.
	Task *string

	// Specifies batch transform jobs that SageMaker runs to validate your model
	// package.
	ValidationSpecification *ModelPackageValidationSpecification

	noSmithyDocumentSerde
}

// Describes the Docker container for the model package.
type ModelPackageContainerDefinition struct {

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code is
	// stored. If you are using your own custom algorithm instead of an algorithm
	// provided by SageMaker, the inference code must meet SageMaker requirements.
	// SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see Using
	// Your Own Algorithms with Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	//
	// This member is required.
	Image *string

	// The DNS host name for the Docker container.
	ContainerHostname *string

	// The environment variables to set in the Docker container. Each key and value in
	// the Environment string to string map can have length of up to 1024. We support
	// up to 16 entries in the map.
	Environment map[string]string

	// The machine learning framework of the model package container image.
	Framework *string

	// The framework version of the Model Package Container Image.
	FrameworkVersion *string

	// An MD5 hash of the training algorithm that identifies the Docker image used for
	// training.
	ImageDigest *string

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix). The model artifacts must be in an S3 bucket that is in the
	// same region as the model package.
	ModelDataUrl *string

	// A structure with Model Input details.
	ModelInput *ModelInput

	// The name of a pre-trained machine learning benchmarked by Amazon SageMaker
	// Inference Recommender model that matches your model. You can find a list of
	// benchmarked models by calling ListModelMetadata.
	NearestModelName *string

	// The Amazon Web Services Marketplace product ID of the model package.
	ProductId *string

	noSmithyDocumentSerde
}

// A group of versioned models in the model registry.
type ModelPackageGroup struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// The time that the model group was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model group.
	ModelPackageGroupArn *string

	// The description for the model group.
	ModelPackageGroupDescription *string

	// The name of the model group.
	ModelPackageGroupName *string

	// The status of the model group. This can be one of the following values.
	//
	// *
	// PENDING - The model group is pending being created.
	//
	// * IN_PROGRESS - The model
	// group is in the process of being created.
	//
	// * COMPLETED - The model group was
	// successfully created.
	//
	// * FAILED - The model group failed.
	//
	// * DELETING - The
	// model group is in the process of being deleted.
	//
	// * DELETE_FAILED - SageMaker
	// failed to delete the model group.
	ModelPackageGroupStatus ModelPackageGroupStatus

	// A list of the tags associated with the model group. For more information, see
	// Tagging Amazon Web Services resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the Amazon
	// Web Services General Reference Guide.
	Tags []Tag

	noSmithyDocumentSerde
}

// Summary information about a model group.
type ModelPackageGroupSummary struct {

	// The time that the model group was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model group.
	//
	// This member is required.
	ModelPackageGroupArn *string

	// The name of the model group.
	//
	// This member is required.
	ModelPackageGroupName *string

	// The status of the model group.
	//
	// This member is required.
	ModelPackageGroupStatus ModelPackageGroupStatus

	// A description of the model group.
	ModelPackageGroupDescription *string

	noSmithyDocumentSerde
}

// Specifies the validation and image scan statuses of the model package.
type ModelPackageStatusDetails struct {

	// The validation status of the model package.
	//
	// This member is required.
	ValidationStatuses []ModelPackageStatusItem

	// The status of the scan of the Docker image container for the model package.
	ImageScanStatuses []ModelPackageStatusItem

	noSmithyDocumentSerde
}

// Represents the overall status of a model package.
type ModelPackageStatusItem struct {

	// The name of the model package for which the overall status is being reported.
	//
	// This member is required.
	Name *string

	// The current status.
	//
	// This member is required.
	Status DetailedModelPackageStatus

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Provides summary information about a model package.
type ModelPackageSummary struct {

	// A timestamp that shows when the model package was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model package.
	//
	// This member is required.
	ModelPackageArn *string

	// The name of the model package.
	//
	// This member is required.
	ModelPackageName *string

	// The overall status of the model package.
	//
	// This member is required.
	ModelPackageStatus ModelPackageStatus

	// The approval status of the model. This can be one of the following values.
	//
	// *
	// APPROVED - The model is approved
	//
	// * REJECTED - The model is rejected.
	//
	// *
	// PENDING_MANUAL_APPROVAL - The model is waiting for manual approval.
	ModelApprovalStatus ModelApprovalStatus

	// A brief description of the model package.
	ModelPackageDescription *string

	// If the model package is a versioned model, the model group that the versioned
	// model belongs to.
	ModelPackageGroupName *string

	// If the model package is a versioned model, the version of the model.
	ModelPackageVersion *int32

	noSmithyDocumentSerde
}

// Contains data, such as the inputs and targeted instance types that are used in
// the process of validating the model package. The data provided in the validation
// profile is made available to your buyers on Amazon Web Services Marketplace.
type ModelPackageValidationProfile struct {

	// The name of the profile for the model package.
	//
	// This member is required.
	ProfileName *string

	// The TransformJobDefinition object that describes the transform job used for the
	// validation of the model package.
	//
	// This member is required.
	TransformJobDefinition *TransformJobDefinition

	noSmithyDocumentSerde
}

// Specifies batch transform jobs that SageMaker runs to validate your model
// package.
type ModelPackageValidationSpecification struct {

	// An array of ModelPackageValidationProfile objects, each of which specifies a
	// batch transform job that SageMaker runs to validate your model package.
	//
	// This member is required.
	ValidationProfiles []ModelPackageValidationProfile

	// The IAM roles to be used for the validation of the model package.
	//
	// This member is required.
	ValidationRole *string

	noSmithyDocumentSerde
}

// Model quality statistics and constraints.
type ModelQuality struct {

	// Model quality constraints.
	Constraints *MetricsSource

	// Model quality statistics.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// Container image configuration object for the monitoring job.
type ModelQualityAppSpecification struct {

	// The address of the container image that the monitoring job runs.
	//
	// This member is required.
	ImageUri *string

	// An array of arguments for the container used to run the monitoring job.
	ContainerArguments []string

	// Specifies the entrypoint for a container that the monitoring job runs.
	ContainerEntrypoint []string

	// Sets the environment variables in the container that the monitoring job runs.
	Environment map[string]string

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string

	// The machine learning problem type of the model that the monitoring job monitors.
	ProblemType MonitoringProblemType

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flatted json so that the
	// built-in container can use the converted data. Applicable only for the built-in
	// (first party) containers.
	RecordPreprocessorSourceUri *string

	noSmithyDocumentSerde
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from the
// series of jobs scheduled to collect data periodically.
type ModelQualityBaselineConfig struct {

	// The name of the job that performs baselining for the monitoring job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	noSmithyDocumentSerde
}

// The input for the model quality monitoring job. Currently endponts are supported
// for input for model quality monitoring jobs.
type ModelQualityJobInput struct {

	// Input object for the endpoint
	//
	// This member is required.
	EndpointInput *EndpointInput

	// The ground truth label provided for the model.
	//
	// This member is required.
	GroundTruthS3Input *MonitoringGroundTruthS3Input

	noSmithyDocumentSerde
}

// Metadata for Model steps.
type ModelStepMetadata struct {

	// The Amazon Resource Name (ARN) of the created model.
	Arn *string

	noSmithyDocumentSerde
}

// Provides summary information about a model.
type ModelSummary struct {

	// A timestamp that indicates when the model was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model.
	//
	// This member is required.
	ModelArn *string

	// The name of the model that you want a summary for.
	//
	// This member is required.
	ModelName *string

	noSmithyDocumentSerde
}

// Container image configuration object for the monitoring job.
type MonitoringAppSpecification struct {

	// The container image to be run by the monitoring job.
	//
	// This member is required.
	ImageUri *string

	// An array of arguments for the container used to run the monitoring job.
	ContainerArguments []string

	// Specifies the entrypoint for a container used to run the monitoring job.
	ContainerEntrypoint []string

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flatted json so that the
	// built-in container can use the converted data. Applicable only for the built-in
	// (first party) containers.
	RecordPreprocessorSourceUri *string

	noSmithyDocumentSerde
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from the
// series of jobs scheduled to collect data periodically.
type MonitoringBaselineConfig struct {

	// The name of the job that performs baselining for the monitoring job.
	BaseliningJobName *string

	// The baseline constraint file in Amazon S3 that the current monitoring job should
	// validated against.
	ConstraintsResource *MonitoringConstraintsResource

	// The baseline statistics file in Amazon S3 that the current monitoring job should
	// be validated against.
	StatisticsResource *MonitoringStatisticsResource

	noSmithyDocumentSerde
}

// Configuration for the cluster used to run model monitoring jobs.
type MonitoringClusterConfig struct {

	// The number of ML compute instances to use in the model monitoring job. For
	// distributed processing jobs, specify a value greater than 1. The default value
	// is 1.
	//
	// This member is required.
	InstanceCount *int32

	// The ML compute instance type for the processing job.
	//
	// This member is required.
	InstanceType ProcessingInstanceType

	// The size of the ML storage volume, in gigabytes, that you want to provision. You
	// must specify sufficient ML storage for your scenario.
	//
	// This member is required.
	VolumeSizeInGB *int32

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume attached to the
	// ML compute instance(s) that run the model monitoring job.
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// The constraints resource for a monitoring job.
type MonitoringConstraintsResource struct {

	// The Amazon S3 URI for the constraints resource.
	S3Uri *string

	noSmithyDocumentSerde
}

// Summary of information about the last monitoring job to run.
type MonitoringExecutionSummary struct {

	// The time at which the monitoring job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// A timestamp that indicates the last time the monitoring job was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The status of the monitoring job.
	//
	// This member is required.
	MonitoringExecutionStatus ExecutionStatus

	// The name of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleName *string

	// The time the monitoring job was scheduled.
	//
	// This member is required.
	ScheduledTime *time.Time

	// The name of the endpoint used to run the monitoring job.
	EndpointName *string

	// Contains the reason a monitoring job failed, if it failed.
	FailureReason *string

	// The name of the monitoring job.
	MonitoringJobDefinitionName *string

	// The type of the monitoring job.
	MonitoringType MonitoringType

	// The Amazon Resource Name (ARN) of the monitoring job.
	ProcessingJobArn *string

	noSmithyDocumentSerde
}

// The ground truth labels for the dataset used for the monitoring job.
type MonitoringGroundTruthS3Input struct {

	// The address of the Amazon S3 location of the ground truth labels.
	S3Uri *string

	noSmithyDocumentSerde
}

// The inputs for a monitoring job.
type MonitoringInput struct {

	// The endpoint for a monitoring job.
	//
	// This member is required.
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// Defines the monitoring job.
type MonitoringJobDefinition struct {

	// Configures the monitoring job to run a specified Docker container image.
	//
	// This member is required.
	MonitoringAppSpecification *MonitoringAppSpecification

	// The array of inputs for the monitoring job. Currently we support monitoring an
	// Amazon SageMaker Endpoint.
	//
	// This member is required.
	MonitoringInputs []MonitoringInput

	// The array of outputs from the monitoring job to be uploaded to Amazon Simple
	// Storage Service (Amazon S3).
	//
	// This member is required.
	MonitoringOutputConfig *MonitoringOutputConfig

	// Identifies the resources, ML compute instances, and ML storage volumes to deploy
	// for a monitoring job. In distributed processing, you specify more than one
	// instance.
	//
	// This member is required.
	MonitoringResources *MonitoringResources

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// This member is required.
	RoleArn *string

	// Baseline configuration used to validate that the data conforms to the specified
	// constraints and statistics
	BaselineConfig *MonitoringBaselineConfig

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	// Specifies networking options for an monitoring job.
	NetworkConfig *NetworkConfig

	// Specifies a time limit for how long the monitoring job is allowed to run.
	StoppingCondition *MonitoringStoppingCondition

	noSmithyDocumentSerde
}

// Summary information about a monitoring job.
type MonitoringJobDefinitionSummary struct {

	// The time that the monitoring job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The name of the endpoint that the job monitors.
	//
	// This member is required.
	EndpointName *string

	// The Amazon Resource Name (ARN) of the monitoring job.
	//
	// This member is required.
	MonitoringJobDefinitionArn *string

	// The name of the monitoring job.
	//
	// This member is required.
	MonitoringJobDefinitionName *string

	noSmithyDocumentSerde
}

// The networking configuration for the monitoring job.
type MonitoringNetworkConfig struct {

	// Whether to encrypt all communications between the instances used for the
	// monitoring jobs. Choose True to encrypt communications. Encryption provides
	// greater security for distributed jobs, but the processing might take longer.
	EnableInterContainerTrafficEncryption bool

	// Whether to allow inbound and outbound network calls to and from the containers
	// used for the monitoring job.
	EnableNetworkIsolation bool

	// Specifies a VPC that your training jobs and hosted models have access to.
	// Control access to and from your training and model containers by configuring the
	// VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
	// and Protect Training Jobs by Using an Amazon Virtual Private Cloud
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The output object for a monitoring job.
type MonitoringOutput struct {

	// The Amazon S3 storage location where the results of a monitoring job are saved.
	//
	// This member is required.
	S3Output *MonitoringS3Output

	noSmithyDocumentSerde
}

// The output configuration for monitoring jobs.
type MonitoringOutputConfig struct {

	// Monitoring outputs for monitoring jobs. This is where the output of the periodic
	// monitoring jobs is uploaded.
	//
	// This member is required.
	MonitoringOutputs []MonitoringOutput

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon
	// S3 server-side encryption.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Identifies the resources to deploy for a monitoring job.
type MonitoringResources struct {

	// The configuration for the cluster resources used to run the processing job.
	//
	// This member is required.
	ClusterConfig *MonitoringClusterConfig

	noSmithyDocumentSerde
}

// Information about where and how you want to store the results of a monitoring
// job.
type MonitoringS3Output struct {

	// The local path to the Amazon S3 storage location where Amazon SageMaker saves
	// the results of a monitoring job. LocalPath is an absolute path for the output
	// data.
	//
	// This member is required.
	LocalPath *string

	// A URI that identifies the Amazon S3 storage location where Amazon SageMaker
	// saves the results of a monitoring job.
	//
	// This member is required.
	S3Uri *string

	// Whether to upload the results of the monitoring job continuously or after the
	// job completes.
	S3UploadMode ProcessingS3UploadMode

	noSmithyDocumentSerde
}

// A schedule for a model monitoring job. For information about model monitor, see
// Amazon SageMaker Model Monitor
// (https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
type MonitoringSchedule struct {

	// The time that the monitoring schedule was created.
	CreationTime *time.Time

	// The endpoint that hosts the model being monitored.
	EndpointName *string

	// If the monitoring schedule failed, the reason it failed.
	FailureReason *string

	// The last time the monitoring schedule was changed.
	LastModifiedTime *time.Time

	// Summary of information about the last monitoring job to run.
	LastMonitoringExecutionSummary *MonitoringExecutionSummary

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	MonitoringScheduleArn *string

	// Configures the monitoring schedule and defines the monitoring job.
	MonitoringScheduleConfig *MonitoringScheduleConfig

	// The name of the monitoring schedule.
	MonitoringScheduleName *string

	// The status of the monitoring schedule. This can be one of the following
	// values.
	//
	// * PENDING - The schedule is pending being created.
	//
	// * FAILED - The
	// schedule failed.
	//
	// * SCHEDULED - The schedule was successfully created.
	//
	// *
	// STOPPED - The schedule was stopped.
	MonitoringScheduleStatus ScheduleStatus

	// The type of the monitoring job definition to schedule.
	MonitoringType MonitoringType

	// A list of the tags associated with the monitoring schedlue. For more
	// information, see Tagging Amazon Web Services resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the Amazon
	// Web Services General Reference Guide.
	Tags []Tag

	noSmithyDocumentSerde
}

// Configures the monitoring schedule and defines the monitoring job.
type MonitoringScheduleConfig struct {

	// Defines the monitoring job.
	MonitoringJobDefinition *MonitoringJobDefinition

	// The name of the monitoring job definition to schedule.
	MonitoringJobDefinitionName *string

	// The type of the monitoring job definition to schedule.
	MonitoringType MonitoringType

	// Configures the monitoring schedule.
	ScheduleConfig *ScheduleConfig

	noSmithyDocumentSerde
}

// Summarizes the monitoring schedule.
type MonitoringScheduleSummary struct {

	// The creation time of the monitoring schedule.
	//
	// This member is required.
	CreationTime *time.Time

	// The last time the monitoring schedule was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleArn *string

	// The name of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleName *string

	// The status of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleStatus ScheduleStatus

	// The name of the endpoint using the monitoring schedule.
	EndpointName *string

	// The name of the monitoring job definition that the schedule is for.
	MonitoringJobDefinitionName *string

	// The type of the monitoring job definition that the schedule is for.
	MonitoringType MonitoringType

	noSmithyDocumentSerde
}

// The statistics resource for a monitoring job.
type MonitoringStatisticsResource struct {

	// The Amazon S3 URI for the statistics resource.
	S3Uri *string

	noSmithyDocumentSerde
}

// A time limit for how long the monitoring job is allowed to run before stopping.
type MonitoringStoppingCondition struct {

	// The maximum runtime allowed in seconds. The MaxRuntimeInSeconds cannot exceed
	// the frequency of the job. For data quality and model explainability, this can be
	// up to 3600 seconds for an hourly schedule. For model bias and model quality
	// hourly schedules, this can be up to 1800 seconds.
	//
	// This member is required.
	MaxRuntimeInSeconds int32

	noSmithyDocumentSerde
}

// Specifies additional configuration for hosting multi-model endpoints.
type MultiModelConfig struct {

	// Whether to cache models for a multi-model endpoint. By default, multi-model
	// endpoints cache models so that a model does not have to be loaded into memory
	// each time it is invoked. Some use cases do not benefit from model caching. For
	// example, if an endpoint hosts a large number of models that are each invoked
	// infrequently, the endpoint might perform better if you disable model caching. To
	// disable model caching, set the value of this parameter to Disabled.
	ModelCacheSetting ModelCacheSetting

	noSmithyDocumentSerde
}

// The VpcConfig configuration object that specifies the VPC that you want the
// compilation jobs to connect to. For more information on controlling access to
// your Amazon S3 buckets used for compilation job, see Give Amazon SageMaker
// Compilation Jobs Access to Resources in Your Amazon VPC
// (https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).
type NeoVpcConfig struct {

	// The VPC security group IDs. IDs have the form of sg-xxxxxxxx. Specify the
	// security groups for the VPC that is specified in the Subnets field.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC that you want to connect the compilation job to
	// for accessing the model in Amazon S3.
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// A list of nested Filter objects. A resource must satisfy the conditions of all
// filters to be included in the results returned from the Search API. For example,
// to filter on a training job's InputDataConfig property with a specific channel
// name and S3Uri prefix, define the following filters:
//
// *
// '{Name:"InputDataConfig.ChannelName", "Operator":"Equals", "Value":"train"}',
//
// *
// '{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"Contains",
// "Value":"mybucket/catdata"}'
type NestedFilters struct {

	// A list of filters. Each filter acts on a property. Filters must contain at least
	// one Filters value. For example, a NestedFilters call might include a filter on
	// the PropertyName parameter of the InputDataConfig property:
	// InputDataConfig.DataSource.S3DataSource.S3Uri.
	//
	// This member is required.
	Filters []Filter

	// The name of the property to use in the nested filters. The value must match a
	// listed property name, such as InputDataConfig.
	//
	// This member is required.
	NestedPropertyName *string

	noSmithyDocumentSerde
}

// Networking options for a job, such as network traffic encryption between
// containers, whether to allow inbound and outbound network calls to and from
// containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
type NetworkConfig struct {

	// Whether to encrypt all communications between distributed processing jobs.
	// Choose True to encrypt communications. Encryption provides greater security for
	// distributed processing jobs, but the processing might take longer.
	EnableInterContainerTrafficEncryption bool

	// Whether to allow inbound and outbound network calls to and from the containers
	// used for the processing job.
	EnableNetworkIsolation bool

	// Specifies a VPC that your training jobs and hosted models have access to.
	// Control access to and from your training and model containers by configuring the
	// VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
	// and Protect Training Jobs by Using an Amazon Virtual Private Cloud
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Provides a summary of a notebook instance lifecycle configuration.
type NotebookInstanceLifecycleConfigSummary struct {

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	//
	// This member is required.
	NotebookInstanceLifecycleConfigArn *string

	// The name of the lifecycle configuration.
	//
	// This member is required.
	NotebookInstanceLifecycleConfigName *string

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains the notebook instance lifecycle configuration script. Each lifecycle
// configuration script has a limit of 16384 characters. The value of the $PATH
// environment variable that is available to both scripts is
// /sbin:bin:/usr/sbin:/usr/bin. View CloudWatch Logs for notebook instance
// lifecycle configurations in log group /aws/sagemaker/NotebookInstances in log
// stream [notebook-instance-name]/[LifecycleConfigHook]. Lifecycle configuration
// scripts cannot run for longer than 5 minutes. If a script runs for longer than 5
// minutes, it fails and the notebook instance is not created or started. For
// information about notebook instance lifestyle configurations, see Step 2.1:
// (Optional) Customize a Notebook Instance
// (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
type NotebookInstanceLifecycleHook struct {

	// A base64-encoded string that contains a shell script for a notebook instance
	// lifecycle configuration.
	Content *string

	noSmithyDocumentSerde
}

// Provides summary information for an SageMaker notebook instance.
type NotebookInstanceSummary struct {

	// The Amazon Resource Name (ARN) of the notebook instance.
	//
	// This member is required.
	NotebookInstanceArn *string

	// The name of the notebook instance that you want a summary for.
	//
	// This member is required.
	NotebookInstanceName *string

	// An array of up to three Git repositories associated with the notebook instance.
	// These can be either the names of Git repositories stored as resources in your
	// account, or the URL of Git repositories in Amazon Web Services CodeCommit
	// (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any
	// other Git repository. These repositories are cloned at the same level as the
	// default repository of your notebook instance. For more information, see
	// Associating Git Repositories with SageMaker Notebook Instances
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	AdditionalCodeRepositories []string

	// A timestamp that shows when the notebook instance was created.
	CreationTime *time.Time

	// The Git repository associated with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in Amazon Web Services
	// CodeCommit
	// (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any
	// other Git repository. When you open a notebook instance, it opens in the
	// directory that contains this repository. For more information, see Associating
	// Git Repositories with SageMaker Notebook Instances
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	DefaultCodeRepository *string

	// The type of ML compute instance that the notebook instance is running on.
	InstanceType InstanceType

	// A timestamp that shows when the notebook instance was last modified.
	LastModifiedTime *time.Time

	// The name of a notebook instance lifecycle configuration associated with this
	// notebook instance. For information about notebook instance lifestyle
	// configurations, see Step 2.1: (Optional) Customize a Notebook Instance
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
	NotebookInstanceLifecycleConfigName *string

	// The status of the notebook instance.
	NotebookInstanceStatus NotebookInstanceStatus

	// The URL that you use to connect to the Jupyter notebook running in your notebook
	// instance.
	Url *string

	noSmithyDocumentSerde
}

// Configures Amazon SNS notifications of available or expiring work items for work
// teams.
type NotificationConfiguration struct {

	// The ARN for the Amazon SNS topic to which notifications should be published.
	NotificationTopicArn *string

	noSmithyDocumentSerde
}

// Specifies the number of training jobs that this hyperparameter tuning job
// launched, categorized by the status of their objective metric. The objective
// metric status shows whether the final objective metric for the training job has
// been evaluated by the tuning job and used in the hyperparameter tuning process.
type ObjectiveStatusCounters struct {

	// The number of training jobs whose final objective metric was not evaluated and
	// used in the hyperparameter tuning process. This typically occurs when the
	// training job failed or did not emit an objective metric.
	Failed int32

	// The number of training jobs that are in progress and pending evaluation of their
	// final objective metric.
	Pending int32

	// The number of training jobs whose final objective metric was evaluated by the
	// hyperparameter tuning job and used in the hyperparameter tuning process.
	Succeeded int32

	noSmithyDocumentSerde
}

// The configuration of an OfflineStore. Provide an OfflineStoreConfig in a request
// to CreateFeatureGroup to create an OfflineStore. To encrypt an OfflineStore
// using at rest data encryption, specify Amazon Web Services Key Management
// Service (KMS) key ID, or KMSKeyId, in S3StorageConfig.
type OfflineStoreConfig struct {

	// The Amazon Simple Storage (Amazon S3) location of OfflineStore.
	//
	// This member is required.
	S3StorageConfig *S3StorageConfig

	// The meta data of the Glue table that is autogenerated when an OfflineStore is
	// created.
	DataCatalogConfig *DataCatalogConfig

	// Set to True to disable the automatic creation of an Amazon Web Services Glue
	// table when configuring an OfflineStore.
	DisableGlueTableCreation bool

	noSmithyDocumentSerde
}

// The status of OfflineStore.
type OfflineStoreStatus struct {

	// An OfflineStore status.
	//
	// This member is required.
	Status OfflineStoreStatusValue

	// The justification for why the OfflineStoreStatus is Blocked (if applicable).
	BlockedReason *string

	noSmithyDocumentSerde
}

// Use this parameter to configure your OIDC Identity Provider (IdP).
type OidcConfig struct {

	// The OIDC IdP authorization endpoint used to configure your private workforce.
	//
	// This member is required.
	AuthorizationEndpoint *string

	// The OIDC IdP client ID used to configure your private workforce.
	//
	// This member is required.
	ClientId *string

	// The OIDC IdP client secret used to configure your private workforce.
	//
	// This member is required.
	ClientSecret *string

	// The OIDC IdP issuer used to configure your private workforce.
	//
	// This member is required.
	Issuer *string

	// The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private
	// workforce.
	//
	// This member is required.
	JwksUri *string

	// The OIDC IdP logout endpoint used to configure your private workforce.
	//
	// This member is required.
	LogoutEndpoint *string

	// The OIDC IdP token endpoint used to configure your private workforce.
	//
	// This member is required.
	TokenEndpoint *string

	// The OIDC IdP user information endpoint used to configure your private workforce.
	//
	// This member is required.
	UserInfoEndpoint *string

	noSmithyDocumentSerde
}

// Your OIDC IdP workforce configuration.
type OidcConfigForResponse struct {

	// The OIDC IdP authorization endpoint used to configure your private workforce.
	AuthorizationEndpoint *string

	// The OIDC IdP client ID used to configure your private workforce.
	ClientId *string

	// The OIDC IdP issuer used to configure your private workforce.
	Issuer *string

	// The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private
	// workforce.
	JwksUri *string

	// The OIDC IdP logout endpoint used to configure your private workforce.
	LogoutEndpoint *string

	// The OIDC IdP token endpoint used to configure your private workforce.
	TokenEndpoint *string

	// The OIDC IdP user information endpoint used to configure your private workforce.
	UserInfoEndpoint *string

	noSmithyDocumentSerde
}

// A list of user groups that exist in your OIDC Identity Provider (IdP). One to
// ten groups can be used to create a single private work team. When you add a user
// group to the list of Groups, you can add that user group to one or more private
// work teams. If you add a user group to a private work team, all workers in that
// user group are added to the work team.
type OidcMemberDefinition struct {

	// A list of comma seperated strings that identifies user groups in your OIDC IdP.
	// Each user group is made up of a group of private workers.
	//
	// This member is required.
	Groups []string

	noSmithyDocumentSerde
}

// Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID,
// or KMSKeyId, for at rest data encryption. You can turn OnlineStore on or off by
// specifying the EnableOnlineStore flag at General Assembly; the default value is
// False.
type OnlineStoreConfig struct {

	// Turn OnlineStore off by specifying False for the EnableOnlineStore flag. Turn
	// OnlineStore on by specifying True for the EnableOnlineStore flag. The default
	// value is False.
	EnableOnlineStore bool

	// Use to specify KMS Key ID (KMSKeyId) for at-rest encryption of your OnlineStore.
	SecurityConfig *OnlineStoreSecurityConfig

	noSmithyDocumentSerde
}

// The security configuration for OnlineStore.
type OnlineStoreSecurityConfig struct {

	// The ID of the Amazon Web Services Key Management Service (Amazon Web Services
	// KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at
	// rest using Amazon S3 server-side encryption. The caller (either IAM user or IAM
	// role) of CreateFeatureGroup must have below permissions to the
	// OnlineStoreKmsKeyId:
	//
	// * "kms:Encrypt"
	//
	// * "kms:Decrypt"
	//
	// * "kms:DescribeKey"
	//
	// *
	// "kms:CreateGrant"
	//
	// * "kms:RetireGrant"
	//
	// * "kms:ReEncryptFrom"
	//
	// *
	// "kms:ReEncryptTo"
	//
	// * "kms:GenerateDataKey"
	//
	// * "kms:ListAliases"
	//
	// *
	// "kms:ListGrants"
	//
	// * "kms:RevokeGrant"
	//
	// The caller (either IAM user or IAM role)
	// to all DataPlane operations (PutRecord, GetRecord, DeleteRecord) must have the
	// following permissions to the KmsKeyId:
	//
	// * "kms:Decrypt"
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Contains information about the output location for the compiled model and the
// target device that the model runs on. TargetDevice and TargetPlatform are
// mutually exclusive, so you need to choose one between the two to specify your
// target device or platform. If you cannot find your device you want to use from
// the TargetDevice list, use TargetPlatform to describe the platform of your edge
// device and CompilerOptions if there are specific settings that are required or
// recommended to use for particular TargetPlatform.
type OutputConfig struct {

	// Identifies the S3 bucket where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix.
	//
	// This member is required.
	S3OutputLocation *string

	// Specifies additional parameters for compiler options in JSON format. The
	// compiler options are TargetPlatform specific. It is required for NVIDIA
	// accelerators and highly recommended for CPU compilations. For any other cases,
	// it is optional to specify CompilerOptions.
	//
	// * DTYPE: Specifies the data type for
	// the input. When compiling for ml_* (except for ml_inf) instances using PyTorch
	// framework, provide the data type (dtype) of the model's input. "float32" is used
	// if "DTYPE" is not specified. Options for data type are:
	//
	// * float32: Use either
	// "float" or "float32".
	//
	// * int64: Use either "int64" or "long".
	//
	// For example,
	// {"dtype" : "float32"}.
	//
	// * CPU: Compilation for CPU supports the following
	// compiler options.
	//
	// * mcpu: CPU micro-architecture. For example, {'mcpu':
	// 'skylake-avx512'}
	//
	// * mattr: CPU flags. For example, {'mattr': ['+neon',
	// '+vfpv4']}
	//
	// * ARM: Details of ARM CPU compilations.
	//
	// * NEON: NEON is an
	// implementation of the Advanced SIMD extension used in ARMv7 processors. For
	// example, add {'mattr': ['+neon']} to the compiler options if compiling for ARM
	// 32-bit platform with the NEON support.
	//
	// * NVIDIA: Compilation for NVIDIA GPU
	// supports the following compiler options.
	//
	// * gpu_code: Specifies the targeted
	// architecture.
	//
	// * trt-ver: Specifies the TensorRT versions in x.y.z. format.
	//
	// *
	// cuda-ver: Specifies the CUDA version in x.y format.
	//
	// For example, {'gpu-code':
	// 'sm_72', 'trt-ver': '6.0.1', 'cuda-ver': '10.1'}
	//
	// * ANDROID: Compilation for the
	// Android OS supports the following compiler options:
	//
	// * ANDROID_PLATFORM:
	// Specifies the Android API levels. Available levels range from 21 to 29. For
	// example, {'ANDROID_PLATFORM': 28}.
	//
	// * mattr: Add {'mattr': ['+neon']} to
	// compiler options if compiling for ARM 32-bit platform with NEON support.
	//
	// *
	// INFERENTIA: Compilation for target ml_inf1 uses compiler options passed in as a
	// JSON string. For example, "CompilerOptions": "\"--verbose 1 --num-neuroncores 2
	// -O2\"". For information about supported compiler options, see  Neuron Compiler
	// CLI
	// (https://github.com/aws/aws-neuron-sdk/blob/master/docs/neuron-cc/command-line-reference.md).
	//
	// *
	// CoreML: Compilation for the CoreML OutputConfig$TargetDevice supports the
	// following compiler options:
	//
	// * class_labels: Specifies the classification labels
	// file name inside input tar.gz file. For example, {"class_labels":
	// "imagenet_labels_1000.txt"}. Labels inside the txt file should be separated by
	// newlines.
	//
	// * EIA: Compilation for the Elastic Inference Accelerator supports the
	// following compiler options:
	//
	// * precision_mode: Specifies the precision of
	// compiled artifacts. Supported values are "FP16" and "FP32". Default is
	// "FP32".
	//
	// * signature_def_key: Specifies the signature to use for models in
	// SavedModel format. Defaults is TensorFlow's default signature def key.
	//
	// *
	// output_names: Specifies a list of output tensor names for models in FrozenGraph
	// format. Set at most one API field, either: signature_def_key or
	// output_names.
	//
	// For example: {"precision_mode": "FP32", "output_names":
	// ["output:0"]}
	CompilerOptions *string

	// The Amazon Web Services Key Management Service key (Amazon Web Services KMS)
	// that Amazon SageMaker uses to encrypt your output models with Amazon S3
	// server-side encryption after compilation job. If you don't provide a KMS key ID,
	// Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
	// For more information, see KMS-Managed Encryption Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide. The KmsKeyId can be any of
	// the following formats:
	//
	// * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// * Key
	// ARN:
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// *
	// Alias name: alias/ExampleAlias
	//
	// * Alias name ARN:
	// arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	KmsKeyId *string

	// Identifies the target device or the machine learning instance that you want to
	// run your model on after the compilation has completed. Alternatively, you can
	// specify OS, architecture, and accelerator using TargetPlatform fields. It can be
	// used instead of TargetPlatform.
	TargetDevice TargetDevice

	// Contains information about a target platform that you want your model to run on,
	// such as OS, architecture, and accelerators. It is an alternative of
	// TargetDevice. The following examples show how to configure the TargetPlatform
	// and CompilerOptions JSON strings for popular target platforms:
	//
	// * Raspberry Pi 3
	// Model B+ "TargetPlatform": {"Os": "LINUX", "Arch": "ARM_EABIHF"},
	// "CompilerOptions": {'mattr': ['+neon']}
	//
	// * Jetson TX2 "TargetPlatform": {"Os":
	// "LINUX", "Arch": "ARM64", "Accelerator": "NVIDIA"}, "CompilerOptions":
	// {'gpu-code': 'sm_62', 'trt-ver': '6.0.1', 'cuda-ver': '10.0'}
	//
	// * EC2 m5.2xlarge
	// instance OS "TargetPlatform": {"Os": "LINUX", "Arch": "X86_64", "Accelerator":
	// "NVIDIA"}, "CompilerOptions": {'mcpu': 'skylake-avx512'}
	//
	// * RK3399
	// "TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "MALI"}
	//
	// *
	// ARMv7 phone (CPU) "TargetPlatform": {"Os": "ANDROID", "Arch": "ARM_EABI"},
	// "CompilerOptions": {'ANDROID_PLATFORM': 25, 'mattr': ['+neon']}
	//
	// * ARMv8 phone
	// (CPU) "TargetPlatform": {"Os": "ANDROID", "Arch": "ARM64"}, "CompilerOptions":
	// {'ANDROID_PLATFORM': 29}
	TargetPlatform *TargetPlatform

	noSmithyDocumentSerde
}

// Provides information about how to store model training results (model
// artifacts).
type OutputDataConfig struct {

	// Identifies the S3 path where you want SageMaker to store the model artifacts.
	// For example, s3://bucket-name/key-name-prefix.
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that SageMaker uses to encrypt the model artifacts at rest using Amazon S3
	// server-side encryption. The KmsKeyId can be any of the following formats:
	//
	// * //
	// KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * // Amazon Resource Name
	// (ARN) of a KMS Key
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// *
	// // KMS Key Alias "alias/ExampleAlias"
	//
	// * // Amazon Resource Name (ARN) of a KMS
	// Key Alias "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you use a
	// KMS key ID or an alias of your KMS key, the SageMaker execution role must
	// include permissions to call kms:Encrypt. If you don't provide a KMS key ID,
	// SageMaker uses the default KMS key for Amazon S3 for your role's account.
	// SageMaker uses server-side encryption with KMS-managed keys for
	// OutputDataConfig. If you use a bucket policy with an s3:PutObject permission
	// that only allows objects with server-side encryption, set the condition key of
	// s3:x-amz-server-side-encryption to "aws:kms". For more information, see
	// KMS-Managed Encryption Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide. The KMS key policy must
	// grant permission to the IAM role that you specify in your CreateTrainingJob,
	// CreateTransformJob, or CreateHyperParameterTuningJob requests. For more
	// information, see Using Key Policies in Amazon Web Services KMS
	// (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the
	// Amazon Web Services Key Management Service Developer Guide.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// An output parameter of a pipeline step.
type OutputParameter struct {

	// The name of the output parameter.
	//
	// This member is required.
	Name *string

	// The value of the output parameter.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Configuration that controls the parallelism of the pipeline. By default, the
// parallelism configuration specified applies to all executions of the pipeline
// unless overridden.
type ParallelismConfiguration struct {

	// The max number of steps that can be executed in parallel.
	//
	// This member is required.
	MaxParallelExecutionSteps int32

	noSmithyDocumentSerde
}

// Assigns a value to a named Pipeline parameter.
type Parameter struct {

	// The name of the parameter to assign a value to. This parameter name must match a
	// named parameter in the pipeline definition.
	//
	// This member is required.
	Name *string

	// The literal value for the parameter.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Defines the possible values for categorical, continuous, and integer
// hyperparameters to be used by an algorithm.
type ParameterRange struct {

	// A CategoricalParameterRangeSpecification object that defines the possible values
	// for a categorical hyperparameter.
	CategoricalParameterRangeSpecification *CategoricalParameterRangeSpecification

	// A ContinuousParameterRangeSpecification object that defines the possible values
	// for a continuous hyperparameter.
	ContinuousParameterRangeSpecification *ContinuousParameterRangeSpecification

	// A IntegerParameterRangeSpecification object that defines the possible values for
	// an integer hyperparameter.
	IntegerParameterRangeSpecification *IntegerParameterRangeSpecification

	noSmithyDocumentSerde
}

// Specifies ranges of integer, continuous, and categorical hyperparameters that a
// hyperparameter tuning job searches. The hyperparameter tuning job launches
// training jobs with hyperparameter values within these ranges to find the
// combination of values that result in the training job with the best performance
// as measured by the objective metric of the hyperparameter tuning job. The
// maximum number of items specified for Array Members refers to the maximum number
// of hyperparameters for each range and also the maximum for the hyperparameter
// tuning job itself. That is, the sum of the number of hyperparameters for all the
// ranges can't exceed the maximum number specified.
type ParameterRanges struct {

	// The array of CategoricalParameterRange objects that specify ranges of
	// categorical hyperparameters that a hyperparameter tuning job searches.
	CategoricalParameterRanges []CategoricalParameterRange

	// The array of ContinuousParameterRange objects that specify ranges of continuous
	// hyperparameters that a hyperparameter tuning job searches.
	ContinuousParameterRanges []ContinuousParameterRange

	// The array of IntegerParameterRange objects that specify ranges of integer
	// hyperparameters that a hyperparameter tuning job searches.
	IntegerParameterRanges []IntegerParameterRange

	noSmithyDocumentSerde
}

// The trial that a trial component is associated with and the experiment the trial
// is part of. A component might not be associated with a trial. A component can be
// associated with multiple trials.
type Parent struct {

	// The name of the experiment.
	ExperimentName *string

	// The name of the trial.
	TrialName *string

	noSmithyDocumentSerde
}

// A previously completed or stopped hyperparameter tuning job to be used as a
// starting point for a new hyperparameter tuning job.
type ParentHyperParameterTuningJob struct {

	// The name of the hyperparameter tuning job to be used as a starting point for a
	// new hyperparameter tuning job.
	HyperParameterTuningJobName *string

	noSmithyDocumentSerde
}

// The summary of an in-progress deployment when an endpoint is creating or
// updating with a new endpoint configuration.
type PendingDeploymentSummary struct {

	// The name of the endpoint configuration used in the deployment.
	//
	// This member is required.
	EndpointConfigName *string

	// List of PendingProductionVariantSummary objects.
	ProductionVariants []PendingProductionVariantSummary

	// The start time of the deployment.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// The production variant summary for a deployment when an endpoint is creating or
// updating with the CreateEndpoint or UpdateEndpoint operations. Describes the
// VariantStatus , weight and capacity for a production variant associated with an
// endpoint.
type PendingProductionVariantSummary struct {

	// The name of the variant.
	//
	// This member is required.
	VariantName *string

	// The size of the Elastic Inference (EI) instance to use for the production
	// variant. EI instances provide on-demand GPU computing for inference. For more
	// information, see Using Elastic Inference in Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	AcceleratorType ProductionVariantAcceleratorType

	// The number of instances associated with the variant.
	CurrentInstanceCount *int32

	// The serverless configuration for the endpoint.
	CurrentServerlessConfig *ProductionVariantServerlessConfig

	// The weight associated with the variant.
	CurrentWeight *float32

	// An array of DeployedImage objects that specify the Amazon EC2 Container Registry
	// paths of the inference images deployed on instances of this ProductionVariant.
	DeployedImages []DeployedImage

	// The number of instances requested in this deployment, as specified in the
	// endpoint configuration for the endpoint. The value is taken from the request to
	// the CreateEndpointConfig operation.
	DesiredInstanceCount *int32

	// The serverless configuration requested for this deployment, as specified in the
	// endpoint configuration for the endpoint.
	DesiredServerlessConfig *ProductionVariantServerlessConfig

	// The requested weight for the variant in this deployment, as specified in the
	// endpoint configuration for the endpoint. The value is taken from the request to
	// the CreateEndpointConfig operation.
	DesiredWeight *float32

	// The type of instances associated with the variant.
	InstanceType ProductionVariantInstanceType

	// The endpoint variant status which describes the current deployment stage status
	// or operational status.
	VariantStatus []ProductionVariantStatus

	noSmithyDocumentSerde
}

// Defines the traffic pattern.
type Phase struct {

	// Specifies how long traffic phase should be.
	DurationInSeconds *int32

	// Specifies how many concurrent users to start with.
	InitialNumberOfUsers *int32

	// Specified how many new users to spawn in a minute.
	SpawnRate *int32

	noSmithyDocumentSerde
}

// A SageMaker Model Building Pipeline instance.
type Pipeline struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// The creation time of the pipeline.
	CreationTime *time.Time

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// The time that the pipeline was last modified.
	LastModifiedTime *time.Time

	// The time when the pipeline was last run.
	LastRunTime *time.Time

	// The parallelism configuration applied to the pipeline.
	ParallelismConfiguration *ParallelismConfiguration

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The description of the pipeline.
	PipelineDescription *string

	// The display name of the pipeline.
	PipelineDisplayName *string

	// The name of the pipeline.
	PipelineName *string

	// The status of the pipeline.
	PipelineStatus PipelineStatus

	// The Amazon Resource Name (ARN) of the role that created the pipeline.
	RoleArn *string

	// A list of tags that apply to the pipeline.
	Tags []Tag

	noSmithyDocumentSerde
}

// The location of the pipeline definition stored in Amazon S3.
type PipelineDefinitionS3Location struct {

	// Name of the S3 bucket.
	//
	// This member is required.
	Bucket *string

	// The object key (or key name) uniquely identifies the object in an S3 bucket.
	//
	// This member is required.
	ObjectKey *string

	// Version Id of the pipeline definition file. If not specified, Amazon SageMaker
	// will retrieve the latest version.
	VersionId *string

	noSmithyDocumentSerde
}

// An execution of a pipeline.
type PipelineExecution struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// The creation time of the pipeline execution.
	CreationTime *time.Time

	// If the execution failed, a message describing why.
	FailureReason *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// The time that the pipeline execution was last modified.
	LastModifiedTime *time.Time

	// The parallelism configuration applied to the pipeline execution.
	ParallelismConfiguration *ParallelismConfiguration

	// The Amazon Resource Name (ARN) of the pipeline that was executed.
	PipelineArn *string

	// The Amazon Resource Name (ARN) of the pipeline execution.
	PipelineExecutionArn *string

	// The description of the pipeline execution.
	PipelineExecutionDescription *string

	// The display name of the pipeline execution.
	PipelineExecutionDisplayName *string

	// The status of the pipeline status.
	PipelineExecutionStatus PipelineExecutionStatus

	// Specifies the names of the experiment and trial created by a pipeline.
	PipelineExperimentConfig *PipelineExperimentConfig

	// Contains a list of pipeline parameters. This list can be empty.
	PipelineParameters []Parameter

	noSmithyDocumentSerde
}

// An execution of a step in a pipeline.
type PipelineExecutionStep struct {

	// The current attempt of the execution step. For more information, see Retry
	// Policy for SageMaker Pipelines steps
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-retry-policy.html).
	AttemptCount int32

	// If this pipeline execution step was cached, details on the cache hit.
	CacheHitResult *CacheHitResult

	// The time that the step stopped executing.
	EndTime *time.Time

	// The reason why the step failed execution. This is only returned if the step
	// failed its execution.
	FailureReason *string

	// Metadata for the step execution.
	Metadata *PipelineExecutionStepMetadata

	// The time that the step started executing.
	StartTime *time.Time

	// The description of the step.
	StepDescription *string

	// The display name of the step.
	StepDisplayName *string

	// The name of the step that is executed.
	StepName *string

	// The status of the step execution.
	StepStatus StepStatus

	noSmithyDocumentSerde
}

// Metadata for a step execution.
type PipelineExecutionStepMetadata struct {

	// The URL of the Amazon SQS queue used by this step execution, the pipeline
	// generated token, and a list of output parameters.
	Callback *CallbackStepMetadata

	// Container for the metadata for a Clarify check step. The configurations and
	// outcomes of the check step execution. This includes:
	//
	// * The type of the check
	// conducted,
	//
	// * The Amazon S3 URIs of baseline constraints and statistics files to
	// be used for the drift check.
	//
	// * The Amazon S3 URIs of newly calculated baseline
	// constraints and statistics.
	//
	// * The model package group name provided.
	//
	// * The
	// Amazon S3 URI of the violation report if violations detected.
	//
	// * The Amazon
	// Resource Name (ARN) of check processing job initiated by the step execution.
	//
	// *
	// The boolean flags indicating if the drift check is skipped.
	//
	// * If step property
	// BaselineUsedForDriftCheck is set the same as CalculatedBaseline.
	ClarifyCheck *ClarifyCheckStepMetadata

	// The outcome of the condition evaluation that was run by this step execution.
	Condition *ConditionStepMetadata

	// The configurations and outcomes of an EMR step execution.
	EMR *EMRStepMetadata

	// The configurations and outcomes of a Fail step execution.
	Fail *FailStepMetadata

	// The Amazon Resource Name (ARN) of the Lambda function that was run by this step
	// execution and a list of output parameters.
	Lambda *LambdaStepMetadata

	// The Amazon Resource Name (ARN) of the model that was created by this step
	// execution.
	Model *ModelStepMetadata

	// The Amazon Resource Name (ARN) of the processing job that was run by this step
	// execution.
	ProcessingJob *ProcessingJobStepMetadata

	// The configurations and outcomes of the check step execution. This includes:
	//
	// *
	// The type of the check conducted,
	//
	// * The Amazon S3 URIs of baseline constraints
	// and statistics files to be used for the drift check.
	//
	// * The Amazon S3 URIs of
	// newly calculated baseline constraints and statistics.
	//
	// * The model package group
	// name provided.
	//
	// * The Amazon S3 URI of the violation report if violations
	// detected.
	//
	// * The Amazon Resource Name (ARN) of check processing job initiated by
	// the step execution.
	//
	// * The boolean flags indicating if the drift check is
	// skipped.
	//
	// * If step property BaselineUsedForDriftCheck is set the same as
	// CalculatedBaseline.
	QualityCheck *QualityCheckStepMetadata

	// The Amazon Resource Name (ARN) of the model package the model was registered to
	// by this step execution.
	RegisterModel *RegisterModelStepMetadata

	// The Amazon Resource Name (ARN) of the training job that was run by this step
	// execution.
	TrainingJob *TrainingJobStepMetadata

	// The Amazon Resource Name (ARN) of the transform job that was run by this step
	// execution.
	TransformJob *TransformJobStepMetadata

	// The Amazon Resource Name (ARN) of the tuning job that was run by this step
	// execution.
	TuningJob *TuningJobStepMetaData

	noSmithyDocumentSerde
}

// A pipeline execution summary.
type PipelineExecutionSummary struct {

	// The Amazon Resource Name (ARN) of the pipeline execution.
	PipelineExecutionArn *string

	// The description of the pipeline execution.
	PipelineExecutionDescription *string

	// The display name of the pipeline execution.
	PipelineExecutionDisplayName *string

	// A message generated by SageMaker Pipelines describing why the pipeline execution
	// failed.
	PipelineExecutionFailureReason *string

	// The status of the pipeline execution.
	PipelineExecutionStatus PipelineExecutionStatus

	// The start time of the pipeline execution.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Specifies the names of the experiment and trial created by a pipeline.
type PipelineExperimentConfig struct {

	// The name of the experiment.
	ExperimentName *string

	// The name of the trial.
	TrialName *string

	noSmithyDocumentSerde
}

// A summary of a pipeline.
type PipelineSummary struct {

	// The creation time of the pipeline.
	CreationTime *time.Time

	// The last time that a pipeline execution began.
	LastExecutionTime *time.Time

	// The time that the pipeline was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The description of the pipeline.
	PipelineDescription *string

	// The display name of the pipeline.
	PipelineDisplayName *string

	// The name of the pipeline.
	PipelineName *string

	// The Amazon Resource Name (ARN) that the pipeline used to execute.
	RoleArn *string

	noSmithyDocumentSerde
}

// Configuration for the cluster used to run a processing job.
type ProcessingClusterConfig struct {

	// The number of ML compute instances to use in the processing job. For distributed
	// processing jobs, specify a value greater than 1. The default value is 1.
	//
	// This member is required.
	InstanceCount *int32

	// The ML compute instance type for the processing job.
	//
	// This member is required.
	InstanceType ProcessingInstanceType

	// The size of the ML storage volume in gigabytes that you want to provision. You
	// must specify sufficient ML storage for your scenario. Certain Nitro-based
	// instances include local storage with a fixed total size, dependent on the
	// instance type. When using these instances for processing, Amazon SageMaker
	// mounts the local instance storage instead of Amazon EBS gp2 storage. You can't
	// request a VolumeSizeInGB greater than the total size of the local instance
	// storage. For a list of instance types that support local instance storage,
	// including the total size per instance type, see Instance Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	//
	// This member is required.
	VolumeSizeInGB *int32

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume attached to the
	// ML compute instance(s) that run the processing job. Certain Nitro-based
	// instances include local storage, dependent on the instance type. Local storage
	// volumes are encrypted using a hardware module on the instance. You can't request
	// a VolumeKmsKeyId when using an instance type with local storage. For a list of
	// instance types that support local instance storage, see Instance Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	// For more information about local instance storage encryption, see SSD Instance
	// Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// Configuration for processing job outputs in Amazon SageMaker Feature Store.
type ProcessingFeatureStoreOutput struct {

	// The name of the Amazon SageMaker FeatureGroup to use as the destination for
	// processing job output. Note that your processing script is responsible for
	// putting records into your Feature Store.
	//
	// This member is required.
	FeatureGroupName *string

	noSmithyDocumentSerde
}

// The inputs for a processing job. The processing input must specify exactly one
// of either S3Input or DatasetDefinition types.
type ProcessingInput struct {

	// The name for the processing job input.
	//
	// This member is required.
	InputName *string

	// When True, input operations such as data download are managed natively by the
	// processing job application. When False (default), input operations are managed
	// by Amazon SageMaker.
	AppManaged bool

	// Configuration for a Dataset Definition input.
	DatasetDefinition *DatasetDefinition

	// Configuration for downloading input data from Amazon S3 into the processing
	// container.
	S3Input *ProcessingS3Input

	noSmithyDocumentSerde
}

// An Amazon SageMaker processing job that is used to analyze data and evaluate
// models. For more information, see Process Data and Evaluate Models
// (https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html).
type ProcessingJob struct {

	// Configuration to run a processing job in a specified container image.
	AppSpecification *AppSpecification

	// The Amazon Resource Name (ARN) of the AutoML job associated with this processing
	// job.
	AutoMLJobArn *string

	// The time the processing job was created.
	CreationTime *time.Time

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	// A string, up to one KB in size, that contains metadata from the processing
	// container when the processing job exits.
	ExitMessage *string

	// Associates a SageMaker job as a trial component with an experiment and trial.
	// Specified when you call the following APIs:
	//
	// * CreateProcessingJob
	//
	// *
	// CreateTrainingJob
	//
	// * CreateTransformJob
	ExperimentConfig *ExperimentConfig

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string

	// The time the processing job was last modified.
	LastModifiedTime *time.Time

	// The ARN of a monitoring schedule for an endpoint associated with this processing
	// job.
	MonitoringScheduleArn *string

	// Networking options for a job, such as network traffic encryption between
	// containers, whether to allow inbound and outbound network calls to and from
	// containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
	NetworkConfig *NetworkConfig

	// The time that the processing job ended.
	ProcessingEndTime *time.Time

	// List of input configurations for the processing job.
	ProcessingInputs []ProcessingInput

	// The ARN of the processing job.
	ProcessingJobArn *string

	// The name of the processing job.
	ProcessingJobName *string

	// The status of the processing job.
	ProcessingJobStatus ProcessingJobStatus

	// Configuration for uploading output from the processing container.
	ProcessingOutputConfig *ProcessingOutputConfig

	// Identifies the resources, ML compute instances, and ML storage volumes to deploy
	// for a processing job. In distributed training, you specify more than one
	// instance.
	ProcessingResources *ProcessingResources

	// The time that the processing job started.
	ProcessingStartTime *time.Time

	// The ARN of the role used to create the processing job.
	RoleArn *string

	// Configures conditions under which the processing job should be stopped, such as
	// how long the processing job has been running. After the condition is met, the
	// processing job is stopped.
	StoppingCondition *ProcessingStoppingCondition

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags
	// (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
	// in the Amazon Web Services Billing and Cost Management User Guide.
	Tags []Tag

	// The ARN of the training job associated with this processing job.
	TrainingJobArn *string

	noSmithyDocumentSerde
}

// Metadata for a processing job step.
type ProcessingJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the processing job.
	Arn *string

	noSmithyDocumentSerde
}

// Summary of information about a processing job.
type ProcessingJobSummary struct {

	// The time at which the processing job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the processing job..
	//
	// This member is required.
	ProcessingJobArn *string

	// The name of the processing job.
	//
	// This member is required.
	ProcessingJobName *string

	// The status of the processing job.
	//
	// This member is required.
	ProcessingJobStatus ProcessingJobStatus

	// An optional string, up to one KB in size, that contains metadata from the
	// processing container when the processing job exits.
	ExitMessage *string

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string

	// A timestamp that indicates the last time the processing job was modified.
	LastModifiedTime *time.Time

	// The time at which the processing job completed.
	ProcessingEndTime *time.Time

	noSmithyDocumentSerde
}

// Describes the results of a processing job. The processing output must specify
// exactly one of either S3Output or FeatureStoreOutput types.
type ProcessingOutput struct {

	// The name for the processing job output.
	//
	// This member is required.
	OutputName *string

	// When True, output operations such as data upload are managed natively by the
	// processing job application. When False (default), output operations are managed
	// by Amazon SageMaker.
	AppManaged bool

	// Configuration for processing job outputs in Amazon SageMaker Feature Store. This
	// processing output type is only supported when AppManaged is specified.
	FeatureStoreOutput *ProcessingFeatureStoreOutput

	// Configuration for processing job outputs in Amazon S3.
	S3Output *ProcessingS3Output

	noSmithyDocumentSerde
}

// Configuration for uploading output from the processing container.
type ProcessingOutputConfig struct {

	// An array of outputs configuring the data to upload from the processing
	// container.
	//
	// This member is required.
	Outputs []ProcessingOutput

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt the processing job output. KmsKeyId can be
	// an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key.
	// The KmsKeyId is applied to all outputs.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Identifies the resources, ML compute instances, and ML storage volumes to deploy
// for a processing job. In distributed training, you specify more than one
// instance.
type ProcessingResources struct {

	// The configuration for the resources in a cluster used to run the processing job.
	//
	// This member is required.
	ClusterConfig *ProcessingClusterConfig

	noSmithyDocumentSerde
}

// Configuration for downloading input data from Amazon S3 into the processing
// container.
type ProcessingS3Input struct {

	// Whether you use an S3Prefix or a ManifestFile for the data type. If you choose
	// S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker uses all objects
	// with the specified key name prefix for the processing job. If you choose
	// ManifestFile, S3Uri identifies an object that is a manifest file containing a
	// list of object keys that you want Amazon SageMaker to use for the processing
	// job.
	//
	// This member is required.
	S3DataType ProcessingS3DataType

	// The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run
	// a processing job.
	//
	// This member is required.
	S3Uri *string

	// The local path in your container where you want Amazon SageMaker to write input
	// data to. LocalPath is an absolute path to the input data and must begin with
	// /opt/ml/processing/. LocalPath is a required parameter when AppManaged is False
	// (default).
	LocalPath *string

	// Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the
	// processing container. Gzip can only be used when Pipe mode is specified as the
	// S3InputMode. In Pipe mode, Amazon SageMaker streams input data from the source
	// directly to your container without using the EBS volume.
	S3CompressionType ProcessingS3CompressionType

	// Whether to distribute the data from Amazon S3 to all processing instances with
	// FullyReplicated, or whether the data from Amazon S3 is shared by Amazon S3 key,
	// downloading one shard of data to each processing instance.
	S3DataDistributionType ProcessingS3DataDistributionType

	// Whether to use File or Pipe input mode. In File mode, Amazon SageMaker copies
	// the data from the input source onto the local ML storage volume before starting
	// your processing container. This is the most commonly used input mode. In Pipe
	// mode, Amazon SageMaker streams input data from the source directly to your
	// processing container into named pipes without using the ML storage volume.
	S3InputMode ProcessingS3InputMode

	noSmithyDocumentSerde
}

// Configuration for uploading output data to Amazon S3 from the processing
// container.
type ProcessingS3Output struct {

	// The local path of a directory where you want Amazon SageMaker to upload its
	// contents to Amazon S3. LocalPath is an absolute path to a directory containing
	// output files. This directory will be created by the platform and exist when your
	// container's entrypoint is invoked.
	//
	// This member is required.
	LocalPath *string

	// Whether to upload the results of the processing job continuously or after the
	// job completes.
	//
	// This member is required.
	S3UploadMode ProcessingS3UploadMode

	// A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to
	// save the results of a processing job.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Configures conditions under which the processing job should be stopped, such as
// how long the processing job has been running. After the condition is met, the
// processing job is stopped.
type ProcessingStoppingCondition struct {

	// Specifies the maximum runtime in seconds.
	//
	// This member is required.
	MaxRuntimeInSeconds int32

	noSmithyDocumentSerde
}

// Identifies a model that you want to host and the resources chosen to deploy for
// hosting it. If you are deploying multiple models, tell SageMaker how to
// distribute traffic among the models by specifying variant weights.
type ProductionVariant struct {

	// The name of the model that you want to host. This is the name that you specified
	// when creating the model.
	//
	// This member is required.
	ModelName *string

	// The name of the production variant.
	//
	// This member is required.
	VariantName *string

	// The size of the Elastic Inference (EI) instance to use for the production
	// variant. EI instances provide on-demand GPU computing for inference. For more
	// information, see Using Elastic Inference in Amazon SageMaker
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	AcceleratorType ProductionVariantAcceleratorType

	// Specifies configuration for a core dump from the model container when the
	// process crashes.
	CoreDumpConfig *ProductionVariantCoreDumpConfig

	// Number of instances to launch initially.
	InitialInstanceCount *int32

	// Determines initial traffic distribution among all of the models that you specify
	// in the endpoint configuration. The traffic to a production variant is determined
	// by the ratio of the VariantWeight to the sum of all VariantWeight values across
	// all ProductionVariants. If unspecified, it defaults to 1.0.
	InitialVariantWeight *float32

	// The ML compute instance type.
	InstanceType ProductionVariantInstanceType

	// The serverless configuration for an endpoint. Specifies a serverless endpoint
	// configuration instead of an instance-based endpoint configuration.
	ServerlessConfig *ProductionVariantServerlessConfig

	noSmithyDocumentSerde
}

// Specifies configuration for a core dump from the model container when the
// process crashes.
type ProductionVariantCoreDumpConfig struct {

	// The Amazon S3 bucket to send the core dump to.
	//
	// This member is required.
	DestinationS3Uri *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that SageMaker uses to encrypt the core dump data at rest using Amazon S3
	// server-side encryption. The KmsKeyId can be any of the following formats:
	//
	// * //
	// KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * // Amazon Resource Name
	// (ARN) of a KMS Key
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// *
	// // KMS Key Alias "alias/ExampleAlias"
	//
	// * // Amazon Resource Name (ARN) of a KMS
	// Key Alias "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you use a
	// KMS key ID or an alias of your KMS key, the SageMaker execution role must
	// include permissions to call kms:Encrypt. If you don't provide a KMS key ID,
	// SageMaker uses the default KMS key for Amazon S3 for your role's account.
	// SageMaker uses server-side encryption with KMS-managed keys for
	// OutputDataConfig. If you use a bucket policy with an s3:PutObject permission
	// that only allows objects with server-side encryption, set the condition key of
	// s3:x-amz-server-side-encryption to "aws:kms". For more information, see
	// KMS-Managed Encryption Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the
	// Amazon Simple Storage Service Developer Guide. The KMS key policy must grant
	// permission to the IAM role that you specify in your CreateEndpoint and
	// UpdateEndpoint requests. For more information, see Using Key Policies in Amazon
	// Web Services KMS
	// (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the
	// Amazon Web Services Key Management Service Developer Guide.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies the serverless configuration for an endpoint variant.
type ProductionVariantServerlessConfig struct {

	// The maximum number of concurrent invocations your serverless endpoint can
	// process.
	//
	// This member is required.
	MaxConcurrency *int32

	// The memory size of your serverless endpoint. Valid values are in 1 GB
	// increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
	//
	// This member is required.
	MemorySizeInMB *int32

	noSmithyDocumentSerde
}

// Describes the status of the production variant.
type ProductionVariantStatus struct {

	// The endpoint variant status which describes the current deployment stage status
	// or operational status.
	//
	// * Creating: Creating inference resources for the
	// production variant.
	//
	// * Deleting: Terminating inference resources for the
	// production variant.
	//
	// * Updating: Updating capacity for the production
	// variant.
	//
	// * ActivatingTraffic: Turning on traffic for the production variant.
	//
	// *
	// Baking: Waiting period to monitor the CloudWatch alarms in the automatic
	// rollback configuration.
	//
	// This member is required.
	Status VariantStatus

	// The start time of the current status change.
	StartTime *time.Time

	// A message that describes the status of the production variant.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Describes weight and capacities for a production variant associated with an
// endpoint. If you sent a request to the UpdateEndpointWeightsAndCapacities API
// and the endpoint status is Updating, you get different desired and current
// values.
type ProductionVariantSummary struct {

	// The name of the variant.
	//
	// This member is required.
	VariantName *string

	// The number of instances associated with the variant.
	CurrentInstanceCount *int32

	// The serverless configuration for the endpoint.
	CurrentServerlessConfig *ProductionVariantServerlessConfig

	// The weight associated with the variant.
	CurrentWeight *float32

	// An array of DeployedImage objects that specify the Amazon EC2 Container Registry
	// paths of the inference images deployed on instances of this ProductionVariant.
	DeployedImages []DeployedImage

	// The number of instances requested in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredInstanceCount *int32

	// The serverless configuration requested for the endpoint update.
	DesiredServerlessConfig *ProductionVariantServerlessConfig

	// The requested weight, as specified in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredWeight *float32

	// The endpoint variant status which describes the current deployment stage status
	// or operational status.
	VariantStatus []ProductionVariantStatus

	noSmithyDocumentSerde
}

// Configuration information for Debugger system monitoring, framework profiling,
// and storage paths.
type ProfilerConfig struct {

	// Path to Amazon S3 storage location for system and framework metrics.
	//
	// This member is required.
	S3OutputPath *string

	// A time interval for capturing system metrics in milliseconds. Available values
	// are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute)
	// milliseconds. The default value is 500 milliseconds.
	ProfilingIntervalInMilliseconds *int64

	// Configuration information for capturing framework metrics. Available key strings
	// for different profiling options are DetailedProfilingConfig,
	// PythonProfilingConfig, and DataLoaderProfilingConfig. The following codes are
	// configuration structures for the ProfilingParameters parameter. To learn more
	// about how to configure the ProfilingParameters parameter, see Use the SageMaker
	// and Debugger Configuration API Operations to Create, Update, and Debug Your
	// Training Job
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
	ProfilingParameters map[string]string

	noSmithyDocumentSerde
}

// Configuration information for updating the Debugger profile parameters, system
// and framework metrics configurations, and storage paths.
type ProfilerConfigForUpdate struct {

	// To disable Debugger monitoring and profiling, set to True.
	DisableProfiler bool

	// A time interval for capturing system metrics in milliseconds. Available values
	// are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute)
	// milliseconds. The default value is 500 milliseconds.
	ProfilingIntervalInMilliseconds *int64

	// Configuration information for capturing framework metrics. Available key strings
	// for different profiling options are DetailedProfilingConfig,
	// PythonProfilingConfig, and DataLoaderProfilingConfig. The following codes are
	// configuration structures for the ProfilingParameters parameter. To learn more
	// about how to configure the ProfilingParameters parameter, see Use the SageMaker
	// and Debugger Configuration API Operations to Create, Update, and Debug Your
	// Training Job
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
	ProfilingParameters map[string]string

	// Path to Amazon S3 storage location for system and framework metrics.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// Configuration information for profiling rules.
type ProfilerRuleConfiguration struct {

	// The name of the rule configuration. It must be unique relative to other rule
	// configuration names.
	//
	// This member is required.
	RuleConfigurationName *string

	// The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
	//
	// This member is required.
	RuleEvaluatorImage *string

	// The instance type to deploy a Debugger custom rule for profiling a training job.
	InstanceType ProcessingInstanceType

	// Path to local storage location for output of rules. Defaults to
	// /opt/ml/processing/output/rule/.
	LocalPath *string

	// Runtime configuration for rule container.
	RuleParameters map[string]string

	// Path to Amazon S3 storage location for rules.
	S3OutputPath *string

	// The size, in GB, of the ML storage volume attached to the processing instance.
	VolumeSizeInGB int32

	noSmithyDocumentSerde
}

// Information about the status of the rule evaluation.
type ProfilerRuleEvaluationStatus struct {

	// Timestamp when the rule evaluation status was last modified.
	LastModifiedTime *time.Time

	// The name of the rule configuration.
	RuleConfigurationName *string

	// The Amazon Resource Name (ARN) of the rule evaluation job.
	RuleEvaluationJobArn *string

	// Status of the rule evaluation.
	RuleEvaluationStatus RuleEvaluationStatus

	// Details from the rule evaluation.
	StatusDetails *string

	noSmithyDocumentSerde
}

// The properties of a project as returned by the Search API.
type Project struct {

	// Who created the project.
	CreatedBy *UserContext

	// A timestamp specifying when the project was created.
	CreationTime *time.Time

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// A timestamp container for when the project was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string

	// The description of the project.
	ProjectDescription *string

	// The ID of the project.
	ProjectId *string

	// The name of the project.
	ProjectName *string

	// The status of the project.
	ProjectStatus ProjectStatus

	// Details of a provisioned service catalog product. For information about service
	// catalog, see What is Amazon Web Services Service Catalog
	// (https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
	ServiceCatalogProvisionedProductDetails *ServiceCatalogProvisionedProductDetails

	// Details that you specify to provision a service catalog product. For information
	// about service catalog, see What is Amazon Web Services Service Catalog
	// (https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
	ServiceCatalogProvisioningDetails *ServiceCatalogProvisioningDetails

	// An array of key-value pairs. You can use tags to categorize your Amazon Web
	// Services resources in different ways, for example, by purpose, owner, or
	// environment. For more information, see Tagging Amazon Web Services Resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
	Tags []Tag

	noSmithyDocumentSerde
}

// Information about a project.
type ProjectSummary struct {

	// The time that the project was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the project.
	//
	// This member is required.
	ProjectArn *string

	// The ID of the project.
	//
	// This member is required.
	ProjectId *string

	// The name of the project.
	//
	// This member is required.
	ProjectName *string

	// The status of the project.
	//
	// This member is required.
	ProjectStatus ProjectStatus

	// The description of the project.
	ProjectDescription *string

	noSmithyDocumentSerde
}

// Part of the SuggestionQuery type. Specifies a hint for retrieving property names
// that begin with the specified text.
type PropertyNameQuery struct {

	// Text that begins a property's name.
	//
	// This member is required.
	PropertyNameHint *string

	noSmithyDocumentSerde
}

// A property name returned from a GetSearchSuggestions call that specifies a value
// in the PropertyNameQuery field.
type PropertyNameSuggestion struct {

	// A suggested property name based on what you entered in the search textbox in the
	// Amazon SageMaker console.
	PropertyName *string

	noSmithyDocumentSerde
}

// A key value pair used when you provision a project as a service catalog product.
// For information, see What is Amazon Web Services Service Catalog
// (https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
type ProvisioningParameter struct {

	// The key that identifies a provisioning parameter.
	Key *string

	// The value of the provisioning parameter.
	Value *string

	noSmithyDocumentSerde
}

// Defines the amount of money paid to an Amazon Mechanical Turk worker for each
// task performed. Use one of the following prices for bounding box tasks. Prices
// are in US dollars and should be based on the complexity of the task; the longer
// it takes in your initial testing, the more you should offer.
//
// * 0.036
//
// *
// 0.048
//
// * 0.060
//
// * 0.072
//
// * 0.120
//
// * 0.240
//
// * 0.360
//
// * 0.480
//
// * 0.600
//
// * 0.720
//
// *
// 0.840
//
// * 0.960
//
// * 1.080
//
// * 1.200
//
// Use one of the following prices for image
// classification, text classification, and custom tasks. Prices are in US
// dollars.
//
// * 0.012
//
// * 0.024
//
// * 0.036
//
// * 0.048
//
// * 0.060
//
// * 0.072
//
// * 0.120
//
// *
// 0.240
//
// * 0.360
//
// * 0.480
//
// * 0.600
//
// * 0.720
//
// * 0.840
//
// * 0.960
//
// * 1.080
//
// *
// 1.200
//
// Use one of the following prices for semantic segmentation tasks. Prices
// are in US dollars.
//
// * 0.840
//
// * 0.960
//
// * 1.080
//
// * 1.200
//
// Use one of the following
// prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI
// review tasks. Prices are in US dollars.
//
// * 2.400
//
// * 2.280
//
// * 2.160
//
// * 2.040
//
// *
// 1.920
//
// * 1.800
//
// * 1.680
//
// * 1.560
//
// * 1.440
//
// * 1.320
//
// * 1.200
//
// * 1.080
//
// * 0.960
//
// *
// 0.840
//
// * 0.720
//
// * 0.600
//
// * 0.480
//
// * 0.360
//
// * 0.240
//
// * 0.120
//
// * 0.072
//
// * 0.060
//
// *
// 0.048
//
// * 0.036
//
// * 0.024
//
// * 0.012
//
// Use one of the following prices for
// Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are
// in US dollars.
//
// * 1.200
//
// * 1.080
//
// * 0.960
//
// * 0.840
//
// * 0.720
//
// * 0.600
//
// * 0.480
//
// *
// 0.360
//
// * 0.240
//
// * 0.120
//
// * 0.072
//
// * 0.060
//
// * 0.048
//
// * 0.036
//
// * 0.024
//
// *
// 0.012
//
// Use one of the following prices for Amazon Augmented AI custom human
// review tasks. Prices are in US dollars.
//
// * 1.200
//
// * 1.080
//
// * 0.960
//
// * 0.840
//
// *
// 0.720
//
// * 0.600
//
// * 0.480
//
// * 0.360
//
// * 0.240
//
// * 0.120
//
// * 0.072
//
// * 0.060
//
// * 0.048
//
// *
// 0.036
//
// * 0.024
//
// * 0.012
type PublicWorkforceTaskPrice struct {

	// Defines the amount of money paid to an Amazon Mechanical Turk worker in United
	// States dollars.
	AmountInUsd *USD

	noSmithyDocumentSerde
}

// Container for the metadata for a Quality check step. For more information, see
// the topic on QualityCheck step
// (https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-quality-check)
// in the Amazon SageMaker Developer Guide.
type QualityCheckStepMetadata struct {

	// The Amazon S3 URI of the baseline constraints file used for the drift check.
	BaselineUsedForDriftCheckConstraints *string

	// The Amazon S3 URI of the baseline statistics file used for the drift check.
	BaselineUsedForDriftCheckStatistics *string

	// The Amazon S3 URI of the newly calculated baseline constraints file.
	CalculatedBaselineConstraints *string

	// The Amazon S3 URI of the newly calculated baseline statistics file.
	CalculatedBaselineStatistics *string

	// The Amazon Resource Name (ARN) of the Quality check processing job that was run
	// by this step execution.
	CheckJobArn *string

	// The type of the Quality check step.
	CheckType *string

	// The model package group name.
	ModelPackageGroupName *string

	// This flag indicates if a newly calculated baseline can be accessed through step
	// properties BaselineUsedForDriftCheckConstraints and
	// BaselineUsedForDriftCheckStatistics. If it is set to False, the previous
	// baseline of the configured check type must also be available. These can be
	// accessed through the BaselineUsedForDriftCheckConstraints and
	// BaselineUsedForDriftCheckStatistics properties.
	RegisterNewBaseline bool

	// This flag indicates if the drift check against the previous baseline will be
	// skipped or not. If it is set to False, the previous baseline of the configured
	// check type must be available.
	SkipCheck bool

	// The Amazon S3 URI of violation report if violations are detected.
	ViolationReport *string

	noSmithyDocumentSerde
}

// A set of filters to narrow the set of lineage entities connected to the
// StartArn(s) returned by the QueryLineage API action.
type QueryFilters struct {

	// Filter the lineage entities connected to the StartArn(s) after the create date.
	CreatedAfter *time.Time

	// Filter the lineage entities connected to the StartArn(s) by created date.
	CreatedBefore *time.Time

	// Filter the lineage entities connected to the StartArn(s) by the type of the
	// lineage entity.
	LineageTypes []LineageType

	// Filter the lineage entities connected to the StartArn(s) after the last modified
	// date.
	ModifiedAfter *time.Time

	// Filter the lineage entities connected to the StartArn(s) before the last
	// modified date.
	ModifiedBefore *time.Time

	// Filter the lineage entities connected to the StartArn(s) by a set if property
	// key value pairs. If multiple pairs are provided, an entity is included in the
	// results if it matches any of the provided pairs.
	Properties map[string]string

	// Filter the lineage entities connected to the StartArn by type. For example:
	// DataSet, Model, Endpoint, or ModelDeployment.
	Types []string

	noSmithyDocumentSerde
}

// Provides information about the output configuration for the compiled model.
type RecommendationJobCompiledOutputConfig struct {

	// Identifies the Amazon S3 bucket where you want SageMaker to store the compiled
	// model artifacts.
	S3OutputUri *string

	noSmithyDocumentSerde
}

// The input configuration of the recommendation job.
type RecommendationJobInputConfig struct {

	// The Amazon Resource Name (ARN) of a versioned model package.
	//
	// This member is required.
	ModelPackageVersionArn *string

	// Specifies the endpoint configuration to use for a job.
	EndpointConfigurations []EndpointInputConfiguration

	// Specifies the maximum duration of the job, in seconds.>
	JobDurationInSeconds *int32

	// Defines the resource limit of the job.
	ResourceLimit *RecommendationJobResourceLimit

	// Specifies the traffic pattern of the job.
	TrafficPattern *TrafficPattern

	// The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the
	// storage volume attached to the ML compute instance that hosts the endpoint. This
	// key will be passed to SageMaker Hosting for endpoint creation. The SageMaker
	// execution role must have kms:CreateGrant permission in order to encrypt data on
	// the storage volume of the endpoints created for inference recommendation. The
	// inference recommendation job will fail asynchronously during endpoint
	// configuration creation if the role passed does not have kms:CreateGrant
	// permission. The KmsKeyId can be any of the following formats:
	//
	// * // KMS Key ID
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * // Amazon Resource Name (ARN) of a KMS
	// Key "arn:aws:kms:::key/"
	//
	// * // KMS Key Alias "alias/ExampleAlias"
	//
	// * // Amazon
	// Resource Name (ARN) of a KMS Key Alias "arn:aws:kms:::alias/"
	//
	// For more
	// information about key identifiers, see Key identifiers (KeyID)
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id)
	// in the Amazon Web Services Key Management Service (Amazon Web Services KMS)
	// documentation.
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// Provides information about the output configuration for the compiled model.
type RecommendationJobOutputConfig struct {

	// Provides information about the output configuration for the compiled model.
	CompiledOutputConfig *RecommendationJobCompiledOutputConfig

	// The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt your output
	// artifacts with Amazon S3 server-side encryption. The SageMaker execution role
	// must have kms:GenerateDataKey permission. The KmsKeyId can be any of the
	// following formats:
	//
	// * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * //
	// Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:::key/"
	//
	// * // KMS Key Alias
	// "alias/ExampleAlias"
	//
	// * // Amazon Resource Name (ARN) of a KMS Key Alias
	// "arn:aws:kms:::alias/"
	//
	// For more information about key identifiers, see Key
	// identifiers (KeyID)
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id)
	// in the Amazon Web Services Key Management Service (Amazon Web Services KMS)
	// documentation.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies the maximum number of jobs that can run in parallel and the maximum
// number of jobs that can run.
type RecommendationJobResourceLimit struct {

	// Defines the maximum number of load tests.
	MaxNumberOfTests *int32

	// Defines the maximum number of parallel load tests.
	MaxParallelOfTests *int32

	noSmithyDocumentSerde
}

// Specifies conditions for stopping a job. When a job reaches a stopping condition
// limit, SageMaker ends the job.
type RecommendationJobStoppingConditions struct {

	// The maximum number of requests per minute expected for the endpoint.
	MaxInvocations int32

	// The interval of time taken by a model to respond as viewed from SageMaker. The
	// interval includes the local communication time taken to send the request and to
	// fetch the response from the container of a model and the time taken to complete
	// the inference in the container.
	ModelLatencyThresholds []ModelLatencyThreshold

	noSmithyDocumentSerde
}

// The metrics of recommendations.
type RecommendationMetrics struct {

	// Defines the cost per hour for the instance.
	//
	// This member is required.
	CostPerHour float32

	// Defines the cost per inference for the instance .
	//
	// This member is required.
	CostPerInference float32

	// The expected maximum number of requests per minute for the instance.
	//
	// This member is required.
	MaxInvocations int32

	// The expected model latency at maximum invocation per minute for the instance.
	//
	// This member is required.
	ModelLatency int32

	noSmithyDocumentSerde
}

// Configuration for Redshift Dataset Definition input.
type RedshiftDatasetDefinition struct {

	// The Redshift cluster Identifier.
	//
	// This member is required.
	ClusterId *string

	// The IAM role attached to your Redshift cluster that Amazon SageMaker uses to
	// generate datasets.
	//
	// This member is required.
	ClusterRoleArn *string

	// The name of the Redshift database used in Redshift query execution.
	//
	// This member is required.
	Database *string

	// The database user name used in Redshift query execution.
	//
	// This member is required.
	DbUser *string

	// The data storage format for Redshift query results.
	//
	// This member is required.
	OutputFormat RedshiftResultFormat

	// The location in Amazon S3 where the Redshift query results are stored.
	//
	// This member is required.
	OutputS3Uri *string

	// The SQL query statements to be executed.
	//
	// This member is required.
	QueryString *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data from a Redshift execution.
	KmsKeyId *string

	// The compression used for Redshift query results.
	OutputCompression RedshiftResultCompressionType

	noSmithyDocumentSerde
}

// Metadata for a register model job step.
type RegisterModelStepMetadata struct {

	// The Amazon Resource Name (ARN) of the model package.
	Arn *string

	noSmithyDocumentSerde
}

// Contains input values for a task.
type RenderableTask struct {

	// A JSON object that contains values for the variables defined in the template. It
	// is made available to the template under the substitution variable task.input.
	// For example, if you define a variable task.input.text in your template, you can
	// supply the variable in the JSON object as "text": "sample text".
	//
	// This member is required.
	Input *string

	noSmithyDocumentSerde
}

// A description of an error that occurred while rendering the template.
type RenderingError struct {

	// A unique identifier for a specific class of errors.
	//
	// This member is required.
	Code *string

	// A human-readable message describing the error.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Specifies an authentication configuration for the private docker registry where
// your model image is hosted. Specify a value for this property only if you
// specified Vpc as the value for the RepositoryAccessMode field of the ImageConfig
// object that you passed to a call to CreateModel and the private Docker registry
// where the model image is hosted requires authentication.
type RepositoryAuthConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that
	// provides credentials to authenticate to the private Docker registry where your
	// model image is hosted. For information about how to create an Amazon Web
	// Services Lambda function, see Create a Lambda function with the console
	// (https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html)
	// in the Amazon Web Services Lambda Developer Guide.
	//
	// This member is required.
	RepositoryCredentialsProviderArn *string

	noSmithyDocumentSerde
}

// The resolved attributes.
type ResolvedAttributes struct {

	// Specifies a metric to minimize or maximize as the objective of a job.
	AutoMLJobObjective *AutoMLJobObjective

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	// The problem type.
	ProblemType ProblemType

	noSmithyDocumentSerde
}

// Describes the resources, including ML compute instances and ML storage volumes,
// to use for model training.
type ResourceConfig struct {

	// The size of the ML storage volume that you want to provision. ML storage volumes
	// store model artifacts and incremental states. Training algorithms might also use
	// the ML storage volume for scratch space. If you want to store the training data
	// in the ML storage volume, choose File as the TrainingInputMode in the algorithm
	// specification. You must specify sufficient ML storage for your scenario.
	// SageMaker supports only the General Purpose SSD (gp2) ML storage volume type.
	// Certain Nitro-based instances include local storage with a fixed total size,
	// dependent on the instance type. When using these instances for training,
	// SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage.
	// You can't request a VolumeSizeInGB greater than the total size of the local
	// instance storage. For a list of instance types that support local instance
	// storage, including the total size per instance type, see Instance Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	//
	// This member is required.
	VolumeSizeInGB int32

	// The number of ML compute instances to use. For distributed training, provide a
	// value greater than 1.
	InstanceCount int32

	// The configuration of a heterogeneous cluster in JSON format.
	InstanceGroups []InstanceGroup

	// The ML compute instance type.
	InstanceType TrainingInstanceType

	// The Amazon Web Services KMS key that SageMaker uses to encrypt data on the
	// storage volume attached to the ML compute instance(s) that run the training job.
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a VolumeKmsKeyId when using an instance type with
	// local storage. For a list of instance types that support local instance storage,
	// see Instance Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	// For more information about local instance storage encryption, see SSD Instance
	// Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
	// The VolumeKmsKeyId can be in any of the following formats:
	//
	// * // KMS Key ID
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * // Amazon Resource Name (ARN) of a KMS
	// Key
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies the maximum number of training jobs and parallel training jobs that a
// hyperparameter tuning job can launch.
type ResourceLimits struct {

	// The maximum number of training jobs that a hyperparameter tuning job can launch.
	//
	// This member is required.
	MaxNumberOfTrainingJobs int32

	// The maximum number of concurrent training jobs that a hyperparameter tuning job
	// can launch.
	//
	// This member is required.
	MaxParallelTrainingJobs int32

	noSmithyDocumentSerde
}

// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
// instance type that the version runs on.
type ResourceSpec struct {

	// The instance type that the image version runs on. JupyterServer apps only
	// support the system value. For KernelGateway apps, the system value is translated
	// to ml.t3.medium. KernelGateway apps also support all other values for available
	// instance types.
	InstanceType AppInstanceType

	// The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the
	// Resource.
	LifecycleConfigArn *string

	// The ARN of the SageMaker image that the image version belongs to.
	SageMakerImageArn *string

	// The ARN of the image version created on the instance.
	SageMakerImageVersionArn *string

	noSmithyDocumentSerde
}

// The retention policy for data stored on an Amazon Elastic File System (EFS)
// volume.
type RetentionPolicy struct {

	// The default is Retain, which specifies to keep the data stored on the EFS
	// volume. Specify Delete to delete the data stored on the EFS volume.
	HomeEfsFileSystem RetentionType

	noSmithyDocumentSerde
}

// The retry strategy to use when a training job fails due to an
// InternalServerError. RetryStrategy is specified as part of the CreateTrainingJob
// and CreateHyperParameterTuningJob requests. You can add the StoppingCondition
// parameter to the request to limit the training time for the complete job.
type RetryStrategy struct {

	// The number of times to retry the job. When the job is retried, it's
	// SecondaryStatus is changed to STARTING.
	//
	// This member is required.
	MaximumRetryAttempts int32

	noSmithyDocumentSerde
}

// A collection of settings that apply to an RSessionGateway app.
type RSessionAppSettings struct {

	// A list of custom SageMaker images that are configured to run as a RSession app.
	CustomImages []CustomImage

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// A collection of settings that configure user interaction with the
// RStudioServerPro app. RStudioServerProAppSettings cannot be updated. The
// RStudioServerPro app must be deleted and a new one created to make any changes.
type RStudioServerProAppSettings struct {

	// Indicates whether the current user has access to the RStudioServerPro app.
	AccessStatus RStudioServerProAccessStatus

	// The level of permissions that the user has within the RStudioServerPro app. This
	// value defaults to `User`. The `Admin` value allows the user access to the
	// RStudio Administrative Dashboard.
	UserGroup RStudioServerProUserGroup

	noSmithyDocumentSerde
}

// A collection of settings that configure the RStudioServerPro Domain-level app.
type RStudioServerProDomainSettings struct {

	// The ARN of the execution role for the RStudioServerPro Domain-level app.
	//
	// This member is required.
	DomainExecutionRoleArn *string

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	// A URL pointing to an RStudio Connect server.
	RStudioConnectUrl *string

	// A URL pointing to an RStudio Package Manager server.
	RStudioPackageManagerUrl *string

	noSmithyDocumentSerde
}

// A collection of settings that update the current configuration for the
// RStudioServerPro Domain-level app.
type RStudioServerProDomainSettingsForUpdate struct {

	// The execution role for the RStudioServerPro Domain-level app.
	//
	// This member is required.
	DomainExecutionRoleArn *string

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// Describes the S3 data source.
type S3DataSource struct {

	// If you choose S3Prefix, S3Uri identifies a key name prefix. SageMaker uses all
	// objects that match the specified key name prefix for model training. If you
	// choose ManifestFile, S3Uri identifies an object that is a manifest file
	// containing a list of object keys that you want SageMaker to use for model
	// training. If you choose AugmentedManifestFile, S3Uri identifies an object that
	// is an augmented manifest file in JSON lines format. This file contains the data
	// you want to use for model training. AugmentedManifestFile can only be used if
	// the Channel's input mode is Pipe.
	//
	// This member is required.
	S3DataType S3DataType

	// Depending on the value specified for the S3DataType, identifies either a key
	// name prefix or a manifest. For example:
	//
	// * A key name prefix might look like
	// this: s3://bucketname/exampleprefix
	//
	// * A manifest might look like this:
	// s3://bucketname/example.manifest A manifest is an S3 object which is a JSON file
	// consisting of an array of elements. The first element is a prefix which is
	// followed by one or more suffixes. SageMaker appends the suffix elements to the
	// prefix to get a full set of S3Uri. Note that the prefix must be a valid
	// non-empty S3Uri that precludes users from specifying a manifest whose individual
	// S3Uri is sourced from different S3 buckets. The following code example shows a
	// valid manifest format: [ {"prefix": "s3://customer_bucket/some/prefix/"},
	// "relative/path/to/custdata-1", "relative/path/custdata-2", ...
	// "relative/path/custdata-N"] This JSON is equivalent to the following S3Uri list:
	// s3://customer_bucket/some/prefix/relative/path/to/custdata-1s3://customer_bucket/some/prefix/relative/path/custdata-2...s3://customer_bucket/some/prefix/relative/path/custdata-N
	// The complete set of S3Uri in this manifest is the input data for the channel for
	// this data source. The object that each S3Uri points to must be readable by the
	// IAM role that SageMaker uses to perform tasks on your behalf.
	//
	// This member is required.
	S3Uri *string

	// A list of one or more attribute names to use that are found in a specified
	// augmented manifest file.
	AttributeNames []string

	// A list of names of instance groups that get data from the S3 data source.
	InstanceGroupNames []string

	// If you want SageMaker to replicate the entire dataset on each ML compute
	// instance that is launched for model training, specify FullyReplicated. If you
	// want SageMaker to replicate a subset of data on each ML compute instance that is
	// launched for model training, specify ShardedByS3Key. If there are n ML compute
	// instances launched for a training job, each instance gets approximately 1/n of
	// the number of S3 objects. In this case, model training on each machine uses only
	// the subset of training data. Don't choose more ML compute instances for training
	// than available S3 objects. If you do, some nodes won't get any data and you will
	// pay for nodes that aren't getting any training data. This applies in both File
	// and Pipe modes. Keep this in mind when developing algorithms. In distributed
	// training, where you use multiple ML compute EC2 instances, you might choose
	// ShardedByS3Key. If the algorithm requires copying training data to the ML
	// storage volume (when TrainingInputMode is set to File), this copies 1/n of the
	// number of objects.
	S3DataDistributionType S3DataDistribution

	noSmithyDocumentSerde
}

// The Amazon Simple Storage (Amazon S3) location and and security configuration
// for OfflineStore.
type S3StorageConfig struct {

	// The S3 URI, or location in Amazon S3, of OfflineStore. S3 URIs have a format
	// similar to the following: s3://example-bucket/prefix/.
	//
	// This member is required.
	S3Uri *string

	// The Amazon Web Services Key Management Service (KMS) key ID of the key used to
	// encrypt any objects written into the OfflineStore S3 location. The IAM roleARN
	// that is passed as a parameter to CreateFeatureGroup must have below permissions
	// to the KmsKeyId:
	//
	// * "kms:GenerateDataKey"
	KmsKeyId *string

	// The S3 path where offline records are written.
	ResolvedOutputS3Uri *string

	noSmithyDocumentSerde
}

// Configuration details about the monitoring schedule.
type ScheduleConfig struct {

	// A cron expression that describes details about the monitoring schedule.
	// Currently the only supported cron expressions are:
	//
	// * If you want to set the job
	// to start every hour, please use the following: Hourly: cron(0 * ? * * *)
	//
	// * If
	// you want to start the job daily: cron(0 [00-23] ? * * *)
	//
	// For example, the
	// following are valid cron expressions:
	//
	// * Daily at noon UTC: cron(0 12 ? * *
	// *)
	//
	// * Daily at midnight UTC: cron(0 0 ? * * *)
	//
	// To support running every 6, 12
	// hours, the following are also supported: cron(0 [00-23]/[01-24] ? * * *) For
	// example, the following are valid cron expressions:
	//
	// * Every 12 hours, starting
	// at 5pm UTC: cron(0 17/12 ? * * *)
	//
	// * Every two hours starting at midnight:
	// cron(0 0/2 ? * * *)
	//
	// * Even though the cron expression is set to start at 5PM
	// UTC, note that there could be a delay of 0-20 minutes from the actual requested
	// time to run the execution.
	//
	// * We recommend that if you would like a daily
	// schedule, you do not provide this parameter. Amazon SageMaker will pick a time
	// for running every day.
	//
	// This member is required.
	ScheduleExpression *string

	noSmithyDocumentSerde
}

// A multi-expression that searches for the specified resource or resources in a
// search. All resource objects that satisfy the expression's condition are
// included in the search results. You must specify at least one subexpression,
// filter, or nested filter. A SearchExpression can contain up to twenty elements.
// A SearchExpression contains the following components:
//
// * A list of Filter
// objects. Each filter defines a simple Boolean expression comprised of a resource
// property name, Boolean operator, and value.
//
// * A list of NestedFilter objects.
// Each nested filter defines a list of Boolean expressions using a list of
// resource properties. A nested filter is satisfied if a single object in the list
// satisfies all Boolean expressions.
//
// * A list of SearchExpression objects. A
// search expression object can be nested in a list of search expression
// objects.
//
// * A Boolean operator: And or Or.
type SearchExpression struct {

	// A list of filter objects.
	Filters []Filter

	// A list of nested filter objects.
	NestedFilters []NestedFilters

	// A Boolean operator used to evaluate the search expression. If you want every
	// conditional statement in all lists to be satisfied for the entire search
	// expression to be true, specify And. If only a single conditional statement needs
	// to be true for the entire search expression to be true, specify Or. The default
	// value is And.
	Operator BooleanOperator

	// A list of search expression objects.
	SubExpressions []SearchExpression

	noSmithyDocumentSerde
}

// A single resource returned as part of the Search API response.
type SearchRecord struct {

	// A hosted endpoint for real-time inference.
	Endpoint *Endpoint

	// The properties of an experiment.
	Experiment *Experiment

	// Amazon SageMaker Feature Store stores features in a collection called Feature
	// Group. A Feature Group can be visualized as a table which has rows, with a
	// unique identifier for each row where each column in the table is a feature. In
	// principle, a Feature Group is composed of features and values per features.
	FeatureGroup *FeatureGroup

	// The feature metadata used to search through the features.
	FeatureMetadata *FeatureMetadata

	// A versioned model that can be deployed for SageMaker inference.
	ModelPackage *ModelPackage

	// A group of versioned models in the model registry.
	ModelPackageGroup *ModelPackageGroup

	// A SageMaker Model Building Pipeline instance.
	Pipeline *Pipeline

	// An execution of a pipeline.
	PipelineExecution *PipelineExecution

	// The properties of a project.
	Project *Project

	// The properties of a training job.
	TrainingJob *TrainingJob

	// The properties of a trial.
	Trial *Trial

	// The properties of a trial component.
	TrialComponent *TrialComponent

	noSmithyDocumentSerde
}

// An array element of DescribeTrainingJobResponse$SecondaryStatusTransitions. It
// provides additional details about a status that the training job has
// transitioned through. A training job can be in one of several states, for
// example, starting, downloading, training, or uploading. Within each state, there
// are a number of intermediate states. For example, within the starting state,
// SageMaker could be starting the training job or launching the ML instances.
// These transitional states are referred to as the job's secondary status.
type SecondaryStatusTransition struct {

	// A timestamp that shows when the training job transitioned to the current
	// secondary status state.
	//
	// This member is required.
	StartTime *time.Time

	// Contains a secondary status information from a training job. Status might be one
	// of the following secondary statuses: InProgress
	//
	// * Starting - Starting the
	// training job.
	//
	// * Downloading - An optional stage for algorithms that support
	// File training input mode. It indicates that data is being downloaded to the ML
	// storage volumes.
	//
	// * Training - Training is in progress.
	//
	// * Uploading - Training
	// is complete and the model artifacts are being uploaded to the S3
	// location.
	//
	// Completed
	//
	// * Completed - The training job has completed.
	//
	// Failed
	//
	// *
	// Failed - The training job has failed. The reason for the failure is returned in
	// the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	// *
	// MaxRuntimeExceeded - The job stopped because it exceeded the maximum allowed
	// runtime.
	//
	// * Stopped - The training job has stopped.
	//
	// Stopping
	//
	// * Stopping -
	// Stopping the training job.
	//
	// We no longer support the following secondary
	// statuses:
	//
	// * LaunchingMLInstances
	//
	// * PreparingTrainingStack
	//
	// *
	// DownloadingTrainingImage
	//
	// This member is required.
	Status SecondaryStatus

	// A timestamp that shows when the training job transitioned out of this secondary
	// status state into another secondary status state or when the training job has
	// ended.
	EndTime *time.Time

	// A detailed description of the progress within a secondary status. SageMaker
	// provides secondary statuses and status messages that apply to each of them:
	// Starting
	//
	// * Starting the training job.
	//
	// * Launching requested ML instances.
	//
	// *
	// Insufficient capacity error from EC2 while launching instances, retrying!
	//
	// *
	// Launched instance was unhealthy, replacing it!
	//
	// * Preparing the instances for
	// training.
	//
	// Training
	//
	// * Downloading the training image.
	//
	// * Training image
	// download completed. Training in progress.
	//
	// Status messages are subject to
	// change. Therefore, we recommend not including them in code that programmatically
	// initiates actions. For examples, don't use status messages in if statements. To
	// have an overview of your training job's progress, view TrainingJobStatus and
	// SecondaryStatus in DescribeTrainingJob, and StatusMessage together. For example,
	// at the start of a training job, you might see the following:
	//
	// *
	// TrainingJobStatus - InProgress
	//
	// * SecondaryStatus - Training
	//
	// * StatusMessage -
	// Downloading the training image
	StatusMessage *string

	noSmithyDocumentSerde
}

// Details of a provisioned service catalog product. For information about service
// catalog, see What is Amazon Web Services Service Catalog
// (https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
type ServiceCatalogProvisionedProductDetails struct {

	// The ID of the provisioned product.
	ProvisionedProductId *string

	// The current status of the product.
	//
	// * AVAILABLE - Stable state, ready to perform
	// any operation. The most recent operation succeeded and completed.
	//
	// *
	// UNDER_CHANGE - Transitive state. Operations performed might not have valid
	// results. Wait for an AVAILABLE status before performing operations.
	//
	// * TAINTED -
	// Stable state, ready to perform any operation. The stack has completed the
	// requested operation but is not exactly what was requested. For example, a
	// request to update to a new version failed and the stack rolled back to the
	// current version.
	//
	// * ERROR - An unexpected error occurred. The provisioned
	// product exists but the stack is not running. For example, CloudFormation
	// received a parameter value that was not valid and could not launch the stack.
	//
	// *
	// PLAN_IN_PROGRESS - Transitive state. The plan operations were performed to
	// provision a new product, but resources have not yet been created. After
	// reviewing the list of resources to be created, execute the plan. Wait for an
	// AVAILABLE status before performing operations.
	ProvisionedProductStatusMessage *string

	noSmithyDocumentSerde
}

// Details that you specify to provision a service catalog product. For information
// about service catalog, see What is Amazon Web Services Service Catalog
// (https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
type ServiceCatalogProvisioningDetails struct {

	// The ID of the product to provision.
	//
	// This member is required.
	ProductId *string

	// The path identifier of the product. This value is optional if the product has a
	// default path, and required if the product has more than one path.
	PathId *string

	// The ID of the provisioning artifact.
	ProvisioningArtifactId *string

	// A list of key value pairs that you specify when you provision a product.
	ProvisioningParameters []ProvisioningParameter

	noSmithyDocumentSerde
}

// Details that you specify to provision a service catalog product. For information
// about service catalog, see What is Amazon Web Services Service Catalog
// (https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
type ServiceCatalogProvisioningUpdateDetails struct {

	// The ID of the provisioning artifact.
	ProvisioningArtifactId *string

	// A list of key value pairs that you specify when you provision a product.
	ProvisioningParameters []ProvisioningParameter

	noSmithyDocumentSerde
}

// Specifies options for sharing SageMaker Studio notebooks. These settings are
// specified as part of DefaultUserSettings when the CreateDomain API is called,
// and as part of UserSettings when the CreateUserProfile API is called. When
// SharingSettings is not specified, notebook sharing isn't allowed.
type SharingSettings struct {

	// Whether to include the notebook cell output when sharing the notebook. The
	// default is Disabled.
	NotebookOutputOption NotebookOutputOption

	// When NotebookOutputOption is Allowed, the Amazon Web Services Key Management
	// Service (KMS) encryption key ID used to encrypt the notebook cell output in the
	// Amazon S3 bucket.
	S3KmsKeyId *string

	// When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the
	// shared notebook snapshots.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// A configuration for a shuffle option for input data in a channel. If you use
// S3Prefix for S3DataType, the results of the S3 key prefix matches are shuffled.
// If you use ManifestFile, the order of the S3 object references in the
// ManifestFile is shuffled. If you use AugmentedManifestFile, the order of the
// JSON lines in the AugmentedManifestFile is shuffled. The shuffling order is
// determined using the Seed value. For Pipe input mode, when ShuffleConfig is
// specified shuffling is done at the start of every epoch. With large datasets,
// this ensures that the order of the training data is different for each epoch,
// and it helps reduce bias and possible overfitting. In a multi-node training job
// when ShuffleConfig is combined with S3DataDistributionType of ShardedByS3Key,
// the data is shuffled across nodes so that the content sent to a particular node
// on the first epoch might be sent to a different node on the second epoch.
type ShuffleConfig struct {

	// Determines the shuffling order in ShuffleConfig value.
	//
	// This member is required.
	Seed int64

	noSmithyDocumentSerde
}

// Specifies an algorithm that was used to create the model package. The algorithm
// must be either an algorithm resource in your SageMaker account or an algorithm
// in Amazon Web Services Marketplace that you are subscribed to.
type SourceAlgorithm struct {

	// The name of an algorithm that was used to create the model package. The
	// algorithm must be either an algorithm resource in your SageMaker account or an
	// algorithm in Amazon Web Services Marketplace that you are subscribed to.
	//
	// This member is required.
	AlgorithmName *string

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix). The model artifacts must be in an S3 bucket that is in the
	// same region as the algorithm.
	ModelDataUrl *string

	noSmithyDocumentSerde
}

// A list of algorithms that were used to create a model package.
type SourceAlgorithmSpecification struct {

	// A list of the algorithms that were used to create a model package.
	//
	// This member is required.
	SourceAlgorithms []SourceAlgorithm

	noSmithyDocumentSerde
}

// A list of IP address ranges (CIDRs
// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Used to
// create an allow list of IP addresses for a private workforce. Workers will only
// be able to login to their worker portal from an IP address within this range. By
// default, a workforce isn't restricted to specific IP addresses.
type SourceIpConfig struct {

	// A list of one to ten Classless Inter-Domain Routing
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) (CIDR)
	// values. Maximum: Ten CIDR values The following Length Constraints apply to
	// individual CIDR values in the CIDR value list.
	//
	// This member is required.
	Cidrs []string

	noSmithyDocumentSerde
}

// Specifies a limit to how long a model training job or model compilation job can
// run. It also specifies how long a managed spot training job has to complete.
// When the job reaches the time limit, SageMaker ends the training or compilation
// job. Use this API to cap model training costs. To stop a training job, SageMaker
// sends the algorithm the SIGTERM signal, which delays job termination for 120
// seconds. Algorithms can use this 120-second window to save the model artifacts,
// so the results of training are not lost. The training algorithms provided by
// SageMaker automatically save the intermediate results of a model training job
// when possible. This attempt to save artifacts is only a best effort case as
// model might not be in a state from which it can be saved. For example, if
// training has just started, the model might not be ready to save. When saved,
// this intermediate data is a valid model artifact. You can use it to create a
// model with CreateModel. The Neural Topic Model (NTM) currently does not support
// saving intermediate model artifacts. When training NTMs, make sure that the
// maximum runtime is sufficient for the training job to complete.
type StoppingCondition struct {

	// The maximum length of time, in seconds, that a training or compilation job can
	// run. For compilation jobs, if the job does not complete during this time, a
	// TimeOut error is generated. We recommend starting with 900 seconds and
	// increasing as necessary based on your model. For all other jobs, if the job does
	// not complete during this time, SageMaker ends the job. When RetryStrategy is
	// specified in the job request, MaxRuntimeInSeconds specifies the maximum time for
	// all of the attempts in total, not each individual attempt. The default value is
	// 1 day. The maximum value is 28 days.
	MaxRuntimeInSeconds int32

	// The maximum length of time, in seconds, that a managed Spot training job has to
	// complete. It is the amount of time spent waiting for Spot capacity plus the
	// amount of time the job can run. It must be equal to or greater than
	// MaxRuntimeInSeconds. If the job does not complete during this time, SageMaker
	// ends the job. When RetryStrategy is specified in the job request,
	// MaxWaitTimeInSeconds specifies the maximum time for all of the attempts in
	// total, not each individual attempt.
	MaxWaitTimeInSeconds *int32

	noSmithyDocumentSerde
}

// Details of the Studio Lifecycle Configuration.
type StudioLifecycleConfigDetails struct {

	// The creation time of the Studio Lifecycle Configuration.
	CreationTime *time.Time

	// This value is equivalent to CreationTime because Studio Lifecycle Configurations
	// are immutable.
	LastModifiedTime *time.Time

	// The App type to which the Lifecycle Configuration is attached.
	StudioLifecycleConfigAppType StudioLifecycleConfigAppType

	// The Amazon Resource Name (ARN) of the Lifecycle Configuration.
	StudioLifecycleConfigArn *string

	// The name of the Studio Lifecycle Configuration.
	StudioLifecycleConfigName *string

	noSmithyDocumentSerde
}

// Describes a work team of a vendor that does the a labelling job.
type SubscribedWorkteam struct {

	// The Amazon Resource Name (ARN) of the vendor that you have subscribed.
	//
	// This member is required.
	WorkteamArn *string

	// Marketplace product listing ID.
	ListingId *string

	// The description of the vendor from the Amazon Marketplace.
	MarketplaceDescription *string

	// The title of the service provided by the vendor in the Amazon Marketplace.
	MarketplaceTitle *string

	// The name of the vendor in the Amazon Marketplace.
	SellerName *string

	noSmithyDocumentSerde
}

// Specified in the GetSearchSuggestions request. Limits the property names that
// are included in the response.
type SuggestionQuery struct {

	// Defines a property name hint. Only property names that begin with the specified
	// hint are included in the response.
	PropertyNameQuery *PropertyNameQuery

	noSmithyDocumentSerde
}

// A tag object that consists of a key and an optional value, used to manage
// metadata for SageMaker Amazon Web Services resources. You can add tags to
// notebook instances, training jobs, hyperparameter tuning jobs, batch transform
// jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.
// For more information on adding tags to SageMaker resources, see AddTags. For
// more information on adding metadata to your Amazon Web Services resources with
// tagging, see Tagging Amazon Web Services resources
// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). For advice on
// best practices for managing Amazon Web Services resources with tagging, see
// Tagging Best Practices: Implement an Effective Amazon Web Services Resource
// Tagging Strategy
// (https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf).
type Tag struct {

	// The tag key. Tag keys must be unique per resource.
	//
	// This member is required.
	Key *string

	// The tag value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about a target platform that you want your model to run on,
// such as OS, architecture, and accelerators. It is an alternative of
// TargetDevice.
type TargetPlatform struct {

	// Specifies a target platform architecture.
	//
	// * X86_64: 64-bit version of the x86
	// instruction set.
	//
	// * X86: 32-bit version of the x86 instruction set.
	//
	// * ARM64:
	// ARMv8 64-bit CPU.
	//
	// * ARM_EABIHF: ARMv7 32-bit, Hard Float.
	//
	// * ARM_EABI: ARMv7
	// 32-bit, Soft Float. Used by Android 32-bit ARM platform.
	//
	// This member is required.
	Arch TargetPlatformArch

	// Specifies a target platform OS.
	//
	// * LINUX: Linux-based operating systems.
	//
	// *
	// ANDROID: Android operating systems. Android API level can be specified using the
	// ANDROID_PLATFORM compiler option. For example, "CompilerOptions":
	// {'ANDROID_PLATFORM': 28}
	//
	// This member is required.
	Os TargetPlatformOs

	// Specifies a target platform accelerator (optional).
	//
	// * NVIDIA: Nvidia graphics
	// processing unit. It also requires gpu-code, trt-ver, cuda-ver compiler
	// options
	//
	// * MALI: ARM Mali graphics processor
	//
	// * INTEL_GRAPHICS: Integrated Intel
	// graphics
	Accelerator TargetPlatformAccelerator

	noSmithyDocumentSerde
}

// The TensorBoard app settings.
type TensorBoardAppSettings struct {

	// The default instance type and the Amazon Resource Name (ARN) of the SageMaker
	// image created on the instance.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// Configuration of storage locations for the Debugger TensorBoard output data.
type TensorBoardOutputConfig struct {

	// Path to Amazon S3 storage location for TensorBoard output.
	//
	// This member is required.
	S3OutputPath *string

	// Path to local storage location for tensorBoard output. Defaults to
	// /opt/ml/output/tensorboard.
	LocalPath *string

	noSmithyDocumentSerde
}

// Defines the traffic pattern of the load test.
type TrafficPattern struct {

	// Defines the phases traffic specification.
	Phases []Phase

	// Defines the traffic patterns.
	TrafficType TrafficType

	noSmithyDocumentSerde
}

// Defines the traffic routing strategy during an endpoint deployment to shift
// traffic from the old fleet to the new fleet.
type TrafficRoutingConfig struct {

	// Traffic routing strategy type.
	//
	// * ALL_AT_ONCE: Endpoint traffic shifts to the
	// new fleet in a single step.
	//
	// * CANARY: Endpoint traffic shifts to the new fleet
	// in two steps. The first step is the canary, which is a small portion of the
	// traffic. The second step is the remainder of the traffic.
	//
	// * LINEAR: Endpoint
	// traffic shifts to the new fleet in n steps of a configurable size.
	//
	// This member is required.
	Type TrafficRoutingConfigType

	// The waiting time (in seconds) between incremental steps to turn on traffic on
	// the new endpoint fleet.
	//
	// This member is required.
	WaitIntervalInSeconds *int32

	// Batch size for the first step to turn on traffic on the new endpoint fleet.
	// Value must be less than or equal to 50% of the variant's total instance count.
	CanarySize *CapacitySize

	// Batch size for each step to turn on traffic on the new endpoint fleet. Value
	// must be 10-50% of the variant's total instance count.
	LinearStepSize *CapacitySize

	noSmithyDocumentSerde
}

// Contains information about a training job.
type TrainingJob struct {

	// Information about the algorithm used for training, and algorithm metadata.
	AlgorithmSpecification *AlgorithmSpecification

	// The Amazon Resource Name (ARN) of the job.
	AutoMLJobArn *string

	// The billable time in seconds.
	BillableTimeInSeconds *int32

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig

	// A timestamp that indicates when the training job was created.
	CreationTime *time.Time

	// Configuration information for the Debugger hook parameters, metric and tensor
	// collections, and storage paths. To learn more about how to configure the
	// DebugHookConfig parameter, see Use the SageMaker and Debugger Configuration API
	// Operations to Create, Update, and Debug Your Training Job
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
	DebugHookConfig *DebugHookConfig

	// Information about the debug rule configuration.
	DebugRuleConfigurations []DebugRuleConfiguration

	// Information about the evaluation status of the rules for the training job.
	DebugRuleEvaluationStatuses []DebugRuleEvaluationStatus

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use a deep
	// learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption bool

	// When true, enables managed spot training using Amazon EC2 Spot instances to run
	// training jobs instead of on-demand instances. For more information, see Managed
	// Spot Training
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
	EnableManagedSpotTraining bool

	// If the TrainingJob was created with network isolation, the value is set to true.
	// If network isolation is enabled, nodes can't communicate beyond the VPC they run
	// in.
	EnableNetworkIsolation bool

	// The environment variables to set in the Docker container.
	Environment map[string]string

	// Associates a SageMaker job as a trial component with an experiment and trial.
	// Specified when you call the following APIs:
	//
	// * CreateProcessingJob
	//
	// *
	// CreateTrainingJob
	//
	// * CreateTransformJob
	ExperimentConfig *ExperimentConfig

	// If the training job failed, the reason it failed.
	FailureReason *string

	// A list of final metric values that are set when the training job completes. Used
	// only if the training job was configured to use metrics.
	FinalMetricDataList []MetricData

	// Algorithm-specific parameters.
	HyperParameters map[string]string

	// An array of Channel objects that describes each data input channel.
	InputDataConfig []Channel

	// The Amazon Resource Name (ARN) of the labeling job.
	LabelingJobArn *string

	// A timestamp that indicates when the status of the training job was last
	// modified.
	LastModifiedTime *time.Time

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	ModelArtifacts *ModelArtifacts

	// The S3 path where model artifacts that you configured when creating the job are
	// stored. SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	ResourceConfig *ResourceConfig

	// The number of times to retry the job when the job fails due to an
	// InternalServerError.
	RetryStrategy *RetryStrategy

	// The Amazon Web Services Identity and Access Management (IAM) role configured for
	// the training job.
	RoleArn *string

	// Provides detailed information about the state of the training job. For detailed
	// information about the secondary status of the training job, see StatusMessage
	// under SecondaryStatusTransition. SageMaker provides primary statuses and
	// secondary statuses that apply to each of them: InProgress
	//
	// * Starting - Starting
	// the training job.
	//
	// * Downloading - An optional stage for algorithms that support
	// File training input mode. It indicates that data is being downloaded to the ML
	// storage volumes.
	//
	// * Training - Training is in progress.
	//
	// * Uploading - Training
	// is complete and the model artifacts are being uploaded to the S3
	// location.
	//
	// Completed
	//
	// * Completed - The training job has completed.
	//
	// Failed
	//
	// *
	// Failed - The training job has failed. The reason for the failure is returned in
	// the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	// *
	// MaxRuntimeExceeded - The job stopped because it exceeded the maximum allowed
	// runtime.
	//
	// * Stopped - The training job has stopped.
	//
	// Stopping
	//
	// * Stopping -
	// Stopping the training job.
	//
	// Valid values for SecondaryStatus are subject to
	// change. We no longer support the following secondary statuses:
	//
	// *
	// LaunchingMLInstances
	//
	// * PreparingTrainingStack
	//
	// * DownloadingTrainingImage
	SecondaryStatus SecondaryStatus

	// A history of all of the secondary statuses that the training job has
	// transitioned through.
	SecondaryStatusTransitions []SecondaryStatusTransition

	// Specifies a limit to how long a model training job can run. It also specifies
	// how long a managed Spot training job has to complete. When the job reaches the
	// time limit, SageMaker ends the training job. Use this API to cap model training
	// costs. To stop a job, SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	StoppingCondition *StoppingCondition

	// An array of key-value pairs. You can use tags to categorize your Amazon Web
	// Services resources in different ways, for example, by purpose, owner, or
	// environment. For more information, see Tagging Amazon Web Services Resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
	Tags []Tag

	// Configuration of storage locations for the Debugger TensorBoard output data.
	TensorBoardOutputConfig *TensorBoardOutputConfig

	// Indicates the time when the training job ends on training instances. You are
	// billed for the time interval between the value of TrainingStartTime and this
	// time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when SageMaker detects
	// a job failure.
	TrainingEndTime *time.Time

	// The Amazon Resource Name (ARN) of the training job.
	TrainingJobArn *string

	// The name of the training job.
	TrainingJobName *string

	// The status of the training job. Training job statuses are:
	//
	// * InProgress - The
	// training is in progress.
	//
	// * Completed - The training job has completed.
	//
	// *
	// Failed - The training job has failed. To see the reason for the failure, see the
	// FailureReason field in the response to a DescribeTrainingJobResponse call.
	//
	// *
	// Stopping - The training job is stopping.
	//
	// * Stopped - The training job has
	// stopped.
	//
	// For more detailed information, see SecondaryStatus.
	TrainingJobStatus TrainingJobStatus

	// Indicates the time when the training job starts on training instances. You are
	// billed for the time interval between this time and the value of TrainingEndTime.
	// The start time in CloudWatch Logs might be later than this time. The difference
	// is due to the time it takes to download the training data and to the size of the
	// training container.
	TrainingStartTime *time.Time

	// The training time in seconds.
	TrainingTimeInSeconds *int32

	// The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if
	// the training job was launched by a hyperparameter tuning job.
	TuningJobArn *string

	// A VpcConfig object that specifies the VPC that this training job has access to.
	// For more information, see Protect Training Jobs by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Defines the input needed to run a training job using the algorithm.
type TrainingJobDefinition struct {

	// An array of Channel objects, each of which specifies an input source.
	//
	// This member is required.
	InputDataConfig []Channel

	// the path to the S3 bucket where you want to store model artifacts. SageMaker
	// creates subfolders for the artifacts.
	//
	// This member is required.
	OutputDataConfig *OutputDataConfig

	// The resources, including the ML compute instances and ML storage volumes, to use
	// for model training.
	//
	// This member is required.
	ResourceConfig *ResourceConfig

	// Specifies a limit to how long a model training job can run. It also specifies
	// how long a managed Spot training job has to complete. When the job reaches the
	// time limit, SageMaker ends the training job. Use this API to cap model training
	// costs. To stop a job, SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts.
	//
	// This member is required.
	StoppingCondition *StoppingCondition

	// The training input mode that the algorithm supports. For more information about
	// input modes, see Algorithms
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). Pipe mode If an
	// algorithm supports Pipe mode, Amazon SageMaker streams data directly from Amazon
	// S3 to the container. File mode If an algorithm supports File mode, SageMaker
	// downloads the training data from S3 to the provisioned ML storage volume, and
	// mounts the directory to the Docker volume for the training container. You must
	// provision the ML storage volume with sufficient capacity to accommodate the data
	// downloaded from S3. In addition to the training data, the ML storage volume also
	// stores the output model. The algorithm container uses the ML storage volume to
	// also store intermediate information, if any. For distributed algorithms,
	// training data is distributed uniformly. Your training duration is predictable if
	// the input data objects sizes are approximately the same. SageMaker does not
	// split the files any further for model training. If the object sizes are skewed,
	// training won't be optimal as the data distribution is also skewed when one host
	// in a training cluster is overloaded, thus becoming a bottleneck in training.
	// FastFile mode If an algorithm supports FastFile mode, SageMaker streams data
	// directly from S3 to the container with no code changes, and provides file system
	// access to the data. Users can author their training script to interact with
	// these files as if they were stored on disk. FastFile mode works best when the
	// data is read sequentially. Augmented manifest files aren't supported. The
	// startup time is lower when there are fewer files in the S3 bucket provided.
	//
	// This member is required.
	TrainingInputMode TrainingInputMode

	// The hyperparameters used for the training job.
	HyperParameters map[string]string

	noSmithyDocumentSerde
}

// The numbers of training jobs launched by a hyperparameter tuning job,
// categorized by status.
type TrainingJobStatusCounters struct {

	// The number of completed training jobs launched by the hyperparameter tuning job.
	Completed int32

	// The number of in-progress training jobs launched by a hyperparameter tuning job.
	InProgress int32

	// The number of training jobs that failed and can't be retried. A failed training
	// job can't be retried if it failed because a client error occurred.
	NonRetryableError int32

	// The number of training jobs that failed, but can be retried. A failed training
	// job can be retried only if it failed because an internal service error occurred.
	RetryableError int32

	// The number of training jobs launched by a hyperparameter tuning job that were
	// manually stopped.
	Stopped int32

	noSmithyDocumentSerde
}

// Metadata for a training job step.
type TrainingJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the training job that was run by this step
	// execution.
	Arn *string

	noSmithyDocumentSerde
}

// Provides summary information about a training job.
type TrainingJobSummary struct {

	// A timestamp that shows when the training job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the training job.
	//
	// This member is required.
	TrainingJobArn *string

	// The name of the training job that you want a summary for.
	//
	// This member is required.
	TrainingJobName *string

	// The status of the training job.
	//
	// This member is required.
	TrainingJobStatus TrainingJobStatus

	// Timestamp when the training job was last modified.
	LastModifiedTime *time.Time

	// A timestamp that shows when the training job ended. This field is set only if
	// the training job has one of the terminal statuses (Completed, Failed, or
	// Stopped).
	TrainingEndTime *time.Time

	noSmithyDocumentSerde
}

// Defines how the algorithm is used for a training job.
type TrainingSpecification struct {

	// A list of the instance types that this algorithm can use for training.
	//
	// This member is required.
	SupportedTrainingInstanceTypes []TrainingInstanceType

	// A list of ChannelSpecification objects, which specify the input sources to be
	// used by the algorithm.
	//
	// This member is required.
	TrainingChannels []ChannelSpecification

	// The Amazon ECR registry path of the Docker image that contains the training
	// algorithm.
	//
	// This member is required.
	TrainingImage *string

	// A list of MetricDefinition objects, which are used for parsing metrics generated
	// by the algorithm.
	MetricDefinitions []MetricDefinition

	// A list of the HyperParameterSpecification objects, that define the supported
	// hyperparameters. This is required if the algorithm supports automatic model
	// tuning.>
	SupportedHyperParameters []HyperParameterSpecification

	// A list of the metrics that the algorithm emits that can be used as the objective
	// metric in a hyperparameter tuning job.
	SupportedTuningJobObjectiveMetrics []HyperParameterTuningJobObjective

	// Indicates whether the algorithm supports distributed training. If set to false,
	// buyers can't request more than one instance during training.
	SupportsDistributedTraining bool

	// An MD5 hash of the training algorithm that identifies the Docker image used for
	// training.
	TrainingImageDigest *string

	noSmithyDocumentSerde
}

// Describes the location of the channel data.
type TransformDataSource struct {

	// The S3 location of the data source that is associated with a channel.
	//
	// This member is required.
	S3DataSource *TransformS3DataSource

	noSmithyDocumentSerde
}

// Describes the input source of a transform job and the way the transform job
// consumes it.
type TransformInput struct {

	// Describes the location of the channel data, which is, the S3 location of the
	// input data that the model can consume.
	//
	// This member is required.
	DataSource *TransformDataSource

	// If your transform data is compressed, specify the compression type. Amazon
	// SageMaker automatically decompresses the data for the transform job accordingly.
	// The default value is None.
	CompressionType CompressionType

	// The multipurpose internet mail extension (MIME) type of the data. Amazon
	// SageMaker uses the MIME type with each http call to transfer data to the
	// transform job.
	ContentType *string

	// The method to use to split the transform job's data files into smaller batches.
	// Splitting is necessary when the total size of each object is too large to fit in
	// a single request. You can also use data splitting to improve performance by
	// processing multiple concurrent mini-batches. The default value for SplitType is
	// None, which indicates that input data files are not split, and request payloads
	// contain the entire contents of an input object. Set the value of this parameter
	// to Line to split records on a newline character boundary. SplitType also
	// supports a number of record-oriented binary data formats. Currently, the
	// supported record formats are:
	//
	// * RecordIO
	//
	// * TFRecord
	//
	// When splitting is
	// enabled, the size of a mini-batch depends on the values of the BatchStrategy and
	// MaxPayloadInMB parameters. When the value of BatchStrategy is MultiRecord,
	// Amazon SageMaker sends the maximum number of records in each request, up to the
	// MaxPayloadInMB limit. If the value of BatchStrategy is SingleRecord, Amazon
	// SageMaker sends individual records in each request. Some data formats represent
	// a record as a binary payload wrapped with extra padding bytes. When splitting is
	// applied to a binary data format, padding is removed if the value of
	// BatchStrategy is set to SingleRecord. Padding is not removed if the value of
	// BatchStrategy is set to MultiRecord. For more information about RecordIO, see
	// Create a Dataset Using RecordIO (https://mxnet.apache.org/api/faq/recordio) in
	// the MXNet documentation. For more information about TFRecord, see Consuming
	// TFRecord data (https://www.tensorflow.org/guide/data#consuming_tfrecord_data) in
	// the TensorFlow documentation.
	SplitType SplitType

	noSmithyDocumentSerde
}

// A batch transform job. For information about SageMaker batch transform, see Use
// Batch Transform
// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
type TransformJob struct {

	// The Amazon Resource Name (ARN) of the AutoML job that created the transform job.
	AutoMLJobArn *string

	// Specifies the number of records to include in a mini-batch for an HTTP inference
	// request. A record is a single unit of input data that inference can be made on.
	// For example, a single line in a CSV file is a record.
	BatchStrategy BatchStrategy

	// A timestamp that shows when the transform Job was created.
	CreationTime *time.Time

	// The data structure used to specify the data to be used for inference in a batch
	// transform job and to associate the data that is relevant to the prediction
	// results in the output. The input filter provided allows you to exclude input
	// data that is not needed for inference in a batch transform job. The output
	// filter provided allows you to include input data relevant to interpreting the
	// predictions in the output from the job. For more information, see Associate
	// Prediction Results with their Corresponding Input Records
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
	DataProcessing *DataProcessing

	// The environment variables to set in the Docker container. We support up to 16
	// key and values entries in the map.
	Environment map[string]string

	// Associates a SageMaker job as a trial component with an experiment and trial.
	// Specified when you call the following APIs:
	//
	// * CreateProcessingJob
	//
	// *
	// CreateTrainingJob
	//
	// * CreateTransformJob
	ExperimentConfig *ExperimentConfig

	// If the transform job failed, the reason it failed.
	FailureReason *string

	// The Amazon Resource Name (ARN) of the labeling job that created the transform
	// job.
	LabelingJobArn *string

	// The maximum number of parallel requests that can be sent to each instance in a
	// transform job. If MaxConcurrentTransforms is set to 0 or left unset, SageMaker
	// checks the optional execution-parameters to determine the settings for your
	// chosen algorithm. If the execution-parameters endpoint is not enabled, the
	// default value is 1. For built-in algorithms, you don't need to set a value for
	// MaxConcurrentTransforms.
	MaxConcurrentTransforms *int32

	// The maximum allowed size of the payload, in MB. A payload is the data portion of
	// a record (without metadata). The value in MaxPayloadInMB must be greater than,
	// or equal to, the size of a single record. To estimate the size of a record in
	// MB, divide the size of your dataset by the number of records. To ensure that the
	// records fit within the maximum payload size, we recommend using a slightly
	// larger value. The default value is 6 MB. For cases where the payload might be
	// arbitrarily large and is transmitted using HTTP chunked encoding, set the value
	// to 0. This feature works only in supported algorithms. Currently, SageMaker
	// built-in algorithms do not support HTTP chunked encoding.
	MaxPayloadInMB *int32

	// Configures the timeout and maximum number of retries for processing a transform
	// job invocation.
	ModelClientConfig *ModelClientConfig

	// The name of the model associated with the transform job.
	ModelName *string

	// A list of tags associated with the transform job.
	Tags []Tag

	// Indicates when the transform job has been completed, or has stopped or failed.
	// You are billed for the time interval between this time and the value of
	// TransformStartTime.
	TransformEndTime *time.Time

	// Describes the input source of a transform job and the way the transform job
	// consumes it.
	TransformInput *TransformInput

	// The Amazon Resource Name (ARN) of the transform job.
	TransformJobArn *string

	// The name of the transform job.
	TransformJobName *string

	// The status of the transform job. Transform job statuses are:
	//
	// * InProgress - The
	// job is in progress.
	//
	// * Completed - The job has completed.
	//
	// * Failed - The
	// transform job has failed. To see the reason for the failure, see the
	// FailureReason field in the response to a DescribeTransformJob call.
	//
	// * Stopping
	// - The transform job is stopping.
	//
	// * Stopped - The transform job has stopped.
	TransformJobStatus TransformJobStatus

	// Describes the results of a transform job.
	TransformOutput *TransformOutput

	// Describes the resources, including ML instance types and ML instance count, to
	// use for transform job.
	TransformResources *TransformResources

	// Indicates when the transform job starts on ML instances. You are billed for the
	// time interval between this time and the value of TransformEndTime.
	TransformStartTime *time.Time

	noSmithyDocumentSerde
}

// Defines the input needed to run a transform job using the inference
// specification specified in the algorithm.
type TransformJobDefinition struct {

	// A description of the input source and the way the transform job consumes it.
	//
	// This member is required.
	TransformInput *TransformInput

	// Identifies the Amazon S3 location where you want Amazon SageMaker to save the
	// results from the transform job.
	//
	// This member is required.
	TransformOutput *TransformOutput

	// Identifies the ML compute instances for the transform job.
	//
	// This member is required.
	TransformResources *TransformResources

	// A string that determines the number of records included in a single mini-batch.
	// SingleRecord means only one record is used per mini-batch. MultiRecord means a
	// mini-batch is set to contain as many records that can fit within the
	// MaxPayloadInMB limit.
	BatchStrategy BatchStrategy

	// The environment variables to set in the Docker container. We support up to 16
	// key and values entries in the map.
	Environment map[string]string

	// The maximum number of parallel requests that can be sent to each instance in a
	// transform job. The default value is 1.
	MaxConcurrentTransforms *int32

	// The maximum payload size allowed, in MB. A payload is the data portion of a
	// record (without metadata).
	MaxPayloadInMB *int32

	noSmithyDocumentSerde
}

// Metadata for a transform job step.
type TransformJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the transform job that was run by this step
	// execution.
	Arn *string

	noSmithyDocumentSerde
}

// Provides a summary of a transform job. Multiple TransformJobSummary objects are
// returned as a list after in response to a ListTransformJobs call.
type TransformJobSummary struct {

	// A timestamp that shows when the transform Job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// This member is required.
	TransformJobArn *string

	// The name of the transform job.
	//
	// This member is required.
	TransformJobName *string

	// The status of the transform job.
	//
	// This member is required.
	TransformJobStatus TransformJobStatus

	// If the transform job failed, the reason it failed.
	FailureReason *string

	// Indicates when the transform job was last modified.
	LastModifiedTime *time.Time

	// Indicates when the transform job ends on compute instances. For successful jobs
	// and stopped jobs, this is the exact time recorded after the results are
	// uploaded. For failed jobs, this is when Amazon SageMaker detected that the job
	// failed.
	TransformEndTime *time.Time

	noSmithyDocumentSerde
}

// Describes the results of a transform job.
type TransformOutput struct {

	// The Amazon S3 path where you want Amazon SageMaker to store the results of the
	// transform job. For example, s3://bucket-name/key-name-prefix. For every S3
	// object used as input for the transform job, batch transform stores the
	// transformed data with an .out suffix in a corresponding subfolder in the
	// location in the output prefix. For example, for the input data stored at
	// s3://bucket-name/input-name-prefix/dataset01/data.csv, batch transform stores
	// the transformed data at
	// s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out. Batch
	// transform doesn't upload partially processed objects. For an input S3 object
	// that contains multiple records, it creates an .out file only if the transform
	// job succeeds on the entire file. When the input contains multiple S3 objects,
	// the batch transform job processes the listed S3 objects and uploads only the
	// output for successfully processed objects. If any object fails in the transform
	// job batch transform marks the job as failed to prompt investigation.
	//
	// This member is required.
	S3OutputPath *string

	// The MIME type used to specify the output data. Amazon SageMaker uses the MIME
	// type with each http call to transfer data from the transform job.
	Accept *string

	// Defines how to assemble the results of the transform job as a single S3 object.
	// Choose a format that is most convenient to you. To concatenate the results in
	// binary format, specify None. To add a newline character at the end of every
	// transformed record, specify Line.
	AssembleWith AssemblyType

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon
	// S3 server-side encryption. The KmsKeyId can be any of the following formats:
	//
	// *
	// Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// * Key ARN:
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// *
	// Alias name: alias/ExampleAlias
	//
	// * Alias name ARN:
	// arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// If you don't provide a
	// KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
	// role's account. For more information, see KMS-Managed Encryption Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the
	// Amazon Simple Storage Service Developer Guide. The KMS key policy must grant
	// permission to the IAM role that you specify in your CreateModel
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html)
	// request. For more information, see Using Key Policies in Amazon Web Services KMS
	// (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the
	// Amazon Web Services Key Management Service Developer Guide.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Describes the resources, including ML instance types and ML instance count, to
// use for transform job.
type TransformResources struct {

	// The number of ML compute instances to use in the transform job. For distributed
	// transform jobs, specify a value greater than 1. The default value is 1.
	//
	// This member is required.
	InstanceCount *int32

	// The ML compute instance type for the transform job. If you are using built-in
	// algorithms to transform moderately sized datasets, we recommend using
	// ml.m4.xlarge or ml.m5.largeinstance types.
	//
	// This member is required.
	InstanceType TransformInstanceType

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt model data on the storage volume attached
	// to the ML compute instance(s) that run the batch transform job. Certain
	// Nitro-based instances include local storage, dependent on the instance type.
	// Local storage volumes are encrypted using a hardware module on the instance. You
	// can't request a VolumeKmsKeyId when using an instance type with local storage.
	// For a list of instance types that support local instance storage, see Instance
	// Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	// For more information about local instance storage encryption, see SSD Instance
	// Store Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
	// The VolumeKmsKeyId can be any of the following formats:
	//
	// * Key ID:
	// 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// * Key ARN:
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// *
	// Alias name: alias/ExampleAlias
	//
	// * Alias name ARN:
	// arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// Describes the S3 data source.
type TransformS3DataSource struct {

	// If you choose S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects with the specified key name prefix for batch transform. If you
	// choose ManifestFile, S3Uri identifies an object that is a manifest file
	// containing a list of object keys that you want Amazon SageMaker to use for batch
	// transform. The following values are compatible: ManifestFile, S3Prefix The
	// following value is not compatible: AugmentedManifestFile
	//
	// This member is required.
	S3DataType S3DataType

	// Depending on the value specified for the S3DataType, identifies either a key
	// name prefix or a manifest. For example:
	//
	// * A key name prefix might look like
	// this: s3://bucketname/exampleprefix.
	//
	// * A manifest might look like this:
	// s3://bucketname/example.manifest The manifest is an S3 object which is a JSON
	// file with the following format: [ {"prefix":
	// "s3://customer_bucket/some/prefix/"},"relative/path/to/custdata-1","relative/path/custdata-2",..."relative/path/custdata-N"]
	// The preceding JSON matches the following S3Uris:
	// s3://customer_bucket/some/prefix/relative/path/to/custdata-1s3://customer_bucket/some/prefix/relative/path/custdata-2...s3://customer_bucket/some/prefix/relative/path/custdata-N
	// The complete set of S3Uris in this manifest constitutes the input data for the
	// channel for this datasource. The object that each S3Uris points to must be
	// readable by the IAM role that Amazon SageMaker uses to perform tasks on your
	// behalf.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The properties of a trial as returned by the Search API.
type Trial struct {

	// Who created the trial.
	CreatedBy *UserContext

	// When the trial was created.
	CreationTime *time.Time

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName is
	// displayed.
	DisplayName *string

	// The name of the experiment the trial is part of.
	ExperimentName *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// Who last modified the trial.
	LastModifiedTime *time.Time

	// Metadata properties of the tracking entity, trial, or trial component.
	MetadataProperties *MetadataProperties

	// The source of the trial.
	Source *TrialSource

	// The list of tags that are associated with the trial. You can use Search API to
	// search on the tags.
	Tags []Tag

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string

	// A list of the components associated with the trial. For each component, a
	// summary of the component's properties is included.
	TrialComponentSummaries []TrialComponentSimpleSummary

	// The name of the trial.
	TrialName *string

	noSmithyDocumentSerde
}

// The properties of a trial component as returned by the Search API.
type TrialComponent struct {

	// Who created the trial component.
	CreatedBy *UserContext

	// When the component was created.
	CreationTime *time.Time

	// The name of the component as displayed. If DisplayName isn't specified,
	// TrialComponentName is displayed.
	DisplayName *string

	// When the component ended.
	EndTime *time.Time

	// The input artifacts of the component.
	InputArtifacts map[string]TrialComponentArtifact

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// When the component was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the lineage group resource.
	LineageGroupArn *string

	// Metadata properties of the tracking entity, trial, or trial component.
	MetadataProperties *MetadataProperties

	// The metrics for the component.
	Metrics []TrialComponentMetricSummary

	// The output artifacts of the component.
	OutputArtifacts map[string]TrialComponentArtifact

	// The hyperparameters of the component.
	Parameters map[string]TrialComponentParameterValue

	// An array of the parents of the component. A parent is a trial the component is
	// associated with and the experiment the trial is part of. A component might not
	// have any parents.
	Parents []Parent

	// The Amazon Resource Name (ARN) and job type of the source of the component.
	Source *TrialComponentSource

	// Details of the source of the component.
	SourceDetail *TrialComponentSourceDetail

	// When the component started.
	StartTime *time.Time

	// The status of the trial component.
	Status *TrialComponentStatus

	// The list of tags that are associated with the component. You can use Search API
	// to search on the tags.
	Tags []Tag

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string

	// The name of the trial component.
	TrialComponentName *string

	noSmithyDocumentSerde
}

// Represents an input or output artifact of a trial component. You specify
// TrialComponentArtifact as part of the InputArtifacts and OutputArtifacts
// parameters in the CreateTrialComponent request. Examples of input artifacts are
// datasets, algorithms, hyperparameters, source code, and instance types. Examples
// of output artifacts are metrics, snapshots, logs, and images.
type TrialComponentArtifact struct {

	// The location of the artifact.
	//
	// This member is required.
	Value *string

	// The media type of the artifact, which indicates the type of data in the artifact
	// file. The media type consists of a type and a subtype concatenated with a slash
	// (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies
	// the category of the media. The subtype specifies the kind of data.
	MediaType *string

	noSmithyDocumentSerde
}

// A summary of the metrics of a trial component.
type TrialComponentMetricSummary struct {

	// The average value of the metric.
	Avg *float64

	// The number of samples used to generate the metric.
	Count *int32

	// The most recent value of the metric.
	Last *float64

	// The maximum value of the metric.
	Max *float64

	// The name of the metric.
	MetricName *string

	// The minimum value of the metric.
	Min *float64

	// The Amazon Resource Name (ARN) of the source.
	SourceArn *string

	// The standard deviation of the metric.
	StdDev *float64

	// When the metric was last updated.
	TimeStamp *time.Time

	noSmithyDocumentSerde
}

// The value of a hyperparameter. Only one of NumberValue or StringValue can be
// specified. This object is specified in the CreateTrialComponent request.
//
// The following types satisfy this interface:
//  TrialComponentParameterValueMemberNumberValue
//  TrialComponentParameterValueMemberStringValue
type TrialComponentParameterValue interface {
	isTrialComponentParameterValue()
}

// The numeric value of a numeric hyperparameter. If you specify a value for this
// parameter, you can't specify the StringValue parameter.
type TrialComponentParameterValueMemberNumberValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*TrialComponentParameterValueMemberNumberValue) isTrialComponentParameterValue() {}

// The string value of a categorical hyperparameter. If you specify a value for
// this parameter, you can't specify the NumberValue parameter.
type TrialComponentParameterValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*TrialComponentParameterValueMemberStringValue) isTrialComponentParameterValue() {}

// A short summary of a trial component.
type TrialComponentSimpleSummary struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// When the component was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string

	// The name of the trial component.
	TrialComponentName *string

	// The Amazon Resource Name (ARN) and job type of the source of a trial component.
	TrialComponentSource *TrialComponentSource

	noSmithyDocumentSerde
}

// The Amazon Resource Name (ARN) and job type of the source of a trial component.
type TrialComponentSource struct {

	// The source ARN.
	//
	// This member is required.
	SourceArn *string

	// The source job type.
	SourceType *string

	noSmithyDocumentSerde
}

// Detailed information about the source of a trial component. Either ProcessingJob
// or TrainingJob is returned.
type TrialComponentSourceDetail struct {

	// Information about a processing job that's the source of a trial component.
	ProcessingJob *ProcessingJob

	// The Amazon Resource Name (ARN) of the source.
	SourceArn *string

	// Information about a training job that's the source of a trial component.
	TrainingJob *TrainingJob

	// Information about a transform job that's the source of a trial component.
	TransformJob *TransformJob

	noSmithyDocumentSerde
}

// The status of the trial component.
type TrialComponentStatus struct {

	// If the component failed, a message describing why.
	Message *string

	// The status of the trial component.
	PrimaryStatus TrialComponentPrimaryStatus

	noSmithyDocumentSerde
}

// A summary of the properties of a trial component. To get all the properties,
// call the DescribeTrialComponent API and provide the TrialComponentName.
type TrialComponentSummary struct {

	// Who created the trial component.
	CreatedBy *UserContext

	// When the component was created.
	CreationTime *time.Time

	// The name of the component as displayed. If DisplayName isn't specified,
	// TrialComponentName is displayed.
	DisplayName *string

	// When the component ended.
	EndTime *time.Time

	// Who last modified the component.
	LastModifiedBy *UserContext

	// When the component was last modified.
	LastModifiedTime *time.Time

	// When the component started.
	StartTime *time.Time

	// The status of the component. States include:
	//
	// * InProgress
	//
	// * Completed
	//
	// *
	// Failed
	Status *TrialComponentStatus

	// The ARN of the trial component.
	TrialComponentArn *string

	// The name of the trial component.
	TrialComponentName *string

	// The Amazon Resource Name (ARN) and job type of the source of a trial component.
	TrialComponentSource *TrialComponentSource

	noSmithyDocumentSerde
}

// The source of the trial.
type TrialSource struct {

	// The Amazon Resource Name (ARN) of the source.
	//
	// This member is required.
	SourceArn *string

	// The source job type.
	SourceType *string

	noSmithyDocumentSerde
}

// A summary of the properties of a trial. To get the complete set of properties,
// call the DescribeTrial API and provide the TrialName.
type TrialSummary struct {

	// When the trial was created.
	CreationTime *time.Time

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName is
	// displayed.
	DisplayName *string

	// When the trial was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string

	// The name of the trial.
	TrialName *string

	// The source of the trial.
	TrialSource *TrialSource

	noSmithyDocumentSerde
}

// The job completion criteria.
type TuningJobCompletionCriteria struct {

	// The value of the objective metric.
	//
	// This member is required.
	TargetObjectiveMetricValue *float32

	noSmithyDocumentSerde
}

// Metadata for a tuning step.
type TuningJobStepMetaData struct {

	// The Amazon Resource Name (ARN) of the tuning job that was run by this step
	// execution.
	Arn *string

	noSmithyDocumentSerde
}

// Provided configuration information for the worker UI for a labeling job. Provide
// either HumanTaskUiArn or UiTemplateS3Uri. For named entity recognition, 3D point
// cloud and video frame labeling jobs, use HumanTaskUiArn. For all other Ground
// Truth built-in task types and custom task types, use UiTemplateS3Uri to specify
// the location of a worker task template in Amazon S3.
type UiConfig struct {

	// The ARN of the worker task template used to render the worker UI and tools for
	// labeling job tasks. Use this parameter when you are creating a labeling job for
	// named entity recognition, 3D point cloud and video frame labeling jobs. Use your
	// labeling job task type to select one of the following ARNs and use it with this
	// parameter when you create a labeling job. Replace aws-region with the Amazon Web
	// Services Region you are creating your labeling job in. For example, replace
	// aws-region with us-west-1 if you create a labeling job in US West (N.
	// California). Named Entity Recognition Use the following HumanTaskUiArn for named
	// entity recognition labeling jobs:
	// arn:aws:sagemaker:aws-region:394669845002:human-task-ui/NamedEntityRecognition
	// 3D Point Cloud HumanTaskUiArns Use this HumanTaskUiArn for 3D point cloud object
	// detection and 3D point cloud object detection adjustment labeling jobs.
	//
	// *
	// arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection
	//
	// Use
	// this HumanTaskUiArn for 3D point cloud object tracking and 3D point cloud object
	// tracking adjustment labeling jobs.
	//
	// *
	// arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking
	//
	// Use
	// this HumanTaskUiArn for 3D point cloud semantic segmentation and 3D point cloud
	// semantic segmentation adjustment labeling jobs.
	//
	// *
	// arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation
	//
	// Video
	// Frame HumanTaskUiArns Use this HumanTaskUiArn for video frame object detection
	// and video frame object detection adjustment labeling jobs.
	//
	// *
	// arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection
	//
	// Use
	// this HumanTaskUiArn for video frame object tracking and video frame object
	// tracking adjustment labeling jobs.
	//
	// *
	// arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking
	HumanTaskUiArn *string

	// The Amazon S3 bucket location of the UI template, or worker task template. This
	// is the template used to render the worker UI and tools for labeling job tasks.
	// For more information about the contents of a UI template, see  Creating Your
	// Custom Labeling Task Template
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html).
	UiTemplateS3Uri *string

	noSmithyDocumentSerde
}

// The Liquid template for the worker user interface.
type UiTemplate struct {

	// The content of the Liquid template for the worker user interface.
	//
	// This member is required.
	Content *string

	noSmithyDocumentSerde
}

// Container for user interface template information.
type UiTemplateInfo struct {

	// The SHA-256 digest of the contents of the template.
	ContentSha256 *string

	// The URL for the user interface template.
	Url *string

	noSmithyDocumentSerde
}

// Represents an amount of money in United States dollars.
type USD struct {

	// The fractional portion, in cents, of the amount.
	Cents int32

	// The whole number of dollars in the amount.
	Dollars int32

	// Fractions of a cent, in tenths.
	TenthFractionsOfACent int32

	noSmithyDocumentSerde
}

// Information about the user who created or modified an experiment, trial, trial
// component, lineage group, or project.
type UserContext struct {

	// The domain associated with the user.
	DomainId *string

	// The Amazon Resource Name (ARN) of the user's profile.
	UserProfileArn *string

	// The name of the user's profile.
	UserProfileName *string

	noSmithyDocumentSerde
}

// The user profile details.
type UserProfileDetails struct {

	// The creation time.
	CreationTime *time.Time

	// The domain ID.
	DomainId *string

	// The last modified time.
	LastModifiedTime *time.Time

	// The status.
	Status UserProfileStatus

	// The user profile name.
	UserProfileName *string

	noSmithyDocumentSerde
}

// A collection of settings that apply to users of Amazon SageMaker Studio. These
// settings are specified when the CreateUserProfile API is called, and as
// DefaultUserSettings when the CreateDomain API is called. SecurityGroups is
// aggregated when specified in both calls. For all other settings in UserSettings,
// the values specified in CreateUserProfile take precedence over those specified
// in CreateDomain.
type UserSettings struct {

	// The execution role for the user.
	ExecutionRole *string

	// The Jupyter server's app settings.
	JupyterServerAppSettings *JupyterServerAppSettings

	// The kernel gateway app settings.
	KernelGatewayAppSettings *KernelGatewayAppSettings

	// A collection of settings that configure the RSessionGateway app.
	RSessionAppSettings *RSessionAppSettings

	// A collection of settings that configure user interaction with the
	// RStudioServerPro app.
	RStudioServerProAppSettings *RStudioServerProAppSettings

	// The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses
	// for communication. Optional when the CreateDomain.AppNetworkAccessType parameter
	// is set to PublicInternetOnly. Required when the
	// CreateDomain.AppNetworkAccessType parameter is set to VpcOnly. Amazon SageMaker
	// adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the
	// number of security groups that you can specify is one less than the maximum
	// number shown.
	SecurityGroups []string

	// Specifies options for sharing SageMaker Studio notebooks.
	SharingSettings *SharingSettings

	// The TensorBoard app settings.
	TensorBoardAppSettings *TensorBoardAppSettings

	noSmithyDocumentSerde
}

// Specifies a production variant property type for an Endpoint. If you are
// updating an endpoint with the UpdateEndpointInput$RetainAllVariantProperties
// option set to true, the VariantProperty objects listed in
// UpdateEndpointInput$ExcludeRetainedVariantProperties override the existing
// variant properties of the endpoint.
type VariantProperty struct {

	// The type of variant property. The supported values are:
	//
	// * DesiredInstanceCount:
	// Overrides the existing variant instance counts using the
	// ProductionVariant$InitialInstanceCount values in the
	// CreateEndpointConfigInput$ProductionVariants.
	//
	// * DesiredWeight: Overrides the
	// existing variant weights using the ProductionVariant$InitialVariantWeight values
	// in the CreateEndpointConfigInput$ProductionVariants.
	//
	// * DataCaptureConfig: (Not
	// currently supported.)
	//
	// This member is required.
	VariantPropertyType VariantPropertyType

	noSmithyDocumentSerde
}

// A lineage entity connected to the starting entity(ies).
type Vertex struct {

	// The Amazon Resource Name (ARN) of the lineage entity resource.
	Arn *string

	// The type of resource of the lineage entity.
	LineageType LineageType

	// The type of the lineage entity resource. For example: DataSet, Model, Endpoint,
	// etc...
	Type *string

	noSmithyDocumentSerde
}

// Specifies a VPC that your training jobs and hosted models have access to.
// Control access to and from your training and model containers by configuring the
// VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
// and Protect Training Jobs by Using an Amazon Virtual Private Cloud
// (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
type VpcConfig struct {

	// The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups
	// for the VPC that is specified in the Subnets field.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC to which you want to connect your training job
	// or model. For information about the availability of specific instance types, see
	// Supported Instance Types and Availability Zones
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html).
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// A single private workforce, which is automatically created when you create your
// first private work team. You can create one private work force in each Amazon
// Web Services Region. By default, any workforce-related API operation used in a
// specific region will apply to the workforce created in that region. To learn how
// to create a private workforce, see Create a Private Workforce
// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
type Workforce struct {

	// The Amazon Resource Name (ARN) of the private workforce.
	//
	// This member is required.
	WorkforceArn *string

	// The name of the private workforce.
	//
	// This member is required.
	WorkforceName *string

	// The configuration of an Amazon Cognito workforce. A single Cognito workforce is
	// created using and corresponds to a single  Amazon Cognito user pool
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
	CognitoConfig *CognitoConfig

	// The date that the workforce is created.
	CreateDate *time.Time

	// The reason your workforce failed.
	FailureReason *string

	// The most recent date that was used to successfully add one or more IP address
	// ranges (CIDRs
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to a
	// private workforce's allow list.
	LastUpdatedDate *time.Time

	// The configuration of an OIDC Identity Provider (IdP) private workforce.
	OidcConfig *OidcConfigForResponse

	// A list of one to ten IP address ranges (CIDRs
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to be added
	// to the workforce allow list. By default, a workforce isn't restricted to
	// specific IP addresses.
	SourceIpConfig *SourceIpConfig

	// The status of your workforce.
	Status WorkforceStatus

	// The subdomain for your OIDC Identity Provider.
	SubDomain *string

	// The configuration of a VPC workforce.
	WorkforceVpcConfig *WorkforceVpcConfigResponse

	noSmithyDocumentSerde
}

// The VPC object you use to create or update a workforce.
type WorkforceVpcConfigRequest struct {

	// The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be
	// for the same VPC as specified in the subnet.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC that you want to connect.
	Subnets []string

	// The ID of the VPC that the workforce uses for communication.
	VpcId *string

	noSmithyDocumentSerde
}

// A VpcConfig object that specifies the VPC that you want your workforce to
// connect to.
type WorkforceVpcConfigResponse struct {

	// The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be
	// for the same VPC as specified in the subnet.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC that you want to connect.
	//
	// This member is required.
	Subnets []string

	// The ID of the VPC that the workforce uses for communication.
	//
	// This member is required.
	VpcId *string

	// The IDs for the VPC service endpoints of your VPC workforce when it is created
	// and updated.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// Provides details about a labeling work team.
type Workteam struct {

	// A description of the work team.
	//
	// This member is required.
	Description *string

	// A list of MemberDefinition objects that contains objects that identify the
	// workers that make up the work team. Workforces can be created using Amazon
	// Cognito or your own OIDC Identity Provider (IdP). For private workforces created
	// using Amazon Cognito use CognitoMemberDefinition. For workforces created using
	// your own OIDC identity provider (IdP) use OidcMemberDefinition.
	//
	// This member is required.
	MemberDefinitions []MemberDefinition

	// The Amazon Resource Name (ARN) that identifies the work team.
	//
	// This member is required.
	WorkteamArn *string

	// The name of the work team.
	//
	// This member is required.
	WorkteamName *string

	// The date and time that the work team was created (timestamp).
	CreateDate *time.Time

	// The date and time that the work team was last updated (timestamp).
	LastUpdatedDate *time.Time

	// Configures SNS notifications of available or expiring work items for work teams.
	NotificationConfiguration *NotificationConfiguration

	// The Amazon Marketplace identifier for a vendor's work team.
	ProductListingIds []string

	// The URI of the labeling job's user interface. Workers open this URI to start
	// labeling your data objects.
	SubDomain *string

	// The Amazon Resource Name (ARN) of the workforce.
	WorkforceArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isTrialComponentParameterValue() {}
