// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// What occurs after a certain event.
type Action struct {

	// Details for the export revision to Amazon S3 action.
	ExportRevisionToS3 *AutoExportRevisionToS3RequestDetails

	noSmithyDocumentSerde
}

// The API Gateway API that is the asset.
type ApiGatewayApiAsset struct {

	// The API description of the API asset.
	ApiDescription *string

	// The API endpoint of the API asset.
	ApiEndpoint *string

	// The unique identifier of the API asset.
	ApiId *string

	// The API key of the API asset.
	ApiKey *string

	// The API name of the API asset.
	ApiName *string

	// The download URL of the API specification of the API asset.
	ApiSpecificationDownloadUrl *string

	// The date and time that the upload URL expires, in ISO 8601 format.
	ApiSpecificationDownloadUrlExpiresAt *time.Time

	// The protocol type of the API asset.
	ProtocolType ProtocolType

	// The stage of the API asset.
	Stage *string

	noSmithyDocumentSerde
}

// The destination for the asset.
type AssetDestinationEntry struct {

	// The unique identifier for the asset.
	//
	// This member is required.
	AssetId *string

	// The S3 bucket that is the destination for the asset.
	//
	// This member is required.
	Bucket *string

	// The name of the object in Amazon S3 for the asset.
	Key *string

	noSmithyDocumentSerde
}

// Information about the asset.
type AssetDetails struct {

	// Information about the API Gateway API asset.
	ApiGatewayApiAsset *ApiGatewayApiAsset

	// The Amazon Redshift datashare that is the asset.
	RedshiftDataShareAsset *RedshiftDataShareAsset

	// The S3 object that is the asset.
	S3SnapshotAsset *S3SnapshotAsset

	noSmithyDocumentSerde
}

// An asset in AWS Data Exchange is a piece of data (S3 object) or a means of
// fulfilling data (Amazon Redshift datashare or Amazon API Gateway API). The asset
// can be a structured data file, an image file, or some other data file that can
// be stored as an S3 object, an Amazon API Gateway API, or an Amazon Redshift
// datashare. When you create an import job for your files, API Gateway APIs, or
// Amazon Redshift datashares, you create an asset in AWS Data Exchange.
type AssetEntry struct {

	// The ARN for the asset.
	//
	// This member is required.
	Arn *string

	// Information about the asset.
	//
	// This member is required.
	AssetDetails *AssetDetails

	// The type of asset that is added to a data set.
	//
	// This member is required.
	AssetType AssetType

	// The date and time that the asset was created, in ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier for the data set associated with this asset.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the asset.
	//
	// This member is required.
	Id *string

	// The name of the asset. When importing from Amazon S3, the S3 object key is used
	// as the asset name. When exporting to Amazon S3, the asset name is used as
	// default target S3 object key. When importing from Amazon API Gateway API, the
	// API name is used as the asset name. When importing from Amazon Redshift, the
	// datashare name is used as the asset name.
	//
	// This member is required.
	Name *string

	// The unique identifier for the revision associated with this asset.
	//
	// This member is required.
	RevisionId *string

	// The date and time that the asset was last updated, in ISO 8601 format.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The asset ID of the owned asset corresponding to the entitled asset being
	// viewed. This parameter is returned when an asset owner is viewing the entitled
	// copy of its owned asset.
	SourceId *string

	noSmithyDocumentSerde
}

// The source of the assets.
type AssetSourceEntry struct {

	// The S3 bucket that's part of the source of the asset.
	//
	// This member is required.
	Bucket *string

	// The name of the object in Amazon S3 for the asset.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// A revision destination is the Amazon S3 bucket folder destination to where the
// export will be sent.
type AutoExportRevisionDestinationEntry struct {

	// The S3 bucket that is the destination for the event action.
	//
	// This member is required.
	Bucket *string

	// A string representing the pattern for generated names of the individual assets
	// in the revision. For more information about key patterns, see Key patterns when
	// exporting revisions
	// (https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
	KeyPattern *string

	noSmithyDocumentSerde
}

// Details of the operation to be performed by the job.
type AutoExportRevisionToS3RequestDetails struct {

	// A revision destination is the Amazon S3 bucket folder destination to where the
	// export will be sent.
	//
	// This member is required.
	RevisionDestination *AutoExportRevisionDestinationEntry

	// Encryption configuration for the auto export job.
	Encryption *ExportServerSideEncryption

	noSmithyDocumentSerde
}

// A data set is an AWS resource with one or more revisions.
type DataSetEntry struct {

	// The ARN for the data set.
	//
	// This member is required.
	Arn *string

	// The type of asset that is added to a data set.
	//
	// This member is required.
	AssetType AssetType

	// The date and time that the data set was created, in ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The description for the data set.
	//
	// This member is required.
	Description *string

	// The unique identifier for the data set.
	//
	// This member is required.
	Id *string

	// The name of the data set.
	//
	// This member is required.
	Name *string

	// A property that defines the data set as OWNED by the account (for providers) or
	// ENTITLED to the account (for subscribers).
	//
	// This member is required.
	Origin Origin

	// The date and time that the data set was last updated, in ISO 8601 format.
	//
	// This member is required.
	UpdatedAt *time.Time

	// If the origin of this data set is ENTITLED, includes the details for the product
	// on AWS Marketplace.
	OriginDetails *OriginDetails

	// The data set ID of the owned data set corresponding to the entitled data set
	// being viewed. This parameter is returned when a data set owner is viewing the
	// entitled copy of its owned data set.
	SourceId *string

	noSmithyDocumentSerde
}

// Information about the job error.
type Details struct {

	// Information about the job error.
	ImportAssetFromSignedUrlJobErrorDetails *ImportAssetFromSignedUrlJobErrorDetails

	// Information about the job error.
	ImportAssetsFromS3JobErrorDetails []AssetSourceEntry

	noSmithyDocumentSerde
}

// What occurs to start an action.
type Event struct {

	// What occurs to start the revision publish action.
	RevisionPublished *RevisionPublished

	noSmithyDocumentSerde
}

// An event action is an object that defines the relationship between a specific
// event and an automated action that will be taken on behalf of the customer.
type EventActionEntry struct {

	// What occurs after a certain event.
	//
	// This member is required.
	Action *Action

	// The Amazon Resource Name (ARN) for the event action.
	//
	// This member is required.
	Arn *string

	// The date and time that the event action was created, in ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// What occurs to start an action.
	//
	// This member is required.
	Event *Event

	// The unique identifier for the event action.
	//
	// This member is required.
	Id *string

	// The date and time that the event action was last updated, in ISO 8601 format.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Details of the operation to be performed by the job.
type ExportAssetsToS3RequestDetails struct {

	// The destination for the asset.
	//
	// This member is required.
	AssetDestinations []AssetDestinationEntry

	// The unique identifier for the data set associated with this export job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this export request.
	//
	// This member is required.
	RevisionId *string

	// Encryption configuration for the export job.
	Encryption *ExportServerSideEncryption

	noSmithyDocumentSerde
}

// Details about the export to Amazon S3 response.
type ExportAssetsToS3ResponseDetails struct {

	// The destination in Amazon S3 where the asset is exported.
	//
	// This member is required.
	AssetDestinations []AssetDestinationEntry

	// The unique identifier for the data set associated with this export job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this export response.
	//
	// This member is required.
	RevisionId *string

	// Encryption configuration of the export job.
	Encryption *ExportServerSideEncryption

	noSmithyDocumentSerde
}

// Details of the operation to be performed by the job.
type ExportAssetToSignedUrlRequestDetails struct {

	// The unique identifier for the asset that is exported to a signed URL.
	//
	// This member is required.
	AssetId *string

	// The unique identifier for the data set associated with this export job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this export request.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// The details of the export to signed URL response.
type ExportAssetToSignedUrlResponseDetails struct {

	// The unique identifier for the asset associated with this export job.
	//
	// This member is required.
	AssetId *string

	// The unique identifier for the data set associated with this export job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this export response.
	//
	// This member is required.
	RevisionId *string

	// The signed URL for the export request.
	SignedUrl *string

	// The date and time that the signed URL expires, in ISO 8601 format.
	SignedUrlExpiresAt *time.Time

	noSmithyDocumentSerde
}

// Details of the operation to be performed by the job.
type ExportRevisionsToS3RequestDetails struct {

	// The unique identifier for the data set associated with this export job.
	//
	// This member is required.
	DataSetId *string

	// The destination for the revision.
	//
	// This member is required.
	RevisionDestinations []RevisionDestinationEntry

	// Encryption configuration for the export job.
	Encryption *ExportServerSideEncryption

	noSmithyDocumentSerde
}

// Details about the export revisions to Amazon S3 response.
type ExportRevisionsToS3ResponseDetails struct {

	// The unique identifier for the data set associated with this export job.
	//
	// This member is required.
	DataSetId *string

	// The destination in Amazon S3 where the revision is exported.
	//
	// This member is required.
	RevisionDestinations []RevisionDestinationEntry

	// Encryption configuration of the export job.
	Encryption *ExportServerSideEncryption

	// The Amazon Resource Name (ARN) of the event action.
	EventActionArn *string

	noSmithyDocumentSerde
}

// Encryption configuration of the export job. Includes the encryption type in
// addition to the AWS KMS key. The KMS key is only necessary if you chose the KMS
// encryption. type.
type ExportServerSideEncryption struct {

	// The type of server side encryption used for encrypting the objects in Amazon S3.
	//
	// This member is required.
	Type ServerSideEncryptionTypes

	// The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the
	// Amazon S3 objects. This parameter is required if you choose aws:kms as an
	// encryption type.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// The request details.
type ImportAssetFromApiGatewayApiRequestDetails struct {

	// The API Gateway API ID.
	//
	// This member is required.
	ApiId *string

	// The API name.
	//
	// This member is required.
	ApiName *string

	// The Base64-encoded MD5 hash of the OpenAPI 3.0 JSON API specification file. It
	// is used to ensure the integrity of the file.
	//
	// This member is required.
	ApiSpecificationMd5Hash *string

	// The data set ID.
	//
	// This member is required.
	DataSetId *string

	// The protocol type.
	//
	// This member is required.
	ProtocolType ProtocolType

	// The revision ID.
	//
	// This member is required.
	RevisionId *string

	// The API stage.
	//
	// This member is required.
	Stage *string

	// The API description. Markdown supported.
	ApiDescription *string

	// The API Gateway API key.
	ApiKey *string

	noSmithyDocumentSerde
}

// The response details.
type ImportAssetFromApiGatewayApiResponseDetails struct {

	// The API ID.
	//
	// This member is required.
	ApiId *string

	// The API name.
	//
	// This member is required.
	ApiName *string

	// The Base64-encoded Md5 hash for the API asset, used to ensure the integrity of
	// the API at that location.
	//
	// This member is required.
	ApiSpecificationMd5Hash *string

	// The upload URL of the API specification.
	//
	// This member is required.
	ApiSpecificationUploadUrl *string

	// The date and time that the upload URL expires, in ISO 8601 format.
	//
	// This member is required.
	ApiSpecificationUploadUrlExpiresAt *time.Time

	// The data set ID.
	//
	// This member is required.
	DataSetId *string

	// The protocol type.
	//
	// This member is required.
	ProtocolType ProtocolType

	// The revision ID.
	//
	// This member is required.
	RevisionId *string

	// The API stage.
	//
	// This member is required.
	Stage *string

	// The API description.
	ApiDescription *string

	// The API key.
	ApiKey *string

	noSmithyDocumentSerde
}

// Information about the job error.
type ImportAssetFromSignedUrlJobErrorDetails struct {

	// Information about the job error.
	//
	// This member is required.
	AssetName *string

	noSmithyDocumentSerde
}

// Details of the operation to be performed by the job.
type ImportAssetFromSignedUrlRequestDetails struct {

	// The name of the asset. When importing from Amazon S3, the S3 object key is used
	// as the asset name.
	//
	// This member is required.
	AssetName *string

	// The unique identifier for the data set associated with this import job.
	//
	// This member is required.
	DataSetId *string

	// The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the
	// file at that location.
	//
	// This member is required.
	Md5Hash *string

	// The unique identifier for the revision associated with this import request.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// The details in the response for an import request, including the signed URL and
// other information.
type ImportAssetFromSignedUrlResponseDetails struct {

	// The name for the asset associated with this import job.
	//
	// This member is required.
	AssetName *string

	// The unique identifier for the data set associated with this import job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this import response.
	//
	// This member is required.
	RevisionId *string

	// The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the
	// file at that location.
	Md5Hash *string

	// The signed URL.
	SignedUrl *string

	// The time and date at which the signed URL expires, in ISO 8601 format.
	SignedUrlExpiresAt *time.Time

	noSmithyDocumentSerde
}

// Details from an import from Amazon Redshift datashare request.
type ImportAssetsFromRedshiftDataSharesRequestDetails struct {

	// A list of Amazon Redshift datashare assets.
	//
	// This member is required.
	AssetSources []RedshiftDataShareAssetSourceEntry

	// The unique identifier for the data set associated with this import job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this import job.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// Details from an import from Amazon Redshift datashare response.
type ImportAssetsFromRedshiftDataSharesResponseDetails struct {

	// A list of Amazon Redshift datashare asset sources.
	//
	// This member is required.
	AssetSources []RedshiftDataShareAssetSourceEntry

	// The unique identifier for the data set associated with this import job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this import job.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// Details of the operation to be performed by the job.
type ImportAssetsFromS3RequestDetails struct {

	// Is a list of S3 bucket and object key pairs.
	//
	// This member is required.
	AssetSources []AssetSourceEntry

	// The unique identifier for the data set associated with this import job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this import request.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// Details from an import from Amazon S3 response.
type ImportAssetsFromS3ResponseDetails struct {

	// Is a list of Amazon S3 bucket and object key pairs.
	//
	// This member is required.
	AssetSources []AssetSourceEntry

	// The unique identifier for the data set associated with this import job.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision associated with this import response.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// AWS Data Exchange Jobs are asynchronous import or export operations used to
// create or copy assets. A data set owner can both import and export as they see
// fit. Someone with an entitlement to a data set can only export. Jobs are deleted
// 90 days after they are created.
type JobEntry struct {

	// The ARN for the job.
	//
	// This member is required.
	Arn *string

	// The date and time that the job was created, in ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// Details of the operation to be performed by the job, such as export destination
	// details or import source details.
	//
	// This member is required.
	Details *ResponseDetails

	// The unique identifier for the job.
	//
	// This member is required.
	Id *string

	// The state of the job.
	//
	// This member is required.
	State State

	// The job type.
	//
	// This member is required.
	Type Type

	// The date and time that the job was last updated, in ISO 8601 format.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Errors for jobs.
	Errors []JobError

	noSmithyDocumentSerde
}

// An error that occurred with the job request.
type JobError struct {

	// The code for the job error.
	//
	// This member is required.
	Code Code

	// The message related to the job error.
	//
	// This member is required.
	Message *string

	// The details about the job error.
	Details *Details

	// The name of the limit that was reached.
	LimitName JobErrorLimitName

	// The value of the exceeded limit.
	LimitValue float64

	// The unique identifier for the resource related to the error.
	ResourceId *string

	// The type of resource related to the error.
	ResourceType JobErrorResourceTypes

	noSmithyDocumentSerde
}

// Information about the origin of the data set.
type OriginDetails struct {

	// The product ID of the origin of the data set.
	//
	// This member is required.
	ProductId *string

	noSmithyDocumentSerde
}

// The Amazon Redshift datashare asset.
type RedshiftDataShareAsset struct {

	// The Amazon Resource Name (ARN) of the datashare asset.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// The source of the Amazon Redshift datashare asset.
type RedshiftDataShareAssetSourceEntry struct {

	// The Amazon Resource Name (ARN) of the datashare asset.
	//
	// This member is required.
	DataShareArn *string

	noSmithyDocumentSerde
}

// The details for the request.
type RequestDetails struct {

	// Details about the export to signed URL request.
	ExportAssetToSignedUrl *ExportAssetToSignedUrlRequestDetails

	// Details about the export to Amazon S3 request.
	ExportAssetsToS3 *ExportAssetsToS3RequestDetails

	// Details about the export to Amazon S3 request.
	ExportRevisionsToS3 *ExportRevisionsToS3RequestDetails

	// Information about the import asset from API Gateway API request.
	ImportAssetFromApiGatewayApi *ImportAssetFromApiGatewayApiRequestDetails

	// Details about the import from signed URL request.
	ImportAssetFromSignedUrl *ImportAssetFromSignedUrlRequestDetails

	// Details from an import from Amazon Redshift datashare request.
	ImportAssetsFromRedshiftDataShares *ImportAssetsFromRedshiftDataSharesRequestDetails

	// Details about the import from Amazon S3 request.
	ImportAssetsFromS3 *ImportAssetsFromS3RequestDetails

	noSmithyDocumentSerde
}

// Details for the response.
type ResponseDetails struct {

	// Details for the export to signed URL response.
	ExportAssetToSignedUrl *ExportAssetToSignedUrlResponseDetails

	// Details for the export to Amazon S3 response.
	ExportAssetsToS3 *ExportAssetsToS3ResponseDetails

	// Details for the export revisions to Amazon S3 response.
	ExportRevisionsToS3 *ExportRevisionsToS3ResponseDetails

	// The response details.
	ImportAssetFromApiGatewayApi *ImportAssetFromApiGatewayApiResponseDetails

	// Details for the import from signed URL response.
	ImportAssetFromSignedUrl *ImportAssetFromSignedUrlResponseDetails

	// Details from an import from Amazon Redshift datashare response.
	ImportAssetsFromRedshiftDataShares *ImportAssetsFromRedshiftDataSharesResponseDetails

	// Details for the import from Amazon S3 response.
	ImportAssetsFromS3 *ImportAssetsFromS3ResponseDetails

	noSmithyDocumentSerde
}

// The destination where the assets in the revision will be exported.
type RevisionDestinationEntry struct {

	// The S3 bucket that is the destination for the assets in the revision.
	//
	// This member is required.
	Bucket *string

	// The unique identifier for the revision.
	//
	// This member is required.
	RevisionId *string

	// A string representing the pattern for generated names of the individual assets
	// in the revision. For more information about key patterns, see Key patterns when
	// exporting revisions
	// (https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
	KeyPattern *string

	noSmithyDocumentSerde
}

// A revision is a container for one or more assets.
type RevisionEntry struct {

	// The ARN for the revision.
	//
	// This member is required.
	Arn *string

	// The date and time that the revision was created, in ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier for the data set associated with this revision.
	//
	// This member is required.
	DataSetId *string

	// The unique identifier for the revision.
	//
	// This member is required.
	Id *string

	// The date and time that the revision was last updated, in ISO 8601 format.
	//
	// This member is required.
	UpdatedAt *time.Time

	// An optional comment about the revision.
	Comment *string

	// To publish a revision to a data set in a product, the revision must first be
	// finalized. Finalizing a revision tells AWS Data Exchange that your changes to
	// the assets in the revision are complete. After it's in this read-only state, you
	// can publish the revision to your products. Finalized revisions can be published
	// through the AWS Data Exchange console or the AWS Marketplace Catalog API, using
	// the StartChangeSet AWS Marketplace Catalog API action. When using the API,
	// revisions are uniquely identified by their ARN.
	Finalized bool

	// A required comment to inform subscribers of the reason their access to the
	// revision was revoked.
	RevocationComment *string

	// A status indicating that subscribers' access to the revision was revoked.
	Revoked bool

	// The date and time that the revision was revoked, in ISO 8601 format.
	RevokedAt *time.Time

	// The revision ID of the owned revision corresponding to the entitled revision
	// being viewed. This parameter is returned when a revision owner is viewing the
	// entitled copy of its owned revision.
	SourceId *string

	noSmithyDocumentSerde
}

// Information about the published revision.
type RevisionPublished struct {

	// The data set ID of the published revision.
	//
	// This member is required.
	DataSetId *string

	noSmithyDocumentSerde
}

// The S3 object that is the asset.
type S3SnapshotAsset struct {

	// The size of the S3 object that is the object.
	//
	// This member is required.
	Size float64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
