//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvmwarecloudsimple

import "time"

// AvailableOperation - Resource provider available operation model
type AvailableOperation struct {
	// The list of operations
	Display *AvailableOperationDisplay `json:"display,omitempty"`

	// Indicating whether the operation is a data action or not
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty"`

	// The origin of operation
	Origin *OperationOrigin `json:"origin,omitempty"`

	// The list of operation properties
	Properties *AvailableOperationDisplayPropertyServiceSpecification `json:"properties,omitempty"`
}

// AvailableOperationDisplay - Resource provider available operation display model
type AvailableOperationDisplay struct {
	// Description of the operation for display purposes
	Description *string `json:"description,omitempty"`

	// Name of the operation for display purposes
	Operation *string `json:"operation,omitempty"`

	// Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`

	// Name of the resource type for display purposes
	Resource *string `json:"resource,omitempty"`
}

// AvailableOperationDisplayPropertyServiceSpecification - Available operation display property service specification model
type AvailableOperationDisplayPropertyServiceSpecification struct {
	// The list of specification's service metrics
	ServiceSpecification *AvailableOperationDisplayPropertyServiceSpecificationMetricsList `json:"serviceSpecification,omitempty"`
}

// AvailableOperationDisplayPropertyServiceSpecificationMetricsItem - Available operation display property service specification
// metrics item
type AvailableOperationDisplayPropertyServiceSpecificationMetricsItem struct {
	// REQUIRED; Metric's aggregation type for e.g. (Average, Total)
	AggregationType *AggregationType `json:"aggregationType,omitempty"`

	// REQUIRED; Metric's description
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// REQUIRED; Human readable metric's name
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Metric's name/id
	Name *string `json:"name,omitempty"`

	// REQUIRED; Metric's unit
	Unit *string `json:"unit,omitempty"`
}

// AvailableOperationDisplayPropertyServiceSpecificationMetricsList - List of available operation display property service
// specification metrics
type AvailableOperationDisplayPropertyServiceSpecificationMetricsList struct {
	// Metric specifications of operation
	MetricSpecifications []*AvailableOperationDisplayPropertyServiceSpecificationMetricsItem `json:"metricSpecifications,omitempty"`
}

// AvailableOperationsListResponse - List of available operations
type AvailableOperationsListResponse struct {
	// Link for next list of available operations
	NextLink *string `json:"nextLink,omitempty"`

	// Returns a list of available operations
	Value []*AvailableOperation `json:"value,omitempty"`
}

// CSRPError - General error model
type CSRPError struct {
	// Error's body
	Error *CSRPErrorBody `json:"error,omitempty"`
}

// CSRPErrorBody - Error properties
type CSRPErrorBody struct {
	// Error's target
	Target *string `json:"target,omitempty"`

	// READ-ONLY; Error's code
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error's details
	Details []*CSRPErrorBody `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Error's message
	Message *string `json:"message,omitempty" azure:"ro"`
}

// CustomizationHostName - Host name model
type CustomizationHostName struct {
	// Hostname
	Name *string `json:"name,omitempty"`

	// Type of host name
	Type *CustomizationHostNameType `json:"type,omitempty"`
}

type CustomizationIPAddress struct {
	// Argument when Custom ip type is selected
	Argument *string `json:"argument,omitempty"`

	// Defined Ip Address when Fixed ip type is selected
	IPAddress *string `json:"ipAddress,omitempty"`

	// Customization Specification ip type
	Type *CustomizationIPAddressType `json:"type,omitempty"`
}

type CustomizationIPSettings struct {
	// The list of gateways
	Gateway []*string `json:"gateway,omitempty"`

	// Ip address customization settings
	IP *CustomizationIPAddress `json:"ip,omitempty"`

	// Adapter subnet mask
	SubnetMask *string `json:"subnetMask,omitempty"`
}

type CustomizationIdentity struct {
	// Windows Text Identity. Prepared data
	Data *string `json:"data,omitempty"`

	// Virtual machine host name settings
	HostName *CustomizationHostName `json:"hostName,omitempty"`

	// Identity type
	Type *CustomizationIdentityType `json:"type,omitempty"`

	// Windows Identity. User data customization
	UserData *CustomizationIdentityUserData `json:"userData,omitempty"`
}

// CustomizationIdentityUserData - Windows Identity. User data customization
type CustomizationIdentityUserData struct {
	// Is password predefined in customization policy
	IsPasswordPredefined *bool `json:"isPasswordPredefined,omitempty"`
}

type CustomizationNicSetting struct {
	// The list of adapters' settings
	Adapter *CustomizationIPSettings `json:"adapter,omitempty"`

	// NIC mac address
	MacAddress *string `json:"macAddress,omitempty"`
}

// CustomizationPoliciesClientGetOptions contains the optional parameters for the CustomizationPoliciesClient.Get method.
type CustomizationPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomizationPoliciesClientListOptions contains the optional parameters for the CustomizationPoliciesClient.List method.
type CustomizationPoliciesClientListOptions struct {
	// The filter to apply on the list operation. only type is allowed here as a filter e.g. $filter=type eq 'xxxx'
	Filter *string
}

// CustomizationPoliciesListResponse - List of customization polices response model
type CustomizationPoliciesListResponse struct {
	// Link for next list of the Customization policy
	NextLink *string `json:"nextLink,omitempty"`

	// List of the customization policies
	Value []*CustomizationPolicy `json:"value,omitempty"`
}

// CustomizationPolicy - The virtual machine customization policy
type CustomizationPolicy struct {
	// Customization policy azure id
	ID *string `json:"id,omitempty"`

	// Azure region
	Location *string `json:"location,omitempty"`

	// Customization Policy properties
	Properties *CustomizationPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Customization policy name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomizationPolicyProperties - The properties of Customization policy
type CustomizationPolicyProperties struct {
	// Policy description
	Description *string `json:"description,omitempty"`

	// The Private cloud id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`

	// Detailed customization policy specification
	Specification *CustomizationSpecification `json:"specification,omitempty"`

	// The type of customization (Linux or Windows)
	Type *CustomizationPolicyPropertiesType `json:"type,omitempty"`

	// Policy version
	Version *string `json:"version,omitempty"`
}

// CustomizationSpecification - The specification for Customization Policy
type CustomizationSpecification struct {
	// Customization Identity. It contains data about user and hostname
	Identity *CustomizationIdentity `json:"identity,omitempty"`

	// Network interface settings
	NicSettings []*CustomizationNicSetting `json:"nicSettings,omitempty"`
}

// DedicatedCloudNode - Dedicated cloud node model
type DedicatedCloudNode struct {
	// REQUIRED; Azure region
	Location *string `json:"location,omitempty"`

	// Dedicated Cloud Nodes properties
	Properties *DedicatedCloudNodeProperties `json:"properties,omitempty"`

	// Dedicated Cloud Nodes SKU
	SKU *SKU `json:"sku,omitempty"`

	// Dedicated Cloud Nodes tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudNodes/{dedicatedCloudNodeName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; {dedicatedCloudNodeName}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DedicatedCloudNodeListResponse - List of dedicated nodes response model
type DedicatedCloudNodeListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the DedicatedCloudNode list
	Value []*DedicatedCloudNode `json:"value,omitempty"`
}

// DedicatedCloudNodeProperties - Properties of dedicated cloud node
type DedicatedCloudNodeProperties struct {
	// REQUIRED; Availability Zone id, e.g. "az1"
	AvailabilityZoneID *string `json:"availabilityZoneId,omitempty"`

	// REQUIRED; count of nodes to create
	NodesCount *int32 `json:"nodesCount,omitempty"`

	// REQUIRED; Placement Group id, e.g. "n1"
	PlacementGroupID *string `json:"placementGroupId,omitempty"`

	// REQUIRED; purchase id
	PurchaseID *string `json:"purchaseId,omitempty"`

	// Dedicated Cloud Nodes SKU's description
	SKUDescription *SKUDescription `json:"skuDescription,omitempty"`

	// READ-ONLY; Availability Zone name, e.g. "Availability Zone 1"
	AvailabilityZoneName *string `json:"availabilityZoneName,omitempty" azure:"ro"`

	// READ-ONLY; VMWare Cloud Rack Name
	CloudRackName *string `json:"cloudRackName,omitempty" azure:"ro"`

	// READ-ONLY; date time the resource was created
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Placement Name, e.g. "Placement Group 1"
	PlacementGroupName *string `json:"placementGroupName,omitempty" azure:"ro"`

	// READ-ONLY; Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty" azure:"ro"`

	// READ-ONLY; Resource Pool Name
	PrivateCloudName *string `json:"privateCloudName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Node status, indicates is private cloud set up on this node or not
	Status *NodeStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; VMWare Cluster Name
	VmwareClusterName *string `json:"vmwareClusterName,omitempty" azure:"ro"`
}

// DedicatedCloudNodesClientBeginCreateOrUpdateOptions contains the optional parameters for the DedicatedCloudNodesClient.BeginCreateOrUpdate
// method.
type DedicatedCloudNodesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DedicatedCloudNodesClientDeleteOptions contains the optional parameters for the DedicatedCloudNodesClient.Delete method.
type DedicatedCloudNodesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DedicatedCloudNodesClientGetOptions contains the optional parameters for the DedicatedCloudNodesClient.Get method.
type DedicatedCloudNodesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DedicatedCloudNodesClientListByResourceGroupOptions contains the optional parameters for the DedicatedCloudNodesClient.ListByResourceGroup
// method.
type DedicatedCloudNodesClientListByResourceGroupOptions struct {
	// The filter to apply on the list operation
	Filter *string
	// to be used by nextLink implementation
	SkipToken *string
	// The maximum number of record sets to return
	Top *int32
}

// DedicatedCloudNodesClientListBySubscriptionOptions contains the optional parameters for the DedicatedCloudNodesClient.ListBySubscription
// method.
type DedicatedCloudNodesClientListBySubscriptionOptions struct {
	// The filter to apply on the list operation
	Filter *string
	// to be used by nextLink implementation
	SkipToken *string
	// The maximum number of record sets to return
	Top *int32
}

// DedicatedCloudNodesClientUpdateOptions contains the optional parameters for the DedicatedCloudNodesClient.Update method.
type DedicatedCloudNodesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DedicatedCloudService - Dedicated cloud service model
type DedicatedCloudService struct {
	// REQUIRED; Azure region
	Location *string `json:"location,omitempty"`

	// The properties of Dedicated Node Service
	Properties *DedicatedCloudServiceProperties `json:"properties,omitempty"`

	// The list of tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudServices/{dedicatedCloudServiceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; {dedicatedCloudServiceName}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DedicatedCloudServiceListResponse - List of dedicated cloud services
type DedicatedCloudServiceListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the DedicatedCloudService list
	Value []*DedicatedCloudService `json:"value,omitempty"`
}

// DedicatedCloudServiceProperties - Properties of dedicated cloud service
type DedicatedCloudServiceProperties struct {
	// REQUIRED; gateway Subnet for the account. It will collect the subnet address and always treat it as /28
	GatewaySubnet *string `json:"gatewaySubnet,omitempty"`

	// READ-ONLY; indicates whether account onboarded or not in a given region
	IsAccountOnboarded *OnboardingStatus `json:"isAccountOnboarded,omitempty" azure:"ro"`

	// READ-ONLY; total nodes purchased
	Nodes *int32 `json:"nodes,omitempty" azure:"ro"`

	// READ-ONLY; link to a service management web portal
	ServiceURL *string `json:"serviceURL,omitempty" azure:"ro"`
}

// DedicatedCloudServicesClientBeginDeleteOptions contains the optional parameters for the DedicatedCloudServicesClient.BeginDelete
// method.
type DedicatedCloudServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DedicatedCloudServicesClientCreateOrUpdateOptions contains the optional parameters for the DedicatedCloudServicesClient.CreateOrUpdate
// method.
type DedicatedCloudServicesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DedicatedCloudServicesClientGetOptions contains the optional parameters for the DedicatedCloudServicesClient.Get method.
type DedicatedCloudServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DedicatedCloudServicesClientListByResourceGroupOptions contains the optional parameters for the DedicatedCloudServicesClient.ListByResourceGroup
// method.
type DedicatedCloudServicesClientListByResourceGroupOptions struct {
	// The filter to apply on the list operation
	Filter *string
	// to be used by nextLink implementation
	SkipToken *string
	// The maximum number of record sets to return
	Top *int32
}

// DedicatedCloudServicesClientListBySubscriptionOptions contains the optional parameters for the DedicatedCloudServicesClient.ListBySubscription
// method.
type DedicatedCloudServicesClientListBySubscriptionOptions struct {
	// The filter to apply on the list operation
	Filter *string
	// to be used by nextLink implementation
	SkipToken *string
	// The maximum number of record sets to return
	Top *int32
}

// DedicatedCloudServicesClientUpdateOptions contains the optional parameters for the DedicatedCloudServicesClient.Update
// method.
type DedicatedCloudServicesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GuestOSCustomization - Guest OS Customization properties
type GuestOSCustomization struct {
	// List of dns servers to use
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Virtual Machine hostname
	HostName *string `json:"hostName,omitempty"`

	// Password for login
	Password *string `json:"password,omitempty"`

	// id of customization policy
	PolicyID *string `json:"policyId,omitempty"`

	// Username for login
	Username *string `json:"username,omitempty"`
}

// GuestOSNICCustomization - Guest OS nic customization
type GuestOSNICCustomization struct {
	// IP address allocation method
	Allocation *GuestOSNICCustomizationAllocation `json:"allocation,omitempty"`

	// List of dns servers to use
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Gateway addresses assigned to nic
	Gateway []*string `json:"gateway,omitempty"`

	// Static ip address for nic
	IPAddress *string `json:"ipAddress,omitempty"`

	// Network mask for nic
	Mask *string `json:"mask,omitempty"`

	// primary WINS server for Windows
	PrimaryWinsServer *string `json:"primaryWinsServer,omitempty"`

	// secondary WINS server for Windows
	SecondaryWinsServer *string `json:"secondaryWinsServer,omitempty"`
}

// OperationError - Operation error model
type OperationError struct {
	// Error's code
	Code *string `json:"code,omitempty"`

	// Error's message
	Message *string `json:"message,omitempty"`
}

// OperationResource - Operation status response
type OperationResource struct {
	// Error Message if operation failed
	Error *OperationError `json:"error,omitempty"`

	// READ-ONLY; End time of the operation
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Operation Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Operation ID
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the operation
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Operation status
	Status *string `json:"status,omitempty" azure:"ro"`
}

// OperationsClientGetOptions contains the optional parameters for the OperationsClient.Get method.
type OperationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PatchPayload - General patch payload modal
type PatchPayload struct {
	// The tags key:value pairs
	Tags map[string]*string `json:"tags,omitempty"`
}

// PrivateCloud - Private cloud model
type PrivateCloud struct {
	// Azure Id, e.g. "/subscriptions/4da99247-a172-4ed6-8ae9-ebed2d12f839/providers/Microsoft.VMwareCloudSimple/privateClouds/cloud123"
	ID *string `json:"id,omitempty"`

	// Location where private cloud created, e.g "westus"
	Location *string `json:"location,omitempty"`

	// Private cloud name
	Name *string `json:"name,omitempty"`

	// Private cloud properties
	Properties *PrivateCloudProperties `json:"properties,omitempty"`

	// Azure Resource type
	Type *string `json:"type,omitempty"`
}

// PrivateCloudList - List of private clouds
type PrivateCloudList struct {
	// Link for next list of Private Clouds
	NextLink *string `json:"nextLink,omitempty"`

	// the list of private clouds
	Value []*PrivateCloud `json:"value,omitempty"`
}

// PrivateCloudProperties - Properties of private
type PrivateCloudProperties struct {
	// Availability Zone id, e.g. "az1"
	AvailabilityZoneID *string `json:"availabilityZoneId,omitempty"`

	// Availability Zone name, e.g. "Availability Zone 1"
	AvailabilityZoneName *string `json:"availabilityZoneName,omitempty"`

	// Number of clusters
	ClustersNumber *int32 `json:"clustersNumber,omitempty"`

	// User's emails who created cloud
	CreatedBy *string `json:"createdBy,omitempty"`

	// When private cloud was created
	CreatedOn *time.Time `json:"createdOn,omitempty"`

	// Array of DNS servers
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Expiration date of PC
	Expires *string `json:"expires,omitempty"`

	// Nsx Type, e.g. "Advanced"
	NsxType *string `json:"nsxType,omitempty"`

	// Placement Group id, e.g. "n1"
	PlacementGroupID *string `json:"placementGroupId,omitempty"`

	// Placement Group name
	PlacementGroupName *string `json:"placementGroupName,omitempty"`

	// Id of a private cloud
	PrivateCloudID *string `json:"privateCloudId,omitempty"`

	// The list of Resource Pools
	ResourcePools []*ResourcePool `json:"resourcePools,omitempty"`

	// Private Cloud state, e.g. "operational"
	State *string `json:"state,omitempty"`

	// Number of cores
	TotalCPUCores *int32 `json:"totalCpuCores,omitempty"`

	// Number of nodes
	TotalNodes *int32 `json:"totalNodes,omitempty"`

	// Memory size
	TotalRAM *int32 `json:"totalRam,omitempty"`

	// Disk space in TB
	TotalStorage *float32 `json:"totalStorage,omitempty"`

	// Virtualization type e.g. "vSphere"
	Type *string `json:"type,omitempty"`

	// e.g. "6.5u2"
	VSphereVersion *string `json:"vSphereVersion,omitempty"`

	// FQDN for vcenter access
	VcenterFqdn *string `json:"vcenterFqdn,omitempty"`

	// Vcenter ip address
	VcenterRefid *string `json:"vcenterRefid,omitempty"`

	// The list of Virtual Machine Templates
	VirtualMachineTemplates []*VirtualMachineTemplate `json:"virtualMachineTemplates,omitempty"`

	// The list of Virtual Networks
	VirtualNetworks []*VirtualNetwork `json:"virtualNetworks,omitempty"`

	// Is Vrops enabled/disabled
	VrOpsEnabled *bool `json:"vrOpsEnabled,omitempty"`
}

// PrivateCloudsClientGetOptions contains the optional parameters for the PrivateCloudsClient.Get method.
type PrivateCloudsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateCloudsClientListOptions contains the optional parameters for the PrivateCloudsClient.List method.
type PrivateCloudsClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourcePool - Resource pool model
type ResourcePool struct {
	// REQUIRED; resource pool id (privateCloudId:vsphereId)
	ID *string `json:"id,omitempty"`

	// Resource pool properties
	Properties *ResourcePoolProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure region
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; {ResourcePoolName}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty" azure:"ro"`

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourcePoolProperties - Properties of resource pool
type ResourcePoolProperties struct {
	// READ-ONLY; Hierarchical resource pool name
	FullName *string `json:"fullName,omitempty" azure:"ro"`
}

// ResourcePoolsClientGetOptions contains the optional parameters for the ResourcePoolsClient.Get method.
type ResourcePoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourcePoolsClientListOptions contains the optional parameters for the ResourcePoolsClient.List method.
type ResourcePoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourcePoolsListResponse - List of resource pools response model
type ResourcePoolsListResponse struct {
	// Link for next list of ResourcePoolsList
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the Resource pools list
	Value []*ResourcePool `json:"value,omitempty"`
}

// SKU - The purchase SKU for CloudSimple paid resources
type SKU struct {
	// REQUIRED; The name of the SKU for VMWare CloudSimple Node
	Name *string `json:"name,omitempty"`

	// The capacity of the SKU
	Capacity *string `json:"capacity,omitempty"`

	// dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200
	// 2400MHz DDR4 ECC Registered DIMM, …
	Description *string `json:"description,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here
	Family *string `json:"family,omitempty"`

	// The tier of the SKU
	Tier *string `json:"tier,omitempty"`
}

// SKUAvailability - SKU availability model
type SKUAvailability struct {
	// REQUIRED; indicates how many resources of a given SKU is available in a AZ->PG
	Limit *int32 `json:"limit,omitempty"`

	// CloudSimple Availability Zone id
	DedicatedAvailabilityZoneID *string `json:"dedicatedAvailabilityZoneId,omitempty"`

	// CloudSimple Availability Zone Name
	DedicatedAvailabilityZoneName *string `json:"dedicatedAvailabilityZoneName,omitempty"`

	// CloudSimple Placement Group Id
	DedicatedPlacementGroupID *string `json:"dedicatedPlacementGroupId,omitempty"`

	// CloudSimple Placement Group name
	DedicatedPlacementGroupName *string `json:"dedicatedPlacementGroupName,omitempty"`

	// resource type e.g. DedicatedCloudNodes
	ResourceType *string `json:"resourceType,omitempty"`

	// sku id
	SKUID *string `json:"skuId,omitempty"`

	// sku name
	SKUName *string `json:"skuName,omitempty"`
}

// SKUAvailabilityListResponse - List of SKU availabilities
type SKUAvailabilityListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the DedicatedPlacementGroupSkuAvailability list
	Value []*SKUAvailability `json:"value,omitempty"`
}

// SKUDescription - The purchase SKU for CloudSimple paid resources
type SKUDescription struct {
	// REQUIRED; SKU's id
	ID *string `json:"id,omitempty"`

	// REQUIRED; SKU's name
	Name *string `json:"name,omitempty"`
}

// SKUsAvailabilityClientListOptions contains the optional parameters for the SKUsAvailabilityClient.List method.
type SKUsAvailabilityClientListOptions struct {
	// sku id, if no sku is passed availability for all skus will be returned
	SKUID *string
}

// Usage model
type Usage struct {
	// REQUIRED; The current usage value
	CurrentValue *int32 `json:"currentValue,omitempty"`

	// REQUIRED; limit of a given sku in a region for a subscription. The maximum permitted value for the usage quota. If there
	// is no limit, this value will be -1
	Limit *int32 `json:"limit,omitempty"`

	// Usage name value and localized name
	Name *UsageName `json:"name,omitempty"`

	// The usages' unit
	Unit *UsageCount `json:"unit,omitempty"`
}

// UsageListResponse - List of usages
type UsageListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; The list of usages
	Value []*Usage `json:"value,omitempty" azure:"ro"`
}

// UsageName - User name model
type UsageName struct {
	// e.g. "Virtual Machines"
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// resource type or resource type sku name, e.g. virtualMachines
	Value *string `json:"value,omitempty"`
}

// UsagesClientListOptions contains the optional parameters for the UsagesClient.List method.
type UsagesClientListOptions struct {
	// The filter to apply on the list operation. only name.value is allowed here as a filter e.g. $filter=name.value eq 'xxxx'
	Filter *string
}

// VirtualDisk - Virtual disk model
type VirtualDisk struct {
	// REQUIRED; Disk's Controller id
	ControllerID *string `json:"controllerId,omitempty"`

	// REQUIRED; Disk's independence mode type
	IndependenceMode *DiskIndependenceMode `json:"independenceMode,omitempty"`

	// REQUIRED; Disk's total size
	TotalSize *int32 `json:"totalSize,omitempty"`

	// Disk's id
	VirtualDiskID *string `json:"virtualDiskId,omitempty"`

	// READ-ONLY; Disk's display name
	VirtualDiskName *string `json:"virtualDiskName,omitempty" azure:"ro"`
}

// VirtualDiskController - Virtual disk controller model
type VirtualDiskController struct {
	// READ-ONLY; Controller's id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The display name of Controller
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; dik controller subtype (VMWAREPARAVIRTUAL, BUSPARALLEL, LSIPARALLEL, LSISAS)
	SubType *string `json:"subType,omitempty" azure:"ro"`

	// READ-ONLY; disk controller type (SCSI)
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachine - Virtual machine model
type VirtualMachine struct {
	// REQUIRED; Azure region
	Location *string `json:"location,omitempty"`

	// Virtual machine properties
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// The list of tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/virtualMachines/{virtualMachineName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; {virtualMachineName}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineListResponse - List of virtual machines
type VirtualMachineListResponse struct {
	// Link for next list of VirtualMachines
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the VirtualMachine list
	Value []*VirtualMachine `json:"value,omitempty"`
}

// VirtualMachineProperties - Properties of virtual machine
type VirtualMachineProperties struct {
	// REQUIRED; The amount of memory
	AmountOfRAM *int32 `json:"amountOfRam,omitempty"`

	// REQUIRED; The number of CPU cores
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`

	// REQUIRED; Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`

	// Virtual machine properties
	Customization *GuestOSCustomization `json:"customization,omitempty"`

	// The list of Virtual Disks
	Disks []*VirtualDisk `json:"disks,omitempty"`

	// Expose Guest OS or not
	ExposeToGuestVM *bool `json:"exposeToGuestVM,omitempty"`

	// The list of Virtual NICs
	Nics []*VirtualNic `json:"nics,omitempty"`

	// Password for login. Deprecated - use customization property
	Password *string `json:"password,omitempty"`

	// Virtual Machines Resource Pool
	ResourcePool *ResourcePool `json:"resourcePool,omitempty"`

	// Virtual Machine Template Id
	TemplateID *string `json:"templateId,omitempty"`

	// Username for login. Deprecated - use customization property
	Username *string `json:"username,omitempty"`

	// The list of Virtual VSphere Networks
	VSphereNetworks []*string `json:"vSphereNetworks,omitempty"`

	// READ-ONLY; The list of Virtual Disks' Controllers
	Controllers []*VirtualDiskController `json:"controllers,omitempty" azure:"ro"`

	// READ-ONLY; The DNS name of Virtual Machine in VCenter
	Dnsname *string `json:"dnsname,omitempty" azure:"ro"`

	// READ-ONLY; The path to virtual machine folder in VCenter
	Folder *string `json:"folder,omitempty" azure:"ro"`

	// READ-ONLY; The name of Guest OS
	GuestOS *string `json:"guestOS,omitempty" azure:"ro"`

	// READ-ONLY; The Guest OS type
	GuestOSType *GuestOSType `json:"guestOSType,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The public ip of Virtual Machine
	PublicIP *string `json:"publicIP,omitempty" azure:"ro"`

	// READ-ONLY; The status of Virtual machine
	Status *VirtualMachineStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The internal id of Virtual Machine in VCenter
	VMID *string `json:"vmId,omitempty" azure:"ro"`

	// READ-ONLY; VMware tools version
	Vmwaretools *string `json:"vmwaretools,omitempty" azure:"ro"`
}

// VirtualMachineStopMode - List of virtual machine stop modes
type VirtualMachineStopMode struct {
	// mode indicates a type of stop operation - reboot, suspend, shutdown or power-off
	Mode *StopMode `json:"mode,omitempty"`
}

// VirtualMachineTemplate - Virtual machine template model
type VirtualMachineTemplate struct {
	// Azure region
	Location *string `json:"location,omitempty"`

	// The Virtual Machine Template properties
	Properties *VirtualMachineTemplateProperties `json:"properties,omitempty"`

	// READ-ONLY; virtual machine template id (privateCloudId:vsphereId)
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; {virtualMachineTemplateName}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineTemplateListResponse - List of virtual machine templates
type VirtualMachineTemplateListResponse struct {
	// Link for next list of VirtualMachineTemplate
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the VM template list
	Value []*VirtualMachineTemplate `json:"value,omitempty"`
}

// VirtualMachineTemplateProperties - Properties of virtual machine template
type VirtualMachineTemplateProperties struct {
	// REQUIRED; The Private Cloud Id
	PrivateCloudID *string `json:"privateCloudId,omitempty"`

	// The amount of memory
	AmountOfRAM *int32 `json:"amountOfRam,omitempty"`

	// The list of Virtual Disk Controllers
	Controllers []*VirtualDiskController `json:"controllers,omitempty"`

	// The description of Virtual Machine Template
	Description *string `json:"description,omitempty"`

	// The list of Virtual Disks
	Disks []*VirtualDisk `json:"disks,omitempty"`

	// Expose Guest OS or not
	ExposeToGuestVM *bool `json:"exposeToGuestVM,omitempty"`

	// The list of Virtual NICs
	Nics []*VirtualNic `json:"nics,omitempty"`

	// The number of CPU cores
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`

	// path to folder
	Path *string `json:"path,omitempty"`

	// The list of VSphere networks
	VSphereNetworks []*string `json:"vSphereNetworks,omitempty"`

	// The tags from VSphere
	VSphereTags []*string `json:"vSphereTags,omitempty"`

	// READ-ONLY; The Guest OS
	GuestOS *string `json:"guestOS,omitempty" azure:"ro"`

	// READ-ONLY; The Guest OS types
	GuestOSType *string `json:"guestOSType,omitempty" azure:"ro"`

	// READ-ONLY; The VMware tools version
	Vmwaretools *string `json:"vmwaretools,omitempty" azure:"ro"`
}

// VirtualMachineTemplatesClientGetOptions contains the optional parameters for the VirtualMachineTemplatesClient.Get method.
type VirtualMachineTemplatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesClientListOptions contains the optional parameters for the VirtualMachineTemplatesClient.List method.
type VirtualMachineTemplatesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginCreateOrUpdate
// method.
type VirtualMachinesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeleteOptions contains the optional parameters for the VirtualMachinesClient.BeginDelete method.
type VirtualMachinesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStartOptions contains the optional parameters for the VirtualMachinesClient.BeginStart method.
type VirtualMachinesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStopOptions contains the optional parameters for the VirtualMachinesClient.BeginStop method.
type VirtualMachinesClientBeginStopOptions struct {
	// body stop mode parameter (reboot, shutdown, etc…)
	M *VirtualMachineStopMode
	// query stop mode parameter (reboot, shutdown, etc…)
	Mode *StopMode
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginUpdate method.
type VirtualMachinesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListByResourceGroupOptions contains the optional parameters for the VirtualMachinesClient.ListByResourceGroup
// method.
type VirtualMachinesClientListByResourceGroupOptions struct {
	// The filter to apply on the list operation
	Filter *string
	// to be used by nextLink implementation
	SkipToken *string
	// The maximum number of record sets to return
	Top *int32
}

// VirtualMachinesClientListBySubscriptionOptions contains the optional parameters for the VirtualMachinesClient.ListBySubscription
// method.
type VirtualMachinesClientListBySubscriptionOptions struct {
	// The filter to apply on the list operation
	Filter *string
	// to be used by nextLink implementation
	SkipToken *string
	// The maximum number of record sets to return
	Top *int32
}

// VirtualNetwork - Virtual network model
type VirtualNetwork struct {
	// REQUIRED; virtual network id (privateCloudId:vsphereId)
	ID *string `json:"id,omitempty"`

	// Virtual Network properties
	Properties *VirtualNetworkProperties `json:"properties,omitempty"`

	// READ-ONLY; can be used in vm creation/deletion
	Assignable *bool `json:"assignable,omitempty" azure:"ro"`

	// READ-ONLY; Azure region
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; {VirtualNetworkName}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkListResponse - List of virtual networks
type VirtualNetworkListResponse struct {
	// Link for next list of VirtualNetwork
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the VirtualNetwork list
	Value []*VirtualNetwork `json:"value,omitempty"`
}

// VirtualNetworkProperties - Properties of virtual network
type VirtualNetworkProperties struct {
	// READ-ONLY; The Private Cloud id
	PrivateCloudID *string `json:"privateCloudId,omitempty" azure:"ro"`
}

// VirtualNetworksClientGetOptions contains the optional parameters for the VirtualNetworksClient.Get method.
type VirtualNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListOptions contains the optional parameters for the VirtualNetworksClient.List method.
type VirtualNetworksClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNic - Virtual NIC model
type VirtualNic struct {
	// REQUIRED; Virtual Network
	Network *VirtualNetwork `json:"network,omitempty"`

	// REQUIRED; NIC type
	NicType *NICType `json:"nicType,omitempty"`

	// guest OS customization for nic
	Customization *GuestOSNICCustomization `json:"customization,omitempty"`

	// NIC ip address
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// NIC MAC address
	MacAddress *string `json:"macAddress,omitempty"`

	// Is NIC powered on/off on boot
	PowerOnBoot *bool `json:"powerOnBoot,omitempty"`

	// NIC id
	VirtualNicID *string `json:"virtualNicId,omitempty"`

	// READ-ONLY; NIC name
	VirtualNicName *string `json:"virtualNicName,omitempty" azure:"ro"`
}
