//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessPolicy.
func (a AccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiryTime", a.ExpiryTime)
	populate(objectMap, "permission", a.Permission)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicy.
func (a *AccessPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &a.ExpiryTime)
			delete(rawMsg, key)
		case "permission":
			err = unpopulate(val, "Permission", &a.Permission)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", a.ExtendedLocation)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Account.
func (a *Account) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &a.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountCheckNameAvailabilityParameters.
func (a AccountCheckNameAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", a.Name)
	objectMap["type"] = "Microsoft.Storage/storageAccounts"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCheckNameAvailabilityParameters.
func (a *AccountCheckNameAvailabilityParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountCreateParameters.
func (a AccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", a.ExtendedLocation)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCreateParameters.
func (a *AccountCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &a.ExtendedLocation)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountImmutabilityPolicyProperties.
func (a AccountImmutabilityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowProtectedAppendWrites", a.AllowProtectedAppendWrites)
	populate(objectMap, "immutabilityPeriodSinceCreationInDays", a.ImmutabilityPeriodSinceCreationInDays)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountImmutabilityPolicyProperties.
func (a *AccountImmutabilityPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowProtectedAppendWrites":
			err = unpopulate(val, "AllowProtectedAppendWrites", &a.AllowProtectedAppendWrites)
			delete(rawMsg, key)
		case "immutabilityPeriodSinceCreationInDays":
			err = unpopulate(val, "ImmutabilityPeriodSinceCreationInDays", &a.ImmutabilityPeriodSinceCreationInDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountInternetEndpoints.
func (a AccountInternetEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blob", a.Blob)
	populate(objectMap, "dfs", a.Dfs)
	populate(objectMap, "file", a.File)
	populate(objectMap, "web", a.Web)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountInternetEndpoints.
func (a *AccountInternetEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blob":
			err = unpopulate(val, "Blob", &a.Blob)
			delete(rawMsg, key)
		case "dfs":
			err = unpopulate(val, "Dfs", &a.Dfs)
			delete(rawMsg, key)
		case "file":
			err = unpopulate(val, "File", &a.File)
			delete(rawMsg, key)
		case "web":
			err = unpopulate(val, "Web", &a.Web)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountKey.
func (a AccountKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "keyName", a.KeyName)
	populate(objectMap, "permissions", a.Permissions)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountKey.
func (a *AccountKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &a.KeyName)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &a.Permissions)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountListKeysResult.
func (a AccountListKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keys", a.Keys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountListKeysResult.
func (a *AccountListKeysResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keys":
			err = unpopulate(val, "Keys", &a.Keys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountListResult.
func (a AccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountListResult.
func (a *AccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountMicrosoftEndpoints.
func (a AccountMicrosoftEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blob", a.Blob)
	populate(objectMap, "dfs", a.Dfs)
	populate(objectMap, "file", a.File)
	populate(objectMap, "queue", a.Queue)
	populate(objectMap, "table", a.Table)
	populate(objectMap, "web", a.Web)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountMicrosoftEndpoints.
func (a *AccountMicrosoftEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blob":
			err = unpopulate(val, "Blob", &a.Blob)
			delete(rawMsg, key)
		case "dfs":
			err = unpopulate(val, "Dfs", &a.Dfs)
			delete(rawMsg, key)
		case "file":
			err = unpopulate(val, "File", &a.File)
			delete(rawMsg, key)
		case "queue":
			err = unpopulate(val, "Queue", &a.Queue)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "web":
			err = unpopulate(val, "Web", &a.Web)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountProperties.
func (a AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessTier", a.AccessTier)
	populate(objectMap, "allowBlobPublicAccess", a.AllowBlobPublicAccess)
	populate(objectMap, "allowCrossTenantReplication", a.AllowCrossTenantReplication)
	populate(objectMap, "allowSharedKeyAccess", a.AllowSharedKeyAccess)
	populate(objectMap, "allowedCopyScope", a.AllowedCopyScope)
	populate(objectMap, "azureFilesIdentityBasedAuthentication", a.AzureFilesIdentityBasedAuthentication)
	populate(objectMap, "blobRestoreStatus", a.BlobRestoreStatus)
	populateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "customDomain", a.CustomDomain)
	populate(objectMap, "dnsEndpointType", a.DNSEndpointType)
	populate(objectMap, "defaultToOAuthAuthentication", a.DefaultToOAuthAuthentication)
	populate(objectMap, "supportsHttpsTrafficOnly", a.EnableHTTPSTrafficOnly)
	populate(objectMap, "isNfsV3Enabled", a.EnableNfsV3)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "failoverInProgress", a.FailoverInProgress)
	populate(objectMap, "geoReplicationStats", a.GeoReplicationStats)
	populate(objectMap, "immutableStorageWithVersioning", a.ImmutableStorageWithVersioning)
	populate(objectMap, "isHnsEnabled", a.IsHnsEnabled)
	populate(objectMap, "isLocalUserEnabled", a.IsLocalUserEnabled)
	populate(objectMap, "isSftpEnabled", a.IsSftpEnabled)
	populate(objectMap, "keyCreationTime", a.KeyCreationTime)
	populate(objectMap, "keyPolicy", a.KeyPolicy)
	populate(objectMap, "largeFileSharesState", a.LargeFileSharesState)
	populateTimeRFC3339(objectMap, "lastGeoFailoverTime", a.LastGeoFailoverTime)
	populate(objectMap, "minimumTlsVersion", a.MinimumTLSVersion)
	populate(objectMap, "networkAcls", a.NetworkRuleSet)
	populate(objectMap, "primaryEndpoints", a.PrimaryEndpoints)
	populate(objectMap, "primaryLocation", a.PrimaryLocation)
	populate(objectMap, "privateEndpointConnections", a.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", a.PublicNetworkAccess)
	populate(objectMap, "routingPreference", a.RoutingPreference)
	populate(objectMap, "sasPolicy", a.SasPolicy)
	populate(objectMap, "secondaryEndpoints", a.SecondaryEndpoints)
	populate(objectMap, "secondaryLocation", a.SecondaryLocation)
	populate(objectMap, "statusOfPrimary", a.StatusOfPrimary)
	populate(objectMap, "statusOfSecondary", a.StatusOfSecondary)
	populate(objectMap, "storageAccountSkuConversionStatus", a.StorageAccountSKUConversionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountProperties.
func (a *AccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessTier":
			err = unpopulate(val, "AccessTier", &a.AccessTier)
			delete(rawMsg, key)
		case "allowBlobPublicAccess":
			err = unpopulate(val, "AllowBlobPublicAccess", &a.AllowBlobPublicAccess)
			delete(rawMsg, key)
		case "allowCrossTenantReplication":
			err = unpopulate(val, "AllowCrossTenantReplication", &a.AllowCrossTenantReplication)
			delete(rawMsg, key)
		case "allowSharedKeyAccess":
			err = unpopulate(val, "AllowSharedKeyAccess", &a.AllowSharedKeyAccess)
			delete(rawMsg, key)
		case "allowedCopyScope":
			err = unpopulate(val, "AllowedCopyScope", &a.AllowedCopyScope)
			delete(rawMsg, key)
		case "azureFilesIdentityBasedAuthentication":
			err = unpopulate(val, "AzureFilesIdentityBasedAuthentication", &a.AzureFilesIdentityBasedAuthentication)
			delete(rawMsg, key)
		case "blobRestoreStatus":
			err = unpopulate(val, "BlobRestoreStatus", &a.BlobRestoreStatus)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "customDomain":
			err = unpopulate(val, "CustomDomain", &a.CustomDomain)
			delete(rawMsg, key)
		case "dnsEndpointType":
			err = unpopulate(val, "DNSEndpointType", &a.DNSEndpointType)
			delete(rawMsg, key)
		case "defaultToOAuthAuthentication":
			err = unpopulate(val, "DefaultToOAuthAuthentication", &a.DefaultToOAuthAuthentication)
			delete(rawMsg, key)
		case "supportsHttpsTrafficOnly":
			err = unpopulate(val, "EnableHTTPSTrafficOnly", &a.EnableHTTPSTrafficOnly)
			delete(rawMsg, key)
		case "isNfsV3Enabled":
			err = unpopulate(val, "EnableNfsV3", &a.EnableNfsV3)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "failoverInProgress":
			err = unpopulate(val, "FailoverInProgress", &a.FailoverInProgress)
			delete(rawMsg, key)
		case "geoReplicationStats":
			err = unpopulate(val, "GeoReplicationStats", &a.GeoReplicationStats)
			delete(rawMsg, key)
		case "immutableStorageWithVersioning":
			err = unpopulate(val, "ImmutableStorageWithVersioning", &a.ImmutableStorageWithVersioning)
			delete(rawMsg, key)
		case "isHnsEnabled":
			err = unpopulate(val, "IsHnsEnabled", &a.IsHnsEnabled)
			delete(rawMsg, key)
		case "isLocalUserEnabled":
			err = unpopulate(val, "IsLocalUserEnabled", &a.IsLocalUserEnabled)
			delete(rawMsg, key)
		case "isSftpEnabled":
			err = unpopulate(val, "IsSftpEnabled", &a.IsSftpEnabled)
			delete(rawMsg, key)
		case "keyCreationTime":
			err = unpopulate(val, "KeyCreationTime", &a.KeyCreationTime)
			delete(rawMsg, key)
		case "keyPolicy":
			err = unpopulate(val, "KeyPolicy", &a.KeyPolicy)
			delete(rawMsg, key)
		case "largeFileSharesState":
			err = unpopulate(val, "LargeFileSharesState", &a.LargeFileSharesState)
			delete(rawMsg, key)
		case "lastGeoFailoverTime":
			err = unpopulateTimeRFC3339(val, "LastGeoFailoverTime", &a.LastGeoFailoverTime)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &a.MinimumTLSVersion)
			delete(rawMsg, key)
		case "networkAcls":
			err = unpopulate(val, "NetworkRuleSet", &a.NetworkRuleSet)
			delete(rawMsg, key)
		case "primaryEndpoints":
			err = unpopulate(val, "PrimaryEndpoints", &a.PrimaryEndpoints)
			delete(rawMsg, key)
		case "primaryLocation":
			err = unpopulate(val, "PrimaryLocation", &a.PrimaryLocation)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &a.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &a.PublicNetworkAccess)
			delete(rawMsg, key)
		case "routingPreference":
			err = unpopulate(val, "RoutingPreference", &a.RoutingPreference)
			delete(rawMsg, key)
		case "sasPolicy":
			err = unpopulate(val, "SasPolicy", &a.SasPolicy)
			delete(rawMsg, key)
		case "secondaryEndpoints":
			err = unpopulate(val, "SecondaryEndpoints", &a.SecondaryEndpoints)
			delete(rawMsg, key)
		case "secondaryLocation":
			err = unpopulate(val, "SecondaryLocation", &a.SecondaryLocation)
			delete(rawMsg, key)
		case "statusOfPrimary":
			err = unpopulate(val, "StatusOfPrimary", &a.StatusOfPrimary)
			delete(rawMsg, key)
		case "statusOfSecondary":
			err = unpopulate(val, "StatusOfSecondary", &a.StatusOfSecondary)
			delete(rawMsg, key)
		case "storageAccountSkuConversionStatus":
			err = unpopulate(val, "StorageAccountSKUConversionStatus", &a.StorageAccountSKUConversionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountPropertiesCreateParameters.
func (a AccountPropertiesCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessTier", a.AccessTier)
	populate(objectMap, "allowBlobPublicAccess", a.AllowBlobPublicAccess)
	populate(objectMap, "allowCrossTenantReplication", a.AllowCrossTenantReplication)
	populate(objectMap, "allowSharedKeyAccess", a.AllowSharedKeyAccess)
	populate(objectMap, "allowedCopyScope", a.AllowedCopyScope)
	populate(objectMap, "azureFilesIdentityBasedAuthentication", a.AzureFilesIdentityBasedAuthentication)
	populate(objectMap, "customDomain", a.CustomDomain)
	populate(objectMap, "dnsEndpointType", a.DNSEndpointType)
	populate(objectMap, "defaultToOAuthAuthentication", a.DefaultToOAuthAuthentication)
	populate(objectMap, "supportsHttpsTrafficOnly", a.EnableHTTPSTrafficOnly)
	populate(objectMap, "isNfsV3Enabled", a.EnableNfsV3)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "immutableStorageWithVersioning", a.ImmutableStorageWithVersioning)
	populate(objectMap, "isHnsEnabled", a.IsHnsEnabled)
	populate(objectMap, "isLocalUserEnabled", a.IsLocalUserEnabled)
	populate(objectMap, "isSftpEnabled", a.IsSftpEnabled)
	populate(objectMap, "keyPolicy", a.KeyPolicy)
	populate(objectMap, "largeFileSharesState", a.LargeFileSharesState)
	populate(objectMap, "minimumTlsVersion", a.MinimumTLSVersion)
	populate(objectMap, "networkAcls", a.NetworkRuleSet)
	populate(objectMap, "publicNetworkAccess", a.PublicNetworkAccess)
	populate(objectMap, "routingPreference", a.RoutingPreference)
	populate(objectMap, "sasPolicy", a.SasPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountPropertiesCreateParameters.
func (a *AccountPropertiesCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessTier":
			err = unpopulate(val, "AccessTier", &a.AccessTier)
			delete(rawMsg, key)
		case "allowBlobPublicAccess":
			err = unpopulate(val, "AllowBlobPublicAccess", &a.AllowBlobPublicAccess)
			delete(rawMsg, key)
		case "allowCrossTenantReplication":
			err = unpopulate(val, "AllowCrossTenantReplication", &a.AllowCrossTenantReplication)
			delete(rawMsg, key)
		case "allowSharedKeyAccess":
			err = unpopulate(val, "AllowSharedKeyAccess", &a.AllowSharedKeyAccess)
			delete(rawMsg, key)
		case "allowedCopyScope":
			err = unpopulate(val, "AllowedCopyScope", &a.AllowedCopyScope)
			delete(rawMsg, key)
		case "azureFilesIdentityBasedAuthentication":
			err = unpopulate(val, "AzureFilesIdentityBasedAuthentication", &a.AzureFilesIdentityBasedAuthentication)
			delete(rawMsg, key)
		case "customDomain":
			err = unpopulate(val, "CustomDomain", &a.CustomDomain)
			delete(rawMsg, key)
		case "dnsEndpointType":
			err = unpopulate(val, "DNSEndpointType", &a.DNSEndpointType)
			delete(rawMsg, key)
		case "defaultToOAuthAuthentication":
			err = unpopulate(val, "DefaultToOAuthAuthentication", &a.DefaultToOAuthAuthentication)
			delete(rawMsg, key)
		case "supportsHttpsTrafficOnly":
			err = unpopulate(val, "EnableHTTPSTrafficOnly", &a.EnableHTTPSTrafficOnly)
			delete(rawMsg, key)
		case "isNfsV3Enabled":
			err = unpopulate(val, "EnableNfsV3", &a.EnableNfsV3)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "immutableStorageWithVersioning":
			err = unpopulate(val, "ImmutableStorageWithVersioning", &a.ImmutableStorageWithVersioning)
			delete(rawMsg, key)
		case "isHnsEnabled":
			err = unpopulate(val, "IsHnsEnabled", &a.IsHnsEnabled)
			delete(rawMsg, key)
		case "isLocalUserEnabled":
			err = unpopulate(val, "IsLocalUserEnabled", &a.IsLocalUserEnabled)
			delete(rawMsg, key)
		case "isSftpEnabled":
			err = unpopulate(val, "IsSftpEnabled", &a.IsSftpEnabled)
			delete(rawMsg, key)
		case "keyPolicy":
			err = unpopulate(val, "KeyPolicy", &a.KeyPolicy)
			delete(rawMsg, key)
		case "largeFileSharesState":
			err = unpopulate(val, "LargeFileSharesState", &a.LargeFileSharesState)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &a.MinimumTLSVersion)
			delete(rawMsg, key)
		case "networkAcls":
			err = unpopulate(val, "NetworkRuleSet", &a.NetworkRuleSet)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &a.PublicNetworkAccess)
			delete(rawMsg, key)
		case "routingPreference":
			err = unpopulate(val, "RoutingPreference", &a.RoutingPreference)
			delete(rawMsg, key)
		case "sasPolicy":
			err = unpopulate(val, "SasPolicy", &a.SasPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountPropertiesUpdateParameters.
func (a AccountPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessTier", a.AccessTier)
	populate(objectMap, "allowBlobPublicAccess", a.AllowBlobPublicAccess)
	populate(objectMap, "allowCrossTenantReplication", a.AllowCrossTenantReplication)
	populate(objectMap, "allowSharedKeyAccess", a.AllowSharedKeyAccess)
	populate(objectMap, "allowedCopyScope", a.AllowedCopyScope)
	populate(objectMap, "azureFilesIdentityBasedAuthentication", a.AzureFilesIdentityBasedAuthentication)
	populate(objectMap, "customDomain", a.CustomDomain)
	populate(objectMap, "dnsEndpointType", a.DNSEndpointType)
	populate(objectMap, "defaultToOAuthAuthentication", a.DefaultToOAuthAuthentication)
	populate(objectMap, "supportsHttpsTrafficOnly", a.EnableHTTPSTrafficOnly)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "immutableStorageWithVersioning", a.ImmutableStorageWithVersioning)
	populate(objectMap, "isLocalUserEnabled", a.IsLocalUserEnabled)
	populate(objectMap, "isSftpEnabled", a.IsSftpEnabled)
	populate(objectMap, "keyPolicy", a.KeyPolicy)
	populate(objectMap, "largeFileSharesState", a.LargeFileSharesState)
	populate(objectMap, "minimumTlsVersion", a.MinimumTLSVersion)
	populate(objectMap, "networkAcls", a.NetworkRuleSet)
	populate(objectMap, "publicNetworkAccess", a.PublicNetworkAccess)
	populate(objectMap, "routingPreference", a.RoutingPreference)
	populate(objectMap, "sasPolicy", a.SasPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountPropertiesUpdateParameters.
func (a *AccountPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessTier":
			err = unpopulate(val, "AccessTier", &a.AccessTier)
			delete(rawMsg, key)
		case "allowBlobPublicAccess":
			err = unpopulate(val, "AllowBlobPublicAccess", &a.AllowBlobPublicAccess)
			delete(rawMsg, key)
		case "allowCrossTenantReplication":
			err = unpopulate(val, "AllowCrossTenantReplication", &a.AllowCrossTenantReplication)
			delete(rawMsg, key)
		case "allowSharedKeyAccess":
			err = unpopulate(val, "AllowSharedKeyAccess", &a.AllowSharedKeyAccess)
			delete(rawMsg, key)
		case "allowedCopyScope":
			err = unpopulate(val, "AllowedCopyScope", &a.AllowedCopyScope)
			delete(rawMsg, key)
		case "azureFilesIdentityBasedAuthentication":
			err = unpopulate(val, "AzureFilesIdentityBasedAuthentication", &a.AzureFilesIdentityBasedAuthentication)
			delete(rawMsg, key)
		case "customDomain":
			err = unpopulate(val, "CustomDomain", &a.CustomDomain)
			delete(rawMsg, key)
		case "dnsEndpointType":
			err = unpopulate(val, "DNSEndpointType", &a.DNSEndpointType)
			delete(rawMsg, key)
		case "defaultToOAuthAuthentication":
			err = unpopulate(val, "DefaultToOAuthAuthentication", &a.DefaultToOAuthAuthentication)
			delete(rawMsg, key)
		case "supportsHttpsTrafficOnly":
			err = unpopulate(val, "EnableHTTPSTrafficOnly", &a.EnableHTTPSTrafficOnly)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "immutableStorageWithVersioning":
			err = unpopulate(val, "ImmutableStorageWithVersioning", &a.ImmutableStorageWithVersioning)
			delete(rawMsg, key)
		case "isLocalUserEnabled":
			err = unpopulate(val, "IsLocalUserEnabled", &a.IsLocalUserEnabled)
			delete(rawMsg, key)
		case "isSftpEnabled":
			err = unpopulate(val, "IsSftpEnabled", &a.IsSftpEnabled)
			delete(rawMsg, key)
		case "keyPolicy":
			err = unpopulate(val, "KeyPolicy", &a.KeyPolicy)
			delete(rawMsg, key)
		case "largeFileSharesState":
			err = unpopulate(val, "LargeFileSharesState", &a.LargeFileSharesState)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &a.MinimumTLSVersion)
			delete(rawMsg, key)
		case "networkAcls":
			err = unpopulate(val, "NetworkRuleSet", &a.NetworkRuleSet)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &a.PublicNetworkAccess)
			delete(rawMsg, key)
		case "routingPreference":
			err = unpopulate(val, "RoutingPreference", &a.RoutingPreference)
			delete(rawMsg, key)
		case "sasPolicy":
			err = unpopulate(val, "SasPolicy", &a.SasPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountRegenerateKeyParameters.
func (a AccountRegenerateKeyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyName", a.KeyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountRegenerateKeyParameters.
func (a *AccountRegenerateKeyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &a.KeyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountSKUConversionStatus.
func (a AccountSKUConversionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endTime", a.EndTime)
	populate(objectMap, "skuConversionStatus", a.SKUConversionStatus)
	populate(objectMap, "startTime", a.StartTime)
	populate(objectMap, "targetSkuName", a.TargetSKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountSKUConversionStatus.
func (a *AccountSKUConversionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "skuConversionStatus":
			err = unpopulate(val, "SKUConversionStatus", &a.SKUConversionStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "targetSkuName":
			err = unpopulate(val, "TargetSKUName", &a.TargetSKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountSasParameters.
func (a AccountSasParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "signedIp", a.IPAddressOrRange)
	populate(objectMap, "keyToSign", a.KeyToSign)
	populate(objectMap, "signedPermission", a.Permissions)
	populate(objectMap, "signedProtocol", a.Protocols)
	populate(objectMap, "signedResourceTypes", a.ResourceTypes)
	populate(objectMap, "signedServices", a.Services)
	populateTimeRFC3339(objectMap, "signedExpiry", a.SharedAccessExpiryTime)
	populateTimeRFC3339(objectMap, "signedStart", a.SharedAccessStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountSasParameters.
func (a *AccountSasParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "signedIp":
			err = unpopulate(val, "IPAddressOrRange", &a.IPAddressOrRange)
			delete(rawMsg, key)
		case "keyToSign":
			err = unpopulate(val, "KeyToSign", &a.KeyToSign)
			delete(rawMsg, key)
		case "signedPermission":
			err = unpopulate(val, "Permissions", &a.Permissions)
			delete(rawMsg, key)
		case "signedProtocol":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "signedResourceTypes":
			err = unpopulate(val, "ResourceTypes", &a.ResourceTypes)
			delete(rawMsg, key)
		case "signedServices":
			err = unpopulate(val, "Services", &a.Services)
			delete(rawMsg, key)
		case "signedExpiry":
			err = unpopulateTimeRFC3339(val, "SharedAccessExpiryTime", &a.SharedAccessExpiryTime)
			delete(rawMsg, key)
		case "signedStart":
			err = unpopulateTimeRFC3339(val, "SharedAccessStartTime", &a.SharedAccessStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateParameters.
func (a AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUpdateParameters.
func (a *AccountUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveDirectoryProperties.
func (a ActiveDirectoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountType", a.AccountType)
	populate(objectMap, "azureStorageSid", a.AzureStorageSid)
	populate(objectMap, "domainGuid", a.DomainGUID)
	populate(objectMap, "domainName", a.DomainName)
	populate(objectMap, "domainSid", a.DomainSid)
	populate(objectMap, "forestName", a.ForestName)
	populate(objectMap, "netBiosDomainName", a.NetBiosDomainName)
	populate(objectMap, "samAccountName", a.SamAccountName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveDirectoryProperties.
func (a *ActiveDirectoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountType":
			err = unpopulate(val, "AccountType", &a.AccountType)
			delete(rawMsg, key)
		case "azureStorageSid":
			err = unpopulate(val, "AzureStorageSid", &a.AzureStorageSid)
			delete(rawMsg, key)
		case "domainGuid":
			err = unpopulate(val, "DomainGUID", &a.DomainGUID)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &a.DomainName)
			delete(rawMsg, key)
		case "domainSid":
			err = unpopulate(val, "DomainSid", &a.DomainSid)
			delete(rawMsg, key)
		case "forestName":
			err = unpopulate(val, "ForestName", &a.ForestName)
			delete(rawMsg, key)
		case "netBiosDomainName":
			err = unpopulate(val, "NetBiosDomainName", &a.NetBiosDomainName)
			delete(rawMsg, key)
		case "samAccountName":
			err = unpopulate(val, "SamAccountName", &a.SamAccountName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureEntityResource.
func (a AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureEntityResource.
func (a *AzureEntityResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFilesIdentityBasedAuthentication.
func (a AzureFilesIdentityBasedAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activeDirectoryProperties", a.ActiveDirectoryProperties)
	populate(objectMap, "defaultSharePermission", a.DefaultSharePermission)
	populate(objectMap, "directoryServiceOptions", a.DirectoryServiceOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFilesIdentityBasedAuthentication.
func (a *AzureFilesIdentityBasedAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeDirectoryProperties":
			err = unpopulate(val, "ActiveDirectoryProperties", &a.ActiveDirectoryProperties)
			delete(rawMsg, key)
		case "defaultSharePermission":
			err = unpopulate(val, "DefaultSharePermission", &a.DefaultSharePermission)
			delete(rawMsg, key)
		case "directoryServiceOptions":
			err = unpopulate(val, "DirectoryServiceOptions", &a.DirectoryServiceOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobContainer.
func (b BlobContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", b.ContainerProperties)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobContainer.
func (b *BlobContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "ContainerProperties", &b.ContainerProperties)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInventoryPolicy.
func (b BlobInventoryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInventoryPolicy.
func (b *BlobInventoryPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInventoryPolicyDefinition.
func (b BlobInventoryPolicyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filters", b.Filters)
	populate(objectMap, "format", b.Format)
	populate(objectMap, "objectType", b.ObjectType)
	populate(objectMap, "schedule", b.Schedule)
	populate(objectMap, "schemaFields", b.SchemaFields)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInventoryPolicyDefinition.
func (b *BlobInventoryPolicyDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filters":
			err = unpopulate(val, "Filters", &b.Filters)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &b.Format)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &b.Schedule)
			delete(rawMsg, key)
		case "schemaFields":
			err = unpopulate(val, "SchemaFields", &b.SchemaFields)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInventoryPolicyFilter.
func (b BlobInventoryPolicyFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobTypes", b.BlobTypes)
	populate(objectMap, "excludePrefix", b.ExcludePrefix)
	populate(objectMap, "includeBlobVersions", b.IncludeBlobVersions)
	populate(objectMap, "includeDeleted", b.IncludeDeleted)
	populate(objectMap, "includeSnapshots", b.IncludeSnapshots)
	populate(objectMap, "prefixMatch", b.PrefixMatch)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInventoryPolicyFilter.
func (b *BlobInventoryPolicyFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobTypes":
			err = unpopulate(val, "BlobTypes", &b.BlobTypes)
			delete(rawMsg, key)
		case "excludePrefix":
			err = unpopulate(val, "ExcludePrefix", &b.ExcludePrefix)
			delete(rawMsg, key)
		case "includeBlobVersions":
			err = unpopulate(val, "IncludeBlobVersions", &b.IncludeBlobVersions)
			delete(rawMsg, key)
		case "includeDeleted":
			err = unpopulate(val, "IncludeDeleted", &b.IncludeDeleted)
			delete(rawMsg, key)
		case "includeSnapshots":
			err = unpopulate(val, "IncludeSnapshots", &b.IncludeSnapshots)
			delete(rawMsg, key)
		case "prefixMatch":
			err = unpopulate(val, "PrefixMatch", &b.PrefixMatch)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInventoryPolicyProperties.
func (b BlobInventoryPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastModifiedTime", b.LastModifiedTime)
	populate(objectMap, "policy", b.Policy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInventoryPolicyProperties.
func (b *BlobInventoryPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &b.LastModifiedTime)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &b.Policy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInventoryPolicyRule.
func (b BlobInventoryPolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "definition", b.Definition)
	populate(objectMap, "destination", b.Destination)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "name", b.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInventoryPolicyRule.
func (b *BlobInventoryPolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &b.Definition)
			delete(rawMsg, key)
		case "destination":
			err = unpopulate(val, "Destination", &b.Destination)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInventoryPolicySchema.
func (b BlobInventoryPolicySchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destination", b.Destination)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "rules", b.Rules)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInventoryPolicySchema.
func (b *BlobInventoryPolicySchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &b.Destination)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &b.Rules)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobRestoreParameters.
func (b BlobRestoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobRanges", b.BlobRanges)
	populateTimeRFC3339(objectMap, "timeToRestore", b.TimeToRestore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobRestoreParameters.
func (b *BlobRestoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobRanges":
			err = unpopulate(val, "BlobRanges", &b.BlobRanges)
			delete(rawMsg, key)
		case "timeToRestore":
			err = unpopulateTimeRFC3339(val, "TimeToRestore", &b.TimeToRestore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobRestoreRange.
func (b BlobRestoreRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endRange", b.EndRange)
	populate(objectMap, "startRange", b.StartRange)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobRestoreRange.
func (b *BlobRestoreRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endRange":
			err = unpopulate(val, "EndRange", &b.EndRange)
			delete(rawMsg, key)
		case "startRange":
			err = unpopulate(val, "StartRange", &b.StartRange)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobRestoreStatus.
func (b BlobRestoreStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failureReason", b.FailureReason)
	populate(objectMap, "parameters", b.Parameters)
	populate(objectMap, "restoreId", b.RestoreID)
	populate(objectMap, "status", b.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobRestoreStatus.
func (b *BlobRestoreStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failureReason":
			err = unpopulate(val, "FailureReason", &b.FailureReason)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &b.Parameters)
			delete(rawMsg, key)
		case "restoreId":
			err = unpopulate(val, "RestoreID", &b.RestoreID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &b.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobServiceItems.
func (b BlobServiceItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobServiceItems.
func (b *BlobServiceItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobServiceProperties.
func (b BlobServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", b.BlobServiceProperties)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobServiceProperties.
func (b *BlobServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "BlobServiceProperties", &b.BlobServiceProperties)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobServicePropertiesProperties.
func (b BlobServicePropertiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "automaticSnapshotPolicyEnabled", b.AutomaticSnapshotPolicyEnabled)
	populate(objectMap, "changeFeed", b.ChangeFeed)
	populate(objectMap, "containerDeleteRetentionPolicy", b.ContainerDeleteRetentionPolicy)
	populate(objectMap, "cors", b.Cors)
	populate(objectMap, "defaultServiceVersion", b.DefaultServiceVersion)
	populate(objectMap, "deleteRetentionPolicy", b.DeleteRetentionPolicy)
	populate(objectMap, "isVersioningEnabled", b.IsVersioningEnabled)
	populate(objectMap, "lastAccessTimeTrackingPolicy", b.LastAccessTimeTrackingPolicy)
	populate(objectMap, "restorePolicy", b.RestorePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobServicePropertiesProperties.
func (b *BlobServicePropertiesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticSnapshotPolicyEnabled":
			err = unpopulate(val, "AutomaticSnapshotPolicyEnabled", &b.AutomaticSnapshotPolicyEnabled)
			delete(rawMsg, key)
		case "changeFeed":
			err = unpopulate(val, "ChangeFeed", &b.ChangeFeed)
			delete(rawMsg, key)
		case "containerDeleteRetentionPolicy":
			err = unpopulate(val, "ContainerDeleteRetentionPolicy", &b.ContainerDeleteRetentionPolicy)
			delete(rawMsg, key)
		case "cors":
			err = unpopulate(val, "Cors", &b.Cors)
			delete(rawMsg, key)
		case "defaultServiceVersion":
			err = unpopulate(val, "DefaultServiceVersion", &b.DefaultServiceVersion)
			delete(rawMsg, key)
		case "deleteRetentionPolicy":
			err = unpopulate(val, "DeleteRetentionPolicy", &b.DeleteRetentionPolicy)
			delete(rawMsg, key)
		case "isVersioningEnabled":
			err = unpopulate(val, "IsVersioningEnabled", &b.IsVersioningEnabled)
			delete(rawMsg, key)
		case "lastAccessTimeTrackingPolicy":
			err = unpopulate(val, "LastAccessTimeTrackingPolicy", &b.LastAccessTimeTrackingPolicy)
			delete(rawMsg, key)
		case "restorePolicy":
			err = unpopulate(val, "RestorePolicy", &b.RestorePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeFeed.
func (c ChangeFeed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", c.Enabled)
	populate(objectMap, "retentionInDays", c.RetentionInDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeFeed.
func (c *ChangeFeed) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &c.RetentionInDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResult.
func (c CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResult.
func (c *CheckNameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudError.
func (c CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", c.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudError.
func (c *CloudError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudErrorBody.
func (c CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudErrorBody.
func (c *CloudErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerProperties.
func (c ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultEncryptionScope", c.DefaultEncryptionScope)
	populate(objectMap, "deleted", c.Deleted)
	populateTimeRFC3339(objectMap, "deletedTime", c.DeletedTime)
	populate(objectMap, "denyEncryptionScopeOverride", c.DenyEncryptionScopeOverride)
	populate(objectMap, "enableNfsV3AllSquash", c.EnableNfsV3AllSquash)
	populate(objectMap, "enableNfsV3RootSquash", c.EnableNfsV3RootSquash)
	populate(objectMap, "hasImmutabilityPolicy", c.HasImmutabilityPolicy)
	populate(objectMap, "hasLegalHold", c.HasLegalHold)
	populate(objectMap, "immutabilityPolicy", c.ImmutabilityPolicy)
	populate(objectMap, "immutableStorageWithVersioning", c.ImmutableStorageWithVersioning)
	populateTimeRFC3339(objectMap, "lastModifiedTime", c.LastModifiedTime)
	populate(objectMap, "leaseDuration", c.LeaseDuration)
	populate(objectMap, "leaseState", c.LeaseState)
	populate(objectMap, "leaseStatus", c.LeaseStatus)
	populate(objectMap, "legalHold", c.LegalHold)
	populate(objectMap, "metadata", c.Metadata)
	populate(objectMap, "publicAccess", c.PublicAccess)
	populate(objectMap, "remainingRetentionDays", c.RemainingRetentionDays)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerProperties.
func (c *ContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultEncryptionScope":
			err = unpopulate(val, "DefaultEncryptionScope", &c.DefaultEncryptionScope)
			delete(rawMsg, key)
		case "deleted":
			err = unpopulate(val, "Deleted", &c.Deleted)
			delete(rawMsg, key)
		case "deletedTime":
			err = unpopulateTimeRFC3339(val, "DeletedTime", &c.DeletedTime)
			delete(rawMsg, key)
		case "denyEncryptionScopeOverride":
			err = unpopulate(val, "DenyEncryptionScopeOverride", &c.DenyEncryptionScopeOverride)
			delete(rawMsg, key)
		case "enableNfsV3AllSquash":
			err = unpopulate(val, "EnableNfsV3AllSquash", &c.EnableNfsV3AllSquash)
			delete(rawMsg, key)
		case "enableNfsV3RootSquash":
			err = unpopulate(val, "EnableNfsV3RootSquash", &c.EnableNfsV3RootSquash)
			delete(rawMsg, key)
		case "hasImmutabilityPolicy":
			err = unpopulate(val, "HasImmutabilityPolicy", &c.HasImmutabilityPolicy)
			delete(rawMsg, key)
		case "hasLegalHold":
			err = unpopulate(val, "HasLegalHold", &c.HasLegalHold)
			delete(rawMsg, key)
		case "immutabilityPolicy":
			err = unpopulate(val, "ImmutabilityPolicy", &c.ImmutabilityPolicy)
			delete(rawMsg, key)
		case "immutableStorageWithVersioning":
			err = unpopulate(val, "ImmutableStorageWithVersioning", &c.ImmutableStorageWithVersioning)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &c.LastModifiedTime)
			delete(rawMsg, key)
		case "leaseDuration":
			err = unpopulate(val, "LeaseDuration", &c.LeaseDuration)
			delete(rawMsg, key)
		case "leaseState":
			err = unpopulate(val, "LeaseState", &c.LeaseState)
			delete(rawMsg, key)
		case "leaseStatus":
			err = unpopulate(val, "LeaseStatus", &c.LeaseStatus)
			delete(rawMsg, key)
		case "legalHold":
			err = unpopulate(val, "LegalHold", &c.LegalHold)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "publicAccess":
			err = unpopulate(val, "PublicAccess", &c.PublicAccess)
			delete(rawMsg, key)
		case "remainingRetentionDays":
			err = unpopulate(val, "RemainingRetentionDays", &c.RemainingRetentionDays)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CorsRule.
func (c CorsRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedHeaders", c.AllowedHeaders)
	populate(objectMap, "allowedMethods", c.AllowedMethods)
	populate(objectMap, "allowedOrigins", c.AllowedOrigins)
	populate(objectMap, "exposedHeaders", c.ExposedHeaders)
	populate(objectMap, "maxAgeInSeconds", c.MaxAgeInSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CorsRule.
func (c *CorsRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedHeaders":
			err = unpopulate(val, "AllowedHeaders", &c.AllowedHeaders)
			delete(rawMsg, key)
		case "allowedMethods":
			err = unpopulate(val, "AllowedMethods", &c.AllowedMethods)
			delete(rawMsg, key)
		case "allowedOrigins":
			err = unpopulate(val, "AllowedOrigins", &c.AllowedOrigins)
			delete(rawMsg, key)
		case "exposedHeaders":
			err = unpopulate(val, "ExposedHeaders", &c.ExposedHeaders)
			delete(rawMsg, key)
		case "maxAgeInSeconds":
			err = unpopulate(val, "MaxAgeInSeconds", &c.MaxAgeInSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CorsRules.
func (c CorsRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "corsRules", c.CorsRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CorsRules.
func (c *CorsRules) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "corsRules":
			err = unpopulate(val, "CorsRules", &c.CorsRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomain.
func (c CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "useSubDomainName", c.UseSubDomainName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomain.
func (c *CustomDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "useSubDomainName":
			err = unpopulate(val, "UseSubDomainName", &c.UseSubDomainName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DateAfterCreation.
func (d DateAfterCreation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "daysAfterCreationGreaterThan", d.DaysAfterCreationGreaterThan)
	populate(objectMap, "daysAfterLastTierChangeGreaterThan", d.DaysAfterLastTierChangeGreaterThan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DateAfterCreation.
func (d *DateAfterCreation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysAfterCreationGreaterThan":
			err = unpopulate(val, "DaysAfterCreationGreaterThan", &d.DaysAfterCreationGreaterThan)
			delete(rawMsg, key)
		case "daysAfterLastTierChangeGreaterThan":
			err = unpopulate(val, "DaysAfterLastTierChangeGreaterThan", &d.DaysAfterLastTierChangeGreaterThan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DateAfterModification.
func (d DateAfterModification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "daysAfterCreationGreaterThan", d.DaysAfterCreationGreaterThan)
	populate(objectMap, "daysAfterLastAccessTimeGreaterThan", d.DaysAfterLastAccessTimeGreaterThan)
	populate(objectMap, "daysAfterLastTierChangeGreaterThan", d.DaysAfterLastTierChangeGreaterThan)
	populate(objectMap, "daysAfterModificationGreaterThan", d.DaysAfterModificationGreaterThan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DateAfterModification.
func (d *DateAfterModification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysAfterCreationGreaterThan":
			err = unpopulate(val, "DaysAfterCreationGreaterThan", &d.DaysAfterCreationGreaterThan)
			delete(rawMsg, key)
		case "daysAfterLastAccessTimeGreaterThan":
			err = unpopulate(val, "DaysAfterLastAccessTimeGreaterThan", &d.DaysAfterLastAccessTimeGreaterThan)
			delete(rawMsg, key)
		case "daysAfterLastTierChangeGreaterThan":
			err = unpopulate(val, "DaysAfterLastTierChangeGreaterThan", &d.DaysAfterLastTierChangeGreaterThan)
			delete(rawMsg, key)
		case "daysAfterModificationGreaterThan":
			err = unpopulate(val, "DaysAfterModificationGreaterThan", &d.DaysAfterModificationGreaterThan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeleteRetentionPolicy.
func (d DeleteRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowPermanentDelete", d.AllowPermanentDelete)
	populate(objectMap, "days", d.Days)
	populate(objectMap, "enabled", d.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeleteRetentionPolicy.
func (d *DeleteRetentionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowPermanentDelete":
			err = unpopulate(val, "AllowPermanentDelete", &d.AllowPermanentDelete)
			delete(rawMsg, key)
		case "days":
			err = unpopulate(val, "Days", &d.Days)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAccount.
func (d DeletedAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAccount.
func (d *DeletedAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAccountListResult.
func (d DeletedAccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAccountListResult.
func (d *DeletedAccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAccountProperties.
func (d DeletedAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "creationTime", d.CreationTime)
	populate(objectMap, "deletionTime", d.DeletionTime)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "restoreReference", d.RestoreReference)
	populate(objectMap, "storageAccountResourceId", d.StorageAccountResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAccountProperties.
func (d *DeletedAccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulate(val, "CreationTime", &d.CreationTime)
			delete(rawMsg, key)
		case "deletionTime":
			err = unpopulate(val, "DeletionTime", &d.DeletionTime)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "restoreReference":
			err = unpopulate(val, "RestoreReference", &d.RestoreReference)
			delete(rawMsg, key)
		case "storageAccountResourceId":
			err = unpopulate(val, "StorageAccountResourceID", &d.StorageAccountResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedShare.
func (d DeletedShare) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deletedShareName", d.DeletedShareName)
	populate(objectMap, "deletedShareVersion", d.DeletedShareVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedShare.
func (d *DeletedShare) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletedShareName":
			err = unpopulate(val, "DeletedShareName", &d.DeletedShareName)
			delete(rawMsg, key)
		case "deletedShareVersion":
			err = unpopulate(val, "DeletedShareVersion", &d.DeletedShareVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Encryption.
func (e Encryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", e.EncryptionIdentity)
	populate(objectMap, "keySource", e.KeySource)
	populate(objectMap, "keyvaultproperties", e.KeyVaultProperties)
	populate(objectMap, "requireInfrastructureEncryption", e.RequireInfrastructureEncryption)
	populate(objectMap, "services", e.Services)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Encryption.
func (e *Encryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "EncryptionIdentity", &e.EncryptionIdentity)
			delete(rawMsg, key)
		case "keySource":
			err = unpopulate(val, "KeySource", &e.KeySource)
			delete(rawMsg, key)
		case "keyvaultproperties":
			err = unpopulate(val, "KeyVaultProperties", &e.KeyVaultProperties)
			delete(rawMsg, key)
		case "requireInfrastructureEncryption":
			err = unpopulate(val, "RequireInfrastructureEncryption", &e.RequireInfrastructureEncryption)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &e.Services)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionIdentity.
func (e EncryptionIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "federatedIdentityClientId", e.EncryptionFederatedIdentityClientID)
	populate(objectMap, "userAssignedIdentity", e.EncryptionUserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionIdentity.
func (e *EncryptionIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "federatedIdentityClientId":
			err = unpopulate(val, "EncryptionFederatedIdentityClientID", &e.EncryptionFederatedIdentityClientID)
			delete(rawMsg, key)
		case "userAssignedIdentity":
			err = unpopulate(val, "EncryptionUserAssignedIdentity", &e.EncryptionUserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionScope.
func (e EncryptionScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.EncryptionScopeProperties)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionScope.
func (e *EncryptionScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "EncryptionScopeProperties", &e.EncryptionScopeProperties)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionScopeKeyVaultProperties.
func (e EncryptionScopeKeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentVersionedKeyIdentifier", e.CurrentVersionedKeyIdentifier)
	populate(objectMap, "keyUri", e.KeyURI)
	populateTimeRFC3339(objectMap, "lastKeyRotationTimestamp", e.LastKeyRotationTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionScopeKeyVaultProperties.
func (e *EncryptionScopeKeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentVersionedKeyIdentifier":
			err = unpopulate(val, "CurrentVersionedKeyIdentifier", &e.CurrentVersionedKeyIdentifier)
			delete(rawMsg, key)
		case "keyUri":
			err = unpopulate(val, "KeyURI", &e.KeyURI)
			delete(rawMsg, key)
		case "lastKeyRotationTimestamp":
			err = unpopulateTimeRFC3339(val, "LastKeyRotationTimestamp", &e.LastKeyRotationTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionScopeListResult.
func (e EncryptionScopeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionScopeListResult.
func (e *EncryptionScopeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionScopeProperties.
func (e EncryptionScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "keyVaultProperties", e.KeyVaultProperties)
	populateTimeRFC3339(objectMap, "lastModifiedTime", e.LastModifiedTime)
	populate(objectMap, "requireInfrastructureEncryption", e.RequireInfrastructureEncryption)
	populate(objectMap, "source", e.Source)
	populate(objectMap, "state", e.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionScopeProperties.
func (e *EncryptionScopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "keyVaultProperties":
			err = unpopulate(val, "KeyVaultProperties", &e.KeyVaultProperties)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &e.LastModifiedTime)
			delete(rawMsg, key)
		case "requireInfrastructureEncryption":
			err = unpopulate(val, "RequireInfrastructureEncryption", &e.RequireInfrastructureEncryption)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &e.Source)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionService.
func (e EncryptionService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", e.Enabled)
	populate(objectMap, "keyType", e.KeyType)
	populateTimeRFC3339(objectMap, "lastEnabledTime", e.LastEnabledTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionService.
func (e *EncryptionService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &e.Enabled)
			delete(rawMsg, key)
		case "keyType":
			err = unpopulate(val, "KeyType", &e.KeyType)
			delete(rawMsg, key)
		case "lastEnabledTime":
			err = unpopulateTimeRFC3339(val, "LastEnabledTime", &e.LastEnabledTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionServices.
func (e EncryptionServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blob", e.Blob)
	populate(objectMap, "file", e.File)
	populate(objectMap, "queue", e.Queue)
	populate(objectMap, "table", e.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionServices.
func (e *EncryptionServices) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blob":
			err = unpopulate(val, "Blob", &e.Blob)
			delete(rawMsg, key)
		case "file":
			err = unpopulate(val, "File", &e.File)
			delete(rawMsg, key)
		case "queue":
			err = unpopulate(val, "Queue", &e.Queue)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &e.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Endpoints.
func (e Endpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blob", e.Blob)
	populate(objectMap, "dfs", e.Dfs)
	populate(objectMap, "file", e.File)
	populate(objectMap, "internetEndpoints", e.InternetEndpoints)
	populate(objectMap, "microsoftEndpoints", e.MicrosoftEndpoints)
	populate(objectMap, "queue", e.Queue)
	populate(objectMap, "table", e.Table)
	populate(objectMap, "web", e.Web)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Endpoints.
func (e *Endpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blob":
			err = unpopulate(val, "Blob", &e.Blob)
			delete(rawMsg, key)
		case "dfs":
			err = unpopulate(val, "Dfs", &e.Dfs)
			delete(rawMsg, key)
		case "file":
			err = unpopulate(val, "File", &e.File)
			delete(rawMsg, key)
		case "internetEndpoints":
			err = unpopulate(val, "InternetEndpoints", &e.InternetEndpoints)
			delete(rawMsg, key)
		case "microsoftEndpoints":
			err = unpopulate(val, "MicrosoftEndpoints", &e.MicrosoftEndpoints)
			delete(rawMsg, key)
		case "queue":
			err = unpopulate(val, "Queue", &e.Queue)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &e.Table)
			delete(rawMsg, key)
		case "web":
			err = unpopulate(val, "Web", &e.Web)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseBody.
func (e ErrorResponseBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseBody.
func (e *ErrorResponseBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServiceItems.
func (f FileServiceItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServiceItems.
func (f *FileServiceItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServiceProperties.
func (f FileServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", f.FileServiceProperties)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "sku", f.SKU)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServiceProperties.
func (f *FileServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "FileServiceProperties", &f.FileServiceProperties)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &f.SKU)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServicePropertiesProperties.
func (f FileServicePropertiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cors", f.Cors)
	populate(objectMap, "protocolSettings", f.ProtocolSettings)
	populate(objectMap, "shareDeleteRetentionPolicy", f.ShareDeleteRetentionPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServicePropertiesProperties.
func (f *FileServicePropertiesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cors":
			err = unpopulate(val, "Cors", &f.Cors)
			delete(rawMsg, key)
		case "protocolSettings":
			err = unpopulate(val, "ProtocolSettings", &f.ProtocolSettings)
			delete(rawMsg, key)
		case "shareDeleteRetentionPolicy":
			err = unpopulate(val, "ShareDeleteRetentionPolicy", &f.ShareDeleteRetentionPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileShare.
func (f FileShare) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "properties", f.FileShareProperties)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileShare.
func (f *FileShare) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "FileShareProperties", &f.FileShareProperties)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileShareItem.
func (f FileShareItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileShareItem.
func (f *FileShareItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileShareItems.
func (f FileShareItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileShareItems.
func (f *FileShareItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileShareProperties.
func (f FileShareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessTier", f.AccessTier)
	populateTimeRFC3339(objectMap, "accessTierChangeTime", f.AccessTierChangeTime)
	populate(objectMap, "accessTierStatus", f.AccessTierStatus)
	populate(objectMap, "deleted", f.Deleted)
	populateTimeRFC3339(objectMap, "deletedTime", f.DeletedTime)
	populate(objectMap, "enabledProtocols", f.EnabledProtocols)
	populateTimeRFC3339(objectMap, "lastModifiedTime", f.LastModifiedTime)
	populate(objectMap, "leaseDuration", f.LeaseDuration)
	populate(objectMap, "leaseState", f.LeaseState)
	populate(objectMap, "leaseStatus", f.LeaseStatus)
	populate(objectMap, "metadata", f.Metadata)
	populate(objectMap, "remainingRetentionDays", f.RemainingRetentionDays)
	populate(objectMap, "rootSquash", f.RootSquash)
	populate(objectMap, "shareQuota", f.ShareQuota)
	populate(objectMap, "shareUsageBytes", f.ShareUsageBytes)
	populate(objectMap, "signedIdentifiers", f.SignedIdentifiers)
	populateTimeRFC3339(objectMap, "snapshotTime", f.SnapshotTime)
	populate(objectMap, "version", f.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileShareProperties.
func (f *FileShareProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessTier":
			err = unpopulate(val, "AccessTier", &f.AccessTier)
			delete(rawMsg, key)
		case "accessTierChangeTime":
			err = unpopulateTimeRFC3339(val, "AccessTierChangeTime", &f.AccessTierChangeTime)
			delete(rawMsg, key)
		case "accessTierStatus":
			err = unpopulate(val, "AccessTierStatus", &f.AccessTierStatus)
			delete(rawMsg, key)
		case "deleted":
			err = unpopulate(val, "Deleted", &f.Deleted)
			delete(rawMsg, key)
		case "deletedTime":
			err = unpopulateTimeRFC3339(val, "DeletedTime", &f.DeletedTime)
			delete(rawMsg, key)
		case "enabledProtocols":
			err = unpopulate(val, "EnabledProtocols", &f.EnabledProtocols)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &f.LastModifiedTime)
			delete(rawMsg, key)
		case "leaseDuration":
			err = unpopulate(val, "LeaseDuration", &f.LeaseDuration)
			delete(rawMsg, key)
		case "leaseState":
			err = unpopulate(val, "LeaseState", &f.LeaseState)
			delete(rawMsg, key)
		case "leaseStatus":
			err = unpopulate(val, "LeaseStatus", &f.LeaseStatus)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &f.Metadata)
			delete(rawMsg, key)
		case "remainingRetentionDays":
			err = unpopulate(val, "RemainingRetentionDays", &f.RemainingRetentionDays)
			delete(rawMsg, key)
		case "rootSquash":
			err = unpopulate(val, "RootSquash", &f.RootSquash)
			delete(rawMsg, key)
		case "shareQuota":
			err = unpopulate(val, "ShareQuota", &f.ShareQuota)
			delete(rawMsg, key)
		case "shareUsageBytes":
			err = unpopulate(val, "ShareUsageBytes", &f.ShareUsageBytes)
			delete(rawMsg, key)
		case "signedIdentifiers":
			err = unpopulate(val, "SignedIdentifiers", &f.SignedIdentifiers)
			delete(rawMsg, key)
		case "snapshotTime":
			err = unpopulateTimeRFC3339(val, "SnapshotTime", &f.SnapshotTime)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &f.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoReplicationStats.
func (g GeoReplicationStats) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "canFailover", g.CanFailover)
	populateTimeRFC3339(objectMap, "lastSyncTime", g.LastSyncTime)
	populate(objectMap, "status", g.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoReplicationStats.
func (g *GeoReplicationStats) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canFailover":
			err = unpopulate(val, "CanFailover", &g.CanFailover)
			delete(rawMsg, key)
		case "lastSyncTime":
			err = unpopulateTimeRFC3339(val, "LastSyncTime", &g.LastSyncTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPRule.
func (i IPRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["action"] = "Allow"
	populate(objectMap, "value", i.IPAddressOrRange)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPRule.
func (i *IPRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "IPAddressOrRange", &i.IPAddressOrRange)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &i.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmutabilityPolicy.
func (i ImmutabilityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmutabilityPolicy.
func (i *ImmutabilityPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmutabilityPolicyProperties.
func (i ImmutabilityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "updateHistory", i.UpdateHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmutabilityPolicyProperties.
func (i *ImmutabilityPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "updateHistory":
			err = unpopulate(val, "UpdateHistory", &i.UpdateHistory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmutabilityPolicyProperty.
func (i ImmutabilityPolicyProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowProtectedAppendWrites", i.AllowProtectedAppendWrites)
	populate(objectMap, "allowProtectedAppendWritesAll", i.AllowProtectedAppendWritesAll)
	populate(objectMap, "immutabilityPeriodSinceCreationInDays", i.ImmutabilityPeriodSinceCreationInDays)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmutabilityPolicyProperty.
func (i *ImmutabilityPolicyProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowProtectedAppendWrites":
			err = unpopulate(val, "AllowProtectedAppendWrites", &i.AllowProtectedAppendWrites)
			delete(rawMsg, key)
		case "allowProtectedAppendWritesAll":
			err = unpopulate(val, "AllowProtectedAppendWritesAll", &i.AllowProtectedAppendWritesAll)
			delete(rawMsg, key)
		case "immutabilityPeriodSinceCreationInDays":
			err = unpopulate(val, "ImmutabilityPeriodSinceCreationInDays", &i.ImmutabilityPeriodSinceCreationInDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmutableStorageAccount.
func (i ImmutableStorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", i.Enabled)
	populate(objectMap, "immutabilityPolicy", i.ImmutabilityPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmutableStorageAccount.
func (i *ImmutableStorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &i.Enabled)
			delete(rawMsg, key)
		case "immutabilityPolicy":
			err = unpopulate(val, "ImmutabilityPolicy", &i.ImmutabilityPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmutableStorageWithVersioning.
func (i ImmutableStorageWithVersioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", i.Enabled)
	populate(objectMap, "migrationState", i.MigrationState)
	populateTimeRFC3339(objectMap, "timeStamp", i.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmutableStorageWithVersioning.
func (i *ImmutableStorageWithVersioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &i.Enabled)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &i.MigrationState)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateTimeRFC3339(val, "TimeStamp", &i.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyCreationTime.
func (k KeyCreationTime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "key1", k.Key1)
	populateTimeRFC3339(objectMap, "key2", k.Key2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyCreationTime.
func (k *KeyCreationTime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key1":
			err = unpopulateTimeRFC3339(val, "Key1", &k.Key1)
			delete(rawMsg, key)
		case "key2":
			err = unpopulateTimeRFC3339(val, "Key2", &k.Key2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyPolicy.
func (k KeyPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyExpirationPeriodInDays", k.KeyExpirationPeriodInDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyPolicy.
func (k *KeyPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyExpirationPeriodInDays":
			err = unpopulate(val, "KeyExpirationPeriodInDays", &k.KeyExpirationPeriodInDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultProperties.
func (k KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "currentVersionedKeyExpirationTimestamp", k.CurrentVersionedKeyExpirationTimestamp)
	populate(objectMap, "currentVersionedKeyIdentifier", k.CurrentVersionedKeyIdentifier)
	populate(objectMap, "keyname", k.KeyName)
	populate(objectMap, "keyvaulturi", k.KeyVaultURI)
	populate(objectMap, "keyversion", k.KeyVersion)
	populateTimeRFC3339(objectMap, "lastKeyRotationTimestamp", k.LastKeyRotationTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultProperties.
func (k *KeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentVersionedKeyExpirationTimestamp":
			err = unpopulateTimeRFC3339(val, "CurrentVersionedKeyExpirationTimestamp", &k.CurrentVersionedKeyExpirationTimestamp)
			delete(rawMsg, key)
		case "currentVersionedKeyIdentifier":
			err = unpopulate(val, "CurrentVersionedKeyIdentifier", &k.CurrentVersionedKeyIdentifier)
			delete(rawMsg, key)
		case "keyname":
			err = unpopulate(val, "KeyName", &k.KeyName)
			delete(rawMsg, key)
		case "keyvaulturi":
			err = unpopulate(val, "KeyVaultURI", &k.KeyVaultURI)
			delete(rawMsg, key)
		case "keyversion":
			err = unpopulate(val, "KeyVersion", &k.KeyVersion)
			delete(rawMsg, key)
		case "lastKeyRotationTimestamp":
			err = unpopulateTimeRFC3339(val, "LastKeyRotationTimestamp", &k.LastKeyRotationTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastAccessTimeTrackingPolicy.
func (l LastAccessTimeTrackingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobType", l.BlobType)
	populate(objectMap, "enable", l.Enable)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "trackingGranularityInDays", l.TrackingGranularityInDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastAccessTimeTrackingPolicy.
func (l *LastAccessTimeTrackingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobType":
			err = unpopulate(val, "BlobType", &l.BlobType)
			delete(rawMsg, key)
		case "enable":
			err = unpopulate(val, "Enable", &l.Enable)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "trackingGranularityInDays":
			err = unpopulate(val, "TrackingGranularityInDays", &l.TrackingGranularityInDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LeaseContainerRequest.
func (l LeaseContainerRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", l.Action)
	populate(objectMap, "breakPeriod", l.BreakPeriod)
	populate(objectMap, "leaseDuration", l.LeaseDuration)
	populate(objectMap, "leaseId", l.LeaseID)
	populate(objectMap, "proposedLeaseId", l.ProposedLeaseID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LeaseContainerRequest.
func (l *LeaseContainerRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &l.Action)
			delete(rawMsg, key)
		case "breakPeriod":
			err = unpopulate(val, "BreakPeriod", &l.BreakPeriod)
			delete(rawMsg, key)
		case "leaseDuration":
			err = unpopulate(val, "LeaseDuration", &l.LeaseDuration)
			delete(rawMsg, key)
		case "leaseId":
			err = unpopulate(val, "LeaseID", &l.LeaseID)
			delete(rawMsg, key)
		case "proposedLeaseId":
			err = unpopulate(val, "ProposedLeaseID", &l.ProposedLeaseID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LeaseContainerResponse.
func (l LeaseContainerResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "leaseId", l.LeaseID)
	populate(objectMap, "leaseTimeSeconds", l.LeaseTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LeaseContainerResponse.
func (l *LeaseContainerResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "leaseId":
			err = unpopulate(val, "LeaseID", &l.LeaseID)
			delete(rawMsg, key)
		case "leaseTimeSeconds":
			err = unpopulate(val, "LeaseTimeSeconds", &l.LeaseTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LeaseShareRequest.
func (l LeaseShareRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", l.Action)
	populate(objectMap, "breakPeriod", l.BreakPeriod)
	populate(objectMap, "leaseDuration", l.LeaseDuration)
	populate(objectMap, "leaseId", l.LeaseID)
	populate(objectMap, "proposedLeaseId", l.ProposedLeaseID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LeaseShareRequest.
func (l *LeaseShareRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &l.Action)
			delete(rawMsg, key)
		case "breakPeriod":
			err = unpopulate(val, "BreakPeriod", &l.BreakPeriod)
			delete(rawMsg, key)
		case "leaseDuration":
			err = unpopulate(val, "LeaseDuration", &l.LeaseDuration)
			delete(rawMsg, key)
		case "leaseId":
			err = unpopulate(val, "LeaseID", &l.LeaseID)
			delete(rawMsg, key)
		case "proposedLeaseId":
			err = unpopulate(val, "ProposedLeaseID", &l.ProposedLeaseID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LeaseShareResponse.
func (l LeaseShareResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "leaseId", l.LeaseID)
	populate(objectMap, "leaseTimeSeconds", l.LeaseTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LeaseShareResponse.
func (l *LeaseShareResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "leaseId":
			err = unpopulate(val, "LeaseID", &l.LeaseID)
			delete(rawMsg, key)
		case "leaseTimeSeconds":
			err = unpopulate(val, "LeaseTimeSeconds", &l.LeaseTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegalHold.
func (l LegalHold) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowProtectedAppendWritesAll", l.AllowProtectedAppendWritesAll)
	populate(objectMap, "hasLegalHold", l.HasLegalHold)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegalHold.
func (l *LegalHold) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowProtectedAppendWritesAll":
			err = unpopulate(val, "AllowProtectedAppendWritesAll", &l.AllowProtectedAppendWritesAll)
			delete(rawMsg, key)
		case "hasLegalHold":
			err = unpopulate(val, "HasLegalHold", &l.HasLegalHold)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegalHoldProperties.
func (l LegalHoldProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hasLegalHold", l.HasLegalHold)
	populate(objectMap, "protectedAppendWritesHistory", l.ProtectedAppendWritesHistory)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegalHoldProperties.
func (l *LegalHoldProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hasLegalHold":
			err = unpopulate(val, "HasLegalHold", &l.HasLegalHold)
			delete(rawMsg, key)
		case "protectedAppendWritesHistory":
			err = unpopulate(val, "ProtectedAppendWritesHistory", &l.ProtectedAppendWritesHistory)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListAccountSasResponse.
func (l ListAccountSasResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountSasToken", l.AccountSasToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListAccountSasResponse.
func (l *ListAccountSasResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountSasToken":
			err = unpopulate(val, "AccountSasToken", &l.AccountSasToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListBlobInventoryPolicy.
func (l ListBlobInventoryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListBlobInventoryPolicy.
func (l *ListBlobInventoryPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListContainerItem.
func (l ListContainerItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListContainerItem.
func (l *ListContainerItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListContainerItems.
func (l ListContainerItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListContainerItems.
func (l *ListContainerItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListQueue.
func (l ListQueue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.QueueProperties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListQueue.
func (l *ListQueue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "QueueProperties", &l.QueueProperties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListQueueProperties.
func (l ListQueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "metadata", l.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListQueueProperties.
func (l *ListQueueProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &l.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListQueueResource.
func (l ListQueueResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListQueueResource.
func (l *ListQueueResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListQueueServices.
func (l ListQueueServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListQueueServices.
func (l *ListQueueServices) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListServiceSasResponse.
func (l ListServiceSasResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceSasToken", l.ServiceSasToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListServiceSasResponse.
func (l *ListServiceSasResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSasToken":
			err = unpopulate(val, "ServiceSasToken", &l.ServiceSasToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListTableResource.
func (l ListTableResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListTableResource.
func (l *ListTableResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListTableServices.
func (l ListTableServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListTableServices.
func (l *ListTableServices) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalUser.
func (l LocalUser) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalUser.
func (l *LocalUser) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalUserKeys.
func (l LocalUserKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sshAuthorizedKeys", l.SSHAuthorizedKeys)
	populate(objectMap, "sharedKey", l.SharedKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalUserKeys.
func (l *LocalUserKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sshAuthorizedKeys":
			err = unpopulate(val, "SSHAuthorizedKeys", &l.SSHAuthorizedKeys)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &l.SharedKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalUserProperties.
func (l LocalUserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hasSshKey", l.HasSSHKey)
	populate(objectMap, "hasSshPassword", l.HasSSHPassword)
	populate(objectMap, "hasSharedKey", l.HasSharedKey)
	populate(objectMap, "homeDirectory", l.HomeDirectory)
	populate(objectMap, "permissionScopes", l.PermissionScopes)
	populate(objectMap, "sshAuthorizedKeys", l.SSHAuthorizedKeys)
	populate(objectMap, "sid", l.Sid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalUserProperties.
func (l *LocalUserProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hasSshKey":
			err = unpopulate(val, "HasSSHKey", &l.HasSSHKey)
			delete(rawMsg, key)
		case "hasSshPassword":
			err = unpopulate(val, "HasSSHPassword", &l.HasSSHPassword)
			delete(rawMsg, key)
		case "hasSharedKey":
			err = unpopulate(val, "HasSharedKey", &l.HasSharedKey)
			delete(rawMsg, key)
		case "homeDirectory":
			err = unpopulate(val, "HomeDirectory", &l.HomeDirectory)
			delete(rawMsg, key)
		case "permissionScopes":
			err = unpopulate(val, "PermissionScopes", &l.PermissionScopes)
			delete(rawMsg, key)
		case "sshAuthorizedKeys":
			err = unpopulate(val, "SSHAuthorizedKeys", &l.SSHAuthorizedKeys)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "Sid", &l.Sid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalUserRegeneratePasswordResult.
func (l LocalUserRegeneratePasswordResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sshPassword", l.SSHPassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalUserRegeneratePasswordResult.
func (l *LocalUserRegeneratePasswordResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sshPassword":
			err = unpopulate(val, "SSHPassword", &l.SSHPassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalUsers.
func (l LocalUsers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalUsers.
func (l *LocalUsers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicy.
func (m ManagementPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicy.
func (m *ManagementPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyAction.
func (m ManagementPolicyAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseBlob", m.BaseBlob)
	populate(objectMap, "snapshot", m.Snapshot)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyAction.
func (m *ManagementPolicyAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseBlob":
			err = unpopulate(val, "BaseBlob", &m.BaseBlob)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &m.Snapshot)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyBaseBlob.
func (m ManagementPolicyBaseBlob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "delete", m.Delete)
	populate(objectMap, "enableAutoTierToHotFromCool", m.EnableAutoTierToHotFromCool)
	populate(objectMap, "tierToArchive", m.TierToArchive)
	populate(objectMap, "tierToCool", m.TierToCool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyBaseBlob.
func (m *ManagementPolicyBaseBlob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delete":
			err = unpopulate(val, "Delete", &m.Delete)
			delete(rawMsg, key)
		case "enableAutoTierToHotFromCool":
			err = unpopulate(val, "EnableAutoTierToHotFromCool", &m.EnableAutoTierToHotFromCool)
			delete(rawMsg, key)
		case "tierToArchive":
			err = unpopulate(val, "TierToArchive", &m.TierToArchive)
			delete(rawMsg, key)
		case "tierToCool":
			err = unpopulate(val, "TierToCool", &m.TierToCool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyDefinition.
func (m ManagementPolicyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", m.Actions)
	populate(objectMap, "filters", m.Filters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyDefinition.
func (m *ManagementPolicyDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &m.Actions)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &m.Filters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyFilter.
func (m ManagementPolicyFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobIndexMatch", m.BlobIndexMatch)
	populate(objectMap, "blobTypes", m.BlobTypes)
	populate(objectMap, "prefixMatch", m.PrefixMatch)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyFilter.
func (m *ManagementPolicyFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobIndexMatch":
			err = unpopulate(val, "BlobIndexMatch", &m.BlobIndexMatch)
			delete(rawMsg, key)
		case "blobTypes":
			err = unpopulate(val, "BlobTypes", &m.BlobTypes)
			delete(rawMsg, key)
		case "prefixMatch":
			err = unpopulate(val, "PrefixMatch", &m.PrefixMatch)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyProperties.
func (m ManagementPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastModifiedTime", m.LastModifiedTime)
	populate(objectMap, "policy", m.Policy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyProperties.
func (m *ManagementPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &m.LastModifiedTime)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &m.Policy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyRule.
func (m ManagementPolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "definition", m.Definition)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyRule.
func (m *ManagementPolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &m.Definition)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicySchema.
func (m ManagementPolicySchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicySchema.
func (m *ManagementPolicySchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &m.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicySnapShot.
func (m ManagementPolicySnapShot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "delete", m.Delete)
	populate(objectMap, "tierToArchive", m.TierToArchive)
	populate(objectMap, "tierToCool", m.TierToCool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicySnapShot.
func (m *ManagementPolicySnapShot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delete":
			err = unpopulate(val, "Delete", &m.Delete)
			delete(rawMsg, key)
		case "tierToArchive":
			err = unpopulate(val, "TierToArchive", &m.TierToArchive)
			delete(rawMsg, key)
		case "tierToCool":
			err = unpopulate(val, "TierToCool", &m.TierToCool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementPolicyVersion.
func (m ManagementPolicyVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "delete", m.Delete)
	populate(objectMap, "tierToArchive", m.TierToArchive)
	populate(objectMap, "tierToCool", m.TierToCool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementPolicyVersion.
func (m *ManagementPolicyVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delete":
			err = unpopulate(val, "Delete", &m.Delete)
			delete(rawMsg, key)
		case "tierToArchive":
			err = unpopulate(val, "TierToArchive", &m.TierToArchive)
			delete(rawMsg, key)
		case "tierToCool":
			err = unpopulate(val, "TierToCool", &m.TierToCool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "resourceIdDimensionNameOverride", m.ResourceIDDimensionNameOverride)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resourceIdDimensionNameOverride":
			err = unpopulate(val, "ResourceIDDimensionNameOverride", &m.ResourceIDDimensionNameOverride)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Multichannel.
func (m Multichannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Multichannel.
func (m *Multichannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRuleSet.
func (n NetworkRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bypass", n.Bypass)
	populate(objectMap, "defaultAction", n.DefaultAction)
	populate(objectMap, "ipRules", n.IPRules)
	populate(objectMap, "resourceAccessRules", n.ResourceAccessRules)
	populate(objectMap, "virtualNetworkRules", n.VirtualNetworkRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkRuleSet.
func (n *NetworkRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bypass":
			err = unpopulate(val, "Bypass", &n.Bypass)
			delete(rawMsg, key)
		case "defaultAction":
			err = unpopulate(val, "DefaultAction", &n.DefaultAction)
			delete(rawMsg, key)
		case "ipRules":
			err = unpopulate(val, "IPRules", &n.IPRules)
			delete(rawMsg, key)
		case "resourceAccessRules":
			err = unpopulate(val, "ResourceAccessRules", &n.ResourceAccessRules)
			delete(rawMsg, key)
		case "virtualNetworkRules":
			err = unpopulate(val, "VirtualNetworkRules", &n.VirtualNetworkRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectReplicationPolicies.
func (o ObjectReplicationPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectReplicationPolicies.
func (o *ObjectReplicationPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectReplicationPolicy.
func (o ObjectReplicationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectReplicationPolicy.
func (o *ObjectReplicationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectReplicationPolicyFilter.
func (o ObjectReplicationPolicyFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "minCreationTime", o.MinCreationTime)
	populate(objectMap, "prefixMatch", o.PrefixMatch)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectReplicationPolicyFilter.
func (o *ObjectReplicationPolicyFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minCreationTime":
			err = unpopulate(val, "MinCreationTime", &o.MinCreationTime)
			delete(rawMsg, key)
		case "prefixMatch":
			err = unpopulate(val, "PrefixMatch", &o.PrefixMatch)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectReplicationPolicyProperties.
func (o ObjectReplicationPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destinationAccount", o.DestinationAccount)
	populateTimeRFC3339(objectMap, "enabledTime", o.EnabledTime)
	populate(objectMap, "policyId", o.PolicyID)
	populate(objectMap, "rules", o.Rules)
	populate(objectMap, "sourceAccount", o.SourceAccount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectReplicationPolicyProperties.
func (o *ObjectReplicationPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationAccount":
			err = unpopulate(val, "DestinationAccount", &o.DestinationAccount)
			delete(rawMsg, key)
		case "enabledTime":
			err = unpopulateTimeRFC3339(val, "EnabledTime", &o.EnabledTime)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &o.PolicyID)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &o.Rules)
			delete(rawMsg, key)
		case "sourceAccount":
			err = unpopulate(val, "SourceAccount", &o.SourceAccount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectReplicationPolicyRule.
func (o ObjectReplicationPolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destinationContainer", o.DestinationContainer)
	populate(objectMap, "filters", o.Filters)
	populate(objectMap, "ruleId", o.RuleID)
	populate(objectMap, "sourceContainer", o.SourceContainer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectReplicationPolicyRule.
func (o *ObjectReplicationPolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationContainer":
			err = unpopulate(val, "DestinationContainer", &o.DestinationContainer)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &o.Filters)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &o.RuleID)
			delete(rawMsg, key)
		case "sourceContainer":
			err = unpopulate(val, "SourceContainer", &o.SourceContainer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.OperationProperties)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "OperationProperties", &o.OperationProperties)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PermissionScope.
func (p PermissionScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "permissions", p.Permissions)
	populate(objectMap, "resourceName", p.ResourceName)
	populate(objectMap, "service", p.Service)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PermissionScope.
func (p *PermissionScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "permissions":
			err = unpopulate(val, "Permissions", &p.Permissions)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &p.ResourceName)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &p.Service)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionRequired", p.ActionRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionRequired":
			err = unpopulate(val, "ActionRequired", &p.ActionRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedAppendWritesHistory.
func (p ProtectedAppendWritesHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowProtectedAppendWritesAll", p.AllowProtectedAppendWritesAll)
	populateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedAppendWritesHistory.
func (p *ProtectedAppendWritesHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowProtectedAppendWritesAll":
			err = unpopulate(val, "AllowProtectedAppendWritesAll", &p.AllowProtectedAppendWritesAll)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtocolSettings.
func (p ProtocolSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "smb", p.Smb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtocolSettings.
func (p *ProtocolSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "smb":
			err = unpopulate(val, "Smb", &p.Smb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Queue.
func (q Queue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", q.ID)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.QueueProperties)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Queue.
func (q *Queue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "QueueProperties", &q.QueueProperties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueueProperties.
func (q QueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "approximateMessageCount", q.ApproximateMessageCount)
	populate(objectMap, "metadata", q.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueueProperties.
func (q *QueueProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approximateMessageCount":
			err = unpopulate(val, "ApproximateMessageCount", &q.ApproximateMessageCount)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &q.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueueServiceProperties.
func (q QueueServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", q.ID)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.QueueServiceProperties)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueueServiceProperties.
func (q *QueueServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "QueueServiceProperties", &q.QueueServiceProperties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueueServicePropertiesProperties.
func (q QueueServicePropertiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cors", q.Cors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueueServicePropertiesProperties.
func (q *QueueServicePropertiesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cors":
			err = unpopulate(val, "Cors", &q.Cors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceAccessRule.
func (r ResourceAccessRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceId", r.ResourceID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceAccessRule.
func (r *ResourceAccessRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePolicyProperties.
func (r RestorePolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "days", r.Days)
	populate(objectMap, "enabled", r.Enabled)
	populateTimeRFC3339(objectMap, "lastEnabledTime", r.LastEnabledTime)
	populateTimeRFC3339(objectMap, "minRestoreTime", r.MinRestoreTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePolicyProperties.
func (r *RestorePolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "days":
			err = unpopulate(val, "Days", &r.Days)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		case "lastEnabledTime":
			err = unpopulateTimeRFC3339(val, "LastEnabledTime", &r.LastEnabledTime)
			delete(rawMsg, key)
		case "minRestoreTime":
			err = unpopulateTimeRFC3339(val, "MinRestoreTime", &r.MinRestoreTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Restriction.
func (r Restriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "reasonCode", r.ReasonCode)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "values", r.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Restriction.
func (r *Restriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &r.ReasonCode)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &r.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingPreference.
func (r RoutingPreference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publishInternetEndpoints", r.PublishInternetEndpoints)
	populate(objectMap, "publishMicrosoftEndpoints", r.PublishMicrosoftEndpoints)
	populate(objectMap, "routingChoice", r.RoutingChoice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingPreference.
func (r *RoutingPreference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publishInternetEndpoints":
			err = unpopulate(val, "PublishInternetEndpoints", &r.PublishInternetEndpoints)
			delete(rawMsg, key)
		case "publishMicrosoftEndpoints":
			err = unpopulate(val, "PublishMicrosoftEndpoints", &r.PublishMicrosoftEndpoints)
			delete(rawMsg, key)
		case "routingChoice":
			err = unpopulate(val, "RoutingChoice", &r.RoutingChoice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapability.
func (s SKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapability.
func (s *SKUCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInformation.
func (s SKUInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "restrictions", s.Restrictions)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInformation.
func (s *SKUInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &s.Restrictions)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUListResult.
func (s SKUListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUListResult.
func (s *SKUListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	populate(objectMap, "key", s.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SasPolicy.
func (s SasPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "expirationAction", s.ExpirationAction)
	populate(objectMap, "sasExpirationPeriod", s.SasExpirationPeriod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SasPolicy.
func (s *SasPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationAction":
			err = unpopulate(val, "ExpirationAction", &s.ExpirationAction)
			delete(rawMsg, key)
		case "sasExpirationPeriod":
			err = unpopulate(val, "SasExpirationPeriod", &s.SasExpirationPeriod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSasParameters.
func (s ServiceSasParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "rscc", s.CacheControl)
	populate(objectMap, "canonicalizedResource", s.CanonicalizedResource)
	populate(objectMap, "rscd", s.ContentDisposition)
	populate(objectMap, "rsce", s.ContentEncoding)
	populate(objectMap, "rscl", s.ContentLanguage)
	populate(objectMap, "rsct", s.ContentType)
	populate(objectMap, "signedIp", s.IPAddressOrRange)
	populate(objectMap, "signedIdentifier", s.Identifier)
	populate(objectMap, "keyToSign", s.KeyToSign)
	populate(objectMap, "endPk", s.PartitionKeyEnd)
	populate(objectMap, "startPk", s.PartitionKeyStart)
	populate(objectMap, "signedPermission", s.Permissions)
	populate(objectMap, "signedProtocol", s.Protocols)
	populate(objectMap, "signedResource", s.Resource)
	populate(objectMap, "endRk", s.RowKeyEnd)
	populate(objectMap, "startRk", s.RowKeyStart)
	populateTimeRFC3339(objectMap, "signedExpiry", s.SharedAccessExpiryTime)
	populateTimeRFC3339(objectMap, "signedStart", s.SharedAccessStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSasParameters.
func (s *ServiceSasParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rscc":
			err = unpopulate(val, "CacheControl", &s.CacheControl)
			delete(rawMsg, key)
		case "canonicalizedResource":
			err = unpopulate(val, "CanonicalizedResource", &s.CanonicalizedResource)
			delete(rawMsg, key)
		case "rscd":
			err = unpopulate(val, "ContentDisposition", &s.ContentDisposition)
			delete(rawMsg, key)
		case "rsce":
			err = unpopulate(val, "ContentEncoding", &s.ContentEncoding)
			delete(rawMsg, key)
		case "rscl":
			err = unpopulate(val, "ContentLanguage", &s.ContentLanguage)
			delete(rawMsg, key)
		case "rsct":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "signedIp":
			err = unpopulate(val, "IPAddressOrRange", &s.IPAddressOrRange)
			delete(rawMsg, key)
		case "signedIdentifier":
			err = unpopulate(val, "Identifier", &s.Identifier)
			delete(rawMsg, key)
		case "keyToSign":
			err = unpopulate(val, "KeyToSign", &s.KeyToSign)
			delete(rawMsg, key)
		case "endPk":
			err = unpopulate(val, "PartitionKeyEnd", &s.PartitionKeyEnd)
			delete(rawMsg, key)
		case "startPk":
			err = unpopulate(val, "PartitionKeyStart", &s.PartitionKeyStart)
			delete(rawMsg, key)
		case "signedPermission":
			err = unpopulate(val, "Permissions", &s.Permissions)
			delete(rawMsg, key)
		case "signedProtocol":
			err = unpopulate(val, "Protocols", &s.Protocols)
			delete(rawMsg, key)
		case "signedResource":
			err = unpopulate(val, "Resource", &s.Resource)
			delete(rawMsg, key)
		case "endRk":
			err = unpopulate(val, "RowKeyEnd", &s.RowKeyEnd)
			delete(rawMsg, key)
		case "startRk":
			err = unpopulate(val, "RowKeyStart", &s.RowKeyStart)
			delete(rawMsg, key)
		case "signedExpiry":
			err = unpopulateTimeRFC3339(val, "SharedAccessExpiryTime", &s.SharedAccessExpiryTime)
			delete(rawMsg, key)
		case "signedStart":
			err = unpopulateTimeRFC3339(val, "SharedAccessStartTime", &s.SharedAccessStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignedIdentifier.
func (s SignedIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessPolicy", s.AccessPolicy)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignedIdentifier.
func (s *SignedIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessPolicy":
			err = unpopulate(val, "AccessPolicy", &s.AccessPolicy)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SmbSetting.
func (s SmbSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authenticationMethods", s.AuthenticationMethods)
	populate(objectMap, "channelEncryption", s.ChannelEncryption)
	populate(objectMap, "kerberosTicketEncryption", s.KerberosTicketEncryption)
	populate(objectMap, "multichannel", s.Multichannel)
	populate(objectMap, "versions", s.Versions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SmbSetting.
func (s *SmbSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMethods":
			err = unpopulate(val, "AuthenticationMethods", &s.AuthenticationMethods)
			delete(rawMsg, key)
		case "channelEncryption":
			err = unpopulate(val, "ChannelEncryption", &s.ChannelEncryption)
			delete(rawMsg, key)
		case "kerberosTicketEncryption":
			err = unpopulate(val, "KerberosTicketEncryption", &s.KerberosTicketEncryption)
			delete(rawMsg, key)
		case "multichannel":
			err = unpopulate(val, "Multichannel", &s.Multichannel)
			delete(rawMsg, key)
		case "versions":
			err = unpopulate(val, "Versions", &s.Versions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Table.
func (t Table) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.TableProperties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Table.
func (t *Table) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "TableProperties", &t.TableProperties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableAccessPolicy.
func (t TableAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiryTime", t.ExpiryTime)
	populate(objectMap, "permission", t.Permission)
	populateTimeRFC3339(objectMap, "startTime", t.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableAccessPolicy.
func (t *TableAccessPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &t.ExpiryTime)
			delete(rawMsg, key)
		case "permission":
			err = unpopulate(val, "Permission", &t.Permission)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableProperties.
func (t TableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "signedIdentifiers", t.SignedIdentifiers)
	populate(objectMap, "tableName", t.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableProperties.
func (t *TableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "signedIdentifiers":
			err = unpopulate(val, "SignedIdentifiers", &t.SignedIdentifiers)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &t.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableServiceProperties.
func (t TableServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.TableServiceProperties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableServiceProperties.
func (t *TableServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "TableServiceProperties", &t.TableServiceProperties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableServicePropertiesProperties.
func (t TableServicePropertiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cors", t.Cors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableServicePropertiesProperties.
func (t *TableServicePropertiesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cors":
			err = unpopulate(val, "Cors", &t.Cors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableSignedIdentifier.
func (t TableSignedIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessPolicy", t.AccessPolicy)
	populate(objectMap, "id", t.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableSignedIdentifier.
func (t *TableSignedIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessPolicy":
			err = unpopulate(val, "AccessPolicy", &t.AccessPolicy)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagFilter.
func (t TagFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", t.Name)
	populate(objectMap, "op", t.Op)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagFilter.
func (t *TagFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "op":
			err = unpopulate(val, "Op", &t.Op)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagProperty.
func (t TagProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "objectIdentifier", t.ObjectIdentifier)
	populate(objectMap, "tag", t.Tag)
	populate(objectMap, "tenantId", t.TenantID)
	populateTimeRFC3339(objectMap, "timestamp", t.Timestamp)
	populate(objectMap, "upn", t.Upn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagProperty.
func (t *TagProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectIdentifier":
			err = unpopulate(val, "ObjectIdentifier", &t.ObjectIdentifier)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &t.Tag)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &t.TenantID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &t.Timestamp)
			delete(rawMsg, key)
		case "upn":
			err = unpopulate(val, "Upn", &t.Upn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateHistoryProperty.
func (u UpdateHistoryProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowProtectedAppendWrites", u.AllowProtectedAppendWrites)
	populate(objectMap, "allowProtectedAppendWritesAll", u.AllowProtectedAppendWritesAll)
	populate(objectMap, "immutabilityPeriodSinceCreationInDays", u.ImmutabilityPeriodSinceCreationInDays)
	populate(objectMap, "objectIdentifier", u.ObjectIdentifier)
	populate(objectMap, "tenantId", u.TenantID)
	populateTimeRFC3339(objectMap, "timestamp", u.Timestamp)
	populate(objectMap, "update", u.Update)
	populate(objectMap, "upn", u.Upn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateHistoryProperty.
func (u *UpdateHistoryProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowProtectedAppendWrites":
			err = unpopulate(val, "AllowProtectedAppendWrites", &u.AllowProtectedAppendWrites)
			delete(rawMsg, key)
		case "allowProtectedAppendWritesAll":
			err = unpopulate(val, "AllowProtectedAppendWritesAll", &u.AllowProtectedAppendWritesAll)
			delete(rawMsg, key)
		case "immutabilityPeriodSinceCreationInDays":
			err = unpopulate(val, "ImmutabilityPeriodSinceCreationInDays", &u.ImmutabilityPeriodSinceCreationInDays)
			delete(rawMsg, key)
		case "objectIdentifier":
			err = unpopulate(val, "ObjectIdentifier", &u.ObjectIdentifier)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &u.TenantID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &u.Timestamp)
			delete(rawMsg, key)
		case "update":
			err = unpopulate(val, "Update", &u.Update)
			delete(rawMsg, key)
		case "upn":
			err = unpopulate(val, "Upn", &u.Upn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageListResult.
func (u UsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageListResult.
func (u *UsageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkRule.
func (v VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["action"] = "Allow"
	populate(objectMap, "state", v.State)
	populate(objectMap, "id", v.VirtualNetworkResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkRule.
func (v *VirtualNetworkRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &v.Action)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "VirtualNetworkResourceID", &v.VirtualNetworkResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
