//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscheduler

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type BasicAuthentication.
func (b BasicAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "password", b.Password)
	objectMap["type"] = HTTPAuthenticationTypeBasic
	populate(objectMap, "username", b.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BasicAuthentication.
func (b *BasicAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &b.Password)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &b.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientCertAuthentication.
func (c ClientCertAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "certificateExpirationDate", c.CertificateExpirationDate)
	populate(objectMap, "certificateSubjectName", c.CertificateSubjectName)
	populate(objectMap, "certificateThumbprint", c.CertificateThumbprint)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "pfx", c.Pfx)
	objectMap["type"] = HTTPAuthenticationTypeClientCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientCertAuthentication.
func (c *ClientCertAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateExpirationDate":
			err = unpopulateTimeRFC3339(val, "CertificateExpirationDate", &c.CertificateExpirationDate)
			delete(rawMsg, key)
		case "certificateSubjectName":
			err = unpopulate(val, "CertificateSubjectName", &c.CertificateSubjectName)
			delete(rawMsg, key)
		case "certificateThumbprint":
			err = unpopulate(val, "CertificateThumbprint", &c.CertificateThumbprint)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "pfx":
			err = unpopulate(val, "Pfx", &c.Pfx)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRequest.
func (h HTTPRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authentication", h.Authentication)
	populate(objectMap, "body", h.Body)
	populate(objectMap, "headers", h.Headers)
	populate(objectMap, "method", h.Method)
	populate(objectMap, "uri", h.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRequest.
func (h *HTTPRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			h.Authentication, err = unmarshalHTTPAuthenticationClassification(val)
			delete(rawMsg, key)
		case "body":
			err = unpopulate(val, "Body", &h.Body)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &h.Method)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &h.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionDefinition.
func (j JobCollectionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobDefinition.
func (j JobDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobHistoryDefinitionProperties.
func (j *JobHistoryDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &j.ActionName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "expectedExecutionTime":
			err = unpopulateTimeRFC3339(val, "ExpectedExecutionTime", &j.ExpectedExecutionTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		case "repeatCount":
			err = unpopulate(val, "RepeatCount", &j.RepeatCount)
			delete(rawMsg, key)
		case "retryCount":
			err = unpopulate(val, "RetryCount", &j.RetryCount)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", j.Action)
	populate(objectMap, "recurrence", j.Recurrence)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "state", j.State)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &j.Action)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &j.Recurrence)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobRecurrence.
func (j JobRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "count", j.Count)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "frequency", j.Frequency)
	populate(objectMap, "interval", j.Interval)
	populate(objectMap, "schedule", j.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobRecurrence.
func (j *JobRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &j.Count)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &j.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &j.Interval)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &j.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobRecurrenceSchedule.
func (j JobRecurrenceSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hours", j.Hours)
	populate(objectMap, "minutes", j.Minutes)
	populate(objectMap, "monthDays", j.MonthDays)
	populate(objectMap, "monthlyOccurrences", j.MonthlyOccurrences)
	populate(objectMap, "weekDays", j.WeekDays)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobStatus.
func (j JobStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "executionCount", j.ExecutionCount)
	populate(objectMap, "failureCount", j.FailureCount)
	populate(objectMap, "faultedCount", j.FaultedCount)
	populateTimeRFC3339(objectMap, "lastExecutionTime", j.LastExecutionTime)
	populateTimeRFC3339(objectMap, "nextExecutionTime", j.NextExecutionTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStatus.
func (j *JobStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executionCount":
			err = unpopulate(val, "ExecutionCount", &j.ExecutionCount)
			delete(rawMsg, key)
		case "failureCount":
			err = unpopulate(val, "FailureCount", &j.FailureCount)
			delete(rawMsg, key)
		case "faultedCount":
			err = unpopulate(val, "FaultedCount", &j.FaultedCount)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateTimeRFC3339(val, "LastExecutionTime", &j.LastExecutionTime)
			delete(rawMsg, key)
		case "nextExecutionTime":
			err = unpopulateTimeRFC3339(val, "NextExecutionTime", &j.NextExecutionTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OAuthAuthentication.
func (o OAuthAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audience", o.Audience)
	populate(objectMap, "clientId", o.ClientID)
	populate(objectMap, "secret", o.Secret)
	populate(objectMap, "tenant", o.Tenant)
	objectMap["type"] = HTTPAuthenticationTypeActiveDirectoryOAuth
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OAuthAuthentication.
func (o *OAuthAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audience":
			err = unpopulate(val, "Audience", &o.Audience)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &o.ClientID)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &o.Secret)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &o.Tenant)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusBrokeredMessageProperties.
func (s ServiceBusBrokeredMessageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "correlationId", s.CorrelationID)
	populate(objectMap, "forcePersistence", s.ForcePersistence)
	populate(objectMap, "label", s.Label)
	populate(objectMap, "messageId", s.MessageID)
	populate(objectMap, "partitionKey", s.PartitionKey)
	populate(objectMap, "replyTo", s.ReplyTo)
	populate(objectMap, "replyToSessionId", s.ReplyToSessionID)
	populateTimeRFC3339(objectMap, "scheduledEnqueueTimeUtc", s.ScheduledEnqueueTimeUTC)
	populate(objectMap, "sessionId", s.SessionID)
	populate(objectMap, "timeToLive", s.TimeToLive)
	populate(objectMap, "to", s.To)
	populate(objectMap, "viaPartitionKey", s.ViaPartitionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusBrokeredMessageProperties.
func (s *ServiceBusBrokeredMessageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "forcePersistence":
			err = unpopulate(val, "ForcePersistence", &s.ForcePersistence)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &s.Label)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &s.MessageID)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &s.PartitionKey)
			delete(rawMsg, key)
		case "replyTo":
			err = unpopulate(val, "ReplyTo", &s.ReplyTo)
			delete(rawMsg, key)
		case "replyToSessionId":
			err = unpopulate(val, "ReplyToSessionID", &s.ReplyToSessionID)
			delete(rawMsg, key)
		case "scheduledEnqueueTimeUtc":
			err = unpopulateTimeRFC3339(val, "ScheduledEnqueueTimeUTC", &s.ScheduledEnqueueTimeUTC)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &s.SessionID)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &s.TimeToLive)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &s.To)
			delete(rawMsg, key)
		case "viaPartitionKey":
			err = unpopulate(val, "ViaPartitionKey", &s.ViaPartitionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusMessage.
func (s ServiceBusMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "brokeredMessageProperties", s.BrokeredMessageProperties)
	populate(objectMap, "customMessageProperties", s.CustomMessageProperties)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "transportType", s.TransportType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueMessage.
func (s ServiceBusQueueMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "brokeredMessageProperties", s.BrokeredMessageProperties)
	populate(objectMap, "customMessageProperties", s.CustomMessageProperties)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "transportType", s.TransportType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicMessage.
func (s ServiceBusTopicMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authentication", s.Authentication)
	populate(objectMap, "brokeredMessageProperties", s.BrokeredMessageProperties)
	populate(objectMap, "customMessageProperties", s.CustomMessageProperties)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "topicPath", s.TopicPath)
	populate(objectMap, "transportType", s.TransportType)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
