//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpeering

import "time"

// BandwidthOffer - The properties that define a peering bandwidth offer.
type BandwidthOffer struct {
	// The name of the bandwidth offer.
	OfferName *string `json:"offerName,omitempty"`

	// The value of the bandwidth offer in Mbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// BgpSession - The properties that define a BGP session.
type BgpSession struct {
	// The MD5 authentication key of the session.
	MD5AuthenticationKey *string `json:"md5AuthenticationKey,omitempty"`

	// The maximum number of prefixes advertised over the IPv4 session.
	MaxPrefixesAdvertisedV4 *int32 `json:"maxPrefixesAdvertisedV4,omitempty"`

	// The maximum number of prefixes advertised over the IPv6 session.
	MaxPrefixesAdvertisedV6 *int32 `json:"maxPrefixesAdvertisedV6,omitempty"`

	// The IPv4 session address on Microsoft's end.
	MicrosoftSessionIPv4Address *string `json:"microsoftSessionIPv4Address,omitempty"`

	// The IPv6 session address on Microsoft's end.
	MicrosoftSessionIPv6Address *string `json:"microsoftSessionIPv6Address,omitempty"`

	// The IPv4 session address on peer's end.
	PeerSessionIPv4Address *string `json:"peerSessionIPv4Address,omitempty"`

	// The IPv6 session address on peer's end.
	PeerSessionIPv6Address *string `json:"peerSessionIPv6Address,omitempty"`

	// The IPv4 prefix that contains both ends' IPv4 addresses.
	SessionPrefixV4 *string `json:"sessionPrefixV4,omitempty"`

	// The IPv6 prefix that contains both ends' IPv6 addresses.
	SessionPrefixV6 *string `json:"sessionPrefixV6,omitempty"`

	// READ-ONLY; The state of the IPv4 session.
	SessionStateV4 *SessionStateV4 `json:"sessionStateV4,omitempty" azure:"ro"`

	// READ-ONLY; The state of the IPv6 session.
	SessionStateV6 *SessionStateV6 `json:"sessionStateV6,omitempty" azure:"ro"`
}

// CdnPeeringPrefix - The CDN peering prefix
type CdnPeeringPrefix struct {
	// The properties that define a cdn peering prefix.
	Properties *CdnPeeringPrefixProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CdnPeeringPrefixListResult - The paginated list of CDN peering prefixes.
type CdnPeeringPrefixListResult struct {
	// The link to fetch the next page of CDN peering prefixes.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of CDN peering prefixes.
	Value []*CdnPeeringPrefix `json:"value,omitempty"`
}

// CdnPeeringPrefixProperties - The properties that define a CDN peering prefix
type CdnPeeringPrefixProperties struct {
	// READ-ONLY; The Azure region.
	AzureRegion *string `json:"azureRegion,omitempty" azure:"ro"`

	// READ-ONLY; The Azure service.
	AzureService *string `json:"azureService,omitempty" azure:"ro"`

	// READ-ONLY; The BGP Community
	BgpCommunity *string `json:"bgpCommunity,omitempty" azure:"ro"`

	// READ-ONLY; The flag that indicates whether or not this is the primary region.
	IsPrimaryRegion *bool `json:"isPrimaryRegion,omitempty" azure:"ro"`

	// READ-ONLY; The prefix.
	Prefix *string `json:"prefix,omitempty" azure:"ro"`
}

// CdnPeeringPrefixesClientListOptions contains the optional parameters for the CdnPeeringPrefixesClient.List method.
type CdnPeeringPrefixesClientListOptions struct {
	// placeholder for future optional parameters
}

// CheckServiceProviderAvailabilityInput - Class for CheckServiceProviderAvailabilityInput
type CheckServiceProviderAvailabilityInput struct {
	// Gets or sets the peering service location.
	PeeringServiceLocation *string `json:"peeringServiceLocation,omitempty"`

	// Gets or sets the peering service provider.
	PeeringServiceProvider *string `json:"peeringServiceProvider,omitempty"`
}

// ConnectionMonitorTest - The Connection Monitor Test class.
type ConnectionMonitorTest struct {
	// The properties that define a Connection Monitor Test.
	Properties *ConnectionMonitorTestProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectionMonitorTestListResult - The paginated list of [T].
type ConnectionMonitorTestListResult struct {
	// The link to fetch the next page of [T].
	NextLink *string `json:"nextLink,omitempty"`

	// The list of [T].
	Value []*ConnectionMonitorTest `json:"value,omitempty"`
}

// ConnectionMonitorTestProperties - The properties that define a Connection Monitor Test.
type ConnectionMonitorTestProperties struct {
	// The Connection Monitor test destination
	Destination *string `json:"destination,omitempty"`

	// The Connection Monitor test destination port
	DestinationPort *int32 `json:"destinationPort,omitempty"`

	// The Connection Monitor test source agent
	SourceAgent *string `json:"sourceAgent,omitempty"`

	// The Connection Monitor test frequency in seconds
	TestFrequencyInSec *int32 `json:"testFrequencyInSec,omitempty"`

	// READ-ONLY; The flag that indicates if the Connection Monitor test is successful or not.
	IsTestSuccessful *bool `json:"isTestSuccessful,omitempty" azure:"ro"`

	// READ-ONLY; The path representing the Connection Monitor test.
	Path []*string `json:"path,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ConnectionMonitorTestsClientCreateOrUpdateOptions contains the optional parameters for the ConnectionMonitorTestsClient.CreateOrUpdate
// method.
type ConnectionMonitorTestsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectionMonitorTestsClientDeleteOptions contains the optional parameters for the ConnectionMonitorTestsClient.Delete
// method.
type ConnectionMonitorTestsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectionMonitorTestsClientGetOptions contains the optional parameters for the ConnectionMonitorTestsClient.Get method.
type ConnectionMonitorTestsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectionMonitorTestsClientListByPeeringServiceOptions contains the optional parameters for the ConnectionMonitorTestsClient.ListByPeeringService
// method.
type ConnectionMonitorTestsClientListByPeeringServiceOptions struct {
	// placeholder for future optional parameters
}

// ContactDetail - The contact detail class.
type ContactDetail struct {
	// The e-mail address of the contact.
	Email *string `json:"email,omitempty"`

	// The phone number of the contact.
	Phone *string `json:"phone,omitempty"`

	// The role of the contact.
	Role *Role `json:"role,omitempty"`
}

// DirectConnection - The properties that define a direct connection.
type DirectConnection struct {
	// The bandwidth of the connection.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`

	// The BGP session associated with the connection.
	BgpSession *BgpSession `json:"bgpSession,omitempty"`

	// The unique identifier (GUID) for the connection.
	ConnectionIdentifier *string `json:"connectionIdentifier,omitempty"`

	// The PeeringDB.com ID of the facility at which the connection has to be set up.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`

	// The field indicating if Microsoft provides session ip addresses.
	SessionAddressProvider *SessionAddressProvider `json:"sessionAddressProvider,omitempty"`

	// The flag that indicates whether or not the connection is used for peering service.
	UseForPeeringService *bool `json:"useForPeeringService,omitempty"`

	// READ-ONLY; The state of the connection.
	ConnectionState *ConnectionState `json:"connectionState,omitempty" azure:"ro"`

	// READ-ONLY; The error message related to the connection state, if any.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The ID used within Microsoft's peering provisioning system to track the connection
	MicrosoftTrackingID *string `json:"microsoftTrackingId,omitempty" azure:"ro"`

	// READ-ONLY; The bandwidth that is actually provisioned.
	ProvisionedBandwidthInMbps *int32 `json:"provisionedBandwidthInMbps,omitempty" azure:"ro"`
}

// DirectPeeringFacility - The properties that define a direct peering facility.
type DirectPeeringFacility struct {
	// The address of the direct peering facility.
	Address *string `json:"address,omitempty"`

	// The type of the direct peering.
	DirectPeeringType *DirectPeeringType `json:"directPeeringType,omitempty"`

	// The PeeringDB.com ID of the facility.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`

	// The PeeringDB.com URL of the facility.
	PeeringDBFacilityLink *string `json:"peeringDBFacilityLink,omitempty"`
}

// ErrorDetail - The error detail that describes why an operation has failed.
type ErrorDetail struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponse - The error response that indicates why an operation has failed.
type ErrorResponse struct {
	// The error detail that describes why an operation has failed.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExchangeConnection - The properties that define an exchange connection.
type ExchangeConnection struct {
	// The BGP session associated with the connection.
	BgpSession *BgpSession `json:"bgpSession,omitempty"`

	// The unique identifier (GUID) for the connection.
	ConnectionIdentifier *string `json:"connectionIdentifier,omitempty"`

	// The PeeringDB.com ID of the facility at which the connection has to be set up.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`

	// READ-ONLY; The state of the connection.
	ConnectionState *ConnectionState `json:"connectionState,omitempty" azure:"ro"`

	// READ-ONLY; The error message related to the connection state, if any.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`
}

// ExchangePeeringFacility - The properties that define an exchange peering facility.
type ExchangePeeringFacility struct {
	// The bandwidth of the connection between Microsoft and the exchange peering facility.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`

	// The name of the exchange peering facility.
	ExchangeName *string `json:"exchangeName,omitempty"`

	// The IPv4 prefixes associated with the exchange peering facility.
	FacilityIPv4Prefix *string `json:"facilityIPv4Prefix,omitempty"`

	// The IPv6 prefixes associated with the exchange peering facility.
	FacilityIPv6Prefix *string `json:"facilityIPv6Prefix,omitempty"`

	// The IPv4 address of Microsoft at the exchange peering facility.
	MicrosoftIPv4Address *string `json:"microsoftIPv4Address,omitempty"`

	// The IPv6 address of Microsoft at the exchange peering facility.
	MicrosoftIPv6Address *string `json:"microsoftIPv6Address,omitempty"`

	// The PeeringDB.com ID of the facility.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`

	// The PeeringDB.com URL of the facility.
	PeeringDBFacilityLink *string `json:"peeringDBFacilityLink,omitempty"`
}

// LegacyPeeringsClientListOptions contains the optional parameters for the LegacyPeeringsClient.List method.
type LegacyPeeringsClientListOptions struct {
	// The ASN number associated with a legacy peering.
	Asn *int32
}

// ListResult - The paginated list of peerings.
type ListResult struct {
	// The link to fetch the next page of peerings.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peerings.
	Value []*Peering `json:"value,omitempty"`
}

// Location - Peering location is where connectivity could be established to the Microsoft Cloud Edge.
type Location struct {
	// The kind of peering that the peering location supports.
	Kind *Kind `json:"kind,omitempty"`

	// The properties that define a peering location.
	Properties *LocationProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LocationListResult - The paginated list of peering locations.
type LocationListResult struct {
	// The link to fetch the next page of peering locations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering locations.
	Value []*Location `json:"value,omitempty"`
}

// LocationProperties - The properties that define a peering location.
type LocationProperties struct {
	// The Azure region associated with the peering location.
	AzureRegion *string `json:"azureRegion,omitempty"`

	// The country in which the peering location exists.
	Country *string `json:"country,omitempty"`

	// The properties that define a direct peering location.
	Direct *LocationPropertiesDirect `json:"direct,omitempty"`

	// The properties that define an exchange peering location.
	Exchange *LocationPropertiesExchange `json:"exchange,omitempty"`

	// The name of the peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
}

// LocationPropertiesDirect - The properties that define a direct peering location.
type LocationPropertiesDirect struct {
	// The list of bandwidth offers available at the peering location.
	BandwidthOffers []*BandwidthOffer `json:"bandwidthOffers,omitempty"`

	// The list of direct peering facilities at the peering location.
	PeeringFacilities []*DirectPeeringFacility `json:"peeringFacilities,omitempty"`
}

// LocationPropertiesExchange - The properties that define an exchange peering location.
type LocationPropertiesExchange struct {
	// The list of exchange peering facilities at the peering location.
	PeeringFacilities []*ExchangePeeringFacility `json:"peeringFacilities,omitempty"`
}

// LocationsClientListOptions contains the optional parameters for the LocationsClient.List method.
type LocationsClientListOptions struct {
	// The type of direct peering.
	DirectPeeringType *PeeringLocationsDirectPeeringType
}

// LogAnalyticsWorkspaceProperties - The properties that define a Log Analytics Workspace.
type LogAnalyticsWorkspaceProperties struct {
	// READ-ONLY; The list of connected agents.
	ConnectedAgents []*string `json:"connectedAgents,omitempty" azure:"ro"`

	// READ-ONLY; The Workspace Key.
	Key *string `json:"key,omitempty" azure:"ro"`

	// READ-ONLY; The Workspace ID.
	WorkspaceID *string `json:"workspaceID,omitempty" azure:"ro"`
}

// LookingGlassClientInvokeOptions contains the optional parameters for the LookingGlassClient.Invoke method.
type LookingGlassClientInvokeOptions struct {
	// placeholder for future optional parameters
}

// LookingGlassOutput - Looking glass output model
type LookingGlassOutput struct {
	// Invoked command
	Command *Command `json:"command,omitempty"`

	// Output of the command
	Output *string `json:"output,omitempty"`
}

// ManagementClientCheckServiceProviderAvailabilityOptions contains the optional parameters for the ManagementClient.CheckServiceProviderAvailability
// method.
type ManagementClientCheckServiceProviderAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// MetricDimension - Dimensions of the metric.
type MetricDimension struct {
	// READ-ONLY; Localized friendly display name of the dimension.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the dimension.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring.
type MetricSpecification struct {
	// READ-ONLY; Aggregation type will be set to one of the values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty" azure:"ro"`

	// READ-ONLY; Dimensions of the metric.
	Dimensions []*MetricDimension `json:"dimensions,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly display name of the metric.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the metric.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Supported time grain types for the metric.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty" azure:"ro"`

	// READ-ONLY; Unit that makes sense for the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// Operation - The peering API operation.
type Operation struct {
	// READ-ONLY; The information related to the operation.
	Display *OperationDisplayInfo `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of the operation.
	Properties *OperationProperties `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplayInfo - The information related to the operation.
type OperationDisplayInfo struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource provider.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - The paginated list of peering API operations.
type OperationListResult struct {
	// The link to fetch the next page of peering API operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering API operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - The properties of the operation.
type OperationProperties struct {
	// READ-ONLY; Service specification payload.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PeerAsn - The essential information related to the peer's ASN.
type PeerAsn struct {
	// The properties that define a peer's ASN.
	Properties *PeerAsnProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PeerAsnListResult - The paginated list of peer ASNs.
type PeerAsnListResult struct {
	// The link to fetch the next page of peer ASNs.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peer ASNs.
	Value []*PeerAsn `json:"value,omitempty"`
}

// PeerAsnProperties - The properties that define a peer's ASN.
type PeerAsnProperties struct {
	// The Autonomous System Number (ASN) of the peer.
	PeerAsn *int32 `json:"peerAsn,omitempty"`

	// The contact details of the peer.
	PeerContactDetail []*ContactDetail `json:"peerContactDetail,omitempty"`

	// The name of the peer.
	PeerName *string `json:"peerName,omitempty"`

	// READ-ONLY; The error message for the validation state
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The validation state of the ASN associated with the peer.
	ValidationState *ValidationState `json:"validationState,omitempty" azure:"ro"`
}

// PeerAsnsClientCreateOrUpdateOptions contains the optional parameters for the PeerAsnsClient.CreateOrUpdate method.
type PeerAsnsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PeerAsnsClientDeleteOptions contains the optional parameters for the PeerAsnsClient.Delete method.
type PeerAsnsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PeerAsnsClientGetOptions contains the optional parameters for the PeerAsnsClient.Get method.
type PeerAsnsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PeerAsnsClientListBySubscriptionOptions contains the optional parameters for the PeerAsnsClient.ListBySubscription method.
type PeerAsnsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.
type Peering struct {
	// REQUIRED; The kind of the peering.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU that defines the tier and kind of the peering.
	SKU *SKU `json:"sku,omitempty"`

	// The properties that define a peering.
	Properties *Properties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PeeringsClientCreateOrUpdateOptions contains the optional parameters for the PeeringsClient.CreateOrUpdate method.
type PeeringsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PeeringsClientDeleteOptions contains the optional parameters for the PeeringsClient.Delete method.
type PeeringsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PeeringsClientGetOptions contains the optional parameters for the PeeringsClient.Get method.
type PeeringsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PeeringsClientListByResourceGroupOptions contains the optional parameters for the PeeringsClient.ListByResourceGroup method.
type PeeringsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PeeringsClientListBySubscriptionOptions contains the optional parameters for the PeeringsClient.ListBySubscription method.
type PeeringsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PeeringsClientUpdateOptions contains the optional parameters for the PeeringsClient.Update method.
type PeeringsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrefixesClientCreateOrUpdateOptions contains the optional parameters for the PrefixesClient.CreateOrUpdate method.
type PrefixesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrefixesClientDeleteOptions contains the optional parameters for the PrefixesClient.Delete method.
type PrefixesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrefixesClientGetOptions contains the optional parameters for the PrefixesClient.Get method.
type PrefixesClientGetOptions struct {
	// The properties to be expanded.
	Expand *string
}

// PrefixesClientListByPeeringServiceOptions contains the optional parameters for the PrefixesClient.ListByPeeringService
// method.
type PrefixesClientListByPeeringServiceOptions struct {
	// The properties to be expanded.
	Expand *string
}

// Properties - The properties that define connectivity to the Microsoft Cloud Edge.
type Properties struct {
	// The properties that define a direct peering.
	Direct *PropertiesDirect `json:"direct,omitempty"`

	// The properties that define an exchange peering.
	Exchange *PropertiesExchange `json:"exchange,omitempty"`

	// The location of the peering.
	PeeringLocation *string `json:"peeringLocation,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PropertiesDirect - The properties that define a direct peering.
type PropertiesDirect struct {
	// The set of connections that constitute a direct peering.
	Connections []*DirectConnection `json:"connections,omitempty"`

	// The type of direct peering.
	DirectPeeringType *DirectPeeringType `json:"directPeeringType,omitempty"`

	// The reference of the peer ASN.
	PeerAsn *SubResource `json:"peerAsn,omitempty"`

	// READ-ONLY; The flag that indicates whether or not the peering is used for peering service.
	UseForPeeringService *bool `json:"useForPeeringService,omitempty" azure:"ro"`
}

// PropertiesExchange - The properties that define an exchange peering.
type PropertiesExchange struct {
	// The set of connections that constitute an exchange peering.
	Connections []*ExchangeConnection `json:"connections,omitempty"`

	// The reference of the peer ASN.
	PeerAsn *SubResource `json:"peerAsn,omitempty"`
}

// ReceivedRoute - The properties that define a received route.
type ReceivedRoute struct {
	// READ-ONLY; The AS path for the prefix.
	AsPath *string `json:"asPath,omitempty" azure:"ro"`

	// READ-ONLY; The next hop for the prefix.
	NextHop *string `json:"nextHop,omitempty" azure:"ro"`

	// READ-ONLY; The origin AS change information for the prefix.
	OriginAsValidationState *string `json:"originAsValidationState,omitempty" azure:"ro"`

	// READ-ONLY; The prefix.
	Prefix *string `json:"prefix,omitempty" azure:"ro"`

	// READ-ONLY; The received timestamp associated with the prefix.
	ReceivedTimestamp *string `json:"receivedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The RPKI validation state for the prefix and origin AS that's listed in the AS path.
	RpkiValidationState *string `json:"rpkiValidationState,omitempty" azure:"ro"`

	// READ-ONLY; The authority which holds the Route Origin Authorization record for the prefix, if any.
	TrustAnchor *string `json:"trustAnchor,omitempty" azure:"ro"`
}

// ReceivedRouteListResult - The paginated list of received routes for the peering.
type ReceivedRouteListResult struct {
	// The link to fetch the next page of received routes for the peering.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of received routes for the peering.
	Value []*ReceivedRoute `json:"value,omitempty"`
}

// ReceivedRoutesClientListByPeeringOptions contains the optional parameters for the ReceivedRoutesClient.ListByPeering method.
type ReceivedRoutesClientListByPeeringOptions struct {
	// The optional AS path that can be used to filter the routes.
	AsPath *string
	// The optional origin AS validation state that can be used to filter the routes.
	OriginAsValidationState *string
	// The optional prefix that can be used to filter the routes.
	Prefix *string
	// The optional RPKI validation state that can be used to filter the routes.
	RpkiValidationState *string
	// The optional page continuation token that is used in the event of paginated result.
	SkipToken *string
}

// RegisteredAsn - The customer's ASN that is registered by the peering service provider.
type RegisteredAsn struct {
	// The properties that define a registered ASN.
	Properties *RegisteredAsnProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegisteredAsnListResult - The paginated list of peering registered ASNs.
type RegisteredAsnListResult struct {
	// The link to fetch the next page of peering registered ASNs.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering registered ASNs.
	Value []*RegisteredAsn `json:"value,omitempty"`
}

// RegisteredAsnProperties - The properties that define a registered ASN.
type RegisteredAsnProperties struct {
	// The customer's ASN from which traffic originates.
	Asn *int32 `json:"asn,omitempty"`

	// READ-ONLY; The peering service prefix key that is to be shared with the customer.
	PeeringServicePrefixKey *string `json:"peeringServicePrefixKey,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RegisteredAsnsClientCreateOrUpdateOptions contains the optional parameters for the RegisteredAsnsClient.CreateOrUpdate
// method.
type RegisteredAsnsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// RegisteredAsnsClientDeleteOptions contains the optional parameters for the RegisteredAsnsClient.Delete method.
type RegisteredAsnsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RegisteredAsnsClientGetOptions contains the optional parameters for the RegisteredAsnsClient.Get method.
type RegisteredAsnsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegisteredAsnsClientListByPeeringOptions contains the optional parameters for the RegisteredAsnsClient.ListByPeering method.
type RegisteredAsnsClientListByPeeringOptions struct {
	// placeholder for future optional parameters
}

// RegisteredPrefix - The customer's prefix that is registered by the peering service provider.
type RegisteredPrefix struct {
	// The properties that define a registered prefix.
	Properties *RegisteredPrefixProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegisteredPrefixListResult - The paginated list of peering registered prefixes.
type RegisteredPrefixListResult struct {
	// The link to fetch the next page of peering registered prefixes.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering registered prefixes.
	Value []*RegisteredPrefix `json:"value,omitempty"`
}

// RegisteredPrefixProperties - The properties that define a registered prefix.
type RegisteredPrefixProperties struct {
	// The customer's prefix from which traffic originates.
	Prefix *string `json:"prefix,omitempty"`

	// READ-ONLY; The error message associated with the validation state, if any.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The peering service prefix key that is to be shared with the customer.
	PeeringServicePrefixKey *string `json:"peeringServicePrefixKey,omitempty" azure:"ro"`

	// READ-ONLY; The prefix validation state.
	PrefixValidationState *PrefixValidationState `json:"prefixValidationState,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RegisteredPrefixesClientCreateOrUpdateOptions contains the optional parameters for the RegisteredPrefixesClient.CreateOrUpdate
// method.
type RegisteredPrefixesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// RegisteredPrefixesClientDeleteOptions contains the optional parameters for the RegisteredPrefixesClient.Delete method.
type RegisteredPrefixesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RegisteredPrefixesClientGetOptions contains the optional parameters for the RegisteredPrefixesClient.Get method.
type RegisteredPrefixesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegisteredPrefixesClientListByPeeringOptions contains the optional parameters for the RegisteredPrefixesClient.ListByPeering
// method.
type RegisteredPrefixesClientListByPeeringOptions struct {
	// placeholder for future optional parameters
}

// Resource - The ARM resource class.
type Resource struct {
	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceTags - The resource tags.
type ResourceTags struct {
	// Gets or sets the tags, a dictionary of descriptors arm object
	Tags map[string]*string `json:"tags,omitempty"`
}

// SKU - The SKU that defines the tier and kind of the peering.
type SKU struct {
	// The name of the peering SKU.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The family of the peering SKU.
	Family *Family `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The size of the peering SKU.
	Size *Size `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; The tier of the peering SKU.
	Tier *Tier `json:"tier,omitempty" azure:"ro"`
}

// Service - Peering Service
type Service struct {
	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// The properties that define a peering service.
	Properties *ServiceProperties `json:"properties,omitempty"`

	// The SKU that defines the type of the peering service.
	SKU *ServiceSKU `json:"sku,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceCountriesClientListOptions contains the optional parameters for the ServiceCountriesClient.List method.
type ServiceCountriesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceCountry - The peering service country.
type ServiceCountry struct {
	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceCountryListResult - The paginated list of peering service countries.
type ServiceCountryListResult struct {
	// The link to fetch the next page of peering service countries.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering service countries.
	Value []*ServiceCountry `json:"value,omitempty"`
}

// ServiceListResult - The paginated list of peering services.
type ServiceListResult struct {
	// The link to fetch the next page of peering services.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering services.
	Value []*Service `json:"value,omitempty"`
}

// ServiceLocation - The peering service location.
type ServiceLocation struct {
	// The properties that define a peering service location.
	Properties *ServiceLocationProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceLocationListResult - The paginated list of peering service locations.
type ServiceLocationListResult struct {
	// The link to fetch the next page of peering service locations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering service locations.
	Value []*ServiceLocation `json:"value,omitempty"`
}

// ServiceLocationProperties - The properties that define connectivity to the Peering Service Location.
type ServiceLocationProperties struct {
	// Azure region for the location
	AzureRegion *string `json:"azureRegion,omitempty"`

	// Country of the customer
	Country *string `json:"country,omitempty"`

	// State of the customer
	State *string `json:"state,omitempty"`
}

// ServiceLocationsClientListOptions contains the optional parameters for the ServiceLocationsClient.List method.
type ServiceLocationsClientListOptions struct {
	// The country of interest, in which the locations are to be present.
	Country *string
}

// ServicePrefix - The peering service prefix class.
type ServicePrefix struct {
	// Gets or sets the peering prefix properties.
	Properties *ServicePrefixProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicePrefixEvent - The details of the event associated with a prefix.
type ServicePrefixEvent struct {
	// READ-ONLY; The description of the event associated with a prefix.
	EventDescription *string `json:"eventDescription,omitempty" azure:"ro"`

	// READ-ONLY; The level of the event associated with a prefix.
	EventLevel *string `json:"eventLevel,omitempty" azure:"ro"`

	// READ-ONLY; The summary of the event associated with a prefix.
	EventSummary *string `json:"eventSummary,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of the event associated with a prefix.
	EventTimestamp *time.Time `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The type of the event associated with a prefix.
	EventType *string `json:"eventType,omitempty" azure:"ro"`
}

// ServicePrefixListResult - The paginated list of peering service prefixes.
type ServicePrefixListResult struct {
	// The link to fetch the next page of peering service prefixes.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering service prefixes.
	Value []*ServicePrefix `json:"value,omitempty"`
}

// ServicePrefixProperties - The peering service prefix properties class.
type ServicePrefixProperties struct {
	// The peering service prefix key
	PeeringServicePrefixKey *string `json:"peeringServicePrefixKey,omitempty"`

	// The prefix from which your traffic originates.
	Prefix *string `json:"prefix,omitempty"`

	// READ-ONLY; The error message for validation state
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The list of events for peering service prefix
	Events []*ServicePrefixEvent `json:"events,omitempty" azure:"ro"`

	// READ-ONLY; The prefix learned type
	LearnedType *LearnedType `json:"learnedType,omitempty" azure:"ro"`

	// READ-ONLY; The prefix validation state
	PrefixValidationState *PrefixValidationState `json:"prefixValidationState,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceProperties - The properties that define connectivity to the Peering Service.
type ServiceProperties struct {
	// The Log Analytics Workspace Properties
	LogAnalyticsWorkspaceProperties *LogAnalyticsWorkspaceProperties `json:"logAnalyticsWorkspaceProperties,omitempty"`

	// The location (state/province) of the customer.
	PeeringServiceLocation *string `json:"peeringServiceLocation,omitempty"`

	// The name of the service provider.
	PeeringServiceProvider *string `json:"peeringServiceProvider,omitempty"`

	// The backup peering (Microsoft/service provider) location to be used for customer traffic.
	ProviderBackupPeeringLocation *string `json:"providerBackupPeeringLocation,omitempty"`

	// The primary peering (Microsoft/service provider) location to be used for customer traffic.
	ProviderPrimaryPeeringLocation *string `json:"providerPrimaryPeeringLocation,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceProvider - PeeringService provider
type ServiceProvider struct {
	// The properties that define a peering service provider.
	Properties *ServiceProviderProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceProviderListResult - The paginated list of peering service providers.
type ServiceProviderListResult struct {
	// The link to fetch the next page of peering service providers.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of peering service providers.
	Value []*ServiceProvider `json:"value,omitempty"`
}

// ServiceProviderProperties - The properties that define connectivity to the Peering Service Provider.
type ServiceProviderProperties struct {
	// The list of locations at which the service provider peers with Microsoft.
	PeeringLocations []*string `json:"peeringLocations,omitempty"`

	// The name of the service provider.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
}

// ServiceProvidersClientListOptions contains the optional parameters for the ServiceProvidersClient.List method.
type ServiceProvidersClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceSKU - The SKU that defines the type of the peering service.
type ServiceSKU struct {
	// The name of the peering service SKU.
	Name *string `json:"name,omitempty"`
}

// ServiceSpecification - Service specification payload.
type ServiceSpecification struct {
	// READ-ONLY; Specifications of the Metrics for Azure Monitoring.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty" azure:"ro"`
}

// ServicesClientCreateOrUpdateOptions contains the optional parameters for the ServicesClient.CreateOrUpdate method.
type ServicesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientDeleteOptions contains the optional parameters for the ServicesClient.Delete method.
type ServicesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientInitializeConnectionMonitorOptions contains the optional parameters for the ServicesClient.InitializeConnectionMonitor
// method.
type ServicesClientInitializeConnectionMonitorOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListByResourceGroupOptions contains the optional parameters for the ServicesClient.ListByResourceGroup method.
type ServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListBySubscriptionOptions contains the optional parameters for the ServicesClient.ListBySubscription method.
type ServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientUpdateOptions contains the optional parameters for the ServicesClient.Update method.
type ServicesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SubResource - The sub resource.
type SubResource struct {
	// The identifier of the referenced resource.
	ID *string `json:"id,omitempty"`
}
