//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import "time"

// AbsoluteDeleteOption - Delete option with duration
type AbsoluteDeleteOption struct {
	// REQUIRED; Duration of deletion after given timespan
	Duration *string `json:"duration,omitempty"`

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetDeleteOption implements the DeleteOptionClassification interface for type AbsoluteDeleteOption.
func (a *AbsoluteDeleteOption) GetDeleteOption() *DeleteOption {
	return &DeleteOption{
		Duration:   a.Duration,
		ObjectType: a.ObjectType,
	}
}

// AdHocBackupRuleOptions - Adhoc backup rules
type AdHocBackupRuleOptions struct {
	// REQUIRED
	RuleName *string `json:"ruleName,omitempty"`

	// REQUIRED; Adhoc backup trigger option
	TriggerOption *AdhocBackupTriggerOption `json:"triggerOption,omitempty"`
}

// AdhocBackupTriggerOption - Adhoc backup trigger option
type AdhocBackupTriggerOption struct {
	RetentionTagOverride *string `json:"retentionTagOverride,omitempty"`
}

// AdhocBasedTaggingCriteria - Adhoc backup tagging criteria
type AdhocBasedTaggingCriteria struct {
	// Retention tag information
	TagInfo *RetentionTag `json:"tagInfo,omitempty"`
}

// AdhocBasedTriggerContext - Adhoc trigger context
type AdhocBasedTriggerContext struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Tagging Criteria containing retention tag for adhoc backup.
	TaggingCriteria *AdhocBasedTaggingCriteria `json:"taggingCriteria,omitempty"`
}

// GetTriggerContext implements the TriggerContextClassification interface for type AdhocBasedTriggerContext.
func (a *AdhocBasedTriggerContext) GetTriggerContext() *TriggerContext {
	return &TriggerContext{
		ObjectType: a.ObjectType,
	}
}

// AuthCredentialsClassification provides polymorphic access to related types.
// Call the interface's GetAuthCredentials() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AuthCredentials, *SecretStoreBasedAuthCredentials
type AuthCredentialsClassification interface {
	// GetAuthCredentials returns the AuthCredentials content of the underlying type.
	GetAuthCredentials() *AuthCredentials
}

// AuthCredentials - Base class for different types of authentication credentials.
type AuthCredentials struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetAuthCredentials implements the AuthCredentialsClassification interface for type AuthCredentials.
func (a *AuthCredentials) GetAuthCredentials() *AuthCredentials { return a }

// AzureBackupDiscreteRecoveryPoint - Azure backup discrete RecoveryPoint
type AzureBackupDiscreteRecoveryPoint struct {
	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED
	RecoveryPointTime              *time.Time                       `json:"recoveryPointTime,omitempty"`
	FriendlyName                   *string                          `json:"friendlyName,omitempty"`
	PolicyName                     *string                          `json:"policyName,omitempty"`
	PolicyVersion                  *string                          `json:"policyVersion,omitempty"`
	RecoveryPointDataStoresDetails []*RecoveryPointDataStoreDetails `json:"recoveryPointDataStoresDetails,omitempty"`
	RecoveryPointID                *string                          `json:"recoveryPointId,omitempty"`
	RecoveryPointType              *string                          `json:"recoveryPointType,omitempty"`
	RetentionTagName               *string                          `json:"retentionTagName,omitempty"`
	RetentionTagVersion            *string                          `json:"retentionTagVersion,omitempty"`
}

// GetAzureBackupRecoveryPoint implements the AzureBackupRecoveryPointClassification interface for type AzureBackupDiscreteRecoveryPoint.
func (a *AzureBackupDiscreteRecoveryPoint) GetAzureBackupRecoveryPoint() *AzureBackupRecoveryPoint {
	return &AzureBackupRecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureBackupFindRestorableTimeRangesRequest - List Restore Ranges Request
type AzureBackupFindRestorableTimeRangesRequest struct {
	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *RestoreSourceDataStoreType `json:"sourceDataStoreType,omitempty"`

	// End time for the List Restore Ranges request. ISO 8601 format.
	EndTime *string `json:"endTime,omitempty"`

	// Start time for the List Restore Ranges request. ISO 8601 format.
	StartTime *string `json:"startTime,omitempty"`
}

// AzureBackupFindRestorableTimeRangesRequestResource - List Restore Ranges Request
type AzureBackupFindRestorableTimeRangesRequestResource struct {
	// AzureBackupFindRestorableTimeRangesRequestResource content
	Content     *AzureBackupFindRestorableTimeRangesRequest `json:"content,omitempty"`
	CultureInfo *string                                     `json:"cultureInfo,omitempty"`
	HTTPMethod  *string                                     `json:"httpMethod,omitempty"`

	// Dictionary of
	Headers map[string][]*string `json:"headers,omitempty"`

	// Dictionary of
	Parameters             map[string]*string `json:"parameters,omitempty"`
	SubscriptionID         *string            `json:"subscriptionId,omitempty"`
	SupportedGroupVersions []*string          `json:"supportedGroupVersions,omitempty"`
	URI                    *string            `json:"uri,omitempty"`
}

// AzureBackupFindRestorableTimeRangesResponse - List Restore Ranges Response
type AzureBackupFindRestorableTimeRangesResponse struct {
	ObjectType *string `json:"objectType,omitempty"`

	// Returns the Restore Ranges available on the Backup Instance.
	RestorableTimeRanges []*RestorableTimeRange `json:"restorableTimeRanges,omitempty"`
}

// AzureBackupFindRestorableTimeRangesResponseResource - List Restore Ranges Response
type AzureBackupFindRestorableTimeRangesResponseResource struct {
	// AzureBackupFindRestorableTimeRangesResponseResource properties
	Properties *AzureBackupFindRestorableTimeRangesResponse `json:"properties,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureBackupJob - AzureBackup Job Class
type AzureBackupJob struct {
	// REQUIRED; Job Activity Id
	ActivityID *string `json:"activityID,omitempty"`

	// REQUIRED; Name of the Backup Instance
	BackupInstanceFriendlyName *string `json:"backupInstanceFriendlyName,omitempty"`

	// REQUIRED; ARM ID of the DataSource
	DataSourceID *string `json:"dataSourceId,omitempty"`

	// REQUIRED; Location of the DataSource
	DataSourceLocation *string `json:"dataSourceLocation,omitempty"`

	// REQUIRED; User Friendly Name of the DataSource
	DataSourceName *string `json:"dataSourceName,omitempty"`

	// REQUIRED; Type of DataSource
	DataSourceType *string `json:"dataSourceType,omitempty"`

	// REQUIRED; Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool `json:"isUserTriggered,omitempty"`

	// REQUIRED; It indicates the type of Job i.e. Backup:full/log/diff ;Restore:ALR/OLR; Tiering:Backup/Archive ; Management:ConfigureProtection/UnConfigure
	Operation *string `json:"operation,omitempty"`

	// REQUIRED; It indicates the type of Job i.e. Backup/Restore/Tiering/Management
	OperationCategory *string `json:"operationCategory,omitempty"`

	// REQUIRED; Indicated whether progress is enabled for the job
	ProgressEnabled *bool `json:"progressEnabled,omitempty"`

	// REQUIRED; Resource Group Name of the Datasource
	SourceResourceGroup *string `json:"sourceResourceGroup,omitempty"`

	// REQUIRED; SubscriptionId corresponding to the DataSource
	SourceSubscriptionID *string `json:"sourceSubscriptionID,omitempty"`

	// REQUIRED; StartTime of the job(in UTC)
	StartTime *time.Time `json:"startTime,omitempty"`

	// REQUIRED; Status of the job like InProgress/Success/Failed/Cancelled/SuccessWithWarning
	Status *string `json:"status,omitempty"`

	// REQUIRED; Subscription Id of the corresponding backup vault
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// REQUIRED; List of supported actions
	SupportedActions []*string `json:"supportedActions,omitempty"`

	// REQUIRED; Name of the vault
	VaultName *string `json:"vaultName,omitempty"`

	// Data Source Set Name of the DataSource
	DataSourceSetName        *string `json:"dataSourceSetName,omitempty"`
	DestinationDataStoreName *string `json:"destinationDataStoreName,omitempty"`

	// Total run time of the job. ISO 8601 format.
	Duration            *string `json:"duration,omitempty"`
	Etag                *string `json:"etag,omitempty"`
	SourceDataStoreName *string `json:"sourceDataStoreName,omitempty"`

	// READ-ONLY; ARM ID of the Backup Instance
	BackupInstanceID *string `json:"backupInstanceId,omitempty" azure:"ro"`

	// READ-ONLY; EndTime of the job(in UTC)
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; A List, detailing the errors related to the job
	ErrorDetails []*UserFacingError `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; Extended Information about the job
	ExtendedInfo *JobExtendedInfo `json:"extendedInfo,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the policy
	PolicyID *string `json:"policyId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the policy
	PolicyName *string `json:"policyName,omitempty" azure:"ro"`

	// READ-ONLY; Url which contains job's progress
	ProgressURL *string `json:"progressUrl,omitempty" azure:"ro"`

	// READ-ONLY; It indicates the sub type of operation i.e. in case of Restore it can be ALR/OLR
	RestoreType *string `json:"restoreType,omitempty" azure:"ro"`
}

// AzureBackupJobResource - AzureBackup Job Resource Class
type AzureBackupJobResource struct {
	// AzureBackupJobResource properties
	Properties *AzureBackupJob `json:"properties,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureBackupJobResourceList - List of AzureBackup Job resources
type AzureBackupJobResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*AzureBackupJobResource `json:"value,omitempty"`
}

// AzureBackupParams - Azure backup parameters
type AzureBackupParams struct {
	// REQUIRED; BackupType ; Full/Incremental etc
	BackupType *string `json:"backupType,omitempty"`

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetBackupParameters implements the BackupParametersClassification interface for type AzureBackupParams.
func (a *AzureBackupParams) GetBackupParameters() *BackupParameters {
	return &BackupParameters{
		ObjectType: a.ObjectType,
	}
}

// AzureBackupRecoveryPointClassification provides polymorphic access to related types.
// Call the interface's GetAzureBackupRecoveryPoint() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupDiscreteRecoveryPoint, *AzureBackupRecoveryPoint
type AzureBackupRecoveryPointClassification interface {
	// GetAzureBackupRecoveryPoint returns the AzureBackupRecoveryPoint content of the underlying type.
	GetAzureBackupRecoveryPoint() *AzureBackupRecoveryPoint
}

// AzureBackupRecoveryPoint - Azure backup recoveryPoint
type AzureBackupRecoveryPoint struct {
	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`
}

// GetAzureBackupRecoveryPoint implements the AzureBackupRecoveryPointClassification interface for type AzureBackupRecoveryPoint.
func (a *AzureBackupRecoveryPoint) GetAzureBackupRecoveryPoint() *AzureBackupRecoveryPoint { return a }

// AzureBackupRecoveryPointBasedRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureBackupRecoveryPointBasedRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupRecoveryPointBasedRestoreRequest, *AzureBackupRestoreWithRehydrationRequest
type AzureBackupRecoveryPointBasedRestoreRequestClassification interface {
	AzureBackupRestoreRequestClassification
	// GetAzureBackupRecoveryPointBasedRestoreRequest returns the AzureBackupRecoveryPointBasedRestoreRequest content of the underlying type.
	GetAzureBackupRecoveryPointBasedRestoreRequest() *AzureBackupRecoveryPointBasedRestoreRequest
}

// AzureBackupRecoveryPointBasedRestoreRequest - Azure backup recoveryPoint based restore request
type AzureBackupRecoveryPointBasedRestoreRequest struct {
	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification `json:"restoreTargetInfo,omitempty"`

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType `json:"sourceDataStoreType,omitempty"`

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetAzureBackupRecoveryPointBasedRestoreRequest implements the AzureBackupRecoveryPointBasedRestoreRequestClassification
// interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a *AzureBackupRecoveryPointBasedRestoreRequest) GetAzureBackupRecoveryPointBasedRestoreRequest() *AzureBackupRecoveryPointBasedRestoreRequest {
	return a
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a *AzureBackupRecoveryPointBasedRestoreRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return &AzureBackupRestoreRequest{
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// AzureBackupRecoveryPointResource - Azure backup recoveryPoint resource
type AzureBackupRecoveryPointResource struct {
	// AzureBackupRecoveryPointResource properties
	Properties AzureBackupRecoveryPointClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureBackupRecoveryPointResourceList - Azure backup recoveryPoint resource list
type AzureBackupRecoveryPointResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*AzureBackupRecoveryPointResource `json:"value,omitempty"`
}

// AzureBackupRecoveryTimeBasedRestoreRequest - AzureBackup RecoveryPointTime Based Restore Request
type AzureBackupRecoveryTimeBasedRestoreRequest struct {
	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; The recovery time in ISO 8601 format example - 2020-08-14T17:30:00.0000000Z.
	RecoveryPointTime *string `json:"recoveryPointTime,omitempty"`

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification `json:"restoreTargetInfo,omitempty"`

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType `json:"sourceDataStoreType,omitempty"`

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRecoveryTimeBasedRestoreRequest.
func (a *AzureBackupRecoveryTimeBasedRestoreRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return &AzureBackupRestoreRequest{
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// AzureBackupRehydrationRequest - Azure Backup Rehydrate Request
type AzureBackupRehydrationRequest struct {
	// REQUIRED; Id of the recovery point to be recovered
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// REQUIRED; Retention duration in ISO 8601 format i.e P10D .
	RehydrationRetentionDuration *string `json:"rehydrationRetentionDuration,omitempty"`

	// Priority to be used for rehydration. Values High or Standard
	RehydrationPriority *RehydrationPriority `json:"rehydrationPriority,omitempty"`
}

// AzureBackupRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureBackupRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupRecoveryPointBasedRestoreRequest, *AzureBackupRecoveryTimeBasedRestoreRequest, *AzureBackupRestoreRequest,
// - *AzureBackupRestoreWithRehydrationRequest
type AzureBackupRestoreRequestClassification interface {
	// GetAzureBackupRestoreRequest returns the AzureBackupRestoreRequest content of the underlying type.
	GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest
}

// AzureBackupRestoreRequest - Azure backup restore request
type AzureBackupRestoreRequest struct {
	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification `json:"restoreTargetInfo,omitempty"`

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType `json:"sourceDataStoreType,omitempty"`

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRestoreRequest.
func (a *AzureBackupRestoreRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return a
}

// AzureBackupRestoreWithRehydrationRequest - AzureBackup Restore with Rehydration Request
type AzureBackupRestoreWithRehydrationRequest struct {
	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// REQUIRED; Priority to be used for rehydration. Values High or Standard
	RehydrationPriority *RehydrationPriority `json:"rehydrationPriority,omitempty"`

	// REQUIRED; Retention duration in ISO 8601 format i.e P10D .
	RehydrationRetentionDuration *string `json:"rehydrationRetentionDuration,omitempty"`

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification `json:"restoreTargetInfo,omitempty"`

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType `json:"sourceDataStoreType,omitempty"`

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetAzureBackupRecoveryPointBasedRestoreRequest implements the AzureBackupRecoveryPointBasedRestoreRequestClassification
// interface for type AzureBackupRestoreWithRehydrationRequest.
func (a *AzureBackupRestoreWithRehydrationRequest) GetAzureBackupRecoveryPointBasedRestoreRequest() *AzureBackupRecoveryPointBasedRestoreRequest {
	return &AzureBackupRecoveryPointBasedRestoreRequest{
		RecoveryPointID:     a.RecoveryPointID,
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRestoreWithRehydrationRequest.
func (a *AzureBackupRestoreWithRehydrationRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return &AzureBackupRestoreRequest{
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// AzureBackupRule - Azure backup rule
type AzureBackupRule struct {
	// REQUIRED; DataStoreInfo base
	DataStore *DataStoreInfoBase `json:"dataStore,omitempty"`

	// REQUIRED
	Name *string `json:"name,omitempty"`

	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Trigger context
	Trigger TriggerContextClassification `json:"trigger,omitempty"`

	// BackupParameters base
	BackupParameters BackupParametersClassification `json:"backupParameters,omitempty"`
}

// GetBasePolicyRule implements the BasePolicyRuleClassification interface for type AzureBackupRule.
func (a *AzureBackupRule) GetBasePolicyRule() *BasePolicyRule {
	return &BasePolicyRule{
		Name:       a.Name,
		ObjectType: a.ObjectType,
	}
}

// AzureMonitorAlertSettings - Settings for Azure Monitor based alerts
type AzureMonitorAlertSettings struct {
	AlertsForAllJobFailures *AlertsState `json:"alertsForAllJobFailures,omitempty"`
}

// AzureOperationalStoreParameters - Parameters for Operational-Tier DataStore
type AzureOperationalStoreParameters struct {
	// REQUIRED; type of datastore; Operational/Vault/Archive
	DataStoreType *DataStoreTypes `json:"dataStoreType,omitempty"`

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// Gets or sets the Snapshot Resource Group Uri.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
}

// GetDataStoreParameters implements the DataStoreParametersClassification interface for type AzureOperationalStoreParameters.
func (a *AzureOperationalStoreParameters) GetDataStoreParameters() *DataStoreParameters {
	return &DataStoreParameters{
		ObjectType:    a.ObjectType,
		DataStoreType: a.DataStoreType,
	}
}

// AzureRetentionRule - Azure retention rule
type AzureRetentionRule struct {
	// REQUIRED
	Lifecycles []*SourceLifeCycle `json:"lifecycles,omitempty"`

	// REQUIRED
	Name *string `json:"name,omitempty"`

	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`
	IsDefault  *bool   `json:"isDefault,omitempty"`
}

// GetBasePolicyRule implements the BasePolicyRuleClassification interface for type AzureRetentionRule.
func (a *AzureRetentionRule) GetBasePolicyRule() *BasePolicyRule {
	return &BasePolicyRule{
		Name:       a.Name,
		ObjectType: a.ObjectType,
	}
}

// BackupCriteriaClassification provides polymorphic access to related types.
// Call the interface's GetBackupCriteria() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BackupCriteria, *ScheduleBasedBackupCriteria
type BackupCriteriaClassification interface {
	// GetBackupCriteria returns the BackupCriteria content of the underlying type.
	GetBackupCriteria() *BackupCriteria
}

// BackupCriteria base class
type BackupCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetBackupCriteria implements the BackupCriteriaClassification interface for type BackupCriteria.
func (b *BackupCriteria) GetBackupCriteria() *BackupCriteria { return b }

// BackupInstance - Backup Instance
type BackupInstance struct {
	// REQUIRED; Gets or sets the data source information.
	DataSourceInfo *Datasource `json:"dataSourceInfo,omitempty"`

	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Gets or sets the policy information.
	PolicyInfo *PolicyInfo `json:"policyInfo,omitempty"`

	// Gets or sets the data source set information.
	DataSourceSetInfo *DatasourceSet `json:"dataSourceSetInfo,omitempty"`

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification `json:"datasourceAuthCredentials,omitempty"`

	// Gets or sets the Backup Instance friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
	ValidationType *ValidationType `json:"validationType,omitempty"`

	// READ-ONLY; Specifies the current protection state of the resource
	CurrentProtectionState *CurrentProtectionState `json:"currentProtectionState,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the protection error of the resource
	ProtectionErrorDetails *UserFacingError `json:"protectionErrorDetails,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the protection status of the resource
	ProtectionStatus *ProtectionStatusDetails `json:"protectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// BackupInstanceResource - BackupInstance Resource
type BackupInstanceResource struct {
	// BackupInstanceResource properties
	Properties *BackupInstance `json:"properties,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupInstanceResourceList - BackupInstance Resource list response
type BackupInstanceResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*BackupInstanceResource `json:"value,omitempty"`
}

// BackupInstancesClientBeginAdhocBackupOptions contains the optional parameters for the BackupInstancesClient.BeginAdhocBackup
// method.
type BackupInstancesClientBeginAdhocBackupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupInstancesClient.BeginCreateOrUpdate
// method.
type BackupInstancesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginDeleteOptions contains the optional parameters for the BackupInstancesClient.BeginDelete method.
type BackupInstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginResumeBackupsOptions contains the optional parameters for the BackupInstancesClient.BeginResumeBackups
// method.
type BackupInstancesClientBeginResumeBackupsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginResumeProtectionOptions contains the optional parameters for the BackupInstancesClient.BeginResumeProtection
// method.
type BackupInstancesClientBeginResumeProtectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginStopProtectionOptions contains the optional parameters for the BackupInstancesClient.BeginStopProtection
// method.
type BackupInstancesClientBeginStopProtectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginSuspendBackupsOptions contains the optional parameters for the BackupInstancesClient.BeginSuspendBackups
// method.
type BackupInstancesClientBeginSuspendBackupsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginSyncBackupInstanceOptions contains the optional parameters for the BackupInstancesClient.BeginSyncBackupInstance
// method.
type BackupInstancesClientBeginSyncBackupInstanceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginTriggerRehydrateOptions contains the optional parameters for the BackupInstancesClient.BeginTriggerRehydrate
// method.
type BackupInstancesClientBeginTriggerRehydrateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginTriggerRestoreOptions contains the optional parameters for the BackupInstancesClient.BeginTriggerRestore
// method.
type BackupInstancesClientBeginTriggerRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginValidateForBackupOptions contains the optional parameters for the BackupInstancesClient.BeginValidateForBackup
// method.
type BackupInstancesClientBeginValidateForBackupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientBeginValidateForRestoreOptions contains the optional parameters for the BackupInstancesClient.BeginValidateForRestore
// method.
type BackupInstancesClientBeginValidateForRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupInstancesClientGetBackupInstanceOperationResultOptions contains the optional parameters for the BackupInstancesClient.GetBackupInstanceOperationResult
// method.
type BackupInstancesClientGetBackupInstanceOperationResultOptions struct {
	// placeholder for future optional parameters
}

// BackupInstancesClientGetOptions contains the optional parameters for the BackupInstancesClient.Get method.
type BackupInstancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupInstancesClientListOptions contains the optional parameters for the BackupInstancesClient.List method.
type BackupInstancesClientListOptions struct {
	// placeholder for future optional parameters
}

// BackupParametersClassification provides polymorphic access to related types.
// Call the interface's GetBackupParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupParams, *BackupParameters
type BackupParametersClassification interface {
	// GetBackupParameters returns the BackupParameters content of the underlying type.
	GetBackupParameters() *BackupParameters
}

// BackupParameters base
type BackupParameters struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetBackupParameters implements the BackupParametersClassification interface for type BackupParameters.
func (b *BackupParameters) GetBackupParameters() *BackupParameters { return b }

// BackupPoliciesClientCreateOrUpdateOptions contains the optional parameters for the BackupPoliciesClient.CreateOrUpdate
// method.
type BackupPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesClientDeleteOptions contains the optional parameters for the BackupPoliciesClient.Delete method.
type BackupPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesClientGetOptions contains the optional parameters for the BackupPoliciesClient.Get method.
type BackupPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesClientListOptions contains the optional parameters for the BackupPoliciesClient.List method.
type BackupPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// BackupPolicy - Rule based backup policy
type BackupPolicy struct {
	// REQUIRED; Type of datasource for the backup management
	DatasourceTypes []*string `json:"datasourceTypes,omitempty"`

	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
	PolicyRules []BasePolicyRuleClassification `json:"policyRules,omitempty"`
}

// GetBaseBackupPolicy implements the BaseBackupPolicyClassification interface for type BackupPolicy.
func (b *BackupPolicy) GetBaseBackupPolicy() *BaseBackupPolicy {
	return &BaseBackupPolicy{
		DatasourceTypes: b.DatasourceTypes,
		ObjectType:      b.ObjectType,
	}
}

// BackupSchedule - Schedule for backup
type BackupSchedule struct {
	// REQUIRED; ISO 8601 repeating time interval format
	RepeatingTimeIntervals []*string `json:"repeatingTimeIntervals,omitempty"`

	// Time zone for a schedule. Example: Pacific Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
}

// BackupVault - Backup Vault
type BackupVault struct {
	// REQUIRED; Storage Settings
	StorageSettings []*StorageSetting `json:"storageSettings,omitempty"`

	// Monitoring Settings
	MonitoringSettings *MonitoringSettings `json:"monitoringSettings,omitempty"`

	// READ-ONLY; Provisioning state of the BackupVault resource
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource move details for backup vault
	ResourceMoveDetails *ResourceMoveDetails `json:"resourceMoveDetails,omitempty" azure:"ro"`

	// READ-ONLY; Resource move state for backup vault
	ResourceMoveState *ResourceMoveState `json:"resourceMoveState,omitempty" azure:"ro"`
}

// BackupVaultOperationResultsClientGetOptions contains the optional parameters for the BackupVaultOperationResultsClient.Get
// method.
type BackupVaultOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupVaultResource - Backup Vault Resource
type BackupVaultResource struct {
	// REQUIRED; BackupVaultResource properties
	Properties *BackupVault `json:"properties,omitempty"`

	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupVaultResourceList - List of BackupVault resources
type BackupVaultResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*BackupVaultResource `json:"value,omitempty"`
}

// BackupVaultsClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupVaultsClient.BeginCreateOrUpdate
// method.
type BackupVaultsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupVaultsClientBeginUpdateOptions contains the optional parameters for the BackupVaultsClient.BeginUpdate method.
type BackupVaultsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupVaultsClientCheckNameAvailabilityOptions contains the optional parameters for the BackupVaultsClient.CheckNameAvailability
// method.
type BackupVaultsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// BackupVaultsClientDeleteOptions contains the optional parameters for the BackupVaultsClient.Delete method.
type BackupVaultsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BackupVaultsClientGetInResourceGroupOptions contains the optional parameters for the BackupVaultsClient.GetInResourceGroup
// method.
type BackupVaultsClientGetInResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// BackupVaultsClientGetInSubscriptionOptions contains the optional parameters for the BackupVaultsClient.GetInSubscription
// method.
type BackupVaultsClientGetInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// BackupVaultsClientGetOptions contains the optional parameters for the BackupVaultsClient.Get method.
type BackupVaultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BaseBackupPolicyClassification provides polymorphic access to related types.
// Call the interface's GetBaseBackupPolicy() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BackupPolicy, *BaseBackupPolicy
type BaseBackupPolicyClassification interface {
	// GetBaseBackupPolicy returns the BaseBackupPolicy content of the underlying type.
	GetBaseBackupPolicy() *BaseBackupPolicy
}

// BaseBackupPolicy - BackupPolicy base
type BaseBackupPolicy struct {
	// REQUIRED; Type of datasource for the backup management
	DatasourceTypes []*string `json:"datasourceTypes,omitempty"`

	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`
}

// GetBaseBackupPolicy implements the BaseBackupPolicyClassification interface for type BaseBackupPolicy.
func (b *BaseBackupPolicy) GetBaseBackupPolicy() *BaseBackupPolicy { return b }

// BaseBackupPolicyResource - BaseBackupPolicy resource
type BaseBackupPolicyResource struct {
	// BaseBackupPolicyResource properties
	Properties BaseBackupPolicyClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BaseBackupPolicyResourceList - List of BaseBackupPolicy resources
type BaseBackupPolicyResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*BaseBackupPolicyResource `json:"value,omitempty"`
}

// BasePolicyRuleClassification provides polymorphic access to related types.
// Call the interface's GetBasePolicyRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupRule, *AzureRetentionRule, *BasePolicyRule
type BasePolicyRuleClassification interface {
	// GetBasePolicyRule returns the BasePolicyRule content of the underlying type.
	GetBasePolicyRule() *BasePolicyRule
}

// BasePolicyRule - BasePolicy Rule
type BasePolicyRule struct {
	// REQUIRED
	Name *string `json:"name,omitempty"`

	// REQUIRED
	ObjectType *string `json:"objectType,omitempty"`
}

// GetBasePolicyRule implements the BasePolicyRuleClassification interface for type BasePolicyRule.
func (b *BasePolicyRule) GetBasePolicyRule() *BasePolicyRule { return b }

// CheckNameAvailabilityRequest - CheckNameAvailability Request
type CheckNameAvailabilityRequest struct {
	// Resource name for which availability needs to be checked
	Name *string `json:"name,omitempty"`

	// Describes the Resource type: Microsoft.DataProtection/BackupVaults
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult - CheckNameAvailability Result
type CheckNameAvailabilityResult struct {
	// Gets or sets the message.
	Message *string `json:"message,omitempty"`

	// Gets or sets a value indicating whether [name available].
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Gets or sets the reason.
	Reason *string `json:"reason,omitempty"`
}

// ClientCheckFeatureSupportOptions contains the optional parameters for the Client.CheckFeatureSupport method.
type ClientCheckFeatureSupportOptions struct {
	// placeholder for future optional parameters
}

// ClientDiscoveryDisplay - Localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Description of the operation having details of what operation is about.
	Description *string `json:"description,omitempty"`

	// Operations Name itself.
	Operation *string `json:"operation,omitempty"`

	// Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`

	// ResourceType for which this Operation can be performed.
	Resource *string `json:"resource,omitempty"`
}

// ClientDiscoveryForLogSpecification - Class to represent shoebox log specification in json client discovery.
type ClientDiscoveryForLogSpecification struct {
	// blob duration of shoebox log specification
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized display name
	DisplayName *string `json:"displayName,omitempty"`

	// Name for shoebox log specification.
	Name *string `json:"name,omitempty"`
}

// ClientDiscoveryForProperties - Class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification - Class to represent shoebox service specification in json client discovery.
type ClientDiscoveryForServiceSpecification struct {
	// List of log specifications of this operation.
	LogSpecifications []*ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse - Operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	// Link to the next chunk of Response.
	NextLink *string `json:"nextLink,omitempty"`

	// List of available operations.
	Value []*ClientDiscoveryValueForSingleAPI `json:"value,omitempty"`
}

// ClientDiscoveryValueForSingleAPI - Available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the Operation.
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string `json:"origin,omitempty"`

	// Properties for the given operation.
	Properties *ClientDiscoveryForProperties `json:"properties,omitempty"`
}

// CloudError - An error response from Azure Backup.
type CloudError struct {
	// The resource management error response.
	Error *Error `json:"error,omitempty"`
}

// CopyOnExpiryOption - Copy on Expiry Option
type CopyOnExpiryOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetCopyOption implements the CopyOptionClassification interface for type CopyOnExpiryOption.
func (c *CopyOnExpiryOption) GetCopyOption() *CopyOption {
	return &CopyOption{
		ObjectType: c.ObjectType,
	}
}

// CopyOptionClassification provides polymorphic access to related types.
// Call the interface's GetCopyOption() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CopyOnExpiryOption, *CopyOption, *CustomCopyOption, *ImmediateCopyOption
type CopyOptionClassification interface {
	// GetCopyOption returns the CopyOption content of the underlying type.
	GetCopyOption() *CopyOption
}

// CopyOption - Options to copy
type CopyOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetCopyOption implements the CopyOptionClassification interface for type CopyOption.
func (c *CopyOption) GetCopyOption() *CopyOption { return c }

// CustomCopyOption - Duration based custom options to copy
type CustomCopyOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// Data copied after given timespan
	Duration *string `json:"duration,omitempty"`
}

// GetCopyOption implements the CopyOptionClassification interface for type CustomCopyOption.
func (c *CustomCopyOption) GetCopyOption() *CopyOption {
	return &CopyOption{
		ObjectType: c.ObjectType,
	}
}

// DataStoreInfoBase - DataStoreInfo base
type DataStoreInfoBase struct {
	// REQUIRED; type of datastore; Operational/Vault/Archive
	DataStoreType *DataStoreTypes `json:"dataStoreType,omitempty"`

	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`
}

// DataStoreParametersClassification provides polymorphic access to related types.
// Call the interface's GetDataStoreParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureOperationalStoreParameters, *DataStoreParameters
type DataStoreParametersClassification interface {
	// GetDataStoreParameters returns the DataStoreParameters content of the underlying type.
	GetDataStoreParameters() *DataStoreParameters
}

// DataStoreParameters - Parameters for DataStore
type DataStoreParameters struct {
	// REQUIRED; type of datastore; Operational/Vault/Archive
	DataStoreType *DataStoreTypes `json:"dataStoreType,omitempty"`

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetDataStoreParameters implements the DataStoreParametersClassification interface for type DataStoreParameters.
func (d *DataStoreParameters) GetDataStoreParameters() *DataStoreParameters { return d }

// Datasource to be backed up
type Datasource struct {
	// REQUIRED; Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID
	// created by backup service via Fabric/Vault.
	ResourceID *string `json:"resourceID,omitempty"`

	// DatasourceType of the resource.
	DatasourceType *string `json:"datasourceType,omitempty"`

	// Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`

	// Location of datasource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// Unique identifier of the resource in the context of parent.
	ResourceName *string `json:"resourceName,omitempty"`

	// Resource Type of Datasource.
	ResourceType *string `json:"resourceType,omitempty"`

	// Uri of the resource.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// DatasourceSet details of datasource to be backed up
type DatasourceSet struct {
	// REQUIRED; Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID
	// created by backup service via Fabric/Vault.
	ResourceID *string `json:"resourceID,omitempty"`

	// DatasourceType of the resource.
	DatasourceType *string `json:"datasourceType,omitempty"`

	// Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`

	// Location of datasource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// Unique identifier of the resource in the context of parent.
	ResourceName *string `json:"resourceName,omitempty"`

	// Resource Type of Datasource.
	ResourceType *string `json:"resourceType,omitempty"`

	// Uri of the resource.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// Day of the week
type Day struct {
	// Date of the month
	Date *int32 `json:"date,omitempty"`

	// Whether Date is last date of month
	IsLast *bool `json:"isLast,omitempty"`
}

// DeleteOptionClassification provides polymorphic access to related types.
// Call the interface's GetDeleteOption() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AbsoluteDeleteOption, *DeleteOption
type DeleteOptionClassification interface {
	// GetDeleteOption returns the DeleteOption content of the underlying type.
	GetDeleteOption() *DeleteOption
}

// DeleteOption - Delete Option
type DeleteOption struct {
	// REQUIRED; Duration of deletion after given timespan
	Duration *string `json:"duration,omitempty"`

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetDeleteOption implements the DeleteOptionClassification interface for type DeleteOption.
func (d *DeleteOption) GetDeleteOption() *DeleteOption { return d }

// DppBaseResource - Base resource under Microsoft.DataProtection provider namespace
type DppBaseResource struct {
	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DppBaseResourceList - Base for all lists of V2 resources.
type DppBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Dpp resources.
	Value []*DppBaseResource `json:"value,omitempty"`
}

// DppIdentityDetails - Identity details
type DppIdentityDetails struct {
	// The identityType which can be either SystemAssigned or None
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The object ID of the service principal object for the managed identity that is used to grant role-based access
	// to an Azure resource.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is now a member.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// DppResource - Resource class
type DppResource struct {
	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DppResourceList - ListResource
type DppResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

type DppTrackedResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DppTrackedResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

type DppWorkerRequest struct {
	CultureInfo *string `json:"cultureInfo,omitempty"`
	HTTPMethod  *string `json:"httpMethod,omitempty"`

	// Dictionary of
	Headers map[string][]*string `json:"headers,omitempty"`

	// Dictionary of
	Parameters             map[string]*string `json:"parameters,omitempty"`
	SubscriptionID         *string            `json:"subscriptionId,omitempty"`
	SupportedGroupVersions []*string          `json:"supportedGroupVersions,omitempty"`
	URI                    *string            `json:"uri,omitempty"`
}

// Error - The resource management error response.
type Error struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*Error `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExportJobsClientBeginTriggerOptions contains the optional parameters for the ExportJobsClient.BeginTrigger method.
type ExportJobsClientBeginTriggerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExportJobsOperationResultClientGetOptions contains the optional parameters for the ExportJobsOperationResultClient.Get
// method.
type ExportJobsOperationResultClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExportJobsResult - The result for export jobs containing blob details.
type ExportJobsResult struct {
	// READ-ONLY; SAS key to access the blob.
	BlobSasKey *string `json:"blobSasKey,omitempty" azure:"ro"`

	// READ-ONLY; URL of the blob into which the serialized string of list of jobs is exported.
	BlobURL *string `json:"blobUrl,omitempty" azure:"ro"`

	// READ-ONLY; SAS key to access the ExcelFile blob.
	ExcelFileBlobSasKey *string `json:"excelFileBlobSasKey,omitempty" azure:"ro"`

	// READ-ONLY; URL of the blob into which the ExcelFile is uploaded.
	ExcelFileBlobURL *string `json:"excelFileBlobUrl,omitempty" azure:"ro"`
}

// FeatureValidationRequest - Base class for feature object
type FeatureValidationRequest struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// backup support feature name.
	FeatureName *string `json:"featureName,omitempty"`

	// backup support feature type.
	FeatureType *FeatureType `json:"featureType,omitempty"`
}

// GetFeatureValidationRequestBase implements the FeatureValidationRequestBaseClassification interface for type FeatureValidationRequest.
func (f *FeatureValidationRequest) GetFeatureValidationRequestBase() *FeatureValidationRequestBase {
	return &FeatureValidationRequestBase{
		ObjectType: f.ObjectType,
	}
}

// FeatureValidationRequestBaseClassification provides polymorphic access to related types.
// Call the interface's GetFeatureValidationRequestBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FeatureValidationRequest, *FeatureValidationRequestBase
type FeatureValidationRequestBaseClassification interface {
	// GetFeatureValidationRequestBase returns the FeatureValidationRequestBase content of the underlying type.
	GetFeatureValidationRequestBase() *FeatureValidationRequestBase
}

// FeatureValidationRequestBase - Base class for Backup Feature support
type FeatureValidationRequestBase struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetFeatureValidationRequestBase implements the FeatureValidationRequestBaseClassification interface for type FeatureValidationRequestBase.
func (f *FeatureValidationRequestBase) GetFeatureValidationRequestBase() *FeatureValidationRequestBase {
	return f
}

// FeatureValidationResponse - Feature Validation Response
type FeatureValidationResponse struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// backup support feature type.
	FeatureType *FeatureType `json:"featureType,omitempty"`

	// Response features
	Features []*SupportedFeature `json:"features,omitempty"`
}

// GetFeatureValidationResponseBase implements the FeatureValidationResponseBaseClassification interface for type FeatureValidationResponse.
func (f *FeatureValidationResponse) GetFeatureValidationResponseBase() *FeatureValidationResponseBase {
	return &FeatureValidationResponseBase{
		ObjectType: f.ObjectType,
	}
}

// FeatureValidationResponseBaseClassification provides polymorphic access to related types.
// Call the interface's GetFeatureValidationResponseBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FeatureValidationResponse, *FeatureValidationResponseBase
type FeatureValidationResponseBaseClassification interface {
	// GetFeatureValidationResponseBase returns the FeatureValidationResponseBase content of the underlying type.
	GetFeatureValidationResponseBase() *FeatureValidationResponseBase
}

// FeatureValidationResponseBase - Base class for Backup Feature support
type FeatureValidationResponseBase struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetFeatureValidationResponseBase implements the FeatureValidationResponseBaseClassification interface for type FeatureValidationResponseBase.
func (f *FeatureValidationResponseBase) GetFeatureValidationResponseBase() *FeatureValidationResponseBase {
	return f
}

// ImmediateCopyOption - Immediate copy Option
type ImmediateCopyOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetCopyOption implements the CopyOptionClassification interface for type ImmediateCopyOption.
func (i *ImmediateCopyOption) GetCopyOption() *CopyOption {
	return &CopyOption{
		ObjectType: i.ObjectType,
	}
}

// InnerError - Inner Error
type InnerError struct {
	// Any Key value pairs that can be provided to the client for additional verbose information.
	AdditionalInfo map[string]*string `json:"additionalInfo,omitempty"`

	// Unique code for this error
	Code *string `json:"code,omitempty"`

	// Child Inner Error, to allow Nesting.
	EmbeddedInnerError *InnerError `json:"embeddedInnerError,omitempty"`
}

// ItemLevelRestoreCriteriaClassification provides polymorphic access to related types.
// Call the interface's GetItemLevelRestoreCriteria() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ItemLevelRestoreCriteria, *KubernetesPVRestoreCriteria, *KubernetesStorageClassRestoreCriteria, *RangeBasedItemLevelRestoreCriteria
type ItemLevelRestoreCriteriaClassification interface {
	// GetItemLevelRestoreCriteria returns the ItemLevelRestoreCriteria content of the underlying type.
	GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria
}

// ItemLevelRestoreCriteria - Class to contain criteria for item level restore
type ItemLevelRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type ItemLevelRestoreCriteria.
func (i *ItemLevelRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria { return i }

// ItemLevelRestoreTargetInfo - Restore target info for Item level restore operation
type ItemLevelRestoreTargetInfo struct {
	// REQUIRED; Information of target DS
	DatasourceInfo *Datasource `json:"datasourceInfo,omitempty"`

	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption `json:"recoveryOption,omitempty"`

	// REQUIRED; Restore Criteria
	RestoreCriteria []ItemLevelRestoreCriteriaClassification `json:"restoreCriteria,omitempty"`

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification `json:"datasourceAuthCredentials,omitempty"`

	// Information of target DS Set
	DatasourceSetInfo *DatasourceSet `json:"datasourceSetInfo,omitempty"`

	// Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type ItemLevelRestoreTargetInfo.
func (i *ItemLevelRestoreTargetInfo) GetRestoreTargetInfoBase() *RestoreTargetInfoBase {
	return &RestoreTargetInfoBase{
		ObjectType:      i.ObjectType,
		RecoveryOption:  i.RecoveryOption,
		RestoreLocation: i.RestoreLocation,
	}
}

// JobExtendedInfo - Extended Information about the job
type JobExtendedInfo struct {
	// Job's Additional Details
	AdditionalDetails map[string]*string `json:"additionalDetails,omitempty"`

	// READ-ONLY; State of the Backup Instance
	BackupInstanceState *string `json:"backupInstanceState,omitempty" azure:"ro"`

	// READ-ONLY; Number of bytes transferred
	DataTransferredInBytes *float64 `json:"dataTransferredInBytes,omitempty" azure:"ro"`

	// READ-ONLY; Destination where restore is done
	RecoveryDestination *string `json:"recoveryDestination,omitempty" azure:"ro"`

	// READ-ONLY; Details of the Source Recovery Point
	SourceRecoverPoint *RestoreJobRecoveryPointDetails `json:"sourceRecoverPoint,omitempty" azure:"ro"`

	// READ-ONLY; List of Sub Tasks of the job
	SubTasks []*JobSubTask `json:"subTasks,omitempty" azure:"ro"`

	// READ-ONLY; Details of the Target Recovery Point
	TargetRecoverPoint *RestoreJobRecoveryPointDetails `json:"targetRecoverPoint,omitempty" azure:"ro"`
}

// JobSubTask - Details of Job's Sub Task
type JobSubTask struct {
	// REQUIRED; Task Id of the Sub Task
	TaskID *int32 `json:"taskId,omitempty"`

	// REQUIRED; Name of the Sub Task
	TaskName *string `json:"taskName,omitempty"`

	// REQUIRED; Status of the Sub Task
	TaskStatus *string `json:"taskStatus,omitempty"`

	// Additional details of Sub Tasks
	AdditionalDetails map[string]*string `json:"additionalDetails,omitempty"`

	// READ-ONLY; Progress of the Sub Task
	TaskProgress *string `json:"taskProgress,omitempty" azure:"ro"`
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListOptions contains the optional parameters for the JobsClient.List method.
type JobsClientListOptions struct {
	// placeholder for future optional parameters
}

// KubernetesPVRestoreCriteria - Item Level kubernetes persistent volume target info for restore operation
type KubernetesPVRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// Selected persistent volume claim name
	Name *string `json:"name,omitempty"`

	// Selected storage class name for restore operation
	StorageClassName *string `json:"storageClassName,omitempty"`
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type KubernetesPVRestoreCriteria.
func (k *KubernetesPVRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: k.ObjectType,
	}
}

// KubernetesStorageClassRestoreCriteria - Item Level kubernetes storage class target info for restore operation
type KubernetesStorageClassRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// Provisioner of the storage class
	Provisioner *string `json:"provisioner,omitempty"`

	// Selected storage class name
	SelectedStorageClassName *string `json:"selectedStorageClassName,omitempty"`
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type KubernetesStorageClassRestoreCriteria.
func (k *KubernetesStorageClassRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: k.ObjectType,
	}
}

// MonitoringSettings - Monitoring Settings
type MonitoringSettings struct {
	// Settings for Azure Monitor based alerts
	AzureMonitorAlertSettings *AzureMonitorAlertSettings `json:"azureMonitorAlertSettings,omitempty"`
}

// OperationExtendedInfoClassification provides polymorphic access to related types.
// Call the interface's GetOperationExtendedInfo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *OperationExtendedInfo, *OperationJobExtendedInfo
type OperationExtendedInfoClassification interface {
	// GetOperationExtendedInfo returns the OperationExtendedInfo content of the underlying type.
	GetOperationExtendedInfo() *OperationExtendedInfo
}

// OperationExtendedInfo - Operation Extended Info
type OperationExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetOperationExtendedInfo implements the OperationExtendedInfoClassification interface for type OperationExtendedInfo.
func (o *OperationExtendedInfo) GetOperationExtendedInfo() *OperationExtendedInfo { return o }

// OperationJobExtendedInfo - Operation Job Extended Info
type OperationJobExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Arm Id of the job created for this operation.
	JobID *string `json:"jobId,omitempty"`
}

// GetOperationExtendedInfo implements the OperationExtendedInfoClassification interface for type OperationJobExtendedInfo.
func (o *OperationJobExtendedInfo) GetOperationExtendedInfo() *OperationExtendedInfo {
	return &OperationExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationResource - Operation Resource
type OperationResource struct {
	// End time of the operation
	EndTime *time.Time `json:"endTime,omitempty"`

	// Required if status == failed or status == canceled. This is the OData v4 error format, used by the RPC and will go into
	// the v2.2 Azure REST API guidelines. The full set of optional properties (e.g.
	// inner errors / details) can be found in the "Error Response" section.
	Error *Error `json:"error,omitempty"`

	// It should match what is used to GET the operation result
	ID *string `json:"id,omitempty"`

	// It must match the last segment of the "id" field, and will typically be a GUID / system generated value
	Name *string `json:"name,omitempty"`

	// End time of the operation
	Properties OperationExtendedInfoClassification `json:"properties,omitempty"`

	// Start time of the operation
	StartTime *time.Time `json:"startTime,omitempty"`
	Status    *string    `json:"status,omitempty"`
}

// OperationResultClientGetOptions contains the optional parameters for the OperationResultClient.Get method.
type OperationResultClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationStatusBackupVaultContextClientGetOptions contains the optional parameters for the OperationStatusBackupVaultContextClient.Get
// method.
type OperationStatusBackupVaultContextClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationStatusClientGetOptions contains the optional parameters for the OperationStatusClient.Get method.
type OperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationStatusResourceGroupContextClientGetOptions contains the optional parameters for the OperationStatusResourceGroupContextClient.Get
// method.
type OperationStatusResourceGroupContextClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PatchBackupVaultInput - Backup Vault Contract for Patch Backup Vault API.
type PatchBackupVaultInput struct {
	// Monitoring Settings
	MonitoringSettings *MonitoringSettings `json:"monitoringSettings,omitempty"`
}

// PatchResourceRequestInput - Patch Request content for Microsoft.DataProtection resources
type PatchResourceRequestInput struct {
	// Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`

	// Resource properties.
	Properties *PatchBackupVaultInput `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PolicyInfo - Policy Info in backupInstance
type PolicyInfo struct {
	// REQUIRED
	PolicyID *string `json:"policyId,omitempty"`

	// Policy parameters for the backup instance
	PolicyParameters *PolicyParameters `json:"policyParameters,omitempty"`

	// READ-ONLY
	PolicyVersion *string `json:"policyVersion,omitempty" azure:"ro"`
}

// PolicyParameters - Parameters in Policy
type PolicyParameters struct {
	// Gets or sets the DataStore Parameters
	DataStoreParametersList []DataStoreParametersClassification `json:"dataStoreParametersList,omitempty"`
}

// ProtectionStatusDetails - Protection status details
type ProtectionStatusDetails struct {
	// Specifies the protection status error of the resource
	ErrorDetails *UserFacingError `json:"errorDetails,omitempty"`

	// Specifies the protection status of the resource
	Status *Status `json:"status,omitempty"`
}

// RangeBasedItemLevelRestoreCriteria - Item Level target info for restore operation
type RangeBasedItemLevelRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// maximum value for range prefix match
	MaxMatchingValue *string `json:"maxMatchingValue,omitempty"`

	// minimum value for range prefix match
	MinMatchingValue *string `json:"minMatchingValue,omitempty"`
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type RangeBasedItemLevelRestoreCriteria.
func (r *RangeBasedItemLevelRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: r.ObjectType,
	}
}

// RecoveryPointDataStoreDetails - RecoveryPoint datastore details
type RecoveryPointDataStoreDetails struct {
	CreationTime *time.Time `json:"creationTime,omitempty"`
	ExpiryTime   *time.Time `json:"expiryTime,omitempty"`
	ID           *string    `json:"id,omitempty"`
	MetaData     *string    `json:"metaData,omitempty"`
	State        *string    `json:"state,omitempty"`
	Type         *string    `json:"type,omitempty"`
	Visible      *bool      `json:"visible,omitempty"`

	// READ-ONLY
	RehydrationExpiryTime *time.Time `json:"rehydrationExpiryTime,omitempty" azure:"ro"`

	// READ-ONLY
	RehydrationStatus *RehydrationStatus `json:"rehydrationStatus,omitempty" azure:"ro"`
}

// RecoveryPointsClientGetOptions contains the optional parameters for the RecoveryPointsClient.Get method.
type RecoveryPointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecoveryPointsClientListOptions contains the optional parameters for the RecoveryPointsClient.List method.
type RecoveryPointsClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

type RecoveryPointsFilters struct {
	EndDate                 *string `json:"endDate,omitempty"`
	ExtendedInfo            *bool   `json:"extendedInfo,omitempty"`
	IsVisible               *bool   `json:"isVisible,omitempty"`
	RestorePointDataStoreID *string `json:"restorePointDataStoreId,omitempty"`
	RestorePointState       *string `json:"restorePointState,omitempty"`
	StartDate               *string `json:"startDate,omitempty"`
}

type ResourceGuard struct {
	// List of critical operations which are not protected by this resourceGuard
	VaultCriticalOperationExclusionList []*string `json:"vaultCriticalOperationExclusionList,omitempty"`

	// READ-ONLY; This flag indicates whether auto approval is allowed or not.
	AllowAutoApprovals *bool `json:"allowAutoApprovals,omitempty" azure:"ro"`

	// READ-ONLY; Description about the pre-req steps to perform all the critical operations.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the BackupVault resource
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; {readonly} List of operation details those are protected by the ResourceGuard resource
	ResourceGuardOperations []*ResourceGuardOperation `json:"resourceGuardOperations,omitempty" azure:"ro"`
}

// ResourceGuardOperation - This class contains all the details about a critical operation.
type ResourceGuardOperation struct {
	// READ-ONLY; Type of resource request.
	RequestResourceType *string `json:"requestResourceType,omitempty" azure:"ro"`

	// READ-ONLY; Name of the critical operation.
	VaultCriticalOperation *string `json:"vaultCriticalOperation,omitempty" azure:"ro"`
}

type ResourceGuardResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ResourceGuardResource properties
	Properties *ResourceGuard `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceGuardResourceList - List of ResourceGuard resources
type ResourceGuardResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ResourceGuardResource `json:"value,omitempty"`
}

// ResourceGuardsClientDeleteOptions contains the optional parameters for the ResourceGuardsClient.Delete method.
type ResourceGuardsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetBackupSecurityPINRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.GetBackupSecurityPINRequestsObjects
// method.
type ResourceGuardsClientGetBackupSecurityPINRequestsObjectsOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectOptions contains the optional parameters for the ResourceGuardsClient.GetDefaultBackupSecurityPINRequestsObject
// method.
type ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectOptions contains the optional parameters for the ResourceGuardsClient.GetDefaultDeleteProtectedItemRequestsObject
// method.
type ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectOptions contains the optional parameters for the ResourceGuardsClient.GetDefaultDeleteResourceGuardProxyRequestsObject
// method.
type ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectOptions contains the optional parameters for the ResourceGuardsClient.GetDefaultDisableSoftDeleteRequestsObject
// method.
type ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectOptions contains the optional parameters for the ResourceGuardsClient.GetDefaultUpdateProtectedItemRequestsObject
// method.
type ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectOptions contains the optional parameters for the ResourceGuardsClient.GetDefaultUpdateProtectionPolicyRequestsObject
// method.
type ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.GetDeleteProtectedItemRequestsObjects
// method.
type ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.GetDeleteResourceGuardProxyRequestsObjects
// method.
type ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.GetDisableSoftDeleteRequestsObjects
// method.
type ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetOptions contains the optional parameters for the ResourceGuardsClient.Get method.
type ResourceGuardsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetResourcesInResourceGroupOptions contains the optional parameters for the ResourceGuardsClient.GetResourcesInResourceGroup
// method.
type ResourceGuardsClientGetResourcesInResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetResourcesInSubscriptionOptions contains the optional parameters for the ResourceGuardsClient.GetResourcesInSubscription
// method.
type ResourceGuardsClientGetResourcesInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.GetUpdateProtectedItemRequestsObjects
// method.
type ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.GetUpdateProtectionPolicyRequestsObjects
// method.
type ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientPatchOptions contains the optional parameters for the ResourceGuardsClient.Patch method.
type ResourceGuardsClientPatchOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardsClientPutOptions contains the optional parameters for the ResourceGuardsClient.Put method.
type ResourceGuardsClientPutOptions struct {
	// placeholder for future optional parameters
}

// ResourceMoveDetails will be returned in response to GetResource call from ARM
type ResourceMoveDetails struct {
	// Completion time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
	CompletionTimeUTC *string `json:"completionTimeUtc,omitempty"`

	// CorrelationId of latest ResourceMove operation attempted
	OperationID *string `json:"operationId,omitempty"`

	// ARM resource path of source resource
	SourceResourcePath *string `json:"sourceResourcePath,omitempty"`

	// Start time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
	StartTimeUTC *string `json:"startTimeUtc,omitempty"`

	// ARM resource path of target resource used in latest ResourceMove operation
	TargetResourcePath *string `json:"targetResourcePath,omitempty"`
}

type RestorableTimeRange struct {
	// REQUIRED; End time for the available restore range
	EndTime *string `json:"endTime,omitempty"`

	// REQUIRED; Start time for the available restore range
	StartTime  *string `json:"startTime,omitempty"`
	ObjectType *string `json:"objectType,omitempty"`
}

// RestorableTimeRangesClientFindOptions contains the optional parameters for the RestorableTimeRangesClient.Find method.
type RestorableTimeRangesClientFindOptions struct {
	// placeholder for future optional parameters
}

// RestoreFilesTargetInfo - Class encapsulating restore as files target parameters
type RestoreFilesTargetInfo struct {
	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption `json:"recoveryOption,omitempty"`

	// REQUIRED; Destination of RestoreAsFiles operation, when destination is not a datasource
	TargetDetails *TargetDetails `json:"targetDetails,omitempty"`

	// Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type RestoreFilesTargetInfo.
func (r *RestoreFilesTargetInfo) GetRestoreTargetInfoBase() *RestoreTargetInfoBase {
	return &RestoreTargetInfoBase{
		ObjectType:      r.ObjectType,
		RecoveryOption:  r.RecoveryOption,
		RestoreLocation: r.RestoreLocation,
	}
}

type RestoreJobRecoveryPointDetails struct {
	RecoveryPointID   *string    `json:"recoveryPointID,omitempty"`
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty"`
}

// RestoreTargetInfo - Class encapsulating restore target parameters
type RestoreTargetInfo struct {
	// REQUIRED; Information of target DS
	DatasourceInfo *Datasource `json:"datasourceInfo,omitempty"`

	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption `json:"recoveryOption,omitempty"`

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification `json:"datasourceAuthCredentials,omitempty"`

	// Information of target DS Set
	DatasourceSetInfo *DatasourceSet `json:"datasourceSetInfo,omitempty"`

	// Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type RestoreTargetInfo.
func (r *RestoreTargetInfo) GetRestoreTargetInfoBase() *RestoreTargetInfoBase {
	return &RestoreTargetInfoBase{
		ObjectType:      r.ObjectType,
		RecoveryOption:  r.RecoveryOption,
		RestoreLocation: r.RestoreLocation,
	}
}

// RestoreTargetInfoBaseClassification provides polymorphic access to related types.
// Call the interface's GetRestoreTargetInfoBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ItemLevelRestoreTargetInfo, *RestoreFilesTargetInfo, *RestoreTargetInfo, *RestoreTargetInfoBase
type RestoreTargetInfoBaseClassification interface {
	// GetRestoreTargetInfoBase returns the RestoreTargetInfoBase content of the underlying type.
	GetRestoreTargetInfoBase() *RestoreTargetInfoBase
}

// RestoreTargetInfoBase - Base class common to RestoreTargetInfo and RestoreFilesTargetInfo
type RestoreTargetInfoBase struct {
	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption `json:"recoveryOption,omitempty"`

	// Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type RestoreTargetInfoBase.
func (r *RestoreTargetInfoBase) GetRestoreTargetInfoBase() *RestoreTargetInfoBase { return r }

// RetentionTag - Retention tag
type RetentionTag struct {
	// REQUIRED; Retention Tag Name to relate it to retention rule.
	TagName *string `json:"tagName,omitempty"`

	// READ-ONLY; Retention Tag version.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Retention Tag version.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// ScheduleBasedBackupCriteria - Schedule based backup criteria
type ScheduleBasedBackupCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth" and should be part of AbsoluteMarker
	// enum
	AbsoluteCriteria []*AbsoluteMarker `json:"absoluteCriteria,omitempty"`

	// This is day of the month from 1 to 28 other wise last of month
	DaysOfMonth []*Day `json:"daysOfMonth,omitempty"`

	// It should be Sunday/Monday/T…./Saturday
	DaysOfTheWeek []*DayOfWeek `json:"daysOfTheWeek,omitempty"`

	// It should be January/February/……/December
	MonthsOfYear []*Month `json:"monthsOfYear,omitempty"`

	// List of schedule times for backup
	ScheduleTimes []*time.Time `json:"scheduleTimes,omitempty"`

	// It should be First/Second/Third/Fourth/Last
	WeeksOfTheMonth []*WeekNumber `json:"weeksOfTheMonth,omitempty"`
}

// GetBackupCriteria implements the BackupCriteriaClassification interface for type ScheduleBasedBackupCriteria.
func (s *ScheduleBasedBackupCriteria) GetBackupCriteria() *BackupCriteria {
	return &BackupCriteria{
		ObjectType: s.ObjectType,
	}
}

// ScheduleBasedTriggerContext - Schedule based trigger context
type ScheduleBasedTriggerContext struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// REQUIRED; Schedule for this backup
	Schedule *BackupSchedule `json:"schedule,omitempty"`

	// REQUIRED; List of tags that can be applicable for given schedule.
	TaggingCriteria []*TaggingCriteria `json:"taggingCriteria,omitempty"`
}

// GetTriggerContext implements the TriggerContextClassification interface for type ScheduleBasedTriggerContext.
func (s *ScheduleBasedTriggerContext) GetTriggerContext() *TriggerContext {
	return &TriggerContext{
		ObjectType: s.ObjectType,
	}
}

// SecretStoreBasedAuthCredentials - Secret store based authentication credentials.
type SecretStoreBasedAuthCredentials struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`

	// Secret store resource
	SecretStoreResource *SecretStoreResource `json:"secretStoreResource,omitempty"`
}

// GetAuthCredentials implements the AuthCredentialsClassification interface for type SecretStoreBasedAuthCredentials.
func (s *SecretStoreBasedAuthCredentials) GetAuthCredentials() *AuthCredentials {
	return &AuthCredentials{
		ObjectType: s.ObjectType,
	}
}

// SecretStoreResource - Class representing a secret store resource.
type SecretStoreResource struct {
	// REQUIRED; Gets or sets the type of secret store
	SecretStoreType *SecretStoreType `json:"secretStoreType,omitempty"`

	// Uri to get to the resource
	URI *string `json:"uri,omitempty"`

	// Gets or sets value stored in secret store resource
	Value *string `json:"value,omitempty"`
}

// SourceLifeCycle - Source LifeCycle
type SourceLifeCycle struct {
	// REQUIRED; Delete Option
	DeleteAfter DeleteOptionClassification `json:"deleteAfter,omitempty"`

	// REQUIRED; DataStoreInfo base
	SourceDataStore             *DataStoreInfoBase   `json:"sourceDataStore,omitempty"`
	TargetDataStoreCopySettings []*TargetCopySetting `json:"targetDataStoreCopySettings,omitempty"`
}

// StorageSetting - Storage setting
type StorageSetting struct {
	// Gets or sets the type of the datastore.
	DatastoreType *StorageSettingStoreTypes `json:"datastoreType,omitempty"`

	// Gets or sets the type.
	Type *StorageSettingTypes `json:"type,omitempty"`
}

// SupportedFeature - Elements class for feature request
type SupportedFeature struct {
	// support feature type.
	ExposureControlledFeatures []*string `json:"exposureControlledFeatures,omitempty"`

	// support feature type.
	FeatureName *string `json:"featureName,omitempty"`

	// feature support status
	SupportStatus *FeatureSupportStatus `json:"supportStatus,omitempty"`
}

// SyncBackupInstanceRequest - Sync BackupInstance Request
type SyncBackupInstanceRequest struct {
	// Field indicating sync type e.g. to sync only in case of failure or in all cases
	SyncType *SyncType `json:"syncType,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TaggingCriteria - Tagging criteria
type TaggingCriteria struct {
	// REQUIRED; Specifies if tag is default.
	IsDefault *bool `json:"isDefault,omitempty"`

	// REQUIRED; Retention tag information
	TagInfo *RetentionTag `json:"tagInfo,omitempty"`

	// REQUIRED; Retention Tag priority.
	TaggingPriority *int64 `json:"taggingPriority,omitempty"`

	// Criteria which decides whether the tag can be applied to a triggered backup.
	Criteria []BackupCriteriaClassification `json:"criteria,omitempty"`
}

// TargetCopySetting - Target copy settings
type TargetCopySetting struct {
	// REQUIRED; It can be CustomCopyOption or ImmediateCopyOption.
	CopyAfter CopyOptionClassification `json:"copyAfter,omitempty"`

	// REQUIRED; Info of target datastore
	DataStore *DataStoreInfoBase `json:"dataStore,omitempty"`
}

// TargetDetails - Class encapsulating target details, used where the destination is not a datasource
type TargetDetails struct {
	// REQUIRED; Restore operation may create multiple files inside location pointed by Url Below will be the common prefix for
	// all of them
	FilePrefix *string `json:"filePrefix,omitempty"`

	// REQUIRED; Denotes the target location where the data will be restored, string value for the enum {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}
	RestoreTargetLocationType *RestoreTargetLocationType `json:"restoreTargetLocationType,omitempty"`

	// REQUIRED; Url denoting the restore destination. It can point to container / file share etc
	URL *string `json:"url,omitempty"`
}

// TriggerBackupRequest - Trigger backup request
type TriggerBackupRequest struct {
	// REQUIRED; Name for the Rule of the Policy which needs to be applied for this backup
	BackupRuleOptions *AdHocBackupRuleOptions `json:"backupRuleOptions,omitempty"`
}

// TriggerContextClassification provides polymorphic access to related types.
// Call the interface's GetTriggerContext() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AdhocBasedTriggerContext, *ScheduleBasedTriggerContext, *TriggerContext
type TriggerContextClassification interface {
	// GetTriggerContext returns the TriggerContext content of the underlying type.
	GetTriggerContext() *TriggerContext
}

// TriggerContext - Trigger context
type TriggerContext struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string `json:"objectType,omitempty"`
}

// GetTriggerContext implements the TriggerContextClassification interface for type TriggerContext.
func (t *TriggerContext) GetTriggerContext() *TriggerContext { return t }

// UserFacingError - Error object used by layers that have access to localized content, and propagate that to user
type UserFacingError struct {
	// Unique code for this error
	Code *string `json:"code,omitempty"`

	// Additional related Errors
	Details []*UserFacingError `json:"details,omitempty"`

	// Inner Error
	InnerError *InnerError `json:"innerError,omitempty"`

	// Whether the operation will be retryable or not
	IsRetryable *bool `json:"isRetryable,omitempty"`

	// Whether the operation is due to a user error or service error
	IsUserError *bool   `json:"isUserError,omitempty"`
	Message     *string `json:"message,omitempty"`

	// Any key value pairs that can be injected inside error object
	Properties map[string]*string `json:"properties,omitempty"`

	// RecommendedAction � localized.
	RecommendedAction []*string `json:"recommendedAction,omitempty"`

	// Target of the error.
	Target *string `json:"target,omitempty"`
}

// ValidateForBackupRequest - Validate for backup request
type ValidateForBackupRequest struct {
	// REQUIRED; Backup Instance
	BackupInstance *BackupInstance `json:"backupInstance,omitempty"`
}

// ValidateRestoreRequestObject - Validate restore request object
type ValidateRestoreRequestObject struct {
	// REQUIRED; Gets or sets the restore request object.
	RestoreRequestObject AzureBackupRestoreRequestClassification `json:"restoreRequestObject,omitempty"`
}
