//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataboxedge

import "time"

// ARMBaseModel - Represents the base class for all object models.
type ARMBaseModel struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AddonClassification provides polymorphic access to related types.
// Call the interface's GetAddon() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Addon, *ArcAddon, *IoTAddon
type AddonClassification interface {
	// GetAddon returns the Addon content of the underlying type.
	GetAddon() *Addon
}

// Addon - Role Addon
type Addon struct {
	// REQUIRED; Addon type.
	Kind *AddonType `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Addon
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetAddon implements the AddonClassification interface for type Addon.
func (a *Addon) GetAddon() *Addon { return a }

// AddonList - Collection of all the Role addon on the Azure Stack Edge device.
type AddonList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The Value.
	Value []AddonClassification `json:"value,omitempty" azure:"ro"`
}

// AddonsClientBeginCreateOrUpdateOptions contains the optional parameters for the AddonsClient.BeginCreateOrUpdate method.
type AddonsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AddonsClientBeginDeleteOptions contains the optional parameters for the AddonsClient.BeginDelete method.
type AddonsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AddonsClientGetOptions contains the optional parameters for the AddonsClient.Get method.
type AddonsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AddonsClientListByRoleOptions contains the optional parameters for the AddonsClient.ListByRole method.
type AddonsClientListByRoleOptions struct {
	// placeholder for future optional parameters
}

// Address - The shipping address of the customer.
type Address struct {
	// REQUIRED; The country name.
	Country *string `json:"country,omitempty"`

	// The address line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`

	// The address line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`

	// The address line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`

	// The city name.
	City *string `json:"city,omitempty"`

	// The postal code.
	PostalCode *string `json:"postalCode,omitempty"`

	// The state name.
	State *string `json:"state,omitempty"`
}

// Alert on the data box edge/gateway device.
type Alert struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Properties of alert.
	Properties *AlertProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Alert
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertErrorDetails - Error details for the alert.
type AlertErrorDetails struct {
	// READ-ONLY; Error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Error Message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Number of occurrences.
	Occurrences *int32 `json:"occurrences,omitempty" azure:"ro"`
}

// AlertList - Collection of alerts.
type AlertList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The value.
	Value []*Alert `json:"value,omitempty" azure:"ro"`
}

// AlertProperties - Properties of alert.
type AlertProperties struct {
	// READ-ONLY; Alert type.
	AlertType *string `json:"alertType,omitempty" azure:"ro"`

	// READ-ONLY; UTC time when the alert appeared.
	AppearedAtDateTime *time.Time `json:"appearedAtDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Alert details.
	DetailedInformation map[string]*string `json:"detailedInformation,omitempty" azure:"ro"`

	// READ-ONLY; Error details of the alert.
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; Alert recommendation.
	Recommendation *string `json:"recommendation,omitempty" azure:"ro"`

	// READ-ONLY; Severity of the alert.
	Severity *AlertSeverity `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; Alert title.
	Title *string `json:"title,omitempty" azure:"ro"`
}

// AlertsClientGetOptions contains the optional parameters for the AlertsClient.Get method.
type AlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the AlertsClient.ListByDataBoxEdgeDevice
// method.
type AlertsClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// ArcAddon - Arc Addon.
type ArcAddon struct {
	// REQUIRED; Addon type.
	Kind *AddonType `json:"kind,omitempty"`

	// REQUIRED; Properties specific to Arc addon.
	Properties *ArcAddonProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Addon
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetAddon implements the AddonClassification interface for type ArcAddon.
func (a *ArcAddon) GetAddon() *Addon {
	return &Addon{
		Kind:       a.Kind,
		SystemData: a.SystemData,
		ID:         a.ID,
		Name:       a.Name,
		Type:       a.Type,
	}
}

// ArcAddonProperties - Arc addon properties.
type ArcAddonProperties struct {
	// REQUIRED; Arc resource group name
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// REQUIRED; Arc resource location
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// REQUIRED; Arc resource Name
	ResourceName *string `json:"resourceName,omitempty"`

	// REQUIRED; Arc resource subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Host OS supported by the Arc addon.
	HostPlatform *PlatformType `json:"hostPlatform,omitempty" azure:"ro"`

	// READ-ONLY; Platform where the runtime is hosted.
	HostPlatformType *HostPlatformType `json:"hostPlatformType,omitempty" azure:"ro"`

	// READ-ONLY; Addon Provisioning State
	ProvisioningState *AddonState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Arc resource version
	Version *string `json:"version,omitempty" azure:"ro"`
}

// AsymmetricEncryptedSecret - Represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// REQUIRED; The algorithm used to encrypt "Value".
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The value of the secret.
	Value *string `json:"value,omitempty"`

	// Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
}

// Authentication mechanism for IoT devices.
type Authentication struct {
	// Symmetric key for authentication.
	SymmetricKey *SymmetricKey `json:"symmetricKey,omitempty"`
}

// AvailableSKUsClientListOptions contains the optional parameters for the AvailableSKUsClient.List method.
type AvailableSKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// AzureContainerInfo - Azure container mapping of the endpoint.
type AzureContainerInfo struct {
	// REQUIRED; Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; Storage format used for the file represented by the share.
	DataFormat *AzureContainerDataFormat `json:"dataFormat,omitempty"`

	// REQUIRED; ID of the storage account credential used to access storage.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
}

// BandwidthSchedule - The bandwidth schedule details.
type BandwidthSchedule struct {
	// REQUIRED; The properties of the bandwidth schedule.
	Properties *BandwidthScheduleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of BandwidthSchedule
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BandwidthScheduleProperties - The properties of the bandwidth schedule.
type BandwidthScheduleProperties struct {
	// REQUIRED; The days of the week when this schedule is applicable.
	Days []*DayOfWeek `json:"days,omitempty"`

	// REQUIRED; The bandwidth rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`

	// REQUIRED; The start time of the schedule in UTC.
	Start *string `json:"start,omitempty"`

	// REQUIRED; The stop time of the schedule in UTC.
	Stop *string `json:"stop,omitempty"`
}

// BandwidthSchedulesClientBeginCreateOrUpdateOptions contains the optional parameters for the BandwidthSchedulesClient.BeginCreateOrUpdate
// method.
type BandwidthSchedulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BandwidthSchedulesClientBeginDeleteOptions contains the optional parameters for the BandwidthSchedulesClient.BeginDelete
// method.
type BandwidthSchedulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BandwidthSchedulesClientGetOptions contains the optional parameters for the BandwidthSchedulesClient.Get method.
type BandwidthSchedulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BandwidthSchedulesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the BandwidthSchedulesClient.ListByDataBoxEdgeDevice
// method.
type BandwidthSchedulesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// BandwidthSchedulesList - The collection of bandwidth schedules.
type BandwidthSchedulesList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of bandwidth schedules.
	Value []*BandwidthSchedule `json:"value,omitempty" azure:"ro"`
}

// ClientAccessRight - The mapping between a particular client IP and the type of access client has on the NFS share.
type ClientAccessRight struct {
	// REQUIRED; Type of access to be allowed for the client.
	AccessPermission *ClientPermissionType `json:"accessPermission,omitempty"`

	// REQUIRED; IP of the client.
	Client *string `json:"client,omitempty"`
}

// CloudEdgeManagementRole - The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing
// VMs on your Azure Stack Edge device from Azure Portal. For more information, refer to:
// https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview By using this feature,
// you agree to the preview legal terms. See the
// https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
type CloudEdgeManagementRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// Properties specific to CloudEdgeManagementRole role.
	Properties *CloudEdgeManagementRoleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type CloudEdgeManagementRole.
func (c *CloudEdgeManagementRole) GetRole() *Role {
	return &Role{
		Kind:       c.Kind,
		SystemData: c.SystemData,
		ID:         c.ID,
		Name:       c.Name,
		Type:       c.Type,
	}
}

// CloudEdgeManagementRoleProperties - CloudEdgeManagement Role properties.
type CloudEdgeManagementRoleProperties struct {
	// REQUIRED; Role status.
	RoleStatus *RoleStatus `json:"roleStatus,omitempty"`

	// READ-ONLY; Edge Profile of the resource
	EdgeProfile *EdgeProfile `json:"edgeProfile,omitempty" azure:"ro"`

	// READ-ONLY; Local Edge Management Status
	LocalManagementStatus *RoleStatus `json:"localManagementStatus,omitempty" azure:"ro"`
}

// CloudError - An error response from the service.
type CloudError struct {
	// The error details.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// ClusterCapacityViewData - Cluster Compute Data.
type ClusterCapacityViewData struct {
	// The FQDN of the cluster.
	Fqdn *string `json:"fqdn,omitempty"`

	// The cluster's GPU capacity.
	GpuCapacity *ClusterGpuCapacity `json:"gpuCapacity,omitempty"`

	// The last time at which the ClusterCapacityViewData was set.
	LastRefreshedTime *time.Time `json:"lastRefreshedTime,omitempty"`

	// The cluster's memory capacity.
	MemoryCapacity *ClusterMemoryCapacity `json:"memoryCapacity,omitempty"`

	// The total # of vCPUs provisioned by non-HPN VM per appliance.
	TotalProvisionedNonHpnCores *int64 `json:"totalProvisionedNonHpnCores,omitempty"`
}

// ClusterGpuCapacity - Cluster GPU Data.
type ClusterGpuCapacity struct {
	// The free GPU units count in the cluster.
	GpuFreeUnitsCount *int32 `json:"gpuFreeUnitsCount,omitempty"`

	// The GPU units count reserved for failover in the cluster.
	GpuReservedForFailoverUnitsCount *int32 `json:"gpuReservedForFailoverUnitsCount,omitempty"`

	// The total GPU units count in the cluster.
	GpuTotalUnitsCount *int32 `json:"gpuTotalUnitsCount,omitempty"`

	// The cluster GPU Type.
	GpuType *string `json:"gpuType,omitempty"`

	// The used GPU units count in the cluster.
	GpuUsedUnitsCount *int32 `json:"gpuUsedUnitsCount,omitempty"`
}

// ClusterMemoryCapacity - NodeCapacityInfo defines the required information to determine the placement of a VM.
type ClusterMemoryCapacity struct {
	// The failover memory in the cluster in MB.
	ClusterFailoverMemoryMb *float64 `json:"clusterFailoverMemoryMb,omitempty"`

	// The fragmentation memory in the cluster in MB.
	ClusterFragmentationMemoryMb *float64 `json:"clusterFragmentationMemoryMb,omitempty"`

	// The free memory in the cluster in MB.
	ClusterFreeMemoryMb *float64 `json:"clusterFreeMemoryMb,omitempty"`

	// The memory reserved for Hyper-V in the cluster in MB.
	ClusterHypervReserveMemoryMb *float64 `json:"clusterHypervReserveMemoryMb,omitempty"`

	// The memory of the Infra VM in the cluster in MB.
	ClusterInfraVMMemoryMb *float64 `json:"clusterInfraVmMemoryMb,omitempty"`

	// The memory used by VMs in the cluster in MB.
	ClusterMemoryUsedByVMsMb *float64 `json:"clusterMemoryUsedByVmsMb,omitempty"`

	// The non-failover memory in the cluster in MB.
	ClusterNonFailoverVMMb *float64 `json:"clusterNonFailoverVmMb,omitempty"`

	// The total memory in the cluster in MB.
	ClusterTotalMemoryMb *float64 `json:"clusterTotalMemoryMb,omitempty"`

	// The used memory in the cluster in MB.
	ClusterUsedMemoryMb *float64 `json:"clusterUsedMemoryMb,omitempty"`
}

// ClusterStorageViewData - Cluster Storage Data.
type ClusterStorageViewData struct {
	// The available or free storage on the cluster in MB.
	ClusterFreeStorageMb *float64 `json:"clusterFreeStorageMb,omitempty"`

	// Total storage on the cluster in MB.
	ClusterTotalStorageMb *float64 `json:"clusterTotalStorageMb,omitempty"`
}

// CniConfig - Cni configuration
type CniConfig struct {
	// READ-ONLY; Pod Subnet
	PodSubnet *string `json:"podSubnet,omitempty" azure:"ro"`

	// READ-ONLY; Service subnet
	ServiceSubnet *string `json:"serviceSubnet,omitempty" azure:"ro"`

	// READ-ONLY; Cni type
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Cni version
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ComputeResource - Compute infrastructure Resource
type ComputeResource struct {
	// REQUIRED; Memory in GB
	MemoryInGB *int64 `json:"memoryInGB,omitempty"`

	// REQUIRED; Processor count
	ProcessorCount *int32 `json:"processorCount,omitempty"`
}

// ContactDetails - Contains all the contact details of the customer.
type ContactDetails struct {
	// REQUIRED; The name of the company.
	CompanyName *string `json:"companyName,omitempty"`

	// REQUIRED; The contact person name.
	ContactPerson *string `json:"contactPerson,omitempty"`

	// REQUIRED; The email list.
	EmailList []*string `json:"emailList,omitempty"`

	// REQUIRED; The phone number.
	Phone *string `json:"phone,omitempty"`
}

// Container - Represents a container on the Data Box Edge/Gateway device.
type Container struct {
	// REQUIRED; The container properties.
	Properties *ContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Container
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerList - Collection of all the containers on the Data Box Edge/Gateway device.
type ContainerList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of containers.
	Value []*Container `json:"value,omitempty" azure:"ro"`
}

// ContainerProperties - The container properties.
type ContainerProperties struct {
	// REQUIRED; DataFormat for Container
	DataFormat *AzureContainerDataFormat `json:"dataFormat,omitempty"`

	// READ-ONLY; Current status of the container.
	ContainerStatus *ContainerStatus `json:"containerStatus,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time when container got created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Details of the refresh job on this container.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty" azure:"ro"`
}

// ContainersClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainersClient.BeginCreateOrUpdate
// method.
type ContainersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainersClientBeginDeleteOptions contains the optional parameters for the ContainersClient.BeginDelete method.
type ContainersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainersClientBeginRefreshOptions contains the optional parameters for the ContainersClient.BeginRefresh method.
type ContainersClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainersClientGetOptions contains the optional parameters for the ContainersClient.Get method.
type ContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainersClientListByStorageAccountOptions contains the optional parameters for the ContainersClient.ListByStorageAccount
// method.
type ContainersClientListByStorageAccountOptions struct {
	// placeholder for future optional parameters
}

// DCAccessCode - DC Access code in the case of Self Managed Shipping.
type DCAccessCode struct {
	// DCAccessCode properties.
	Properties *DCAccessCodeProperties `json:"properties,omitempty"`
}

// DCAccessCodeProperties - DCAccessCode Properties.
type DCAccessCodeProperties struct {
	// DCAccess Code for the Self Managed shipment.
	AuthCode *string `json:"authCode,omitempty"`
}

// DataResidency - Wraps data-residency related information for edge-resource and this should be used with ARM layer.
type DataResidency struct {
	// DataResidencyType enum
	Type *DataResidencyType `json:"type,omitempty"`
}

// Device - The Data Box Edge/Gateway device.
type Device struct {
	// REQUIRED; The location of the device. This is a supported and registered Azure geographical region (for example, West US,
	// East US, or Southeast Asia). The geographical region of a device cannot be changed once
	// it is created, but if an identical geographical region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`

	// The etag for the devices.
	Etag *string `json:"etag,omitempty"`

	// Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The properties of the Data Box Edge/Gateway device.
	Properties *DeviceProperties `json:"properties,omitempty"`

	// The SKU type.
	SKU *SKUInfo `json:"sku,omitempty"`

	// The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The kind of the device.
	Kind *DataBoxEdgeDeviceKind `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceCapacityCheckClientBeginCheckResourceCreationFeasibilityOptions contains the optional parameters for the DeviceCapacityCheckClient.BeginCheckResourceCreationFeasibility
// method.
type DeviceCapacityCheckClientBeginCheckResourceCreationFeasibilityOptions struct {
	// The capacity name.
	CapacityName *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeviceCapacityInfo - Object for Capturing DeviceCapacityInfo
type DeviceCapacityInfo struct {
	// The device capacity properties.
	Properties *DeviceCapacityInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to device capacity info.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceCapacityInfoClientGetDeviceCapacityInfoOptions contains the optional parameters for the DeviceCapacityInfoClient.GetDeviceCapacityInfo
// method.
type DeviceCapacityInfoClientGetDeviceCapacityInfoOptions struct {
	// placeholder for future optional parameters
}

// DeviceCapacityInfoProperties - The properties of Device Capacity Info
type DeviceCapacityInfoProperties struct {
	// Cluster capacity data for compute resources (Memory and GPU).
	ClusterComputeCapacityInfo *ClusterCapacityViewData `json:"clusterComputeCapacityInfo,omitempty"`

	// Cluster capacity data for storage resources (CSV).
	ClusterStorageCapacityInfo *ClusterStorageViewData `json:"clusterStorageCapacityInfo,omitempty"`

	// The dictionary of individual node names and node capacities in the cluster.
	NodeCapacityInfos map[string]*HostCapacity `json:"nodeCapacityInfos,omitempty"`

	// Timestamp of request in UTC
	TimeStamp *time.Time `json:"timeStamp,omitempty"`
}

// DeviceCapacityRequestInfo - Object for Capturing DeviceCapacityRequestInfo
type DeviceCapacityRequestInfo struct {
	// REQUIRED; The properties of the Device Capacity Request.
	Properties *DeviceCapacityRequestInfoProperties `json:"properties,omitempty"`
}

// DeviceCapacityRequestInfoProperties - Properties of Device Capacity Request Info containing VM's to be checked and their
// corresponding results.
type DeviceCapacityRequestInfoProperties struct {
	// REQUIRED; Array containing the sizes of the VMs for checking if its feasible to create them on the appliance.
	VMPlacementQuery [][]*string `json:"vmPlacementQuery,omitempty"`

	// Array of the VMs of the sizes in VmSizes can be provisioned on the appliance.
	VMPlacementResults []*VMPlacementRequestResult `json:"vmPlacementResults,omitempty"`
}

// DeviceExtendedInfo - The extended Info of the Data Box Edge/Gateway device.
type DeviceExtendedInfo struct {
	// The extended info properties.
	Properties *DeviceExtendedInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of DataBoxEdgeDevice
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceExtendedInfoPatch - The Data Box Edge/Gateway device extended info patch.
type DeviceExtendedInfoPatch struct {
	// The name for Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyName *string `json:"channelIntegrityKeyName,omitempty"`

	// The version of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyVersion *string `json:"channelIntegrityKeyVersion,omitempty"`

	// The Key Vault ARM Id for client secrets
	ClientSecretStoreID *string `json:"clientSecretStoreId,omitempty"`

	// The url to access the Client Key Vault
	ClientSecretStoreURL *string `json:"clientSecretStoreUrl,omitempty"`

	// For changing or to initiate the resync to key-vault set the status to KeyVaultSyncPending, rest of the status will not
	// be applicable.
	SyncStatus *KeyVaultSyncStatus `json:"syncStatus,omitempty"`
}

// DeviceExtendedInfoProperties - The properties of the Data Box Edge/Gateway device extended info.
type DeviceExtendedInfoProperties struct {
	// The name of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyName *string `json:"channelIntegrityKeyName,omitempty"`

	// The version of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyVersion *string `json:"channelIntegrityKeyVersion,omitempty"`

	// The Key Vault ARM Id for client secrets
	ClientSecretStoreID *string `json:"clientSecretStoreId,omitempty"`

	// The url to access the Client Key Vault
	ClientSecretStoreURL *string `json:"clientSecretStoreUrl,omitempty"`

	// The public part of the encryption certificate. Client uses this to encrypt any secret.
	EncryptionKey *string `json:"encryptionKey,omitempty"`

	// The digital signature of encrypted certificate.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`

	// Key vault sync status
	KeyVaultSyncStatus *KeyVaultSyncStatus `json:"keyVaultSyncStatus,omitempty"`

	// READ-ONLY; The Container for cloud witness in the storage account.
	CloudWitnessContainerName *string `json:"cloudWitnessContainerName,omitempty" azure:"ro"`

	// READ-ONLY; The Cloud Witness Storage account name.
	CloudWitnessStorageAccountName *string `json:"cloudWitnessStorageAccountName,omitempty" azure:"ro"`

	// READ-ONLY; The Azure service endpoint of the cloud witness storage account.
	CloudWitnessStorageEndpoint *string `json:"cloudWitnessStorageEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Cluster Witness Type
	ClusterWitnessType *ClusterWitnessType `json:"clusterWitnessType,omitempty" azure:"ro"`

	// READ-ONLY; Device secrets, will be returned only with ODataFilter $expand=deviceSecrets
	DeviceSecrets map[string]*Secret `json:"deviceSecrets,omitempty" azure:"ro"`

	// READ-ONLY; The witness location of file share.
	FileShareWitnessLocation *string `json:"fileShareWitnessLocation,omitempty" azure:"ro"`

	// READ-ONLY; The username of file share.
	FileShareWitnessUsername *string `json:"fileShareWitnessUsername,omitempty" azure:"ro"`

	// READ-ONLY; The Resource ID of the Resource.
	ResourceKey *string `json:"resourceKey,omitempty" azure:"ro"`
}

// DeviceList - The collection of Data Box Edge/Gateway devices.
type DeviceList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of Data Box Edge/Gateway devices.
	Value []*Device `json:"value,omitempty" azure:"ro"`
}

// DevicePatch - The Data Box Edge/Gateway device patch.
type DevicePatch struct {
	// Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The properties associated with the Data Box Edge/Gateway resource
	Properties *DevicePropertiesPatch `json:"properties,omitempty"`

	// The tags attached to the Data Box Edge/Gateway resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DeviceProperties - The properties of the Data Box Edge/Gateway device.
type DeviceProperties struct {
	// The details of data-residency related properties for this resource
	DataResidency *DataResidency `json:"dataResidency,omitempty"`

	// READ-ONLY; Type of compute roles configured.
	ConfiguredRoleTypes []*RoleTypes `json:"configuredRoleTypes,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device culture.
	Culture *string `json:"culture,omitempty" azure:"ro"`

	// READ-ONLY; The status of the Data Box Edge/Gateway device.
	DataBoxEdgeDeviceStatus *DataBoxEdgeDeviceStatus `json:"dataBoxEdgeDeviceStatus,omitempty" azure:"ro"`

	// READ-ONLY; The Description of the Data Box Edge/Gateway device.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The device software version number of the device (eg: 1.2.18105.6).
	DeviceHcsVersion *string `json:"deviceHcsVersion,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device local capacity in MB.
	DeviceLocalCapacity *int64 `json:"deviceLocalCapacity,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device model.
	DeviceModel *string `json:"deviceModel,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device software version.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Data Box Edge/Gateway device.
	DeviceType *DeviceType `json:"deviceType,omitempty" azure:"ro"`

	// READ-ONLY; The details of Edge Profile for this resource
	EdgeProfile *EdgeProfile `json:"edgeProfile,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device name.
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The description of the Data Box Edge/Gateway device model.
	ModelDescription *string `json:"modelDescription,omitempty" azure:"ro"`

	// READ-ONLY; The number of nodes in the cluster.
	NodeCount *int32 `json:"nodeCount,omitempty" azure:"ro"`

	// READ-ONLY; The details of the move operation on this resource.
	ResourceMoveDetails *ResourceMoveDetails `json:"resourceMoveDetails,omitempty" azure:"ro"`

	// READ-ONLY; The Serial Number of Data Box Edge/Gateway device.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; DataBoxEdge Device Properties
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The Data Box Edge/Gateway device timezone.
	TimeZone *string `json:"timeZone,omitempty" azure:"ro"`
}

// DevicePropertiesPatch - The Data Box Edge/Gateway device properties patch.
type DevicePropertiesPatch struct {
	// Edge Profile property of the Data Box Edge/Gateway device
	EdgeProfile *EdgeProfilePatch `json:"edgeProfile,omitempty"`
}

// DevicesClientBeginCreateOrUpdateSecuritySettingsOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdateSecuritySettings
// method.
type DevicesClientBeginCreateOrUpdateSecuritySettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
type DevicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDownloadUpdatesOptions contains the optional parameters for the DevicesClient.BeginDownloadUpdates method.
type DevicesClientBeginDownloadUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginInstallUpdatesOptions contains the optional parameters for the DevicesClient.BeginInstallUpdates method.
type DevicesClientBeginInstallUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginScanForUpdatesOptions contains the optional parameters for the DevicesClient.BeginScanForUpdates method.
type DevicesClientBeginScanForUpdatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientCreateOrUpdateOptions contains the optional parameters for the DevicesClient.CreateOrUpdate method.
type DevicesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGenerateCertificateOptions contains the optional parameters for the DevicesClient.GenerateCertificate method.
type DevicesClientGenerateCertificateOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetExtendedInformationOptions contains the optional parameters for the DevicesClient.GetExtendedInformation
// method.
type DevicesClientGetExtendedInformationOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetNetworkSettingsOptions contains the optional parameters for the DevicesClient.GetNetworkSettings method.
type DevicesClientGetNetworkSettingsOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
type DevicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientGetUpdateSummaryOptions contains the optional parameters for the DevicesClient.GetUpdateSummary method.
type DevicesClientGetUpdateSummaryOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListByResourceGroupOptions contains the optional parameters for the DevicesClient.ListByResourceGroup method.
type DevicesClientListByResourceGroupOptions struct {
	// Specify $expand=details to populate additional fields related to the resource or Specify $skipToken= to populate the next
	// page in the list.
	Expand *string
}

// DevicesClientListBySubscriptionOptions contains the optional parameters for the DevicesClient.ListBySubscription method.
type DevicesClientListBySubscriptionOptions struct {
	// Specify $expand=details to populate additional fields related to the resource or Specify $skipToken= to populate the next
	// page in the list.
	Expand *string
}

// DevicesClientUpdateExtendedInformationOptions contains the optional parameters for the DevicesClient.UpdateExtendedInformation
// method.
type DevicesClientUpdateExtendedInformationOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientUpdateOptions contains the optional parameters for the DevicesClient.Update method.
type DevicesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientUploadCertificateOptions contains the optional parameters for the DevicesClient.UploadCertificate method.
type DevicesClientUploadCertificateOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticProactiveLogCollectionSettings - The diagnostic proactive log collection settings of a device.
type DiagnosticProactiveLogCollectionSettings struct {
	// REQUIRED; Properties of the diagnostic proactive log collection settings.
	Properties *ProactiveLogCollectionSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of DiagnosticProactiveLogCollectionSettings
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticRemoteSupportSettings - The remote support settings of a device.
type DiagnosticRemoteSupportSettings struct {
	// REQUIRED; Properties of the remote support settings.
	Properties *DiagnosticRemoteSupportSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Represents resource creation and updation time
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticRemoteSupportSettingsProperties - The properties of remote support settings.
type DiagnosticRemoteSupportSettingsProperties struct {
	// Remote support settings list according to the RemoteApplicationType
	RemoteSupportSettingsList []*RemoteSupportSettings `json:"remoteSupportSettingsList,omitempty"`
}

// DiagnosticSettingsClientBeginUpdateDiagnosticProactiveLogCollectionSettingsOptions contains the optional parameters for
// the DiagnosticSettingsClient.BeginUpdateDiagnosticProactiveLogCollectionSettings method.
type DiagnosticSettingsClientBeginUpdateDiagnosticProactiveLogCollectionSettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiagnosticSettingsClientBeginUpdateDiagnosticRemoteSupportSettingsOptions contains the optional parameters for the DiagnosticSettingsClient.BeginUpdateDiagnosticRemoteSupportSettings
// method.
type DiagnosticSettingsClientBeginUpdateDiagnosticRemoteSupportSettingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiagnosticSettingsClientGetDiagnosticProactiveLogCollectionSettingsOptions contains the optional parameters for the DiagnosticSettingsClient.GetDiagnosticProactiveLogCollectionSettings
// method.
type DiagnosticSettingsClientGetDiagnosticProactiveLogCollectionSettingsOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientGetDiagnosticRemoteSupportSettingsOptions contains the optional parameters for the DiagnosticSettingsClient.GetDiagnosticRemoteSupportSettings
// method.
type DiagnosticSettingsClientGetDiagnosticRemoteSupportSettingsOptions struct {
	// placeholder for future optional parameters
}

// EdgeProfile - Details about Edge Profile for the resource
type EdgeProfile struct {
	// Edge Profile Subscription
	Subscription *EdgeProfileSubscription `json:"subscription,omitempty"`
}

// EdgeProfilePatch - The Data Box Edge/Gateway Edge Profile patch.
type EdgeProfilePatch struct {
	// The Data Box Edge/Gateway Edge Profile Subscription patch
	Subscription *EdgeProfileSubscriptionPatch `json:"subscription,omitempty"`
}

// EdgeProfileSubscription - Subscription details for the Edge Profile
type EdgeProfileSubscription struct {
	// ARM ID of the subscription
	ID               *string                 `json:"id,omitempty"`
	Properties       *SubscriptionProperties `json:"properties,omitempty"`
	RegistrationDate *string                 `json:"registrationDate,omitempty"`

	// Edge Subscription Registration ID
	RegistrationID *string            `json:"registrationId,omitempty"`
	State          *SubscriptionState `json:"state,omitempty"`
	SubscriptionID *string            `json:"subscriptionId,omitempty"`
}

// EdgeProfileSubscriptionPatch - The Data Box Edge/Gateway Edge Profile Subscription patch.
type EdgeProfileSubscriptionPatch struct {
	// The path ID that uniquely identifies the subscription of the edge profile.
	ID *string `json:"id,omitempty"`
}

// EtcdInfo - Etcd configuration
type EtcdInfo struct {
	// READ-ONLY; Etcd type
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Etcd version
	Version *string `json:"version,omitempty" azure:"ro"`
}

// FileEventTrigger - Trigger details.
type FileEventTrigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType `json:"kind,omitempty"`

	// REQUIRED; File trigger properties.
	Properties *FileTriggerProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Trigger
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type FileEventTrigger.
func (f *FileEventTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Kind:       f.Kind,
		SystemData: f.SystemData,
		ID:         f.ID,
		Name:       f.Name,
		Type:       f.Type,
	}
}

// FileSourceInfo - File source details.
type FileSourceInfo struct {
	// REQUIRED; File share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// FileTriggerProperties - File trigger properties.
type FileTriggerProperties struct {
	// REQUIRED; Role sink info.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`

	// REQUIRED; File event source details.
	SourceInfo *FileSourceInfo `json:"sourceInfo,omitempty"`

	// A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger
	// is intended for certain specific IoT modules in the device, the tag can be the
	// name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// GenerateCertResponse - Used in activation key generation flow.
type GenerateCertResponse struct {
	// Gets or sets expiry time in UTC
	ExpiryTimeInUTC *string `json:"expiryTimeInUTC,omitempty"`

	// Gets or sets base64 encoded private part of the certificate, needed to form the activation key
	PrivateKey *string `json:"privateKey,omitempty"`

	// Gets or sets base64 encoded certificate raw data, this is the public part needed to be uploaded to cert vault
	PublicKey *string `json:"publicKey,omitempty"`
}

// HostCapacity - Host Capacity Data.
type HostCapacity struct {
	// The available amount of GPUs on the host to use after accounting for GPUS used by reservations on the host.
	AvailableGpuCount *int32 `json:"availableGpuCount,omitempty"`

	// The available memory on the host accounting for VM placement size and any host VM reservations.
	EffectiveAvailableMemoryMbOnHost *int64 `json:"effectiveAvailableMemoryMbOnHost,omitempty"`

	// The GPU type of the VM.
	GpuType *string `json:"gpuType,omitempty"`

	// The name of the host.
	HostName *string `json:"hostName,omitempty"`

	// The numa nodes information for Hpn VMs.
	NumaNodesData []*NumaNodeData `json:"numaNodesData,omitempty"`

	// The VM used memory per VmId.
	VMUsedMemory map[string]*VMMemory `json:"vmUsedMemory,omitempty"`
}

// IPv4Config - Details related to the IPv4 address configuration.
type IPv4Config struct {
	// READ-ONLY; The IPv4 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty" azure:"ro"`

	// READ-ONLY; The IPv4 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`

	// READ-ONLY; The IPv4 subnet of the network adapter.
	Subnet *string `json:"subnet,omitempty" azure:"ro"`
}

// IPv6Config - Details related to the IPv6 address configuration.
type IPv6Config struct {
	// READ-ONLY; The IPv6 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 prefix of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty" azure:"ro"`
}

// ImageRepositoryCredential - Image repository credential.
type ImageRepositoryCredential struct {
	// REQUIRED; Image repository url (e.g.: mcr.microsoft.com).
	ImageRepositoryURL *string `json:"imageRepositoryUrl,omitempty"`

	// REQUIRED; Repository user name.
	UserName *string `json:"userName,omitempty"`

	// Repository user password.
	Password *AsymmetricEncryptedSecret `json:"password,omitempty"`
}

// IoTAddon - IoT Addon.
type IoTAddon struct {
	// REQUIRED; Addon type.
	Kind *AddonType `json:"kind,omitempty"`

	// REQUIRED; Properties specific to IOT addon.
	Properties *IoTAddonProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Addon
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetAddon implements the AddonClassification interface for type IoTAddon.
func (i *IoTAddon) GetAddon() *Addon {
	return &Addon{
		Kind:       i.Kind,
		SystemData: i.SystemData,
		ID:         i.ID,
		Name:       i.Name,
		Type:       i.Type,
	}
}

// IoTAddonProperties - IoT addon properties.
type IoTAddonProperties struct {
	// REQUIRED; IoT device metadata to which appliance needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`

	// REQUIRED; IoT edge device to which the IoT Addon needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`

	// READ-ONLY; Host OS supported by the IoT addon.
	HostPlatform *PlatformType `json:"hostPlatform,omitempty" azure:"ro"`

	// READ-ONLY; Platform where the runtime is hosted.
	HostPlatformType *HostPlatformType `json:"hostPlatformType,omitempty" azure:"ro"`

	// READ-ONLY; Addon Provisioning State
	ProvisioningState *AddonState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Version of IoT running on the appliance.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// IoTDeviceInfo - Metadata of IoT device/IoT Edge device to be configured.
type IoTDeviceInfo struct {
	// REQUIRED; ID of the IoT device/edge device.
	DeviceID *string `json:"deviceId,omitempty"`

	// REQUIRED; Host name for the IoT hub associated to the device.
	IoTHostHub *string `json:"ioTHostHub,omitempty"`

	// Encrypted IoT device/IoT edge device connection string.
	Authentication *Authentication `json:"authentication,omitempty"`

	// Id for the IoT hub associated to the device.
	IoTHostHubID *string `json:"ioTHostHubId,omitempty"`
}

// IoTEdgeAgentInfo - IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping
// IoT Role if specified.
type IoTEdgeAgentInfo struct {
	// REQUIRED; Name of the IoT edge agent image.
	ImageName *string `json:"imageName,omitempty"`

	// REQUIRED; Image Tag.
	Tag *string `json:"tag,omitempty"`

	// Image repository details.
	ImageRepository *ImageRepositoryCredential `json:"imageRepository,omitempty"`
}

// IoTRole - Compute role.
type IoTRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// Properties specific to IoT role.
	Properties *IoTRoleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type IoTRole.
func (i *IoTRole) GetRole() *Role {
	return &Role{
		Kind:       i.Kind,
		SystemData: i.SystemData,
		ID:         i.ID,
		Name:       i.Name,
		Type:       i.Type,
	}
}

// IoTRoleProperties - IoT role properties.
type IoTRoleProperties struct {
	// REQUIRED; Host OS supported by the IoT role.
	HostPlatform *PlatformType `json:"hostPlatform,omitempty"`

	// REQUIRED; IoT device metadata to which data box edge device needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`

	// REQUIRED; IoT edge device to which the IoT role needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`

	// REQUIRED; Role status.
	RoleStatus *RoleStatus `json:"roleStatus,omitempty"`

	// Resource allocation
	ComputeResource *ComputeResource `json:"computeResource,omitempty"`

	// Iot edge agent details to download the agent and bootstrap iot runtime.
	IoTEdgeAgentInfo *IoTEdgeAgentInfo `json:"ioTEdgeAgentInfo,omitempty"`

	// Mount points of shares in role(s).
	ShareMappings []*MountPointMap `json:"shareMappings,omitempty"`

	// READ-ONLY; Platform where the Iot runtime is hosted.
	HostPlatformType *HostPlatformType `json:"hostPlatformType,omitempty" azure:"ro"`
}

// Job - A device job.
type Job struct {
	// READ-ONLY; The UTC date and time at which the job completed.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Error *JobErrorDetails `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the job that is complete.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The properties of the job.
	Properties *JobProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time at which the job started.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the job.
	Status *JobStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobErrorDetails - The job error information containing the list of job errors.
type JobErrorDetails struct {
	// READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	ErrorDetails []*JobErrorItem `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// JobErrorItem - The job error items.
type JobErrorItem struct {
	// READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The recommended actions.
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`
}

// JobProperties - The properties for the job.
type JobProperties struct {
	// If only subfolders need to be refreshed, then the subfolder path inside the share or container. (The path is empty if there
	// are no subfolders.)
	Folder *string `json:"folder,omitempty"`

	// READ-ONLY; Current stage of the update operation.
	CurrentStage *UpdateOperationStage `json:"currentStage,omitempty" azure:"ro"`

	// READ-ONLY; The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty" azure:"ro"`

	// READ-ONLY; Local share/remote container relative path to the error manifest file of the refresh.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty" azure:"ro"`

	// READ-ONLY; The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty" azure:"ro"`

	// READ-ONLY; The type of the job.
	JobType *JobType `json:"jobType,omitempty" azure:"ro"`

	// READ-ONLY; ARM ID of the entity that was refreshed.
	RefreshedEntityID *string `json:"refreshedEntityId,omitempty" azure:"ro"`

	// READ-ONLY; Total number of errors encountered during the refresh process.
	TotalRefreshErrors *int32 `json:"totalRefreshErrors,omitempty" azure:"ro"`
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KubernetesClusterInfo - Kubernetes cluster configuration
type KubernetesClusterInfo struct {
	// REQUIRED; Kubernetes cluster version
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Etcd configuration
	EtcdInfo *EtcdInfo `json:"etcdInfo,omitempty" azure:"ro"`

	// READ-ONLY; Kubernetes cluster nodes
	Nodes []*NodeInfo `json:"nodes,omitempty" azure:"ro"`
}

// KubernetesIPConfiguration - Kubernetes node IP configuration
type KubernetesIPConfiguration struct {
	// IP address of the Kubernetes node.
	IPAddress *string `json:"ipAddress,omitempty"`

	// READ-ONLY; Port of the Kubernetes node.
	Port *string `json:"port,omitempty" azure:"ro"`
}

// KubernetesRole - The limited preview of Kubernetes Cluster Management from the Azure supports:
// 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
// 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure
// Portal. Azure Arc enables organizations to view, manage, and govern their
// on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
// 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data. For more information, refer
// to the document here:
// https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
// Or Demo:
// https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
// By using this feature, you agree to the preview legal terms. See the
// https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
type KubernetesRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// Properties specific to Kubernetes role.
	Properties *KubernetesRoleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type KubernetesRole.
func (k *KubernetesRole) GetRole() *Role {
	return &Role{
		Kind:       k.Kind,
		SystemData: k.SystemData,
		ID:         k.ID,
		Name:       k.Name,
		Type:       k.Type,
	}
}

// KubernetesRoleCompute - Kubernetes role compute resource
type KubernetesRoleCompute struct {
	// REQUIRED; VM profile
	VMProfile *string `json:"vmProfile,omitempty"`

	// READ-ONLY; Memory in bytes
	MemoryInBytes *int64 `json:"memoryInBytes,omitempty" azure:"ro"`

	// READ-ONLY; Processor count
	ProcessorCount *int32 `json:"processorCount,omitempty" azure:"ro"`
}

// KubernetesRoleNetwork - Kubernetes role network resource
type KubernetesRoleNetwork struct {
	// READ-ONLY; Cni configuration
	CniConfig *CniConfig `json:"cniConfig,omitempty" azure:"ro"`

	// READ-ONLY; Load balancer configuration
	LoadBalancerConfig *LoadBalancerConfig `json:"loadBalancerConfig,omitempty" azure:"ro"`
}

// KubernetesRoleProperties - Kubernetes role properties.
type KubernetesRoleProperties struct {
	// REQUIRED; Host OS supported by the Kubernetes role.
	HostPlatform *PlatformType `json:"hostPlatform,omitempty"`

	// REQUIRED; Kubernetes cluster configuration
	KubernetesClusterInfo *KubernetesClusterInfo `json:"kubernetesClusterInfo,omitempty"`

	// REQUIRED; Kubernetes role resources
	KubernetesRoleResources *KubernetesRoleResources `json:"kubernetesRoleResources,omitempty"`

	// REQUIRED; Role status.
	RoleStatus *RoleStatus `json:"roleStatus,omitempty"`

	// READ-ONLY; Platform where the runtime is hosted.
	HostPlatformType *HostPlatformType `json:"hostPlatformType,omitempty" azure:"ro"`

	// READ-ONLY; State of Kubernetes deployment
	ProvisioningState *KubernetesState `json:"provisioningState,omitempty" azure:"ro"`
}

// KubernetesRoleResources - Kubernetes role resources
type KubernetesRoleResources struct {
	// REQUIRED; Kubernetes role compute resource
	Compute *KubernetesRoleCompute `json:"compute,omitempty"`

	// Kubernetes role storage resource
	Storage *KubernetesRoleStorage `json:"storage,omitempty"`

	// READ-ONLY; Kubernetes role network resource
	Network *KubernetesRoleNetwork `json:"network,omitempty" azure:"ro"`
}

// KubernetesRoleStorage - Kubernetes role storage resource
type KubernetesRoleStorage struct {
	// Mount points of shares in role(s).
	Endpoints []*MountPointMap `json:"endpoints,omitempty"`

	// READ-ONLY; Kubernetes storage class info.
	StorageClasses []*KubernetesRoleStorageClassInfo `json:"storageClasses,omitempty" azure:"ro"`
}

// KubernetesRoleStorageClassInfo - Kubernetes storage class info.
type KubernetesRoleStorageClassInfo struct {
	// READ-ONLY; Storage class name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; If provisioned storage is posix compliant.
	PosixCompliant *PosixComplianceStatus `json:"posixCompliant,omitempty" azure:"ro"`

	// READ-ONLY; Storage class type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LoadBalancerConfig - Load balancer configuration
type LoadBalancerConfig struct {
	// READ-ONLY; Load balancer type
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Load balancer version
	Version *string `json:"version,omitempty" azure:"ro"`
}

// MECRole - MEC role.
type MECRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// Properties specific to MEC role.
	Properties *MECRoleProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type MECRole.
func (m *MECRole) GetRole() *Role {
	return &Role{
		Kind:       m.Kind,
		SystemData: m.SystemData,
		ID:         m.ID,
		Name:       m.Name,
		Type:       m.Type,
	}
}

// MECRoleProperties - MEC role properties.
type MECRoleProperties struct {
	// REQUIRED; Role status.
	RoleStatus *RoleStatus `json:"roleStatus,omitempty"`

	// Activation key of the MEC.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`

	// Controller Endpoint.
	ControllerEndpoint *string `json:"controllerEndpoint,omitempty"`

	// Unique Id of the Resource.
	ResourceUniqueID *string `json:"resourceUniqueId,omitempty"`
}

// MetricConfiguration - Metric configuration.
type MetricConfiguration struct {
	// REQUIRED; Host name for the IoT hub associated to the device.
	CounterSets []*MetricCounterSet `json:"counterSets,omitempty"`

	// REQUIRED; The Resource ID on which the metrics should be pushed.
	ResourceID *string `json:"resourceId,omitempty"`

	// The MDM account to which the counters should be pushed.
	MdmAccount *string `json:"mdmAccount,omitempty"`

	// The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
	MetricNameSpace *string `json:"metricNameSpace,omitempty"`
}

// MetricCounter - The metric counter
type MetricCounter struct {
	// REQUIRED; The counter name.
	Name *string `json:"name,omitempty"`

	// The additional dimensions to be added to metric.
	AdditionalDimensions []*MetricDimension `json:"additionalDimensions,omitempty"`

	// The dimension filter.
	DimensionFilter []*MetricDimension `json:"dimensionFilter,omitempty"`

	// The instance from which counter should be collected.
	Instance *string `json:"instance,omitempty"`
}

// MetricCounterSet - The metric counter set
type MetricCounterSet struct {
	// REQUIRED; The counters that should be collected in this set.
	Counters []*MetricCounter `json:"counters,omitempty"`
}

// MetricDimension - The metric dimension
type MetricDimension struct {
	// REQUIRED; The dimension value.
	SourceName *string `json:"sourceName,omitempty"`

	// REQUIRED; The dimension type.
	SourceType *string `json:"sourceType,omitempty"`
}

// MetricDimensionV1 - Metric Dimension v1.
type MetricDimensionV1 struct {
	// Display name of the metrics dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the metrics dimension.
	Name *string `json:"name,omitempty"`

	// To be exported to shoe box.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecificationV1 - Metric specification version 1.
type MetricSpecificationV1 struct {
	// Metric aggregation type.
	AggregationType *MetricAggregationType `json:"aggregationType,omitempty"`

	// Metric category.
	Category *MetricCategory `json:"category,omitempty"`

	// Metric dimensions, other than default dimension which is resource.
	Dimensions []*MetricDimensionV1 `json:"dimensions,omitempty"`

	// Description of the metric to be displayed.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Set true to fill the gaps with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of the metric.
	Name *string `json:"name,omitempty"`

	// Resource name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// Support metric aggregation type.
	SupportedAggregationTypes []*MetricAggregationType `json:"supportedAggregationTypes,omitempty"`

	// Support granularity of metrics.
	SupportedTimeGrainTypes []*TimeGrain `json:"supportedTimeGrainTypes,omitempty"`

	// Metric units.
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MonitoringConfigClientBeginCreateOrUpdateOptions contains the optional parameters for the MonitoringConfigClient.BeginCreateOrUpdate
// method.
type MonitoringConfigClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitoringConfigClientBeginDeleteOptions contains the optional parameters for the MonitoringConfigClient.BeginDelete method.
type MonitoringConfigClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitoringConfigClientGetOptions contains the optional parameters for the MonitoringConfigClient.Get method.
type MonitoringConfigClientGetOptions struct {
	// placeholder for future optional parameters
}

// MonitoringConfigClientListOptions contains the optional parameters for the MonitoringConfigClient.List method.
type MonitoringConfigClientListOptions struct {
	// placeholder for future optional parameters
}

// MonitoringMetricConfiguration - The metric setting details for the role
type MonitoringMetricConfiguration struct {
	// REQUIRED; The metric setting properties.
	Properties *MonitoringMetricConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of MonitoringConfiguration
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MonitoringMetricConfigurationList - Collection of metric configurations.
type MonitoringMetricConfigurationList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of metric configurations.
	Value []*MonitoringMetricConfiguration `json:"value,omitempty" azure:"ro"`
}

// MonitoringMetricConfigurationProperties - Metrics properties
type MonitoringMetricConfigurationProperties struct {
	// REQUIRED; The metrics configuration details
	MetricConfigurations []*MetricConfiguration `json:"metricConfigurations,omitempty"`
}

// MountPointMap - The share mount point.
type MountPointMap struct {
	// REQUIRED; ID of the share mounted to the role VM.
	ShareID *string `json:"shareId,omitempty"`

	// READ-ONLY; Mount point for the share.
	MountPoint *string `json:"mountPoint,omitempty" azure:"ro"`

	// READ-ONLY; Mounting type.
	MountType *MountType `json:"mountType,omitempty" azure:"ro"`

	// READ-ONLY; ID of the role to which share is mounted.
	RoleID *string `json:"roleId,omitempty" azure:"ro"`

	// READ-ONLY; Role type.
	RoleType *RoleTypes `json:"roleType,omitempty" azure:"ro"`
}

// MoveRequest - Resource Move details
type MoveRequest struct {
	// REQUIRED; List of resources to be moved
	Resources []*string `json:"resources,omitempty"`

	// REQUIRED; Target resource group ARMId
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// NetworkAdapter - Represents the networkAdapter on a device.
type NetworkAdapter struct {
	// Value indicating whether this adapter has DHCP enabled.
	DhcpStatus *NetworkAdapterDHCPStatus `json:"dhcpStatus,omitempty"`

	// Value indicating whether this adapter is RDMA capable.
	RdmaStatus *NetworkAdapterRDMAStatus `json:"rdmaStatus,omitempty"`

	// READ-ONLY; Instance ID of network adapter.
	AdapterID *string `json:"adapterId,omitempty" azure:"ro"`

	// READ-ONLY; Hardware position of network adapter.
	AdapterPosition *NetworkAdapterPosition `json:"adapterPosition,omitempty" azure:"ro"`

	// READ-ONLY; The list of DNS Servers of the device.
	DNSServers []*string `json:"dnsServers,omitempty" azure:"ro"`

	// READ-ONLY; The IPv4 configuration of the network adapter.
	IPv4Configuration *IPv4Config `json:"ipv4Configuration,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 configuration of the network adapter.
	IPv6Configuration *IPv6Config `json:"ipv6Configuration,omitempty" azure:"ro"`

	// READ-ONLY; The IPv6 local address.
	IPv6LinkLocalAddress *string `json:"ipv6LinkLocalAddress,omitempty" azure:"ro"`

	// READ-ONLY; Logical index of the adapter.
	Index *int32 `json:"index,omitempty" azure:"ro"`

	// READ-ONLY; Hardware label for the adapter.
	Label *string `json:"label,omitempty" azure:"ro"`

	// READ-ONLY; Link speed.
	LinkSpeed *int64 `json:"linkSpeed,omitempty" azure:"ro"`

	// READ-ONLY; MAC address.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Network adapter name.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty" azure:"ro"`

	// READ-ONLY; Node ID of the network adapter.
	NodeID *string `json:"nodeId,omitempty" azure:"ro"`

	// READ-ONLY; Value indicating whether this adapter is valid.
	Status *NetworkAdapterStatus `json:"status,omitempty" azure:"ro"`
}

// NetworkAdapterPosition - The network adapter position.
type NetworkAdapterPosition struct {
	// READ-ONLY; The network group.
	NetworkGroup *NetworkGroup `json:"networkGroup,omitempty" azure:"ro"`

	// READ-ONLY; The port.
	Port *int32 `json:"port,omitempty" azure:"ro"`
}

// NetworkSettings - The network settings of a device.
type NetworkSettings struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of network settings of a device.
	Properties *NetworkSettingsProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of NetworkSettings
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkSettingsProperties - The properties of network settings.
type NetworkSettingsProperties struct {
	// READ-ONLY; The network adapter list on the device.
	NetworkAdapters []*NetworkAdapter `json:"networkAdapters,omitempty" azure:"ro"`
}

// Node - Represents a single node in a Data box Edge/Gateway device Gateway devices, standalone Edge devices and a single
// node cluster Edge device will all have 1 node Multi-node Edge devices will have more
// than 1 nodes
type Node struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of the node
	Properties *NodeProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NodeInfo - Kubernetes node info
type NodeInfo struct {
	// IP Configuration of the Kubernetes node.
	IPConfiguration []*KubernetesIPConfiguration `json:"ipConfiguration,omitempty"`

	// READ-ONLY; Node name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Node type - Master/Worker
	Type *KubernetesNodeType `json:"type,omitempty" azure:"ro"`
}

// NodeList - Collection of Nodes.
type NodeList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of Nodes.
	Value []*Node `json:"value,omitempty" azure:"ro"`
}

// NodeProperties - This class represents the nodes in a highly available cluster
type NodeProperties struct {
	// READ-ONLY; Serial number of the Chassis
	NodeChassisSerialNumber *string `json:"nodeChassisSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the individual node
	NodeDisplayName *string `json:"nodeDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Friendly software version name that is currently installed on the node
	NodeFriendlySoftwareVersion *string `json:"nodeFriendlySoftwareVersion,omitempty" azure:"ro"`

	// READ-ONLY; HCS version that is currently installed on the node
	NodeHcsVersion *string `json:"nodeHcsVersion,omitempty" azure:"ro"`

	// READ-ONLY; Guid instance id of the node
	NodeInstanceID *string `json:"nodeInstanceId,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the individual node
	NodeSerialNumber *string `json:"nodeSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the individual node
	NodeStatus *NodeStatus `json:"nodeStatus,omitempty" azure:"ro"`
}

// NodesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the NodesClient.ListByDataBoxEdgeDevice
// method.
type NodesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// NumaNodeData - NUMA node data.
type NumaNodeData struct {
	// The effective available memory on the NUMA node in MB.
	EffectiveAvailableMemoryInMb *int64 `json:"effectiveAvailableMemoryInMb,omitempty"`

	// The free VCPU indices for the Hpn VMs.
	FreeVCPUIndexesForHpn []*int32 `json:"freeVCpuIndexesForHpn,omitempty"`

	// The logical cores per core count.
	LogicalCoreCountPerCore *int32 `json:"logicalCoreCountPerCore,omitempty"`

	// The NUMA node index.
	NumaNodeIndex *int32 `json:"numaNodeIndex,omitempty"`

	// The total memory on the NUMA node.
	TotalMemoryInMb *int64 `json:"totalMemoryInMb,omitempty"`

	// The VCPU indices for Hpn VMs
	VCPUIndexesForHpn []*int32 `json:"vCpuIndexesForHpn,omitempty"`

	// The VCPU indices for the root.
	VCPUIndexesForRoot []*int32 `json:"vCpuIndexesForRoot,omitempty"`
}

// Operations.
type Operation struct {
	// Properties displayed for the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Is data action.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation.
	Name *string `json:"name,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Operation properties.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - Operation display properties.
type OperationDisplay struct {
	// Description of the operation to be performed.
	Description *string `json:"description,omitempty"`

	// Operation to be performed on the resource.
	Operation *string `json:"operation,omitempty"`

	// Provider name.
	Provider *string `json:"provider,omitempty"`

	// The type of resource in which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationProperties - Operation properties.
type OperationProperties struct {
	// Service specification.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsList - The list of operations used for the discovery of available provider operations.
type OperationsList struct {
	// REQUIRED; The value.
	Value []*Operation `json:"value,omitempty"`

	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsStatusClientGetOptions contains the optional parameters for the OperationsStatusClient.Get method.
type OperationsStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// Order - The order details.
type Order struct {
	// The order properties.
	Properties *OrderProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; It specify the order api version.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Order
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OrderList - List of order entities.
type OrderList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of orders.
	Value []*Order `json:"value,omitempty" azure:"ro"`
}

// OrderProperties - Order properties.
type OrderProperties struct {
	// REQUIRED; The contact details.
	ContactInformation *ContactDetails `json:"contactInformation,omitempty"`

	// ShipmentType of the order
	ShipmentType *ShipmentType `json:"shipmentType,omitempty"`

	// The shipping address.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`

	// READ-ONLY; Current status of the order.
	CurrentStatus *OrderStatus `json:"currentStatus,omitempty" azure:"ro"`

	// READ-ONLY; Tracking information for the package delivered to the customer whether it has an original or a replacement device.
	DeliveryTrackingInfo []*TrackingInfo `json:"deliveryTrackingInfo,omitempty" azure:"ro"`

	// READ-ONLY; List of status changes in the order.
	OrderHistory []*OrderStatus `json:"orderHistory,omitempty" azure:"ro"`

	// READ-ONLY; It specify the order resource id.
	OrderID *string `json:"orderId,omitempty" azure:"ro"`

	// READ-ONLY; Tracking information for the package returned from the customer whether it has an original or a replacement
	// device.
	ReturnTrackingInfo []*TrackingInfo `json:"returnTrackingInfo,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the device.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`
}

// OrderStatus - Represents a single status change.
type OrderStatus struct {
	// REQUIRED; Status of the order as per the allowed status types.
	Status *OrderState `json:"status,omitempty"`

	// Comments related to this status change.
	Comments *string `json:"comments,omitempty"`

	// READ-ONLY; Dictionary to hold generic information which is not stored by the already existing properties
	AdditionalOrderDetails map[string]*string `json:"additionalOrderDetails,omitempty" azure:"ro"`

	// READ-ONLY; Tracking information related to the state in the ordering flow
	TrackingInformation *TrackingInfo `json:"trackingInformation,omitempty" azure:"ro"`

	// READ-ONLY; Time of status update.
	UpdateDateTime *time.Time `json:"updateDateTime,omitempty" azure:"ro"`
}

// OrdersClientBeginCreateOrUpdateOptions contains the optional parameters for the OrdersClient.BeginCreateOrUpdate method.
type OrdersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OrdersClientBeginDeleteOptions contains the optional parameters for the OrdersClient.BeginDelete method.
type OrdersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OrdersClientGetOptions contains the optional parameters for the OrdersClient.Get method.
type OrdersClientGetOptions struct {
	// placeholder for future optional parameters
}

// OrdersClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the OrdersClient.ListByDataBoxEdgeDevice
// method.
type OrdersClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// OrdersClientListDCAccessCodeOptions contains the optional parameters for the OrdersClient.ListDCAccessCode method.
type OrdersClientListDCAccessCodeOptions struct {
	// placeholder for future optional parameters
}

// PeriodicTimerEventTrigger - Trigger details.
type PeriodicTimerEventTrigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType `json:"kind,omitempty"`

	// REQUIRED; Periodic timer trigger properties.
	Properties *PeriodicTimerProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Trigger
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type PeriodicTimerEventTrigger.
func (p *PeriodicTimerEventTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Kind:       p.Kind,
		SystemData: p.SystemData,
		ID:         p.ID,
		Name:       p.Name,
		Type:       p.Type,
	}
}

// PeriodicTimerProperties - Periodic timer trigger properties.
type PeriodicTimerProperties struct {
	// REQUIRED; Role Sink information.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`

	// REQUIRED; Periodic timer details.
	SourceInfo *PeriodicTimerSourceInfo `json:"sourceInfo,omitempty"`

	// A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger
	// is intended for certain specific IoT modules in the device, the tag can be the
	// name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// PeriodicTimerSourceInfo - Periodic timer event source.
type PeriodicTimerSourceInfo struct {
	// REQUIRED; Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
	Schedule *string `json:"schedule,omitempty"`

	// REQUIRED; The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified
	// upto seconds. If timezone is not specified the time will considered to be in device
	// timezone. The value will always be returned as UTC time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Topic where periodic events are published to IoT device.
	Topic *string `json:"topic,omitempty"`
}

// ProactiveLogCollectionSettingsProperties - The properties of proactive log collection settings.
type ProactiveLogCollectionSettingsProperties struct {
	// REQUIRED; Proactive diagnostic collection consent flag
	UserConsent *ProactiveDiagnosticsConsent `json:"userConsent,omitempty"`
}

// RawCertificateData - Raw Certificate Data.
type RawCertificateData struct {
	// REQUIRED; The base64 encoded certificate raw data.
	Certificate *string `json:"certificate,omitempty"`

	// The authentication type.
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`
}

// RefreshDetails - Fields for tracking refresh job on the share or container.
type RefreshDetails struct {
	// Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This
	// could be a failed job or a successful job.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`

	// If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that
	// job. The field is empty if no job is in progress.
	InProgressRefreshJobID *string `json:"inProgressRefreshJobId,omitempty"`

	// Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed
	// job or a successful job.
	LastCompletedRefreshJobTimeInUTC *time.Time `json:"lastCompletedRefreshJobTimeInUTC,omitempty"`

	// Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a
	// successful job.
	LastJob *string `json:"lastJob,omitempty"`
}

// RemoteSupportSettings - RemoteApplicationType for which remote support settings is being modified
type RemoteSupportSettings struct {
	// Access level allowed for this remote application type
	AccessLevel *AccessLevel `json:"accessLevel,omitempty"`

	// Expiration time stamp
	ExpirationTimeStampInUTC *time.Time `json:"expirationTimeStampInUTC,omitempty"`

	// Remote application type
	RemoteApplicationType *RemoteApplicationType `json:"remoteApplicationType,omitempty"`
}

// ResourceIdentity - Msi identity details of the resource
type ResourceIdentity struct {
	// Identity type
	Type *MsiIdentityType `json:"type,omitempty"`

	// READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Home Tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ResourceMoveDetails - Fields for tracking resource move
type ResourceMoveDetails struct {
	// Denotes whether move operation is in progress
	OperationInProgress *ResourceMoveStatus `json:"operationInProgress,omitempty"`

	// Denotes the timeout of the operation to finish
	OperationInProgressLockTimeoutInUTC *time.Time `json:"operationInProgressLockTimeoutInUTC,omitempty"`
}

// RoleClassification provides polymorphic access to related types.
// Call the interface's GetRole() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CloudEdgeManagementRole, *IoTRole, *KubernetesRole, *MECRole, *Role
type RoleClassification interface {
	// GetRole returns the Role content of the underlying type.
	GetRole() *Role
}

// Role - Compute role.
type Role struct {
	// REQUIRED; Role type.
	Kind *RoleTypes `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetRole implements the RoleClassification interface for type Role.
func (r *Role) GetRole() *Role { return r }

// RoleList - Collection of all the roles on the Data Box Edge device.
type RoleList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The Value.
	Value []RoleClassification `json:"value,omitempty" azure:"ro"`
}

// RoleSinkInfo - Compute role against which events will be raised.
type RoleSinkInfo struct {
	// REQUIRED; Compute role ID.
	RoleID *string `json:"roleId,omitempty"`
}

// RolesClientBeginCreateOrUpdateOptions contains the optional parameters for the RolesClient.BeginCreateOrUpdate method.
type RolesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RolesClientBeginDeleteOptions contains the optional parameters for the RolesClient.BeginDelete method.
type RolesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RolesClientGetOptions contains the optional parameters for the RolesClient.Get method.
type RolesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RolesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the RolesClient.ListByDataBoxEdgeDevice
// method.
type RolesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// SKU - The Sku information.
type SKU struct {
	// READ-ONLY; The API versions in which Sku is available.
	APIVersions []*string `json:"apiVersions,omitempty" azure:"ro"`

	// READ-ONLY; Links to the next set of results
	Availability *SKUAvailability `json:"availability,omitempty" azure:"ro"`

	// READ-ONLY; The capability info of the SKU.
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The pricing info of the Sku.
	Costs []*SKUCost `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The Sku family.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The Sku kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Availability of the Sku for the location/zone/site.
	LocationInfo []*SKULocationInfo `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; Availability of the Sku for the region.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The Sku name.
	Name *SKUName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; List of Shipment Types supported by this SKU
	ShipmentTypes []*ShipmentType `json:"shipmentTypes,omitempty" azure:"ro"`

	// READ-ONLY; Sku can be signed up by customer or not.
	SignupOption *SKUSignupOption `json:"signupOption,omitempty" azure:"ro"`

	// READ-ONLY; The Sku kind.
	Size *string `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; The Sku tier.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`

	// READ-ONLY; Availability of the Sku as preview/stable.
	Version *SKUVersion `json:"version,omitempty" azure:"ro"`
}

// SKUCapability - The metadata to describe the capability.
type SKUCapability struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// SKUCost - The metadata for retrieving price info.
type SKUCost struct {
	// READ-ONLY; The extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty" azure:"ro"`

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; The cost quantity.
	Quantity *int64 `json:"quantity,omitempty" azure:"ro"`
}

// SKUInfo - The SKU type.
type SKUInfo struct {
	// SKU name.
	Name *SKUName `json:"name,omitempty"`

	// The SKU tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUList - List of SKU Information objects.
type SKUList struct {
	// READ-ONLY; Links to the next set of results
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of ResourceType Sku
	Value []*SKU `json:"value,omitempty" azure:"ro"`
}

// SKULocationInfo - The location info.
type SKULocationInfo struct {
	// READ-ONLY; The location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The sites.
	Sites []*string `json:"sites,omitempty" azure:"ro"`

	// READ-ONLY; The zones.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// Secret - Holds device secret either as a KeyVault reference or as an encrypted value.
type Secret struct {
	// Encrypted (using device public key) secret value.
	EncryptedSecret *AsymmetricEncryptedSecret `json:"encryptedSecret,omitempty"`

	// Id of the Key-Vault where secret is stored (ex: secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// SecuritySettings - The security settings of a device.
type SecuritySettings struct {
	// REQUIRED; Properties of the security settings.
	Properties *SecuritySettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecuritySettingsProperties - The properties of security settings.
type SecuritySettingsProperties struct {
	// REQUIRED; Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to sign into the local
	// web UI of the device. The Actual password should have at least 8 characters that are a
	// combination of uppercase, lowercase, numeric, and special characters.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// ServiceSpecification - Service specification.
type ServiceSpecification struct {
	// Metric specification as defined by shoebox.
	MetricSpecifications []*MetricSpecificationV1 `json:"metricSpecifications,omitempty"`
}

// Share - Represents a share on the Data Box Edge/Gateway device.
type Share struct {
	// REQUIRED; The share properties.
	Properties *ShareProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Share
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ShareAccessRight - Specifies the mapping between this particular user and the type of access he has on shares on this device.
type ShareAccessRight struct {
	// REQUIRED; Type of access to be allowed on the share for this user.
	AccessType *ShareAccessType `json:"accessType,omitempty"`

	// REQUIRED; The share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// ShareList - Collection of all the shares on the Data Box Edge/Gateway device.
type ShareList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of shares.
	Value []*Share `json:"value,omitempty" azure:"ro"`
}

// ShareProperties - The share properties.
type ShareProperties struct {
	// REQUIRED; Access protocol to be used by the share.
	AccessProtocol *ShareAccessProtocol `json:"accessProtocol,omitempty"`

	// REQUIRED; Current monitoring status of the share.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`

	// REQUIRED; Current status of the share.
	ShareStatus *ShareStatus `json:"shareStatus,omitempty"`

	// Azure container mapping for the share.
	AzureContainerInfo *AzureContainerInfo `json:"azureContainerInfo,omitempty"`

	// List of IP addresses and corresponding access rights on the share(required for NFS protocol).
	ClientAccessRights []*ClientAccessRight `json:"clientAccessRights,omitempty"`

	// Data policy of the share.
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// Description for the share.
	Description *string `json:"description,omitempty"`

	// Details of the refresh job on this share.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty"`

	// Mapping of users and corresponding access rights on the share (required for SMB protocol).
	UserAccessRights []*UserAccessRight `json:"userAccessRights,omitempty"`

	// READ-ONLY; Share mount point to the role.
	ShareMappings []*MountPointMap `json:"shareMappings,omitempty" azure:"ro"`
}

// SharesClientBeginCreateOrUpdateOptions contains the optional parameters for the SharesClient.BeginCreateOrUpdate method.
type SharesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientBeginDeleteOptions contains the optional parameters for the SharesClient.BeginDelete method.
type SharesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientBeginRefreshOptions contains the optional parameters for the SharesClient.BeginRefresh method.
type SharesClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientGetOptions contains the optional parameters for the SharesClient.Get method.
type SharesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharesClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the SharesClient.ListByDataBoxEdgeDevice
// method.
type SharesClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// StorageAccount - Represents a Storage Account on the Data Box Edge/Gateway device.
type StorageAccount struct {
	// REQUIRED; The Storage Account properties.
	Properties *StorageAccountProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of StorageAccount
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountCredential - The storage account credential.
type StorageAccountCredential struct {
	// REQUIRED; The storage account credential properties.
	Properties *StorageAccountCredentialProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of StorageAccountCredential
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountCredentialList - The collection of storage account credentials.
type StorageAccountCredentialList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The value.
	Value []*StorageAccountCredential `json:"value,omitempty" azure:"ro"`
}

// StorageAccountCredentialProperties - The storage account credential properties.
type StorageAccountCredentialProperties struct {
	// REQUIRED; Type of storage accessed on the storage account.
	AccountType *AccountType `json:"accountType,omitempty"`

	// REQUIRED; Alias for the storage account.
	Alias *string `json:"alias,omitempty"`

	// REQUIRED; Signifies whether SSL needs to be enabled or not.
	SSLStatus *SSLStatus `json:"sslStatus,omitempty"`

	// Encrypted storage key.
	AccountKey *AsymmetricEncryptedSecret `json:"accountKey,omitempty"`

	// Blob end point for private clouds.
	BlobDomainName *string `json:"blobDomainName,omitempty"`

	// Connection string for the storage account. Use this string if username and account key are not specified.
	ConnectionString *string `json:"connectionString,omitempty"`

	// Id of the storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// Username for the storage account.
	UserName *string `json:"userName,omitempty"`
}

// StorageAccountCredentialsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginCreateOrUpdate
// method.
type StorageAccountCredentialsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientBeginDeleteOptions contains the optional parameters for the StorageAccountCredentialsClient.BeginDelete
// method.
type StorageAccountCredentialsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountCredentialsClientGetOptions contains the optional parameters for the StorageAccountCredentialsClient.Get
// method.
type StorageAccountCredentialsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountCredentialsClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the StorageAccountCredentialsClient.ListByDataBoxEdgeDevice
// method.
type StorageAccountCredentialsClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountList - Collection of all the Storage Accounts on the Data Box Edge/Gateway device.
type StorageAccountList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of storageAccounts.
	Value []*StorageAccount `json:"value,omitempty" azure:"ro"`
}

// StorageAccountProperties - The storage account properties.
type StorageAccountProperties struct {
	// REQUIRED; Data policy of the storage Account.
	DataPolicy *DataPolicy `json:"dataPolicy,omitempty"`

	// Description for the storage Account.
	Description *string `json:"description,omitempty"`

	// Storage Account Credential Id
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`

	// Current status of the storage account
	StorageAccountStatus *StorageAccountStatus `json:"storageAccountStatus,omitempty"`

	// READ-ONLY; BlobEndpoint of Storage Account
	BlobEndpoint *string `json:"blobEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The Container Count. Present only for Storage Accounts with DataPolicy set to Cloud.
	ContainerCount *int32 `json:"containerCount,omitempty" azure:"ro"`
}

// StorageAccountsClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageAccountsClient.BeginCreateOrUpdate
// method.
type StorageAccountsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountsClientBeginDeleteOptions contains the optional parameters for the StorageAccountsClient.BeginDelete method.
type StorageAccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageAccountsClientGetOptions contains the optional parameters for the StorageAccountsClient.Get method.
type StorageAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the StorageAccountsClient.ListByDataBoxEdgeDevice
// method.
type StorageAccountsClientListByDataBoxEdgeDeviceOptions struct {
	// placeholder for future optional parameters
}

type SubscriptionProperties struct {
	LocationPlacementID *string                           `json:"locationPlacementId,omitempty"`
	QuotaID             *string                           `json:"quotaId,omitempty"`
	RegisteredFeatures  []*SubscriptionRegisteredFeatures `json:"registeredFeatures,omitempty"`
	SerializedDetails   *string                           `json:"serializedDetails,omitempty"`
	TenantID            *string                           `json:"tenantId,omitempty"`
}

type SubscriptionRegisteredFeatures struct {
	Name  *string `json:"name,omitempty"`
	State *string `json:"state,omitempty"`
}

// SupportPackageRequestProperties - The share properties.
type SupportPackageRequestProperties struct {
	// Type of files, which need to be included in the logs This will contain the type of logs (Default/DefaultWithDumps/None/All/DefaultWithArchived)
	// or a comma separated list of log types that are required
	Include *string `json:"include,omitempty"`

	// Start of the timespan of the log collection
	MaximumTimeStamp *time.Time `json:"maximumTimeStamp,omitempty"`

	// MinimumTimeStamp from where logs need to be collected
	MinimumTimeStamp *time.Time `json:"minimumTimeStamp,omitempty"`
}

// SupportPackagesClientBeginTriggerSupportPackageOptions contains the optional parameters for the SupportPackagesClient.BeginTriggerSupportPackage
// method.
type SupportPackagesClientBeginTriggerSupportPackageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SymmetricKey - Symmetric key for authentication.
type SymmetricKey struct {
	// Connection string based on the symmetric key.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackingInfo - Tracking courier information.
type TrackingInfo struct {
	// Name of the carrier used in the delivery.
	CarrierName *string `json:"carrierName,omitempty"`

	// Serial number of the device being tracked.
	SerialNumber *string `json:"serialNumber,omitempty"`

	// Tracking ID of the shipment.
	TrackingID *string `json:"trackingId,omitempty"`

	// Tracking URL of the shipment.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// TriggerClassification provides polymorphic access to related types.
// Call the interface's GetTrigger() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FileEventTrigger, *PeriodicTimerEventTrigger, *Trigger
type TriggerClassification interface {
	// GetTrigger returns the Trigger content of the underlying type.
	GetTrigger() *Trigger
}

// Trigger details.
type Trigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType `json:"kind,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of Trigger
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type Trigger.
func (t *Trigger) GetTrigger() *Trigger { return t }

// TriggerList - Collection of all trigger on the data box edge device.
type TriggerList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of triggers.
	Value []TriggerClassification `json:"value,omitempty" azure:"ro"`
}

// TriggerSupportPackageRequest - The request object for trigger support package.
type TriggerSupportPackageRequest struct {
	// REQUIRED; The TriggerSupportPackageRequest properties.
	Properties *SupportPackageRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggersClientBeginCreateOrUpdateOptions contains the optional parameters for the TriggersClient.BeginCreateOrUpdate method.
type TriggersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TriggersClientBeginDeleteOptions contains the optional parameters for the TriggersClient.BeginDelete method.
type TriggersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TriggersClientGetOptions contains the optional parameters for the TriggersClient.Get method.
type TriggersClientGetOptions struct {
	// placeholder for future optional parameters
}

// TriggersClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the TriggersClient.ListByDataBoxEdgeDevice
// method.
type TriggersClientListByDataBoxEdgeDeviceOptions struct {
	// Specify $filter='CustomContextTag eq ' to filter on custom context tag property
	Filter *string
}

// UpdateDetails - Update Specific attributes
type UpdateDetails struct {
	// Estimated Install Time for the update
	EstimatedInstallTimeInMins *int32 `json:"estimatedInstallTimeInMins,omitempty"`

	// Friendly Version Number
	FriendlyVersionNumber *string `json:"friendlyVersionNumber,omitempty"`

	// Impact of Installing an updateType
	InstallationImpact *InstallationImpact `json:"installationImpact,omitempty"`

	// Indicates if updates are available and at least one of the updates needs a reboot.
	RebootBehavior *InstallRebootBehavior `json:"rebootBehavior,omitempty"`

	// Status of the update.
	Status *UpdateStatus `json:"status,omitempty"`

	// Target Version number
	TargetVersion *string `json:"targetVersion,omitempty"`

	// Size of the update(In Bytes)
	UpdateSize *float64 `json:"updateSize,omitempty"`

	// Title of the Update
	UpdateTitle *string `json:"updateTitle,omitempty"`

	// Type of the Update
	UpdateType *UpdateType `json:"updateType,omitempty"`
}

// UpdateDownloadProgress - Details about the download progress of update.
type UpdateDownloadProgress struct {
	// READ-ONLY; The download phase.
	DownloadPhase *DownloadPhase `json:"downloadPhase,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty" azure:"ro"`

	// READ-ONLY; Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty" azure:"ro"`

	// READ-ONLY; Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty" azure:"ro"`
}

// UpdateInstallProgress - Progress details during installation of updates.
type UpdateInstallProgress struct {
	// READ-ONLY; Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty" azure:"ro"`

	// READ-ONLY; Percentage completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`
}

// UpdateSummary - Details about ongoing updates and availability of updates on the device.
type UpdateSummary struct {
	// The device update information summary.
	Properties *UpdateSummaryProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of UpdateSummary
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateSummaryProperties - The device update information summary.
type UpdateSummaryProperties struct {
	// The last time when a scan was done on the device.
	DeviceLastScannedDateTime *time.Time `json:"deviceLastScannedDateTime,omitempty"`

	// The current version of the device in format: 1.2.17312.13.",
	DeviceVersionNumber *string `json:"deviceVersionNumber,omitempty"`

	// The current version of the device in text format.
	FriendlyDeviceVersionName *string `json:"friendlyDeviceVersionName,omitempty"`

	// The time when the last scan job was completed (success/cancelled/failed) on the appliance.
	LastCompletedScanJobDateTime *time.Time `json:"lastCompletedScanJobDateTime,omitempty"`

	// The time when the Last Install job was completed successfully on the appliance
	LastSuccessfulInstallJobDateTime *time.Time `json:"lastSuccessfulInstallJobDateTime,omitempty"`

	// Time when the last scan job is successfully completed.
	LastSuccessfulScanJobTime *time.Time `json:"lastSuccessfulScanJobTime,omitempty"`

	// READ-ONLY; The job ID of the download job in progress.
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty" azure:"ro"`

	// READ-ONLY; The time when the currently running download (if any) started.
	InProgressDownloadJobStartedDateTime *time.Time `json:"inProgressDownloadJobStartedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The job ID of the install job in progress.
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty" azure:"ro"`

	// READ-ONLY; The time when the currently running install (if any) started.
	InProgressInstallJobStartedDateTime *time.Time `json:"inProgressInstallJobStartedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The time when the last Download job was completed (success/cancelled/failed) on the appliance.
	LastCompletedDownloadJobDateTime *time.Time `json:"lastCompletedDownloadJobDateTime,omitempty" azure:"ro"`

	// READ-ONLY; JobId of the last ran download job.(Can be success/cancelled/failed)
	LastCompletedDownloadJobID *string `json:"lastCompletedDownloadJobId,omitempty" azure:"ro"`

	// READ-ONLY; The time when the last Install job was completed (success/cancelled/failed) on the appliance.
	LastCompletedInstallJobDateTime *time.Time `json:"lastCompletedInstallJobDateTime,omitempty" azure:"ro"`

	// READ-ONLY; JobId of the last ran install job.(Can be success/cancelled/failed)
	LastCompletedInstallJobID *string `json:"lastCompletedInstallJobId,omitempty" azure:"ro"`

	// READ-ONLY; JobStatus of the last ran download job.
	LastDownloadJobStatus *JobStatus `json:"lastDownloadJobStatus,omitempty" azure:"ro"`

	// READ-ONLY; JobStatus of the last ran install job.
	LastInstallJobStatus *JobStatus `json:"lastInstallJobStatus,omitempty" azure:"ro"`

	// READ-ONLY; The current update operation.
	OngoingUpdateOperation *UpdateOperation `json:"ongoingUpdateOperation,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if updates are available and at least one of the updates needs a reboot.
	RebootBehavior *InstallRebootBehavior `json:"rebootBehavior,omitempty" azure:"ro"`

	// READ-ONLY; The number of updates available for the current device version as per the last device scan.
	TotalNumberOfUpdatesAvailable *int32 `json:"totalNumberOfUpdatesAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The total number of items pending download.
	TotalNumberOfUpdatesPendingDownload *int32 `json:"totalNumberOfUpdatesPendingDownload,omitempty" azure:"ro"`

	// READ-ONLY; The total number of items pending install.
	TotalNumberOfUpdatesPendingInstall *int32 `json:"totalNumberOfUpdatesPendingInstall,omitempty" azure:"ro"`

	// READ-ONLY; The total time in Minutes
	TotalTimeInMinutes *int32 `json:"totalTimeInMinutes,omitempty" azure:"ro"`

	// READ-ONLY; The total size of updates available for download in bytes.
	TotalUpdateSizeInBytes *float64 `json:"totalUpdateSizeInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The list of updates available for install.
	UpdateTitles []*string `json:"updateTitles,omitempty" azure:"ro"`

	// READ-ONLY; The list of updates available for install.
	Updates []*UpdateDetails `json:"updates,omitempty" azure:"ro"`
}

// UploadCertificateRequest - The upload certificate request.
type UploadCertificateRequest struct {
	// REQUIRED; The Base 64 encoded certificate raw data.
	Properties *RawCertificateData `json:"properties,omitempty"`
}

// UploadCertificateResponse - The upload registration certificate response.
type UploadCertificateResponse struct {
	// Specifies authentication type.
	AuthType *AuthenticationType `json:"authType,omitempty"`

	// READ-ONLY; Identifier of the target resource that is the recipient of the requested token.
	AADAudience *string `json:"aadAudience,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory tenant authority.
	AADAuthority *string `json:"aadAuthority,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory tenant ID.
	AADTenantID *string `json:"aadTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The azure management endpoint audience.
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of the Data Box Edge/Gateway device.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory service principal client ID.
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory service principal object ID.
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty" azure:"ro"`
}

// User - Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
type User struct {
	// REQUIRED; The storage account credential properties.
	Properties *UserProperties `json:"properties,omitempty"`

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The object name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of User
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAccessRight - The mapping between a particular user and the access type on the SMB share.
type UserAccessRight struct {
	// REQUIRED; Type of access to be allowed for the user.
	AccessType *ShareAccessType `json:"accessType,omitempty"`

	// REQUIRED; User ID (already existing in the device).
	UserID *string `json:"userId,omitempty"`
}

// UserList - Collection of users.
type UserList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of users.
	Value []*User `json:"value,omitempty" azure:"ro"`
}

// UserProperties - The user properties.
type UserProperties struct {
	// REQUIRED; Type of the user.
	UserType *UserType `json:"userType,omitempty"`

	// The password details.
	EncryptedPassword *AsymmetricEncryptedSecret `json:"encryptedPassword,omitempty"`

	// READ-ONLY; List of shares that the user has rights on. This field should not be specified during user creation.
	ShareAccessRights []*ShareAccessRight `json:"shareAccessRights,omitempty" azure:"ro"`
}

// UsersClientBeginCreateOrUpdateOptions contains the optional parameters for the UsersClient.BeginCreateOrUpdate method.
type UsersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientBeginDeleteOptions contains the optional parameters for the UsersClient.BeginDelete method.
type UsersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientGetOptions contains the optional parameters for the UsersClient.Get method.
type UsersClientGetOptions struct {
	// placeholder for future optional parameters
}

// UsersClientListByDataBoxEdgeDeviceOptions contains the optional parameters for the UsersClient.ListByDataBoxEdgeDevice
// method.
type UsersClientListByDataBoxEdgeDeviceOptions struct {
	// Specify $filter='Type eq ' to filter on user type property
	Filter *string
}

// VMMemory - VmMemory Data.
type VMMemory struct {
	// The current memory used by the virtual machine.
	CurrentMemoryUsageMB *int64 `json:"currentMemoryUsageMB,omitempty"`

	// The total amount of RAM in the virtual machine, as seen by the guest operating system. For a virtual machine with dynamic
	// memory enabled, this represents the initial memory available at startup.
	StartupMemoryMB *int64 `json:"startupMemoryMB,omitempty"`
}

// VMPlacementRequestResult - List of VM sizes being checked for creation on appliance along with corresponding result.
type VMPlacementRequestResult struct {
	// Boolean value indicating if the VM(s) in VmSize can be created.
	IsFeasible *bool `json:"isFeasible,omitempty"`

	// Localized message to be displayed to the user to explain the check result.
	Message *string `json:"message,omitempty"`

	// MessageCode indicating reason for success or failure.
	MessageCode *string `json:"messageCode,omitempty"`

	// List of VM sizes being checked.
	VMSize []*string `json:"vmSize,omitempty"`
}
