//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armanalysisservices

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServersClient contains the methods for the Servers group.
// Don't use this type directly, use NewServersClient() instead.
type ServersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServersClient creates a new instance of ServersClient with the specified values.
// subscriptionID - A unique identifier for a Microsoft Azure subscription. The subscription ID forms part of the URI for
// every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CheckNameAvailability - Check the name availability in the target location.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// location - The region name which the operation will lookup into.
// serverParameters - Contains the information used to provision the Analysis Services server.
// options - ServersClientCheckNameAvailabilityOptions contains the optional parameters for the ServersClient.CheckNameAvailability
// method.
func (client *ServersClient) CheckNameAvailability(ctx context.Context, location string, serverParameters CheckServerNameAvailabilityParameters, options *ServersClientCheckNameAvailabilityOptions) (ServersClientCheckNameAvailabilityResponse, error) {
	req, err := client.checkNameAvailabilityCreateRequest(ctx, location, serverParameters, options)
	if err != nil {
		return ServersClientCheckNameAvailabilityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientCheckNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServersClientCheckNameAvailabilityResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkNameAvailabilityHandleResponse(resp)
}

// checkNameAvailabilityCreateRequest creates the CheckNameAvailability request.
func (client *ServersClient) checkNameAvailabilityCreateRequest(ctx context.Context, location string, serverParameters CheckServerNameAvailabilityParameters, options *ServersClientCheckNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/locations/{location}/checkNameAvailability"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, serverParameters)
}

// checkNameAvailabilityHandleResponse handles the CheckNameAvailability response.
func (client *ServersClient) checkNameAvailabilityHandleResponse(resp *http.Response) (ServersClientCheckNameAvailabilityResponse, error) {
	result := ServersClientCheckNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckServerNameAvailabilityResult); err != nil {
		return ServersClientCheckNameAvailabilityResponse{}, err
	}
	return result, nil
}

// BeginCreate - Provisions the specified Analysis Services server based on the configuration specified in the request.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be a minimum of 3 characters, and a maximum of 63.
// serverParameters - Contains the information used to provision the Analysis Services server.
// options - ServersClientBeginCreateOptions contains the optional parameters for the ServersClient.BeginCreate method.
func (client *ServersClient) BeginCreate(ctx context.Context, resourceGroupName string, serverName string, serverParameters Server, options *ServersClientBeginCreateOptions) (*runtime.Poller[ServersClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, serverName, serverParameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ServersClientCreateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ServersClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - Provisions the specified Analysis Services server based on the configuration specified in the request.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
func (client *ServersClient) create(ctx context.Context, resourceGroupName string, serverName string, serverParameters Server, options *ServersClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, serverName, serverParameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *ServersClient) createCreateRequest(ctx context.Context, resourceGroupName string, serverName string, serverParameters Server, options *ServersClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, serverParameters)
}

// BeginDelete - Deletes the specified Analysis Services server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be at least 3 characters in length, and no more than 63.
// options - ServersClientBeginDeleteOptions contains the optional parameters for the ServersClient.BeginDelete method.
func (client *ServersClient) BeginDelete(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginDeleteOptions) (*runtime.Poller[ServersClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, serverName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ServersClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ServersClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the specified Analysis Services server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
func (client *ServersClient) deleteOperation(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ServersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DissociateGateway - Dissociates a Unified Gateway associated with the server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be at least 3 characters in length, and no more than 63.
// options - ServersClientDissociateGatewayOptions contains the optional parameters for the ServersClient.DissociateGateway
// method.
func (client *ServersClient) DissociateGateway(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientDissociateGatewayOptions) (ServersClientDissociateGatewayResponse, error) {
	req, err := client.dissociateGatewayCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return ServersClientDissociateGatewayResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientDissociateGatewayResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServersClientDissociateGatewayResponse{}, runtime.NewResponseError(resp)
	}
	return ServersClientDissociateGatewayResponse{}, nil
}

// dissociateGatewayCreateRequest creates the DissociateGateway request.
func (client *ServersClient) dissociateGatewayCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientDissociateGatewayOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/dissociateGateway"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the specified Analysis Services server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be a minimum of 3 characters, and a maximum of 63.
// options - ServersClientGetDetailsOptions contains the optional parameters for the ServersClient.GetDetails method.
func (client *ServersClient) GetDetails(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientGetDetailsOptions) (ServersClientGetDetailsResponse, error) {
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return ServersClientGetDetailsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServersClientGetDetailsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDetailsHandleResponse(resp)
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *ServersClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *ServersClient) getDetailsHandleResponse(resp *http.Response) (ServersClientGetDetailsResponse, error) {
	result := ServersClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Server); err != nil {
		return ServersClientGetDetailsResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all the Analysis Services servers for the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// options - ServersClientListOptions contains the optional parameters for the ServersClient.List method.
func (client *ServersClient) NewListPager(options *ServersClientListOptions) *runtime.Pager[ServersClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServersClientListResponse]{
		More: func(page ServersClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ServersClientListResponse) (ServersClientListResponse, error) {
			req, err := client.listCreateRequest(ctx, options)
			if err != nil {
				return ServersClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ServersClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServersClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *ServersClient) listCreateRequest(ctx context.Context, options *ServersClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/servers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ServersClient) listHandleResponse(resp *http.Response) (ServersClientListResponse, error) {
	result := ServersClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Servers); err != nil {
		return ServersClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Gets all the Analysis Services servers for the given resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// options - ServersClientListByResourceGroupOptions contains the optional parameters for the ServersClient.ListByResourceGroup
// method.
func (client *ServersClient) NewListByResourceGroupPager(resourceGroupName string, options *ServersClientListByResourceGroupOptions) *runtime.Pager[ServersClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServersClientListByResourceGroupResponse]{
		More: func(page ServersClientListByResourceGroupResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ServersClientListByResourceGroupResponse) (ServersClientListByResourceGroupResponse, error) {
			req, err := client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			if err != nil {
				return ServersClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ServersClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServersClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *ServersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ServersClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *ServersClient) listByResourceGroupHandleResponse(resp *http.Response) (ServersClientListByResourceGroupResponse, error) {
	result := ServersClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Servers); err != nil {
		return ServersClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// ListGatewayStatus - Return the gateway status of the specified Analysis Services server instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server.
// options - ServersClientListGatewayStatusOptions contains the optional parameters for the ServersClient.ListGatewayStatus
// method.
func (client *ServersClient) ListGatewayStatus(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientListGatewayStatusOptions) (ServersClientListGatewayStatusResponse, error) {
	req, err := client.listGatewayStatusCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return ServersClientListGatewayStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientListGatewayStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServersClientListGatewayStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.listGatewayStatusHandleResponse(resp)
}

// listGatewayStatusCreateRequest creates the ListGatewayStatus request.
func (client *ServersClient) listGatewayStatusCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientListGatewayStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/listGatewayStatus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGatewayStatusHandleResponse handles the ListGatewayStatus response.
func (client *ServersClient) listGatewayStatusHandleResponse(resp *http.Response) (ServersClientListGatewayStatusResponse, error) {
	result := ServersClientListGatewayStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GatewayListStatusLive); err != nil {
		return ServersClientListGatewayStatusResponse{}, err
	}
	return result, nil
}

// ListOperationResults - List the result of the specified operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// location - The region name which the operation will lookup into.
// operationID - The target operation Id.
// options - ServersClientListOperationResultsOptions contains the optional parameters for the ServersClient.ListOperationResults
// method.
func (client *ServersClient) ListOperationResults(ctx context.Context, location string, operationID string, options *ServersClientListOperationResultsOptions) (ServersClientListOperationResultsResponse, error) {
	req, err := client.listOperationResultsCreateRequest(ctx, location, operationID, options)
	if err != nil {
		return ServersClientListOperationResultsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientListOperationResultsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return ServersClientListOperationResultsResponse{}, runtime.NewResponseError(resp)
	}
	return ServersClientListOperationResultsResponse{}, nil
}

// listOperationResultsCreateRequest creates the ListOperationResults request.
func (client *ServersClient) listOperationResultsCreateRequest(ctx context.Context, location string, operationID string, options *ServersClientListOperationResultsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/locations/{location}/operationresults/{operationId}"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ListOperationStatuses - List the status of operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// location - The region name which the operation will lookup into.
// operationID - The target operation Id.
// options - ServersClientListOperationStatusesOptions contains the optional parameters for the ServersClient.ListOperationStatuses
// method.
func (client *ServersClient) ListOperationStatuses(ctx context.Context, location string, operationID string, options *ServersClientListOperationStatusesOptions) (ServersClientListOperationStatusesResponse, error) {
	req, err := client.listOperationStatusesCreateRequest(ctx, location, operationID, options)
	if err != nil {
		return ServersClientListOperationStatusesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientListOperationStatusesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return ServersClientListOperationStatusesResponse{}, runtime.NewResponseError(resp)
	}
	return client.listOperationStatusesHandleResponse(resp)
}

// listOperationStatusesCreateRequest creates the ListOperationStatuses request.
func (client *ServersClient) listOperationStatusesCreateRequest(ctx context.Context, location string, operationID string, options *ServersClientListOperationStatusesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/locations/{location}/operationstatuses/{operationId}"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationStatusesHandleResponse handles the ListOperationStatuses response.
func (client *ServersClient) listOperationStatusesHandleResponse(resp *http.Response) (ServersClientListOperationStatusesResponse, error) {
	result := ServersClientListOperationStatusesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationStatus); err != nil {
		return ServersClientListOperationStatusesResponse{}, err
	}
	return result, nil
}

// ListSKUsForExisting - Lists eligible SKUs for an Analysis Services resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be at least 3 characters in length, and no more than 63.
// options - ServersClientListSKUsForExistingOptions contains the optional parameters for the ServersClient.ListSKUsForExisting
// method.
func (client *ServersClient) ListSKUsForExisting(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientListSKUsForExistingOptions) (ServersClientListSKUsForExistingResponse, error) {
	req, err := client.listSKUsForExistingCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return ServersClientListSKUsForExistingResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientListSKUsForExistingResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServersClientListSKUsForExistingResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSKUsForExistingHandleResponse(resp)
}

// listSKUsForExistingCreateRequest creates the ListSKUsForExisting request.
func (client *ServersClient) listSKUsForExistingCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientListSKUsForExistingOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSKUsForExistingHandleResponse handles the ListSKUsForExisting response.
func (client *ServersClient) listSKUsForExistingHandleResponse(resp *http.Response) (ServersClientListSKUsForExistingResponse, error) {
	result := ServersClientListSKUsForExistingResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUEnumerationForExistingResourceResult); err != nil {
		return ServersClientListSKUsForExistingResponse{}, err
	}
	return result, nil
}

// ListSKUsForNew - Lists eligible SKUs for Analysis Services resource provider.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// options - ServersClientListSKUsForNewOptions contains the optional parameters for the ServersClient.ListSKUsForNew method.
func (client *ServersClient) ListSKUsForNew(ctx context.Context, options *ServersClientListSKUsForNewOptions) (ServersClientListSKUsForNewResponse, error) {
	req, err := client.listSKUsForNewCreateRequest(ctx, options)
	if err != nil {
		return ServersClientListSKUsForNewResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServersClientListSKUsForNewResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServersClientListSKUsForNewResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSKUsForNewHandleResponse(resp)
}

// listSKUsForNewCreateRequest creates the ListSKUsForNew request.
func (client *ServersClient) listSKUsForNewCreateRequest(ctx context.Context, options *ServersClientListSKUsForNewOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSKUsForNewHandleResponse handles the ListSKUsForNew response.
func (client *ServersClient) listSKUsForNewHandleResponse(resp *http.Response) (ServersClientListSKUsForNewResponse, error) {
	result := ServersClientListSKUsForNewResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUEnumerationForNewResourceResult); err != nil {
		return ServersClientListSKUsForNewResponse{}, err
	}
	return result, nil
}

// BeginResume - Resumes operation of the specified Analysis Services server instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be at least 3 characters in length, and no more than 63.
// options - ServersClientBeginResumeOptions contains the optional parameters for the ServersClient.BeginResume method.
func (client *ServersClient) BeginResume(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginResumeOptions) (*runtime.Poller[ServersClientResumeResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.resume(ctx, resourceGroupName, serverName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ServersClientResumeResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ServersClientResumeResponse](options.ResumeToken, client.pl, nil)
	}
}

// Resume - Resumes operation of the specified Analysis Services server instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
func (client *ServersClient) resume(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginResumeOptions) (*http.Response, error) {
	req, err := client.resumeCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// resumeCreateRequest creates the Resume request.
func (client *ServersClient) resumeCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginResumeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/resume"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginSuspend - Suspends operation of the specified Analysis Services server instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be at least 3 characters in length, and no more than 63.
// options - ServersClientBeginSuspendOptions contains the optional parameters for the ServersClient.BeginSuspend method.
func (client *ServersClient) BeginSuspend(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginSuspendOptions) (*runtime.Poller[ServersClientSuspendResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.suspend(ctx, resourceGroupName, serverName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ServersClientSuspendResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ServersClientSuspendResponse](options.ResumeToken, client.pl, nil)
	}
}

// Suspend - Suspends operation of the specified Analysis Services server instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
func (client *ServersClient) suspend(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginSuspendOptions) (*http.Response, error) {
	req, err := client.suspendCreateRequest(ctx, resourceGroupName, serverName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// suspendCreateRequest creates the Suspend request.
func (client *ServersClient) suspendCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServersClientBeginSuspendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/suspend"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginUpdate - Updates the current state of the specified Analysis Services server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
// resourceGroupName - The name of the Azure Resource group of which a given Analysis Services server is part. This name must
// be at least 1 character in length, and no more than 90.
// serverName - The name of the Analysis Services server. It must be at least 3 characters in length, and no more than 63.
// serverUpdateParameters - Request object that contains the updated information for the server.
// options - ServersClientBeginUpdateOptions contains the optional parameters for the ServersClient.BeginUpdate method.
func (client *ServersClient) BeginUpdate(ctx context.Context, resourceGroupName string, serverName string, serverUpdateParameters ServerUpdateParameters, options *ServersClientBeginUpdateOptions) (*runtime.Poller[ServersClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, serverName, serverUpdateParameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ServersClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ServersClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Updates the current state of the specified Analysis Services server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-08-01
func (client *ServersClient) update(ctx context.Context, resourceGroupName string, serverName string, serverUpdateParameters ServerUpdateParameters, options *ServersClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, serverName, serverUpdateParameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *ServersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, serverUpdateParameters ServerUpdateParameters, options *ServersClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, serverUpdateParameters)
}
