//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package blob

import (
	"net/http"
	"time"
)

// appendBlobClientAppendBlockFromURLResponse contains the response from method appendBlobClient.AppendBlockFromURL.
type appendBlobClientAppendBlockFromURLResponse struct {
	appendBlobClientAppendBlockFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// appendBlobClientAppendBlockFromURLResult contains the result from method appendBlobClient.AppendBlockFromURL.
type appendBlobClientAppendBlockFromURLResult struct {
	// BlobAppendOffset contains the information returned from the x-ms-blob-append-offset header response.
	BlobAppendOffset *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// appendBlobClientAppendBlockResponse contains the response from method appendBlobClient.AppendBlock.
type appendBlobClientAppendBlockResponse struct {
	appendBlobClientAppendBlockResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// appendBlobClientAppendBlockResult contains the result from method appendBlobClient.AppendBlock.
type appendBlobClientAppendBlockResult struct {
	// BlobAppendOffset contains the information returned from the x-ms-blob-append-offset header response.
	BlobAppendOffset *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// appendBlobClientCreateResponse contains the response from method appendBlobClient.Create.
type appendBlobClientCreateResponse struct {
	appendBlobClientCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// appendBlobClientCreateResult contains the result from method appendBlobClient.Create.
type appendBlobClientCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// appendBlobClientSealResponse contains the response from method appendBlobClient.Seal.
type appendBlobClientSealResponse struct {
	appendBlobClientSealResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// appendBlobClientSealResult contains the result from method appendBlobClient.Seal.
type appendBlobClientSealResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// IsSealed contains the information returned from the x-ms-blob-sealed header response.
	IsSealed *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientAbortCopyFromURLResponse contains the response from method blobClient.AbortCopyFromURL.
type blobClientAbortCopyFromURLResponse struct {
	blobClientAbortCopyFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientAbortCopyFromURLResult contains the result from method blobClient.AbortCopyFromURL.
type blobClientAbortCopyFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientAcquireLeaseResponse contains the response from method blobClient.AcquireLease.
type blobClientAcquireLeaseResponse struct {
	blobClientAcquireLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientAcquireLeaseResult contains the result from method blobClient.AcquireLease.
type blobClientAcquireLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientBreakLeaseResponse contains the response from method blobClient.BreakLease.
type blobClientBreakLeaseResponse struct {
	blobClientBreakLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientBreakLeaseResult contains the result from method blobClient.BreakLease.
type blobClientBreakLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseTime contains the information returned from the x-ms-lease-time header response.
	LeaseTime *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientChangeLeaseResponse contains the response from method blobClient.ChangeLease.
type blobClientChangeLeaseResponse struct {
	blobClientChangeLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientChangeLeaseResult contains the result from method blobClient.ChangeLease.
type blobClientChangeLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientCopyFromURLResponse contains the response from method blobClient.CopyFromURL.
type blobClientCopyFromURLResponse struct {
	blobClientCopyFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientCopyFromURLResult contains the result from method blobClient.CopyFromURL.
type blobClientCopyFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// blobClientCreateSnapshotResponse contains the response from method blobClient.CreateSnapshot.
type blobClientCreateSnapshotResponse struct {
	blobClientCreateSnapshotResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientCreateSnapshotResult contains the result from method blobClient.CreateSnapshot.
type blobClientCreateSnapshotResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Snapshot contains the information returned from the x-ms-snapshot header response.
	Snapshot *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// blobClientDeleteImmutabilityPolicyResponse contains the response from method blobClient.DeleteImmutabilityPolicy.
type blobClientDeleteImmutabilityPolicyResponse struct {
	blobClientDeleteImmutabilityPolicyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientDeleteImmutabilityPolicyResult contains the result from method blobClient.DeleteImmutabilityPolicy.
type blobClientDeleteImmutabilityPolicyResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientDeleteResponse contains the response from method blobClient.Delete.
type blobClientDeleteResponse struct {
	blobClientDeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientDeleteResult contains the result from method blobClient.Delete.
type blobClientDeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientDownloadResponse contains the response from method blobClient.Download.
type blobClientDownloadResponse struct {
	blobClientDownloadResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientDownloadResult contains the result from method blobClient.Download.
type blobClientDownloadResult struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// BlobContentMD5 contains the information returned from the x-ms-blob-content-md5 header response.
	BlobContentMD5 []byte

	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// BlobType contains the information returned from the x-ms-blob-type header response.
	BlobType *BlobType

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	ContentCRC64 []byte

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentRange contains the information returned from the Content-Range header response.
	ContentRange *string

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// ErrorCode contains the information returned from the x-ms-error-code header response.
	ErrorCode *string

	// ImmutabilityPolicyExpiresOn contains the information returned from the x-ms-immutability-policy-until-date header response.
	ImmutabilityPolicyExpiresOn *time.Time

	// ImmutabilityPolicyMode contains the information returned from the x-ms-immutability-policy-mode header response.
	ImmutabilityPolicyMode *BlobImmutabilityPolicyMode

	// IsCurrentVersion contains the information returned from the x-ms-is-current-version header response.
	IsCurrentVersion *bool

	// IsSealed contains the information returned from the x-ms-blob-sealed header response.
	IsSealed *bool

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastAccessed contains the information returned from the x-ms-last-access-time header response.
	LastAccessed *time.Time

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// LegalHold contains the information returned from the x-ms-legal-hold header response.
	LegalHold *bool

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// ObjectReplicationPolicyID contains the information returned from the x-ms-or-policy-id header response.
	ObjectReplicationPolicyID *string

	// ObjectReplicationRules contains the information returned from the x-ms-or header response.
	ObjectReplicationRules map[string]string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// TagCount contains the information returned from the x-ms-tag-count header response.
	TagCount *int64

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// blobClientGetAccountInfoResponse contains the response from method blobClient.GetAccountInfo.
type blobClientGetAccountInfoResponse struct {
	blobClientGetAccountInfoResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientGetAccountInfoResult contains the result from method blobClient.GetAccountInfo.
type blobClientGetAccountInfoResult struct {
	// AccountKind contains the information returned from the x-ms-account-kind header response.
	AccountKind *AccountKind

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// SKUName contains the information returned from the x-ms-sku-name header response.
	SKUName *SKUName

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientGetPropertiesResponse contains the response from method blobClient.GetProperties.
type blobClientGetPropertiesResponse struct {
	blobClientGetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientGetPropertiesResult contains the result from method blobClient.GetProperties.
type blobClientGetPropertiesResult struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// AccessTier contains the information returned from the x-ms-access-tier header response.
	AccessTier *string

	// AccessTierChangeTime contains the information returned from the x-ms-access-tier-change-time header response.
	AccessTierChangeTime *time.Time

	// AccessTierInferred contains the information returned from the x-ms-access-tier-inferred header response.
	AccessTierInferred *bool

	// ArchiveStatus contains the information returned from the x-ms-archive-status header response.
	ArchiveStatus *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// BlobType contains the information returned from the x-ms-blob-type header response.
	BlobType *BlobType

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// CreationTime contains the information returned from the x-ms-creation-time header response.
	CreationTime *time.Time

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// DestinationSnapshot contains the information returned from the x-ms-copy-destination-snapshot header response.
	DestinationSnapshot *string

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// ExpiresOn contains the information returned from the x-ms-expiry-time header response.
	ExpiresOn *time.Time

	// ImmutabilityPolicyExpiresOn contains the information returned from the x-ms-immutability-policy-until-date header response.
	ImmutabilityPolicyExpiresOn *time.Time

	// ImmutabilityPolicyMode contains the information returned from the x-ms-immutability-policy-mode header response.
	ImmutabilityPolicyMode *BlobImmutabilityPolicyMode

	// IsCurrentVersion contains the information returned from the x-ms-is-current-version header response.
	IsCurrentVersion *bool

	// IsIncrementalCopy contains the information returned from the x-ms-incremental-copy header response.
	IsIncrementalCopy *bool

	// IsSealed contains the information returned from the x-ms-blob-sealed header response.
	IsSealed *bool

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastAccessed contains the information returned from the x-ms-last-access-time header response.
	LastAccessed *time.Time

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// LegalHold contains the information returned from the x-ms-legal-hold header response.
	LegalHold *bool

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// ObjectReplicationPolicyID contains the information returned from the x-ms-or-policy-id header response.
	ObjectReplicationPolicyID *string

	// ObjectReplicationRules contains the information returned from the x-ms-or header response.
	ObjectReplicationRules map[string]string

	// RehydratePriority contains the information returned from the x-ms-rehydrate-priority header response.
	RehydratePriority *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// TagCount contains the information returned from the x-ms-tag-count header response.
	TagCount *int64

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// blobClientGetTagsResponse contains the response from method blobClient.GetTags.
type blobClientGetTagsResponse struct {
	blobClientGetTagsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientGetTagsResult contains the result from method blobClient.GetTags.
type blobClientGetTagsResult struct {
	BlobTags
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// blobClientQueryResponse contains the response from method blobClient.Query.
type blobClientQueryResponse struct {
	blobClientQueryResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientQueryResult contains the result from method blobClient.Query.
type blobClientQueryResult struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// BlobContentMD5 contains the information returned from the x-ms-blob-content-md5 header response.
	BlobContentMD5 []byte

	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// BlobType contains the information returned from the x-ms-blob-type header response.
	BlobType *BlobType

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	ContentCRC64 []byte

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentRange contains the information returned from the Content-Range header response.
	ContentRange *string

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientReleaseLeaseResponse contains the response from method blobClient.ReleaseLease.
type blobClientReleaseLeaseResponse struct {
	blobClientReleaseLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientReleaseLeaseResult contains the result from method blobClient.ReleaseLease.
type blobClientReleaseLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientRenewLeaseResponse contains the response from method blobClient.RenewLease.
type blobClientRenewLeaseResponse struct {
	blobClientRenewLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientRenewLeaseResult contains the result from method blobClient.RenewLease.
type blobClientRenewLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientSetExpiryResponse contains the response from method blobClient.SetExpiry.
type blobClientSetExpiryResponse struct {
	blobClientSetExpiryResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetExpiryResult contains the result from method blobClient.SetExpiry.
type blobClientSetExpiryResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientSetHTTPHeadersResponse contains the response from method blobClient.SetHTTPHeaders.
type blobClientSetHTTPHeadersResponse struct {
	blobClientSetHTTPHeadersResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetHTTPHeadersResult contains the result from method blobClient.SetHTTPHeaders.
type blobClientSetHTTPHeadersResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientSetImmutabilityPolicyResponse contains the response from method blobClient.SetImmutabilityPolicy.
type blobClientSetImmutabilityPolicyResponse struct {
	blobClientSetImmutabilityPolicyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetImmutabilityPolicyResult contains the result from method blobClient.SetImmutabilityPolicy.
type blobClientSetImmutabilityPolicyResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ImmutabilityPolicyExpiry contains the information returned from the x-ms-immutability-policy-until-date header response.
	ImmutabilityPolicyExpiry *time.Time

	// ImmutabilityPolicyMode contains the information returned from the x-ms-immutability-policy-mode header response.
	ImmutabilityPolicyMode *BlobImmutabilityPolicyMode

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientSetLegalHoldResponse contains the response from method blobClient.SetLegalHold.
type blobClientSetLegalHoldResponse struct {
	blobClientSetLegalHoldResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetLegalHoldResult contains the result from method blobClient.SetLegalHold.
type blobClientSetLegalHoldResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// LegalHold contains the information returned from the x-ms-legal-hold header response.
	LegalHold *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientSetMetadataResponse contains the response from method blobClient.SetMetadata.
type blobClientSetMetadataResponse struct {
	blobClientSetMetadataResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetMetadataResult contains the result from method blobClient.SetMetadata.
type blobClientSetMetadataResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// blobClientSetTagsResponse contains the response from method blobClient.SetTags.
type blobClientSetTagsResponse struct {
	blobClientSetTagsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetTagsResult contains the result from method blobClient.SetTags.
type blobClientSetTagsResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientSetTierResponse contains the response from method blobClient.SetTier.
type blobClientSetTierResponse struct {
	blobClientSetTierResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientSetTierResult contains the result from method blobClient.SetTier.
type blobClientSetTierResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blobClientStartCopyFromURLResponse contains the response from method blobClient.StartCopyFromURL.
type blobClientStartCopyFromURLResponse struct {
	blobClientStartCopyFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientStartCopyFromURLResult contains the result from method blobClient.StartCopyFromURL.
type blobClientStartCopyFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// blobClientUndeleteResponse contains the response from method blobClient.Undelete.
type blobClientUndeleteResponse struct {
	blobClientUndeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blobClientUndeleteResult contains the result from method blobClient.Undelete.
type blobClientUndeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// blockBlobClientCommitBlockListResponse contains the response from method blockBlobClient.CommitBlockList.
type blockBlobClientCommitBlockListResponse struct {
	blockBlobClientCommitBlockListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blockBlobClientCommitBlockListResult contains the result from method blockBlobClient.CommitBlockList.
type blockBlobClientCommitBlockListResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// blockBlobClientGetBlockListResponse contains the response from method blockBlobClient.GetBlockList.
type blockBlobClientGetBlockListResponse struct {
	blockBlobClientGetBlockListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blockBlobClientGetBlockListResult contains the result from method blockBlobClient.GetBlockList.
type blockBlobClientGetBlockListResult struct {
	BlockList
	// BlobContentLength contains the information returned from the x-ms-blob-content-length header response.
	BlobContentLength *int64 `xml:"BlobContentLength"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string `xml:"ContentType"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// blockBlobClientPutBlobFromURLResponse contains the response from method blockBlobClient.PutBlobFromURL.
type blockBlobClientPutBlobFromURLResponse struct {
	blockBlobClientPutBlobFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blockBlobClientPutBlobFromURLResult contains the result from method blockBlobClient.PutBlobFromURL.
type blockBlobClientPutBlobFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// blockBlobClientStageBlockFromURLResponse contains the response from method blockBlobClient.StageBlockFromURL.
type blockBlobClientStageBlockFromURLResponse struct {
	blockBlobClientStageBlockFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blockBlobClientStageBlockFromURLResult contains the result from method blockBlobClient.StageBlockFromURL.
type blockBlobClientStageBlockFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// blockBlobClientStageBlockResponse contains the response from method blockBlobClient.StageBlock.
type blockBlobClientStageBlockResponse struct {
	blockBlobClientStageBlockResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blockBlobClientStageBlockResult contains the result from method blockBlobClient.StageBlock.
type blockBlobClientStageBlockResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// blockBlobClientUploadResponse contains the response from method blockBlobClient.Upload.
type blockBlobClientUploadResponse struct {
	blockBlobClientUploadResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// blockBlobClientUploadResult contains the result from method blockBlobClient.Upload.
type blockBlobClientUploadResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// containerClientAcquireLeaseResponse contains the response from method containerClient.AcquireLease.
type containerClientAcquireLeaseResponse struct {
	containerClientAcquireLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientAcquireLeaseResult contains the result from method containerClient.AcquireLease.
type containerClientAcquireLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientBreakLeaseResponse contains the response from method containerClient.BreakLease.
type containerClientBreakLeaseResponse struct {
	containerClientBreakLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientBreakLeaseResult contains the result from method containerClient.BreakLease.
type containerClientBreakLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseTime contains the information returned from the x-ms-lease-time header response.
	LeaseTime *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientChangeLeaseResponse contains the response from method containerClient.ChangeLease.
type containerClientChangeLeaseResponse struct {
	containerClientChangeLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientChangeLeaseResult contains the result from method containerClient.ChangeLease.
type containerClientChangeLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientCreateResponse contains the response from method containerClient.Create.
type containerClientCreateResponse struct {
	containerClientCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientCreateResult contains the result from method containerClient.Create.
type containerClientCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientDeleteResponse contains the response from method containerClient.Delete.
type containerClientDeleteResponse struct {
	containerClientDeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientDeleteResult contains the result from method containerClient.Delete.
type containerClientDeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientGetAccessPolicyResponse contains the response from method containerClient.GetAccessPolicy.
type containerClientGetAccessPolicyResponse struct {
	containerClientGetAccessPolicyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientGetAccessPolicyResult contains the result from method containerClient.GetAccessPolicy.
type containerClientGetAccessPolicyResult struct {
	// BlobPublicAccess contains the information returned from the x-ms-blob-public-access header response.
	BlobPublicAccess *PublicAccessType `xml:"BlobPublicAccess"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// a collection of signed identifiers
	SignedIdentifiers []*SignedIdentifier `xml:"SignedIdentifier"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// containerClientGetAccountInfoResponse contains the response from method containerClient.GetAccountInfo.
type containerClientGetAccountInfoResponse struct {
	containerClientGetAccountInfoResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientGetAccountInfoResult contains the result from method containerClient.GetAccountInfo.
type containerClientGetAccountInfoResult struct {
	// AccountKind contains the information returned from the x-ms-account-kind header response.
	AccountKind *AccountKind

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// SKUName contains the information returned from the x-ms-sku-name header response.
	SKUName *SKUName

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientGetPropertiesResponse contains the response from method containerClient.GetProperties.
type containerClientGetPropertiesResponse struct {
	containerClientGetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientGetPropertiesResult contains the result from method containerClient.GetProperties.
type containerClientGetPropertiesResult struct {
	// BlobPublicAccess contains the information returned from the x-ms-blob-public-access header response.
	BlobPublicAccess *PublicAccessType

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// DefaultEncryptionScope contains the information returned from the x-ms-default-encryption-scope header response.
	DefaultEncryptionScope *string

	// DenyEncryptionScopeOverride contains the information returned from the x-ms-deny-encryption-scope-override header response.
	DenyEncryptionScopeOverride *bool

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// HasImmutabilityPolicy contains the information returned from the x-ms-has-immutability-policy header response.
	HasImmutabilityPolicy *bool

	// HasLegalHold contains the information returned from the x-ms-has-legal-hold header response.
	HasLegalHold *bool

	// IsImmutableStorageWithVersioningEnabled contains the information returned from the x-ms-immutable-storage-with-versioning-enabled
	// header response.
	IsImmutableStorageWithVersioningEnabled *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientListBlobFlatSegmentResponse contains the response from method containerClient.ListBlobFlatSegment.
type containerClientListBlobFlatSegmentResponse struct {
	containerClientListBlobFlatSegmentResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientListBlobFlatSegmentResult contains the result from method containerClient.ListBlobFlatSegment.
type containerClientListBlobFlatSegmentResult struct {
	ListBlobsFlatSegmentResponse
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string `xml:"ContentType"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// containerClientListBlobHierarchySegmentResponse contains the response from method containerClient.ListBlobHierarchySegment.
type containerClientListBlobHierarchySegmentResponse struct {
	containerClientListBlobHierarchySegmentResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientListBlobHierarchySegmentResult contains the result from method containerClient.ListBlobHierarchySegment.
type containerClientListBlobHierarchySegmentResult struct {
	ListBlobsHierarchySegmentResponse
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string `xml:"ContentType"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// containerClientReleaseLeaseResponse contains the response from method containerClient.ReleaseLease.
type containerClientReleaseLeaseResponse struct {
	containerClientReleaseLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientReleaseLeaseResult contains the result from method containerClient.ReleaseLease.
type containerClientReleaseLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientRenameResponse contains the response from method containerClient.Rename.
type containerClientRenameResponse struct {
	containerClientRenameResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientRenameResult contains the result from method containerClient.Rename.
type containerClientRenameResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientRenewLeaseResponse contains the response from method containerClient.RenewLease.
type containerClientRenewLeaseResponse struct {
	containerClientRenewLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientRenewLeaseResult contains the result from method containerClient.RenewLease.
type containerClientRenewLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientRestoreResponse contains the response from method containerClient.Restore.
type containerClientRestoreResponse struct {
	containerClientRestoreResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientRestoreResult contains the result from method containerClient.Restore.
type containerClientRestoreResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientSetAccessPolicyResponse contains the response from method containerClient.SetAccessPolicy.
type containerClientSetAccessPolicyResponse struct {
	containerClientSetAccessPolicyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientSetAccessPolicyResult contains the result from method containerClient.SetAccessPolicy.
type containerClientSetAccessPolicyResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientSetMetadataResponse contains the response from method containerClient.SetMetadata.
type containerClientSetMetadataResponse struct {
	containerClientSetMetadataResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientSetMetadataResult contains the result from method containerClient.SetMetadata.
type containerClientSetMetadataResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// containerClientSubmitBatchResponse contains the response from method containerClient.SubmitBatch.
type containerClientSubmitBatchResponse struct {
	containerClientSubmitBatchResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// containerClientSubmitBatchResult contains the result from method containerClient.SubmitBatch.
type containerClientSubmitBatchResult struct {
	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// pageBlobClientClearPagesResponse contains the response from method pageBlobClient.ClearPages.
type pageBlobClientClearPagesResponse struct {
	pageBlobClientClearPagesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientClearPagesResult contains the result from method pageBlobClient.ClearPages.
type pageBlobClientClearPagesResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// pageBlobClientCopyIncrementalResponse contains the response from method pageBlobClient.CopyIncremental.
type pageBlobClientCopyIncrementalResponse struct {
	pageBlobClientCopyIncrementalResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientCopyIncrementalResult contains the result from method pageBlobClient.CopyIncremental.
type pageBlobClientCopyIncrementalResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// pageBlobClientCreateResponse contains the response from method pageBlobClient.Create.
type pageBlobClientCreateResponse struct {
	pageBlobClientCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientCreateResult contains the result from method pageBlobClient.Create.
type pageBlobClientCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// pageBlobClientGetPageRangesDiffResponse contains the response from method pageBlobClient.GetPageRangesDiff.
type pageBlobClientGetPageRangesDiffResponse struct {
	pageBlobClientGetPageRangesDiffResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientGetPageRangesDiffResult contains the result from method pageBlobClient.GetPageRangesDiff.
type pageBlobClientGetPageRangesDiffResult struct {
	PageList
	// BlobContentLength contains the information returned from the x-ms-blob-content-length header response.
	BlobContentLength *int64 `xml:"BlobContentLength"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// pageBlobClientGetPageRangesResponse contains the response from method pageBlobClient.GetPageRanges.
type pageBlobClientGetPageRangesResponse struct {
	pageBlobClientGetPageRangesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientGetPageRangesResult contains the result from method pageBlobClient.GetPageRanges.
type pageBlobClientGetPageRangesResult struct {
	PageList
	// BlobContentLength contains the information returned from the x-ms-blob-content-length header response.
	BlobContentLength *int64 `xml:"BlobContentLength"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// pageBlobClientResizeResponse contains the response from method pageBlobClient.Resize.
type pageBlobClientResizeResponse struct {
	pageBlobClientResizeResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientResizeResult contains the result from method pageBlobClient.Resize.
type pageBlobClientResizeResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// pageBlobClientUpdateSequenceNumberResponse contains the response from method pageBlobClient.UpdateSequenceNumber.
type pageBlobClientUpdateSequenceNumberResponse struct {
	pageBlobClientUpdateSequenceNumberResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientUpdateSequenceNumberResult contains the result from method pageBlobClient.UpdateSequenceNumber.
type pageBlobClientUpdateSequenceNumberResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// pageBlobClientUploadPagesFromURLResponse contains the response from method pageBlobClient.UploadPagesFromURL.
type pageBlobClientUploadPagesFromURLResponse struct {
	pageBlobClientUploadPagesFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientUploadPagesFromURLResult contains the result from method pageBlobClient.UploadPagesFromURL.
type pageBlobClientUploadPagesFromURLResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// pageBlobClientUploadPagesResponse contains the response from method pageBlobClient.UploadPages.
type pageBlobClientUploadPagesResponse struct {
	pageBlobClientUploadPagesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// pageBlobClientUploadPagesResult contains the result from method pageBlobClient.UploadPages.
type pageBlobClientUploadPagesResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// serviceClientFilterBlobsResponse contains the response from method serviceClient.FilterBlobs.
type serviceClientFilterBlobsResponse struct {
	serviceClientFilterBlobsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientFilterBlobsResult contains the result from method serviceClient.FilterBlobs.
type serviceClientFilterBlobsResult struct {
	FilterBlobSegment
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// serviceClientGetAccountInfoResponse contains the response from method serviceClient.GetAccountInfo.
type serviceClientGetAccountInfoResponse struct {
	serviceClientGetAccountInfoResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientGetAccountInfoResult contains the result from method serviceClient.GetAccountInfo.
type serviceClientGetAccountInfoResult struct {
	// AccountKind contains the information returned from the x-ms-account-kind header response.
	AccountKind *AccountKind

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// IsHierarchicalNamespaceEnabled contains the information returned from the x-ms-is-hns-enabled header response.
	IsHierarchicalNamespaceEnabled *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// SKUName contains the information returned from the x-ms-sku-name header response.
	SKUName *SKUName

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// serviceClientGetPropertiesResponse contains the response from method serviceClient.GetProperties.
type serviceClientGetPropertiesResponse struct {
	serviceClientGetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientGetPropertiesResult contains the result from method serviceClient.GetProperties.
type serviceClientGetPropertiesResult struct {
	StorageServiceProperties
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// serviceClientGetStatisticsResponse contains the response from method serviceClient.GetStatistics.
type serviceClientGetStatisticsResponse struct {
	serviceClientGetStatisticsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientGetStatisticsResult contains the result from method serviceClient.GetStatistics.
type serviceClientGetStatisticsResult struct {
	StorageServiceStats
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// serviceClientGetUserDelegationKeyResponse contains the response from method serviceClient.GetUserDelegationKey.
type serviceClientGetUserDelegationKeyResponse struct {
	serviceClientGetUserDelegationKeyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientGetUserDelegationKeyResult contains the result from method serviceClient.GetUserDelegationKey.
type serviceClientGetUserDelegationKeyResult struct {
	UserDelegationKey
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// serviceClientListContainersSegmentResponse contains the response from method serviceClient.ListContainersSegment.
type serviceClientListContainersSegmentResponse struct {
	serviceClientListContainersSegmentResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientListContainersSegmentResult contains the result from method serviceClient.ListContainersSegment.
type serviceClientListContainersSegmentResult struct {
	ListContainersSegmentResponse
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// serviceClientSetPropertiesResponse contains the response from method serviceClient.SetProperties.
type serviceClientSetPropertiesResponse struct {
	serviceClientSetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientSetPropertiesResult contains the result from method serviceClient.SetProperties.
type serviceClientSetPropertiesResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// serviceClientSubmitBatchResponse contains the response from method serviceClient.SubmitBatch.
type serviceClientSubmitBatchResponse struct {
	serviceClientSubmitBatchResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// serviceClientSubmitBatchResult contains the result from method serviceClient.SubmitBatch.
type serviceClientSubmitBatchResult struct {
	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}
