#include "common.h"
#include "cov_types.H"
#include "testfw.H"

TEST(merge_cov_status)
{
#define CASE(a, b, r) \
    check(cov::merge(cov::a, cov::b) == cov::r)

    CASE(COVERED, COVERED, COVERED);
    CASE(COVERED, PARTCOVERED, PARTCOVERED);
    CASE(COVERED, UNCOVERED, PARTCOVERED);
    CASE(COVERED, UNINSTRUMENTED, COVERED);
    CASE(COVERED, SUPPRESSED, COVERED);

    CASE(PARTCOVERED, COVERED, PARTCOVERED);
    CASE(PARTCOVERED, PARTCOVERED, PARTCOVERED);
    CASE(PARTCOVERED, UNCOVERED, PARTCOVERED);
    CASE(PARTCOVERED, UNINSTRUMENTED, PARTCOVERED);
    CASE(PARTCOVERED, SUPPRESSED, PARTCOVERED);

    CASE(UNCOVERED, COVERED, PARTCOVERED);
    CASE(UNCOVERED, PARTCOVERED, PARTCOVERED);
    CASE(UNCOVERED, UNCOVERED, UNCOVERED);
    CASE(UNCOVERED, UNINSTRUMENTED, UNCOVERED);
    CASE(UNCOVERED, SUPPRESSED, UNCOVERED);

    CASE(UNINSTRUMENTED, COVERED, COVERED);
    CASE(UNINSTRUMENTED, PARTCOVERED, PARTCOVERED);
    CASE(UNINSTRUMENTED, UNCOVERED, UNCOVERED);
    CASE(UNINSTRUMENTED, UNINSTRUMENTED, UNINSTRUMENTED);
    CASE(UNINSTRUMENTED, SUPPRESSED, SUPPRESSED);

    CASE(SUPPRESSED, COVERED, COVERED);
    CASE(SUPPRESSED, PARTCOVERED, PARTCOVERED);
    CASE(SUPPRESSED, UNCOVERED, UNCOVERED);
    CASE(SUPPRESSED, UNINSTRUMENTED, SUPPRESSED);
    CASE(SUPPRESSED, SUPPRESSED, SUPPRESSED);
#undef CASE
}

