.\" @(#)$RCSfile: gfal_set_ids_python.man,v $ $Revision: 1.5 $ $Date: 2009/04/16 15:26:19 $ CERN Remi Mollon
.\" Copyright (C) 2007 by CERN
.\" All rights reserved
.\"
.TH GFAL_SET_IDS 3 "$Date: 2009/04/16 15:26:19 $" GFAL "Library Functions"
.SH NAME
gfal_set_ids \- Sets the SRM file/request ids in the 'gfal_internal' object
.SH SYNOPSIS
\fBimport gfal\fR
.sp
.BI "(int " returncode ,
.BI "gfal_internal " gfal ,
.BI "string " errmsg
.BI ") gfal_set_ids (gfal_internal " gfal ,
.BI "listOfInt " srm_fileids ,
.BI "int " srm_reqid ,
.BI "string " srmv2_reqtoken
.B )

.SH DESCRIPTION
.B gfal_set_ids
Sets the SRM file/request ids in the
.B gfal_internal
object.

.TP
.I gfal
.B gfal_internal
object generated from user parameters.
.TP
.I srm_reqid
The request id returned by a SRMv1 SE.
.TP
.I srm_fileids
The table of file ids returned by a SRMv1 SE.
.TP
.I srmv2_reqtoken
The request token returned by a SRMv2 SE.

.SH RETURN VALUE
This routine returns 0 on a success, or -1 in case of error. In the latter case,
.B errno
is set appropriately. Moreover, you can get an error message from
.I errbuf
, if specified.

.SH ERRORS
.B errno
indicates the type of error, but for detailled error message, you have to look into
.IR errbuf .
.TP 1.3i
.B EINVAL
One or more parameter in 
.I req
have a wrong value.

.SH SEE ALSO
.BR gfal_python (3),
.BR gfal_init_python (3),
.BR gfal_set_ids_python (3),
.BR gfal_get_results_python (3),
.BR gfal_internal_free_python (3),
.BR gfal_deletesurls_python (3),
.BR gfal_removedir_python (3),
.BR gfal_get_python (3),
.BR gfal_getstatus_python (3),
.BR gfal_ls_python (3),
.BR gfal_pin_python (3),
.BR gfal_prestage_python (3),
.BR gfal_prestagestatus_python (3),
.BR gfal_release_python (3),
.BR gfal_set_xfer_done_python (3),
.BR gfal_set_xfer_running_python (3),
.BR gfal_turlsfromsurls_python (3),
.BR gfal_get_ids_python (3),
.BR gfal_set_ids_python (3),
.BR gfal_get_results_python (3),
.BR gfal_access_python (3) ,
.BR gfal_chmod_python (3) ,
.BR gfal_close_python (3) ,
.BR gfal_closedir_python (3) ,
.BR gfal_creat_python (3) ,
.BR gfal_get_timeout_connect_python (3) ,
.BR gfal_get_timeout_sendreceive_python (3) ,
.BR gfal_get_timeout_bdii_python (3) ,
.BR gfal_get_timeout_srm_python (3) ,
.BR gfal_set_timeout_connect_python (3) ,
.BR gfal_set_timeout_sendreceive_python (3) ,
.BR gfal_set_timeout_bdii_python (3) ,
.BR gfal_set_timeout_srm_python (3) ,
.BR gfal_lseek_python (3) ,
.BR gfal_mkdir_python (3) ,
.BR gfal_open_python (3) ,
.BR gfal_opendir_python (3) ,
.BR gfal_read_python (3) ,
.BR gfal_rename_python (3) ,
.BR gfal_rmdir_python (3) ,
.BR gfal_stat_python (3) ,
.BR gfal_unlink_python (3) ,
.BR gfal_write_python (3) ,
.BR gfal_set_verbose_python (3) ,
.BR gfal_get_errno_python (3) ,
