#!/bin/sh
#**********************************************************************
# Copyright (C) 2023 - The Geeqie Team
#
# Author: Colin Clark
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#**********************************************************************

## @file
## @brief Run image tests
##
## $1 Geeqie executable
## $2 Full path to image
##
##

xvfb-run --auto-servernum "$1" "$2" &

if [ -z "$XDG_CONFIG_HOME" ]
then
	config_home="$HOME/.config"
else
	config_home="$XDG_CONFIG_HOME"
fi

# Wait for remote to initialize
while [ ! -e "$config_home/geeqie/.command" ] ;
do
	sleep 1
done

sleep 2

# Check if Geeqie crashed
if ! pgrep geeqie
then
	rm "$config_home/geeqie/.command"
	exit 1
fi

result=$(xvfb-run --auto-servernum "$1" --remote --get-file-info)
xvfb-run --auto-servernum "$1" --remote --quit

if echo "$result" | grep -q "Class: Unknown"
then
	exit 1
else
	exit 0
fi

