;; Pipeline model for LoongArch LA464 cores.

;; Copyright (C) 2021-2023 Free Software Foundation, Inc.
;; Contributed by Loongson Ltd.

;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

;; Uncomment the following line to output automata for debugging.
;; (automata_option "v")

;; Automaton for integer instructions.
(define_automaton "la464_a_alu")

;; Automaton for floating-point instructions.
(define_automaton "la464_a_falu")

;; Automaton for memory operations.
(define_automaton "la464_a_mem")

;; Describe the resources.

(define_cpu_unit "la464_alu1" "la464_a_alu")
(define_cpu_unit "la464_alu2" "la464_a_alu")
(define_cpu_unit "la464_mem1" "la464_a_mem")
(define_cpu_unit "la464_mem2" "la464_a_mem")
(define_cpu_unit "la464_falu1" "la464_a_falu")
(define_cpu_unit "la464_falu2" "la464_a_falu")

;; Describe instruction reservations.

(define_insn_reservation "la464_arith" 1
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "arith,clz,const,logical,
			move,nop,shift,signext,slt"))
  "la464_alu1 | la464_alu2")

(define_insn_reservation "la464_branch" 1
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "branch,jump,call,condmove,trap"))
  "la464_alu1 | la464_alu2")

(define_insn_reservation "la464_imul" 7
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "imul"))
  "la464_alu1 | la464_alu2")

(define_insn_reservation "la464_idiv_si" 12
  (and (match_test "TARGET_uARCH_LA464")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "SI")))
  "la464_alu1 | la464_alu2")

(define_insn_reservation "la464_idiv_di" 25
  (and (match_test "TARGET_uARCH_LA464")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "la464_alu1 | la464_alu2")

(define_insn_reservation "la464_load" 4
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "load"))
  "la464_mem1 | la464_mem2")

(define_insn_reservation "la464_gpr_fp" 16
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "mftg,mgtf"))
  "la464_mem1")

(define_insn_reservation "la464_fpload" 4
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "fpload"))
  "la464_mem1 | la464_mem2")

(define_insn_reservation "la464_prefetch" 0
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "prefetch,prefetchx"))
  "la464_mem1 | la464_mem2")

(define_insn_reservation "la464_store" 0
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "store,fpstore,fpidxstore"))
  "la464_mem1 | la464_mem2")

(define_insn_reservation "la464_fadd" 4
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "fadd,fmul,fmadd"))
  "la464_falu1 | la464_falu2")

(define_insn_reservation "la464_fcmp" 2
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "fabs,fcmp,fmove,fneg"))
  "la464_falu1 | la464_falu2")

(define_insn_reservation "la464_fcvt" 4
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "fcvt"))
  "la464_falu1 | la464_falu2")

(define_insn_reservation "la464_fdiv_sf" 12
  (and (match_test "TARGET_uARCH_LA464")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "la464_falu1 | la464_falu2")

(define_insn_reservation "la464_fdiv_df" 19
  (and (match_test "TARGET_uARCH_LA464")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "la464_falu1 | la464_falu2")

;; Force single-dispatch for unknown or multi.
(define_insn_reservation "la464_unknown" 1
  (and (match_test "TARGET_uARCH_LA464")
       (eq_attr "type" "unknown,multi,atomic,syncloop"))
  "la464_alu1 + la464_alu2 + la464_falu1
   + la464_falu2 + la464_mem1 + la464_mem2")

;; End of DFA-based pipeline description for la464
