"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C

"""

from gastables.ObliqueShock import ObliqueShock
from scipy import arange

def get_allValues_from_Mx_and_Wave_Angle(Mx,Wave_Angle,gamma):
    os = ObliqueShock(gamma)
    return get_allValues_from_Mx_and_Turn_Angle(Mx, os.get_Turn_Angle_from_Mx_and_Wave_Angle(Mx,Wave_Angle),gamma)
    

def get_allValues_from_Mx_and_Turn_Angle(Mx,Turn_Angle,gamma):
    os = ObliqueShock(gamma)

    VALUES = {}
    VALUES["Mx"] = Mx
    VALUES["Turn Angle"] = Turn_Angle
    VALUES["Wave Angle"] = os.get_Wave_Angle_from_Mx_and_Turn_Angle(Mx,Turn_Angle)
    VALUES["My"] = os.get_My_from_Mx_and_Turn_Angle(Mx,Turn_Angle)
    VALUES["Py/Px"] = os.get_Py_by_Px_from_Mx_and_Turn_Angle(Mx,Turn_Angle)
    VALUES["Ty/Tx"] = os.get_Ty_by_Tx_from_Mx_and_Turn_Angle(Mx,Turn_Angle)
    VALUES["ry/rx"] = os.get_rhoy_by_rhox_from_Mx_and_Turn_Angle(Mx,Turn_Angle)
    VALUES["Poy/Px"] = os.get_Poy_by_Px_from_Mx_and_Turn_Angle(Mx,Turn_Angle)
    VALUES["Poy/Pox"] = os.get_Poy_by_Pox_from_Mx_and_Turn_Angle(Mx,Turn_Angle)

    SECOND_VALUES = {}
    SECOND_VALUES["Mx"] = Mx
    SECOND_VALUES["Turn Angle"] = Turn_Angle
    SECOND_VALUES["Wave Angle"] = os.get_Wave_Angle_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)
    SECOND_VALUES["My"] = os.get_My_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)
    SECOND_VALUES["Py/Px"] = os.get_Py_by_Px_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)
    SECOND_VALUES["Ty/Tx"] = os.get_Ty_by_Tx_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)
    SECOND_VALUES["ry/rx"] = os.get_rhoy_by_rhox_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)
    SECOND_VALUES["Poy/Px"] = os.get_Poy_by_Px_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)
    SECOND_VALUES["Poy/Pox"] = os.get_Poy_by_Pox_from_Mx_and_Turn_Angle(Mx,Turn_Angle, True)

    return VALUES, SECOND_VALUES

def get_plotData_from_M(Mx,gamma):
    Wave_Angle_Range = arange(10,80.01,0.1)
    VALUES = {"Mx" : Mx, "Turn Angle" : [],"Wave Angle" : Wave_Angle_Range, "My" : [], "Py/Px" : [], "Poy/Px" : [], "Poy/Pox" : [],"ry/rx" : [] , "Ty/Tx" : []}
    os = ObliqueShock(gamma)
    for Wave_Angle in Wave_Angle_Range:
        Turn_Angle = os.get_Turn_Angle_from_Mx_and_Wave_Angle(Mx,Wave_Angle)
        VALUES["Turn Angle"].append(Turn_Angle)
        VALUES["My"].append(os.get_My_from_Mx_and_Turn_Angle(Mx,Turn_Angle))
        VALUES["Py/Px"].append(os.get_Py_by_Px_from_Mx_and_Turn_Angle(Mx,Turn_Angle))
        VALUES["Ty/Tx"].append(os.get_Ty_by_Tx_from_Mx_and_Turn_Angle(Mx,Turn_Angle))
        VALUES["ry/rx"].append(os.get_rhoy_by_rhox_from_Mx_and_Turn_Angle(Mx,Turn_Angle))
        VALUES["Poy/Px"].append(os.get_Poy_by_Px_from_Mx_and_Turn_Angle(Mx,Turn_Angle))
        VALUES["Poy/Pox"].append(os.get_Poy_by_Pox_from_Mx_and_Turn_Angle(Mx,Turn_Angle))
    return VALUES
