/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.Attribute;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConstructor;
import opendap.dap.DataReadException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;
import opendap.dap.XMLparser.DDSXMLParser;

public class DGrid
extends DConstructor
implements ClientIO {
    public static final int ARRAY = 1;
    public static final int MAPS = 2;
    protected DArray arrayVar;
    protected Vector mapVars = new Vector();

    public DGrid() {
        this(null);
    }

    public DGrid(String n) {
        super(n);
    }

    public Object clone() {
        DGrid g = (DGrid)super.clone();
        g.arrayVar = (DArray)this.arrayVar.clone();
        g.mapVars = new Vector();
        for (int i = 0; i < this.mapVars.size(); ++i) {
            BaseType bt = (BaseType)this.mapVars.elementAt(i);
            g.mapVars.addElement(bt.clone());
        }
        return g;
    }

    public String getTypeName() {
        return "Grid";
    }

    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.mapVars.size() + 1;
        }
        int count = 0;
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            count += bt.elementCount(leaves);
        }
        return count += this.arrayVar.elementCount(leaves);
    }

    public void addVariable(BaseType v, int part) {
        if (!(v instanceof DArray)) {
            throw new IllegalArgumentException("Grid `" + this.getName() + "'s' member `" + this.arrayVar.getName() + "' must be an array");
        }
        v.setParent(this);
        switch (part) {
            case 1: {
                this.arrayVar = (DArray)v;
                return;
            }
            case 2: {
                this.mapVars.addElement(v);
                return;
            }
        }
        throw new IllegalArgumentException("addVariable(): Unknown Grid part");
    }

    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            if (this.arrayVar.getName().equals(name)) {
                return this.arrayVar;
            }
            Enumeration e = this.mapVars.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DGrid.getVariable() No such variable: '" + name + "'");
    }

    public BaseType getVar(int index) throws NoSuchVariableException {
        if (index == 0) {
            return this.arrayVar;
        }
        int i = index - 1;
        if (i < this.mapVars.size()) {
            return (BaseType)this.mapVars.elementAt(i);
        }
        throw new NoSuchVariableException("DGrid.getVariable() No Such variable: " + index + " - 1)");
    }

    public Enumeration getVariables() {
        return new EnumerateDGrid();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.mapVars, this.getName(), this.getTypeName());
        if (this.arrayVar == null) {
            throw new BadSemanticsException("DGrid.checkSemantics(): Null grid base array in `" + this.getName() + "'");
        }
        this.arrayVar.checkSemantics(all);
        if (this.mapVars.size() != this.arrayVar.numDimensions()) {
            throw new BadSemanticsException("DGrid.checkSemantics(): The number of map variables for grid `" + this.getName() + "' does not match the number of dimensions of `" + this.arrayVar.getName() + "'");
        }
        Enumeration emap = this.mapVars.elements();
        Enumeration edims = this.arrayVar.getDimensions();
        int dim = 0;
        while (emap.hasMoreElements() && edims.hasMoreElements()) {
            DArray thisMapArray = (DArray)emap.nextElement();
            Enumeration ema = thisMapArray.getDimensions();
            DArrayDimension thisMapDim = (DArrayDimension)ema.nextElement();
            DArrayDimension thisArrayDim = (DArrayDimension)edims.nextElement();
            if (thisMapDim.getSize() != thisArrayDim.getSize()) {
                throw new BadSemanticsException("In grid '" + this.getName() + " The size of dimension " + dim + " in the array component '" + this.arrayVar.getName() + "is not equal to the size of the coresponding map vector '" + thisMapArray.getName() + ".");
            }
            ++dim;
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        os.println(space + " ARRAY:");
        this.arrayVar.printDecl(os, space + "    ", true);
        os.println(space + " MAPS:");
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os, space + "    ", true);
        }
        os.print(space + "} " + this.getName());
        if (print_semi) {
            os.println(";");
        }
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ARRAY: ");
        this.arrayVar.printVal(os, "", false);
        os.print(" MAPS: ");
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printVal(os, "", false);
            if (!e.hasMoreElements()) continue;
            os.print(", ");
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, DataReadException {
        this.arrayVar.deserialize(source, sv, statusUI);
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("DGrid.deserialize(): User cancelled");
            }
            ClientIO bt = (ClientIO)e.nextElement();
            bt.deserialize(source, sv, statusUI);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        this.arrayVar.externalize(sink);
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            ClientIO bt = (ClientIO)e.nextElement();
            bt.externalize(sink);
        }
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Grid");
        if (this.getName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String aName = (String)e.nextElement();
            Attribute a = this.getAttribute(aName);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        this.arrayVar.printXML(pw, pad + "\t", constrained);
        e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            DArray map = (DArray)e.nextElement();
            map.printAsMapXML(pw, pad + "\t", constrained);
        }
        pw.println(pad + "</Grid>");
    }

    class EnumerateDGrid
    implements Enumeration {
        boolean array = false;
        Enumeration e;

        EnumerateDGrid() {
            this.e = DGrid.this.mapVars.elements();
        }

        public boolean hasMoreElements() {
            return !this.array || this.e.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.array) {
                this.array = true;
                return DGrid.this.arrayVar;
            }
            return this.e.nextElement();
        }
    }
}

