/*
 * $Id: loudspeaker.c,v 1.17 2012-02-22 09:27:20 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "loudspeaker.h"

struct cpssp {
	struct sig_sound *port_audio_sound;
};

static void
loudspeaker_sound_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_sound_samples_set(cpssp->port_audio_sound, cpssp, samples);
}

void *
loudspeaker_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_sound *port_sound_in,
	struct sig_sound *port_audio_sound
)
{
	static const struct sig_sound_funcs sound_funcs = {
		.samples_set = loudspeaker_sound_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_audio_sound = port_audio_sound;

	/* In */
	sig_sound_connect(port_sound_in, cpssp, &sound_funcs);

	return cpssp;
}

void
loudspeaker_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
loudspeaker_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
loudspeaker_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
