// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file TestRegression3361.cpp
 * This source file contains the implementation of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace {
char dummy;
}  // namespace
#endif  // _WIN32

#include "TestRegression3361.h"

#if FASTCDR_VERSION_MAJOR > 1

#include "TestRegression3361TypeObject.h"

#include <fastcdr/Cdr.h>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>




TestRegression3361::TestRegression3361()
{
    // Just to register all known types
    registerTestRegression3361Types();
}

TestRegression3361::~TestRegression3361()
{
}

TestRegression3361::TestRegression3361(
        const TestRegression3361& x)
{
    m_uuid = x.m_uuid;
}

TestRegression3361::TestRegression3361(
        TestRegression3361&& x) noexcept
{
    m_uuid = std::move(x.m_uuid);
}

TestRegression3361& TestRegression3361::operator =(
        const TestRegression3361& x)
{

    m_uuid = x.m_uuid;
    return *this;
}

TestRegression3361& TestRegression3361::operator =(
        TestRegression3361&& x) noexcept
{

    m_uuid = std::move(x.m_uuid);
    return *this;
}

bool TestRegression3361::operator ==(
        const TestRegression3361& x) const
{
    return (m_uuid == x.m_uuid);
}

bool TestRegression3361::operator !=(
        const TestRegression3361& x) const
{
    return !(*this == x);
}

/*!
 * @brief This function copies the value in member uuid
 * @param _uuid New value to be copied in member uuid
 */
void TestRegression3361::uuid(
        const TestModule::MACHINEID& _uuid)
{
    m_uuid = _uuid;
}

/*!
 * @brief This function moves the value in member uuid
 * @param _uuid New value to be moved in member uuid
 */
void TestRegression3361::uuid(
        TestModule::MACHINEID&& _uuid)
{
    m_uuid = std::move(_uuid);
}

/*!
 * @brief This function returns a constant reference to member uuid
 * @return Constant reference to member uuid
 */
const TestModule::MACHINEID& TestRegression3361::uuid() const
{
    return m_uuid;
}

/*!
 * @brief This function returns a reference to member uuid
 * @return Reference to member uuid
 */
TestModule::MACHINEID& TestRegression3361::uuid()
{
    return m_uuid;
}


// Include auxiliary functions like for serializing/deserializing.
#include "TestRegression3361CdrAux.ipp"

#endif // FASTCDR_VERSION_MAJOR > 1
