// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file StringTest.cpp
 * This source file contains the implementation of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace {
char dummy;
}  // namespace
#endif  // _WIN32

#include "StringTest.h"

#if FASTCDR_VERSION_MAJOR == 1

#include <fastcdr/Cdr.h>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>

namespace helper { namespace internal {

enum class Size {
    UInt8,
    UInt16,
    UInt32,
    UInt64,
};

constexpr Size get_size(int s) {
    return (s <= 8 ) ? Size::UInt8:
           (s <= 16) ? Size::UInt16:
           (s <= 32) ? Size::UInt32: Size::UInt64;
}

template<Size s>
struct FindTypeH;

template<>
struct FindTypeH<Size::UInt8> {
    using type = std::uint8_t;
};

template<>
struct FindTypeH<Size::UInt16> {
    using type = std::uint16_t;
};

template<>
struct FindTypeH<Size::UInt32> {
    using type = std::uint32_t;
};

template<>
struct FindTypeH<Size::UInt64> {
    using type = std::uint64_t;
};
}

template<int S>
struct FindType {
    using type = typename internal::FindTypeH<internal::get_size(S)>::type;
};
}

#define StringTest_max_cdr_typesize 10009ULL;




StringTest::StringTest()
{
    // /type_d() m_message


}

StringTest::~StringTest()
{
}

StringTest::StringTest(
        const StringTest& x)
{
    m_message = x.m_message;

}

StringTest::StringTest(
        StringTest&& x) noexcept
{
    m_message = std::move(x.m_message);

}

StringTest& StringTest::operator =(
        const StringTest& x)
{
    m_message = x.m_message;

    return *this;
}

StringTest& StringTest::operator =(
        StringTest&& x) noexcept
{
    m_message = std::move(x.m_message);

    return *this;
}

bool StringTest::operator ==(
        const StringTest& x) const
{
    return (m_message == x.m_message);
}

bool StringTest::operator !=(
        const StringTest& x) const
{
    return !(*this == x);
}

size_t StringTest::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return StringTest_max_cdr_typesize;
}

size_t StringTest::getCdrSerializedSize(
        const StringTest& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.message().size() + 1;


    return current_alignment - initial_alignment;
}


void StringTest::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_message.c_str();

}

void StringTest::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    {
        std::string aux;
        dcdr >> aux;
        m_message = aux.c_str();
    }


}


bool StringTest::isKeyDefined()
{
    return false;
}

void StringTest::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function copies the value in member message
 * @param _message New value to be copied in member message
 */
void StringTest::message(
        const eprosima::fastrtps::fixed_string<10000>& _message)
{
    m_message = _message;
}

/*!
 * @brief This function moves the value in member message
 * @param _message New value to be moved in member message
 */
void StringTest::message(
        eprosima::fastrtps::fixed_string<10000>&& _message)
{
    m_message = std::move(_message);
}

/*!
 * @brief This function returns a constant reference to member message
 * @return Constant reference to member message
 */
const eprosima::fastrtps::fixed_string<10000>& StringTest::message() const
{
    return m_message;
}

/*!
 * @brief This function returns a reference to member message
 * @return Reference to member message
 */
eprosima::fastrtps::fixed_string<10000>& StringTest::message()
{
    return m_message;
}




#endif // FASTCDR_VERSION_MAJOR == 1
