// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file monitorservice_types.cpp
 * This source file contains the implementation of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace {
char dummy;
}  // namespace
#endif  // _WIN32

#include "monitorservice_types.h"

#if FASTCDR_VERSION_MAJOR == 1

#include <fastcdr/Cdr.h>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>

namespace helper { namespace internal {

enum class Size {
    UInt8,
    UInt16,
    UInt32,
    UInt64,
};

constexpr Size get_size(int s) {
    return (s <= 8 ) ? Size::UInt8:
           (s <= 16) ? Size::UInt16:
           (s <= 32) ? Size::UInt32: Size::UInt64;
}

template<Size s>
struct FindTypeH;

template<>
struct FindTypeH<Size::UInt8> {
    using type = std::uint8_t;
};

template<>
struct FindTypeH<Size::UInt16> {
    using type = std::uint16_t;
};

template<>
struct FindTypeH<Size::UInt32> {
    using type = std::uint32_t;
};

template<>
struct FindTypeH<Size::UInt64> {
    using type = std::uint64_t;
};
}

template<int S>
struct FindType {
    using type = typename internal::FindTypeH<internal::get_size(S)>::type;
};
}

#define eprosima_fastdds_statistics_DiscoveryTime_max_cdr_typesize 852ULL;

#define eprosima_fastdds_statistics_BaseStatus_s_max_cdr_typesize 8ULL;


#define eprosima_fastdds_statistics_detail_SampleIdentity_s_max_cdr_typesize 44ULL;



#define eprosima_fastdds_statistics_DeadlineMissedStatus_s_max_cdr_typesize 24ULL;
#define eprosima_fastdds_statistics_detail_EntityId_s_max_cdr_typesize 8ULL;
#define eprosima_fastdds_statistics_QosPolicyCount_s_max_cdr_typesize 12ULL;
#define eprosima_fastdds_statistics_detail_SequenceNumber_s_max_cdr_typesize 12ULL;

#define eprosima_fastdds_statistics_MonitorServiceStatusData_max_cdr_typesize 565252ULL;
#define eprosima_fastdds_statistics_PhysicalData_max_cdr_typesize 812ULL;
#define eprosima_fastdds_statistics_detail_Locator_s_max_cdr_typesize 28ULL;
#define eprosima_fastdds_statistics_detail_GuidPrefix_s_max_cdr_typesize 16ULL;
#define eprosima_fastdds_statistics_EntityData_max_cdr_typesize 36ULL;
#define eprosima_fastdds_statistics_Connection_max_cdr_typesize 5652ULL;
#define eprosima_fastdds_statistics_Entity2LocatorTraffic_max_cdr_typesize 82ULL;
#define eprosima_fastdds_statistics_EntityCount_max_cdr_typesize 40ULL;
#define eprosima_fastdds_statistics_IncompatibleQoSStatus_s_max_cdr_typesize 1220ULL;


#define eprosima_fastdds_statistics_WriterReaderData_max_cdr_typesize 64ULL;
#define eprosima_fastdds_statistics_SampleIdentityCount_max_cdr_typesize 56ULL;
#define eprosima_fastdds_statistics_Locator2LocatorData_max_cdr_typesize 64ULL;
#define eprosima_fastdds_statistics_detail_GUID_s_max_cdr_typesize 28ULL;
#define eprosima_fastdds_statistics_LivelinessChangedStatus_s_max_cdr_typesize 28ULL;


namespace eprosima {

namespace fastdds {

namespace statistics {





Connection::Connection()
{
    // eprosima::fastdds::statistics::ConnectionMode m_mode
    m_mode = eprosima::fastdds::statistics::DATA_SHARING;
    // eprosima::fastdds::statistics::detail::GUID_s m_guid

    // sequence<eprosima::fastdds::statistics::detail::Locator_s> m_announced_locators

    // sequence<eprosima::fastdds::statistics::detail::Locator_s> m_used_locators


}

Connection::~Connection()
{
}

Connection::Connection(
        const Connection& x)
{
    m_mode = x.m_mode;


    m_guid = x.m_guid;


    m_announced_locators = x.m_announced_locators;


    m_used_locators = x.m_used_locators;

}

Connection::Connection(
        Connection&& x) noexcept
{
    m_mode = x.m_mode;


    m_guid = std::move(x.m_guid);


    m_announced_locators = std::move(x.m_announced_locators);


    m_used_locators = std::move(x.m_used_locators);

}

Connection& Connection::operator =(
        const Connection& x)
{
    m_mode = x.m_mode;


    m_guid = x.m_guid;


    m_announced_locators = x.m_announced_locators;


    m_used_locators = x.m_used_locators;

    return *this;
}

Connection& Connection::operator =(
        Connection&& x) noexcept
{
    m_mode = x.m_mode;


    m_guid = std::move(x.m_guid);


    m_announced_locators = std::move(x.m_announced_locators);


    m_used_locators = std::move(x.m_used_locators);

    return *this;
}

bool Connection::operator ==(
        const Connection& x) const
{
    return (m_mode == x.m_mode &&
           m_guid == x.m_guid &&
           m_announced_locators == x.m_announced_locators &&
           m_used_locators == x.m_used_locators);
}

bool Connection::operator !=(
        const Connection& x) const
{
    return !(*this == x);
}

size_t Connection::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_Connection_max_cdr_typesize;
}

size_t Connection::getCdrSerializedSize(
        const Connection& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += eprosima::fastdds::statistics::detail::GUID_s::getCdrSerializedSize(data.guid(), current_alignment);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < data.announced_locators().size(); ++a)
    {
        current_alignment += eprosima::fastdds::statistics::detail::Locator_s::getCdrSerializedSize(data.announced_locators().at(a), current_alignment);
    }



    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < data.used_locators().size(); ++a)
    {
        current_alignment += eprosima::fastdds::statistics::detail::Locator_s::getCdrSerializedSize(data.used_locators().at(a), current_alignment);
    }



    return current_alignment - initial_alignment;
}


void Connection::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << (uint32_t)m_mode;

    scdr << m_guid;

    scdr << m_announced_locators;


    scdr << m_used_locators;


}

void Connection::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_mode = (eprosima::fastdds::statistics::ConnectionMode)enum_value;
    }



    dcdr >> m_guid;



    dcdr >> m_announced_locators;



    dcdr >> m_used_locators;


}


bool Connection::isKeyDefined()
{
    return false;
}

void Connection::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function sets a value in member mode
 * @param _mode New value for member mode
 */
void Connection::mode(
        eprosima::fastdds::statistics::ConnectionMode _mode)
{
    m_mode = _mode;
}

/*!
 * @brief This function returns the value of member mode
 * @return Value of member mode
 */
eprosima::fastdds::statistics::ConnectionMode Connection::mode() const
{
    return m_mode;
}

/*!
 * @brief This function returns a reference to member mode
 * @return Reference to member mode
 */
eprosima::fastdds::statistics::ConnectionMode& Connection::mode()
{
    return m_mode;
}


/*!
 * @brief This function copies the value in member guid
 * @param _guid New value to be copied in member guid
 */
void Connection::guid(
        const eprosima::fastdds::statistics::detail::GUID_s& _guid)
{
    m_guid = _guid;
}

/*!
 * @brief This function moves the value in member guid
 * @param _guid New value to be moved in member guid
 */
void Connection::guid(
        eprosima::fastdds::statistics::detail::GUID_s&& _guid)
{
    m_guid = std::move(_guid);
}

/*!
 * @brief This function returns a constant reference to member guid
 * @return Constant reference to member guid
 */
const eprosima::fastdds::statistics::detail::GUID_s& Connection::guid() const
{
    return m_guid;
}

/*!
 * @brief This function returns a reference to member guid
 * @return Reference to member guid
 */
eprosima::fastdds::statistics::detail::GUID_s& Connection::guid()
{
    return m_guid;
}


/*!
 * @brief This function copies the value in member announced_locators
 * @param _announced_locators New value to be copied in member announced_locators
 */
void Connection::announced_locators(
        const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& _announced_locators)
{
    m_announced_locators = _announced_locators;
}

/*!
 * @brief This function moves the value in member announced_locators
 * @param _announced_locators New value to be moved in member announced_locators
 */
void Connection::announced_locators(
        std::vector<eprosima::fastdds::statistics::detail::Locator_s>&& _announced_locators)
{
    m_announced_locators = std::move(_announced_locators);
}

/*!
 * @brief This function returns a constant reference to member announced_locators
 * @return Constant reference to member announced_locators
 */
const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& Connection::announced_locators() const
{
    return m_announced_locators;
}

/*!
 * @brief This function returns a reference to member announced_locators
 * @return Reference to member announced_locators
 */
std::vector<eprosima::fastdds::statistics::detail::Locator_s>& Connection::announced_locators()
{
    return m_announced_locators;
}


/*!
 * @brief This function copies the value in member used_locators
 * @param _used_locators New value to be copied in member used_locators
 */
void Connection::used_locators(
        const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& _used_locators)
{
    m_used_locators = _used_locators;
}

/*!
 * @brief This function moves the value in member used_locators
 * @param _used_locators New value to be moved in member used_locators
 */
void Connection::used_locators(
        std::vector<eprosima::fastdds::statistics::detail::Locator_s>&& _used_locators)
{
    m_used_locators = std::move(_used_locators);
}

/*!
 * @brief This function returns a constant reference to member used_locators
 * @return Constant reference to member used_locators
 */
const std::vector<eprosima::fastdds::statistics::detail::Locator_s>& Connection::used_locators() const
{
    return m_used_locators;
}

/*!
 * @brief This function returns a reference to member used_locators
 * @return Reference to member used_locators
 */
std::vector<eprosima::fastdds::statistics::detail::Locator_s>& Connection::used_locators()
{
    return m_used_locators;
}





QosPolicyCount_s::QosPolicyCount_s()
{
    // unsigned long m_policy_id
    m_policy_id = 0;
    // unsigned long m_count
    m_count = 0;

}

QosPolicyCount_s::~QosPolicyCount_s()
{
}

QosPolicyCount_s::QosPolicyCount_s(
        const QosPolicyCount_s& x)
{
    m_policy_id = x.m_policy_id;


    m_count = x.m_count;

}

QosPolicyCount_s::QosPolicyCount_s(
        QosPolicyCount_s&& x) noexcept
{
    m_policy_id = x.m_policy_id;


    m_count = x.m_count;

}

QosPolicyCount_s& QosPolicyCount_s::operator =(
        const QosPolicyCount_s& x)
{
    m_policy_id = x.m_policy_id;


    m_count = x.m_count;

    return *this;
}

QosPolicyCount_s& QosPolicyCount_s::operator =(
        QosPolicyCount_s&& x) noexcept
{
    m_policy_id = x.m_policy_id;


    m_count = x.m_count;

    return *this;
}

bool QosPolicyCount_s::operator ==(
        const QosPolicyCount_s& x) const
{
    return (m_policy_id == x.m_policy_id &&
           m_count == x.m_count);
}

bool QosPolicyCount_s::operator !=(
        const QosPolicyCount_s& x) const
{
    return !(*this == x);
}

size_t QosPolicyCount_s::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_QosPolicyCount_s_max_cdr_typesize;
}

size_t QosPolicyCount_s::getCdrSerializedSize(
        const QosPolicyCount_s& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}


void QosPolicyCount_s::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_policy_id;

    scdr << m_count;

}

void QosPolicyCount_s::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    dcdr >> m_policy_id;



    dcdr >> m_count;


}


bool QosPolicyCount_s::isKeyDefined()
{
    return false;
}

void QosPolicyCount_s::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function sets a value in member policy_id
 * @param _policy_id New value for member policy_id
 */
void QosPolicyCount_s::policy_id(
        uint32_t _policy_id)
{
    m_policy_id = _policy_id;
}

/*!
 * @brief This function returns the value of member policy_id
 * @return Value of member policy_id
 */
uint32_t QosPolicyCount_s::policy_id() const
{
    return m_policy_id;
}

/*!
 * @brief This function returns a reference to member policy_id
 * @return Reference to member policy_id
 */
uint32_t& QosPolicyCount_s::policy_id()
{
    return m_policy_id;
}


/*!
 * @brief This function sets a value in member count
 * @param _count New value for member count
 */
void QosPolicyCount_s::count(
        uint32_t _count)
{
    m_count = _count;
}

/*!
 * @brief This function returns the value of member count
 * @return Value of member count
 */
uint32_t QosPolicyCount_s::count() const
{
    return m_count;
}

/*!
 * @brief This function returns a reference to member count
 * @return Reference to member count
 */
uint32_t& QosPolicyCount_s::count()
{
    return m_count;
}





BaseStatus_s::BaseStatus_s()
{
    // unsigned long m_total_count
    m_total_count = 0;

}

BaseStatus_s::~BaseStatus_s()
{
}

BaseStatus_s::BaseStatus_s(
        const BaseStatus_s& x)
{
    m_total_count = x.m_total_count;

}

BaseStatus_s::BaseStatus_s(
        BaseStatus_s&& x) noexcept
{
    m_total_count = x.m_total_count;

}

BaseStatus_s& BaseStatus_s::operator =(
        const BaseStatus_s& x)
{
    m_total_count = x.m_total_count;

    return *this;
}

BaseStatus_s& BaseStatus_s::operator =(
        BaseStatus_s&& x) noexcept
{
    m_total_count = x.m_total_count;

    return *this;
}

bool BaseStatus_s::operator ==(
        const BaseStatus_s& x) const
{
    return (m_total_count == x.m_total_count);
}

bool BaseStatus_s::operator !=(
        const BaseStatus_s& x) const
{
    return !(*this == x);
}

size_t BaseStatus_s::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_BaseStatus_s_max_cdr_typesize;
}

size_t BaseStatus_s::getCdrSerializedSize(
        const BaseStatus_s& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    return current_alignment - initial_alignment;
}


void BaseStatus_s::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_total_count;

}

void BaseStatus_s::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    dcdr >> m_total_count;


}


bool BaseStatus_s::isKeyDefined()
{
    return false;
}

void BaseStatus_s::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function sets a value in member total_count
 * @param _total_count New value for member total_count
 */
void BaseStatus_s::total_count(
        uint32_t _total_count)
{
    m_total_count = _total_count;
}

/*!
 * @brief This function returns the value of member total_count
 * @return Value of member total_count
 */
uint32_t BaseStatus_s::total_count() const
{
    return m_total_count;
}

/*!
 * @brief This function returns a reference to member total_count
 * @return Reference to member total_count
 */
uint32_t& BaseStatus_s::total_count()
{
    return m_total_count;
}








IncompatibleQoSStatus_s::IncompatibleQoSStatus_s()
{
    // unsigned long m_total_count
    m_total_count = 0;
    // unsigned long m_last_policy_id
    m_last_policy_id = 0;
    // eprosima::fastdds::statistics::QosPolicyCountSeq_s m_policies


}

IncompatibleQoSStatus_s::~IncompatibleQoSStatus_s()
{
}

IncompatibleQoSStatus_s::IncompatibleQoSStatus_s(
        const IncompatibleQoSStatus_s& x)
{
    m_total_count = x.m_total_count;


    m_last_policy_id = x.m_last_policy_id;


    m_policies = x.m_policies;

}

IncompatibleQoSStatus_s::IncompatibleQoSStatus_s(
        IncompatibleQoSStatus_s&& x) noexcept
{
    m_total_count = x.m_total_count;


    m_last_policy_id = x.m_last_policy_id;


    m_policies = std::move(x.m_policies);

}

IncompatibleQoSStatus_s& IncompatibleQoSStatus_s::operator =(
        const IncompatibleQoSStatus_s& x)
{
    m_total_count = x.m_total_count;


    m_last_policy_id = x.m_last_policy_id;


    m_policies = x.m_policies;

    return *this;
}

IncompatibleQoSStatus_s& IncompatibleQoSStatus_s::operator =(
        IncompatibleQoSStatus_s&& x) noexcept
{
    m_total_count = x.m_total_count;


    m_last_policy_id = x.m_last_policy_id;


    m_policies = std::move(x.m_policies);

    return *this;
}

bool IncompatibleQoSStatus_s::operator ==(
        const IncompatibleQoSStatus_s& x) const
{
    return (m_total_count == x.m_total_count &&
           m_last_policy_id == x.m_last_policy_id &&
           m_policies == x.m_policies);
}

bool IncompatibleQoSStatus_s::operator !=(
        const IncompatibleQoSStatus_s& x) const
{
    return !(*this == x);
}

size_t IncompatibleQoSStatus_s::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_IncompatibleQoSStatus_s_max_cdr_typesize;
}

size_t IncompatibleQoSStatus_s::getCdrSerializedSize(
        const IncompatibleQoSStatus_s& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < data.policies().size(); ++a)
    {
        current_alignment += eprosima::fastdds::statistics::QosPolicyCount_s::getCdrSerializedSize(data.policies().at(a), current_alignment);
    }



    return current_alignment - initial_alignment;
}


void IncompatibleQoSStatus_s::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_total_count;

    scdr << m_last_policy_id;

    scdr << m_policies;


}

void IncompatibleQoSStatus_s::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    dcdr >> m_total_count;



    dcdr >> m_last_policy_id;



    dcdr >> m_policies;


}


bool IncompatibleQoSStatus_s::isKeyDefined()
{
    return false;
}

void IncompatibleQoSStatus_s::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function sets a value in member total_count
 * @param _total_count New value for member total_count
 */
void IncompatibleQoSStatus_s::total_count(
        uint32_t _total_count)
{
    m_total_count = _total_count;
}

/*!
 * @brief This function returns the value of member total_count
 * @return Value of member total_count
 */
uint32_t IncompatibleQoSStatus_s::total_count() const
{
    return m_total_count;
}

/*!
 * @brief This function returns a reference to member total_count
 * @return Reference to member total_count
 */
uint32_t& IncompatibleQoSStatus_s::total_count()
{
    return m_total_count;
}


/*!
 * @brief This function sets a value in member last_policy_id
 * @param _last_policy_id New value for member last_policy_id
 */
void IncompatibleQoSStatus_s::last_policy_id(
        uint32_t _last_policy_id)
{
    m_last_policy_id = _last_policy_id;
}

/*!
 * @brief This function returns the value of member last_policy_id
 * @return Value of member last_policy_id
 */
uint32_t IncompatibleQoSStatus_s::last_policy_id() const
{
    return m_last_policy_id;
}

/*!
 * @brief This function returns a reference to member last_policy_id
 * @return Reference to member last_policy_id
 */
uint32_t& IncompatibleQoSStatus_s::last_policy_id()
{
    return m_last_policy_id;
}


/*!
 * @brief This function copies the value in member policies
 * @param _policies New value to be copied in member policies
 */
void IncompatibleQoSStatus_s::policies(
        const eprosima::fastdds::statistics::QosPolicyCountSeq_s& _policies)
{
    m_policies = _policies;
}

/*!
 * @brief This function moves the value in member policies
 * @param _policies New value to be moved in member policies
 */
void IncompatibleQoSStatus_s::policies(
        eprosima::fastdds::statistics::QosPolicyCountSeq_s&& _policies)
{
    m_policies = std::move(_policies);
}

/*!
 * @brief This function returns a constant reference to member policies
 * @return Constant reference to member policies
 */
const eprosima::fastdds::statistics::QosPolicyCountSeq_s& IncompatibleQoSStatus_s::policies() const
{
    return m_policies;
}

/*!
 * @brief This function returns a reference to member policies
 * @return Reference to member policies
 */
eprosima::fastdds::statistics::QosPolicyCountSeq_s& IncompatibleQoSStatus_s::policies()
{
    return m_policies;
}





LivelinessChangedStatus_s::LivelinessChangedStatus_s()
{
    // unsigned long m_alive_count
    m_alive_count = 0;
    // unsigned long m_not_alive_count
    m_not_alive_count = 0;
    // octet m_last_publication_handle
    memset(&m_last_publication_handle, 0, ((16)) * 1);

}

LivelinessChangedStatus_s::~LivelinessChangedStatus_s()
{
}

LivelinessChangedStatus_s::LivelinessChangedStatus_s(
        const LivelinessChangedStatus_s& x)
{
    m_alive_count = x.m_alive_count;


    m_not_alive_count = x.m_not_alive_count;


    m_last_publication_handle = x.m_last_publication_handle;

}

LivelinessChangedStatus_s::LivelinessChangedStatus_s(
        LivelinessChangedStatus_s&& x) noexcept
{
    m_alive_count = x.m_alive_count;


    m_not_alive_count = x.m_not_alive_count;


    m_last_publication_handle = std::move(x.m_last_publication_handle);

}

LivelinessChangedStatus_s& LivelinessChangedStatus_s::operator =(
        const LivelinessChangedStatus_s& x)
{
    m_alive_count = x.m_alive_count;


    m_not_alive_count = x.m_not_alive_count;


    m_last_publication_handle = x.m_last_publication_handle;

    return *this;
}

LivelinessChangedStatus_s& LivelinessChangedStatus_s::operator =(
        LivelinessChangedStatus_s&& x) noexcept
{
    m_alive_count = x.m_alive_count;


    m_not_alive_count = x.m_not_alive_count;


    m_last_publication_handle = std::move(x.m_last_publication_handle);

    return *this;
}

bool LivelinessChangedStatus_s::operator ==(
        const LivelinessChangedStatus_s& x) const
{
    return (m_alive_count == x.m_alive_count &&
           m_not_alive_count == x.m_not_alive_count &&
           m_last_publication_handle == x.m_last_publication_handle);
}

bool LivelinessChangedStatus_s::operator !=(
        const LivelinessChangedStatus_s& x) const
{
    return !(*this == x);
}

size_t LivelinessChangedStatus_s::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_LivelinessChangedStatus_s_max_cdr_typesize;
}

size_t LivelinessChangedStatus_s::getCdrSerializedSize(
        const LivelinessChangedStatus_s& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += (((16)) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    return current_alignment - initial_alignment;
}


void LivelinessChangedStatus_s::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_alive_count;

    scdr << m_not_alive_count;

    scdr << m_last_publication_handle;


}

void LivelinessChangedStatus_s::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    dcdr >> m_alive_count;



    dcdr >> m_not_alive_count;



    dcdr >> m_last_publication_handle;


}


bool LivelinessChangedStatus_s::isKeyDefined()
{
    return false;
}

void LivelinessChangedStatus_s::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function sets a value in member alive_count
 * @param _alive_count New value for member alive_count
 */
void LivelinessChangedStatus_s::alive_count(
        uint32_t _alive_count)
{
    m_alive_count = _alive_count;
}

/*!
 * @brief This function returns the value of member alive_count
 * @return Value of member alive_count
 */
uint32_t LivelinessChangedStatus_s::alive_count() const
{
    return m_alive_count;
}

/*!
 * @brief This function returns a reference to member alive_count
 * @return Reference to member alive_count
 */
uint32_t& LivelinessChangedStatus_s::alive_count()
{
    return m_alive_count;
}


/*!
 * @brief This function sets a value in member not_alive_count
 * @param _not_alive_count New value for member not_alive_count
 */
void LivelinessChangedStatus_s::not_alive_count(
        uint32_t _not_alive_count)
{
    m_not_alive_count = _not_alive_count;
}

/*!
 * @brief This function returns the value of member not_alive_count
 * @return Value of member not_alive_count
 */
uint32_t LivelinessChangedStatus_s::not_alive_count() const
{
    return m_not_alive_count;
}

/*!
 * @brief This function returns a reference to member not_alive_count
 * @return Reference to member not_alive_count
 */
uint32_t& LivelinessChangedStatus_s::not_alive_count()
{
    return m_not_alive_count;
}


/*!
 * @brief This function copies the value in member last_publication_handle
 * @param _last_publication_handle New value to be copied in member last_publication_handle
 */
void LivelinessChangedStatus_s::last_publication_handle(
        const std::array<uint8_t, 16>& _last_publication_handle)
{
    m_last_publication_handle = _last_publication_handle;
}

/*!
 * @brief This function moves the value in member last_publication_handle
 * @param _last_publication_handle New value to be moved in member last_publication_handle
 */
void LivelinessChangedStatus_s::last_publication_handle(
        std::array<uint8_t, 16>&& _last_publication_handle)
{
    m_last_publication_handle = std::move(_last_publication_handle);
}

/*!
 * @brief This function returns a constant reference to member last_publication_handle
 * @return Constant reference to member last_publication_handle
 */
const std::array<uint8_t, 16>& LivelinessChangedStatus_s::last_publication_handle() const
{
    return m_last_publication_handle;
}

/*!
 * @brief This function returns a reference to member last_publication_handle
 * @return Reference to member last_publication_handle
 */
std::array<uint8_t, 16>& LivelinessChangedStatus_s::last_publication_handle()
{
    return m_last_publication_handle;
}





DeadlineMissedStatus_s::DeadlineMissedStatus_s()
{
    // unsigned long m_total_count
    m_total_count = 0;
    // octet m_last_instance_handle
    memset(&m_last_instance_handle, 0, ((16)) * 1);

}

DeadlineMissedStatus_s::~DeadlineMissedStatus_s()
{
}

DeadlineMissedStatus_s::DeadlineMissedStatus_s(
        const DeadlineMissedStatus_s& x)
{
    m_total_count = x.m_total_count;


    m_last_instance_handle = x.m_last_instance_handle;

}

DeadlineMissedStatus_s::DeadlineMissedStatus_s(
        DeadlineMissedStatus_s&& x) noexcept
{
    m_total_count = x.m_total_count;


    m_last_instance_handle = std::move(x.m_last_instance_handle);

}

DeadlineMissedStatus_s& DeadlineMissedStatus_s::operator =(
        const DeadlineMissedStatus_s& x)
{
    m_total_count = x.m_total_count;


    m_last_instance_handle = x.m_last_instance_handle;

    return *this;
}

DeadlineMissedStatus_s& DeadlineMissedStatus_s::operator =(
        DeadlineMissedStatus_s&& x) noexcept
{
    m_total_count = x.m_total_count;


    m_last_instance_handle = std::move(x.m_last_instance_handle);

    return *this;
}

bool DeadlineMissedStatus_s::operator ==(
        const DeadlineMissedStatus_s& x) const
{
    return (m_total_count == x.m_total_count &&
           m_last_instance_handle == x.m_last_instance_handle);
}

bool DeadlineMissedStatus_s::operator !=(
        const DeadlineMissedStatus_s& x) const
{
    return !(*this == x);
}

size_t DeadlineMissedStatus_s::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_DeadlineMissedStatus_s_max_cdr_typesize;
}

size_t DeadlineMissedStatus_s::getCdrSerializedSize(
        const DeadlineMissedStatus_s& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += (((16)) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    return current_alignment - initial_alignment;
}


void DeadlineMissedStatus_s::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_total_count;

    scdr << m_last_instance_handle;


}

void DeadlineMissedStatus_s::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    dcdr >> m_total_count;



    dcdr >> m_last_instance_handle;


}


bool DeadlineMissedStatus_s::isKeyDefined()
{
    return false;
}

void DeadlineMissedStatus_s::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
}

/*!
 * @brief This function sets a value in member total_count
 * @param _total_count New value for member total_count
 */
void DeadlineMissedStatus_s::total_count(
        uint32_t _total_count)
{
    m_total_count = _total_count;
}

/*!
 * @brief This function returns the value of member total_count
 * @return Value of member total_count
 */
uint32_t DeadlineMissedStatus_s::total_count() const
{
    return m_total_count;
}

/*!
 * @brief This function returns a reference to member total_count
 * @return Reference to member total_count
 */
uint32_t& DeadlineMissedStatus_s::total_count()
{
    return m_total_count;
}


/*!
 * @brief This function copies the value in member last_instance_handle
 * @param _last_instance_handle New value to be copied in member last_instance_handle
 */
void DeadlineMissedStatus_s::last_instance_handle(
        const std::array<uint8_t, 16>& _last_instance_handle)
{
    m_last_instance_handle = _last_instance_handle;
}

/*!
 * @brief This function moves the value in member last_instance_handle
 * @param _last_instance_handle New value to be moved in member last_instance_handle
 */
void DeadlineMissedStatus_s::last_instance_handle(
        std::array<uint8_t, 16>&& _last_instance_handle)
{
    m_last_instance_handle = std::move(_last_instance_handle);
}

/*!
 * @brief This function returns a constant reference to member last_instance_handle
 * @return Constant reference to member last_instance_handle
 */
const std::array<uint8_t, 16>& DeadlineMissedStatus_s::last_instance_handle() const
{
    return m_last_instance_handle;
}

/*!
 * @brief This function returns a reference to member last_instance_handle
 * @return Reference to member last_instance_handle
 */
std::array<uint8_t, 16>& DeadlineMissedStatus_s::last_instance_handle()
{
    return m_last_instance_handle;
}









MonitorServiceData::MonitorServiceData()
{
    m__d = eprosima::fastdds::statistics::PROXY;
    // sequence<octet> m_entity_proxy

    // sequence<eprosima::fastdds::statistics::Connection> m_connection_list

    // eprosima::fastdds::statistics::IncompatibleQoSStatus_s m_incompatible_qos_status

    // eprosima::fastdds::statistics::InconsistentTopicStatus_s m_inconsistent_topic_status

    // eprosima::fastdds::statistics::LivelinessLostStatus_s m_liveliness_lost_status

    // eprosima::fastdds::statistics::LivelinessChangedStatus_s m_liveliness_changed_status

    // eprosima::fastdds::statistics::DeadlineMissedStatus_s m_deadline_missed_status

    // eprosima::fastdds::statistics::SampleLostStatus_s m_sample_lost_status

    // octet m_statuses_size
    m_statuses_size = 0;
}

MonitorServiceData::~MonitorServiceData()
{
}

MonitorServiceData::MonitorServiceData(
        const MonitorServiceData& x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        m_entity_proxy = x.m_entity_proxy;
        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        m_connection_list = x.m_connection_list;
        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        m_incompatible_qos_status = x.m_incompatible_qos_status;
        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        m_inconsistent_topic_status = x.m_inconsistent_topic_status;
        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        m_liveliness_lost_status = x.m_liveliness_lost_status;
        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        m_liveliness_changed_status = x.m_liveliness_changed_status;
        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        m_deadline_missed_status = x.m_deadline_missed_status;
        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        m_sample_lost_status = x.m_sample_lost_status;
        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        m_statuses_size = x.m_statuses_size;
        break;

        default:
        break;
    }
}

MonitorServiceData::MonitorServiceData(
        MonitorServiceData&& x) noexcept
{
    m__d = x.m__d;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        m_entity_proxy = std::move(x.m_entity_proxy);

        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        m_connection_list = std::move(x.m_connection_list);

        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        m_incompatible_qos_status = std::move(x.m_incompatible_qos_status);

        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        m_inconsistent_topic_status = std::move(x.m_inconsistent_topic_status);

        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        m_liveliness_lost_status = std::move(x.m_liveliness_lost_status);

        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        m_liveliness_changed_status = std::move(x.m_liveliness_changed_status);

        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        m_deadline_missed_status = std::move(x.m_deadline_missed_status);

        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        m_sample_lost_status = std::move(x.m_sample_lost_status);

        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        m_statuses_size = x.m_statuses_size;
        break;

        default:
        break;
    }
}

MonitorServiceData& MonitorServiceData::operator =(
        const MonitorServiceData& x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        m_entity_proxy = x.m_entity_proxy;
        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        m_connection_list = x.m_connection_list;
        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        m_incompatible_qos_status = x.m_incompatible_qos_status;
        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        m_inconsistent_topic_status = x.m_inconsistent_topic_status;
        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        m_liveliness_lost_status = x.m_liveliness_lost_status;
        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        m_liveliness_changed_status = x.m_liveliness_changed_status;
        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        m_deadline_missed_status = x.m_deadline_missed_status;
        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        m_sample_lost_status = x.m_sample_lost_status;
        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        m_statuses_size = x.m_statuses_size;
        break;

        default:
        break;
    }

    return *this;
}

MonitorServiceData& MonitorServiceData::operator =(
        MonitorServiceData&& x) noexcept
{
    m__d = x.m__d;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        m_entity_proxy = std::move(x.m_entity_proxy);

        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        m_connection_list = std::move(x.m_connection_list);

        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        m_incompatible_qos_status = std::move(x.m_incompatible_qos_status);

        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        m_inconsistent_topic_status = std::move(x.m_inconsistent_topic_status);

        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        m_liveliness_lost_status = std::move(x.m_liveliness_lost_status);

        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        m_liveliness_changed_status = std::move(x.m_liveliness_changed_status);

        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        m_deadline_missed_status = std::move(x.m_deadline_missed_status);

        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        m_sample_lost_status = std::move(x.m_sample_lost_status);

        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        m_statuses_size = x.m_statuses_size;
        break;

        default:
        break;
    }

    return *this;
}

bool MonitorServiceData::operator ==(
        const MonitorServiceData& x) const
{
    if (m__d != x.m__d)
    {
        return false;
    }

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
            return (m_entity_proxy == x.m_entity_proxy);
            break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
            return (m_connection_list == x.m_connection_list);
            break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
            return (m_incompatible_qos_status == x.m_incompatible_qos_status);
            break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
            return (m_inconsistent_topic_status == x.m_inconsistent_topic_status);
            break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
            return (m_liveliness_lost_status == x.m_liveliness_lost_status);
            break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
            return (m_liveliness_changed_status == x.m_liveliness_changed_status);
            break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
            return (m_deadline_missed_status == x.m_deadline_missed_status);
            break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
            return (m_sample_lost_status == x.m_sample_lost_status);
            break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
            return (m_statuses_size == x.m_statuses_size);
            break;

        default:
        break;
    }
    return false;
}

bool MonitorServiceData::operator !=(
        const MonitorServiceData& x) const
{
    return !(*this == x);
}

void MonitorServiceData::_d(
        eprosima::fastdds::statistics::StatusKind __d)
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        switch(__d)
        {
            case eprosima::fastdds::statistics::PROXY:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        switch(__d)
        {
            case eprosima::fastdds::statistics::CONNECTION_LIST:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        switch(__d)
        {
            case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        switch(__d)
        {
            case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        switch(__d)
        {
            case eprosima::fastdds::statistics::LIVELINESS_LOST:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        switch(__d)
        {
            case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        switch(__d)
        {
            case eprosima::fastdds::statistics::DEADLINE_MISSED:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        switch(__d)
        {
            case eprosima::fastdds::statistics::SAMPLE_LOST:
            b = true;
            break;
            default:
            break;
        }
        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        switch(__d)
        {
            case eprosima::fastdds::statistics::STATUSES_SIZE:
            b = true;
            break;
            default:
            break;
        }
        break;

    }

    if(!b)
    {
        throw BadParamException("Discriminator doesn't correspond with the selected union member");
    }

    m__d = __d;
}

eprosima::fastdds::statistics::StatusKind MonitorServiceData::_d() const
{
    return m__d;
}

eprosima::fastdds::statistics::StatusKind& MonitorServiceData::_d()
{
    return m__d;
}

void MonitorServiceData::entity_proxy(
        const std::vector<uint8_t>& _entity_proxy)
{
    m_entity_proxy = _entity_proxy;
    m__d = eprosima::fastdds::statistics::PROXY;

}

void MonitorServiceData::entity_proxy(
        std::vector<uint8_t>&& _entity_proxy)
{
    m_entity_proxy = std::move(_entity_proxy);
    m__d = eprosima::fastdds::statistics::PROXY;

}

const std::vector<uint8_t>& MonitorServiceData::entity_proxy() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_entity_proxy;
}

std::vector<uint8_t>& MonitorServiceData::entity_proxy()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_entity_proxy;
}


void MonitorServiceData::connection_list(
        const std::vector<eprosima::fastdds::statistics::Connection>& _connection_list)
{
    m_connection_list = _connection_list;
    m__d = eprosima::fastdds::statistics::CONNECTION_LIST;

}

void MonitorServiceData::connection_list(
        std::vector<eprosima::fastdds::statistics::Connection>&& _connection_list)
{
    m_connection_list = std::move(_connection_list);
    m__d = eprosima::fastdds::statistics::CONNECTION_LIST;

}

const std::vector<eprosima::fastdds::statistics::Connection>& MonitorServiceData::connection_list() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::CONNECTION_LIST:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_connection_list;
}

std::vector<eprosima::fastdds::statistics::Connection>& MonitorServiceData::connection_list()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::CONNECTION_LIST:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_connection_list;
}


void MonitorServiceData::incompatible_qos_status(
        const eprosima::fastdds::statistics::IncompatibleQoSStatus_s& _incompatible_qos_status)
{
    m_incompatible_qos_status = _incompatible_qos_status;
    m__d = eprosima::fastdds::statistics::INCOMPATIBLE_QOS;

}

void MonitorServiceData::incompatible_qos_status(
        eprosima::fastdds::statistics::IncompatibleQoSStatus_s&& _incompatible_qos_status)
{
    m_incompatible_qos_status = std::move(_incompatible_qos_status);
    m__d = eprosima::fastdds::statistics::INCOMPATIBLE_QOS;

}

const eprosima::fastdds::statistics::IncompatibleQoSStatus_s& MonitorServiceData::incompatible_qos_status() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_incompatible_qos_status;
}

eprosima::fastdds::statistics::IncompatibleQoSStatus_s& MonitorServiceData::incompatible_qos_status()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_incompatible_qos_status;
}


void MonitorServiceData::inconsistent_topic_status(
        const eprosima::fastdds::statistics::InconsistentTopicStatus_s& _inconsistent_topic_status)
{
    m_inconsistent_topic_status = _inconsistent_topic_status;
    m__d = eprosima::fastdds::statistics::INCONSISTENT_TOPIC;

}

void MonitorServiceData::inconsistent_topic_status(
        eprosima::fastdds::statistics::InconsistentTopicStatus_s&& _inconsistent_topic_status)
{
    m_inconsistent_topic_status = std::move(_inconsistent_topic_status);
    m__d = eprosima::fastdds::statistics::INCONSISTENT_TOPIC;

}

const eprosima::fastdds::statistics::InconsistentTopicStatus_s& MonitorServiceData::inconsistent_topic_status() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_inconsistent_topic_status;
}

eprosima::fastdds::statistics::InconsistentTopicStatus_s& MonitorServiceData::inconsistent_topic_status()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_inconsistent_topic_status;
}


void MonitorServiceData::liveliness_lost_status(
        const eprosima::fastdds::statistics::LivelinessLostStatus_s& _liveliness_lost_status)
{
    m_liveliness_lost_status = _liveliness_lost_status;
    m__d = eprosima::fastdds::statistics::LIVELINESS_LOST;

}

void MonitorServiceData::liveliness_lost_status(
        eprosima::fastdds::statistics::LivelinessLostStatus_s&& _liveliness_lost_status)
{
    m_liveliness_lost_status = std::move(_liveliness_lost_status);
    m__d = eprosima::fastdds::statistics::LIVELINESS_LOST;

}

const eprosima::fastdds::statistics::LivelinessLostStatus_s& MonitorServiceData::liveliness_lost_status() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_liveliness_lost_status;
}

eprosima::fastdds::statistics::LivelinessLostStatus_s& MonitorServiceData::liveliness_lost_status()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_liveliness_lost_status;
}


void MonitorServiceData::liveliness_changed_status(
        const eprosima::fastdds::statistics::LivelinessChangedStatus_s& _liveliness_changed_status)
{
    m_liveliness_changed_status = _liveliness_changed_status;
    m__d = eprosima::fastdds::statistics::LIVELINESS_CHANGED;

}

void MonitorServiceData::liveliness_changed_status(
        eprosima::fastdds::statistics::LivelinessChangedStatus_s&& _liveliness_changed_status)
{
    m_liveliness_changed_status = std::move(_liveliness_changed_status);
    m__d = eprosima::fastdds::statistics::LIVELINESS_CHANGED;

}

const eprosima::fastdds::statistics::LivelinessChangedStatus_s& MonitorServiceData::liveliness_changed_status() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_liveliness_changed_status;
}

eprosima::fastdds::statistics::LivelinessChangedStatus_s& MonitorServiceData::liveliness_changed_status()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_liveliness_changed_status;
}


void MonitorServiceData::deadline_missed_status(
        const eprosima::fastdds::statistics::DeadlineMissedStatus_s& _deadline_missed_status)
{
    m_deadline_missed_status = _deadline_missed_status;
    m__d = eprosima::fastdds::statistics::DEADLINE_MISSED;

}

void MonitorServiceData::deadline_missed_status(
        eprosima::fastdds::statistics::DeadlineMissedStatus_s&& _deadline_missed_status)
{
    m_deadline_missed_status = std::move(_deadline_missed_status);
    m__d = eprosima::fastdds::statistics::DEADLINE_MISSED;

}

const eprosima::fastdds::statistics::DeadlineMissedStatus_s& MonitorServiceData::deadline_missed_status() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_deadline_missed_status;
}

eprosima::fastdds::statistics::DeadlineMissedStatus_s& MonitorServiceData::deadline_missed_status()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_deadline_missed_status;
}


void MonitorServiceData::sample_lost_status(
        const eprosima::fastdds::statistics::SampleLostStatus_s& _sample_lost_status)
{
    m_sample_lost_status = _sample_lost_status;
    m__d = eprosima::fastdds::statistics::SAMPLE_LOST;

}

void MonitorServiceData::sample_lost_status(
        eprosima::fastdds::statistics::SampleLostStatus_s&& _sample_lost_status)
{
    m_sample_lost_status = std::move(_sample_lost_status);
    m__d = eprosima::fastdds::statistics::SAMPLE_LOST;

}

const eprosima::fastdds::statistics::SampleLostStatus_s& MonitorServiceData::sample_lost_status() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::SAMPLE_LOST:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_sample_lost_status;
}

eprosima::fastdds::statistics::SampleLostStatus_s& MonitorServiceData::sample_lost_status()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::SAMPLE_LOST:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_sample_lost_status;
}


void MonitorServiceData::statuses_size(
        uint8_t _statuses_size)
{
    m_statuses_size = _statuses_size;
    m__d = eprosima::fastdds::statistics::STATUSES_SIZE;

}

uint8_t MonitorServiceData::statuses_size() const
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::STATUSES_SIZE:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_statuses_size;
}

uint8_t& MonitorServiceData::statuses_size()
{
    bool b = false;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::STATUSES_SIZE:
        b = true;
        break;
        default:
        break;
    }

    if(!b)
    {
        throw BadParamException("This member has not been selected");
    }

    return m_statuses_size;
}


// TODO(Ricardo) Review
size_t MonitorServiceData::getCdrSerializedSize(
        const MonitorServiceData& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);



    switch(data.m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        if (data.entity_proxy().size() > 0)
        {
            current_alignment += (data.entity_proxy().size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
        }



        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        for(size_t a = 0; a < data.connection_list().size(); ++a)
        {
            current_alignment += eprosima::fastdds::statistics::Connection::getCdrSerializedSize(data.connection_list().at(a), current_alignment);
        }


        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        current_alignment += eprosima::fastdds::statistics::IncompatibleQoSStatus_s::getCdrSerializedSize(data.incompatible_qos_status(), current_alignment);

        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        current_alignment += eprosima::fastdds::statistics::InconsistentTopicStatus_s::getCdrSerializedSize(data.inconsistent_topic_status(), current_alignment);

        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        current_alignment += eprosima::fastdds::statistics::LivelinessLostStatus_s::getCdrSerializedSize(data.liveliness_lost_status(), current_alignment);

        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        current_alignment += eprosima::fastdds::statistics::LivelinessChangedStatus_s::getCdrSerializedSize(data.liveliness_changed_status(), current_alignment);

        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        current_alignment += eprosima::fastdds::statistics::DeadlineMissedStatus_s::getCdrSerializedSize(data.deadline_missed_status(), current_alignment);

        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        current_alignment += eprosima::fastdds::statistics::SampleLostStatus_s::getCdrSerializedSize(data.sample_lost_status(), current_alignment);

        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

        break;

        default:
        break;
    }

    return current_alignment - initial_alignment;
}


void MonitorServiceData::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << (uint32_t)m__d;

    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        scdr << m_entity_proxy;


        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        scdr << m_connection_list;


        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        scdr << m_incompatible_qos_status;

        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        scdr << m_inconsistent_topic_status;

        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        scdr << m_liveliness_lost_status;

        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        scdr << m_liveliness_changed_status;

        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        scdr << m_deadline_missed_status;

        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        scdr << m_sample_lost_status;

        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        scdr << m_statuses_size;

        break;

        default:
        break;
    }
}

void MonitorServiceData::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
    m__d = (eprosima::fastdds::statistics::StatusKind)enum_value;
    }


    switch(m__d)
    {
        case eprosima::fastdds::statistics::PROXY:
        dcdr >> m_entity_proxy;


        break;


        case eprosima::fastdds::statistics::CONNECTION_LIST:
        dcdr >> m_connection_list;


        break;


        case eprosima::fastdds::statistics::INCOMPATIBLE_QOS:
        dcdr >> m_incompatible_qos_status;


        break;


        case eprosima::fastdds::statistics::INCONSISTENT_TOPIC:
        dcdr >> m_inconsistent_topic_status;


        break;


        case eprosima::fastdds::statistics::LIVELINESS_LOST:
        dcdr >> m_liveliness_lost_status;


        break;


        case eprosima::fastdds::statistics::LIVELINESS_CHANGED:
        dcdr >> m_liveliness_changed_status;


        break;


        case eprosima::fastdds::statistics::DEADLINE_MISSED:
        dcdr >> m_deadline_missed_status;


        break;


        case eprosima::fastdds::statistics::SAMPLE_LOST:
        dcdr >> m_sample_lost_status;


        break;


        case eprosima::fastdds::statistics::STATUSES_SIZE:
        dcdr >> m_statuses_size;


        break;

        default:
        break;
    }
}





MonitorServiceStatusData::MonitorServiceStatusData()
{
    // eprosima::fastdds::statistics::detail::GUID_s m_local_entity

    // eprosima::fastdds::statistics::StatusKind m_status_kind
    m_status_kind = eprosima::fastdds::statistics::PROXY;
    // eprosima::fastdds::statistics::MonitorServiceData m_value


}

MonitorServiceStatusData::~MonitorServiceStatusData()
{
}

MonitorServiceStatusData::MonitorServiceStatusData(
        const MonitorServiceStatusData& x)
{
    m_local_entity = x.m_local_entity;


    m_status_kind = x.m_status_kind;


    m_value = x.m_value;

}

MonitorServiceStatusData::MonitorServiceStatusData(
        MonitorServiceStatusData&& x) noexcept
{
    m_local_entity = std::move(x.m_local_entity);


    m_status_kind = x.m_status_kind;


    m_value = std::move(x.m_value);

}

MonitorServiceStatusData& MonitorServiceStatusData::operator =(
        const MonitorServiceStatusData& x)
{
    m_local_entity = x.m_local_entity;


    m_status_kind = x.m_status_kind;


    m_value = x.m_value;

    return *this;
}

MonitorServiceStatusData& MonitorServiceStatusData::operator =(
        MonitorServiceStatusData&& x) noexcept
{
    m_local_entity = std::move(x.m_local_entity);


    m_status_kind = x.m_status_kind;


    m_value = std::move(x.m_value);

    return *this;
}

bool MonitorServiceStatusData::operator ==(
        const MonitorServiceStatusData& x) const
{
    return (m_local_entity == x.m_local_entity &&
           m_status_kind == x.m_status_kind &&
           m_value == x.m_value);
}

bool MonitorServiceStatusData::operator !=(
        const MonitorServiceStatusData& x) const
{
    return !(*this == x);
}

size_t MonitorServiceStatusData::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    static_cast<void>(current_alignment);
    return eprosima_fastdds_statistics_MonitorServiceStatusData_max_cdr_typesize;
}

size_t MonitorServiceStatusData::getCdrSerializedSize(
        const MonitorServiceStatusData& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += eprosima::fastdds::statistics::detail::GUID_s::getCdrSerializedSize(data.local_entity(), current_alignment);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += eprosima::fastdds::statistics::MonitorServiceData::getCdrSerializedSize(data.value(), current_alignment);


    return current_alignment - initial_alignment;
}


void MonitorServiceStatusData::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{
    scdr << m_local_entity;

    scdr << (uint32_t)m_status_kind;

    scdr << m_value;

}

void MonitorServiceStatusData::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{
    dcdr >> m_local_entity;



    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_status_kind = (eprosima::fastdds::statistics::StatusKind)enum_value;
    }



    dcdr >> m_value;


}


bool MonitorServiceStatusData::isKeyDefined()
{
    return true;
}

void MonitorServiceStatusData::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
        m_local_entity.serialize(scdr);    
      
    scdr << (uint32_t)m_status_kind;
       
      
}

/*!
 * @brief This function copies the value in member local_entity
 * @param _local_entity New value to be copied in member local_entity
 */
void MonitorServiceStatusData::local_entity(
        const eprosima::fastdds::statistics::detail::GUID_s& _local_entity)
{
    m_local_entity = _local_entity;
}

/*!
 * @brief This function moves the value in member local_entity
 * @param _local_entity New value to be moved in member local_entity
 */
void MonitorServiceStatusData::local_entity(
        eprosima::fastdds::statistics::detail::GUID_s&& _local_entity)
{
    m_local_entity = std::move(_local_entity);
}

/*!
 * @brief This function returns a constant reference to member local_entity
 * @return Constant reference to member local_entity
 */
const eprosima::fastdds::statistics::detail::GUID_s& MonitorServiceStatusData::local_entity() const
{
    return m_local_entity;
}

/*!
 * @brief This function returns a reference to member local_entity
 * @return Reference to member local_entity
 */
eprosima::fastdds::statistics::detail::GUID_s& MonitorServiceStatusData::local_entity()
{
    return m_local_entity;
}


/*!
 * @brief This function sets a value in member status_kind
 * @param _status_kind New value for member status_kind
 */
void MonitorServiceStatusData::status_kind(
        eprosima::fastdds::statistics::StatusKind _status_kind)
{
    m_status_kind = _status_kind;
}

/*!
 * @brief This function returns the value of member status_kind
 * @return Value of member status_kind
 */
eprosima::fastdds::statistics::StatusKind MonitorServiceStatusData::status_kind() const
{
    return m_status_kind;
}

/*!
 * @brief This function returns a reference to member status_kind
 * @return Reference to member status_kind
 */
eprosima::fastdds::statistics::StatusKind& MonitorServiceStatusData::status_kind()
{
    return m_status_kind;
}


/*!
 * @brief This function copies the value in member value
 * @param _value New value to be copied in member value
 */
void MonitorServiceStatusData::value(
        const eprosima::fastdds::statistics::MonitorServiceData& _value)
{
    m_value = _value;
}

/*!
 * @brief This function moves the value in member value
 * @param _value New value to be moved in member value
 */
void MonitorServiceStatusData::value(
        eprosima::fastdds::statistics::MonitorServiceData&& _value)
{
    m_value = std::move(_value);
}

/*!
 * @brief This function returns a constant reference to member value
 * @return Constant reference to member value
 */
const eprosima::fastdds::statistics::MonitorServiceData& MonitorServiceStatusData::value() const
{
    return m_value;
}

/*!
 * @brief This function returns a reference to member value
 * @return Reference to member value
 */
eprosima::fastdds::statistics::MonitorServiceData& MonitorServiceStatusData::value()
{
    return m_value;
}





} // namespace statistics


} // namespace fastdds


} // namespace eprosima

#endif // FASTCDR_VERSION_MAJOR == 1
