// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file sample.cpp
 * This source file contains the implementation of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace {
char dummy;
}  // namespace
#endif  // _WIN32

#include "sample.h"

#if FASTCDR_VERSION_MAJOR > 1

#include <fastcdr/Cdr.h>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>




sample::sample()
{
}

sample::~sample()
{
}

sample::sample(
        const sample& x)
{
    m_index = x.m_index;
    m_key_value = x.m_key_value;
}

sample::sample(
        sample&& x) noexcept
{
    m_index = x.m_index;
    m_key_value = x.m_key_value;
}

sample& sample::operator =(
        const sample& x)
{

    m_index = x.m_index;
    m_key_value = x.m_key_value;
    return *this;
}

sample& sample::operator =(
        sample&& x) noexcept
{

    m_index = x.m_index;
    m_key_value = x.m_key_value;
    return *this;
}

bool sample::operator ==(
        const sample& x) const
{
    return (m_index == x.m_index &&
           m_key_value == x.m_key_value);
}

bool sample::operator !=(
        const sample& x) const
{
    return !(*this == x);
}

/*!
 * @brief This function sets a value in member index
 * @param _index New value for member index
 */
void sample::index(
        uint8_t _index)
{
    m_index = _index;
}

/*!
 * @brief This function returns the value of member index
 * @return Value of member index
 */
uint8_t sample::index() const
{
    return m_index;
}

/*!
 * @brief This function returns a reference to member index
 * @return Reference to member index
 */
uint8_t& sample::index()
{
    return m_index;
}


/*!
 * @brief This function sets a value in member key_value
 * @param _key_value New value for member key_value
 */
void sample::key_value(
        uint8_t _key_value)
{
    m_key_value = _key_value;
}

/*!
 * @brief This function returns the value of member key_value
 * @return Value of member key_value
 */
uint8_t sample::key_value() const
{
    return m_key_value;
}

/*!
 * @brief This function returns a reference to member key_value
 * @return Reference to member key_value
 */
uint8_t& sample::key_value()
{
    return m_key_value;
}


// Include auxiliary functions like for serializing/deserializing.
#include "sampleCdrAux.ipp"

#endif // FASTCDR_VERSION_MAJOR > 1
