# Pomóż FastAPI - Uzyskaj pomoc

Czy podoba Ci się **FastAPI**?

Czy chciałbyś pomóc FastAPI, jego użytkownikom i autorowi?

Może napotkałeś na trudności z **FastAPI** i potrzebujesz pomocy?

Istnieje kilka bardzo łatwych sposobów, aby pomóc (czasami wystarczy jedno lub dwa kliknięcia).

Istnieje również kilka sposobów uzyskania pomocy.

## Zapisz się do newslettera

Możesz zapisać się do rzadkiego [newslettera o **FastAPI i jego przyjaciołach**](/newsletter/){.internal-link target=_blank}, aby być na bieżąco z:

* Aktualnościami o FastAPI i przyjaciołach 🚀
* Przewodnikami 📝
* Funkcjami ✨
* Przełomowymi zmianami 🚨
* Poradami i sztuczkami ✅

## Śledź FastAPI na Twitterze

<a href="https://twitter.com/fastapi" class="external-link" target="_blank">Śledź @fastapi na **Twitterze**</a> aby być na bieżąco z najnowszymi wiadomościami o **FastAPI**. 🐦

## Dodaj gwiazdkę **FastAPI** na GitHubie

Możesz "dodać gwiazdkę" FastAPI na GitHubie (klikając przycisk gwiazdki w prawym górnym rogu): <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. ⭐️

Dodając gwiazdkę, inni użytkownicy będą mogli łatwiej znaleźć projekt i zobaczyć, że był już przydatny dla innych.

## Obserwuj repozytorium GitHub w poszukiwaniu nowych wydań

Możesz "obserwować" FastAPI na GitHubie (klikając przycisk "obserwuj" w prawym górnym rogu): <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. 👀

Wybierz opcję "Tylko wydania".

Dzięki temu będziesz otrzymywać powiadomienia (na swój adres e-mail) za każdym razem, gdy pojawi się nowe wydanie (nowa wersja) **FastAPI** z poprawkami błędów i nowymi funkcjami.

## Skontaktuj się z autorem

Możesz skontaktować się <a href="https://tiangolo.com" class="external-link" target="_blank">ze mną (Sebastián Ramírez / `tiangolo`)</a>, autorem.

Możesz:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Śledzić mnie na **GitHubie**</a>.
    * Zobacz inne projekty open source, które stworzyłem, a mogą być dla Ciebie pomocne.
    * Śledź mnie, aby dostać powiadomienie, gdy utworzę nowy projekt open source.
* <a href="https://twitter.com/tiangolo" class="external-link" target="_blank">Śledzić mnie na **Twitterze**</a> lub na <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodonie</a>.
    * Napisz mi, w jaki sposób korzystasz z FastAPI (uwielbiam o tym czytać).
    * Dowiedz się, gdy ogłoszę coś nowego lub wypuszczę nowe narzędzia.
    * Możesz także <a href="https://twitter.com/fastapi" class="external-link" target="_blank">śledzić @fastapi na Twitterze</a> (to oddzielne konto).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Nawiąż ze mną kontakt na **Linkedinie**</a>.
    * Dowiedz się, gdy ogłoszę coś nowego lub wypuszczę nowe narzędzia (chociaż częściej korzystam z Twittera 🤷‍♂).
* Czytaj moje posty (lub śledź mnie) na <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> lub na <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Czytaj o innych pomysłach, artykułach i dowiedz się o narzędziach, które stworzyłem.
    * Śledź mnie, by wiedzieć gdy opublikuję coś nowego.

## Napisz tweeta o **FastAPI**

<a href="https://twitter.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/tiangolo/fastapi" class="external-link" target="_blank">Napisz tweeta o **FastAPI**</a> i powiedz czemu Ci się podoba. 🎉

Uwielbiam czytać w jaki sposób **FastAPI** jest używane, co Ci się w nim podobało, w jakim projekcie/firmie go używasz itp.

## Głosuj na FastAPI

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Głosuj na **FastAPI** w Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/" class="external-link" target="_blank">Głosuj na **FastAPI** w AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Powiedz, że używasz **FastAPI** na StackShare</a>.

## Pomagaj innym, odpowiadając na ich pytania na GitHubie

Możesz spróbować pomóc innym, odpowiadając w:

* <a href="https://github.com/tiangolo/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">Dyskusjach na GitHubie</a>
* <a href="https://github.com/tiangolo/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">Problemach na GitHubie</a>

W wielu przypadkach możesz już znać odpowiedź na te pytania. 🤓

Jeśli pomożesz wielu ludziom, możesz zostać oficjalnym [Ekspertem FastAPI](fastapi-people.md#experts){.internal-link target=_blank}. 🎉

Pamiętaj tylko o najważniejszym: bądź życzliwy. Ludzie przychodzą sfrustrowani i w wielu przypadkach nie zadają pytań w najlepszy sposób, ale mimo to postaraj się być dla nich jak najbardziej życzliwy. 🤗

Chciałbym, by społeczność **FastAPI** była życzliwa i przyjazna. Nie akceptuj prześladowania ani braku szacunku wobec innych. Dbajmy o siebie nawzajem.

---

Oto, jak pomóc innym z pytaniami (w dyskusjach lub problemach):

### Zrozum pytanie

* Upewnij się, czy rozumiesz **cel** i przypadek użycia osoby pytającej.

* Następnie sprawdź, czy pytanie (większość to pytania) jest **jasne**.

* W wielu przypadkach zadane pytanie dotyczy rozwiązania wymyślonego przez użytkownika, ale może istnieć **lepsze** rozwiązanie. Jeśli dokładnie zrozumiesz problem i przypadek użycia, być może będziesz mógł zaproponować lepsze **alternatywne rozwiązanie**.

* Jeśli nie rozumiesz pytania, poproś o więcej **szczegółów**.

### Odtwórz problem

W większości przypadków problem wynika z **autorskiego kodu** osoby pytającej.

Często pytający umieszczają tylko fragment kodu, niewystarczający do **odtworzenia problemu**.

* Możesz poprosić ich o dostarczenie <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">minimalnego, odtwarzalnego przykładu</a>, który możesz **skopiować i wkleić** i uruchomić lokalnie, aby zobaczyć ten sam błąd lub zachowanie, które widzą, lub lepiej zrozumieć ich przypadki użycia.

* Jeśli jesteś wyjątkowo pomocny, możesz spróbować **stworzyć taki przykład** samodzielnie, opierając się tylko na opisie problemu. Miej na uwadze, że może to zająć dużo czasu i lepiej może być najpierw poprosić ich o wyjaśnienie problemu.

### Proponuj rozwiązania

* Po zrozumieniu pytania możesz podać im możliwą **odpowiedź**.

* W wielu przypadkach lepiej zrozumieć ich **podstawowy problem lub przypadek użycia**, ponieważ może istnieć lepszy sposób rozwiązania niż to, co próbują zrobić.

### Poproś o zamknięcie

Jeśli odpowiedzą, jest duża szansa, że rozwiązałeś ich problem, gratulacje, **jesteś bohaterem**! 🦸

* Jeśli Twoja odpowiedź rozwiązała problem, możesz poprosić o:

    * W Dyskusjach na GitHubie: oznaczenie komentarza jako **odpowiedź**.
    * W Problemach na GitHubie: **zamknięcie** problemu.

## Obserwuj repozytorium na GitHubie

Możesz "obserwować" FastAPI na GitHubie (klikając przycisk "obserwuj" w prawym górnym rogu): <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. 👀

Jeśli wybierzesz "Obserwuj" zamiast "Tylko wydania", otrzymasz powiadomienia, gdy ktoś utworzy nowy problem lub pytanie. Możesz również określić, że chcesz być powiadamiany tylko o nowych problemach, dyskusjach, PR-ach itp.

Następnie możesz spróbować pomóc rozwiązać te problemy.

## Zadawaj pytania

Możesz <a href="https://github.com/tiangolo/fastapi/discussions/new?category=questions" class="external-link" target="_blank">utworzyć nowe pytanie</a> w repozytorium na GitHubie, na przykład aby:

* Zadać **pytanie** lub zapytać o **problem**.
* Zaproponować nową **funkcję**.

**Uwaga**: jeśli to zrobisz, poproszę Cię również o pomoc innym. 😉

## Przeglądaj Pull Requesty

Możesz pomóc mi w przeglądaniu pull requestów autorstwa innych osób.

Jak wcześniej wspomniałem, postaraj się być jak najbardziej życzliwy. 🤗

---

Oto, co warto mieć na uwadze podczas oceny pull requestu:

### Zrozum problem

* Najpierw upewnij się, że **rozumiesz problem**, który próbuje rozwiązać pull request. Może być osadzony w większym kontekście w GitHubowej dyskusji lub problemie.

* Jest też duża szansa, że pull request nie jest konieczny, ponieważ problem można rozwiązać w **inny sposób**. Wtedy możesz to zasugerować lub o to zapytać.

### Nie martw się stylem

* Nie przejmuj się zbytnio rzeczami takimi jak style wiadomości commitów, przy wcielaniu pull requesta łączę commity i modyfikuję opis sumarycznego commita ręcznie.

* Nie przejmuj się również stylem kodu, automatyczne narzędzia w repozytorium sprawdzają to samodzielnie.

A jeśli istnieje jakaś konkretna potrzeba dotycząca stylu lub spójności, sam poproszę o zmiany lub dodam commity z takimi zmianami.

### Sprawdź kod

* Przeczytaj kod, zastanów się czy ma sens, **uruchom go lokalnie** i potwierdź czy faktycznie rozwiązuje problem.

* Następnie dodaj **komentarz** z informacją o tym, że sprawdziłeś kod, dzięki temu będę miał pewność, że faktycznie go sprawdziłeś.

!!! info
    Niestety, nie mogę ślepo ufać PR-om, nawet jeśli mają kilka zatwierdzeń.

    Kilka razy zdarzyło się, że PR-y miały 3, 5 lub więcej zatwierdzeń (prawdopodobnie dlatego, że opis obiecuje rozwiązanie ważnego problemu), ale gdy sam sprawdziłem danego PR-a, okazał się być zbugowany lub nie rozwiązywał problemu, który rzekomo miał rozwiązywać. 😅

    Dlatego tak ważne jest, abyś faktycznie przeczytał i uruchomił kod oraz napisał w komentarzu, że to zrobiłeś. 🤓

* Jeśli PR można uprościć w jakiś sposób, możesz o to poprosić, ale nie ma potrzeby być zbyt wybrednym, może być wiele subiektywnych punktów widzenia (a ja też będę miał swój 🙈), więc lepiej żebyś skupił się na kluczowych rzeczach.

### Testy

* Pomóż mi sprawdzić, czy PR ma **testy**.

* Sprawdź, czy testy **nie przechodzą** przed PR. 🚨

* Następnie sprawdź, czy testy **przechodzą** po PR. ✅

* Wiele PR-ów nie ma testów, możesz **przypomnieć** im o dodaniu testów, a nawet **zaproponować** samemu jakieś testy. To jedna z rzeczy, które pochłaniają najwięcej czasu i możesz w tym bardzo pomóc.

* Następnie skomentuj również to, czego spróbowałeś, wtedy będę wiedział, że to sprawdziłeś. 🤓

## Utwórz Pull Request

Możesz [wnieść wkład](contributing.md){.internal-link target=_blank} do kodu źródłowego za pomocą Pull Requestu, na przykład:

* Naprawić literówkę, którą znalazłeś w dokumentacji.
* Podzielić się artykułem, filmem lub podcastem, który stworzyłeś lub znalazłeś na temat FastAPI, <a href="https://github.com/tiangolo/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">edytując ten plik</a>.
    * Upewnij się, że dodajesz swój link na początku odpowiedniej sekcji.
* Pomóc w [tłumaczeniu dokumentacji](contributing.md#translations){.internal-link target=_blank} na Twój język.
    * Możesz również pomóc w weryfikacji tłumaczeń stworzonych przez innych.
* Zaproponować nowe sekcje dokumentacji.
* Naprawić istniejący problem/błąd.
    * Upewnij się, że dodajesz testy.
* Dodać nową funkcję.
    * Upewnij się, że dodajesz testy.
    * Upewnij się, że dodajesz dokumentację, jeśli jest to istotne.

## Pomóż w utrzymaniu FastAPI

Pomóż mi utrzymać **FastAPI**! 🤓

Jest wiele pracy do zrobienia, a w większości przypadków **TY** możesz to zrobić.

Główne zadania, które możesz wykonać teraz to:

* [Pomóc innym z pytaniami na GitHubie](#help-others-with-questions-in-github){.internal-link target=_blank} (zobacz sekcję powyżej).
* [Oceniać Pull Requesty](#review-pull-requests){.internal-link target=_blank} (zobacz sekcję powyżej).

Te dwie czynności **zajmują najwięcej czasu**. To główna praca związana z utrzymaniem FastAPI.

Jeśli możesz mi w tym pomóc, **pomożesz mi utrzymać FastAPI** i zapewnisz że będzie **rozwijać się szybciej i lepiej**. 🚀

## Dołącz do czatu

Dołącz do 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">serwera czatu na Discordzie</a> 👥 i spędzaj czas z innymi w społeczności FastAPI.

!!! wskazówka
    Jeśli masz pytania, zadaj je w <a href="https://github.com/tiangolo/fastapi/discussions/new?category=questions" class="external-link" target="_blank">Dyskusjach na GitHubie</a>, jest dużo większa szansa, że otrzymasz pomoc od [Ekspertów FastAPI](fastapi-people.md#experts){.internal-link target=_blank}.

    Używaj czatu tylko do innych ogólnych rozmów.

### Nie zadawaj pytań na czacie

Miej na uwadze, że ponieważ czaty pozwalają na bardziej "swobodną rozmowę", łatwo jest zadawać pytania, które są zbyt ogólne i trudniejsze do odpowiedzi, więc możesz nie otrzymać odpowiedzi.

Na GitHubie szablon poprowadzi Cię do napisania odpowiedniego pytania, dzięki czemu łatwiej uzyskasz dobrą odpowiedź, a nawet rozwiążesz problem samodzielnie, zanim zapytasz. Ponadto na GitHubie mogę się upewnić, że zawsze odpowiadam na wszystko, nawet jeśli zajmuje to trochę czasu. Osobiście nie mogę tego zrobić z systemami czatu. 😅

Rozmów w systemach czatu nie można tak łatwo przeszukiwać, jak na GitHubie, więc pytania i odpowiedzi mogą zaginąć w rozmowie. A tylko te na GitHubie liczą się do zostania [Ekspertem FastAPI](fastapi-people.md#experts){.internal-link target=_blank}, więc najprawdopodobniej otrzymasz więcej uwagi na GitHubie.

Z drugiej strony w systemach czatu są tysiące użytkowników, więc jest duża szansa, że znajdziesz tam kogoś do rozmowy, prawie w każdej chwili. 😄

## Wspieraj autora

Możesz również finansowo wesprzeć autora (mnie) poprzez <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">sponsoring na GitHubie</a>.

Tam możesz postawić mi kawę ☕️ aby podziękować. 😄

Możesz także zostać srebrnym lub złotym sponsorem FastAPI. 🏅🎉

## Wspieraj narzędzia, które napędzają FastAPI

Jak widziałeś w dokumentacji, FastAPI stoi na ramionach gigantów, Starlette i Pydantic.

Możesz również wesprzeć:

* <a href="https://github.com/sponsors/samuelcolvin" class="external-link" target="_blank">Samuel Colvin (Pydantic)</a>
* <a href="https://github.com/sponsors/encode" class="external-link" target="_blank">Encode (Starlette, Uvicorn)</a>

---

Dziękuję! 🚀
