#include "interactor.h"

namespace f3d
{
const std::vector<std::pair<std::string, std::string> >& interactor::getDefaultInteractionsInfo()
{
  // clang-format off
  static const std::vector<std::pair<std::string, std::string> > DefaultInteractionsInfo{
    { "C", "Cycle point/cell data coloring" },
    { "S", "Cycle array to color with" },
    { "Y", "Cycle array component to color with" },
    { "B", "Toggle the scalar bar display" },
    { "V", "Toggle volume rendering" },
    { "I", "Toggle inverse volume opacity" },
    { "O", "Toggle point sprites rendering" },
    { "P", "Toggle translucency support" },
    { "Q", "Toggle ambient occlusion" },
    { "A", "Toggle anti-aliasing" },
    { "T", "Toggle tone mapping" },
    { "E", "Toggle the edges display" },
    { "X", "Toggle the axes display" },
    { "G", "Toggle the grid display" },
    { "N", "Toggle the filename display" },
    { "M", "Toggle the metadata display" },
    { "Z", "Toggle the FPS counter display" },
    { "R", "Toggle raytracing rendering" },
    { "D", "Toggle denoising when raytracing" },
    { "F", "Toggle full screen" },
    { "U", "Toggle blur background" },
    { "K", "Toggle trackball interaction" },
    { "F", "Toggle HDRI ambient lighting" },
    { "J", "Toggle HDRI skybox" },
    { "L", "Increase (+Shift: decrease) lights intensity" },
    { "H", "Toggle cheat sheet display" },
    { "?", "Dump camera state to the terminal" },
    { "1", "Front View camera" },
    { "3", "Left View camera" },
    { "5", "Toggle Orthographic Projection" },
    { "7", "Top View camera" },
    { "9", "Isometric View camera" },
    { "Escape", "Quit" },
    { "Enter", "Reset camera to initial parameters" },
    { "Space", "Play animation if any" },
    { "Left", "Previous file" },
    { "Right", "Next file" },
    { "Up", "Reload current file" },
    { "Down", "Add current file parent directory to the list of files and reload the current file" },
    { "Drop", "Load dropped file, folder or HDRI" }
  };
  // clang-format on

  return DefaultInteractionsInfo;
};
}
