# Installation

## Current release packages (2.3.1)

| Platform | Files |
| -------- | ----- |
| Windows (installer) | [F3D-2.3.1-Windows.exe](https://github.com/f3d-app/f3d/releases/download/v2.3.1/F3D-2.3.1-Windows-x86_64-raytracing.exe) |
| Windows (portable) | [F3D-2.3.1-Windows.zip](https://github.com/f3d-app/f3d/releases/download/v2.3.1/F3D-2.3.1-Windows-x86_64-raytracing.zip) |
| MacOS (Intel) | [F3D-2.3.1-macOS-x86_64.dmg](https://github.com/f3d-app/f3d/releases/download/v2.3.1/F3D-2.3.1-macOS-x86_64-raytracing.dmg) |
| MacOS (Silicon) | [F3D-2.3.1-macOS-arm64.dmg](https://github.com/f3d-app/f3d/releases/download/v2.3.1/F3D-2.3.1-macOS-arm64.dmg) |
| Linux (Debian package) | [F3D-2.3.1-Linux.deb](https://github.com/f3d-app/f3d/releases/download/v2.3.1/F3D-2.3.1-Linux-x86_64-raytracing.deb) |
| Linux (portable) | [F3D-2.3.1-Linux.tar.xz](https://github.com/f3d-app/f3d/releases/download/v2.3.1/F3D-2.3.1-Linux-x86_64-raytracing.tar.xz) |

Note: MacOS package is not signed, see the [troubleshooting](LIMITATIONS_AND_TROUBLESHOOTING.md) section for a workaround if needed.

## Alternatives

You can find other (headless, older, smaller, checksum, RCs) release related packages and files on the [releases page](https://github.com/f3d-app/f3d/releases).
You can also find there the [nightly release](https://github.com/f3d-app/f3d/releases/tag/nightly) to test the development version of F3D.
See the [desktop integration](DESKTOP_INTEGRATION.md) section in order actually integrate the binary release in your desktop.
Alternatively, you can build F3D yourself by following the [build](../dev/BUILD.md) guide.

You can also find packages for the following repositories:

### Windows

- [Scoop](https://scoop.sh/#/apps?q=f3d&s=0&d=1&o=true)

### MacOS

- [Homebrew](https://formulae.brew.sh/formula/f3d)

### Linux

- [Ubuntu](https://packages.ubuntu.com/search?keywords=f3d&searchon=names&exact=1&suite=all&section=all)
- [Debian](https://packages.debian.org/search?keywords=f3d&searchon=names&exact=1&suite=all&section=all)
- [Arch](https://archlinux.org/packages/extra/x86_64/f3d/)
- [NixOS](https://search.nixos.org/packages?query=f3d)
- [openSUSE](https://software.opensuse.org/package/f3d)
- [OpenMandriva](https://github.com/OpenMandrivaAssociation/f3d)
- [Mageia](https://madb.mageia.org/package/show/source/1/application/0/release/cauldron/name/f3d)
- Fedora and others through [openSUSE OBS](https://build.opensuse.org/package/show/home:AndnoVember:F3D/f3d)
- [Guix](https://packages.guix.gnu.org/packages/f3d/)
- [Flathub](https://flathub.org/apps/details/io.github.f3d_app.f3d)

### Other

- [FreeBSD](https://cgit.freebsd.org/ports/tree/graphics/f3d)
- [Spack](https://packages.spack.io/package.html?name=f3d)
- [pypi](https://pypi.org/project/f3d/) (library only)
