# Bindings

## Python

If the python bindings have been generated using the `F3D_BINDINGS_PYTHON` CMake option, the libf3d can be used directly from python.
Make sure to set `PYTHONPATH` to path where the python module is built.
Here is an example showing how to use libf3d python bindings:

```python
import f3d

eng = f3d.Engine(f3d.Window.NATIVE)
eng.options.update({
  "model.scivis.array-name": "Normals",
  "model.scivis.component": 0,
  "ui.bar": True,
  "render.grid.enable": True,
  })

eng.loader.load_geometry("f3d/testing/data/dragon.vtu")
eng.interactor.start()
```

You can see more examples using python bindings in the dedicated example folder [here](https://github.com/f3d-app/f3d/tree/master/examples/libf3d/python).

## Java (experimental)

If the Java bindings have been generated using the `F3D_BINDINGS_JAVA` CMake option, the libf3d can be used directly from Java.
You can import the `f3d.jar` package and use the provided Java classes directly.
Make sure to set `java.library.path` to the path where the JNI library is built.
Here is an example showing how to use libf3d Java bindings:

```java
import app.f3d.F3D.*;

public class F3DExample {
  public static void main(String[] args) {

    Engine.autoloadPlugins();

    // Always use try-with-resources idiom to ensure the native engine is released
    try (Engine engine = new Engine(Window.Type.NATIVE)) {
      Loader loader = engine.getLoader();
      loader.loadGeometry("f3d/testing/data/dragon.vtu");

      engine.getWindow().render();
    }
  }
}
```

## Javascript (experimental)

If the Javascript bindings have been generated by building F3D with webassembly and emscriptem, the libf3d can be used directly from a browser.

```
