if(DEFINED ENV{HOMEBREW})
    set(HOMEBREW "$ENV{HOMEBREW}")
else()
    set(HOMEBREW "$ENV{HOME}/Homebrew")
endif()

if(DEFINED ENV{OSX_DEPLOYMENT_TARGET})
    set(OSX_DEPLOYMENT_TARGET "$ENV{OSX_DEPLOYMENT_TARGET}")
else()
    set(OSX_DEPLOYMENT_TARGET "10.12")
endif()

if(DEFINED ENV{OSX_ARCHITECTURES})
    set(OSX_ARCHITECTURES "$ENV{OSX_ARCHITECTURES}")
else()
    set(OSX_ARCHITECTURES "x86_64")
endif()

if(DEFINED ENV{OSX_SYSROOT})
    set(OSX_SYSROOT "$ENV{OSX_SYSROOT}")
else()
    set(OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX.sdk")
endif()

set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}/opt/qt")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}/opt/openssl")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${HOMEBREW}/opt/gettext")
set(CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH};${OSX_SYSROOT}")

set(CMAKE_C_COMPILER   "clang")
set(CMAKE_CXX_COMPILER "clang++")

set(CMAKE_OSX_SYSROOT "${OSX_SYSROOT}"
    CACHE STRING "CMAKE_OSX_SYSROOT")
set(CMAKE_OSX_ARCHITECTURES "${OSX_ARCHITECTURES}"
    CACHE STRING "CMAKE_OSX_ARCHITECTURES")
set(CMAKE_OSX_DEPLOYMENT_TARGET "${OSX_DEPLOYMENT_TARGET}"
    CACHE STRING "CMAKE_OSX_DEPLOYMENT_TARGET")

set(CMAKE_INSTALL_PREFIX "${HOMEBREW}" CACHE PATH "Installation Prefix")
#set(CMAKE_BUILD_TYPE Release CACHE STRING "Debug|Release|RelWithDebInfo|MinSizeRel")
