/*
 * Decompiled with CFR 0.152.
 */
package dumphd.gui;

import dumphd.core.DumpHD;
import dumphd.gui.MainFrame;
import dumphd.gui.ManagedJob;
import dumphd.gui.SwingWorker;
import dumphd.util.MessagePrinter;
import dumphd.util.Utils;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class Manager {
    public static final int BIG_SPACING = 10;
    public static final int SMALL_SPACING = 5;
    public static final int BORDER_SPACING = 5;
    public static final int LABEL_SPACING = 5;
    public static final Dimension BOX_HORIZONTAL_BIG_SPACING = new Dimension(10, 0);
    public static final Dimension BOX_HORIZONTAL_SMALL_SPACING = new Dimension(5, 0);
    public static final Dimension BOX_VERTICAL_BIG_SPACING = new Dimension(0, 10);
    public static final Dimension BOX_VERTICAL_SMALL_SPACING = new Dimension(0, 5);
    private DumpHD dumpHD = null;
    private MainFrame mainFrame = null;
    private boolean working = false;

    public static URL getResource(String resource) {
        return Manager.class.getResource("/resources/" + resource);
    }

    public static Border createEmptyBorder() {
        return BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }

    public static Border createTitledBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    public static Border createLabelBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 5, 0, 5));
    }

    public static void equalizeLabelButtonHeight(JLabel label, JButton button) {
        Dimension buttonPreferred = button.getPreferredSize();
        Dimension labelPreferred = label.getPreferredSize();
        if (buttonPreferred.height > labelPreferred.height) {
            label.setMinimumSize(new Dimension(32, buttonPreferred.height));
            label.setMaximumSize(new Dimension(Integer.MAX_VALUE, buttonPreferred.height));
            label.setPreferredSize(label.getMinimumSize());
            Dimension buttonDimension = new Dimension(buttonPreferred.width, buttonPreferred.height);
            button.setMinimumSize(buttonDimension);
            button.setMaximumSize(buttonDimension);
            button.setPreferredSize(buttonDimension);
        } else {
            label.setMinimumSize(new Dimension(32, labelPreferred.height));
            label.setMaximumSize(new Dimension(Integer.MAX_VALUE, labelPreferred.height));
            label.setPreferredSize(label.getMinimumSize());
            Dimension buttonDimension = new Dimension(buttonPreferred.width, labelPreferred.height);
            button.setMinimumSize(buttonDimension);
            button.setMaximumSize(buttonDimension);
            button.setPreferredSize(buttonDimension);
        }
    }

    public static void equalizeComponentSize(JComponent component1, JComponent component2) {
        Dimension component1Preferred = component1.getPreferredSize();
        Dimension component2Preferred = component2.getPreferredSize();
        int width = 0;
        int height = 0;
        width = component1Preferred.width > component2Preferred.width ? component1Preferred.width : component2Preferred.width;
        height = component1Preferred.height > component2Preferred.height ? component1Preferred.height : component2Preferred.height;
        Dimension newSize = new Dimension(width, height);
        component1.setMinimumSize(newSize);
        component1.setMaximumSize(newSize);
        component1.setPreferredSize(newSize);
        component2.setMinimumSize(newSize);
        component2.setMaximumSize(newSize);
        component2.setPreferredSize(newSize);
    }

    public Manager() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    System.out.print("Creating GUI... ");
                    Manager.this.mainFrame = new MainFrame(Manager.this);
                    System.out.println("DONE");
                    Manager.this.mainFrame.lock();
                    Manager.this.mainFrame.show();
                }
            });
            MessagePrinter mainFramePrinter = this.mainFrame.getMessagePrinter();
            Utils.setMessagePrinter(this.mainFrame.getMessagePrinter());
            try {
                this.dumpHD = new DumpHD(mainFramePrinter, false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Manager.this.mainFrame.unlock();
                    }
                });
            }
            catch (Exception e) {
                mainFramePrinter.println(e.getMessage());
                mainFramePrinter.println("Critical error: DumpHD could not be created");
            }
        }
        catch (Exception e) {
            System.out.println("\nCritical error occured while creating the GUI: " + e.getMessage());
            System.exit(1);
        }
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public DumpHD getDumpHD() {
        return this.dumpHD;
    }

    public void execute(final ManagedJob workerJob, final ManagedJob eventDispatcherJob) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return workerJob.run(null);
            }

            @Override
            public void finished() {
                Manager.this.working = false;
                eventDispatcherJob.run(this.get());
            }
        };
        this.working = true;
        worker.start();
    }

    public boolean isWorking() {
        return this.working;
    }

    public void exit() {
        if (this.dumpHD != null) {
            this.dumpHD.close();
        }
        this.mainFrame.dispose();
        System.exit(0);
    }
}

