//
// Copyright(C) 2021 by Ryan Krafnick
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// DESCRIPTION:
// DSDA Line Special
//

#ifndef __DSDA_LINE_SPECIAL__
#define __DSDA_LINE_SPECIAL__

typedef enum {
  zi_init_gravity     = 0,
  zi_init_color       = 1,
  zi_init_damage      = 2,
  zi_init_sector_link = 3,

  zi_init_ed_sector    = 253,
  zi_init_ed_line      = 254,
  zi_init_transfer_sky = 255
} zi_staticinit_t;

typedef enum {
  zl_polyobj_start_line                  = 1,
  zl_polyobj_rotate_left                 = 2,
  zl_polyobj_rotate_right                = 3,
  zl_polyobj_move                        = 4,
  zl_polyobj_explicit_line               = 5,
  zl_polyobj_move_times_8                = 6,
  zl_polyobj_door_swing                  = 7,
  zl_polyobj_door_slide                  = 8,
  zl_line_horizon                        = 9,
  zl_door_close                          = 10,
  zl_door_open                           = 11,
  zl_door_raise                          = 12,
  zl_door_locked_raise                   = 13,
  zl_door_animated                       = 14,
  zl_autosave                            = 15,
  zl_transfer_wall_light                 = 16,
  zl_thing_raise                         = 17,
  zl_start_conversation                  = 18,
  zl_thing_stop                          = 19,
  zl_floor_lower_by_value                = 20,
  zl_floor_lower_to_lowest               = 21,
  zl_floor_lower_to_nearest              = 22,
  zl_floor_raise_by_value                = 23,
  zl_floor_raise_to_highest              = 24,
  zl_floor_raise_to_nearest              = 25,
  zl_stairs_build_down                   = 26,
  zl_stairs_build_up                     = 27,
  zl_floor_raise_and_crush               = 28,
  zl_pillar_build                        = 29,
  zl_pillar_open                         = 30,
  zl_stairs_build_down_sync              = 31,
  zl_stairs_build_up_sync                = 32,
  zl_force_field                         = 33,
  zl_clear_force_field                   = 34,
  zl_floor_raise_by_value_times_8        = 35,
  zl_floor_lower_by_value_times_8        = 36,
  zl_floor_move_to_value                 = 37,
  zl_ceiling_waggle                      = 38,
  zl_teleport_zombie_changer             = 39,
  zl_ceiling_lower_by_value              = 40,
  zl_ceiling_raise_by_value              = 41,
  zl_ceiling_crush_and_raise             = 42,
  zl_ceiling_lower_and_crush             = 43,
  zl_ceiling_crush_stop                  = 44,
  zl_ceiling_crush_raise_and_stay        = 45,
  zl_floor_crush_stop                    = 46,
  zl_ceiling_move_to_value               = 47,
  zl_sector_attach_3d_midtex             = 48,
  zl_glass_break                         = 49,
  zl_extra_floor_light_only              = 50,
  zl_sector_set_link                     = 51,
  zl_scroll_wall                         = 52,
  zl_line_set_texture_offset             = 53,
  zl_sector_change_flags                 = 54,
  zl_line_set_blocking                   = 55,
  zl_line_set_texturescale               = 56,
  zl_sector_set_portal                   = 57,
  zl_sector_copy_scroller                = 58,
  zl_polyobj_or_move_to_spot             = 59,
  zl_plat_perpetual_raise                = 60,
  zl_plat_stop                           = 61,
  zl_plat_down_wait_up_stay              = 62,
  zl_plat_down_by_value                  = 63,
  zl_plat_up_wait_down_stay              = 64,
  zl_plat_up_by_value                    = 65,
  zl_floor_lower_instant                 = 66,
  zl_floor_raise_instant                 = 67,
  zl_floor_move_to_value_times_8         = 68,
  zl_ceiling_move_to_value_times_8       = 69,
  zl_teleport                            = 70,
  zl_teleport_no_fog                     = 71,
  zl_thrust_thing                        = 72,
  zl_damage_thing                        = 73,
  zl_teleport_new_map                    = 74,
  zl_teleport_end_game                   = 75,
  zl_teleport_other                      = 76,
  zl_teleport_group                      = 77,
  zl_teleport_in_sector                  = 78,
  zl_thing_set_conversation              = 79,
  zl_acs_execute                         = 80,
  zl_acs_suspend                         = 81,
  zl_acs_terminate                       = 82,
  zl_acs_locked_execute                  = 83,
  zl_acs_execute_with_result             = 84,
  zl_acs_locked_execute_door             = 85,
  zl_polyobj_move_to_spot                = 86,
  zl_polyobj_stop                        = 87,
  zl_polyobj_move_to                     = 88,
  zl_polyobj_or_move_to                  = 89,
  zl_polyobj_or_rotate_left              = 90,
  zl_polyobj_or_rotate_right             = 91,
  zl_polyobj_or_move                     = 92,
  zl_polyobj_or_move_times_8             = 93,
  zl_pillar_build_and_crush              = 94,
  zl_floor_and_ceiling_lower_by_value    = 95,
  zl_floor_and_ceiling_raise_by_value    = 96,
  zl_ceiling_lower_and_crush_dist        = 97,
  zl_sector_set_translucent              = 98,
  zl_floor_raise_and_crushdoom           = 99,
  zl_scroll_texture_left                 = 100,
  zl_scroll_texture_right                = 101,
  zl_scroll_texture_up                   = 102,
  zl_scroll_texture_down                 = 103,
  zl_ceiling_crush_and_raise_silent_dist = 104,
  zl_door_wait_raise                     = 105,
  zl_door_wait_close                     = 106,
  zl_line_set_portal_target              = 107,

  zl_light_force_lightning   = 109,
  zl_light_raise_by_value    = 110,
  zl_light_lower_by_value    = 111,
  zl_light_change_to_value   = 112,
  zl_light_fade              = 113,
  zl_light_glow              = 114,
  zl_light_flicker           = 115,
  zl_light_strobe            = 116,
  zl_light_stop              = 117,
  zl_plane_copy              = 118,
  zl_thing_damage            = 119,
  zl_radius_quake            = 120,
  zl_line_set_identification = 121,

  zl_thing_move = 125,

  zl_thing_set_special        = 127,
  zl_thrust_thing_z           = 128,
  zl_use_puzzle_item          = 129,
  zl_thing_activate           = 130,
  zl_thing_deactivate         = 131,
  zl_thing_remove             = 132,
  zl_thing_destroy            = 133,
  zl_thing_projectile         = 134,
  zl_thing_spawn              = 135,
  zl_thing_projectile_gravity = 136,
  zl_thing_spawn_no_fog       = 137,
  zl_floor_waggle             = 138,
  zl_thing_spawn_facing       = 139,
  zl_sector_change_sound      = 140,

  zl_teleport_no_stop = 154,

  zl_line_set_portal             = 156,
  zl_set_global_fog_parameter    = 157,
  zl_fs_execute                  = 158,
  zl_sector_set_plane_reflection = 159,
  zl_sector_set_3d_floor         = 160,
  zl_sector_set_contents         = 161,

  zl_ceiling_crush_and_raise_dist       = 168,
  zl_generic_crusher2                   = 169,
  zl_sector_set_ceiling_scale2          = 170,
  zl_sector_set_floor_scale2            = 171,
  zl_plat_up_nearest_wait_down_stay     = 172,
  zl_noise_alert                        = 173,
  zl_send_to_communicator               = 174,
  zl_thing_projectile_intercept         = 175,
  zl_thing_change_tid                   = 176,
  zl_thing_hate                         = 177,
  zl_thing_projectile_aimed             = 178,
  zl_change_skill                       = 179,
  zl_thing_set_translation              = 180,
  zl_plane_align                        = 181,
  zl_line_mirror                        = 182,
  zl_line_align_ceiling                 = 183,
  zl_line_align_floor                   = 184,
  zl_sector_set_rotation                = 185,
  zl_sector_set_ceiling_panning         = 186,
  zl_sector_set_floor_panning           = 187,
  zl_sector_set_ceiling_scale           = 188,
  zl_sector_set_floor_scale             = 189,
  zl_static_init                        = 190,
  zl_set_player_property                = 191,
  zl_ceiling_lower_to_highest_floor     = 192,
  zl_ceiling_lower_instant              = 193,
  zl_ceiling_raise_instant              = 194,
  zl_ceiling_crush_raise_and_stay_a     = 195,
  zl_ceiling_crush_and_raise_a          = 196,
  zl_ceiling_crush_and_raise_silent_a   = 197,
  zl_ceiling_raise_by_value_times_8     = 198,
  zl_ceiling_lower_by_value_times_8     = 199,
  zl_generic_floor                      = 200,
  zl_generic_ceiling                    = 201,
  zl_generic_door                       = 202,
  zl_generic_lift                       = 203,
  zl_generic_stairs                     = 204,
  zl_generic_crusher                    = 205,
  zl_plat_down_wait_up_stay_lip         = 206,
  zl_plat_perpetual_raise_lip           = 207,
  zl_translucent_line                   = 208,
  zl_transfer_heights                   = 209,
  zl_transfer_floor_light               = 210,
  zl_transfer_ceiling_light             = 211,
  zl_sector_set_color                   = 212,
  zl_sector_set_fade                    = 213,
  zl_sector_set_damage                  = 214,
  zl_teleport_line                      = 215,
  zl_sector_set_gravity                 = 216,
  zl_stairs_build_up_doom               = 217,
  zl_sector_set_wind                    = 218,
  zl_sector_set_friction                = 219,
  zl_sector_set_current                 = 220,
  zl_scroll_texture_both                = 221,
  zl_scroll_texture_model               = 222,
  zl_scroll_floor                       = 223,
  zl_scroll_ceiling                     = 224,
  zl_scroll_texture_offsets             = 225,
  zl_acs_execute_always                 = 226,
  zl_point_push_set_force               = 227,
  zl_plat_raise_and_stay_tx0            = 228,
  zl_thing_set_goal                     = 229,
  zl_plat_up_by_value_stay_tx           = 230,
  zl_plat_toggle_ceiling                = 231,
  zl_light_strobe_doom                  = 232,
  zl_light_min_neighbor                 = 233,
  zl_light_max_neighbor                 = 234,
  zl_floor_transfer_trigger             = 235,
  zl_floor_transfer_numeric             = 236,
  zl_change_camera                      = 237,
  zl_floor_raise_to_lowest_ceiling      = 238,
  zl_floor_raise_by_value_tx_ty         = 239,
  zl_floor_raise_by_texture             = 240,
  zl_floor_lower_to_lowest_tx_ty        = 241,
  zl_floor_lower_to_highest             = 242,
  zl_exit_normal                        = 243,
  zl_exit_secret                        = 244,
  zl_elevator_raise_to_nearest          = 245,
  zl_elevator_move_to_floor             = 246,
  zl_elevator_lower_to_nearest          = 247,
  zl_heal_thing                         = 248,
  zl_door_close_wait_open               = 249,
  zl_floor_donut                        = 250,
  zl_floor_and_ceiling_lower_raise         = 251,
  zl_ceiling_raise_to_nearest           = 252,
  zl_ceiling_lower_to_lowest            = 253,
  zl_ceiling_lower_to_floor             = 254,
  zl_ceiling_crush_raise_and_stay_sil_a = 255,

  zl_floor_lower_to_highest_ee      = 256,
  zl_floor_raise_to_lowest          = 257,
  zl_floor_lower_to_lowest_ceiling  = 258,
  zl_floor_raise_to_ceiling         = 259,
  zl_floor_to_ceiling_instant       = 260,
  zl_floor_lower_by_texture         = 261,
  zl_ceiling_raise_to_highest       = 262,
  zl_ceiling_to_highest_instant     = 263,
  zl_ceiling_lower_to_nearest       = 264,
  zl_ceiling_raise_to_lowest        = 265,
  zl_ceiling_raise_to_highest_floor = 266,
  zl_ceiling_to_floor_instant       = 267,
  zl_ceiling_raise_by_texture       = 268,
  zl_ceiling_lower_by_texture       = 269,
  zl_stairs_build_down_doom         = 270,
  zl_stairs_build_up_doom_sync      = 271,
  zl_stairs_build_down_doom_sync    = 272,

  zl_stairs_build_up_doom_crush = 273,
  zl_door_animated_close = 274,
  zl_floor_stop = 275,
  zl_ceiling_stop = 276,
  zl_sector_set_floor_glow = 277,
  zl_sector_set_ceiling_glow = 278,
  zl_floor_move_to_value_and_crush = 279,
  zl_ceiling_move_to_value_and_crush = 280,
  zl_line_set_automap_flags = 281,
  zl_line_set_automap_style = 282,
  zl_polyobj_stop_sound = 283,

  zl_linespecial_max
} zl_linespecial_id_t;

#endif
