open System

let RuntimeJsonPathEnvironmentVariableName = "DOTNET_RUNTIME_JSON_PATH"

let printUsage() =
    printfn  "Usage:"
    printfn $"  dotnet fsi {fsi.CommandLineArgs[0]} help"
    printfn $"  dotnet fsi {fsi.CommandLineArgs[0]} <path>"
    printfn  ""
    printfn  "Commands:"
    printfn  "  help    Shows this usage info."
    printfn  ""
    printfn  "Arguments:"
    printfn  "  path    File path of the json file that contains all dotnet runtime"
    printfn  "          identifiers structured as json."
    printfn  ""

let printErrorMessageAndTerminate errorMessage =
    Console.ForegroundColor <- ConsoleColor.Red
    eprintfn errorMessage
    Console.ResetColor()
    printfn  ""
    printUsage()
    Environment.Exit(-1)

let getRuntimeJsonPath() =
    let containsAny array values =
        array
        |> Array.exists (fun x -> Array.contains x values)

    if fsi.CommandLineArgs.Length < 2 then
        printErrorMessageAndTerminate "Too few arguments!"
        String.Empty
    elif (containsAny fsi.CommandLineArgs [|"-h"; "--help"; "help"|]) then
        printUsage()
        Environment.Exit(0)
        String.Empty
    elif fsi.CommandLineArgs.Length > 2 then
        printErrorMessageAndTerminate "Too many arguments!"
        String.Empty
    else
        let path = fsi.CommandLineArgs[1]

        if IO.File.Exists(path) then
            path
        else
            printErrorMessageAndTerminate $"File '{path}' does not exist!"
            String.Empty
