#include "masking.h"

const std::unordered_set<Kmer<MOTIF_LEN>, Kmer<MOTIF_LEN>::Hash> motif_table = {
"FRKYTAFT",
"KYTAFTIP",
"RKYTAFTI",
"PQGWKGSP",
"YTAFTIPS",
"LPQGWKGS",
"VLPQGWKG",
"NVLPQGWK",
"YNVLPQGW",
"RYQYNVLP",
"QYNVLPQG",
"PENPYNTP",
"YQYNVLPQ",
"GPENPYNT",
"DVGDAYFS",
"LDVGDAYF",
"VDFRELNK",
"VQLGIPHP",
"EVQLGIPH",
"IGPENPYN",
"KGSPAIFQ",
"TVLDVGDA",
"WKGSPAIF",
"GWKGSPAI",
"WEVQLGIP",
"QGWKGSPA",
"VLDVGDAY",
"FWEVQLGI",
"TQDFWEVQ",
"QDFWEVQL",
"DFWEVQLG",
"WRKLVDFR",
"KLVDFREL",
"LVDFRELN",
"RKLVDFRE",
"RELNKRTQ",
"QLGIPHPA",
"LGIPHPAG",
"FRELNKRT",
"GDAYFSVP",
"DAYFSVPL",
"LNKRTQDF",
"DFRELNKR",
"ELNKRTQD",
"VGDAYFSV",
"GIPHPAGL",
"VTVLDVGD",
"SVTVLDVG",
"NKRTQDFW",
"KRTQDFWE",
"DDLYVGSD",
"DLYVGSDL",
"KIGPENPY",
"KWRKLVDF",
"LYVGSDLE",
"RTQDFWEV",
"KSVTVLDV",
"PGIRYQYN",
"IRYQYNVL",
"GIRYQYNV",
"YVGSDLEI",
"IPHPAGLK",
"TKWRKLVD",
"TPGIRYQY",
"KHQKEPPF",
"TPDKKHQK",
"PDKKHQKE",
"FAIKKKDS",
"QKEPPFLW",
"KDSTKWRK",
"NETPGIRY",
"AYFSVPLD",
"ETPGIRYQ",
"WMGYELHP",
"STKWRKLV",
"NNETPGIR",
"KEPPFLWM",
"HQKEPPFL",
"KKDSTKWR",
"DKKHQKEP",
"EPPFLWMG",
"SDLEIGQH",
"DLEIGQHR",
"DSTKWRKL",
"PPFLWMGY",
"PFLWMGYE",
"SMTKILEP",
"KKHQKEPP",
"FLWMGYEL",
"PHPAGLKK",
"AIKKKDST",
"MTKILEPF",
"MGYELHPD",
"LWMGYELH",
"TKILEPFR",
"ALLDTGAD",
"VGSDLEIG",
"EALLDTGA",
"LDTGADDT",
"DTGADDTV",
"LLDTGADD",
"QYMDDLYV",
"TTPDKKHQ",
"KKSVTVLD",
"GIGGFIKV",
"GSDLEIGQ",
"IYQYMDDL",
"YQYMDDLY",
"YMDDLYVG",
"SKIGPENP",
"GKISKIGP",
"MDDLYVGS",
"ISKIGPEN",
"TGADDTVL",
"KISKIGPE",
"GADDTVLE",
"NPYNTPVF",
"EMEKEGKI",
"EGKISKIG",
"ENPYNTPV",
"QWPLTEEK",
"PKMIGGIG",
"WPLTEEKI",
"PYNTPVFA",
"YNTPVFAI",
"KKKSVTVL",
"GYELHPDK",
"LKPGMDGP",
"KQWPLTEE",
"TPVNIIGR",
"GPTPVNII",
"PTPVNIIG",
"HPAGLKKK",
"LTEEKIKA",
"PLTEEKIK",
"NTPVFAIK",
"TEEKIKAL",
"PVNIIGRN",
"KPKMIGGI",
"WKPKMIGG",
"TPVFAIKK",
"PVFAIKKK",
"VKQWPLTE",
"YELHPDKW",
"ELHPDKWT",
"GSPAIFQS",
"SPAIFQSS",
"PAIFQSSM",
"WGFTTPDK",
"GFTTPDKK",
"VIYQYMDD",
"FTTPDKKH",
"VFAIKKKD",
"MEKEGKIS",
"EKEGKISK",
"LHPDKWTV",
"IGGFIKVR",
"KEGKISKI",
"GGFIKVRQ",
"GFIKVRQY",
"KVKQWPLT",
"HPDKWTVQ",
"AIFQSSMT",
"GCTLNFPI",
"PKVKQWPL",
"CTLNFPIS",
"KEALLDTG",
"KPGMDGPK",
"KLKPGMDG",
"GPKVKQWP",
"VKLKPGMD",
"PVKLKPGM",
"DGPKVKQW",
"MDGPKVKQ",
"PGMDGPKV",
"GMDGPKVK",
"TLNFPISP",
"VPVKLKPG",
"TVPVKLKP",
"LNFPISPI",
"TVLVGPTP",
"FQSSMTKI",
"QSSMTKIL",
"GTVLVGPT",
"IFQSSMTK",
"PDKWTVQP",
"QITLWQRP",
"LVGPTPVN",
"VLVGPTPV",
"PQITLWQR",
"VGPTPVNI",
"TAFTIPSI",
"AFTIPSIN",
"FIKVRQYD",
"FTIPSINN",
"DFRKYTAF",
"ISPIETVP",
"SPIETVPV",
"PISPIETV",
"TLWQRPLV",
"SSMTKILE",
"DKWTVQPI",
"ETVPVKLK",
"IETVPVKL",
"IKVRQYDQ",
"TIPSINNE",
"PIETVPVK",
"PSINNETP",
"SINNETPG",
"IPSINNET",
"IGTVLVGP",
"IVIYQYMD",
"KILEPFRK",
"ILEPFRKQ",
"NFPISPIE",
"FPISPIET",
"LEPFRKQN",
"EPFRKQNP",
"ITLWQRPL",
"AIGTVLVG",
"TEMEKEGK",
"LKEALLDT",
"CTEMEKEG",
"QLKEALLD",
"NIIGRNLL",
"IIGRNLLT",
"GQLKEALL",
"IGRNLLTQ",
"INNETPGI",
"VNIIGRNL",
"QTNLLALN",
"IYTSGSTG",
"TQIGCTLN",
"QIGCTLNF",
"LTQIGCTL",
"SHELRTPL",
"KVRQYDQI",
"ADDTVLEE",
"LWQRPLVT",
"KAIGTVLV",
"GKWKPKMI",
"KWKPKMIG",
"YFSVPLDE",
"GGQLKEAL",
"LPGKWKPK",
"ICTEMEKE",
"GTGLGLAI",
"HRTKIEEL",
"PGKWKPKM",
"RTKIEELR",
"IEAARAGE",
"PFRKQNPD",
"YFSVPLDK",
"EICTEMEK",
"EELRQHLL",
"LEIGQHRT",
"QHRTKIEE",
"EIGQHRTK",
"PDIVIYQY",
"GRGFAVVA",
"NPDIVIYQ",
"IEELRQHL",
"TQLGCTLN",
"KIEELRQH",
"QLGCTLNF",
"DDFGTGYS",
"EEKIKALT",
"IGCTLNFP",
"MSHEIRTP",
"LTQLGCTL",
"IGQHRTKI",
"LEIGQHRA",
"ADDTVLED",
"EIGQHRAK",
"AYVIYTSG",
"NLPGKWKP",
"WTVNDIQK",
"GQHRTKIE",
"SWTVNDIQ",
"FRKQNPDI",
"TVNDIQKL",
"DFGTGYSS",
"VNDIQKLV",
"HRAKIEEL",
"NDIQKLVG",
"RAKIEELR",
"IGGQLKEA",
"VIYTSGST",
"QNPDIVIY",
"YVIYTSGS",
"DIQKLVGK",
"NPYNTPIF",
"PYNTPIFA",
"IQKLVGKL",
"YNTPIFAI",
"QKLVGKLN",
"FLANMSHE",
"QHRAKIEE",
"LGCTLNFP",
"KLVGKLNW",
"NIIGRNML",
"LVGKLNWA",
"LALNAAIE",
"DIVIYQYM",
"IIGRNMLT",
"ENPYNTPI",
"GKLNWASQ",
"IGRNMLTQ",
"NTPIFAIK",
"VGKLNWAS",
"KLNWASQI",
"RIELGEIE",
"IGQHRAKI",
"FGTGYSSL",
"LNWASQIY",
"GTGLGLSI",
"DSWTVNDI",
"KQNPDIVI",
"LPGRWKPK",
"RKQNPDIV",
"WQRPLVTI",
"PIFAIKKK",
"TPIFAIKK",
"GRWKPKMI",
"KWGFTTPD",
"LLKWGFTT",
"LKWGFTTP",
"KDSWTVND",
"RWKPKMIG",
"HLLKWGFT",
"GQHRAKIE",
"TAFTIPST",
"AFTIPSTN",
"FTIPSTNN",
"LPEKDSWT",
"IKALVEIC",
"KIKALVEI",
"EKIKALVE",
"NGAGKSTL",
"PEKDSWTV",
"PGRWKPKM",
"TSGSTGRP",
"EEKIKALV",
"SGSTGRPK",
"KIGGQLKE",
"ALVEICTE",
"LLTQIGCT",
"VNIIGRNM",
"NLLTQIGC",
"KALVEICT",
"DTACSSSL",
"RNLLTQIG",
"GRNLLTQI",
"TIPSTNNE",
"GWTVYPPL",
"TGWTVYPP",
"GTGWTVYP",
"GHKAIGTV",
"IKALTEIC",
"HKAIGTVL",
"ICGHKAIG",
"QRPLVTIK",
"EKDSWTVN",
"KIKALTEI",
"GSTGRPKG",
"IFSLHLAG",
"EKIKALTE",
"PSTNNETP",
"EDFRKYTA",
"STNNETPG",
"IFAIKKKD",
"IPSTNNET",
"KDFRKYTA",
"CGHKAIGT",
"GFAVVADE",
"DKDFRKYT",
"PLDKDFRK",
"LDKDFRKY",
"TACSSSLV",
"SGSGKSTL",
"EICGHKAI",
"INLPGKWK",
"TKIEELRQ",
"LGGHSLLA",
"GSGKSTLL",
"LVEICTEM",
"VEICTEME",
"ICGKKAIG",
"SVPLDKDF",
"VPLDKDFR",
"FSVPLDKD",
"SHEIRTPM",
"EICGKKAI",
"IEICGKKA",
"PEIVIYQY",
"NMSHEIRT",
"LSGGQRQR",
"NPEIVIYQ",
"KKAIGTVL",
"DDTVLEEM",
"GKKAIGTV",
"APDMAFPR",
"ACSSSLVA",
"GKGFAVVA",
"STGRPKGV",
"DDTVLEDI",
"ARLGGDEF",
"GAPDMAFP",
"RMNNMSFW",
"FAVVADEV",
"PRMNNMSF",
"IEICGHKA",
"TNNETPGI",
"LSGGQKQR",
"GPNGAGKT",
"HEIRTPMN",
"FPRMNNMS",
"MAFPRMNN",
"CGKKAIGT",
"DMAFPRMN",
"HRDLKPEN",
"NNMSFWLL",
"GAGTGWTV",
"QYVDDLYV",
"ANMSHEIR",
"HELRTPLN",
"VTIKIGGQ",
"AFPRMNNM",
"IEELREHL",
"AGTGWTVY",
"WTVQPIVL",
"MSFWLLPP",
"PDMAFPRM",
"NMSFWLLP",
"KIEELREH",
"MIFFMVMP",
"VEAHGTGT",
"RWGFTTPD",
"LLRWGFTT",
"LRWGFTTP",
"HLLRWGFT",
"LAYVIYTS",
"KWTVQPIV",
"GFRIELGE",
"AVVADEVR",
"TVQPIVLP",
"RGFRIELG",
"QVKIRGFR",
"LANMSHEI",
"IGGFGNWL",
"SFWLLPPS",
"LLTQLGCT",
"PNGAGKTT",
"GAGKSTLL",
"RPLVTIKI",
"QLCKLLRG",
"IKIGGQLK",
"GRNLLTQL",
"DEATSALD",
"RNLLTQLG",
"NLLTQLGC",
"MNNMSFWL",
"IYQYVDDL",
"MSHELRTP",
"RGFAVVAD",
"IFFMVMPI",
"EIVIYQYM",
"TIKIGGQL",
"GSGKTTLL",
"YTSGSTGR",
"EFRKYTAF",
"LRQHLLRW",
"RMYRTGDL",
"RQHLLRWG",
"PLVTIKIG",
"FEPFFTTK",
"ELRQHLLR",
"VDTACSSS",
"HELRTPLT",
"NGAGKTTL",
"LVTIKIGG",
"QIPIEICG",
"YQYVDDLY",
"KIRGFRIE",
"MIGGFGNW",
"WTVYPPLS",
"TVLEDINL",
"IDDFGTGY",
"GSPAIFQC",
"DTVLEDIN",
"SPAIFQCS",
"PAIFQCSM",
"ITMLLTDR",
"GKITKIGP",
"AIFQCSMT",
"GFGNWLVP",
"IFQCSMTK",
"GPNGAGKS",
"EGKITKIG",
"GGFGNWLV",
"LGPNGAGK",
"AIFSLHLA",
"FQCSMTKI",
"QCSMTKIL",
"LEDINLPG",
"GNWLVPLM",
"YVDDLYVG",
"VDDLYVGS",
"FRIELGEI",
"DLAIFSLH",
"PIEICGHK",
"VLEDINLP",
"TMLLTDRN",
"VDLAIFSL",
"FGNWLVPL",
"FFMVMPIM",
"MEKEGKIT",
"EELRAHLL",
"SVDLAIFS",
"SGSTGKPK",
"TSGSTGKP",
"EKEGKITK",
"KEGKITKI",
"SFRKYTAF",
"AGISSILG",
"TKIGPENP",
"VKIRGFRI",
"NLPGRWKP",
"FSLHLAGI",
"LAIFSLHL",
"ITKIGPEN",
"LHLAGISS",
"SLHLAGIS",
"KITKIGPE",
"HLAGISSI",
"GISSILGA",
"DPQQRLLL",
"FTLIELLV",
"MLTQIGCT",
"LAGISSIL",
"NMLTQIGC",
"RNMLTQIG",
"KAGGAYVP",
"SHEIRTPL",
"GRNMLTQI",
"ESFRKYTA",
"LSLPVLAG",
"DDTVLEEI",
"LDEATSAL",
"GAGKTTLL",
"FFELGGHS",
"GSTGKPKG",
"VRQYDQIL",
"TVLIGPTP",
"PIMIGGFG",
"IMIGGFGN",
"CSMTKILE",
"VMPIMIGG",
"DINLPGKW",
"MPIMIGGF",
"EDINLPGK",
"QRVAIARA",
"QILIEICG",
"MVMPIMIG",
"PQQRLLLE",
"VSHELRTP",
"VIYQYVDD",
"GTVLIGPT",
"FMVMPIMI",
"LIGPTPVN",
"NGSGKSTL",
"YRTGDLVR",
"TLIELLVV",
"SLPVLAGA",
"YDQIPIEI",
"VLIGPTPV",
"WTVQPIQL",
"FELGGHSL",
"YDQILIEI",
"PVLAGAIT",
"QYDQILIE",
"IGPTPVNI",
"LPVLAGAI",
"QYDQIPIE",
"NWASQIYP",
"IEELRAHL",
"KWTVQPIQ",
"QNYPNPFN",
"HRDIKPEN",
"WASQIYPG",
"PNGAGKST",
"KIEELRAH",
"VRQYDQIP",
"TVQPIQLP",
"VLAGAITM",
"PLDESFRK",
"LDESFRKY",
"GTGYSSLS",
"DESFRKYT",
"CQGDSGGP",
"LRQHLLKW",
"DQILIEIC",
"RQHLLKWG",
"QHLLRWGF",
"VDLAGSER",
"ASQIYPGI",
"DQIPIEIC",
"EQTNLLAL",
"TVLEEMNL",
"DLKPENIL",
"AARAGEQG",
"EAARAGEQ",
"LREHLLKW",
"FDPFFTTK",
"REHLLKWG",
"DTVLEEMN",
"LAGAITML",
"PLDEDFRK",
"LVDLAGSE",
"DEDFRKYT",
"LDEDFRKY",
"ELRQHLLK",
"MLGAPDMA",
"LGAPDMAF",
"AGAITMLL",
"KEFRKYTA",
"DKEFRKYT",
"SVPLDESF",
"LDKEFRKY",
"PLDKEFRK",
"LEEMNLPG",
"VPLDESFR",
"LDDFGTGY",
"IYTSGTTG",
"FSVPLDES",
"RLYRTGDL",
"YRTGDLAR",
"LMLGAPDM",
"VLEEMNLP",
"IELGEIEA",
"TVYPPLSS",
"LSGGQQQR",
"WPGNVREL",
"QGRGFAVV",
"FGISPREA",
"LKAGGAYV",
"PLMLGAPD",
"ELREHLLK",
"DEPTNHLD",
"GFTLIELL",
"GIKVKQLC",
"MLTQLGCT",
"ELELAENR",
"NMLTQLGC",
"ELAENREI",
"SILGAINF",
"RNMLTQLG",
"LELAENRE",
"WGLTTPDK",
"GRNMLTQL",
"AKIEELRE",
"SSILGAIN",
"SGSGKTTL",
"DEMGLGKT",
"GLTTPDKK",
"MLLTDRNL",
"LAENREIL",
"SQIYPGIK",
"GIAHDFNN",
"ILGAINFI",
"SGSTGTPK",
"AGEQGRGF",
"MDPQQRLL",
"LLTDRNLN",
"CSSSLVAL",
"RAGEQGRG",
"SVPLDKEF",
"GAITMLLT",
"VQPIVLPE",
"VPLDKEFR",
"ARAGEQGR",
"FSVPLDKE",
"GPNGSGKS",
"YTSGSTGK",
"WQRPLVTV",
"DEPTSGLD",
"RQYDQIPI",
"LTTPDKKH",
"ILIEICGK",
"AITMLLTD",
"LDEPTNHL",
"HEIRTPLN",
"NLLSNAIK",
"GSGLGLAI",
"NWLVPLML",
"LTDRNLNT",
"QPIVLPEK",
"GEQGRGFA",
"RQYDQILI",
"PSGSGKST",
"TGLGLAIS",
"EQGRGFAV",
"VIVTAHAF",
"NQDGASNG",
"QIYPGIKV",
"NGAGKTTT",
"STGKPKGV",
"DGASNGLT",
"IVHRDLKP",
"FVNTLVLR",
"IRGFRIEL",
"FITTIINM",
"IPIEICGH",
"GASNGLTA",
"NVIVTAHA",
"ASNGLTAP",
"YGQTGSGK",
"GGHSLLAT",
"TVDTACSS",
"FWLLPPSL",
"NDILDFSK",
"SVPLDEDF",
"QGDSGGPL",
"SSSLVALH",
"VPLDEDFR",
"VGESGSGK",
"YNVIVTAH",
"IGGFIKVK",
"RDLKPENI",
"FFGISPRE",
"LVPLMLGA",
"PFRKQNPE",
"FSVPLDED",
"GAINFITT",
"WLVPLMLG",
"GGFIKVKQ",
"VPLMLGAP",
"AGKGFAVV",
"GFIKVKQY",
"SWGFTTPD",
"LRAHLLSW",
"DNFFELGG",
"RAHLLSWG",
"AGGAYVPL",
"GGAYVPLD",
"ELLVVIAI",
"VEAARAGE",
"GGIAHDFN",
"LGDPIEAQ",
"GDPIEAQA",
"LGAINFIT",
"HRDLKPSN",
"QDGASNGL",
"EFLANMSH",
"PIVLPEKD",
"GSTGTPKG",
"ILKAGGAY",
"ELGGHSLL",
"IVIYQYVD",
"ELRAHLLS",
"VARLGGDE",
"GQTGSGKT",
"AENREILK",
"QHLLKWGF",
"LLSWGFTT",
"SNGLTAPN",
"SGGQQQRV",
"LSWGFTTP",
"IFEPFFTT",
"HLLSWGFT",
"RLGGDEFA",
"ARYGGEEF",
"KQLCKLLR",
"SGGQRQRV",
"TGYSSLSY",
"QIYNVIVT",
"HRDLKPAN",
"DQIYNVIV",
"IGPNGAGK",
"ADEMGLGK",
"MNLPGRWK",
"IYNVIVTA",
"DTVLEEIN",
"TVLEEINL",
"NGLTAPNG",
"YGPPGTGK",
"KVKQLCKL",
"IKVKQLCK",
"NWASQIYA",
"VKQLCKLL",
"DVYSFGVV",
"RVAIARAL",
"WASQIYAG",
"IVLPEKDS",
"AARAGEHG",
"LYGLKQAP",
"EAARAGEH",
"ILDFSKIE",
"NMSHELRT",
"VLPEKDSW",
"SDVYSFGV",
"SGAGKSTL",
"AHDFNNLL",
"DLEIEQHR",
"AEQTNLLA",
"LALNAAVE",
"SDLEIEQH",
"ELRTPLNA",
"ASQIYAGI",
"AGRGFAVV",
"HRDIKPAN",
"PVHGVYYD",
"KSDVYSFG",
"QVKIRGYR",
"EIRTPMNG",
"VGSDLEIE",
"QNPEIVIY",
"GPSGSGKT",
"EHLLKWGF",
"LIEICGKK",
"IGTVLIGP",
"HAFIMIFF",
"LEEINLPG",
"AMDPQQRL",
"GLTAPNGP",
"VLEEINLP",
"DILDFSKI",
"GDSGGPLV",
"SGCGKSTL",
"AYGQTGSG",
"RAGVSSFG",
"DPIEAQAL",
"GSAVNQDG",
"AIDDFGTG",
"GAYVPLDP",
"KGTGLGLS",
"GDDQIYNV",
"VHGVYYDP",
"LADEMGLG",
"SGGQRQRI",
"SGGQKQRI",
"WTVQPIEL",
"GPSGCGKS",
"LDFSKIEA",
"GTLFLDEI",
"TGLGLAIV",
"GLGLAIVK",
"GSDLEIEQ",
"NKSVTVLD",
"NLYGPTEA",
"GESGTGKE",
"SQIYAGIK",
"AVNQDGAS",
"NGAGTGWT",
"SILGAVNF",
"SSILGAVN",
"TVQPIELP",
"IFDPFFTT",
"PPGTGKTL",
"KILEPFRA",
"QGPPGTGK",
"IKEALLDT",
"ILGAVNFI",
"ANMSHELR",
"LPLTPNGK",
"ALDDFGTG",
"IAHRLSTI",
"DDQVKIRG",
"ENGAGTGW",
"MYRTGDLV",
"DQTNLLAL",
"QIKEALLD",
"FFDPAGGG",
"LDEPTSGL",
"NGSGKTTL",
"IELLVVIA",
"FIKVKQYD",
"AHLLSWGF",
"GFFVNTLV",
"GCGKSTLL",
"IFTSGSTG",
"VENGAGTG",
"HRDIKPSN",
"AFTIPSVN",
"TAFTIPSV",
"DDQIYNVI",
"FTIPSVNN",
"AHAFIMIF",
"YGLKQAPR",
"GQIKEALL",
"IAEQTNLL",
"DEPTSALD",
"DDTVLEDM",
"SEFLANMS",
"LLGPNGAG",
"LRGAKALT",
"KSEFLANM",
"INPGNSGG",
"LLRGAKAL",
"LLLDEPTN",
"GPSGCGKT",
"IIHRDLKP",
"LCKLLRGT",
"NFRKYTAF",
"ENREILKE",
"STGTPKGV",
"GYRIELGE",
"TAHAFIMI",
"QIYAGIKV",
"AINFITTI",
"INDILDFS",
"LSGGERQR",
"EMNLPGRW",
"CKLLRGTK",
"VTAHAFIM",
"QRPLVTVK",
"EEMNLPGR",
"RRAGVSSF",
"KALYGLKQ",
"EIRTPMNA",
"TAPNGPSQ",
"HRDLAARN",
"RLGGDEFV",
"SGGQKQRV",
"AGEAGKGF",
"VNQDGASN",
"KIRGYRIE",
"TGSGKTLA",
"GASVDLAI",
"HAFVMIFF",
"LCKLLRGA",
"CKLLRGAK",
"LLRGTKAL",
"LRGTKALT",
"NLLSNAVK",
"ASVDLAIF",
"VADEVRKL",
"NREILKEP",
"DDMGLGKT",
"GSPAIFQA",
"QRVALARA",
"ARGYLNRP",
"DILVNNAG",
"REILKEPV",
"LANMSHEL",
"TIPSVNNE",
"KARLVAKG",
"LALNATIE",
"YGPTETTV",
"SPAIFQAS",
"GHTQAAAG",
"PAIFQASM",
"TGLGLSIS",
"FDKTGTLT",
"GSGKSTLA",
"MPFGLTNA",
"KPGMDGPR",
"IGDDQIYN",
"VVADEVRK",
"ALYGLKQA",
"KNKSVTVL",
"AFVMIFFM",
"FDPAGGGD",
"AHAFVMIF",
"LTAPNGPS",
"SPIDTVPV",
"ILADEMGL",
"EILKEPVH",
"GGTLFLDE",
"ILKEPVHG",
"GFAVVASE",
"FQASMTKI",
"DFSKIEAG",
"QASMTKIL",
"IFQASMTK",
"ISPIDTVP",
"EPVHGVYY",
"PIEAQALL",
"LNATIEAA",
"GPSGAGKS",
"PISPIDTV",
"TAHAFVMI",
"VMPFGLTN",
"PSVNNETP",
"LRTPLNAI",
"IVTAHAFI",
"SVNNETPG",
"RVKQWPLT",
"HGVYYDPS",
"SAVNQDGA",
"RGSAVNQD",
"KNPEIVIY",
"LLLDEATS",
"PSGCGKST",
"WDTAGQER",
"RGYRIELG",
"IPSVNNET",
"ALNATIEA",
"PLTEEAEL",
"KVRQYDQV", // alt
/*"SVLACYNG",
"FSVLACYN",
"CYNGSPSG",
"YNGSPSGV",
"TFSVLACY",
"VLACYNGS",
"LACYNGSP",
"ACYNGSPS",
"NGSPSGVY",
"GSPSGVYQ",
"MTARTVYD",
"ILTSLLVL",
"GQTFSVLA",
"QTFSVLAC",
"ILMTARTV",
"LMTARTVY",
"LILMTART",
"PGQTFSVL",
"QPGQTFSV",
"LLILMTAR",
"VLLILMTA",
"SPSGVYQC",
"PSGVYQCA",
"SGVYQCAM",
"HEIAWYTE",
"EIAWYTER",
"IAWYTERS",
"EHEIAWYT",
"TARTVYDD",
"AWYTERSE",
"NEKQEILG",
"ARTVYDDG",
"EKQEILGT",
"GVYQCAMR",
"SNEKQEIL",
"ISNEKQEI",
"KQEILGTV",
"IISNEKQE",
"QEILGTVS",
"EILGTVSW",
"AFLCLFLL",
"SIISNEKQ",
"FLCLFLLP",
"LCLFLLPS",
"RTVYDDGA",
"PSIISNEK",
"ILPSIISN",
"YILPSIIS",
"LPSIISNE",
"HAFLCLFL",
"ILGTVSWN",
"VMYASAVV",
"FGDSVEEV",
"CLFLLPSL",
"LFLLPSLA",
"TVYDDGAR",
"LTSLLVLV",
"ASAVVLLI",
"SEKSYELQ",
"YASAVVLL",
"TERSEKSY",
"KHAFLCLF",
"RSEKSYEL",
"LGTVSWNL",
"HKHAFLCL",
"ERSEKSYE",
"MYASAVVL",
"GFGDSVEE",
"VVLLILMT",
"YTERSEKS",
"GDSVEEVL",
"AVVLLILM",
"WYTERSEK",
"DSVEEVLS",
"SLLVLVQS",
"TSLLVLVQ",
"CVMYASAV",
"SAVVLLIL",
"LLVLVQST",
"LVLVQSTQ",
"LKDCVMYA",
"RGFGDSVE",
"KLKDCVMY",
"DCVMYASA",
"KHKHAFLC",
"KDCVMYAS",
"VLVQSTQW",
"QSTQWSLF",
"LVQSTQWS",
"VKHKHAFL",
"FVKHKHAF",
"GTVSWNLR",
"FYILPSII",
"TWLDMVDT",
"MTWLDMVD",
"VLSEARQH",
"TVSWNLRE",
"VRGFGDSV",
"VQSTQWSL",
"MFVKHKHA",
"LVRGFGDS",
"MMFVKHKH",
"WLDMVDTS",
"TQWSLFFF",
"SVEEVLSE",
"DIDITFLK",
"KALRKVPT",
"IDITFLKK",
"EVLSEARQ",
"YKVYYGNA",
"AMMFVKHK",
"VYDDGARR",
"EEVLSEAR",
"VAYFNMVY",
"CCREHEHE",
"STQWSLFF",
"KVYYGNAL",
"LSEARQHL",
"VEEVLSEA",
"EKSYELQT",
"VSWNLREM",
"VYQCAMRP",
"YNKVENMT",
"REHEHEIA",
"YDDGARRV",
"IMTWLDMV",
"LTYNKVEN",
"ALRKVPTD",
"TYNKVENM",
"LRKVPTDN",
"CREHEHEI",
"SWNLREML",
"SDIDITFL",
"LDMVDTSL",
"EHEHEIAW",
"CKSAFYIL",
"IKVFTTVD",
"KSAFYILP",
"MLTYNKVE",
"SAFYILPS",
"VKATCEFC",
"KSYELQTP",
"HEHEIAWY",
"KATCEFCG",
"AFYILPSI",
"LAKALRKV",
"YFNMVYMP",
"RKVPTDNY",
"RIMTWLDM",
"NKVENMTP",
"EKKKLDGF",
"SAFAMMFV",
"KVFTTVDN",
"FVKATCEF",
"AFAMMFVK",
"YCCREHEH",
"AYFNMVYM",
"MSAFAMMF",
"MRIMTWLD",
"SYELQTPF",
"YELQTPFE",
"KKKLDGFM",
"WVMRIMTW",
"SWVMRIMT",
"FAMMFVKH",
"KCKSAFYI",
"KKLDGFMG",
"GAGGHSYG",
"DITFLKKD",
"ATCEFCGT",
"VMRIMTWL",
"LQTPFEIK",
"ELQTPFEI",
"QTPFEIKL",
"FNMVYMPA",
"TCEFCGTE",
"DDGARRVW",
"AKALRKVP",
"CEFCGTEN",
"TPFEIKLA",
"NMVYMPAS",
"AGGHSYGA",
"DFVKATCE",
"KLDGFMGR",
"GDFVKATC",
"TTEMLAKA",
"EFCGTENL",
"EARQHLKD",
"ASWVMRIM",
"YMPASWVM",
"MVYMPASW",
"PASWVMRI",
"MLAKALRK",
"IAMSAFAM",
"DGARRVWT",
"KKCKSAFY",
"TEMLAKAL",
"VYMPASWV",
"SEARQHLK",
"EMLAKALR",
"ARQHLKDG",
"KGAGGHSY",
"VYCCREHE",
"LAWLYAAV",
"APYIVGDV",
"AMSAFAMM",
"MPASWVMR",
"HSYGADLK",
"SYGADLKS",
"RRVWTLMN",
"GGHSYGAD",
"GHSYGADL",
"RVWTLMNV",
"TFLKKDAP",
"ITFLKKDA",
"PYIVGDVV",
"FEIKLAKK",
"LKDGTCGL",
"PFEIKLAK",
"RQHLKDGT",
"LKKCKSAF",
"KDGTCGLV",
"EIKLAKKF",
"IKLAKKFD",
"TCGLVEVE",
"HLKDGTCG",
"GVYCCREH",
"QHLKDGTC",
"CGLVEVEK",
"YIVGDVVQ",
"YQCAMRPN",
"TVLKKCKS",
"GTCGLVEV",
"DGTCGLVE",
"GSCGSVGF",
"VWTLMNVL",
"LNGSCGSV",
"NGSCGSVG",
"VLKKCKSA",
"SCGSVGFN",
"FLNGSCGS",
"GLVEVEKG",
"SFLNGSCG",
"KTVLKKCK",
"LEQPYVFI",
"FLKKDAPY",
"KVPTDNYI",
"PQLEQPYV",
"VLPQLEQP",
"YENAFLPF",
"WQTGDFVK",
"SWQTGDFV",
"VPTDNYIT",
"LKKDAPYI",
"KGVLPQLE",
"GVLPQLEQ",
"GNKGAGGH",
"GARRVWTL",
"QTGDFVKA",
"AKTVLKKC",
"GSFLNGSC",
"YGADLKSF",
"EKGVLPQL",
"QLEQPYVF",
"CMVQVTCG",
"VEKGVLPQ",
"LPQLEQPY",
"TGDFVKAT",
"ARRVWTLM",
"CGTTTLNG",
"AGALNKAT",
"CGSVGFNI",
"VQVTCGTT",
"LGDELGTD",
"DLGDELGT",
"VEEAKTVL",
"QVTCGTTT",
"DAPYIVGD",
"ETLGVLVP",
"EAKTVLKK",
"WTLMNVLT",
"EDFQENWN",
"TDPYEDFQ",
"MVQVTCGT",
"KGSFLNGS",
"WNTKHSSG",
"VAGALNKA",
"GALNKATN",
"EVEKGVLP",
"GTTTLNGL",
"VEVEKGVL",
"GETLGVLV",
"DFQENWNT",
"VTCGTTTL",
"FQENWNTK",
"GTDLEGNF",
"EEAKTVLK",
"QENWNTKH",
"TLMNVLTL",
"LVEVEKGV",
"NWNTKHSS",
"YEDFQENW",
"KDAPYIVG",
"IKGSFLNG",
"EQPYVFIK",
"PTDNYITT",
"DPYEDFQE",
"TDNYITTY",
"SGETLGVL",
"GDELGTDP",
"YMHHMELP",
"TCGTTTLN",
"TDLEGNFY",
"GVAGALNK",
"CYMHHMEL",
"DLEGNFYG",
"KKDAPYIV",
"HAGTDLEG",
"GTDPYEDF",
"VHAGTDLE",
"PYEDFQEN",
"FCYMHHME",
"AGTDLEGN",
"DNYITTYP",
"NKGAGGHS",
"RTIKVFTT",
"GGVAGALN",
"SVGFNIDY",
"LGTDPYED",
"GSVGFNID",
"ENWNTKHS",
"GYTVEEAK",
"VGFNIDYD",
"YTVEEAKT",
"SFCYMHHM",
"GVHAGTDL",
"NTKHSSGV",
"TIKVFTTV",
"MELPTGVH",
"QPYVFIKR",
"PYVFIKRS",
"ELGTDPYE",
"TVEEAKTV",
"DCVSFCYM",
"DLKSFDLG",
"VLAWLYAA",
"VRTIKVFT",
"TGVHAGTD",
"GECPNFVF",
"RGVYCCRE",
"TIKGSFLN",
"DGYPLECI",
"LPTGVHAG",
"HMELPTGV",
"CVSFCYMH",
"NGECPNFV",
"VSFCYMHH",
"PDGYPLEC",
"FTIKGSFL",
"ELPTGVHA",
"GFNIDYDC",
"VVNAANVY",
"HHMELPTG",
"PTGVHAGT",
"KRGVYCCR",
"CGPDGYPL",
"MHHMELPT",
"GYPLECIK",
"KNADIVEE",
"NFTIKGSF",
"VVQEGVLT",
"LETAQNSV",
"ECPNFVFP",
"VNAANVYL",
"RSGETLGV",
"VVVNAANV",
"IKNADIVE",
"EGNFYGPF",
"DELGTDPY",
"NVLAWLYA",
"YDCVSFCY",
"IQTIVEVQ",
"FNGECPNF",
"FNIDYDCV",
"LLSLREVR",
"LEGNFYGP",
"GPDGYPLE",
"GADLKSFD",
"NAANVYLK",
"ADLKSFDL",
"YITTYPGQ",
"EVRTIKVF",
"NFVFPLNS",
"ITTYPGQG",
"QGLNGYTV",
"GLNGYTVE",
"NYITTYPG",
"VNVLAWLY",
"CPNFVFPL",
"GQGLNGYT",
"AANVYLKH",
"TLSEQLDF",
"SGVTRELM",
"YIKNADIV",
"VYIKNADI",
"KHGGGVAG",
"HCGETSWQ",
"CTLSEQLD",
"VYLKHGGG",
"TTYPGQGL",
"GDVVQEGV",
"REVRTIKV",
"GVTRELMR",
"NIDYDCVS",
"ANVYLKHG",
"VGDVVQEG",
"TSWQTGDF",
"PNFVFPLN",
"GNFYGPFV",
"DTTITVNV",
"LSLREVRT",
"QCAMRPNF",
"GETSWQTG",
"DHCGETSW",
"VAYRKVLL",
"TKHSSGVT",
"LMRELNGG",
"LECIKDLL",
"IQPRVEKK",
"ELMRELNG",
"DYDCVSFC",
"LSEQLDFI",
"IVGDVVQE",
"DVVQEGVL",
"RELMRELN",
"VTRELMRE",
"CGETSWQT",
"AGKASCTL",
"VKPTVVVN",
"KKVKPTVV",
"PVAYRKVL",
"KHSSGVTR",
"IDYDCVSF",
"CDHCGETS",
"SSGVTREL",
"HSSGVTRE",
"CAMRPNFT",
"KVKPTVVV",
"LREVRTIK",
"SCTLSEQL",
"NECNQMCL",
"YVFIKRSD",
"SFSGYLKL",
"SEQLDFID",
"KPTVVVNA",
"FVFPLNSI",
"LNGYTVEE",
"RVEKKKLD",
"PTVVVNAA",
"KVLLRKNG",
"LKHGGGVA",
"QPRVEKKK",
"NGYTVEEA",
"YRKVLLRK",
"TVVVNAAN",
"GGGVAGAL",
"VFIKRSDA",
"NVYLKHGG",
"VVRSIFSR",
"VEKKKLDG",
"FYGPFVDR",
"NVYIKNAD",
"TVNVLAWL",
"KLTDNVYI",
"YPLECIKD",
"TIQPRVEK",
"TRELMREL",
"PLECIKDL",
"PRVEKKKL",
"KCDHCGET",
"GLNDNLLE",
"QTIVEVQP",
"YGPFVDRQ",
"PGQGLNGY",
"LTDNVYIK",
"IKTIQPRV",
"NFKVTKGK",
"RQTAQAAG",
"YPGQGLNG",
"LKLTDNVY",
"RKVLLRKN",
"YLKLTDNV",
"TLLSLREV",
"ITVNVLAW",
"AYRKVLLR",
"TDNVYIKN",
"ECIKDLLA",
"TYPGQGLN",
"TTLNGLWL",
"TLGVLVPH",
"KTIQPRVE",
"LMWLIINL",
"FSGYLKLT",
"EIPVAYRK",
"DRQTAQAA",
"FIKRSDAR",
"IFSRTLET",
"NFYGPFVD",
"YLKHGGGV",
"SIFSRTLE",
"GIQYGRSG",
"VFPLNSII",
"TTTLNGLW",
"LGVLVPHV",
"IKRSDART",
"KRSDARTA",
"DNVYIKNA",
"GEIPVAYR",
"TILTSLLV",
"MKCDHCGE",
"GPFVDRQT",
"GYLKLTDN",
"YTRYVDNN",
"EGIQYGRS",
"VGEIPVAY",
"SLREVRTI",
"GNFKVTKG",
"GRSGETLG",
"LTILTSLL",
"IPVAYRKV",
"HGGGVAGA",
"SGYLKLTD",
"GKASCTLS",
"ECNQMCLS",
"CNQMCLST",
"RSIFSRTL",
"RAGKASCT",
"TITVNVLA",
"IQPGQTFS",
"ENAFLPFA",
"VAELEGIQ",
"LVAELEGI",
"VESCGNFK",
"TLNGLWLD",
"FPLNSIIK",
"LMKCDHCG",
"TLMKCDHC",
"FVDRQTAQ",
"ETSWQTGD",
"TLETAQNS",
"KASCTLSE",
"SCGNFKVT",
"ELVAELEG",
"RVVRSIFS",
"ARAGKASC",
"IIKTIQPR",
"VLVPHVGE",
"KDLLARAG",
"ESCGNFKV",
"QYGRSGET",
"ASCTLSEQ",
"FSRTLETA",
"LKRGDKSV",
"GVLVPHVG",
"CGNFKVTK",
"RSDARTAP",
"RPNFTIKG",
"DLLARAGK",
"AELEGIQY",
"IVESCGNF",
"VDRQTAQA",
"TTITVNVL",
"FKVTKGKA",
"LLARAGKA",
"LARAGKAS",
"CIKDLLAR",
"NQMCLSTL",
"IQYGRSGE",
"PNFTIKGS",
"LLTILTSL",
"RTLETAQN",
"EFLKRGDK",
"ELEGIQYG",
"FLKRGDKS",
"KTLLSLRE",
"EILQKEKV",
"IKDLLARA",
"WLMWLIIN",
"SRTLETAQ",
"PLNSIIKT",
"NGNKGAGG",
"SIIKTIQP",
"FKQIVESC",
"KQIVESCG",
"LEGIQYGR",
"SDARTAPH",
"LNSIIKTI",
"QIVESCGN",
"AMRPNFTI",
"VEEAKKVK",
"ARVVRSIF",
"LLLTILTS",
"NSFSGYLK",
"YGRSGETL",
"MRPNFTIK",
"MRELNGGA",
"KVTKGKAK",
"LNGLWLDD",
"SWLMWLII",
"IVEEAKKV",
"MCLSTLMK",
"NSIIKTIQ",
"QMCLSTLM",
"VKFISTCA",
"CLSTLMKC",
"KRGDKSVY",
"LEILQKEK",
"ELNGGAYT",
"VRSIFSRT",
"INIVGDFK",
"LRKNGNKG",
"VTKGKAKK",
"VGDFKLNE",
"TSAALQPE",
"KNGNKGAG",
"LSTLMKCD",
"LKTLLSLR",
"NAFLPFAM",
"RELNGGAY",
"AWNIGEQK",
"SFDLGDEL",
"KVNINIVG",
"LLEILQKE",
"IVGDFKLN",
"EKVNINIV",
"NIVGDFKL",
"EEAKKVKP",
"NGLWLDDV",
"VLLRKNGN",
"VEVQPQLE",
"STLMKCDH",
"QKEKVNIN",
"PFVDRQTA",
"LLRKNGNK",
"VPHVGEIP",
"WNIGEQKS",
"NINIVGDF",
"ARTAPHGH",
"AFLPFAMG",
"LVPHVGEI",
"DIVEEAKK",
"VNINIVGD",
"FDNLKTLL",
"IVEVQPQL",
"FDLGDELG",
"LDGEVITF",
"NLLEILQK",
"NADIVEEA",
"KEKVNINI",
"DGEVITFD",
"QEGVLTAV",
"VNSFSGYL",
"FHLDGEVI",
"FCGPDGYP",
"GTTEMLAK",
"NFCGPDGY",
"TIVEVQPQ",
"NGGAYTRY",
"AYTRYVDN",
"PHVGEIPV",
"GLWLDDVV",
"GGAYTRYV",
"GEVITFDN",
"NDNLLEIL",
"RKNGNKGA",
"LNGGAYTR",
"LNDNLLEI",
"GRIRSVYP",
"LQKEKVNI",
"HLDGEVIT",
"GAYTRYVD",
"TFHLDGEV",
"IEFLKRGD",
"DNLKTLLS",
"DNLLEILQ",
"NLKTLLSL",
"ADIVEEAK",
"ILQKEKVN",
"GGTTEMLA",
"RGDKSVYY",
"MGRIRSVY",
"LGIEFLKR",
"EVITFDNL",
"NNFCGPDG",
"VQEGVLTA",
"IVKFISTC",
"GIEFLKRG",
"LWLDDVVY",
"LDGFMGRI",
"FMGRIRSV",
"EVQPQLEM",
"EGVLTAVV",
"DGFMGRIR",
"AARVVRSI",
"EAKKVKPT",
"TFDNLKTL",
"ILASFSAS",
"HVGEIPVA",
"VEGCMVQV",
"DARTAPHG",
"VITFDNLK",
"VELVAELE",
"EVNSFSGY",
"IILASFSA",
"NIGEQKSI",
"ITFDNLKT",
"YVDNNFCG",
"IEVNSFSG",
"AIILASFS",
"QLGIEFLK",
"IGEQKSIL",
"TDTTITVN",
"EAARVVRS",
"KFISTCAC",
"ASEAARVV",
"TFLLNKEM",
"VDNNFCGP",
"GFMGRIRS",
"QKSILSPL",
"GDFKLNEE",
"NPTTFHLD",
"TTFHLDGE",
"DNNFCGPD",
"TQLGIEFL",
"TRYVDNNF",
"LEMELTPV",
"EQKSILSP",
"PTTFHLDG",
"RYVDNNFC",
"SILSPLYA",
"AKKVKPTV",
"GEQKSILS",
"KSILSPLY",
"GKVEGCMV",
"GCMVQVTC",
"YKAFKQIV",
"KVEGCMVQ",
"KAFKQIVE",
"AGTDTTIT",
"LSPLYAFA",
"EGCMVQVT",
"AFKQIVES",
"QTAQAAGT",
"QAAGTDTT",
"YSGQSTQL",
"GTDTTITV",
"AAGTDTTI",
"EMELTPVV",
"SGQSTQLG",
"WLLLTILT",
"VQPQLEME",
"STQLGIEF",
"QLEMELTP",
"LASFSAST",
"FKLNEEIA",
"SNPTTFHL",
"IAIILASF",
"LTAVVIPT",
"ISTCACEI",
"QPQLEMEL",
"ILSPLYAF",
"EEIAIILA",
"EIAIILAS",
"QLDFIDTK",
"DTKRGVYC",
"TAVVIPTK",
"FIDTKRGV",
"LDFIDTKR",
"IDTKRGVY",
"DFIDTKRG",
"PQLEMELT",
"GQSTQLGI",
"TKRGVYCC",
"QSTQLGIE",
"DFKLNEEI",
"NEEIAIIL",
"GDKSVYYT",
"AQAAGTDT",
"MELTPVVQ",
"FISTCACE",
"KVENMTPR",
"KSFDLGDE",
"KLNEEIAI",
"AVVIPTKK",
"EQLDFIDT",
"SPLYAFAS",
"LKSFDLGD",
"PLYAFASE",
"LNEEIAII",
"ASFSASTS",
"SYSGQSTQ",
"KDWSYSGQ",
"GVLTAVVI",
"GAWNIGEQ",
"TIEVNSFS",
"KSVYYTSN",
"TKGKAKKG",
"LYAFASEA",
"QTIEVNSF",
"SVYYTSNP",
"KGAWNIGE",
"DKSVYYTS",
"SEAARVVR",
"VLTAVVIP",
"VENMTPRD",
"TAQAAGTD",
"KKGAWNIG",
"RIRSVYPV",
"DWSYSGQS",
"YAFASEAA",
"FASEAARV",
"HWLLLTIL",
"WSYSGQST",
"KAKKGAWN",
"GKAKKGAW",
"AKKGAWNI",
"KGKAKKGA",
"RSVYPVAS",
"VYCPRHVI",
"KEMYLKLR",
"NKEMYLKL",
"VVQTIEVN",
"AFASEAAR",
"VYYTSNPT",
"YCPRHVIC",
"VQTIEVNS",
"TPVVQTIE",
"PVVQTIEV",
"SFSASTSA",
"SASTSAFV",
"ELTPVVQT",
"FSASTSAF",
"ENMTPRDL",
"VVYCPRHV",
"LTPVVQTI",
"YTSNPTTF",
"TSNPTTFH",
"EMYLKLRS",
"NMTPRDLG",
"DVVYCPRH",
"IIAMSAFA",
"RIQPGQTF",
"LLNKEMYL",
"ATSAALQP",
"WLDDVVYC",
"VRIQPGQT",
"YYTSNPTT",
"LNKEMYLK",
"LDDVVYCP",
"QWSLFFFL",
"GIIAMSAF",
"FLLNKEMY",
"MYLKLRSD",
"QQDGSEDN",
"GQQDGSED",
"NGDRWFLN",
"MGIIAMSA",
"DDVVYCPR",
"PQIGVVRE",
"VSDIDITF",
"WSLFFFLY",
"NRPQIGVV",
"INRPQIGV",
"RPQIGVVR",
"SSAINRPQ",
"LKLRSDVL",
"FFFLYENA",
"LFFFLYEN",
"GATSAALQ",
"SLFFFLYE",
"YLKLRSDV",
"GDRWFLNR",
"DVSSAINR",
"VSSAINRP",
"FDKNLYDK",
"DKNLYDKL",
"INGDRWFL",
"LRVIGHSM",
"SFTVLCLT",
"DRWFLNRF",
"LLFLMSFT",
"FVRIQPGQ",
"LPFAMGII",
"LFLMSFTV",
"TLLFLMSF",
"FTVLCLTP",
"SAINRPQI",
"FLMSFTVL",
"TVLCLTPV",
"MSFTVLCL",
"NTLLFLMS",
"HDVSSAIN",
"FNTLLFLM",
"SGKVEGCM",
"EGDCEEEE",
"AINRPQIG",
"AMGIIAMS",
"KFVRIQPG",
"CPRHVICT",
"YKFVRIQP",
"PFAMGIIA",
"FAMGIIAM",
"PRHVICTS",
"EEGDCEEE",
"FKLASHMY",
"DCEEEEFE",
"NHNFLVQA",
"HVICTSED",
"LMSFTVLC",
"LASHMYCS",
"NFLVQAGN",
"KNLYDKLV",
"LVQAGNVQ",
"VICTSEDM",
"FLVQAGNV",
"KLASHMYC",
"NPNYEDLL",
"PNYEDLLI",
"EEEGDCEE",
"HNFLVQAG",
"RHVICTSE",
"DMLNPNYE",
"YYLFDESG",
"MLNPNYED",
"DEEEGDCE",
"SNHNFLVQ",
"PSGKVEGC",
"GDCEEEEF",
"TYYLFDES",
"EDEEEGDC",
"CEEEEFEP",
"HMYCSFYP",
"MTPRDLGA",
"LNPNYEDL",
"SHMYCSFY",
"FCGTENLT",
"VQAGNVQL",
"NYEDLLIR",
"ASHMYCSF",
"QLRVIGHS",
"YEDLLIRK",
"FLYENAFL",
"EDMLNPNY",
"LLIRKSNH",
"EDLLIRKS",
"DLLIRKSN",
"ILLLDQAL",
"LLLDQALV",
"KSNHNFLV",
"LDEWSMAT",
"PNECNQMC",
"AGNVQLRV",
"LIRKSNHN",
"CGTENLTK",
"SEDMLNPN",
"STCACEIV",
"NVQLRVIG",
"QAGNVQLR",
"MYCSFYPP",
"IRKSNHNF",
"WSMATYYL",
"SMATYYLF",
"RKSNHNFL",
"VQLRVIGH",
"LYENAFLP",
"ICTSEDML",
"GNVQLRVI",
"DEWSMATY",
"EWSMATYY",
"SPNECNQM",
"NSWLMWLI",
"MATYYLFD",
"SNSWLMWL",
"FPSGKVEG",
"ATYYLFDE",
"NKYKYFSG",
"QDGSEDNQ",
"CTSEDMLN",
"HFISNSWL",
"FISNSWLM",
"TSEDMLNP",
"DEDEEEGD",
"ISNSWLMW",
"AFPSGKVE",
"ACSHAAVD",
"TQYEYGTE",
"YNKYKYFS",
"MAFPSGKV",
"KHFSMMIL",
"GTENLTKE",
"LQSGFRKM",
"VINGDRWF",
"KMAFPSGK",
"YVFCTVNA",
"FRKMAFPS",
"SITSAVLQ",
"QYVFCTVN",
"RKMAFPSG",
"LYNKYKYF",
"EQYVFCTV",
"TACSHAAV",
"AVINGDRW",
"ASPNECNQ",
"LEQYVFCT",
"QSGFRKMA",
"VYKVYYGN",
"ATNYDLSV",
"CTFLLNKE",
"FFLYENAF",
"AAVINGDR",
"MATNYDLS",
"EGLNDNLL",
"VLQSGFRK",
"TENLTKEG",
"HAAVDALC",
"AVLQSGFR",
"SMATNYDL",
"GSEDNQTT",
"PDEDEEEG",
"SHAAVDAL",
"GFRKMAFP",
"ITSAVLQS",
"YCSFYPPD",
"YAAVINGD",
"LYAAVING",
"CSHAAVDA",
"TSAVLQSG",
"SAVLQSGF",
"NDVSFLAH",
"LCTFLLNK",
"DGSEDNQT",
"VVFDEISM",
"IYLYLTFY",
"YREAACCH",
"PIDKCSRI",
"VLCLTPVY",
"SGFRKMAF",
"SDVLYQPP",
"CFDKFKVN",
"FLPFAMGI",
"LPIDKCSR",
"GEFKLASH",
"ISMATNYD",
"CSFYPPDE",
"YTACSHAA",
"YMLTYNKV",
"KALKYLPI",
"DVSFLAHI",
"DEISMATN",
"VFDEISMA",
"TNDVSFLA",
"EISMATNY",
"SYREAACC",
"FYPPDEDE",
"ALCTFLLN",
"FDEISMAT",
"KYLPIDKC",
"ALKYLPID",
"EFKLASHM",
"VYTACSHA",
"YPPDEDEE",
"TLEQYVFC",
"LKYLPIDK",
"GHSMQNCV",
"YLPIDKCS",
"SFYPPDED",
"LFDESGEF",
"FDESGEFK",
"NYMLTYNK",
"NNYMLTYN",
"SVIYLYLT",
"FLPGVYSV",
"FGATSAAL",
"KYKYFSGA",
"VIYLYLTF",
"VDALCEKA",
"YLRKHFSM",
"PPDEDEEE",
"YSVIYLYL",
"IVVFDEIS",
"VYSVIYLY",
"LVYKVYYG",
"LRKHFSMM",
"RKHFSMMI",
"VIGHSMQN",
"EPSTQYEY",
"YLFDESGE",
"IGHSMQNC",
"FKMFYKGV",
"GSDVLYQP",
"DVLYQPPQ",
"AALCTFLL",
"EEEEFEPS",
"TPVYSFLP",
"SGEFKLAS",
"EFGATSAA",
"DESGEFKL",
"RVIGHSMQ",
"AKHYVYIG",
"AVDALCEK",
"KHYVYIGD",
"YEYGTEDD",
"FDKFKVNS",
"LCLTPVYS",
"HSMQNCVL",
"IVYTACSH",
"EEEFEPST",
"LPGVYSVI",
"AAVDALCE",
"EYGTEDDY",
"ESGEFKLA",
"NVLTLVYK",
"VLTLVYKV",
"TEDDYQGK",
"PSTQYEYG",
"YGTEDDYQ",
"MNVLTLVY",
"LTPVYSFL",
"EFEPSTQY",
"CLTPVYSF",
"RIVYTACS",
"THDVSSAI",
"KMFYKGVI",
"QYEYGTED",
"HYVYIGDP",
"ARIVYTAC",
"TLVYKVYY",
"PGVYSVIY",
"IRSVYPVA",
"AYLRKHFS",
"GTEDDYQG",
"GKSHFAIG",
"YAYLRKHF",
"NSTLEQYV",
"KSHFAIGL",
"STLEQYVF",
"GVYSVIYL",
"EEFEPSTQ",
"STQYEYGT",
"KYKFVRIQ",
"SARIVYTA",
"ENLTKEGA",
"CEKALKYL",
"TSYREAAC",
"FYAYLRKH",
"NRDVDTDF",
"SEGLNDNL",
"TNYDLSVV",
"LTLVYKVY",
"RNRDVDTD",
"FEPSTQYE",
"FCTVNALP",
"YVYIGDPA",
"PKYKFVRI",
"YYPSARIV",
"RDVDTDFV",
"VFCTVNAL",
"TPKYKFVR",
"EKALKYLP",
"KFKVNSTL",
"ITHDVSSA",
"TTSYREAA",
"PVYSFLPG",
"YLYLTFYL",
"TGKSHFAI",
"GTGKSHFA",
"DALCEKAL",
"ALCEKALK",
"FKVNSTLE",
"LCEKALKY",
"DVDTDFVN",
"NYDLSVVN",
"VNSTLEQY",
"CTVNALPE",
"DKFKVNST",
"REAACCHL",
"KVNSTLEQ",
"DLSVVNAR",
"KALNDFSN",
"TCACEIVG",
"YDLSVVNA",
"SMQNCVLK",
"LEFGATSA",
"VYPVASPN",
"YPSARIVY",
"TVNALPET",
"QALVSDVG",
"DTDFVNEF",
"YLTFYLTN",
"LYLTFYLT",
"VYSFLPGV",
"VSFLAHIQ",
"FVNEFYAY",
"EFYAYLRK",
"YPVASPNE",
"VASPNECN",
"VDTDFVNE",
"VNEFYAYL",
"LTFYLTND",
"DFVNEFYA",
"NEFYAYLR",
"YLTNDVSF",
"FSNSGSDV",
"PSARIVYT",
"FYLTNDVS",
"LTNDVSFL",
"DIVVFDEI",
"DQALVSDV",
"YSFLPGVY",
"TFYLTNDV",
"LMNVLTLV",
"SFLPGVYS",
"KTPKYKFV",
"PVASPNEC",
"DTTSYREA",
"WLYAAVIN",
"NDFSNSGS",
"SVYPVASP",
"LNDFSNSG",
"LRAKHYVY",
"DFSNSGSD",
"SFLAHIQW",
"SNSGSDVL",
"VGQQDGSE",
"LYYPSARI",
"LYYQNNVF",
"TDFVNEFY",
"DVLVRGFG",
"LSVVNARL",
"LDQALVSD",
"HFSMMILS",
"SGSDVLYQ",
"NSGSDVLY",
"AKALNDFS",
"LLDQALVS",
"EAACCHLA",
"AACCHLAK",
"YYQNNVFM",
"VNALPETT",
"YQNNVFMS",
"ALVSDVGD",
"ADIVVFDE",
"FSMMILSD",
"CCHLAKAL",
"ALNDFSNS",
"VLVRGFGD",
"ACCHLAKA",
"FLAHIQWM",
"SMMILSDD",
"CHLAKALN",
"RLRAKHYV",
"GPPGTGKS",
"ARLRAKHY",
"LAKALNDF",
"LAHIQWMV",
"HLAKALND",
"QGPPGTGK",
"NARLRAKH",
"VNARLRAK",
"VVNARLRA",
"VMLTNDNT",
"YKGVITHD",
"FYKGVITH",
"YSVMLTND",
"SVMLTNDN",
"VITHDVSS",
"KGVITHDV",
"GVITHDVS",
"AHIQWMVM",
"VLYYQNNV",
"SVVNARLR",
"FTGYRVTK",
"NLTKEGAT",
"QNNVFMSE",
"GSEGLNDN",
"NALPETTA",
"TADIVVFD",
"MLTNDNTS",
"ALPETTAD",
"GPLSAQTG",
"NNVFMSEA",
"TNDNTSRY",
"LTNDNTSR",
"VFTGYRVT",
"PPGTGKSH",
"EFTPFDVV",
"EDEFTPFD",
"YVFTGYRV",
"NYVFTGYR",
"TTADIVVF",
"PETTADIV",
"CASLKELL",
"FMSEAKCW",
"LPETTADI",
"DEFTPFDV",
"ETTADIVV",
"VFMSEAKC",
"SVLYYQNN",
"MCASLKEL",
"KSVLYYQN",
"EAALCTFL",
"NVFMSEAK",
"FKSVLYYQ",
"FCAGSTFI",
"MFYKGVIT",
"VVLKTGDL",
"FDVVRQCS",
"PGTGKSHF",
"DAVVCFNS",
"PLSAQTGI",
"LEDEFTPF",
"GDPAQLPA",
"ASLKELLQ",
"MMILSDDA",
"MILSDDAV",
"DVVRQCSG",
"VLKTGDLQ",
"LGPLSAQT",
"GSTFISDE",
"EYFNSVCR",
"AVVCFNST",
"FTPFDVVR",
"ILSDDAVV",
"AGSTFISD",
"NFKSVLYY",
"AWLYAAVI",
"VVCFNSTY",
"PFDVVRQC",
"MSEAKCWT",
"LKTGDLQP",
"LQGPPGTG",
"PAQLPAPR",
"DPAQLPAP",
"STFISDEV",
"TPFDVVRQ",
"QCSGVTFQ",
"VRQCSGVT",
"LSDDAVVC",
"LEPEYFNS",
"AQLPAPRT",
"VYIGDPAQ",
"LVSDVGDS",
"EPEYFNSV",
"DDAVVCFN",
"VCFNSTYA",
"SLKELLQN",
"CAGSTFIS",
"DMCASLKE",
"KNFKSVLY",
"LKELLQNG",
"RQCSGVTF",
"LLEDEFTP",
"VVRQCSGV",
"SDDAVVCF",
"CFNSTYAS",
"QLPAPRTL",
"SIKNFKSV",
"IKNFKSVL",
"FNSTYASQ",
"PEYFNSVC",
"CSGVTFQS",
"NSTYASQG",
"YIGDPAQL",
"VDILGPLS",
"RAKHYVYI",
"STYASQGL",
"FEEAALCT",
"FAIGLALY",
"EEAALCTF",
"ALLEDEFT",
"TFEEAALC",
"ILGPLSAQ",
"AKCWTETD",
"DILGPLSA",
"LLYIDING",
"ASIKNFKS",
"LYIDINGN",
"QDHVDILG",
"LSAQTGIA",
"KCWTETDL",
"KELLQNGM",
"ETAQNSVR",
"CFKMFYKG",
"LPAPRTLL",
"TLQGPPGT",
"TQDHVDIL",
"KTGDLQPL",
"LTQDHVDI",
"DHVDILGP",
"QCFKMFYK",
"SEAKCWTE",
"HVDILGPL",
"LLLYIDIN",
"YFNSVCRL",
"MKTIGPDM",
"CACEIVGG",
"NYEPLTQD",
"IGDPAQLP",
"FNSVCRLM",
"KTIGPDMF",
"AQCFKMFY",
"PAPRTLLT",
"LDMCASLK",
"NSVCRLMK",
"STFEEAAL",
"HFAIGLAL",
"YNYEPLTQ",
"TIGPDMFL",
"SVCRLMKT",
"SMKYFVKI",
"PYPDPSRI",
"VSDVGDSA",
"MKYFVKIG",
"YPDPSRIL",
"SALLEDEF",
"CWTETDLT",
"AIGLALYY",
"LPYPDPSR",
"VCRLMKTI",
"EAKCWTET",
"LTENLLLY",
"FSTFEEAA",
"APRTLLTK",
"AQNSVRVL",
"FLTENLLL",
"ACEIVGGQ",
"TAQNSVRV",
"HMLDMYSV",
"NLLLYIDI",
"KFLTENLL",
"TENLLLYI",
"ENLLLYID",
"YEPLTQDH",
"MLDMYSVM",
"GHMLDMYS",
"CNNYMLTY",
"YLATALLT",
"SCNNYMLT",
"CRLMKTIG",
"LDMYSVML",
"HHWLLLTI",
"YLPYPDPS",
"LQQIELKF",
"VDTANPKT",
"PRTLLTKG",
"MYSVMLTN",
"LMKTIGPD",
"EPLTQDHV",
"DMYSVMLT",
"TKNSKVQI",
"GSALLEDE",
"DTANPKTP",
"NPKTPKYK",
"ANPKTPKY",
"TGHMLDMY",
"SAQCFKMF",
"RLMKTIGP",
"PKTPKYKF",
"KNSKVQIG",
"VLDMCASL",
"TGDLQPLE",
"SAQTGIAV",
"QNSVRVLQ",
"CEIVGGQI",
"PLTQDHVD",
"WTETDLTK",
"TFCAGSTF",
"TANPKTPK",
"IGLALYYP",
"STLQGPPG",
"TLEPEYFN",
"AQTGIAVL",
"LAIDAYPL",
"ALNKATNN",
"VKRTIKGT",
"GPHEFCSQ",
"GLALYYPS",
"EGSEGLND",
"QTGIAVLD",
"SHFAIGLA",
"LTGHMLDM",
"THHWLLLT",
"SLAIDAYP",
"SDVGDSAE",
"ELLQNGMN",
"DKSAQCFK",
"LALYYPSA",
"KDKSAQCF",
"ELTGHMLD",
"VYLPYPDP",
"PDPSRILG",
"KGPHEFCS",
"LGSALLED",
"TGIAVLDM",
"KYFVKIGP",
"KSAQCFKM",
"LNKATNNA",
"VTKNSKVQ",
"LQYIRKLH",
"LGAGCFVD",
"GTLEPEYF",
"FHLYLQYI",
"MWLIINLV",
"LYLQYIRK",
"DYVYLPYP",
"TKFLTENL",
"TGYRVTKN",
"GIAVLDMC",
"VSLAIDAY",
"LEETKFLT",
"ILGAGCFV",
"YLQYIRKL",
"HLYLQYIR",
"GVTFQSAV",
"VFHLYLQY",
"RDVLVRGF",
"KGTLEPEY",
"RKLHDELT",
"RILGAGCF",
"YADVFHLY",
"WLIINLVQ",
"ILGSALLE",
"HKDKSAQC",
"YVYLPYPD",
"KCSRIIPA",
"GYRVTKNS",
"GAGCFVDD",
"DPSRILGA",
"DDYVYLPY",
"YIRKLHDE",
"SGVTFQSA",
"LHDELTGH",
"IRKLHDEL",
"QYIRKLHD",
"CSRIIPAR",
"DELTGHML",
"TFQSAVKR",
"KLHDELTG",
"ALYYPSAR",
"SRILGAGC",
"GDSAEVAV",
"ETKFLTEN",
"VGDSAEVA",
"FVDDIVKT",
"HDELTGHM",
"LLQNGMNG",
"IAVLDMCA",
"DKCSRIIP",
"IDKCSRII",
"EETKFLTE",
"DSCNNYML",
"VDDIVKTD",
"DVFHLYLQ",
"DVGDSAEV",
"DTFCAGST",
"VKTDGTLM",
"YRVTKNSK",
"PSRILGAG",
"LIINLVQM",
"AVLDMCAS",
"CDTFCAGS",
"AHKDKSAQ",
"LATALLTL",
"ADVFHLYL",
"VRDVLVRG",
"KTDGTLMI",
"GGKGFCKL",
"TILGSALL",
"GMNGRTIL",
"VECFDKFK",
"SRIIPARA",
"GEGSEGLN",
"AGCFVDDI",
"KIKACVEE",
"RVTKNSKV",
"PHEFCSQH",
"EVTTTLEE",
"KAHKDKSA",
"IIPARARV",
"LTLQQIEL",
"RIIPARAR",
"LKAHKDKS",
"HEFCSQHT",
"EVAVKMFD",
"RTLLTKGT",
"TLLTKGTL",
"TLEETKFL",
"TLQQIELK",
"PARARVEC",
"CFVDDIVK",
"RFVSLAID",
"TKGTLEPE",
"FVSLAIDA",
"ERFVSLAI",
"DDIVKTDG",
"FQSAVKRT",
"RVECFDKF",
"IKACVEEV",
"LLTKGTLE",
"DIVKTDGT",
"IVKTDGTL",
"IINLVQMA",
"GCFVDDIV",
"GKGFCKLH",
"ECFDKFKV",
"EEVTTTLE",
"NTFSSTFN",
"ARARVECF",
"TDGTLMIE",
"MNGRTILG",
"KLRSDVLL",
"TFSSTFNV",
"KLNVGDYF",
"VNTFSSTF",
"YKLNVGDY",
"IERFVSLA",
"DGTLMIER",
"NSKVQIGE",
"TLMIERFV",
"RWFLNRFT",
"TTLEETKF",
"GTLMIERF",
"LLTLQQIE",
"LQNGMNGR",
"EYADVFHL",
"VEEVTTTL",
"VTFQSAVK",
"LMIERFVS",
"RARVECFD",
"ARVECFDK",
"CSQHTMLV",
"IDAYPLTK",
"YVNTFSST",
"NVLSTFIS",
"LRSDVLLP",
"MIERFVSL",
"LDNVLSTF",
"NGMNGRTI",
"FSSTFNVP",
"LNVGDYFV",
"DNVLSTFI",
"AIDAYPLT",
"ACVEEVTT",
"KGFCKLHN",
"LTKGPHEF",
"QNGMNGRT",
"YSTLQGPP",
"KACVEEVT",
"TYKLNVGD",
"TKGPHEFC",
"AEVAVKMF",
"CVEEVTTT",
"SAEVAVKM",
"AVKRTIKG",
"TTTLEETK",
"SQHTMLVK",
"QSAVKRTI",
"NGRTILGS",
"VYANGGKG",
"DSAEVAVK",
"GFCKLHNW",
"CQPILLLD",
"DKKIKACV",
"DAYPLTKH",
"VTTTLEET",
"MFDAYVNT",
"RTILGSAL",
"KTLVATAE",
"NQEYADVF",
"VLSTFISA",
"AYVNTFSS",
"DAYVNTFS",
"KPFITESK",
"GRTILGSA",
"QEYADVFH",
"NGGKGFCK",
"FCKLHNWN",
"FDAYVNTF",
"LTKGTLEP",
"EFCSQHTM",
"KLHNWNCV",
"CKLHNWNC",
"EVKPFITE",
"VKPFITES",
"VECLKLSH",
"FYVYANGG",
"KHPNQEYA",
"YVYANGGK",
"AYPLTKHP",
"VAVKMFDA",
"ANGGKGFC",
"KKIKACVE",
"YANGGKGF",
"TLVATAEA",
"SAVKRTIK",
"PNQEYADV",
"ECLKLSHQ",
"SFYVYANG",
"FITESKPS",
"HPNQEYAD",
"PILLLDQA",
"KVQIGEYT",
"VKMFDAYV",
"FLNRFTTT",
"LKTLVATA",
"LHNWNCVN",
"NVSLDNVL",
"VRRSFYVY",
"WFLNRFTT",
"GVRRSFYV",
"SKVQIGEY",
"RRSFYVYA",
"AVKMFDAY",
"VSLDNVLS",
"VNCDTFCA",
"YPLTKHPN",
"CLKLSHQS",
"TKHPNQEY",
"KMFDAYVN",
"DLTKGPHE",
"WNCVNCDT",
"NCDTFCAG",
"EAELAKNV",
"ITESKPSV",
"GTHHWLLL",
"NKATNNAM",
"TTYKLNVG",
"LTKHPNQE",
"FCSQHTML",
"NWNCVNCD",
"NSVRVLQK",
"NCVNCDTF",
"PLTKHPNQ",
"LVATAEAE",
"GDYGDAVV",
"RVECTTIV",
"RSFYVYAN",
"GDDYVYLP",
"ATAEAELA",
"LKLSHQSD",
"AEAELAKN",
"VNGVRRSF",
"QPILLLDQ",
"KGDYGDAV",
"LNRFTTTL",
"SLDNVLST",
"NGVRRSFY",
"TIVNGVRR",
"KNVSLDNV",
"HNWNCVNC",
"WKSYVHVV",
"TAEAELAK",
"VQIGEYTF",
"CVNCDTFC",
"IVNGVRRS",
"CTTIVNGV",
"ASFYYVWK",
"VATAEAEL",
"QHTMLVKQ",
"FYYVWKSY",
"TETDLTKG",
"FEKGDYGD",
"EKLKTLVA",
"EKGDYGDA",
"VWKSYVHV",
"KLSHQSDI",
"TPRDLGAC",
"AKNVSLDN",
"KLKTLVAT",
"VASIKNFK",
"YYVWKSYV",
"IRHVRAWI",
"LVASIKNF",
"ETDLTKGP",
"YFVKIGPE",
"TDLTKGPH",
"PSVEQRKQ",
"LAKNVSLD",
"TYASQGLV",
"YVWKSYVH",
"SFYYVWKS",
"SKPSVEQR",
"PFITESKP",
"EYTFEKGD",
"TESKPSVE",
"KPSVEQRK",
"GEYTFEKG",
"YASQGLVA",
"SQGLVASI",
"FVKIGPER",
"EEVKPFIT",
"ECTTIVNG",
"QGLVASIK",
"VKIGPERT",
"IGEYTFEK",
"ELAKNVSL",
"KEEVKPFI",
"GLVASIKN",
"QRKQDDKK",
"ASQGLVAS",
"VECTTIVN",
"KYSTLQGP",
"KQDDKKIK",
"RKQDDKKI",
"TTIVNGVR",
"YTFEKGDY",
"LSTFISAA",
"EIVKFIST",
"TTTYKLNV",
"TFEKGDYG",
"FFASFYYV",
"ESKPSVEQ",
"QIGEYTFE",
"FASFYYVW",
"KIGPERTC",
"AELAKNVS",
"TFISDEVA",
"KGTHHWLL",
"LSHQSDIE",
"IFFASFYY",
"HQSDIEVT",
"IGPERTCC",
"YFVLTSHT",
"SHQSDIEV",
"QGDDYVYL",
"DYFVLTSH",
"FVLTSHTV",
"KQGDDYVY",
"INLVQMAP",
"NLVQMAPI",
"VKQGDDYV",
"YVHVVDGC",
"QDDKKIKA",
"MLVKQGDD",
"LVKQGDDY",
"EVVLKTGD",
"DDKKIKAC",
"YIFFASFY",
"EQRKQDDK",
"GDYFVLTS",
"NSSTCMMC",
"VGDYFVLT",
"FISDEVAR",
"VHVVDGCN",
"HVVDGCNS",
"VQMAPISA",
"SVEQRKQD",
"VEQRKQDD",
"KSYVHVVD",
"NVGDYFVL",
"SYVHVVDG",
"KDVVECLK",
"ISDEVARD",
"YKYFSGAM",
"KATNNAMQ",
"GTTTYKLN",
"MYIFFASF",
"EEVVLKTG",
"VVDGCNSS",
"CNSSTCMM",
"QKYSTLQG",
"LVQMAPIS",
"WEIVKFIS",
"DVVECLKL",
"IGPDMFLG",
"GLYPTLNI",
"RRCPAEIV",
"CRRCPAEI",
"RGTTTYKL",
"TMLVKQGD",
"GCNSSTCM",
"VDGCNSST",
"FSSNVANY",
"EDDYQGKP",
"YRGTTTYK",
"QMAPISAM",
"DGCNSSTC",
"PKEEVKPF",
"VRMYIFFA",
"SSNVANYQ",
"PRDLGACI",
"DYQGKPLE",
"LTSHTVMP",
"RMYIFFAS",
"ATNNAMQV",
"AMVRMYIF",
"VVECLKLS",
"VRITGLYP",
"KEIIFLEG",
"RITGLYPT",
"TSHTVMPL",
"NVANYQKV",
"YRKCVKSR",
"TKDVVECL",
"ITGLYPTL",
"IIFLEGET",
"MVRMYIFF",
"RKCVKSRE",
"VVYRGTTT",
"SNVANYQK",
"PQEHYVRI",
"LVPQEHYV",
"NLYDKLVS",
"HYVRITGL",
"VPQEHYVR",
"TGLYPTLN",
"GPDMFLGT",
"QEHYVRIT",
"HTMLVKQG",
"VYRGTTTY",
"ETKDVVEC",
"TCRRCPAE",
"PLEFGATS",
"MAPISAMV",
"YVRITGLY",
"PDMFLGTC",
"EHYVRITG",
"DYGDAVVY",
"AVVYRGTT",
"VANYQKVG",
"PKEIIFLE",
"VLTSHTVM",
"DAVVYRGT",
"KCVKSREE",
"EIPKEEVK",
"DDYQGKPL",
"YQGKPLEF",
"DVETKDVV",
"EIIFLEGE",
"VETKDVVE",
"SDVETKDV",
"IVDTVSAL",
"KPLEFGAT",
"ALLTLQQI",
"KSEKQVEQ",
"IPKEEVKP",
"EIVDTVSA",
"IKGTHHWL",
"YFSGAMDT",
"LYRKCVKS",
"TIKGTHHW",
"DTVSALVY",
"SFLEMKSE",
"PAEIVDTV",
"TVSALVYD",
"TEEVVLKT",
"LYDKLVSS",
"QGKPLEFG",
"MKSEKQVE",
"LYPTLNIS",
"LTEEVVLK",
"YGDAVVYR",
"VDTVSALV",
"GKPLEFGA",
"DSDVETKD",
"GDAVVYRG",
"EFSSNVAN",
"ANYQKVGM",
"MQKYSTLQ",
"SDEVARDL",
"GDSCNNYM",
"RTIKGTHH",
"AEIVDTVS",
"VSALVYDN",
"VDSDVETK",
"WDLLKYDF",
"GFVDSDVE",
"EMKSEKQV",
"KYFSGAMD",
"SAMVRMYI",
"KWDLLKYD",
"TGDSCNNY",
"GMQKYSTL",
"QGFVDSDV",
"PISAMVRM",
"SHTVMPLS",
"VGMQKYST",
"YQKVGMQK",
"FSGAMDTT",
"MDTTSYRE",
"RDLGACID",
"ATALLTLQ",
"QKVGMQKY",
"VTGDSCNN",
"HTVMPLSA",
"KVGMQKYS",
"ISAMVRMY",
"NYQKVGMQ",
"APKEIIFL",
"VGEGSEGL",
"PLKAPKEI",
"FLEMKSEK",
"LEMKSEKQ",
"MPLKAPKE",
"GLYRKCVK",
"APISAMVR",
"CPAEIVDT",
"DLLKYDFT",
"LLKYDFTE",
"IKWDLLKY",
"DLGACIDC",
"KAPKEIIF",
"RQGFVDSD",
"YIKWDLLK",
"FVDSDVET",
"LKAPKEII",
"TALLTLQQ",
"SVRVLQKA",
"YDKLVSSF",
"DKLVSSFL",
"GWEIVKFI",
"CVKSREET",
"TLVPQEHY",
"KSREETGL",
"KRTIKGTH",
"TVMPLSAP",
"SGAMDTTS",
"AEIPKEEV",
"VKSREETG",
"RCPAEIVD",
"GAMDTTSY",
"AMDTTSYR",
"NRNYVFTG",
"YNTYKNTC",
"LGACIDCS",
"IFLEGETL",
"IAEIPKEE",
"PTLVPQEH",
"FLEGETLP",
"VNKFLALC",
"APTLVPQE",
"QVRDVLVR",
"DMFLGTCR",
"VLTEEVVL",
"MFLGTCRR",
"SAPTLVPQ",
"KGLYRKCV",
"LSAPTLVP",
"ARQGFVDS",
"PLSAPTLV",
"DIEVTGDS",
"TFISAARQ",
"FISAARQG",
"LEGETLPT",
"GPERTCCL",
"RNYVFTGY",
"LNRNYVFT",
"STFISAAR",
"SAARQGFV",
"AARQGFVD",
"ISAARQGF",
"EVTGDSCN",
"DYNTYKNT",
"SKGLYRKC",
"DEVARDLS",
"KLVSSFLE",
"SDIEVTGD",
"LMPLKAPK",
"EGETLPTE",
"EETGLLMP",
"QSDIEVTG",
"LVNKFLAL",
"IDCSARHI",
"PDYNTYKN",
"PLNRNYVF",
"FFKLVNKF",
"VIPDYNTY",
"IPDYNTYK",
"VVIPDYNT",
"GACIDCSA",
"REETGLLM",
"LVSSFLEM",
"TVSVSSPD",
"KLVNKFLA",
"IEVTGDSC",
"CIDCSARH",
"VSSFLEMK",
"VMPLSAPT",
"SREETGLL",
"FGTVYEKL",
"IPARARVE",
"PAMHAASG",
"FKLVNKFL",
"MPLSAPTL",
"ETGLLMPL",
"LLMPLKAP",
"NKFLALCA",
"TFFKLVNK",
"HSKGLYRK",
"GLLMPLKA",
"QTFFKLVN",
"MVVIPDYN",
"ACIDCSAR",
"DGWEIVKF",
"VQTFFKLV",
"LKYDFTEE",
"NTYKNTCD",
"KESVQTFF",
"IDAMMFTS",
"TGLLMPLK",
"KYDFTEER",
"EIVGGQIV",
"SEKQVEQK",
"LNLGETFV",
"KVDTANPK",
"DFTEERLK",
"RDGWEIVK",
"ALNLGETF",
"TYKNTCDG",
"MMFTSDLA",
"YDFTEERL",
"AMMFTSDL",
"MCQPILLL",
"KQVEQKIA",
"QVEQKIAE",
"FTEERLKL",
"LMCQPILL",
"DAMMFTSD",
"KFLALCAD",
"EERLKLFD",
"EKQVEQKI",
"TEERLKLF",
"LTKEGATT",
"YDFVENPD",
"LQVRDVLV",
"IVGGQIVT",
"VEQKIAEI",
"PERTCCLC",
"ESVQTFFK",
"GETLPTEV",
"LKALNLGE",
"PYIKWDLL",
"EVLTEEVV",
"VVAFNTLL",
"KPYIKWDL",
"LTKPYIKW",
"FLGTCRRC",
"FLALCADS",
"TKPYIKWD",
"LGTCRRCP",
"DFVENPDI",
"SLRLIDAM",
"DLTKPYIK",
"VAFNTLLF",
"LRLIDAMM",
"LIDAMMFT",
"RLIDAMMF",
"ETLPTEVL",
"GTCRRCPA",
"TLDNQDLN",
"NLGETFVT",
"LDNQDLNG",
"SVQTFFKL",
"FVENPDIL",
"KLKALNLG",
"KALNLGET",
"AFNTLLFL",
"VFDKNLYD",
"MFTSDLAT",
"MHAASGNL",
"LRDGWEIV",
"EQKIAEIP",
"YSLRLIDA",
"ISQYSLRL",
"ERTCCLCD",
"IKESVQTF",
"SDLATNNL",
"DGISQYSL",
"FTSDLATN",
"LGETFVTH",
"ITGGVVQL",
"GETFVTHS",
"DLATNNLV",
"SSFLEMKS",
"GISQYSLR",
"QKIAEIPK",
"VLTLDNQD",
"LTLDNQDL",
"KGIKIQEG",
"GIKIQEGV",
"TSDLATNN",
"KIAEIPKE",
"IKIQEGVV",
"AVFDKNLY",
"SQYSLRLI",
"TLPTEVLT",
"TDLTKPYI",
"FVTHSKGL",
"AMHAASGN",
"HVVAFNTL",
"RTCCLCDR",
"GVLTLDNQ",
"VENPDILR",
"TGGVVQLT",
"ENPDILRV",
"LVYAADPA",
"YITGGVVQ",
"ARFYFYTS",
"VTHSKGLY",
"VGVLTLDN",
"KIQEGVVD",
"DILRVYAN",
"AKLKALNL",
"LATNNLVV",
"ALYNKYKY",
"YGARFYFY",
"EIKESVQT",
"THSKGLYR",
"TFVTHSKG",
"TNNAMQVE",
"SYYSLLMP",
"QYSLRLID",
"LAVFDKNL",
"DSYYSLLM",
"GARFYFYT",
"LALYNKYK",
"ETFVTHSK",
"ATNNLVVM",
"ATVSVSSP",
"VRVLQKAA",
"GGAKLKAL",
"GAKLKALN",
"TCCLCDRR",
"VDSYYSLL",
"TEVLTEEV",
"RYLALYNK",
"YLALYNKY",
"DNQDLNGN",
"PATVSVSS",
"IQEGVVDY",
"AKEIKESV",
"VVDSYYSL",
"ERLKLFDR",
"KEIKESVQ",
"LDGISQYS",
"GTVYEKLK",
"QLMCQPIL",
"PVVDSYYS",
"CCLCDRRA",
"LLVYAADP",
"KVPATVSV",
"IIGGAKLK",
"VLQVRDVL",
"YKGIKIQE",
"VFTTVDNI",
"IGGAKLKA",
"DPAMHAAS",
"KYKGIKIQ",
"WYDFVENP",
"DYGARFYF",
"VPVVDSYY",
"NRYLALYN",
"ASGNLLLD",
"HAASGNLL",
"GVPVVDSY",
"DTDLTKPY",
"IVGVLTLD",
"AASGNLLL",
"GIVGVLTL",
"ELLVYAAD",
"NQDLNGNW",
"FTTVDNIN",
"IDLDEWSM",
"AGIVGVLT",
"GGVVQLTS",
"ILDGISQY",
"NIFGTVYE",
"NAGIVGVL",
"IFGTVYEK",
"QDLNGNWY",
"VPATVSVS",
"YLAVFDKN",
"NDNTSRYW",
"SGVPVVDS",
"VVQLTSQW",
"LTNIFGTV",
"LIDSYFVV",
"QWLTNIFG",
"IDSYFVVK",
"GNLLLDKR",
"QEGVVDYG",
"WNLREMLA",
"RLKLFDRY",
"VQLTSQWL",
"WYDFGDFI",
"SGNLLLDK",
"GVVQLTSQ",
"NLLLDKRT",
"VDYGARFY",
"GVVDYGAR",
"LKLFDRYF",
"KLFDRYFK",
"WLTNIFGT",
"KIFVDGVP",
"LFDRYFKY",
"LALCADSI",
"DLNGNWYD",
"NWYDFGDF",
"NGNWYDFG",
"TVYEKLKP",
"VVDYGARF",
"LNGNWYDF",
"GNWYDFGD",
"VDTDLTKP",
"TNIFGTVY",
"PTEVLTEE",
"GIDLDEWS",
"DWYDFVEN",
"PPLNRNYV",
"GSGVPVVD",
"KELLVYAA",
"FGDFIQTT",
"EGVVDYGA",
"NNLVVMAY",
"YYSLLMPI",
"RNAGIVGV",
"LGIDLDEW",
"YDFGDFIQ",
"HTFSNYQH",
"RKIFVDGV",
"AYITGGVV",
"YNRYLALY",
"IFVDGVPF",
"NLIDSYFV",
"RHTFSNYQ",
"TFSNYQHE",
"RHFDEGNC",
"CLCDRRAT",
"VVMAYITG",
"LRHFDEGN",
"DFGDFIQT",
"ITILDGIS",
"HFDEGNCD",
"FSNYQHEE",
"NLVVMAYI",
"ALCADSII",
"CDAMRNAG",
"TNNLVVMA",
"LVVMAYIT",
"LPTEVLTE",
"LREMLAHA",
"FKELLVYA",
"AESHVDTD",
"TCAKEIKE",
"SHVDTDLT",
"ESHVDTDL",
"CAKEIKES",
"MRNAGIVG",
"VMAYITGG",
"FDEGNCDT",
"LCADSIII",
"DGVPFVVS",
"FDRYFKYW",
"KDWYDFVE",
"TILDGISQ",
"MAYITGGV",
"HVDTDLTK",
"QLTSQWLT",
"CCDDDYFN",
"CDDDYFNK",
"DAMRNAGI",
"VDGVPFVV",
"NCDTLKEI",
"RYFKYWDQ",
"AMRNAGIV",
"YFVVKRHT",
"DEGNCDTL",
"SYFVVKRH",
"KKDWYDFV",
"EGNCDTLK",
"REMLAHAE",
"DRYFKYWD",
"CDTLKEIL",
"DSYFVVKR",
"NLREMLAH",
"PLGIDLDE",
"GNCDTLKE",
"FVDGVPFV",
"SSRLSFKE",
"LTSQWLTN",
"LSFKELLV",
"RKYKGIKI",
"YFNKKDWY",
"LHSSRLSF",
"DYFNKKDW",
"LKEILVTY",
"HSSRLSFK",
"DTLKEILV",
"NLHSSRLS",
"EMLAHAEE",
"VKRHTFSN",
"YLTSSSKT",
"RLSFKELL",
"VRKIFVDG",
"DNTSRYWE",
"VVKRHTFS",
"TSQWLTNI",
"YFKYWDQT",
"FNKKDWYD",
"ALRHFDEG",
"SFKELLVY",
"GYLTSSSK",
"DDDYFNKK",
"SQWLTNIF",
"KRHTFSNY",
"DDYFNKKD",
"NKKDWYDF",
"TLKEILVT",
"SNYQHEET",
"SRLSFKEL",
"IIIGGAKL",
"SVSSPDAV",
"FVVSTGYH",
"NGYLTSSS",
"VYALRHFD",
"PFVVSTGY",
"FVVKRHTF",
"YALRHFDE",
"ILVTYNCC",
"GGCVFSYV",
"LQKAAITI",
"EILVTYNC",
"VSVSSPDA",
"AITILDGI",
"VVSTGYHF",
"VPFVVSTG",
"AFGGCVFS",
"YHFRELGV",
"DVNLHSSR",
"DNLIDSYF",
"GVPFVVST",
"KEILVTYN",
"NCCDDDYF",
"VSTGYHFR",
"LKKSLNVA",
"QDVNLHSS",
"LVRKIFVD",
"DLDEWSMA",
"GYHFRELG",
"QKAAITIL",
"VNLHSSRL",
"LTSSSKTP",
"VTYNCCDD",
"LVTYNCCD",
"QHEETIYN",
"NPDILRVY",
"ATAQEAYE",
"TGYHFREL",
"KLKKSLNV",
"STGYHFRE",
"PDILRVYA",
"IAFGGCVF",
"RVLQKAAI",
"VLQKAAIT",
"YNCCDDDY",
"KSLNVAKS",
"KKSLNVAK",
"DSIIIGGA",
"TYNCCDDD",
"NYQHEETI",
"FATAQEAY",
"EHFIETIS",
"YQHEETIY",
"PLVRKIFV",
"TVKGLDYK",
"LQQLRVES",
"AVANGDSE",
"SIIIGGAK",
"HEETIYNL",
"EEHFIETI",
"KAAITILD",
"NTSRYWEP",
"NQDVNLHS",
"LVYALRHF",
"AAITILDG",
"LQPVSELL",
"DLVYALRH",
"ADSIIIGG",
"HNQDVNLH",
"QYNRYLAL",
"CADSIIIG",
"VANGDSEV",
"ELGTEVNE",
"EETIYNLL",
"TSSSKTPE",
"MLAHAEET",
"VSSPDAVT",
"FGGCVFSY",
"LGTEVNEF",
"TLQPVSEL",
"HFRELGVV",
"FRELGVVH",
"KTLQPVSE",
"NCVNCLDD",
"YNGYLTSS",
"SSSKTPEE",
"ADLVYALR",
"TTTLNDFN",
"TPLGIDLD",
"PNCVNCLD",
"YHPNCVNC",
"NGDSEVVL",
"ETVKGLDY",
"HPNCVNCL",
"ANGDSEVV",
"LDDRCILH",
"VETVKGLD",
"CLDDRCIL",
"VMVELVAE",
"FTTTLNDF",
"HVMVELVA",
"GHVMVELV",
"DDRCILHC",
"RTAPHGHV",
"SSKTPEEH",
"FVETVKGL",
"KKLKKSLN",
"GTEVNEFA",
"VSELLTPL",
"PEEHFIET",
"IYNLLKDC",
"SKTPEEHF",
"SYAAFATA",
"FKYWDQTY",
"LKKLKKSL",
"NCLDDRCI",
"GCVFSYVG",
"CVFSYVGC",
"RELGVVHN",
"CVNCLDDR",
"KYWDQTYH",
"AYNGYLTS",
"HGHVMVEL",
"VNCLDDRC",
"YAAFATAQ",
"GVVHNQDV",
"LGVVHNQD",
"ELGVVHNQ",
"RKLMPVCV",
"LTPLGIDL",
"QIGVVREF",
"SELLTPLG",
"HFIETISL",
"VVHNQDVN",
"VYLAVFDK",
"TAYNGYLT",
"AAFATAQE",
"YWDQTYHP",
"YAADPAMH",
"FSYVGCHN",
"VHNQDVNL",
"YNLLKDCP",
"VGGQIVTC",
"VFSYVGCH",
"VTAYNGYL",
"VLKKLKKS",
"TPEEHFIE",
"KTPEEHFI",
"YKNTCDGT",
"QPVSELLT",
"FIETISLA",
"ELLTPLGI",
"RQRLTKYT",
"LLTPLGID",
"HCANFNVL",
"DAVTAYNG",
"IGVVREFL",
"GDSEVVLK",
"PDAVTAYN",
"FGPLVRKI",
"APHGHVMV",
"VVLKKLKK",
"DWLEEKFK",
"AFATAQEA",
"EVVLKKLK",
"LDWLEEKF",
"CANFNVLF",
"LTKYTMAD",
"NTCDGTTF",
"NRFTTTLN",
"TAPHGHVM",
"SYVGCHNK",
"KYTMADLV",
"LHCANFNV",
"NEFACVVA",
"RCILHCAN",
"VYAADPAM",
"YTMADLVY",
"TKYTMADL",
"IETISLAG",
"NNAMQVES",
"KNTCDGTT",
"SEVVLKKL",
"PHGHVMVE",
"GPLVRKIF",
"ETIYNLLK",
"DRCILHCA",
"AVTAYNGY",
"PSYAAFAT",
"SPDAVTAY",
"TTLNDFNL",
"QTYHPNCV",
"TYHPNCVN",
"TMADLVYA",
"GVVREFLT",
"GCHNKCAY",
"CILHCANF",
"SSPDAVTA",
"SFGPLVRK",
"ILHCANFN",
"NLLKDCPA",
"DSEVVLKK",
"EVARDLSL",
"SLLMPILT",
"PVSELLTP",
"TIYNLLKD",
"MADLVYAL",
"GGQIVTCA",
"FLRDGWEI",
"MVELVAEL",
"QRLTKYTM",
"AKHDFFKF",
"DQTYHPNC",
"VYEKLKPV",
"LLKDCPAV",
"RFTTTLND",
"VNEFACVV",
"RLTKYTMA",
"LLMPILTL",
"GFDVEGCH",
"WDQTYHPN",
"YSLLMPIL",
"LPSYAAFA",
"CDGTTFTY",
"VAKHDFFK",
"VKGLDYKA",
"TSRYWEPE",
"HIQWMVMF",
"VMFTPLVP",
"IQWMVMFT",
"DYKAFKQI",
"LDYKAFKQ",
"NFNVLFST",
"YVGCHNKC",
"LEEKFKEG",
"AFVETVKG",
"FNVLFSTV",
"LAHAEETR",
"GLDYKAFK",
"QWMVMFTP",
"VGCHNKCA",
"KGLDYKAF",
"EFLRDGWE",
"TSFGPLVR",
"ETISLAGS",
"ADPAMHAA",
"YEKLKPVL",
"LMPILTLT",
"IKTLQPVS",
"LKVPATVS",
"AADPAMHA",
"MVMFTPLV",
"WIGFDVEG",
"WMVMFTPL",
"SLKVPATV",
"EEKFKEGV",
"CHNKCAYW",
"EKLKPVLD",
"EFACVVAD",
"NVLFSTVF",
"VLFSTVFP",
"VIKTLQPV",
"TSMKYFVK",
"VIHFGAGS",
"AVAKHDFF",
"EVNEFACV",
"ACVVADAV",
"TLNDFNLV",
"YLNTLTLA",
"YKDWSYSG",
"SAFVETVK",
"LTSMKYFV",
"ANFNVLFS",
"MRVIHFGA",
"KLMPVCVE",
"LNTLTLAV",
"WLEEKFKE",
"ELTSMKYF",
"MRSLKVPA",
"IGFDVEGC",
"LNIIPLTT",
"NMRVIHFG",
"VVADAVIK",
"RAWIGFDV",
"MPILTLTR",
"RVIHFGAG",
"AWIGFDVE",
"VRAWIGFD",
"FELTSMKY",
"HNKCAYWV",
"ESGLKTIL",
"NTLTLAVP",
"TLTRALTA",
"GSYKDWSY",
"MPVCVETK",
"TCDGTTFT",
"PLVPFWIT",
"LMPVCVET",
"NKCAYWVP",
"LTLAVPYN",
"FTPLVPFW",
"LTRALTAE",
"TIAFGGCV",
"TRALTAES",
"SYKDWSYS",
"LTLTRALT",
"RSLKVPAT",
"PILTLTRA",
"FACVVADA",
"HVRAWIGF",
"QQLRVESS",
"NESGLKTI",
"VEFLRDGW",
"TLTLAVPY",
"PAVAKHDF",
"LVPFWITI",
"AVPYNMRV",
"TPLVPFWI",
"LKPVLDWL",
"TLAVPYNM",
"KLKPVLDW",
"ILTLTRAL",
"TEVNEFAC",
"RALTAESH",
"MFTPLVPF",
"LAVPYNMR",
"NIIPLTTA",
"ALTAESHV",
"AGSYKDWS",
"VPYNMRVI",
"PYNMRVIH",
"CPAVAKHD",
"KPVLDWLE",
"LTAESHVD",
"YNMRVIHF",
"ADAVIKTL",
"VADAVIKT",
"DCPAVAKH",
"TAESHVDT",
"KCAYWVPR",
"PVCVETKA",
"ISLAGSYK",
"SLEIPRRN",
"LEIPRRNV",
"GFELTSMK",
"SLPSYAAF",
"RFYFYTSK",
"SHVVAFNT",
"GQIVTCAK",
"VLDWLEEK",
"TISLAGSY",
"SLAGSYKD",
"EKFKEGVE",
"VLLSVLQQ",
"QIVTCAKE",
"CVVADAVI",
"AFEKMVSL",
"EAFEKMVS",
"LLSVLQQL",
"KMVSLLSV",
"EKMVSLLS",
"PVLDWLEE",
"MVSLLSVL",
"LVSDIDIT",
"IHFGAGSD",
"TSAFVETV",
"TEAFEKMV",
"SLLSVLLS",
"QLRVESSS",
"VSLLSVLL",
"LLSVLLSM",
"STSAFVET",
"FLLPSLAT",
"CVPLNIIP",
"VCVETKAI",
"TILRKGGR",
"FEKMVSLL",
"QLHNDILL",
"CAYWVPRA",
"LAKDTTEA",
"LAGSYKDW",
"KTILRKGG",
"GCVPLNII",
"RTIAFGGC",
"ILLAKDTT",
"LKTILRKG",
"DAVIKTLQ",
"FDVEGCHA",
"AKDTTEAF",
"TTEAFEKM",
"LKDCPAVA",
"ASTSAFVE",
"LLAKDTTE",
"LNDFNLVA",
"SSLPSYAA",
"LLSMQGAV",
"IVTCAKEI",
"HNDILLAK",
"DTTEAFEK",
"KDTTEAFE",
"LSVLQQLR",
"FSSLPSYA",
"LHNDILLA",
"TLVSDIDI",
"SKEGFFTY",
"LLPSLATV",
"VVLLSVLQ",
"VTCAKEIK",
"EFSSLPSY",
"KDCPAVAK",
"NDILLAKD",
"TQYNRYLA",
"GLKTILRK",
"CVETKAIV",
"AHAEETRK",
"VEGCHATR",
"DILLAKDT",
"TLQAENVT",
"SVLQQLRV",
"FTYICGFI",
"GRTIAFGG",
"SVLLSMQG",
"DGCVPLNI",
"EGCHATRE",
"ATVAYFNM",
"KEGFFTYI",
"AVIKTLQP",
"DVEGCHAT",
"SEFSSLPS",
"QRKYKGIK",
"VLQQLRVE",
"EGFFTYIC",
"VETKAIVS",
"GCHATREA",
"VLLSMQGA",
"LRVESSSK",
"RVESSSKL",
"LQAIASEF",
"YICGFIQQ",
"LSMQGAVD",
"QAIASEFS",
"SGLKTILR",
"SKLWAQCV",
"SLNVAKSE",
"LPSLATVA",
"TYICGFIQ",
"FGAGSDKG",
"LNVAKSEF",
"NVAKSEFD",
"LSVLLSMQ",
"NRATLQAI",
"HFGAGSDK",
"ETKAIVST",
"RKGGRTIA",
"AIASEFSS",
"SMQGAVDI",
"GGRTIAFG",
"LATVAYFN",
"IASEFSSL",
"FTSLEIPR",
"MQGAVDIN",
"SLATVAYF",
"PSLATVAY",
"VSTIQRKY",
"TVAYFNMV",
"ILRKGGRT",
"TIQRKYKG",
"TLQAIASE",
"IQRKYKGI",
"RATLQAIA",
"QGAVDINK",
"ASEFSSLP",
"IVSTIQRK",
"LDNRATLQ",
"ATLQAIAS",
"VPFWITIA",
"TSLEIPRR",
"SQLMCQPI",
"DNRATLQA",
"VPLNIIPL",
"PFWITIAY",
"RHVRAWIG",
"LRKGGRTI",
"EIPRRNVA",
"TKAIVSTI",
"STIQRKYK",
"KGGRTIAF",
"HNESGLKT",
"ESSSKLWA",
"SVVLLSVL",
"SSSKLWAQ",
"KHDFFKFR",
"ATLVSDID",
"VESSSKLW",
"PRRNVATL",
"HGFELTSM",
"SSKLWAQC",
"VARDLSLQ",
"TTVDNINL",
"GAGSDKGV",
"FFTYICGF",
"CEEMLDNR",
"GFFTYICG",
"KAIVSTIQ",
"IPRRNVAT",
"PLNIIPLT",
"HDFFKFRI",
"KLWAQCVQ",
"WAQCVQLH",
"PVLQVRDV",
"LWAQCVQL",
"EVGPEHSL",
"AIVSTIQR",
"EEMLDNRA",
"PEHSLAEY",
"AQCVQLHN",
"VAKSEFDR",
"DFFKFRID",
"VGPEHSLA",
"VATLQAEN",
"AHGFELTS",
"AYWVPRAS",
"YWVPRASA",
"NDSKEGFF",
"FVSDADST",
"LQAENVTG",
"CHATREAV",
"KSEFDRDA",
"RDGCVPLN",
"ATLQAENV",
"AIRHVRAW",
"NSEVGPEH",
"QCVQLHND",
"ATREAVGT",
"VQLHNDIL",
"CVQLHNDI",
"IIPLTTAA",
"AGSDKGVA",
"NVATLQAE",
"DFVSDADS",
"SEVGPEHS",
"FFKFRIDG",
"LQFKRPIN",
"ENDSKEGF",
"SDADSTLI",
"AKSEFDRD",
"GPEHSLAE",
"PLTTAAKL",
"DSKEGFFT",
"DLIISDMY",
"IPLTTAAK",
"QAENVTGL",
"FKFRIDGD",
"AVLRQWLP",
"TAVLRQWL",
"EAIRHVRA",
"WVPRASAN",
"ARDGCVPL",
"EEAIRHVR",
"SATLVSDI",
"GSDKGVAP",
"EMLDNRAT",
"DADSTLIG",
"REEAIRHV",
"VSDADSTL",
"VKIYCPAC",
"YHNESGLK",
"SDKGVAPG",
"NDFVSDAD",
"FYFYTSKT",
"LIISDMYD",
"MLDNRATL",
"HATREAVG",
"KWDLIISD",
"YSQLMCQP",
"DKGVAPGT",
"LTTAAKLM",
"AENVTGLF",
"APGTAVLR",
"YFYTSKTT",
"HSLAEYHN",
"ANKWDLII",
"FRIDGDMV",
"NKWDLIIS",
"ARDLSLQF",
"KFRIDGDM",
"VAPGTAVL",
"AEYHNESG",
"GTAVLRQW",
"VDINKLCE",
"WDLIISDM",
"LNDFVSDA",
"RDLSLQFK",
"LAEYHNES",
"DINKLCEE",
"AVDINKLC",
"LLVDSDLN",
"GVAPGTAV",
"SLAEYHNE",
"KGVAPGTA",
"NNARDGCV",
"PGTAVLRQ",
"GAVDINKL",
"NAVVKIYC",
"TANKWDLI",
"SRYWEPEF",
"NARDGCVP",
"QNAVVKIY",
"GTLLVDSD",
"EHSLAEYH",
"CHNSEVGP",
"TLLVDSDL",
"VPRASANI",
"DLNDFVSD",
"LDNDALNN",
"EYHNESGL",
"KENDSKEG",
"DSTLIGDC",
"AVVKIYCP",
"ADSTLIGD",
"ENVTGLFK",
"TTAAKLMV",
"SLQFKRPI",
"IINNARDG",
"DLSLQFKR",
"TREEAIRH",
"NVTGLFKD",
"KLDNDALN",
"DSATLVSD",
"DNDALNNI",
"LNNIINNA",
"TKNVTKEN",
"HTANKWDL",
"TVDNINLH",
"SRQRLTKY",
"LSLQFKRP",
"NNIINNAR",
"MLRKLDND",
"VTGLFKDC",
"TMLRKLDN",
"KSKCEESS",
"HNSEVGPE",
"NIINNARD",
"SEFDRDAA",
"INNARDGC",
"WAHGFELT",
"FTMLRKLD",
"VHTANKWD",
"KFKEGVEF",
"ISRQRLTK",
"HISRQRLT",
"RKLDNDAL",
"PRASANIG",
"REAVGTNL",
"RNVATLQA",
"SDLNDFVS",
"LRKLDNDA",
"WLPTGTLL",
"PTGTLLVD",
"LPTGTLLV",
"DALNNIIN",
"TREAVGTN",
"RRNVATLQ",
"PHISRQRL",
"LVDSDLND",
"ALNNIINN",
"KTKNVTKE",
"NVYLAVFD",
"STLIGDCA",
"NDALNNII",
"VDSDLNDF",
"NTLNDLNE",
"NKLCEEML",
"TGTLLVDS",
"TGLFKDCS",
"KIYCPACH",
"INTLNDLN",
"DMVPHISR",
"VPHISRQR",
"GDMVPHIS",
"FKEGVEFL",
"TVHTANKW",
"MVPHISRQ",
"MMGFKMNY",
"LGYFCTCY",
"FYTSKTTV",
"MLVYCFLG",
"LVYCFLGY",
"SMMGFKMN",
"FLGYFCTC",
"DSDLNDFV",
"LINTLNDL",
"FDGKSKCE",
"GYFCTCYF",
"GKSKCEES",
"CATVHTAN",
"VLRQWLPT",
"IGDCATVH",
"PQNAVVKI",
"IISDMYDP",
"DGKSKCEE",
"TLIGDCAT",
"EAVGTNLP",
"LIGDCATV",
"INKLCEEM",
"KLCEEMLD",
"DCATVHTA",
"LCEEMLDN",
"DGDMVPHI",
"GDCATVHT",
"SDMYDPKT",
"ATVHTANK",
"VFDGKSKC",
"RIDGDMVP",
"TKENDSKE",
"IDGDMVPH",
"TLNDLNET",
"IMLVYCFL",
"IVFDGKSK",
"ISMMGFKM",
"VIVFDGKS",
"LISMMGFK",
"ISDMYDPK",
"YFCTCYFG",
"HPDSATLV",
"NVTKENDS",
"ANIGCNHT",
"CIMLVYCF",
"QWLPTGTL",
"HAEETRKL",
"GLFKDCSK",
"EFDRDAAM",
"LNDLNETL",
"INVIVFDG",
"VTKENDSK",
"RASANIGC",
"SLINTLND",
"ITREEAIR",
"NVIVFDGK",
"ACHNSEVG",
"GLHPTQAP",
"RLISMMGF",
"ASANIGCN",
"LWAHGFEL",
"TAAKLMVV",
"QCIMLVYC",
"PDSATLVS",
"TVASLINT",
"LRQWLPTG",
"AVGTNLPL",
"VVKIYCPA",
"VGTNLPLQ",
"TCYFGLFC",
"DMYDPKTK",
"NKLKAHKD",
"AEETRKLM",
"VLWAHGFE",
"YYSQLMCQ",
"KEGVEFLR",
"LHPTQAPT",
"MYDPKTKN",
"YDPKTKNV",
"TKEGATTC",
"KNVTKEND",
"GTNLPLQL",
"VASLINTL",
"KEGATTCG",
"CYFGLFCL",
"YFGLFCLL",
"FITREEAI",
"RQWLPTGT",
"PACHNSEV",
"LFKDCSKV",
"NLPLQLGF",
"ASLINTLN",
"TYRRLISM",
"TNLPLQLG",
"FVLWAHGF",
"LPLQLGFS",
"IYCPACHN",
"SANIGCNH",
"TQLCQYLN",
"FKDCSKVI",
"NIGCNHTG",
"MTYRRLIS",
"KLKAHKDK",
"PINVIVFD",
"PLQLGFST",
"RRLISMMG",
"TGLHPTQA",
"FGLFCLLN",
"DMTYRRLI",
"YCPACHNS",
"KDMTYRRL",
"MLSDTLKN",
"LPVLQVRD",
"QMLSDTLK",
"VYCFLGYF",
"QLCQYLNT",
"YRRLISMM",
"EETRKLMP",
"GVEFLRDG",
"EGVEFLRD",
"LQLGFSTG",
"FDRDAAMQ",
"KFKTEGLC",
"LPQNAVVK",
"LHPDSATL",
"SKVITGLH",
"FKTEGLCV",
"CYLATALL",
"CPACHNSE",
"DPKTKNVT",
"ERHSLSHF",
"KDCSKVIT",
"RHSLSHFV",
"PKTKNVTK",
"LSLPVLQV",
"DCSKVITG",
"QLGFSTGV",
"VYYSQLMC",
"NTDFSRVS",
"CSKVITGL",
"VYYGNALD",
"LIPLMYKG",
"GFKMNYQV",
"YTQLCQYL",
"TEGLCVDI",
"LPINVIVF",
"KTEGLCVD",
"HLIPLMYK",
"ITGLHPTQ",
"VVGEGSEG",
"APTHLSVD",
"DTLKNLSD",
"AAKLMVVI",
"TEETFKLS",
"SVYYSQLM",
"ISTKHFYW",
"VDNINLHT",
"STKHFYWF",
"LGFSTGVN",
"HPTQAPTH",
"QFKHLIPL",
"DRDAAMQR",
"FKLSYGIA",
"VFVLWAHG",
"EETFKLSY",
"CISTKHFY",
"TDFSRVSA",
"ICISTKHF",
"NNCYLATA",
"MGFKMNYQ",
"ASVYYSQL",
"YSHVVAFN",
"TQAPTHLS",
"KSASVYYS",
"SDTLKNLS",
"LSDTLKNL",
"RDAAMQRK",
"FKMNYQVN",
"PTQAPTHL",
"IICISTKH",
"TLKNLSDR",
"FKHLIPLM",
"DQFKHLIP",
"PGDQFKHL",
"ETFKLSYG",
"SASVYYSQ",
"GDQFKHLI",
"YIICISTK",
"SDRVVFVL",
"PTGYVDTP",
"FCTCYFGL",
"KHLIPLMY",
"QAPTHLSV",
"TKHFYWFF",
"ATEETFKL",
"CGYLPQNA",
"NCYLATAL",
"FSRVSAKP",
"VITGLHPT",
"KMNYQVNG",
"LQCIMLVY",
"CTCYFGLF",
"YMRSLKVP",
"PLTSFGPL",
"YLPQNAVV",
"GFSTGVNL",
"DRVVFVLW",
"FSTGVNLV",
"DFSRVSAK",
"MNYQVNGY",
"KVITGLHP",
"KGLPWNVV",
"ETRKLMPV",
"QLSLPVLQ",
"VFPLTSFG",
"YKGLPWNV",
"FPLTSFGP",
"RVVFVLWA",
"VVFVLWAH",
"TCGYLPQN",
"TLQCIMLV",
"SLPVLQVR",
"YERHSLSH",
"PPGDQFKH",
"VPTGYVDT",
"SRVSAKPP",
"LTSFGPLV",
"DAAMQRKL",
"NYQVNGYP",
"LMYKGLPW",
"LKNLSDRV",
"YQVNGYPN",
"TVFPLTSF",
"PLMYKGLP",
"KPPPGDQF",
"YCFLGYFC",
"TTVASLIN",
"YTSKTTVA",
"NTLQCIML",
"RVSAKPPP",
"VTVKNGSI",
"TFKLSYGI",
"VSAKPPPG",
"DNNCYLAT",
"LRANNTKG",
"IPLMYKGL",
"MYKGLPWN",
"EGATTCGY",
"SVTVKNGS",
"VHFISNSW",
"TYERHSLS",
"TTCGYLPQ",
"PPPGDQFK",
"MFITREEA",
"KTVQFCDA",
"KTTVASLI",
"GSIHLYFD",
"FSTVFPLT",
"LFSTVFPL",
"LDNLRANN",
"AKPPPGDQ",
"VKNGSIHL",
"SLPINVIV",
"LCQYLNTL",
"SAKPPPGD",
"IHLYFDKA",
"NGSIHLYF",
"CQYLNTLT",
"NLRANNTK",
"STVFPLTS",
"SKTTVASL",
"HLYFDKAG",
"VNLVAVPT",
"PWNVVRIK",
"NLVAVPTG",
"LVAVPTGY",
"WNVVRIKI",
"GYLPQNAV",
"GATTCGYL",
"TSKTTVAS",
"KNGSIHLY",
"QYLNTLTL",
"ATTCGYLP",
"STGVNLVA",
"CFLGYFCT",
"DNLRANNT",
"TVKNGSIH",
"LSDRVVFV",
"GVVGEGSE",
"ETFYPKLQ",
"NLSDRVVF",
"SIHLYFDK",
"TSVVLLSV",
"GSLPINVI",
"VETFYPKL",
"NLHPDSAT",
"LYFDKAGQ",
"GVNLVAVP",
"KYTQLCQY",
"KGSLPINV",
"VAVPTGYV",
"KNLSDRVV",
"GNLHPDSA",
"NMFITREE",
"VQLSLPVL",
"EGLCVDIP",
"AVPTGYVD",
"AKLMVVIP",
"TFYPKLQS",
"HVQLSLPV",
"NDFNLVAM",
"TGVNLVAV",
"THVQLSLP",
"DFNLVAMK",
"RVVFNGVS",
"CTSVVLLS",
"TKKAGGTT",
"KKAGGTTE",
"TVQFCDAM",
"LMVVIPDY",
"NTKGSLPI",
"RRVVFNGV",
"PTKKAGGT",
"KLSYGIAT",
"RSDVLLPL",
"TKGSLPIN",
"NNTKGSLP",
"TEISFMLW",
"FYPKLQSS",
"AGGTTEML",
"GLPWNVVR",
"EISFMLWC",
"SVTSNYSG",
"LPWNVVRI",
"YTEISFML",
"KLMVVIPD",
"ISVTSNYS",
"KTYERHSL",
"KATEETFK",
"FMLWCKDG",
"ISFMLWCK",
"AAMQRKLE",
"PNMFITRE",
"QVNGYPNM",
"VQFCDAMR",
"VNGYPNMF",
"QKTYERHS",
"IISVTSNY",
"RYMRSLKV",
"YPKLQSSQ",
"FCDAMRNA",
"GLCVDIPG",
"KAGGTTEM",
"GYPNMFIT",
"AYIICIST",
"DYTEISFM",
"NGYPNMFI",
"YPNMFITR",
"IPTKKAGG",
"IAYIICIS",
"QFCDAMRN",
"VIPTKKAG",
"TIAYIICI",
"WITIAYII",
"SFMLWCKD",
"IDYTEISF",
"ITIAYIIC",
"GVSFSTFE",
"NGVSFSTF",
"YFDKAGQK",
"TRKLMPVC",
"PKLQSSQA",
"LSYGIATV",
"KLQSSQAW",
"SFSTFEEA",
"HVETFYPK",
"VTSNYSGV",
"VSFSTFEE",
"FNGVSFST",
"FDKAGQKT",
"KCTSVVLL",
"GHVETFYP",
"LQSSQAWQ",
"DGHVETFY",
"SALVYDNK",
"GQKTYERH",
"VQMLSDTL",
"LCVDIPGI",
"LKATEETF",
"ALVYDNKL",
"ARYMRSLK",
"MWALIISV",
"GLFCLLNR",
"KDGHVETF",
"NGNLHPDS",
"ANNTKGSL",
"VVFNGVSF",
"DKAGQKTY",
"ALIISVTS",
"SMWALIIS",
"LIISVTSN",
"WALIISVT",
"KAGQKTYE",
"CKDGHVET",
"FWITIAYI",
"LFCLLNRY",
"INGNLHPD",
"CLLNRYFR",
"AGQKTYER",
"HSLSHFVN",
"PKDMTYRR",
"FNLVAMKY",
"VYDNKLKA",
"FCLLNRYF",
"IVQMLSDT",
"LVYDNKLK",
"SDVKCTSV",
"VKCTSVVL",
"DVKCTSVV",
"AQEAYEQA",
"VFNGVSFS",
"YEQAVANG",
"TSNYSGVV",
"IPKDMTYR",
"NLVAMKYN",
"IFFITGNT",
"IDINGNLH",
"DINGNLHP",
"VAMKYNYE",
"IKVATVQS",
"RPPLNRNY",
"PCIKVATV",
"LTQYNRYL",
"TAQEAYEQ",
"SNYSGVVT",
"DNKLKAHK",
"PINPTDQS",
"YIDINGNL",
"YDNKLKAH",
"KVATVQSK",
"GGKPCIKV",
"FKLNIKLL",
"GKPCIKVA",
"EAYEQAVA",
"QEAYEQAV",
"EQAVANGD",
"SLSHFVNL",
"KPCIKVAT",
"RANNTKGS",
"KLNIKLLG",
"VVIPTKKA",
"LVAMKYNY",
"QAVANGDS",
"AFKLNIKL",
"MSDVKCTS",
"AYEQAVAN",
"FKRPINPT",
"WCKDGHVE",
"SKMSDVKC",
"MLWCKDGH",
"KMSDVKCT",
"KIVQMLSD",
"LWCKDGHV",
"RPINPTDQ",
"YYGNALDQ",
"QSKMSDVK",
"CIKVATVQ",
"KRPINPTD",
"VQSKMSDV",
"VATVQSKM",
"YGNALDQA",
"DAFKLNIK",
"TVQSKMSD",
"VYDYLVST",
"KYNYEPLT",
"NPTDQSSY",
"ATVQSKMS",
"IDAFKLNI",
"IKIVQMLS",
"YDYLVSTQ",
"TQEFRYMN",
"LSHFVNLD",
"LKVGGSCV",
"INPTDQSS",
"VSTQEFRY",
"FVNLDNLR",
"QEFRYMNS",
"PTDQSSYI",
"MKYNYEPL",
"STQEFRYM",
"SIDAFKLN",
"ITGNTLQC",
"PLTQYNRY",
"AARYMRSL",
"GIPKDMTY",
"LVSTQEFR",
"VPGFNEKT",
"NSIDAFKL",
"PIFFITGN",
"DYLVSTQE",
"YLVSTQEF",
"TDQSSYIV",
"SHFVNLDN",
"TGVVGEGS",
"HFVNLDNL",
"PGFNEKTH",
"FRYMNSQG",
"EFRYMNSQ",
"NLDNLRAN",
"HTGVVGEG",
"CNHTGVVG",
"RIKIVQML",
"TGNTLQCI",
"LPLTQYNR",
"VVRIKIVQ",
"QFKRPINP",
"VVREFLTR",
"GNTLQCIM",
"NEKTHVQL",
"RYMNSQGL",
"FITGNTLQ",
"FNEKTHVQ",
"KNSIDAFK",
"GFNEKTHV",
"VRIKIVQM",
"PKNSIDAF",
"PPKNSIDA",
"NHTGVVGE",
"KVGGSCVL",
"KTHVQLSL",
"ESLVPGFN",
"LVPGFNEK",
"EKTHVQLS",
"SLVPGFNE",
"PISFPLCA",
"VMFLARGI",
"VNLDNLRA",
"MFLARGIV",
"FFITGNTL",
"NVVRIKIV",
"VREFLTRN",
"AMKYNYEP",
"LLNRYFRL",
"GCNHTGVV",
"PRPPLNRN",
"LNRYFRLT",
"LKSAYENF",
"PLKVGGSC",
"NGPLKVGG",
"KSAYENFN",
"NAMQVESD",
"EYSHVVAF",
"SDVLLPLT",
"ISFPLCAN",
"DVLLPLTQ",
"GPLKVGGS",
"EVLSDREL",
"AISMWALI",
"VDIPGIPK",
"DIPGIPKD",
"PGIPKDMT",
"LLPLTQYN",
"RYFRLTLG",
"SVDTKFKT",
"LSVDTKFK",
"VGGSCVLS",
"VLLPLTQY",
"LLKSAYEN",
"CVDIPGIP",
"ISMWALII",
"PLLSAGIF",
"VDTKFKTE",
"IPGIPKDM",
"QLLKSAYE",
"IQLLKSAY",
"NYLKRRVV",
"IGCNHTGV",
"LKRRVVFN",
"KRRVVFNG",
"YLKRRVVF",
"NRYFRLTL",
"VREVLSDR",
"TKFKTEGL",
"DTKFKTEG",
"LAKHCLHV",
"SAYENFNQ",
"KHFYWFFS",
"VNKGEDIQ",
"NVNKGEDI",
"LLSAGIFG",
"KGEDIQLL",
"HFYWFFSN",
"GEDIQLLK",
"NKGEDIQL",
"NLAKHCLH",
"REVLSDRE",
"LSAGIFGA",
"YWFFSNYL",
"GGSCVLSG",
"FYWFFSNY",
"SYGIATVR",
"AMQVESDD",
"YGIATVRE",
"PTHLSVDT",
"YYFMRFRR",
"HVVGPNVN",
"TRVECTTI",
"LHVVGPNV",
"ATRVECTT",
"THLSVDTK",
"RATRVECT",
"AKHCLHVV",
"HLSVDTKF",
"GEYSHVVA",
"ADNNCYLA",
"GIVFMCVE",
"IKLLGVGG",
"GNALDQAI",
"IVFMCVEY",
"NRATRVEC",
"RNRATRVE",
"YKRNRATR",
"LNIKLLGV",
"KRNRATRV",
"NIKLLGVG",
"NALDQAIS",
"ATVREVLS",
"DIQLLKSA",
"YENFNQHE",
"TNGPLKVG",
"LLGVGGKP",
"LQFTSLEI",
"QFTSLEIP",
"REFLTRNP",
"YFMRFRRA",
"MCYKRNRA",
"DKLQFTSL",
"PNVNKGED",
"KLQFTSLE",
"CYKRNRAT",
"KLLGVGGK",
"YDKLQFTS",
"CLHVVGPN",
"MMCYKRNR",
"AYENFNQH",
"EDIQLLKS",
"ATNGPLKV",
"CMMCYKRN",
"EEAARYMR",
"RGIVFMCV",
"ALDQAISM",
"VGGKPCIK",
"TVREVLSD",
"SFPLCANG",
"LGVGGKPC",
"GIATVREV",
"VVGPNVNK",
"YFRLTLGV",
"LGVYDYLV",
"SSTCMMCY",
"GVYDYLVS",
"GVGGKPCI",
"MQVESDDY",
"KHCLHVVG",
"LVTMPLGY",
"VLSGHNLA",
"LAPLLSAG",
"TCMMCYKR",
"VTMPLGYV",
"SCVLSGHN",
"FRLTLGVY",
"LLPPKNSI",
"VLLAPLLS",
"ICGFIQQK",
"IATVREVL",
"GSCVLSGH",
"GPNVNKGE",
"CVLSGHNL",
"DQAISMWA",
"LDQAISMW",
"CGFIQQKL",
"NSQGLLPP",
"VGPNVNKG",
"YMNSQGLL",
"WKYPQVNG",
"TMPLGYVT",
"APLLSAGI",
"LYDKLQFT",
"ETLVTMPL",
"ENFNQHEV",
"LSGHNLAK",
"HNLAKHCL",
"GLLPPKNS",
"HCLHVVGP",
"TLVTMPLG",
"MNSQGLLP",
"KCEESSAK",
"YPTLNISD",
"LPPKNSID",
"SKCEESSA",
"STCMMCYK",
"LARGIVFM",
"GFIQQKLA",
"AKYTQLCQ",
"ARGIVFMC",
"SQGLLPPK",
"RLTLGVYD",
"DEFSSNVA",
"PLGYVTHG",
"MPLGYVTH",
"LLAPLLSA",
"QGLLPPKN",
"NETLVTMP",
"NFNQHEVL",
"FNQHEVLL",
"TLNISDEF",
"CEESSAKS",
"SGHNLAKH",
"SAGIFGAD",
"TLGVYDYL",
"LGYVTHGL",
"ERLKLFAA",
"PTLNISDE",
"LNISDEFS",
"VAKYTQLC",
"LNETLVTM",
"YIATNGPL",
"LKLFAAET",
"LTLGVYDY",
"RLKLFAAE",
"IATNGPLK",
"VFMCVEYC",
"GYVTHGLN",
"SDEFSSNV",
"FLARGIVF",
"GHNLAKHC",
"FMRFRRAF",
"YVTHGLNL",
"FMCVEYCP",
"ISDEFSSN",
"NISDEFSS",
"YCPIFFIT",
"CPIFFITG",
"VTHGLNLE",
"DLNETLVT",
"NDLNETLV",
"FIQQKLAL",
"HGLNLEEA",
"MCVEYCPI",
"EVLLAPLL",
"CVEYCPIF",
"QAISMWAL",
"NQHEVLLA",
"GDYILANT",
"EYCPIFFI",
"DYILANTC",
"EAARYMRS",
"DYIATNGP",
"EESSAKSA",
"EFLTRNPA",
"MRFRRAFG",
"ETLKATEE",
"QVESDDYI",
"NAGDYILA",
"VEYCPIFF",
"FAAETLKA",
"VESDDYIA",
"HEVLLAPL",
"AGDYILAN",
"ESSAKSAS",
"QHEVLLAP",
"SSAKSASV",
"FGEYSHVV",
"AETLKATE",
"GLNLEEAA",
"AKSASVYY",
"AAETLKAT",
"SAKSASVY",
"THGLNLEE",
"FNAIATCD",
"KLFAAETL",
"TLKATEET",
"NAIATCDW",
"TDFNAIAT",
"DFNAIATC",
"ESDDYIAT",
"AIATCDWT",
"TNAGDYIL",
"LNLEEAAR",
"LFAAETLK",
"VTDFNAIA",
"RRAFGEYS",
"VFGLYKNT",
"KPRPPLNR",
"FRRAFGEY",
"SDDYIATN",
"GKPRPPLN",
"AFGEYSHV",
"WTNAGDYI",
"DDYIATNG",
"RFRRAFGE",
"DNVTDFNA",
"GDFIQTTP",
"TERLKLFA",
"DWTNAGDY",
"FGLYKNTC",
"PGSGVPVV",
"IATCDWTN",
"DFIQTTPG",
"TTPGSGVP",
"TPGSGVPV",
"CTERLKLF",
"RAFGEYSH",
"VLSDRELH",
"SYYCKSHK",
"TCDWTNAG",
"QTTPGSGV",
"CDWTNAGD",
"FIQTTPGS",
"IQTTPGSG",
"NVTDFNAI",
"GIFGADPI",
"RYWEPEFY",
"ATCDWTNA",
"NVAKYTQL",
"YILANTCT",
"LEEAARYM",
"LSDRELHL",
"GLYKNTCV",
"LRVYANLG",
"KYPQVNGL",
"TCTERLKL",
"MMNVAKYT",
"ILRVYANL",
"AGIFGADP",
"MNVAKYTQ",
"NLEEAARY",
"ILANTCTE",
"WFFSNYLK",
"LYKNTCVG",
"NTCTERLK",
"WEVGKPRP",
"ANTCTERL",
"YPQVNGLT",
"SDRELHLS",
"SDNVTDFN",
"IMMNVAKY",
"EVGKPRPP",
"DRELHLSW",
"GSDNVTDF",
"YKNTCVGS",
"RELHLSWE",
"LANTCTER",
"GIMMNVAK",
"LSWEVGKP",
"CVGSDNVT",
"ADVTKIKP",
"VGSDNVTD",
"VYANLGER",
"YANLGERV",
"FFSNYLKR",
"SWEVGKPR",
"FSNYLKRR",
"NTCVGSDN",
"SNYLKRRV",
"KNTCVGSD",
"MSYYCKSH",
"TCVGSDNV",
"VGKPRPPL",
"GADVTKIK",
"ANLGERVR",
"RVYANLGE",
"DVTKIKPH",
"DGADVTKI",
"NLGERVRQ",
"NYSGVVTT",
"KGIMMNVA",
"YSGVVTTV",
"VTKIKPHN",
"PKGIMMNV",
"GDLQPLEQ",
"IHSLRVCV",
"LHLSWEVG",
"ELHLSWEV",
"LPKGIMMN",
"IFGADPIH",
"QALLKTVQ",
"RQALLKTV",
"VRQALLKT",
"FGADPIHS",
"DLYDKLQF",
"SGVVTTVM",
"RVRQALLK",
"KCDLQNYG",
"HSLRVCVD",
"LGERVRQA",
"TVMFLARG",
"GERVRQAL",
"LEKCDLQN",
"ERVRQALL",
"SSQAWQPG",
"WADNNCYL",
"TTVMFLAR",
"GMSYYCKS",
"EKCDLQNY",
"QSSQAWQP",
"DLQPLEQP",
"GVVTTVMF",
"VTTVMFLA",
"GADPIHSL",
"PNLYKMQR",
"LLEKCDLQ",
"YKMQRMLL",
"MPNLYKMQ",
"SLRVCVDT",
"VVTTVMFL",
"CDLQNYGD",
"DLQNYGDS",
"LYKMQRML",
"KMQRMLLE",
"AMPNLYKM",
"DDNLIDSY",
"MQRMLLEK",
"SQAWQPGV",
"QRMLLEKC",
"QAWQPGVA",
"NLYKMQRM",
"MLLEKCDL",
"VAMPNLYK",
"RMLLEKCD",
"ADPIHSLR",
"LQPLEQPT",
"GVAMPNLY",
"LQNYGDSA",
"WQPGVAMP",
"QPGVAMPN",
"LGRYMSAL",
"AWQPGVAM",
"PGVAMPNL",
"GRYMSALN",
"GGMSYYCK",
"TLPKGIMM",
"YMSALNHT",
"LGGMSYYC",
"RYMSALNH",
"KWADNNCY",
"EDDNLIDS",
"MSALNHTK",
"HLSWEVGK",
"ATLPKGIM",
"PIHSLRVC",
"DPIHSLRV",
"DEDDNLID",
"STKPVETS",
"TKPVETSN",
"SATLPKGI",
"KPVETSNS",
"YGDSATLP",
"LDGADVTK",
"ETSNSFDV",
"TSNSFDVL",
"GDSATLPK",
"NYGDSATL",
"DSATLPKG",
"KWKYPQVN",
"VETSNSFD",
"PVETSNSF",
"QNYGDSAT",
"TIQTIVEV",
"SNSFDVLK",
"SALNHTKK",
"SASIVAGG",
"KKWKYPQV",
"NSFDVLKS",
"ALNHTKKW",
"TTIQTIVE",
"LNHTKKWK",
"NHTKKWKY",
"SFDVLKSE",
"TKKWKYPQ",
"YLGGMSYY",
"HTKKWKYP",
"YLDGADVT",
"KPANNSLK",
"PANNSLKI",
"DNINLHTQ",
"KDEDDNLI",
"TTTIQTIV",
"TKIKPHNS",
"HEGKTFYV",
"TYLDGADV",
"VNLLTNMF",
"LKTVQFCD",
"KIKPHNSH",
"GPTYLDGA",
"FGPTYLDG",
"LLKTVQFC",
"DAVNLLTN",
"PTYLDGAD",
"QFGPTYLD",
"NLLTNMFT",
"AVNLLTNM",
"IKPHNSHE",
"EGKTFYVL",
"LRVCVDTV",
"ANNSLKIT",
"TNVYLAVF",
"KPHNSHEG",
"YGQQFGPT",
"EKDEDDNL",
"TNMFTPLI",
"LLTNMFTP",
"SHEGKTFY",
"GKTFYVLP",
"TFYVLPND",
"NMFTPLIQ",
"PHNSHEGK",
"MFTPLIQP",
"QQFGPTYL",
"KTFYVLPN",
"MTYGQQFG",
"LTNMFTPL",
"HNSHEGKT",
"RDLYDKLQ",
"SSYIVDSV",
"GQQFGPTY",
"DQSSYIVD",
"YIVDSVTV",
"TYGQQFGP",
"DSVTVKNG",
"QSSYIVDS",
"NSHEGKTF",
"ALLKTVQF",
"SYIVDSVT",
"VDSVTVKN",
"SSTFNVPM",
"STFNVPME",
"SMTYGQQF",
"NINLHTQV",
"FYVLPNDD",
"FLTRNPAW",
"IVDSVTVK",
"AYYFMRFR",
"EAFEYYHT",
"AFEYYHTT",
"RVCVDTVR",
"YVLPNDDT",
"MEKLKTLV",
"TSITSAVL",
"LYLGGMSY",
"TFNVPMEK",
"PMEKLKTL",
"VEAFEYYH",
"VDTVRTNV",
"VCVDTVRT",
"CLAYYFMR",
"LAYYFMRF",
"FEYYHTTD",
"FNVPMEKL",
"CVDTVRTN",
"FTLLLQLC",
"FFTLLLQL",
"VLPNDDTL",
"DTVRTNVY",
"MSMTYGQQ",
"LLLQLCTF",
"TLLLQLCT",
"PYFFTLLL",
"YFFTLLLQ",
"RTNVYLAV",
"QTTTIQTI",
"YMPYFFTL",
"QPPQTSIT",
"DTLRVEAF",
"NVPMEKLK",
"MPYFFTLL",
"LRVEAFEY",
"RVEAFEYY",
"VPMEKLKT",
"YQPPQTSI",
"DDTLRVEA",
"NYMPYFFT",
"DMSMTYGQ",
"TLRVEAFE",
"VLYQPPQT",
"LPNDDTLR",
"CTFTRSTN",
"PPQTSITS",
"PQTSITSA",
"LYQPPQTS",
"TCLAYYFM",
"QTSITSAV",
"TFTRSTNS",
"YWEPEFYE",
"PNDDTLRV",
"LLQLCTFT",
"INLHTQVV",
"LCTFTRST",
"NDDTLRVE",
"LQLCTFTR",
"QLCTFTRS",
"VDMSMTYG",
"TNYMPYFF",
"VELGTEVN",
"SQTSLRCG",
"IILKPANN",
"VRTNVYLA",
"CNSQTSLR",
"VLCNSQTS",
"VGDIILKP",
"QEKDEDDN",
"VTCLAYYF",
"TVRTNVYL",
"GDIILKPA",
"NNSLKITE",
"WEPEFYEA",
"TVELGTEV",
"DIILKPAN",
"NSQTSLRC",
"YTVELGTE",
"IKWADNNC",
"CVLCNSQT",
"VVDMSMTY",
"FTRSTNSR",
"GACVLCNS",
"VGACVLCN",
"VVGDIILK",
"RSTNSRIK",
"AGGIVAIV",
"FPLCANGQ",
"DRDLYDKL",
"ACVLCNSQ",
"STNSRIKA",
"LCNSQTSL",
"VVTCLAYY",
"NSLKITEE",
"TRSTNSRI",
"MESLVPGF",
"SLKITEEV",
"LKPANNSL",
"IVAGGIVA",
"CTNYMPYF",
"VFISPYNS",
"VAGGIVAI",
"LKITEEVG",
"QTSLRCGA",
"AVGACVLC",
"VCTNYMPY",
"SIVAGGIV",
"NLHTQVVD",
"VAIVVTCL",
"GGIVAIVV",
"IVVTCLAY",
"IVAIVVTC",
"AIVVTCLA",
"LQAVGACV",
"ISPYNSQN",
"FISPYNSQ",
"NVAITRAK",
"GIVAIVVT",
"ILKPANNS",
"PLCANGQV",
"ASIVAGGI",
"TSLRCGAC",
"TVDSSQGS",
"VDSSQGSE",
"FNVAITRA",
"NRVCTNYM",
"QTVDSSQG",
"QAVGACVL",
"RVCTNYMP",
"ISASIVAG",
"LNRVCTNY",
"LHTQVVDM",
"SDRDLYDK",
"VLQAVGAC",
"DISASIVA",
"TNSRIKAS",
"PYNSQNAV",
"KITEEVGH",
"HTVLQAVG",
"QVFGLYKN",
"RFNVAITR",
"ALDISASI",
"SLRCGACI",
"LDISASIV",
"YNSQNAVA",
"NQTTTIQT",
"AITRAKVG",
"TVLQAVGA",
"SPYNSQNA",
"AKVGILCI",
"VAITRAKV",
"TQTVDSSQ",
"ITRAKVGI",
"GILCIMSD",
"NRFNVAIT",
"SQNAVASK",
"NSQNAVAS",
"QNAVASKI",
"TRAKVGIL",
"GALDISAS",
"PHTVLQAV",
"RAKVGILC",
"DSSQGSEY",
"HTQVVDMS",
"YTPHTVLQ",
"EEVVENPT",
"VGILCIMS",
"GQVFGLYK",
"QLYLGGMS",
"LRCGACIR",
"EDNQTTTI",
"DNQTTTIQ",
"SEDNQTTT",
"TPHTVLQA",
"MYTPHTVL",
"NAVASKIL",
"SEEVVENP",
"LTRNPAWR",
"AVASKILG",
"KVGILCIM",
"EVVENPTI",
"VSEEVVEN",
"VVENPTIQ",
"VNRFNVAI",
"PLIQPIGA",
"NVNRFNVA",
"TPLIQPIG",
"ITEEVGHT",
"AVFISPYN",
"ILCIMSDR",
"LIQPIGAL",
"VASKILGL",
"FTPLIQPI",
"LCIMSDRD",
"SSQGSEYD",
"IGALDISA",
"TQVVDMSM",
"TQLYLGGM",
"CANGQVFG",
"PIGALDIS",
"CLNRVCTN",
"MSDRDLYD",
"QPLEQPTS",
"LCANGQVF",
"RCGACIRR",
"IQPIGALD",
"VTRCLNRV",
"CGACIRRP",
"NGQVFGLY",
"QVVDMSMT",
"TRCLNRVC",
"KAVFISPY",
"CNVNRFNV",
"GACIRRPF",
"ANGQVFGL",
"SCNVNRFN",
"AMYTPHTV",
"QPIGALDI",
"RCLNRVCT",
"EPEFYEAM",
"TRNPAWRK",
"RKAVFISP",
"IMSDRDLY",
"PTQTVDSS",
"FDVLKSED",
"EFYEAMYT",
"DVTQLYLG",
"DNLACEDL",
"PEFYEAMY",
"EDAQGMDN",
"LKSEDAQG",
"VTQLYLGG",
"QGSEYDYV",
"SEDAQGMD",
"DAQGMDNL",
"ASKILGLP",
"SQGSEYDY",
"WRKAVFIS",
"TDVTQLYL",
"CIMSDRDL",
"HSCNVNRF",
"MDNLACED",
"KSEDAQGM",
"FYEAMYTP",
"SKILGLPT",
"ILGLPTQT",
"DVLKSEDA",
"VLKSEDAQ",
"GMDNLACE",
"YEAMYTPH",
"LPTQTVDS",
"IVTRCLNR",
"EAMYTPHT",
"KILGLPTQ",
"QGMDNLAC",
"AQGMDNLA",
"TTEVVGDI",
"AYTVELGT",
"GLPTQTVD",
"AWRKAVFI",
"LGLPTQTV",
"KTTEVVGD",
"TETAHSCN",
"TTETAHSC",
"YYHTTDPS",
"GSEYDYVI",
"EYYHTTDP",
"VKTTEVVG",
"ECNVKTTE",
"QTTETAHS",
"CNVKTTEV",
"NVKTTEVV",
"AHSCNVNR",
"IFTQTTET",
"TAHSCNVN",
"ETAHSCNV",
"DVLECNVK",
"EVVGDIIL",
"NIVTRCLN",
"VIFTQTTE",
"TQTTETAH",
"FTQTTETA",
"VLECNVKT",
"PQVNGLTS",
"YVIFTQTT",
"LECNVKTT",
"TEVVGDII",
"VNGLTSIK",
"SEYDYVIF",
"SIKWADNN",
"QVNGLTSI",
"DYVIFTQT",
"NGLTSIKW",
"EYDYVIFT",
"YDYVIFTQ",
"TSIKWADN",
"TNIVTRCL",
"GLTSIKWA",
"TIKKPNEL",
"LTSIKWAD",
"IKKPNELS",
"PAWRKAVF",
"RNPAWRKA",
"LTIKKPNE",
"SLTIKKPN",
"VENPTIQK",
"NPAWRKAV",
"KKPNELSR",
"ENPTIQKD",
"KPNELSRV",
"PNELSRVL",
"SSLTIKKP",
"NSSLTIKK",
"EEVGHTDL",
"TTNIVTRC",
"STTTNIVT",
"TTTNIVTR",
"PLEQPTSE",
"TEEVGHTD",
"NPTIQKDV",
"FAKFLKTN",
"TIQKDVLE",
"GFAKFLKT",
"AGFAKFLK",
"VDNSSLTI",
"IQKDVLEC",
"QKDVLECN",
"PTIQKDVL",
"AKFLKTNC",
"DNSSLTIK",
"AYVDNSSL",
"YVDNSSLT",
"AAYVDNSS",
"VAGFAKFL",
"KDVLECNV",
"KVAGFAKF",
"NDKVAGFA",
"YNDKVAGF",
"DKVAGFAK",
"ISTSHKLV",
"STSHKLVL",
"DIYNDKVA",
"PFLCCKCC",
"LMAAYVDN",
"DLMAAYVD",
"AFDIYNDK",
"IYNDKVAG",
"TSHKLVLS",
"NELSRVLG",
"RAFDIYND",
"SHKLVLSV",
"FDIYNDKV",
"SFLGRYMS",
"TDLMAAYV",
"ELSRVLGL",
"VISTSHKL",
"MAAYVDNS",
"HVISTSHK",
"YRAFDIYN",
"LCCKCCYD",
"LSRVLGLK",
"CIRRPFLC",
"FLCCKCCY",
"EVGHTDLM",
"DHVISTSH",
"RPFLCCKC",
"YDHVISTS",
"CKCCYDHV",
"RRPFLCCK",
"CCKCCYDH",
"SRVLGLKT",
"CYDHVIST",
"VGHTDLMA",
"IRRPFLCC",
"HKLVLSVN",
"VSTTTNIV",
"HTDLMAAY",
"CCYDHVIS",
"FLGRYMSA",
"GHTDLMAA",
"KVVSTTTN",
"FLNKVVST",
"KCCYDHVI",
"VVSTTTNI",
"RVLGLKTL",
"NKVVSTTT",
"LNKVVSTT",
"ACIRRPFL",
"WDTIANYA",
"AKPFLNKV",
"DTIANYAK",
"VPWDTIAN",
"NSVPWDTI",
"VNSVPWDT",
"YAKPFLNK",
"NYAKPFLN",
"KPFLNKVV",
"PWDTIANY",
"AVNSVPWD",
"FQEKDEDD",
"LEQPTSEA",
"VLGLKTLA",
"LGLKTLAT",
"PFLNKVVS",
"SVPWDTIA",
"IANYAKPF",
"ANYAKPFL",
"TIANYAKP",
"KLVLSVNP",
"GCDVTDVT",
"CDVTDVTQ",
"DVTDVTQL",
"VTDVTQLY",
"GLKTLATH",
"PSFLGRYM",
"TDPSFLGR",
"DPSFLGRY",
"TTDPSFLG",
"RFQEKDED",
"LENVAFNV",
"ENVAFNVV",
"HTTDPSFL",
"VNPYVCNA",
"SVNPYVCN",
"NVAFNVVN",
"HKPPISFP",
"CRFQEKDE",
"SLENVAFN",
"KFLKTNCC",
"YCKSHKPP",
"LQSLENVA",
"QSLENVAF",
"FLKTNCCR",
"LSVNPYVC",
"YHTTDPSF",
"KTNCCRFQ",
"TNCCRFQE",
"LKTNCCRF",
"CKSHKPPI",
"LVLSVNPY",
"VLSVNPYV",
"RLQSLENV",
"SHKPPISF",
"KSHKPPIS",
"CCRFQEKD",
"NCCRFQEK",
"TRLQSLEN",
"KPPISFPL",
"FTRLQSLE",
"APGCDVTD",
"PGCDVTDV",
"NAPGCDVT",
"CNAPGCDV",
"VCNAPGCD",
"YVCNAPGC",
"FKLKDCVM",
"GFKLKDCV",
"SGFKLKDC",
"SAYTVELG",
"LSGFKLKD",
"SLSGFKLK",
"DMVDTSLS",
"VDTSLSGF",
"TSLSGFKL",
"MVDTSLSG",
"DTSLSGFK",
"YTPSKLIE",
"PYVCNAPG",
"NPYVCNAP",
"FSAVGNIC",
"PRVFSAVG",
"FLPRVFSA",
"VFSAVGNI",
"RVFSAVGN",
"LPRVFSAV",
"CYTPSKLI",
"ICYTPSKL",
"YYCKSHKP",
"NICYTPSK",
"PPISFPLC",
"IYTSGSTG",
"GNICYTPS",
"RHGTCERS",
"HGTCERSE",
"TPSKLIEY",
"CRHGTCER",
"PSKLIEYT",
"VGNICYTP",
"AVGNICYT",
"SAVGNICY",
"YCRHGTCE",
"EQPTSEAV",
"MLLEIKDT",
"LMLLEIKD",
"LLEIKDTE",
"LEIKDTEK",
"QPTSEAVE",
"PTSEAVEA",
"GLMLLEIK",
"EYCRHGTC",
"NGLMLLEI",
"TSACVLAA",
"KLIEYTDF",
"NLACEDLK",
"INGLMLLE",
"SKLIEYTD",
"LIEYTDFA",
"ATSACVLA",
"NSRIKASM",
"YTDFATSA",
"FATSACVL",
"TDFATSAC",
"CVLAAECT",
"ACVLAAEC",
"DFATSACV",
"VLMDGSII",
"SACVLAAE",
"EYTDFATS",
"IEYTDFAT",
"LMDGSIIQ",
"MDGSIIQF",
"CINGLMLL",
"DGSIIQFP",
"LAAECTIF",
"SEYCRHGT",
"PVCINGLM",
"VLAAECTI",
"LEGSVAYE",
"LEGSVRVV",
"GSIIQFPN",
"VCINGLML",
"CSAYTVEL",
"VLEGSVAY",
"TPVCINGL",
"QFPNTYLE",
"FPNTYLEG",
"EGSVRVVT",
"NVLEGSVA",
"YLEGSVRV",
"YVLMDGSI",
"EGSVAYES",
"GSVRVVTT",
"TSEAVEAP",
"SRIKASMP",
"RYVLMDGS",
"GTPVCING",
"SVAYESLR",
"IIQFPNTY",
"IQFPNTYL",
"AYESLRPD",
"IQQKLALG",
"TYLEGSVR",
"GSVAYESL",
"VAYESLRP",
"SIIQFPNT",
"PNTYLEGS",
"SEAVEAPL",
"NTYLEGSV",
"VGTPVCIN",
"LVGTPVCI",
"AAECTIFK",
"AECTIFKD",
"ECTIFKDA",
"YCYDTNVL",
"PLVGTPVC",
"CYDTNVLE",
"PYCYDTNV",
"CTIFKDAS",
"DTNVLEGS",
"YDTNVLEG",
"TNVLEGSV",
"SVRVVTTF",
"EAVEAPLV",
"TIFKDASG",
"GLAAVNSV",
"AVEAPLVG",
"APLVGTPV",
"EAPLVGTP",
"FKDASGKP",
"LAAVNSVP",
"VEAPLVGT",
"THGLAAVN",
"IFKDASGK",
"AAVNSVPW",
"ATHGLAAV",
"HGLAAVNS",
"LRPDTRYV",
"YESLRPDT",
"RPDTRYVL",
"ESLRPDTR",
"SLRPDTRY",
"QQKLALGG",
"TRYVLMDG",
"DTRYVLMD",
"LATHGLAA",
"PDTRYVLM",
"TLATHGLA",
"KTLATHGL",
"LKTLATHG",
"RIKASMPT",
"IKASMPTT",
"VRVVTTFD",
"DSEYCRHG",
"TFDSEYCR",
"FDSEYCRH",
"KASMPTTI",
"TTFDSEYC",
"VTTFDSEY",
"VVTTFDSE",
"IGDELKIN",
"IIGDELKI",
"RVVTTFDS",
"YPIIGDEL",
"PIIGDELK",
"EYPIIGDE",
"QKLALGGS",
"AVHFISNS",
"ASMPTTIA",
"VISSDVLV",
"PVSEEVVE",
"SSDVLVNN",
"VVISSDVL",
"YFAVHFIS",
"GDELKINA",
"DELKINAA",
"ELKINAAC",
"NRVVISSD",
"LKINAACR",
"ISSDVLVN",
"KINAACRK",
"RVVISSDV",
"NNRVVISS",
"ENNRVVIS",
"FAVHFISN",
"IRENNRVV",
"RENNRVVI",
"IIRENNRV",
"LIIRENNR",
"INAACRKV",
"KLALGGSV",
"FVAAIFYL",
"VAAIFYLI",
"LFVAAIFY",
"RLIIRENN",
"NAACRKVQ",
"ANSTVLSF",
"PANSTVLS",
"IDVQQWGF",
"VPANSTVL",
"EVPANSTV",
"GRLIIREN",
"FELDERID",
"LALGGSVA",
"MIDVQQWG",
"KCSAYTVE",
"TFELDERI",
"DVQQWGFT",
"VQQWGFTG",
"GNLQSNHD",
"NLQSNHDL",
"LQSNHDLY",
"AHVASCDA",
"VHGNAHVA",
"QSNHDLYC",
"QQWGFTGN",
"NATEVPAN",
"QVHGNAHV",
"QWGFTGNL",
"VLSFCAFA",
"VAKSHNIA",
"LYCQVHGN",
"ELDERIDK",
"NHDLYCQV",
"YCQVHGNA",
"SNHDLYCQ",
"FTGNLQSN",
"LSFCAFAV",
"HGNAHVAS",
"NAHVASCD",
"ATEVPANS",
"LDERIDKV",
"CQVHGNAH",
"WGFTGNLQ",
"HDLYCQVH",
"HVASCDAI",
"SFCAFAVD",
"DLYCQVHG",
"VASCDAIM",
"GFTGNLQS",
"FMIDVQQW",
"TEVPANST",
"TGNLQSNH",
"SYFAVHFI",
"GNAHVASC",
"TVLSFCAF",
"STVLSFCA",
"PFMIDVQQ",
"NSTVLSFC",
"AACRKVQH",
"EKCSAYTV",
"DERIDKVL",
"NPFMIDVQ",
"QVAKSHNI",
"SIVCRFDT",
"AQVAKSHN",
"QTACTDDN",
"AKSHNIAL",
"YNPFMIDV",
"TQTACTDD",
"VYNPFMID",
"ACTDDNAL",
"CTDDNALA",
"TACTDDNA",
"KSHNIALI",
"INAQVAKS",
"ERIDKVLN",
"YVYNPFMI",
"WNVKDFMS",
"TTQTACTD",
"GTTQTACT",
"DYVYNPFM",
"TDDNALAY",
"NVKDFMSL",
"NSIVCRFD",
"HINAQVAK",
"NAQVAKSH",
"SHNIALIW",
"CERSEAGV",
"TCERSEAG",
"KDFMSLSE",
"CRFDTRVL",
"GNATEVPA",
"QAGNATEV",
"ACRKVQHM",
"ERSEAGVC",
"RHINAQVA",
"MQNCVLKL",
"IWNVKDFM",
"AGNATEVP",
"RFDTRVLS",
"VKDFMSLS",
"IVCRFDTR",
"LIWNVKDF",
"IALIWNVK",
"DFMSLSEQ",
"DKVLNEKC",
"ALIWNVKD",
"ARHINAQV",
"LQAGNATE",
"KGRLIIRE",
"RSEAGVCV",
"FCAFAVDA",
"FDTRVLSN",
"HNIALIWN",
"VCRFDTRV",
"IDKVLNEK",
"ACWHHSIG",
"TYACWHHS",
"NIALIWNV",
"SEAGVCVS",
"YACWHHSI",
"FDYVYNPF",
"KVLNEKCS",
"RLQAGNAT",
"DTYACWHH",
"SDTYACWH",
"RIDKVLNE",
"CSARHINA",
"VRLQAGNA",
"NEKCSAYT",
"DTRVLSNL",
"FMSLSEQL",
"CDRRATCF",
"LNEKCSAY",
"FSYFAVHF",
"CLFWNCNV",
"DNALAYYN",
"SARHINAQ",
"DRRATCFS",
"RRATCFST",
"NDPVGFTL",
"EAGVCVST",
"CWHHSIGF",
"VQHMVVKA",
"PKAIKCVP",
"MSLSEQLR",
"DDNALAYY",
"RKVQHMVV",
"KVQHMVVK",
"CRKVQHMV",
"VLNEKCSA",
"WHHSIGFD",
"SLSEQLRK",
"LSEQLRKQ",
"LFWNCNVD",
"DPVGFTLK",
"NALAYYNT",
"TRVLSNLN",
"CAFAVDAA",
"SEQLRKQI",
"SIGFDYVY",
"FLFVAAIF",
"KVTFGDDT",
"KAIKCVPQ",
"GFDYVYNP",
"AIKCVPQA",
"VLHDIGNP",
"EQLRKQIR",
"SCAAGTTQ",
"KIEELFYS",
"ATCFSTAS",
"ASDTYACW",
"VTFGDDTV",
"TCFSTASD",
"CAAGTTQT",
"YKIEELFY",
"TASDTYAC",
"IGFDYVYN",
"LHDIGNPK",
"HHSIGFDY",
"PVLHDIGN",
"HSIGFDYV",
"RSAAKKNN",
"AAGTTQTA",
"STASDTYA",
"KFPVLHDI",
"QHMVVKAA",
"NPKAIKCV",
"RATCFSTA",
"DIGNPKAI",
"AGTTQTAC",
"ANDPVGFT",
"TFGDDTVI",
"LRKQIRSA",
"IGNPKAIK",
"NCNVDRYP",
"AAKKNNLP",
"FPVLHDIG",
"IEELFYSY",
"HMVVKAAL",
"IRSAAKKN",
"HDIGNPKA",
"GNPKAIKC",
"QLRKQIRS",
"SAAKKNNL",
"KKNNLPFK",
"QIRSAAKK",
"AKKNNLPF",
"VCLFWNCN",
"WNCNVDRY",
"FSTASDTY",
"CANDPVGF",
"KIVNNWLK",
"RKQIRSAA",
"MVVKAALL",
"KCVPQADV",
"FGDDTVIE",
"CFSTASDT",
"FWNCNVDR",
"IKCVPQAD",
"DKFPVLHD",
"LCDRRATC",
"KQIRSAAK",
"RVLSNLNL",
"KAYKIEEL",
"CSDKAYKI",
"AYKIEELF",
"SDKAYKIE",
"IVNNWLKQ",
"FYDAQPCS",
"MSCAAGTT",
"DAQPCSDK",
"YDAQPCSD",
"PCSDKAYK",
"GKIVNNWL",
"DKAYKIEE",
"EELFYSYA",
"GTCERSEA",
"ELFYSYAT",
"GDDTVIEV",
"DCSARHIN",
"QPCSDKAY",
"NITFELDE",
"NNWLKQLI",
"VNNWLKQL",
"AQPCSDKA",
"LFYSYATH",
"ITFELDER",
"VNITFELD",
"LADKFPVL",
"CVPQADVE",
"FFSYFAVH",
"LLADKFPV",
"AFAVDAAK",
"KSVNITFE",
"KGKYVQIP",
"VPQADVEW",
"GVCLFWNC",
"NWLKQLIK",
"LKGKYVQI",
"CDLKGKYV",
"TVIEVQGY",
"DTVIEVQG",
"VIEVQGYK",
"DDTVIEVQ",
"TKVTFGDD",
"SVNITFEL",
"YKSVNITF",
"ADKFPVLH",
"FAVDAAKA",
"DLKGKYVQ",
"WLKQLIKV",
"DGVCLFWN",
"TCANDPVG",
"VVKAALLA",
"YVQIPTTC",
"TDGVCLFW",
"IPTTCAND",
"QIPTTCAN",
"LKQLIKVT",
"WKFYDAQP",
"NVVTTKIA",
"KFYDAQPC",
"FCDLKGKY",
"FTDGVCLF",
"KFTDGVCL",
"GYKSVNIT",
"TVRLQAGN",
"KGFCDLKG",
"GFCDLKGK",
"DKFTDGVC",
"NPKGFCDL",
"PKGFCDLK",
"AVDAAKAY",
"ATVRLQAG",
"VEWKFYDA",
"GGKIVNNW",
"VKAALLAD",
"VQIPTTCA",
"TNCVKMLC",
"GKYVQIPT",
"KAALLADK",
"NCVKMLCT",
"KMLCTHTG",
"VKMLCTHT",
"LCTHTGTG",
"KNNLPFKL",
"CVKMLCTH",
"VVTTKIAL",
"PTTCANDP",
"PTKVTFGD",
"EWKFYDAQ",
"VDAAKAYK",
"GQPITNCV",
"VVNVVTTK",
"PITNCVKM",
"QPITNCVK",
"DQESFGGA",
"AKAYKDYL",
"QESFGGAS",
"PNPKGFCD",
"ITNCVKML",
"GGASCCLY",
"HPNPKGFC",
"ADVEWKFY",
"CCLYCRCH",
"MLCTHTGT",
"KGGKIVNN",
"CTHTGTGQ",
"CLYCRCHI",
"NNLPFKLT",
"VNVVTTKI",
"KQLIKVTL",
"GQAITVTP",
"QMSCAAGT",
"AALLADKF",
"DVEWKFYD",
"THTGTGQA",
"FGGASCCL",
"GASCCLYC",
"NMDQESFG",
"TGTGQAIT",
"LYCRCHID",
"VFLFVAAI",
"YCRCHIDH",
"SFGGASCC",
"MDQESFGG",
"DAAKAYKD",
"ESFGGASC",
"VTTKIALK",
"GTGQAITV",
"ASCCLYCR",
"PQADVEWK",
"KYVQIPTT",
"ANMDQESF",
"AAKAYKDY",
"HTGTGQAI",
"QADVEWKF",
"ALLADKFP",
"AITVTPEA",
"IDHPNPKG",
"TTCANDPV",
"IEVQGYKS",
"TGQAITVT",
"SCCLYCRC",
"EANMDQES",
"QAITVTPE",
"TVTPEANM",
"DHPNPKGF",
"APTKVTFG",
"ITVTPEAN",
"HIDHPNPK",
"GGQPITNC",
"PEANMDQE",
"QVVNVVTT",
"SGGQPITN",
"RCHIDHPN",
"TPEANMDQ",
"CHIDHPNP",
"VTPEANMD",
"VQGYKSVN",
"QGYKSVNI",
"RQVVNVVT",
"TRQVVNVV",
"NLPFKLTC",
"EVQGYKSV",
"CRCHIDHP",
"QLIKVTLV",
"HSDKFTDG",
"THSDKFTD",
"LPFKLTCA",
"KAYKDYLA",
"AYKDYLAS",
"LKGGAPTK",
"ELEPPCRF",
"GAPTKVTF",
"GGAPTKVT",
"RQMSCAAG",
"LEPPCRFV",
"FKLTCATT",
"FYSYATHS",
"VLSNLNLP",
"PFKLTCAT",
"PCRFVTDT",
"HFLPRVFS",
"ATTRQVVN",
"EPPCRFVT",
"KGGAPTKV",
"TTRQVVNV",
"PPCRFVTD",
"ATHSDKFT",
"IKGLNNLN",
"CRFVTDTP",
"KLTCATTR",
"FIKGLNNL",
"LVFLFVAA",
"TCATTRQV",
"YKDYLASG",
"KDYLASGG",
"YFIKGLNN",
"YSYATHSD",
"LYFIKGLN",
"LRQMSCAA",
"TELEPPCR",
"YATHSDKF",
"TTKIALKG",
"LTCATTRQ",
"YLYFIKGL",
"QDLKWARF",
"DYLASGGQ",
"CATTRQVV",
"YTELEPPC",
"YLASGGQP",
"RFVTDTPK",
"SYATHSDK",
"VKLQNNEL",
"LHFLPRVF",
"FVTDTPKG",
"VKYLYFIK",
"SDKFTDGV",
"LQDLKWAR",
"KYLYFIKG",
"LKGGKIVN",
"LASGGQPI",
"KVKYLYFI",
"DADSKIVQ",
"TKIALKGG",
"GPKVKYLY",
"ASGGQPIT",
"KLQNNELS",
"ADSKIVQL",
"LQNNELSP",
"QNNELSPV",
"VDADSKIV",
"KIALKGGK",
"IALKGGKI",
"AATVRLQA",
"YASALWEI",
"KGLNNLNR",
"KGPKVKYL",
"ALKGGKIV",
"VVDADSKI",
"DSKIVQLS",
"QQVVDADS",
"VTDTPKGP",
"GLNNLNRG",
"SKIVQLSE",
"IVQLSEIS",
"QVVDADSK",
"IQQVVDAD",
"KIVQLSEI",
"VQLSEISM",
"MMVTNNTF",
"VLALLSDL",
"PKVKYLYF",
"GGRFVLAL",
"DLQDLKWA",
"EIQQVVDA",
"ASALWEIQ",
"TDTPKGPK",
"FVLALLSD",
"VLGSLAAT",
"QLSEISMD",
"TPKGPKVK",
"LLSDLQDL",
"LNRGMVLG",
"PKGPKVKY",
"DTPKGPKV",
"TFTYASAL",
"SALWEIQQ",
"SEISMDNS",
"LSEISMDN",
"LSDLQDLK",
"NSPNLAWP",
"NNELSPVA",
"ALWEIQQV",
"SDLQDLKW",
"FTYASALW",
"SPNLAWPL",
"GRFVLALL",
"NNLNRGMV",
"DLKWARFP",
"ALLSDLQD",
"EISMDNSP",
"WEIQQVVD",
"DNSPNLAW",
"ALRQMSCA",
"LWEIQQVV",
"LKWARFPK",
"LNNLNRGM",
"ALAYYNTT",
"FLHFLPRV",
"GSLAATVR",
"ARFPKSDG",
"LAATVRLQ",
"MVLGSLAA",
"NLNRGMVL",
"NELSPVAL",
"PKSDGTGT",
"MDNSPNLA",
"LGSLAATV",
"WARFPKSD",
"RFPKSDGT",
"SMDNSPNL",
"NRGMVLGS",
"VALRQMSC",
"FPKSDGTG",
"KWARFPKS",
"LSPVALRQ",
"AWPLIVTA",
"PVALRQMS",
"LKPVSEEV",
"KPVSEEVV",
"ISMDNSPN",
"NNTFTLKG",
"NMMVTNNT",
"NLAWPLIV",
"RFVLALLS",
"SLAATVRL",
"LAWPLIVT",
"ELSPVALR",
"TLVFLFVA",
"LIKVTLVF",
"TYASALWE",
"GMVLGSLA",
"PNLAWPLI",
"DLKPVSEE",
"RGMVLGSL",
"SPVALRQM",
"SAVKLQNN",
"KGGRFVLA",
"LFDMSKFP",
"AVKLQNNE",
"EIKDTEKY",
"VTNNTFTL",
"FTLKGGAP",
"VTLVFLFV",
"LALLSDLQ",
"KVTLVFLF",
"IKVTLVFL",
"TLKGGAPT",
"NSAVKLQN",
"TNNTFTLK",
"PNMMVTNN",
"DMSKFPLK",
"TFTLKGGA",
"MVTNNTFT",
"MSKFPLKL",
"LAPNMMVT",
"FDMSKFPL",
"ANSAVKLQ",
"APNMMVTN",
"LAYYNTTK",
"AYYNTTKG",
"KDTEKYCA",
"NTFTLKGG",
"RANSAVKL",
"LACEDLKP",
"EDLKPVSE",
"LRANSAVK",
"ALAPNMMV",
"YCALAPNM",
"ALRANSAV",
"CALAPNMM",
"CEDLKPVS",
"ACEDLKPV",
"VTALRANS",
"TEKYCALA",
"TALRANSA",
"DTEKYCAL",
"IKDTEKYC",
"WPLIVTAL",
"DFLHFLPR",
"CVLKLKVD",
"PLIVTALR",
"KYCALAPN",
"NCVLKLKV",
"EKYCALAP",
"YYNTTKGG",
"QNCVLKLK",
"LIVTALRA",
"VLKLKVDT",
"IVTALRAN",
"KLKVDTAN",
"SMPTTIAK",
"LKLKVDTA",
"YNTTKGGR",
"GDFLHFLP",
"TTFTYASA",
"GTTFTYAS",
"NTTKGGRF",
"TTKGGRFV",
"DGTTFTYA",
"TKGGRFVL",
"NGDFLHFL",
"LKVDTANP",
"TFTRLQSL",
"NTFTRLQS",
"NNTDFSRV",
"MQLFFSYF",
"TPNNTDFS",
"WNTFTRLQ",
"PNNTDFSR",
"DTPNNTDF",
"LWNTFTRL",
"YVDTPNNT",
"TGYVDTPN",
"GYVDTPNN",
"VDTPNNTD",
"VGFTLKNT",
"DGTGTIYT",
"IMQLFFSY",
"GTGTIYTE",
"TGTIYTEL",
"GTIYTELE",
"GFTLKNTV",
"PVGFTLKN",
"ILFTRFFY",
"IQITISSF",
"SDGTGTIY",
"TIQITISS",
"YILFTRFF",
"IYTELEPP",
"YNLWNTFT",
"TIYTELEP",
"IEYPIIGD",
"SLETIQIT",
"KSDGTGTI",
"LFTRFFYV",
"QITISSFK",
"LETIQITI",
"LFFSYFAV",
"ETIQITIS",
"NLWNTFTR",
"AYILFTRF",
"ITISSFKW",
"FTLKNTVC",
"LAYILFTR",
"ISSFKWDL",
"TISSFKWD",
"TLKNTVCT",
"FLAYILFT",
"PSLETIQI",
"EWFLAYIL",
"SSFKWDLT",
"CSVCLSGL",
"WFLAYILF",
"YPSLETIQ",
"DLTAFGLV",
"VCLSGLDS",
"SFKWDLTA",
"GYLNSTNV",
"RVDWTIEY",
"VDWTIEYP",
"SVCLSGLD",
"TAFGLVAE",
"LTAFGLVA",
"DWTIEYPI",
"TIEYPIIG",
"WTIEYPII",
"AFGLVAEW",
"CLSGLDSL",
"NVTIATYC",
"VAEWFLAY",
"FKWDLTAF",
"FGLVAEWF",
"AEWFLAYI",
"WDLTAFGL",
"FFYVLGLA",
"KWDLTAFG",
"FTRFFYVL",
"TRFFYVLG",
"RFFYVLGL",
"SLFDMSKF",
"YSLFDMSK",
"GLVAEWFL",
"SLLSKGRL",
"LSGLDSLD",
"LDTYPSLE",
"LVAEWFLA",
"SKGRLIIR",
"LLSKGRLI",
"TYPSLETI",
"TIATYCTG",
"SLDTYPSL",
"TVIWDYKR",
"GLDSLDTY",
"SYSLFDMS",
"LDSLDTYP",
"DSLDTYPS",
"LSKGRLII",
"LSLLSKGR",
"QLFFSYFA",
"IWDYKRDA",
"WDYKRDAP",
"SGLDSLDT",
"DYKRDAPA",
"VIWDYKRD",
"ILSLLSKG",
"VTIATYCT",
"DTYPSLET",
"YKRDAPAH",
"KRDAPAHI",
"REGYLNST",
"GVCVSTSG",
"SSYSLFDM",
"RDAPAHIS",
"LSSYSLFD",
"DMILSLLS",
"MILSLLSK",
"NDMILSLL",
"IFYLITPV",
"AGVCVSTS",
"EGYLNSTN",
"INDMILSL",
"KRVDWTIE",
"GKPVPYCY",
"YREGYLNS",
"KPVPYCYD",
"AIMQLFFS",
"VPYCYDTN",
"PVPYCYDT",
"FYVLGLAA",
"QLSSYSLF",
"VKRVDWTI",
"QINDMILS",
"DASGKPVP",
"KDASGKPV",
"TNGDFLHF",
"ASGKPVPY",
"SGKPVPYC",
"AAIMQLFF",
"DAIMTRCL",
"IQLSSYSL",
"ASCDAIMT",
"FVKRVDWT",
"FYLITPVH",
"AIMTRCLA",
"CFVKRVDW",
"LAAIMQLF",
"YVLGLAAI",
"VLGLAAIM",
"LGLAAIMQ",
"GLAAIMQL",
"SCDAIMTR",
"DLLLDDFV",
"YLITPVHV",
"CDAIMTRC",
"NTVIWDYK",
"SSEAFLIG",
"DDFVEIIK",
"IMTRCLAV",
"LLLDDFVE",
"ANTVIWDY",
"LDDFVEII",
"LLDDFVEI",
"MTRCLAVH",
"IDLLLDDF",
"SEAFLIGC",
"VIDLLLDD",
"EAFLIGCN",
"SSSEAFLI",
"AFLIGCNY",
"ECFVKRVD",
"FLIGCNYL",
"HANYIFWR",
"HECFVKRV",
"MHANYIFW",
"ANYIFWRN",
"VHECFVKR",
"YIFWRNTN",
"TRCLAVHE",
"DYYRSLPG",
"AVHECFVK",
"YYRSLPGV",
"TYNLWNTF",
"GQINDMIL",
"RCLAVHEC",
"NYIFWRNT",
"LIGCNYLG",
"CLAVHECF",
"LAVHECFV",
"NNDYYRSL",
"NDYYRSLP",
"YVMHANYI",
"GYVMHANY",
"LNNDYYRS",
"VLNNDYYR",
"DGYVMHAN",
"ASSSEAFL",
"VMHANYIF",
"VNASSSEA",
"DTYNLWNT",
"NASSSEAF",
"AANTVIWD",
"SVIDLLLD",
"VCVSTSGR",
"IGCNYLGK",
"AAIFYLIT",
"WVLNNDYY",
"IDGYVMHA",
"YLNSTNVT",
"CVSTSGRW",
"FDTYNLWN",
"RWVLNNDY",
"LNSTNVTI",
"IATYCTGS",
"VSTSGRWV",
"STSGRWVL",
"AIFYLITP",
"TSGRWVLN",
"GRWVLNND",
"IAANTVIW",
"ATYCTGSI",
"AVMSLKEG",
"SGRWVLNN",
"NSTNVTIA",
"DIAANTVI",
"STNVTIAT",
"VAFNVVNK",
"MPTTIAKN",
"QIDGYVMH",
"AFNVVNKG",
"VVNKGHFD",
"EGQINDMI",
"TNVTIATY",
"FNVVNKGH",
"VNKGHFDG",
"KEGQINDM",
"VMSLKEGQ",
"NVVNKGHF",
"VKILNNLG",
"PEVKILNN",
"VDIAANTV",
"PVNVAFEL",
"GVDIAANT",
"VNVAFELW",
"NVAFELWA",
"EVKILNNL",
"LPVNVAFE",
"FVEIIKSQ",
"DFVEIIKS",
"TIDYTEIS",
"ILNNLGVD",
"KILNNLGV",
"PIQLSSYS",
"LKEGQIND",
"LNNLGVDI",
"EQIDGYVM",
"TLPVNVAF",
"VELFENKT",
"ELFENKTT",
"IFWRNTNP",
"VEIIKSQD",
"EIIKSQDL",
"IIKSQDLS",
"PVPEVKIL",
"VPEVKILN",
"GCNYLGKP",
"TTLPVNVA",
"KPVPEVKI",
"NNLGVDIA",
"KTTLPVNV",
"FENKTTLP",
"NKTTLPVN",
"NLGVDIAA",
"IKSQDLSV",
"IKPVPEVK",
"GHFDGQQG",
"DVELFENK",
"LGVDIAAN",
"VTIDYTEI",
"ENKTTLPV",
"LFENKTTL",
"SLKEGQIN",
"MSLKEGQI",
"NKGHFDGQ",
"KVTIDYTE",
"VKVTIDYT",
"VDVELFEN",
"KSQDLSVV",
"NIKPVPEV",
"VAFELWAK",
"SQDLSVVS",
"NPIQLSSY",
"VVKVTIDY",
"DGVDVELF",
"SKVVKVTI",
"TAVMSLKE",
"GVDVELFE",
"RNIKPVPE",
"AFELWAKR",
"KGHFDGQQ",
"FELWAKRN",
"KVVKVTID",
"ELWAKRNI",
"KRNIKPVP",
"LWAKRNIK",
"AKRNIKPV",
"VDGVDVEL",
"FWRNTNPI",
"WAKRNIKP",
"KVDGVDVE",
"TNPIQLSS",
"TKVDGVDV",
"WWTAFVTN",
"VYTKVDGV",
"VSKVVKVT",
"TVYTKVDG",
"NTVYTKVD",
"WTAFVTNV",
"AIKITEHS",
"SIINNTVY",
"NNTVYTKV",
"IINNTVYT",
"RNTNPIQL",
"INNTVYTK",
"DLSVVSKV",
"QDLSVVSK",
"VAIKITEH",
"YTKVDGVD",
"NVNASSSE",
"WRNTNPIQ",
"TNVNASSS",
"NTNPIQLS",
"VSIINNTV",
"ITEHSWNA",
"KITEHSWN",
"LKNTVCTV",
"SVVSKVVK",
"VTNVNASS",
"IKITEHSW",
"GTAVMSLK",
"VVSKVVKV",
"LSVVSKVV",
"HFDGQQGE",
"PVSIINNT",
"TAFVTNVN",
"KFPLKLRG",
"GHFAWWTA",
"MGHFAWWT",
"AFVTNVNA",
"FVTNVNAS",
"TEHSWNAD",
"LMGHFAWW",
"FAWWTAFV",
"DGQQGEVP",
"HFAWWTAF",
"AWWTAFVT",
"SKFPLKLR",
"FDGQQGEV",
"HSWNADLY",
"GQQGEVPV",
"EHSWNADL",
"VPVSIINN",
"NADLYKLM",
"WNADLYKL",
"QFDTYNLW",
"EVPVSIIN",
"SWNADLYK",
"GEVPVSII",
"QQGEVPVS",
"ADLYKLMG",
"KNTVCTVC",
"LYKLMGHF",
"QGEVPVSI",
"DLYKLMGH",
"YKLMGHFA",
"NTVCTVCG",
"KLMGHFAW",
"TTNGDFLH",
"ANSIVCRF",
"PTTIAKNT",
"PANSIVCR",
"YPANSIVC",
"VDAVNLLT",
"TVCTVCGM",
"KQFDTYNL",
"GVDAVNLL",
"CGVDAVNL",
"LPGVFCGV",
"KLRGTAVM",
"FCGVDAVN",
"VFCGVDAV",
"PGVFCGVD",
"LRGTAVMS",
"GVFCGVDA",
"RYPANSIV",
"RGTAVMSL",
"FPLKLRGT",
"LKLRGTAV",
"DRYPANSI",
"CNVDRYPA",
"NVDRYPAN",
"VDRYPANS",
"PLKLRGTA",
"SLPGVFCG",
"TTIAKNTV",
"VCTVCGMW",
"RTTNGDFL",
"RSLPGVFC",
"YRSLPGVF",
"ALGGSVAI",
"LLLSVCLG",
"GYREGYLN",
"LSNLNLPG",
"FLLLSVCL",
"IWFLLLSV",
"LRTTNGDF",
"LLSVCLGS",
"TIAKNTVK",
"SNLNLPGC",
"TGYREGYL",
"LGGSVAIK",
"WFLLLSVC",
"NLNLPGCD",
"ILRTTNGD",
"NYLKSPNF",
"FNYLKSPN",
"YCTGYREG",
"SFNYLKSP",
"PCSVCLSG",
"CTGYREGY",
"LITPVHVM",
"ASFNYLKS",
"DTCFANKH",
"FANKHADF",
"LEASFNYL",
"IPCSVCLS",
"CFANKHAD",
"TCFANKHA",
"IAKNTVKS",
"EASFNYLK",
"NFSKLINI",
"ANKHADFD",
"TDTCFANK",
"LKSPNFSK",
"PNFSKLIN",
"YLKSPNFS",
"NKHADFDT",
"KHADFDTW",
"KSPNFSKL",
"SIPCSVCL",
"SPNFSKLI",
"DAPAHIST",
"STDTCFAN",
"AVITREVG",
"GSIPCSVC",
"AKNTVKSV",
"NTVKSVGK",
"VITREVGF",
"CLGSLIYS",
"CLEASFNY",
"ITREVGFV",
"VCLGSLIY",
"SVCLGSLI",
"KNTVKSVG",
"ASTDTCFA",
"FCLEASFN",
"APAHISTI",
"SYCTGYRE",
"PAHISTIG",
"PLIAAVIT",
"KFCLEASF",
"VKSVGKFC",
"TVKSVGKF",
"LGSLIYST",
"KSVGKFCL",
"IASTDTCF",
"LIAAVITR",
"LSVCLGSL",
"RDIASTDT",
"DIASTDTC",
"ACPLIAAV",
"AAVITREV",
"CPLIAAVI",
"AYVIYTSG",
"TRDIASTD",
"SVGKFCLE",
"IAAVITRE",
"GKFCLEAS",
"GSLIYSTA",
"NDKACPLI",
"VGKFCLEA",
"VTRDIAST",
"KACPLIAA",
"SLIYSTAA",
"PSYCTGYR",
"TGSIPCSV",
"DKACPLIA",
"TREVGFVV",
"GVTRDIAS",
"CTGSIPCS",
"GGVTRDIA",
"REVGFVVP",
"EVGFVVPG",
"DGGVTRDI",
"YCTGSIPC",
"ITPVHVMS",
"IDGGVTRD",
"VGFVVPGL",
"GFVVPGLP",
"GGSVAIKI",
"CSVIDLLL",
"VCSVIDLL",
"AIDGGVTR",
"AHISTIGV",
"CVCSVIDL",
"FVVPGLPG",
"GSVAIKIT",
"KCVCSVID",
"CTVCGMWK",
"LNLPGCDG",
"TILRTTNG",
"YKAIDGGV",
"SVAIKITE",
"KAIDGGVT",
"TYCTGSIP",
"SKCVCSVI",
"HISTIGVC",
"GTILRTTN",
"VVPGLPGT",
"GLPGTILR",
"TVCGMWKG",
"PGLPGTIL",
"LPGTILRT",
"PGTILRTT",
"VPGLPGTI",
"TDFSSEII",
"GYKAIDGG",
"DFSSEIIG",
"IGYKAIDG",
"HTDFSSEI",
"ISTIGVCS",
"IIGYKAID",
"LIYSTAAL",
"IYSTAALG",
"FSSEIIGY",
"EIIGYKAI",
"SEIIGYKA",
"SSEIIGYK",
"KHTDFSSE",
"YSTAALGV",
"ALGVLMSN",
"SKHTDFSS",
"STAALGVL",
"TAALGVLM",
"AALGVLMS",
"LGVLMSNL",
"GVLMSNLG",
"VCGMWKGY",
"CGMWKGYG",
"NLPGCDGG",
"VMSKHTDF",
"HVMSKHTD",
"VHVMSKHT",
"MSKHTDFS",
"TPVHVMSK",
"PVHVMSKH",
"VIYTSGST",
"STIGVCSM",
"WKGYGCSC",
"MWKGYGCS",
"KGYGCSCD",
"GMWKGYGC",
"YVIYTSGS",
"PMLQSADA",
"GYGCSCDQ",
"YGCSCDQL",
"GCSCDQLR",
"MLQSADAQ",
"CSCDQLRE",
"SCDQLREP",
"EPMLQSAD",
"TIGVCSMT",
"DQLREPML",
"CDQLREPM",
"LQSADAQS",
"REPMLQSA",
"QLREPMLQ",
"LREPMLQS",
"QSADAQSF",
"SADAQSFL",
"ADAQSFLN",
"YKLDGVVC",
"EQFKKGVQ",
"YEQFKKGV",
"VTYKLDGV",
"TYKLDGVV",
"PVTYKLDG",
"SYEQFKKG",
"KPVTYKLD",
"QFKKGVQI",
"VLMSNLGM",
"GMPSYCTG",
"FKKGAKLL",
"KKGAKLLH",
"KGAKLLHK",
"GAKLLHKP",
"AKLLHKPI",
"KLLHKPIV",
"LHKPIVWH",
"HKPIVWHV",
"LLHKPIVW",
"MPSYCTGY",
"LMSNLGMP",
"SNLGMPSY",
"MSNLGMPS",
"LGMPSYCT",
"NLGMPSYC",
"RIELGEIE",
"TIKPVTYK",
"IKPVTYKL",
"TTIKPVTY",
"TLSYEQFK",
"LSYEQFKK",
"YTTTIKPV",
"FKKGVQIP",
"KKGVQIPC",
"GTLSYEQF",
"TTTIKPVT",
"SYTTTIKP",
"KGVQIPCT",
"MGTLSYEQ",
"YMGTLSYE",
"GVQIPCTC",
"VQIPCTCG",
"ESPFVMMS",
"FVMMSAPP",
"HADFDTWF",
"VMMSAPPA",
"NSYTTTIK",
"KPIVWHVN",
"QESPFVMM",
"VQQESPFV",
"SPFVMMSA",
"MSAPPAQY",
"SAPPAQYE",
"MMSAPPAQ",
"QQESPFVM",
"LVQQESPF",
"YLVQQESP",
"APPAQYEL",
"ADFDTWFS",
"PFVMMSAP",
"PIVWHVNN",
"FSQRGGSY",
"IGVCSMTD",
"SQRGGSYT",
"YELKHGTF",
"PPAQYELK",
"ENSYTTTI",
"FDTWFSQR",
"DFDTWFSQ",
"PAQYELKH",
"IVWHVNNA",
"QYELKHGT",
"DTWFSQRG",
"WFSQRGGS",
"QIPCTCGK",
"AQYELKHG",
"VWHVNNAT",
"KENSYTTT",
"ELKHGTFT",
"YKHITSKE",
"QCGHYKHI",
"VFYKENSY",
"LKHGTFTC",
"HITSKETL",
"KHGTFTCA",
"TWFSQRGG",
"KHITSKET",
"ITSKETLY",
"QRGGSYTN",
"PCTCGKQA",
"GNYQCGHY",
"RGGSYTND",
"NYQCGHYK",
"HYKHITSK",
"HGTFTCAS",
"YQCGHYKH",
"TFTCASEY",
"CGHYKHIT",
"GTFTCASE",
"IPCTCGKQ",
"YKENSYTT",
"GHYKHITS",
"TKSSEYKG",
"SKETLYCI",
"CTCGKQAT",
"GSYTNDKA",
"WSTKPVET",
"LLTKSSEY",
"TSKETLYC",
"FYKENSYT",
"LWSTKPVE",
"CLWSTKPV",
"LTKSSEYK",
"GGSYTNDK",
"RCLWSTKP",
"WHVNNATN",
"SYTNDKAC",
"DVFYKENS",
"TDVFYKEN",
"ITDVFYKE",
"IRCLWSTK",
"KSSEYKGP",
"KETLYCID",
"ALLTKSSE",
"TNDKACPL",
"CIRCLWST",
"YTNDKACP",
"SFKKGAKL",
"SSEYKGPI",
"ETLYCIDG",
"YTGNYQCG",
"TGNYQCGH",
"SEYKGPIT",
"ASEYTGNY",
"FTCASEYT",
"GALLTKSS",
"EYKGPITD",
"CASEYTGN",
"EYTGNYQC",
"TLYCIDGA",
"PITDVFYK",
"KGPITDVF",
"GPITDVFY",
"SEYTGNYQ",
"VCSMTDIA",
"LYCIDGAL",
"VYRAFDIY",
"YKGPITDV",
"TCASEYTG",
"HVNNATNK",
"GVCSMTDI",
"YKQFDTYN",
"IDGALLTK",
"YCIDGALL",
"TVFFDGRV",
"LTVFFDGR",
"DGALLTKS",
"VVYRAFDI",
"MYMGTLSY",
"VYKQFDTY",
"CIDGALLT",
"CSMTDIAK",
"PLTVFFDG",
"DVVYRAFD",
"KLDGVVCT",
"SMTDIAKK",
"TDVVYRAF",
"MTDIAKKP",
"VFFDGRVD",
"VNNATNKA",
"STDVVYRA",
"FFDGRVDG",
"YANSVFNI",
"LDGVVCTE",
"TDIAKKPT",
"TSTDVVYR",
"WCIRCLWS",
"KYLVQQES",
"INIIIWFL",
"NIIIWFLL",
"TKYLVQQE",
"QATKYLVQ",
"ATKYLVQQ",
"IIIWFLLL",
"HYTPSFKK",
"YTPSFKKG",
"PSFKKGAK",
"TPSFKKGA",
"DGVVCTEI",
"GTSTDVVY",
"ANSVFNIC",
"NNATNKAT",
"NSVFNICQ",
"SVFNICQA",
"TGTSTDVV",
"KHYTPSFK",
"IIWFLLLS",
"GVVCTEID",
"NKATYKPN",
"CLYRNRDV",
"YRNRDVDT",
"LYRNRDVD",
"TNKATYKP",
"YECLYRNR",
"ECLYRNRD",
"APLTVFFD",
"LYECLYRN",
"TWCIRCLW",
"DIAKKPTE",
"ATNKATYK",
"NATNKATY",
"GKQATKYL",
"KQATKYLV",
"VFNICQAV",
"CGKQATKY",
"FDGRVDGQ",
"YKHYTPSF",
"LINIIIWF",
"TCGKQATK",
"RLYECLYR",
"FNICQAVT",
"HRLYECLY",
"NICQAVTA",
"KLINIIIW",
"TAYANSVF",
"AYANSVFN",
"ICQAVTAN",
"QHRLYECL",
"CQAVTANV",
"TTAYANSV",
"ATTAYANS",
"DGRVDGQV",
"KPNTWCIR",
"PNTWCIRC",
"NTWCIRCL",
"VVCTEIDP",
"YKPNTWCI",
"IAKKPTET",
"QAVTANVN",
"AVTANVNA",
"DATTAYAN",
"AKKPTETI",
"VTANVNAL",
"TYKPNTWC",
"KKPTETIC",
"KATYKPNT",
"ATYKPNTW",
"TANVNALL",
"ANVNALLS",
"ALLSTDGN",
"NALLSTDG",
"NVNALLST",
"VNALLSTD",
"LLSTDGNK",
"RVDGQVDL",
"GRVDGQVD",
"GDATTAYA",
"GQVDLFRN",
"LSTDGNKI",
"QVDLFRNA",
"FSKLINII",
"DGQVDLFR",
"VDGQVDLF",
"STDGNKIA",
"DLFRNARN",
"CAPLTVFF",
"SKLINIII",
"FRNARNGV",
"WVYKQFDT",
"RNARNGVL",
"LFRNARNG",
"LQHRLYEC",
"KPTETICA",
"ETICAPLT",
"VEAHGTGT",
"TICAPLTV",
"GTGTSTDV",
"AARLTPCG",
"ARNGVLIT",
"NARNGVLI",
"VDLFRNAR",
"ICAPLTVF",
"TDGNKIAD",
"NLQHRLYE",
"LTPCGTGT",
"CGTGTSTD",
"DAQSFLNR",
"RNLQHRLY",
"SGDATTAY",
"PTETICAP",
"TETICAPL",
"TPCGTGTS",
"VCTEIDPK",
"RLTPCGTG",
"VRNLQHRL",
"DGNKIADK",
"ARLTPCGT",
"GNKIADKY",
"SSGDATTA",
"PCGTGTST",
"DYKHYTPS",
"YVRNLQHR",
"FLNRVCGV",
"AQSFLNRV",
"TSSGDATT",
"GTSSGDAT",
"SFLNRVCG",
"GGTSSGDA",
"QSFLNRVC",
"KPGGTSSG",
"PGGTSSGD",
"LNRVCGVS",
"NKIADKYV",
"KYVRNLQH",
"KIADKYVR",
"DKYVRNLQ",
"ADKYVRNL",
"LWVYKQFD",
"IADKYVRN",
"QQIELKFN",
"VKPGGTSS",
"YVKPGGTS",
"CGQQQTTL",
"NRVCGVSA",
"LKFNPPAL",
"PKCDRAMP",
"ECAQVLSE",
"RVLNVVCK",
"KCDRAMPN",
"TCGQQQTT",
"NECAQVLS",
"GQQQTTLK",
"KFNPPALQ",
"GVLITEGS",
"NGVLITEG",
"VLITEGSV",
"ELKFNPPA",
"LSEMVMCG",
"LQPSVGPK",
"FYRLANEC",
"LYVKPGGT",
"QQQTTLKG",
"VLNVVCKT",
"QPSVGPKQ",
"RNGVLITE",
"ANECAQVL",
"VLSEMVMC",
"YRLANECA",
"RVCGVSAA",
"RLANECAQ",
"KTCGQQQT",
"LANECAQV",
"IELKFNPP",
"VCGVSAAR",
"AQVLSEMV",
"KRVLNVVC",
"NVVCKTCG",
"QVLSEMVM",
"RFYRLANE",
"CKTCGQQQ",
"CAQVLSEM",
"VVCKTCGQ",
"LNVVCKTC",
"CGVSAARL",
"SLYVKPGG",
"GVSAARLT",
"PSVGPKQA",
"QIELKFNP",
"VCKTCGQQ",
"LDSCKRVL",
"DSCKRVLN",
"KTQFNYYK",
"SCKRVLNV",
"NLDSCKRV",
"CKRVLNVV",
"CDRAMPNM",
"LIGEAVKT",
"QQTTLKGV",
"QTTLKGVE",
"VKTQFNYY",
"IGEAVKTQ",
"NMLRIMAS",
"LRIMASLV",
"RAMPNMLR",
"AMPNMLRI",
"TTLKGVEA",
"LITEGSVK",
"PNMLRIMA",
"DRAMPNML",
"ANLDSCKR",
"TLIGEAVK",
"MPNMLRIM",
"GEAVKTQF",
"LSHRFYRL",
"TQSRNLQE",
"MLRIMASL",
"RIMASLVL",
"GLQPSVGP",
"TLKGVEAV",
"SLVLARKH",
"LKGVEAVM",
"HRFYRLAN",
"SVGPKQAS",
"EAVKTQFN",
"SHRFYRLA",
"HANLDSCK",
"VGPKQASL",
"CSLSHRFY",
"QHANLDSC",
"VMYMGTLS",
"IMASLVLA",
"LFQHANLD",
"NGVTLIGE",
"ASLVLARK",
"SLSHRFYR",
"FQHANLDS",
"TQFNYYKK",
"LVLARKHT",
"ARKHTTCC",
"KGLQPSVG",
"RKHTTCCS",
"MASLVLAR",
"CCSLSHRF",
"KHTTCCSL",
"QFNYYKKV",
"GPKQASLN",
"SSKCVCSV",
"FNYYKKVD",
"NPPALQDA",
"HTTCCSLS",
"NYYKKVDG",
"VKGLQPSV",
"VLARKHTT",
"TMSYLFQH",
"FNPPALQD",
"LNGVTLIG",
"LARKHTTC",
"VSAARLTP",
"ETMSYLFQ",
"RETMSYLF",
"YLFQHANL",
"AVKTQFNY",
"TCCSLSHR",
"VTLIGEAV",
"AVMYMGTL",
"TTCCSLSH",
"MSYLFQHA",
"SYLFQHAN",
"SAARLTPC",
"PKQASLNG",
"ITEGSVKG",
"KGVEAVMY",
"SLNGVTLI",
"GVTLIGEA",
"ASLNGVTL",
"SVKGLQPS",
"QASLNGVT",
"EAVMYMGT",
"TEGSVKGL",
"VEAVMYMG",
"EGSVKGLQ",
"AYYRARAG",
"YRARAGEA",
"GSVKGLQP",
"YYRARAGE",
"GVEAVMYM",
"KQASLNGV",
"YFDCYDGG",
"QDAYYRAR",
"LQDAYYRA",
"YYKKVDGV",
"DAYYRARA",
"ALQDAYYR",
"PALQDAYY",
"PPALQDAY",
"LFVVEVVD",
"GSSKCVCS",
"NLPTMCDI",
"YNLPTMCD",
"DYDYYRYN",
"TMCDIRQL",
"LLFVVEVV",
"CDIRQLLF",
"LPTMCDIR",
"MCDIRQLL",
"DIRQLLFV",
"YYRYNLPT",
"PTMCDIRQ",
"KRTTCFSV",
"YDYYRYNL",
"DKRTTCFS",
"SDYDYYRY",
"LDKRTTCF",
"NVAFQTVK",
"LLDKRTTC",
"QLLFVVEV",
"DYYRYNLP",
"IRQLLFVV",
"RQLLFVVE",
"LLLDKRTT",
"FVVEVVDK",
"YRYNLPTM",
"RYNLPTMC",
"KYFDCYDG",
"NNVAFQTV",
"DKYFDCYD",
"TNNVAFQT",
"QTVKPGNF",
"TVKPGNFN",
"LTNNVAFQ",
"VDKYFDCY",
"FQTVKPGN",
"ALTNNVAF",
"AALTNNVA",
"VAFQTVKP",
"TSGSTGRP",
"VEVVDKYF",
"RTTCFSVA",
"VKPGNFNK",
"PGNFNKDF",
"NFCALILA",
"KPGNFNKD",
"AFQTVKPG",
"VVEVVDKY",
"VAALTNNV",
"TTCFSVAA",
"SVAALTNN",
"LKHFFFAQ",
"FSVAALTN",
"CFSVAALT",
"EVVDKYFD",
"VVDKYFDC",
"SGSTGRPK",
"FFAQDGNA",
"YKKVDGVV",
"FFFAQDGN",
"HFFFAQDG",
"CALILAYC",
"FCALILAY",
"LILAYCNK",
"ALILAYCN",
"KHFFFAQD",
"ISDYDYYR",
"FAQDGNAA",
"TCFSVAAL",
"AISDYDYY",
"AAISDYDY",
"FNKDFYDF",
"NAAISDYD",
"AQDGNAAI",
"NKDFYDFA",
"GNAAISDY",
"KDFYDFAV",
"DFYDFAVS",
"QDGNAAIS",
"DGNAAISD",
"FYDFAVSK",
"QLPETYFT",
"GFFKEGSS",
"YDFAVSKG",
"FFKEGSSV",
"NFNKDFYD",
"DFAVSKGF",
"FAVSKGFF",
"SKGFFKEG",
"KGFFKEGS",
"VSKGFFKE",
"KEGSSVEL",
"GSSVELKH",
"EGSSVELK",
"SSVELKHF",
"FKEGSSVE",
"VELKHFFF",
"SVELKHFF",
"AVSKGFFK",
"ELKHFFFA",
"KLAKKFDT",
"GNFNKDFY",
"KKVDGVVQ",
"KVDGVVQQ",
"LAKKFDTF",
"KFDTFNGE",
"FDTFNGEC",
"PETYFTQS",
"DTFNGECP",
"ETYFTQSR",
"KKFDTFNG",
"AKKFDTFN",
"TFNGECPN",
"VDGVVQQL",
"DGVVQQLP",
"QSRNLQEF",
"VVQQLPET",
"LPETYFTQ",
"GVVQQLPE",
"SLWVYKQF",
"IDYKHYTP",
"LPGCDGGS",
"AIDYKHYT",
"GCINANQV",
"AKKFDIFN",
"KLAKKFDI",
"LAKKFDIF",
"KKFDIFNG",
"FDIFNGEC",
"KFDIFNGE",
"CTEIDPKL",
"FDCYDGGC",
"DIFNGECP",
"IFNGECPN",
"DCYDGGCI",
"QQLPETYF",
"GSTGRPKG",
"VQQLPETY",
"CYDGGCIN",
"YDGGCINA",
"TGSSKCVC",
"VAIDYKHY",
"TEIDPKLD",
"TYFTQSRN",
"DGGCINAN",
"YLGKPREQ",
"FTQSRNLQ",
"CNYLGKPR",
"NYLGKPRE",
"LGKPREQI",
"FSLWVYKQ",
"REQIDGYV",
"GKPREQID",
"KPREQIDG",
"PREQIDGY",
"WDYPKCDR",
"GWDYPKCD",
"GGCINANQ",
"DYPKCDRA",
"MGWDYPKC",
"LMGWDYPK",
"YFTQSRNL",
"TSKFYGGW",
"YPKCDRAM",
"SKFYGGWH",
"KFYGGWHN",
"VVIGTSKF",
"TVVIGTSK",
"HLMGWDYP",
"PHLMGWDY",
"NPHLMGWD",
"VVAIDYKH",
"YGGWHNML",
"FYGGWHNM",
"ELKVTFFP",
"RMYRTGDL",
"ENPHLMGW",
"KKPASREL",
"VENPHLMG",
"ASRELKVT",
"GGWHNMLK",
"SRELKVTF",
"PFNKWGKA",
"FPFNKWGK",
"PASRELKV",
"RELKVTFF",
"GWHNMLKT",
"KPASRELK",
"GFSLWVYK",
"YSDVENPH",
"SDVENPHL",
"DVVAIDYK",
"EIDPKLDN",
"DVENPHLM",
"VYSDVENP",
"YKKPASRE",
"LKTVYSDV",
"GFPFNKWG",
"ARLYYDSM",
"KTVYSDVE",
"AGFPFNKW",
"GDVVAIDY",
"FNKWGKAR",
"TVYSDVEN",
"VIGTSKFY",
"NKWGKARL",
"WHNMLKTV",
"FKFVCDNI",
"KFVCDNIK",
"SAGFPFNK",
"VCDNIKFA",
"MLKTVYSD",
"KARLYYDS",
"NMLKTVYS",
"HNMLKTVY",
"KWGKARLY",
"DNIKFADD",
"FVCDNIKF",
"GTSKFYGG",
"CDNIKFAD",
"GKARLYYD",
"IGTSKFYG",
"NIKFADDL",
"WGKARLYY",
"IKFADDLN",
"KKDNSYFT",
"IDPKLDNY",
"FADDLNQL",
"KSAGFPFN",
"YYKKDNSY",
"ADDLNQLT",
"TFFPDLNG",
"YKKDNSYF",
"LKVTFFPD",
"PFELEDFI",
"FELEDFIP",
"DPKLDNYY",
"DNYYKKDN",
"KFADDLNQ",
"VTFFPDLN",
"NYYKKDNS",
"NFKFVCDN",
"SPFELEDF",
"KDNSYFTE",
"KVTFFPDL",
"LDNYYKKD",
"ESPFELED",
"DKSAGFPF",
"PKLDNYYK",
"LDKSAGFP",
"KLDNYYKK",
"LLIGLAKR",
"GYKKPASR",
"RLYYDSMS",
"ELEDFIPM",
"NLDKSAGF",
"KESPFELE",
"FKESPFEL",
"LIGLAKRF",
"LYYDSMSY",
"LEDFIPMD",
"SRNLQEFK",
"DNSYFTEQ",
"YYDSMSYE",
"NGDVVAID",
"FPDLNGDV",
"FFPDLNGD",
"LTGYKKPA",
"NNLDKSAG",
"YDSMSYED",
"IGLAKRFK",
"DNFKFVCD",
"TGYKKPAS",
"QLTGYKKP",
"PDLNGDVV",
"LNQLTGYK",
"GLAKRFKE",
"NQLTGYKK",
"DSMSYEDQ",
"INANQVIV",
"DFIPMDST",
"VNNLDKSA",
"EDFIPMDS",
"LAKRFKES",
"FDNFKFVC",
"SFDNFKFV",
"DLNQLTGY",
"DDLNQLTG",
"SMSYEDQD",
"DLNGDVVA",
"TVKNYFIT",
"PMDSTVKN",
"IVNNLDKS",
"MDSTVKNY",
"AKRFKESP",
"TEQPIDLV",
"NSYFTEQP",
"ANQVIVNN",
"LNGDVVAI",
"DSTVKNYF",
"RFKESPFE",
"MSYEDQDA",
"KRFKESPF",
"CINANQVI",
"NANQVIVN",
"EQPIDLVP",
"RNLQEFKP",
"FIPMDSTV",
"NQVIVNNL",
"STVKNYFI",
"SYEDQDAL",
"QVIVNNLD",
"FTEQPIDL",
"YFTEQPID",
"VIVNNLDK",
"QPIDLVPN",
"SYFTEQPI",
"IPMDSTVK",
"VIPTITQM",
"PIDLVPNQ",
"NLQEFKPR",
"RTVAGVSI",
"YEDQDALF",
"PTITQMNL",
"QMNLKYAI",
"RNVIPTIT",
"TQMNLKYA",
"NVIPTITQ",
"AGVSICST",
"TKRNVIPT",
"MNLKYAIS",
"NLKYAISA",
"VAGVSICS",
"VKNYFITD",
"TVAGVSIC",
"KYAISAKN",
"IPTITQMN",
"DQDALFAY",
"AISAKNRA",
"QDALFAYT",
"TITQMNLK",
"PGCDGGSL",
"LKYAISAK",
"EDQDALFA",
"YAISAKNR",
"LQEFKPRS",
"KRNVIPTI",
"FAYTKRNV",
"KNYFITDA",
"LFAYTKRN",
"NASFDNFK",
"YTKRNVIP",
"DALFAYTK",
"ARTVAGVS",
"ITQMNLKY",
"ISAKNRAR",
"ASFDNFKF",
"RARTVAGV",
"ALFAYTKR",
"NRARTVAG",
"AYTKRNVI",
"KNRARTVA",
"AKNRARTV",
"GVSICSTM",
"SAKNRART",
"VSICSTMT",
"QEFKPRSQ",
"SICSTMTN",
"RQFHQKLL",
"NYFITDAQ",
"NRQFHQKL",
"ICSTMTNR",
"QTGSSKCV",
"TNRQFHQK",
"ATVVIGTS",
"EFKPRSQM",
"MTNRQFHQ",
"LGGLHLLI",
"GDVRETMS",
"GLHLLIGL",
"LGDVRETM",
"GATVVIGT",
"GGLHLLIG",
"CSTMTNRQ",
"YFITDAQT",
"DVRETMSY",
"QLGGLHLL",
"STMTNRQF",
"VRETMSYL",
"YGDFSHSQ",
"FITDAQTG",
"HSQLGGLH",
"TMTNRQFH",
"LHLLIGLA",
"ELGDVRET",
"SQLGGLHL",
"ITDAQTGS",
"SHSQLGGL",
"TDAQTGSS",
"HLLIGLAK",
"DAQTGSSK",
"FSHSQLGG",
"RGATVVIG",
"DFSHSQLG",
"GDFSHSQL",
"PNASFDNF",
"GELGDVRE",
"AQTGSSKC",
"VGELGDVR",
"TVGELGDV",
"DLVPNQPY",
"KTVGELGD",
"VYGDFSHS",
"TRGATVVI",
"IDLVPNQP",
"IVYGDFSH",
"STGRPKGV",
"NKTVGELG",
"QMEIDFLE",
"HIVYGDFS",
"ILAYCNKT",
"AYCNKTVG",
"CNKTVGEL",
"LAYCNKTV",
"YCNKTVGE",
"RYKLEGYA",
"MEIDFLEL",
"ERYKLEGY",
"IERYKLEG",
"LVPNQPYP",
"FKPRSQME",
"EHIVYGDF",
"EIDFLELA",
"PYPNASFD",
"AGFSLWVY",
"IDFLELAM",
"VPNQPYPN",
"PNQPYPNA",
"YPNASFDN",
"NQPYPNAS",
"FEHIVYGD",
"QPYPNASF",
"AFEHIVYG",
"EFIERYKL",
"YAFEHIVY",
"FLELAMDE",
"DFLELAMD",
"YKLEGYAF",
"FIERYKLE",
"KPRSQMEI",
"GYAFEHIV",
"LELAMDEF",
"DEFIERYK",
"ELAMDEFI",
"MDEFIERY",
"KLEGYAFE",
"EGYAFEHI",
"LEGYAFEH",
"DTACSSSL",
"LAMDEFIE",
"AMDEFIER",
"RSQMEIDF",
"SQMEIDFL",
"PRSQMEID",
"ATRGATVV",
"SAGFSLWV",
"GCDGGSLY",
"ISAGFSLW",
"KHAFHTPA",
"MISAGFSL",
"CDGGSLYV",
"NKHAFHTP",
"AATRGATV",
"VNKHAFHT",
"GGSLYVNK",
"SLYVNKHA",
"MMISAGFS",
"GSLYVNKH",
"LYVNKHAF",
"DGGSLYVN",
"YVNKHAFH",
"GFRIELGE",
"RGFRIELG",
"TACSSSLV",
"LKQLPFFY",
"NLKQLPFF",
"FVNLKQLP",
"GAVCRHHA",
"HAFHTPAF",
"VNLKQLPF",
"GGAVCRHH",
"AFHTPAFD",
"KQLPFFYY",
"VCRHHANE",
"AVCRHHAN",
"FHTPAFDK",
"CRHHANEY",
"AFVNLKQL",
"LGGAVCRH",
"QLPFFYYS",
"RHHANEYR",
"SAFVNLKQ",
"KSAFVNLK",
"HTPAFDKS",
"AFDKSAFV",
"TPAFDKSA",
"DKSAFVNL",
"NMMISAGF",
"CNLGGAVC",
"LPFFYYSD",
"NLGGAVCR",
"PAFDKSAF",
"FDKSAFVN",
"HHANEYRL",
"YNMMISAG",
"PFFYYSDS",
"RCNLGGAV",
"AYNMMISA",
"DAYNMMIS",
"HANEYRLY",
"ITRCNLGG",
"LDAYNMMI",
"CITRCNLG",
"ANEYRLYL",
"LYLDAYNM",
"TRCNLGGA",
"CESHGKQV",
"IAATRGAT",
"YLDAYNMM",
"SIAATRGA",
"NEYRLYLD",
"EYRLYLDA",
"YRLYLDAY",
"QFHQKLLK",*/
};