/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _XWindow_H_
#define _XWindow_H_ "@(#)XWindow.H	1.2\t10/5/92"

#include "XWinExterns.H"

const long maxIntensity = 65535;

class XWindow {
   public:
      XWindow(int,int,const char*,int iscale = 1);
      ~XWindow();

      void newPage();
      // clear screen

      void movePen(int x, int y);
      // move current location

      void drawLine(int x, int y);
      // draw line from current location to this point
      // set current location to this point

      void drawBox(int x1, int y1, int x2, int y2);
      // draw the given rectangle

      int  getMouse(int&, int&);
      // return the button number and position of mouse

      void setLineWidth(int lw);
      // change the linewidth

      void setFont(char*);
      // change the current font

      void putString(int x, int y, const char *str);
      // write a character string at the given location

      void setfgColor(const char*);
      // set the foreground color to the named color

      void setbgColor(const char*);
      // set the background color to the named color

      void setfgColor(int);
      // set the foreground color to this color table entry

      void setbgColor(int);
      // set the background color to this color table entry

      void defineCmap(unsigned short *red, unsigned short *green,
                       unsigned short *blue, int num);
      // add these colors to the current color map

      void flush();
      // flus the XWindow buffer

   private:
      Window          win;
      Display         *display;
      GC              gc;
      XFontStruct     *the_font;
      int             screen;
      int             width, height, scale;
      char            *name;
      int             x0, y0;
      int             nplanes;
      Colormap        cmap;
      unsigned long   *cmap_colors;
      int             num_cmap_colors;
};

#endif
