+++
title = "Prism3"
+++

### Prism3

A prism based on equlateral triangle.

<img src="/img/draw/ff/3d/Prism3.png" width="30%" >
<img src="/img/draw/ff/2d/Prism3_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Prism3_xz.svg" width="30%">

#### Constructor

```python
Prism3(L, H)
```

Parameters:
- L, edge length of the trigonal base
- H, height

#### Usage

As for any other [Form factor](/py/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Prism3" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor is computed as

$$ F(\mathbf{q})=H \space \exp\Big(iq_z\dfrac{H}{2}\Big) \space \text{sinc}\Big(q_z\dfrac{H}{2}\Big) \space F_{||}(\mathbf{q}_{||}) $$

where the form factor $F_{||}(\mathbf{q}_{||}) $ computation is based on the generic form factor of a planar polygon provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{\sqrt3}{4}HL^2. $$

#### Related shapes

More general:
- [Pyramid3](/py/sample/particle/ff/hard/pyramid3), if sides are not vertical.

#### Example

Scattering by uncorrelated, oriented prisms for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/Prism3.png">

Generated by {{% ref-ex "ff/Prism3.py" %}}.

#### History

Has been validated against the "Prism3" form factor of IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.28] and "Prism with three fold symmetry" [[Renaud 2009](/lit/renaud2009), Eq. 219]. Note the different parametrization $L = 2R_{IsGISXAXS}$. In FitGISAXS [[Babonneau 2013](/lit/babonneau2013)] just called "Prism". In BornAgain 1.6, redefined to let the $x$ axis point along a symmetry axis (rotated by $30^{\circ}$ with respect to the previous version).

Reimplemented in BornAgain 1.6 using the generic form factor of a polygonal prism [[Wuttke 2021](/lit/wuttke2021)] to achieve numerical stability near the removable singularity at $q \to 0$.
