+++
title = "Neutron polarization"
weight = 60
+++

## Neutron polarization

BornAgain takes neutron polarization into account
if there is magnetism in the sample model
or if a polarizer is set in the instrument model.

Sample magnetization is explained in
[Sample model > Materials > Magnetization](ref/sample/material/magnetization).

Beam polarization is set through
```python
polarizer_dir = R3(x, y, z)
beam.setPolarization(polarizer_dir) # for scattering
scan.setPolarization(polarizer_dir) # for specular and offspec
```
The `polarizer_dir` is a Bloch vector, created by the constructor
```
```
If it is a unit vector, then the beam polarization is perfect.
A shorter vector indicates imperfect polarization.

The analyzer properties are through
```python
analyzer_dir = R3(x, y, z)
detector.setAnalyzer(analyzer_dir, efficiency, transmission)  # for scattering
scan.setAnalyzer(analyzer_dir, efficiency, transmission)  # for specular and offspec
```
The first argument is a unit vector that specifies the direction of the analyzer.
The second argument is a number between 0 and 1 that specifies the analyzer efficiency.
The third argument is a number between 0 and 0.5
that specifies the transmission of the analyzer for an unpolarized beam.
The maximum value of $0.5$ corresponds to a perfect analyzer
as half of an unpolarized incoming beam is not transmitted.

Examples are under [Examples > Instrument > Polarization](/ex/instr/pol).

Examples to be moved:
{{% children  %}}
