//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobListView.h
//! @brief     Defines class JobListView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBLISTVIEW_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBLISTVIEW_H

#include "GUI/Model/Job/JobItem.h"
#include <QAction>
#include <QListView>
#include <QMenu>
#include <QWidget>

class JobModel;
class JobItem;
class JobListModel;
class JobListViewDelegate;

//! List of jobs on the top left side of JobView.

class JobListView : public QWidget {
    Q_OBJECT

public:
    JobListView(JobModel* jobs, QWidget* parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags());
    QVector<JobItem*> selectedJobItems() const;
    void selectJob(JobItem* job);

signals:
    void selectedJobsChanged(const QVector<JobItem*>& jobs);

private slots:
    void onItemSelectionChanged();
    void onJobListModelDataChanged(const QModelIndex& topLeft, const QModelIndex& bottomRight);
    void onRun();
    void onCancel();
    void onRemove();
    void equalizeSelectedToJob(JobItem* job);
    void showContextMenu(const QPoint& pos);

private:
    void updateActions();
    void ensureItemSelected(int lastSelectedRow = -1);
    void restoreSelection();

private:
    QListView* m_listView;
    JobListViewDelegate* m_listViewDelegate;
    JobListModel* m_model;
    QAction* m_runAction;
    QAction* m_cancelAction;
    QAction* m_removeAction;
    QMenu* m_equalizeMenu;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBLISTVIEW_H
