//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/DepthprobeInstrumentEditor.cpp
//! @brief     Implements class DepthprobeInstrumentEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Instrument/DepthprobeInstrumentEditor.h"
#include "GUI/Model/Device/InstrumentItems.h"
#include "GUI/View/Device/AxisPropertyForm.h"
#include "GUI/View/Instrument/ScanEditor.h"
#include <QVBoxLayout>

DepthprobeInstrumentEditor::DepthprobeInstrumentEditor(QWidget* parent,
                                                       DepthprobeInstrumentItem* instrument,
                                                       MultiInstrumentNotifier* ec)
    : QWidget(parent)
    , m_ec(ec, instrument)
{
    ASSERT(instrument);
    auto* layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);

    auto* scanEditor = new ScanEditor(this, instrument->scanItem(), &m_ec);
    layout->addWidget(scanEditor);

    auto* depthAxisEditor = new AxisPropertyForm(this, "Depth axis", &instrument->zAxis(),
                                                 "Number of points in scan across sample bulk");
    layout->addWidget(depthAxisEditor);

    layout->addStretch();

    connect(scanEditor, &ScanEditor::dataChanged, this, &DepthprobeInstrumentEditor::dataChanged);
    connect(depthAxisEditor, &AxisPropertyForm::dataChanged, this,
            &DepthprobeInstrumentEditor::dataChanged);
}
